["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/stream/GenericWorker.js"],"~:js","shadow$provide[157]=function(ra,X,Ra,P){function w(Z){this.name=Z||\"default\";this.streamInfo={};this.generatedError=null;this.extraStreamInfo={};this.isPaused=!0;this.isLocked=this.isFinished=!1;this._listeners={data:[],end:[],error:[]};this.previous=null}w.prototype={push:function(Z){this.emit(\"data\",Z)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit(\"end\"),this.cleanUp(),this.isFinished=!0}catch(Z){this.emit(\"error\",Z)}return!0},error:function(Z){if(this.isFinished)return!1;\nthis.isPaused?this.generatedError=Z:(this.isFinished=!0,this.emit(\"error\",Z),this.previous&&this.previous.error(Z),this.cleanUp());return!0},on:function(Z,B){this._listeners[Z].push(B);return this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null;this._listeners=[]},emit:function(Z,B){if(this._listeners[Z])for(var p=0;p<this._listeners[Z].length;p++)this._listeners[Z][p].call(this,B)},pipe:function(Z){return Z.registerPrevious(this)},registerPrevious:function(Z){if(this.isLocked)throw Error(\"The stream '\"+\nthis+\"' has already been used.\");this.streamInfo=Z.streamInfo;this.mergeStreamInfo();this.previous=Z;var B=this;Z.on(\"data\",function(p){B.processChunk(p)});Z.on(\"end\",function(){B.end()});Z.on(\"error\",function(p){B.error(p)});return this},pause:function(){if(this.isPaused||this.isFinished)return!1;this.isPaused=!0;this.previous&&this.previous.pause();return!0},resume:function(){if(!this.isPaused||this.isFinished)return!1;var Z=this.isPaused=!1;this.generatedError&&(this.error(this.generatedError),\nZ=!0);this.previous&&this.previous.resume();return!Z},flush:function(){},processChunk:function(Z){this.push(Z)},withStreamInfo:function(Z,B){this.extraStreamInfo[Z]=B;this.mergeStreamInfo();return this},mergeStreamInfo:function(){for(var Z in this.extraStreamInfo)this.extraStreamInfo.hasOwnProperty(Z)&&(this.streamInfo[Z]=this.extraStreamInfo[Z])},lock:function(){if(this.isLocked)throw Error(\"The stream '\"+this+\"' has already been used.\");this.isLocked=!0;this.previous&&this.previous.lock()},toString:function(){var Z=\n\"Worker \"+this.name;return this.previous?this.previous+\" -\\x3e \"+Z:Z}};Ra.exports=w}","~:source","shadow$provide[157] = function(global,require,module,exports) {\n'use strict';\n\n/**\n * A worker that does nothing but passing chunks to the next one. This is like\n * a nodejs stream but with some differences. On the good side :\n * - it works on IE 6-9 without any issue / polyfill\n * - it weights less than the full dependencies bundled with browserify\n * - it forwards errors (no need to declare an error handler EVERYWHERE)\n *\n * A chunk is an object with 2 attributes : `meta` and `data`. The former is an\n * object containing anything (`percent` for example), see each worker for more\n * details. The latter is the real data (String, Uint8Array, etc).\n *\n * @constructor\n * @param {String} name the name of the stream (mainly used for debugging purposes)\n */\nfunction GenericWorker(name) {\n    // the name of the worker\n    this.name = name || \"default\";\n    // an object containing metadata about the workers chain\n    this.streamInfo = {};\n    // an error which happened when the worker was paused\n    this.generatedError = null;\n    // an object containing metadata to be merged by this worker into the general metadata\n    this.extraStreamInfo = {};\n    // true if the stream is paused (and should not do anything), false otherwise\n    this.isPaused = true;\n    // true if the stream is finished (and should not do anything), false otherwise\n    this.isFinished = false;\n    // true if the stream is locked to prevent further structure updates (pipe), false otherwise\n    this.isLocked = false;\n    // the event listeners\n    this._listeners = {\n        'data':[],\n        'end':[],\n        'error':[]\n    };\n    // the previous worker, if any\n    this.previous = null;\n}\n\nGenericWorker.prototype = {\n    /**\n     * Push a chunk to the next workers.\n     * @param {Object} chunk the chunk to push\n     */\n    push : function (chunk) {\n        this.emit(\"data\", chunk);\n    },\n    /**\n     * End the stream.\n     * @return {Boolean} true if this call ended the worker, false otherwise.\n     */\n    end : function () {\n        if (this.isFinished) {\n            return false;\n        }\n\n        this.flush();\n        try {\n            this.emit(\"end\");\n            this.cleanUp();\n            this.isFinished = true;\n        } catch (e) {\n            this.emit(\"error\", e);\n        }\n        return true;\n    },\n    /**\n     * End the stream with an error.\n     * @param {Error} e the error which caused the premature end.\n     * @return {Boolean} true if this call ended the worker with an error, false otherwise.\n     */\n    error : function (e) {\n        if (this.isFinished) {\n            return false;\n        }\n\n        if(this.isPaused) {\n            this.generatedError = e;\n        } else {\n            this.isFinished = true;\n\n            this.emit(\"error\", e);\n\n            // in the workers chain exploded in the middle of the chain,\n            // the error event will go downward but we also need to notify\n            // workers upward that there has been an error.\n            if(this.previous) {\n                this.previous.error(e);\n            }\n\n            this.cleanUp();\n        }\n        return true;\n    },\n    /**\n     * Add a callback on an event.\n     * @param {String} name the name of the event (data, end, error)\n     * @param {Function} listener the function to call when the event is triggered\n     * @return {GenericWorker} the current object for chainability\n     */\n    on : function (name, listener) {\n        this._listeners[name].push(listener);\n        return this;\n    },\n    /**\n     * Clean any references when a worker is ending.\n     */\n    cleanUp : function () {\n        this.streamInfo = this.generatedError = this.extraStreamInfo = null;\n        this._listeners = [];\n    },\n    /**\n     * Trigger an event. This will call registered callback with the provided arg.\n     * @param {String} name the name of the event (data, end, error)\n     * @param {Object} arg the argument to call the callback with.\n     */\n    emit : function (name, arg) {\n        if (this._listeners[name]) {\n            for(var i = 0; i < this._listeners[name].length; i++) {\n                this._listeners[name][i].call(this, arg);\n            }\n        }\n    },\n    /**\n     * Chain a worker with an other.\n     * @param {Worker} next the worker receiving events from the current one.\n     * @return {worker} the next worker for chainability\n     */\n    pipe : function (next) {\n        return next.registerPrevious(this);\n    },\n    /**\n     * Same as `pipe` in the other direction.\n     * Using an API with `pipe(next)` is very easy.\n     * Implementing the API with the point of view of the next one registering\n     * a source is easier, see the ZipFileWorker.\n     * @param {Worker} previous the previous worker, sending events to this one\n     * @return {Worker} the current worker for chainability\n     */\n    registerPrevious : function (previous) {\n        if (this.isLocked) {\n            throw new Error(\"The stream '\" + this + \"' has already been used.\");\n        }\n\n        // sharing the streamInfo...\n        this.streamInfo = previous.streamInfo;\n        // ... and adding our own bits\n        this.mergeStreamInfo();\n        this.previous =  previous;\n        var self = this;\n        previous.on('data', function (chunk) {\n            self.processChunk(chunk);\n        });\n        previous.on('end', function () {\n            self.end();\n        });\n        previous.on('error', function (e) {\n            self.error(e);\n        });\n        return this;\n    },\n    /**\n     * Pause the stream so it doesn't send events anymore.\n     * @return {Boolean} true if this call paused the worker, false otherwise.\n     */\n    pause : function () {\n        if(this.isPaused || this.isFinished) {\n            return false;\n        }\n        this.isPaused = true;\n\n        if(this.previous) {\n            this.previous.pause();\n        }\n        return true;\n    },\n    /**\n     * Resume a paused stream.\n     * @return {Boolean} true if this call resumed the worker, false otherwise.\n     */\n    resume : function () {\n        if(!this.isPaused || this.isFinished) {\n            return false;\n        }\n        this.isPaused = false;\n\n        // if true, the worker tried to resume but failed\n        var withError = false;\n        if(this.generatedError) {\n            this.error(this.generatedError);\n            withError = true;\n        }\n        if(this.previous) {\n            this.previous.resume();\n        }\n\n        return !withError;\n    },\n    /**\n     * Flush any remaining bytes as the stream is ending.\n     */\n    flush : function () {},\n    /**\n     * Process a chunk. This is usually the method overridden.\n     * @param {Object} chunk the chunk to process.\n     */\n    processChunk : function(chunk) {\n        this.push(chunk);\n    },\n    /**\n     * Add a key/value to be added in the workers chain streamInfo once activated.\n     * @param {String} key the key to use\n     * @param {Object} value the associated value\n     * @return {Worker} the current worker for chainability\n     */\n    withStreamInfo : function (key, value) {\n        this.extraStreamInfo[key] = value;\n        this.mergeStreamInfo();\n        return this;\n    },\n    /**\n     * Merge this worker's streamInfo into the chain's streamInfo.\n     */\n    mergeStreamInfo : function () {\n        for(var key in this.extraStreamInfo) {\n            if (!this.extraStreamInfo.hasOwnProperty(key)) {\n                continue;\n            }\n            this.streamInfo[key] = this.extraStreamInfo[key];\n        }\n    },\n\n    /**\n     * Lock the stream to prevent further updates on the workers chain.\n     * After calling this method, all calls to pipe will fail.\n     */\n    lock: function () {\n        if (this.isLocked) {\n            throw new Error(\"The stream '\" + this + \"' has already been used.\");\n        }\n        this.isLocked = true;\n        if (this.previous) {\n            this.previous.lock();\n        }\n    },\n\n    /**\n     *\n     * Pretty print the workers chain.\n     */\n    toString : function () {\n        var me = \"Worker \" + this.name;\n        if (this.previous) {\n            return this.previous + \" -> \" + me;\n        } else {\n            return me;\n        }\n    }\n};\n\nmodule.exports = GenericWorker;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js"]],"~:properties",["^5",["generatedError","isLocked","cleanUp","streamInfo","prototype","error","flush","toString","push","processChunk","name","registerPrevious","previous","extraStreamInfo","emit","pause","_listeners","pipe","on","isPaused","lock","withStreamInfo","end","resume","mergeStreamInfo","isFinished"]],"~:compiled-at",1766065009555,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$stream$GenericWorker.js\",\n\"lineCount\":5,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAiB9DC,QAASA,EAAa,CAACC,CAAD,CAAO,CAEzB,IAAKA,CAAAA,IAAL,CAAYA,CAAZ,EAAoB,SAEpB,KAAKC,CAAAA,UAAL,CAAkB,EAElB,KAAKC,CAAAA,cAAL,CAAsB,IAEtB,KAAKC,CAAAA,eAAL,CAAuB,EAEvB,KAAKC,CAAAA,QAAL,CAAgB,CAAA,CAIhB,KAAKC,CAAAA,QAAL,CAFA,IAAKC,CAAAA,UAEL,CAFkB,CAAA,CAIlB,KAAKC,CAAAA,UAAL,CAAkB,CACd,KAAO,EADO,CAEd,IAAM,EAFQ,CAGd,MAAQ,EAHM,CAMlB,KAAKC,CAAAA,QAAL,CAAgB,IAtBS,CAyB7BT,CAAcU,CAAAA,SAAd,CAA0B,CAKtBC,KAAOA,QAAS,CAACC,CAAD,CAAQ,CACpB,IAAKC,CAAAA,IAAL,CAAU,MAAV,CAAkBD,CAAlB,CADoB,CALF,CAYtBE,IAAMA,QAAS,EAAG,CACd,GAAI,IAAKP,CAAAA,UAAT,CACI,MAAO,CAAA,CAGX,KAAKQ,CAAAA,KAAL,EACA,IAAI,CACA,IAAKF,CAAAA,IAAL,CAAU,KAAV,CAEA,CADA,IAAKG,CAAAA,OAAL,EACA,CAAA,IAAKT,CAAAA,UAAL,CAAkB,CAAA,CAHlB,CAIF,MAAOU,CAAP,CAAU,CACR,IAAKJ,CAAAA,IAAL,CAAU,OAAV,CAAmBI,CAAnB,CADQ,CAGZ,MAAO,CAAA,CAbO,CAZI,CAgCtBC,MAAQA,QAAS,CAACD,CAAD,CAAI,CACjB,GAAI,IAAKV,CAAAA,UAAT,CACI,MAAO,CAAA,CAGR;IAAKF,CAAAA,QAAR,CACI,IAAKF,CAAAA,cADT,CAC0Bc,CAD1B,EAGI,IAAKV,CAAAA,UAWL,CAXkB,CAAA,CAWlB,CATA,IAAKM,CAAAA,IAAL,CAAU,OAAV,CAAmBI,CAAnB,CASA,CAJG,IAAKR,CAAAA,QAIR,EAHI,IAAKA,CAAAA,QAASS,CAAAA,KAAd,CAAoBD,CAApB,CAGJ,CAAA,IAAKD,CAAAA,OAAL,EAdJ,CAgBA,OAAO,CAAA,CArBU,CAhCC,CA6DtBG,GAAKA,QAAS,CAAClB,CAAD,CAAOmB,CAAP,CAAiB,CAC3B,IAAKZ,CAAAA,UAAL,CAAgBP,CAAhB,CAAsBU,CAAAA,IAAtB,CAA2BS,CAA3B,CACA,OAAO,KAFoB,CA7DT,CAoEtBJ,QAAUA,QAAS,EAAG,CAClB,IAAKd,CAAAA,UAAL,CAAkB,IAAKC,CAAAA,cAAvB,CAAwC,IAAKC,CAAAA,eAA7C,CAA+D,IAC/D,KAAKI,CAAAA,UAAL,CAAkB,EAFA,CApEA,CA6EtBK,KAAOA,QAAS,CAACZ,CAAD,CAAOoB,CAAP,CAAY,CACxB,GAAI,IAAKb,CAAAA,UAAL,CAAgBP,CAAhB,CAAJ,CACI,IAAI,IAAIqB,EAAI,CAAZ,CAAeA,CAAf,CAAmB,IAAKd,CAAAA,UAAL,CAAgBP,CAAhB,CAAsBsB,CAAAA,MAAzC,CAAiDD,CAAA,EAAjD,CACI,IAAKd,CAAAA,UAAL,CAAgBP,CAAhB,CAAA,CAAsBqB,CAAtB,CAAyBE,CAAAA,IAAzB,CAA8B,IAA9B,CAAoCH,CAApC,CAHgB,CA7EN,CAyFtBI,KAAOA,QAAS,CAACC,CAAD,CAAO,CACnB,MAAOA,EAAKC,CAAAA,gBAAL,CAAsB,IAAtB,CADY,CAzFD,CAoGtBA,iBAAmBA,QAAS,CAAClB,CAAD,CAAW,CACnC,GAAI,IAAKH,CAAAA,QAAT,CACI,KAAUsB,MAAJ,CAAU,cAAV;AAA2B,IAA3B,CAAkC,0BAAlC,CAAN,CAIJ,IAAK1B,CAAAA,UAAL,CAAkBO,CAASP,CAAAA,UAE3B,KAAK2B,CAAAA,eAAL,EACA,KAAKpB,CAAAA,QAAL,CAAiBA,CACjB,KAAIqB,EAAO,IACXrB,EAASU,CAAAA,EAAT,CAAY,MAAZ,CAAoB,QAAS,CAACP,CAAD,CAAQ,CACjCkB,CAAKC,CAAAA,YAAL,CAAkBnB,CAAlB,CADiC,CAArC,CAGAH,EAASU,CAAAA,EAAT,CAAY,KAAZ,CAAmB,QAAS,EAAG,CAC3BW,CAAKhB,CAAAA,GAAL,EAD2B,CAA/B,CAGAL,EAASU,CAAAA,EAAT,CAAY,OAAZ,CAAqB,QAAS,CAACF,CAAD,CAAI,CAC9Ba,CAAKZ,CAAAA,KAAL,CAAWD,CAAX,CAD8B,CAAlC,CAGA,OAAO,KApB4B,CApGjB,CA8HtBe,MAAQA,QAAS,EAAG,CAChB,GAAG,IAAK3B,CAAAA,QAAR,EAAoB,IAAKE,CAAAA,UAAzB,CACI,MAAO,CAAA,CAEX,KAAKF,CAAAA,QAAL,CAAgB,CAAA,CAEb,KAAKI,CAAAA,QAAR,EACI,IAAKA,CAAAA,QAASuB,CAAAA,KAAd,EAEJ,OAAO,CAAA,CATS,CA9HE,CA6ItBC,OAASA,QAAS,EAAG,CACjB,GAAG,CAAC,IAAK5B,CAAAA,QAAT,EAAqB,IAAKE,CAAAA,UAA1B,CACI,MAAO,CAAA,CAKX,KAAI2B,EAHJ,IAAK7B,CAAAA,QAGD6B,CAHY,CAAA,CAIb,KAAK/B,CAAAA,cAAR,GACI,IAAKe,CAAAA,KAAL,CAAW,IAAKf,CAAAA,cAAhB,CACA;AAAA+B,CAAA,CAAY,CAAA,CAFhB,CAIG,KAAKzB,CAAAA,QAAR,EACI,IAAKA,CAAAA,QAASwB,CAAAA,MAAd,EAGJ,OAAO,CAACC,CAhBS,CA7IC,CAkKtBnB,MAAQA,QAAS,EAAG,EAlKE,CAuKtBgB,aAAeA,QAAQ,CAACnB,CAAD,CAAQ,CAC3B,IAAKD,CAAAA,IAAL,CAAUC,CAAV,CAD2B,CAvKT,CAgLtBuB,eAAiBA,QAAS,CAACC,CAAD,CAAMC,CAAN,CAAa,CACnC,IAAKjC,CAAAA,eAAL,CAAqBgC,CAArB,CAAA,CAA4BC,CAC5B,KAAKR,CAAAA,eAAL,EACA,OAAO,KAH4B,CAhLjB,CAwLtBA,gBAAkBA,QAAS,EAAG,CAC1B,IAAIO,IAAIA,CAAR,GAAe,KAAKhC,CAAAA,eAApB,CACS,IAAKA,CAAAA,eAAgBkC,CAAAA,cAArB,CAAoCF,CAApC,CAAL,GAGA,IAAKlC,CAAAA,UAAL,CAAgBkC,CAAhB,CAHA,CAGuB,IAAKhC,CAAAA,eAAL,CAAqBgC,CAArB,CAHvB,CAFsB,CAxLR,CAqMtBG,KAAMA,QAAS,EAAG,CACd,GAAI,IAAKjC,CAAAA,QAAT,CACI,KAAUsB,MAAJ,CAAU,cAAV,CAA2B,IAA3B,CAAkC,0BAAlC,CAAN,CAEJ,IAAKtB,CAAAA,QAAL,CAAgB,CAAA,CACZ,KAAKG,CAAAA,QAAT,EACI,IAAKA,CAAAA,QAAS8B,CAAAA,IAAd,EANU,CArMI,CAmNtBC,SAAWA,QAAS,EAAG,CACnB,IAAIC;AAAK,SAALA,CAAiB,IAAKxC,CAAAA,IAC1B,OAAI,KAAKQ,CAAAA,QAAT,CACW,IAAKA,CAAAA,QADhB,CAC2B,SAD3B,CACoCgC,CADpC,CAGWA,CALQ,CAnND,CA6N1B3C,GAAOC,CAAAA,OAAP,CAAiBC,CAvQ6C;\",\n\"sources\":[\"node_modules/jszip/lib/stream/GenericWorker.js\"],\n\"sourcesContent\":[\"shadow$provide[157] = function(global,require,module,exports) {\\n'use strict';\\n\\n/**\\n * A worker that does nothing but passing chunks to the next one. This is like\\n * a nodejs stream but with some differences. On the good side :\\n * - it works on IE 6-9 without any issue / polyfill\\n * - it weights less than the full dependencies bundled with browserify\\n * - it forwards errors (no need to declare an error handler EVERYWHERE)\\n *\\n * A chunk is an object with 2 attributes : `meta` and `data`. The former is an\\n * object containing anything (`percent` for example), see each worker for more\\n * details. The latter is the real data (String, Uint8Array, etc).\\n *\\n * @constructor\\n * @param {String} name the name of the stream (mainly used for debugging purposes)\\n */\\nfunction GenericWorker(name) {\\n    // the name of the worker\\n    this.name = name || \\\"default\\\";\\n    // an object containing metadata about the workers chain\\n    this.streamInfo = {};\\n    // an error which happened when the worker was paused\\n    this.generatedError = null;\\n    // an object containing metadata to be merged by this worker into the general metadata\\n    this.extraStreamInfo = {};\\n    // true if the stream is paused (and should not do anything), false otherwise\\n    this.isPaused = true;\\n    // true if the stream is finished (and should not do anything), false otherwise\\n    this.isFinished = false;\\n    // true if the stream is locked to prevent further structure updates (pipe), false otherwise\\n    this.isLocked = false;\\n    // the event listeners\\n    this._listeners = {\\n        'data':[],\\n        'end':[],\\n        'error':[]\\n    };\\n    // the previous worker, if any\\n    this.previous = null;\\n}\\n\\nGenericWorker.prototype = {\\n    /**\\n     * Push a chunk to the next workers.\\n     * @param {Object} chunk the chunk to push\\n     */\\n    push : function (chunk) {\\n        this.emit(\\\"data\\\", chunk);\\n    },\\n    /**\\n     * End the stream.\\n     * @return {Boolean} true if this call ended the worker, false otherwise.\\n     */\\n    end : function () {\\n        if (this.isFinished) {\\n            return false;\\n        }\\n\\n        this.flush();\\n        try {\\n            this.emit(\\\"end\\\");\\n            this.cleanUp();\\n            this.isFinished = true;\\n        } catch (e) {\\n            this.emit(\\\"error\\\", e);\\n        }\\n        return true;\\n    },\\n    /**\\n     * End the stream with an error.\\n     * @param {Error} e the error which caused the premature end.\\n     * @return {Boolean} true if this call ended the worker with an error, false otherwise.\\n     */\\n    error : function (e) {\\n        if (this.isFinished) {\\n            return false;\\n        }\\n\\n        if(this.isPaused) {\\n            this.generatedError = e;\\n        } else {\\n            this.isFinished = true;\\n\\n            this.emit(\\\"error\\\", e);\\n\\n            // in the workers chain exploded in the middle of the chain,\\n            // the error event will go downward but we also need to notify\\n            // workers upward that there has been an error.\\n            if(this.previous) {\\n                this.previous.error(e);\\n            }\\n\\n            this.cleanUp();\\n        }\\n        return true;\\n    },\\n    /**\\n     * Add a callback on an event.\\n     * @param {String} name the name of the event (data, end, error)\\n     * @param {Function} listener the function to call when the event is triggered\\n     * @return {GenericWorker} the current object for chainability\\n     */\\n    on : function (name, listener) {\\n        this._listeners[name].push(listener);\\n        return this;\\n    },\\n    /**\\n     * Clean any references when a worker is ending.\\n     */\\n    cleanUp : function () {\\n        this.streamInfo = this.generatedError = this.extraStreamInfo = null;\\n        this._listeners = [];\\n    },\\n    /**\\n     * Trigger an event. This will call registered callback with the provided arg.\\n     * @param {String} name the name of the event (data, end, error)\\n     * @param {Object} arg the argument to call the callback with.\\n     */\\n    emit : function (name, arg) {\\n        if (this._listeners[name]) {\\n            for(var i = 0; i < this._listeners[name].length; i++) {\\n                this._listeners[name][i].call(this, arg);\\n            }\\n        }\\n    },\\n    /**\\n     * Chain a worker with an other.\\n     * @param {Worker} next the worker receiving events from the current one.\\n     * @return {worker} the next worker for chainability\\n     */\\n    pipe : function (next) {\\n        return next.registerPrevious(this);\\n    },\\n    /**\\n     * Same as `pipe` in the other direction.\\n     * Using an API with `pipe(next)` is very easy.\\n     * Implementing the API with the point of view of the next one registering\\n     * a source is easier, see the ZipFileWorker.\\n     * @param {Worker} previous the previous worker, sending events to this one\\n     * @return {Worker} the current worker for chainability\\n     */\\n    registerPrevious : function (previous) {\\n        if (this.isLocked) {\\n            throw new Error(\\\"The stream '\\\" + this + \\\"' has already been used.\\\");\\n        }\\n\\n        // sharing the streamInfo...\\n        this.streamInfo = previous.streamInfo;\\n        // ... and adding our own bits\\n        this.mergeStreamInfo();\\n        this.previous =  previous;\\n        var self = this;\\n        previous.on('data', function (chunk) {\\n            self.processChunk(chunk);\\n        });\\n        previous.on('end', function () {\\n            self.end();\\n        });\\n        previous.on('error', function (e) {\\n            self.error(e);\\n        });\\n        return this;\\n    },\\n    /**\\n     * Pause the stream so it doesn't send events anymore.\\n     * @return {Boolean} true if this call paused the worker, false otherwise.\\n     */\\n    pause : function () {\\n        if(this.isPaused || this.isFinished) {\\n            return false;\\n        }\\n        this.isPaused = true;\\n\\n        if(this.previous) {\\n            this.previous.pause();\\n        }\\n        return true;\\n    },\\n    /**\\n     * Resume a paused stream.\\n     * @return {Boolean} true if this call resumed the worker, false otherwise.\\n     */\\n    resume : function () {\\n        if(!this.isPaused || this.isFinished) {\\n            return false;\\n        }\\n        this.isPaused = false;\\n\\n        // if true, the worker tried to resume but failed\\n        var withError = false;\\n        if(this.generatedError) {\\n            this.error(this.generatedError);\\n            withError = true;\\n        }\\n        if(this.previous) {\\n            this.previous.resume();\\n        }\\n\\n        return !withError;\\n    },\\n    /**\\n     * Flush any remaining bytes as the stream is ending.\\n     */\\n    flush : function () {},\\n    /**\\n     * Process a chunk. This is usually the method overridden.\\n     * @param {Object} chunk the chunk to process.\\n     */\\n    processChunk : function(chunk) {\\n        this.push(chunk);\\n    },\\n    /**\\n     * Add a key/value to be added in the workers chain streamInfo once activated.\\n     * @param {String} key the key to use\\n     * @param {Object} value the associated value\\n     * @return {Worker} the current worker for chainability\\n     */\\n    withStreamInfo : function (key, value) {\\n        this.extraStreamInfo[key] = value;\\n        this.mergeStreamInfo();\\n        return this;\\n    },\\n    /**\\n     * Merge this worker's streamInfo into the chain's streamInfo.\\n     */\\n    mergeStreamInfo : function () {\\n        for(var key in this.extraStreamInfo) {\\n            if (!this.extraStreamInfo.hasOwnProperty(key)) {\\n                continue;\\n            }\\n            this.streamInfo[key] = this.extraStreamInfo[key];\\n        }\\n    },\\n\\n    /**\\n     * Lock the stream to prevent further updates on the workers chain.\\n     * After calling this method, all calls to pipe will fail.\\n     */\\n    lock: function () {\\n        if (this.isLocked) {\\n            throw new Error(\\\"The stream '\\\" + this + \\\"' has already been used.\\\");\\n        }\\n        this.isLocked = true;\\n        if (this.previous) {\\n            this.previous.lock();\\n        }\\n    },\\n\\n    /**\\n     *\\n     * Pretty print the workers chain.\\n     */\\n    toString : function () {\\n        var me = \\\"Worker \\\" + this.name;\\n        if (this.previous) {\\n            return this.previous + \\\" -> \\\" + me;\\n        } else {\\n            return me;\\n        }\\n    }\\n};\\n\\nmodule.exports = GenericWorker;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"GenericWorker\",\"name\",\"streamInfo\",\"generatedError\",\"extraStreamInfo\",\"isPaused\",\"isLocked\",\"isFinished\",\"_listeners\",\"previous\",\"prototype\",\"push\",\"chunk\",\"emit\",\"end\",\"flush\",\"cleanUp\",\"e\",\"error\",\"on\",\"listener\",\"arg\",\"i\",\"length\",\"call\",\"pipe\",\"next\",\"registerPrevious\",\"Error\",\"mergeStreamInfo\",\"self\",\"processChunk\",\"pause\",\"resume\",\"withError\",\"withStreamInfo\",\"key\",\"value\",\"hasOwnProperty\",\"lock\",\"toString\",\"me\"]\n}\n"]