["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/stream/DataWorker.js"],"~:js","shadow$provide[163]=function(ra,X,Ra,P){function w(p){B.call(this,\"DataWorker\");var c=this;this.dataIsReady=!1;this.max=this.index=0;this.data=null;this.type=\"\";this._tickScheduled=!1;p.then(function(u){c.dataIsReady=!0;c.data=u;c.max=u&&u.length||0;c.type=Z.getTypeOf(u);c.isPaused||c._tickAndRepeat()},function(u){c.error(u)})}var Z=X(156),B=X(157);Z.inherits(w,B);w.prototype.cleanUp=function(){B.prototype.cleanUp.call(this);this.data=null};w.prototype.resume=function(){if(!B.prototype.resume.call(this))return!1;\n!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,Z.delay(this._tickAndRepeat,[],this));return!0};w.prototype._tickAndRepeat=function(){this._tickScheduled=!1;this.isPaused||this.isFinished||(this._tick(),this.isFinished||(Z.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))};w.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var p=null,c=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case \"string\":p=this.data.substring(this.index,\nc);break;case \"uint8array\":p=this.data.subarray(this.index,c);break;case \"array\":case \"nodebuffer\":p=this.data.slice(this.index,c)}this.index=c;return this.push({data:p,meta:{percent:this.max?this.index/this.max*100:0}})};Ra.exports=w}","~:source","shadow$provide[163] = function(global,require,module,exports) {\n'use strict';\n\nvar utils = require('../utils');\nvar GenericWorker = require('./GenericWorker');\n\n// the size of the generated chunks\n// TODO expose this as a public variable\nvar DEFAULT_BLOCK_SIZE = 16 * 1024;\n\n/**\n * A worker that reads a content and emits chunks.\n * @constructor\n * @param {Promise} dataP the promise of the data to split\n */\nfunction DataWorker(dataP) {\n    GenericWorker.call(this, \"DataWorker\");\n    var self = this;\n    this.dataIsReady = false;\n    this.index = 0;\n    this.max = 0;\n    this.data = null;\n    this.type = \"\";\n\n    this._tickScheduled = false;\n\n    dataP.then(function (data) {\n        self.dataIsReady = true;\n        self.data = data;\n        self.max = data && data.length || 0;\n        self.type = utils.getTypeOf(data);\n        if(!self.isPaused) {\n            self._tickAndRepeat();\n        }\n    }, function (e) {\n        self.error(e);\n    });\n}\n\nutils.inherits(DataWorker, GenericWorker);\n\n/**\n * @see GenericWorker.cleanUp\n */\nDataWorker.prototype.cleanUp = function () {\n    GenericWorker.prototype.cleanUp.call(this);\n    this.data = null;\n};\n\n/**\n * @see GenericWorker.resume\n */\nDataWorker.prototype.resume = function () {\n    if(!GenericWorker.prototype.resume.call(this)) {\n        return false;\n    }\n\n    if (!this._tickScheduled && this.dataIsReady) {\n        this._tickScheduled = true;\n        utils.delay(this._tickAndRepeat, [], this);\n    }\n    return true;\n};\n\n/**\n * Trigger a tick a schedule an other call to this function.\n */\nDataWorker.prototype._tickAndRepeat = function() {\n    this._tickScheduled = false;\n    if(this.isPaused || this.isFinished) {\n        return;\n    }\n    this._tick();\n    if(!this.isFinished) {\n        utils.delay(this._tickAndRepeat, [], this);\n        this._tickScheduled = true;\n    }\n};\n\n/**\n * Read and push a chunk.\n */\nDataWorker.prototype._tick = function() {\n\n    if(this.isPaused || this.isFinished) {\n        return false;\n    }\n\n    var size = DEFAULT_BLOCK_SIZE;\n    var data = null, nextIndex = Math.min(this.max, this.index + size);\n    if (this.index >= this.max) {\n        // EOF\n        return this.end();\n    } else {\n        switch(this.type) {\n            case \"string\":\n                data = this.data.substring(this.index, nextIndex);\n            break;\n            case \"uint8array\":\n                data = this.data.subarray(this.index, nextIndex);\n            break;\n            case \"array\":\n            case \"nodebuffer\":\n                data = this.data.slice(this.index, nextIndex);\n            break;\n        }\n        this.index = nextIndex;\n        return this.push({\n            data : data,\n            meta : {\n                percent : this.max ? this.index / this.max * 100 : 0\n            }\n        });\n    }\n};\n\nmodule.exports = DataWorker;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$jszip$lib$stream$GenericWorker","~$shadow.js","~$module$node_modules$jszip$lib$utils"]],"~:properties",["^5",["percent","cleanUp","_tickScheduled","index","max","type","meta","data","_tickAndRepeat","dataIsReady","resume","_tick"]],"~:compiled-at",1766065009556,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$stream$DataWorker.js\",\n\"lineCount\":3,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAe9DC,QAASA,EAAU,CAACC,CAAD,CAAQ,CACvBC,CAAcC,CAAAA,IAAd,CAAmB,IAAnB,CAAyB,YAAzB,CACA,KAAIC,EAAO,IACX,KAAKC,CAAAA,WAAL,CAAmB,CAAA,CAEnB,KAAKC,CAAAA,GAAL,CADA,IAAKC,CAAAA,KACL,CADa,CAEb,KAAKC,CAAAA,IAAL,CAAY,IACZ,KAAKC,CAAAA,IAAL,CAAY,EAEZ,KAAKC,CAAAA,cAAL,CAAsB,CAAA,CAEtBT,EAAMU,CAAAA,IAAN,CAAW,QAAS,CAACH,CAAD,CAAO,CACvBJ,CAAKC,CAAAA,WAAL,CAAmB,CAAA,CACnBD,EAAKI,CAAAA,IAAL,CAAYA,CACZJ,EAAKE,CAAAA,GAAL,CAAWE,CAAX,EAAmBA,CAAKI,CAAAA,MAAxB,EAAkC,CAClCR,EAAKK,CAAAA,IAAL,CAAYI,CAAMC,CAAAA,SAAN,CAAgBN,CAAhB,CACRJ,EAAKW,CAAAA,QAAT,EACIX,CAAKY,CAAAA,cAAL,EANmB,CAA3B,CAQG,QAAS,CAACC,CAAD,CAAI,CACZb,CAAKc,CAAAA,KAAL,CAAWD,CAAX,CADY,CARhB,CAXuB,CAZ3B,IAAIJ,EAAQhB,CAAA,CAAQ,GAAR,CAAZ,CACIK,EAAgBL,CAAA,CAAQ,GAAR,CAmCpBgB,EAAMM,CAAAA,QAAN,CAAenB,CAAf,CAA2BE,CAA3B,CAKAF,EAAWoB,CAAAA,SAAUC,CAAAA,OAArB,CAA+BC,QAAS,EAAG,CACvCpB,CAAckB,CAAAA,SAAUC,CAAAA,OAAQlB,CAAAA,IAAhC,CAAqC,IAArC,CACA,KAAKK,CAAAA,IAAL,CAAY,IAF2B,CAQ3CR,EAAWoB,CAAAA,SAAUG,CAAAA,MAArB,CAA8BC,QAAS,EAAG,CACtC,GAAG,CAACtB,CAAckB,CAAAA,SAAUG,CAAAA,MAAOpB,CAAAA,IAA/B,CAAoC,IAApC,CAAJ,CACI,MAAO,CAAA,CAGP;CAAC,IAAKO,CAAAA,cAAV,EAA4B,IAAKL,CAAAA,WAAjC,GACI,IAAKK,CAAAA,cACL,CADsB,CAAA,CACtB,CAAAG,CAAMY,CAAAA,KAAN,CAAY,IAAKT,CAAAA,cAAjB,CAAiC,EAAjC,CAAqC,IAArC,CAFJ,CAIA,OAAO,CAAA,CAT+B,CAe1ChB,EAAWoB,CAAAA,SAAUJ,CAAAA,cAArB,CAAsCU,QAAQ,EAAG,CAC7C,IAAKhB,CAAAA,cAAL,CAAsB,CAAA,CACnB,KAAKK,CAAAA,QAAR,EAAoB,IAAKY,CAAAA,UAAzB,GAGA,IAAKC,CAAAA,KAAL,EACA,CAAI,IAAKD,CAAAA,UAAT,GACId,CAAMY,CAAAA,KAAN,CAAY,IAAKT,CAAAA,cAAjB,CAAiC,EAAjC,CAAqC,IAArC,CACA,CAAA,IAAKN,CAAAA,cAAL,CAAsB,CAAA,CAF1B,CAJA,CAF6C,CAejDV,EAAWoB,CAAAA,SAAUQ,CAAAA,KAArB,CAA6BC,QAAQ,EAAG,CAEpC,GAAG,IAAKd,CAAAA,QAAR,EAAoB,IAAKY,CAAAA,UAAzB,CACI,MAAO,CAAA,CAHyB,KAOhCnB,EAAO,IAPyB,CAOnBsB,EAAYC,IAAKC,CAAAA,GAAL,CAAS,IAAK1B,CAAAA,GAAd,CAAmB,IAAKC,CAAAA,KAAxB,CAjFR0B,KAiFQ,CAC7B,IAAI,IAAK1B,CAAAA,KAAT,EAAkB,IAAKD,CAAAA,GAAvB,CAEI,MAAO,KAAK4B,CAAAA,GAAL,EAEP,QAAO,IAAKzB,CAAAA,IAAZ,EACI,KAAK,QAAL,CACID,CAAA,CAAO,IAAKA,CAAAA,IAAK2B,CAAAA,SAAV,CAAoB,IAAK5B,CAAAA,KAAzB;AAAgCuB,CAAhC,CACX,MACA,MAAK,YAAL,CACItB,CAAA,CAAO,IAAKA,CAAAA,IAAK4B,CAAAA,QAAV,CAAmB,IAAK7B,CAAAA,KAAxB,CAA+BuB,CAA/B,CACX,MACA,MAAK,OAAL,CACA,KAAK,YAAL,CACItB,CAAA,CAAO,IAAKA,CAAAA,IAAK6B,CAAAA,KAAV,CAAgB,IAAK9B,CAAAA,KAArB,CAA4BuB,CAA5B,CATf,CAYA,IAAKvB,CAAAA,KAAL,CAAauB,CACb,OAAO,KAAKQ,CAAAA,IAAL,CAAU,CACb9B,KAAOA,CADM,CAEb+B,KAAO,CACHC,QAAU,IAAKlC,CAAAA,GAAL,CAAW,IAAKC,CAAAA,KAAhB,CAAwB,IAAKD,CAAAA,GAA7B,CAAmC,GAAnC,CAAyC,CADhD,CAFM,CAAV,CAzByB,CAkCxCR,GAAOC,CAAAA,OAAP,CAAiBC,CApH6C;\",\n\"sources\":[\"node_modules/jszip/lib/stream/DataWorker.js\"],\n\"sourcesContent\":[\"shadow$provide[163] = function(global,require,module,exports) {\\n'use strict';\\n\\nvar utils = require('../utils');\\nvar GenericWorker = require('./GenericWorker');\\n\\n// the size of the generated chunks\\n// TODO expose this as a public variable\\nvar DEFAULT_BLOCK_SIZE = 16 * 1024;\\n\\n/**\\n * A worker that reads a content and emits chunks.\\n * @constructor\\n * @param {Promise} dataP the promise of the data to split\\n */\\nfunction DataWorker(dataP) {\\n    GenericWorker.call(this, \\\"DataWorker\\\");\\n    var self = this;\\n    this.dataIsReady = false;\\n    this.index = 0;\\n    this.max = 0;\\n    this.data = null;\\n    this.type = \\\"\\\";\\n\\n    this._tickScheduled = false;\\n\\n    dataP.then(function (data) {\\n        self.dataIsReady = true;\\n        self.data = data;\\n        self.max = data && data.length || 0;\\n        self.type = utils.getTypeOf(data);\\n        if(!self.isPaused) {\\n            self._tickAndRepeat();\\n        }\\n    }, function (e) {\\n        self.error(e);\\n    });\\n}\\n\\nutils.inherits(DataWorker, GenericWorker);\\n\\n/**\\n * @see GenericWorker.cleanUp\\n */\\nDataWorker.prototype.cleanUp = function () {\\n    GenericWorker.prototype.cleanUp.call(this);\\n    this.data = null;\\n};\\n\\n/**\\n * @see GenericWorker.resume\\n */\\nDataWorker.prototype.resume = function () {\\n    if(!GenericWorker.prototype.resume.call(this)) {\\n        return false;\\n    }\\n\\n    if (!this._tickScheduled && this.dataIsReady) {\\n        this._tickScheduled = true;\\n        utils.delay(this._tickAndRepeat, [], this);\\n    }\\n    return true;\\n};\\n\\n/**\\n * Trigger a tick a schedule an other call to this function.\\n */\\nDataWorker.prototype._tickAndRepeat = function() {\\n    this._tickScheduled = false;\\n    if(this.isPaused || this.isFinished) {\\n        return;\\n    }\\n    this._tick();\\n    if(!this.isFinished) {\\n        utils.delay(this._tickAndRepeat, [], this);\\n        this._tickScheduled = true;\\n    }\\n};\\n\\n/**\\n * Read and push a chunk.\\n */\\nDataWorker.prototype._tick = function() {\\n\\n    if(this.isPaused || this.isFinished) {\\n        return false;\\n    }\\n\\n    var size = DEFAULT_BLOCK_SIZE;\\n    var data = null, nextIndex = Math.min(this.max, this.index + size);\\n    if (this.index >= this.max) {\\n        // EOF\\n        return this.end();\\n    } else {\\n        switch(this.type) {\\n            case \\\"string\\\":\\n                data = this.data.substring(this.index, nextIndex);\\n            break;\\n            case \\\"uint8array\\\":\\n                data = this.data.subarray(this.index, nextIndex);\\n            break;\\n            case \\\"array\\\":\\n            case \\\"nodebuffer\\\":\\n                data = this.data.slice(this.index, nextIndex);\\n            break;\\n        }\\n        this.index = nextIndex;\\n        return this.push({\\n            data : data,\\n            meta : {\\n                percent : this.max ? this.index / this.max * 100 : 0\\n            }\\n        });\\n    }\\n};\\n\\nmodule.exports = DataWorker;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"DataWorker\",\"dataP\",\"GenericWorker\",\"call\",\"self\",\"dataIsReady\",\"max\",\"index\",\"data\",\"type\",\"_tickScheduled\",\"then\",\"length\",\"utils\",\"getTypeOf\",\"isPaused\",\"_tickAndRepeat\",\"e\",\"error\",\"inherits\",\"prototype\",\"cleanUp\",\"DataWorker.prototype.cleanUp\",\"resume\",\"DataWorker.prototype.resume\",\"delay\",\"DataWorker.prototype._tickAndRepeat\",\"isFinished\",\"_tick\",\"DataWorker.prototype._tick\",\"nextIndex\",\"Math\",\"min\",\"DEFAULT_BLOCK_SIZE\",\"end\",\"substring\",\"subarray\",\"slice\",\"push\",\"meta\",\"percent\"]\n}\n"]