["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/reader/DataReader.js"],"~:js","shadow$provide[192]=function(ra,X,Ra,P){function w(B){this.data=B;this.length=B.length;this.zero=this.index=0}var Z=X(156);w.prototype={checkOffset:function(B){this.checkIndex(this.index+B)},checkIndex:function(B){if(this.length<this.zero+B||0>B)throw Error(\"End of data reached (data length \\x3d \"+this.length+\", asked index \\x3d \"+B+\"). Corrupted zip ?\");},setIndex:function(B){this.checkIndex(B);this.index=B},skip:function(B){this.setIndex(this.index+B)},byteAt:function(B){},readInt:function(B){var p=\n0,c;this.checkOffset(B);for(c=this.index+B-1;c>=this.index;c--)p=(p<<8)+this.byteAt(c);this.index+=B;return p},readString:function(B){return Z.transformTo(\"string\",this.readData(B))},readData:function(B){},lastIndexOfSignature:function(B){},readAndCheckSignature:function(B){},readDate:function(){var B=this.readInt(4);return new Date(Date.UTC((B>>25&127)+1980,(B>>21&15)-1,B>>16&31,B>>11&31,B>>5&63,(B&31)<<1))}};Ra.exports=w}","~:source","shadow$provide[192] = function(global,require,module,exports) {\n'use strict';\nvar utils = require('../utils');\n\nfunction DataReader(data) {\n    this.data = data; // type : see implementation\n    this.length = data.length;\n    this.index = 0;\n    this.zero = 0;\n}\nDataReader.prototype = {\n    /**\n     * Check that the offset will not go too far.\n     * @param {string} offset the additional offset to check.\n     * @throws {Error} an Error if the offset is out of bounds.\n     */\n    checkOffset: function(offset) {\n        this.checkIndex(this.index + offset);\n    },\n    /**\n     * Check that the specified index will not be too far.\n     * @param {string} newIndex the index to check.\n     * @throws {Error} an Error if the index is out of bounds.\n     */\n    checkIndex: function(newIndex) {\n        if (this.length < this.zero + newIndex || newIndex < 0) {\n            throw new Error(\"End of data reached (data length = \" + this.length + \", asked index = \" + (newIndex) + \"). Corrupted zip ?\");\n        }\n    },\n    /**\n     * Change the index.\n     * @param {number} newIndex The new index.\n     * @throws {Error} if the new index is out of the data.\n     */\n    setIndex: function(newIndex) {\n        this.checkIndex(newIndex);\n        this.index = newIndex;\n    },\n    /**\n     * Skip the next n bytes.\n     * @param {number} n the number of bytes to skip.\n     * @throws {Error} if the new index is out of the data.\n     */\n    skip: function(n) {\n        this.setIndex(this.index + n);\n    },\n    /**\n     * Get the byte at the specified index.\n     * @param {number} i the index to use.\n     * @return {number} a byte.\n     */\n    byteAt: function(i) {\n        // see implementations\n    },\n    /**\n     * Get the next number with a given byte size.\n     * @param {number} size the number of bytes to read.\n     * @return {number} the corresponding number.\n     */\n    readInt: function(size) {\n        var result = 0,\n            i;\n        this.checkOffset(size);\n        for (i = this.index + size - 1; i >= this.index; i--) {\n            result = (result << 8) + this.byteAt(i);\n        }\n        this.index += size;\n        return result;\n    },\n    /**\n     * Get the next string with a given byte size.\n     * @param {number} size the number of bytes to read.\n     * @return {string} the corresponding string.\n     */\n    readString: function(size) {\n        return utils.transformTo(\"string\", this.readData(size));\n    },\n    /**\n     * Get raw data without conversion, <size> bytes.\n     * @param {number} size the number of bytes to read.\n     * @return {Object} the raw data, implementation specific.\n     */\n    readData: function(size) {\n        // see implementations\n    },\n    /**\n     * Find the last occurrence of a zip signature (4 bytes).\n     * @param {string} sig the signature to find.\n     * @return {number} the index of the last occurrence, -1 if not found.\n     */\n    lastIndexOfSignature: function(sig) {\n        // see implementations\n    },\n    /**\n     * Read the signature (4 bytes) at the current position and compare it with sig.\n     * @param {string} sig the expected signature\n     * @return {boolean} true if the signature matches, false otherwise.\n     */\n    readAndCheckSignature: function(sig) {\n        // see implementations\n    },\n    /**\n     * Get the next date.\n     * @return {Date} the date.\n     */\n    readDate: function() {\n        var dostime = this.readInt(4);\n        return new Date(Date.UTC(\n        ((dostime >> 25) & 0x7f) + 1980, // year\n        ((dostime >> 21) & 0x0f) - 1, // month\n        (dostime >> 16) & 0x1f, // day\n        (dostime >> 11) & 0x1f, // hour\n        (dostime >> 5) & 0x3f, // minute\n        (dostime & 0x1f) << 1)); // second\n    }\n};\nmodule.exports = DataReader;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$jszip$lib$utils"]],"~:properties",["^5",["skip","index","prototype","lastIndexOfSignature","zero","checkOffset","readData","readInt","readString","length","setIndex","readAndCheckSignature","data","checkIndex","readDate","byteAt"]],"~:compiled-at",1766065009568,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$reader$DataReader.js\",\n\"lineCount\":2,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAI9DC,QAASA,EAAU,CAACC,CAAD,CAAO,CACtB,IAAKA,CAAAA,IAAL,CAAYA,CACZ,KAAKC,CAAAA,MAAL,CAAcD,CAAKC,CAAAA,MAEnB,KAAKC,CAAAA,IAAL,CADA,IAAKC,CAAAA,KACL,CADa,CAHS,CAF1B,IAAIC,EAAQR,CAAA,CAAQ,GAAR,CAQZG,EAAWM,CAAAA,SAAX,CAAuB,CAMnBC,YAAaA,QAAQ,CAACC,CAAD,CAAS,CAC1B,IAAKC,CAAAA,UAAL,CAAgB,IAAKL,CAAAA,KAArB,CAA6BI,CAA7B,CAD0B,CANX,CAcnBC,WAAYA,QAAQ,CAACC,CAAD,CAAW,CAC3B,GAAI,IAAKR,CAAAA,MAAT,CAAkB,IAAKC,CAAAA,IAAvB,CAA8BO,CAA9B,EAAqD,CAArD,CAA0CA,CAA1C,CACI,KAAUC,MAAJ,CAAU,wCAAV,CAAkD,IAAKT,CAAAA,MAAvD,CAAgE,qBAAhE,CAAsFQ,CAAtF,CAAkG,oBAAlG,CAAN,CAFuB,CAdZ,CAwBnBE,SAAUA,QAAQ,CAACF,CAAD,CAAW,CACzB,IAAKD,CAAAA,UAAL,CAAgBC,CAAhB,CACA,KAAKN,CAAAA,KAAL,CAAaM,CAFY,CAxBV,CAiCnBG,KAAMA,QAAQ,CAACC,CAAD,CAAI,CACd,IAAKF,CAAAA,QAAL,CAAc,IAAKR,CAAAA,KAAnB,CAA2BU,CAA3B,CADc,CAjCC,CAyCnBC,OAAQA,QAAQ,CAACC,CAAD,CAAI,EAzCD,CAiDnBC,QAASA,QAAQ,CAACC,CAAD,CAAO,CAAA,IAChBC;AAAS,CADO,CAEhBH,CACJ,KAAKT,CAAAA,WAAL,CAAiBW,CAAjB,CACA,KAAKF,CAAL,CAAS,IAAKZ,CAAAA,KAAd,CAAsBc,CAAtB,CAA6B,CAA7B,CAAgCF,CAAhC,EAAqC,IAAKZ,CAAAA,KAA1C,CAAiDY,CAAA,EAAjD,CACIG,CAAA,EAAUA,CAAV,EAAoB,CAApB,EAAyB,IAAKJ,CAAAA,MAAL,CAAYC,CAAZ,CAE7B,KAAKZ,CAAAA,KAAL,EAAcc,CACd,OAAOC,EARa,CAjDL,CAgEnBC,WAAYA,QAAQ,CAACF,CAAD,CAAO,CACvB,MAAOb,EAAMgB,CAAAA,WAAN,CAAkB,QAAlB,CAA4B,IAAKC,CAAAA,QAAL,CAAcJ,CAAd,CAA5B,CADgB,CAhER,CAwEnBI,SAAUA,QAAQ,CAACJ,CAAD,CAAO,EAxEN,CAgFnBK,qBAAsBA,QAAQ,CAACC,CAAD,CAAM,EAhFjB,CAwFnBC,sBAAuBA,QAAQ,CAACD,CAAD,CAAM,EAxFlB,CA+FnBE,SAAUA,QAAQ,EAAG,CACjB,IAAIC,EAAU,IAAKV,CAAAA,OAAL,CAAa,CAAb,CACd,OAAO,KAAIW,IAAJ,CAASA,IAAKC,CAAAA,GAAL,EACdF,CADc,EACH,EADG,CACG,GADH,EACW,IADX,EAEdA,CAFc,EAEH,EAFG,CAEG,EAFH,EAEW,CAFX,CAGfA,CAHe,EAGJ,EAHI,CAGE,EAHF,CAIfA,CAJe,EAIJ,EAJI,CAIE,EAJF,CAKfA,CALe,EAKJ,CALI,CAKC,EALD,EAMfA,CANe,CAML,EANK,GAMI,CANJ,CAAT,CAFU,CA/FF,CA0GvB7B,GAAOC,CAAAA,OAAP,CAAiBC,CApH6C;\",\n\"sources\":[\"node_modules/jszip/lib/reader/DataReader.js\"],\n\"sourcesContent\":[\"shadow$provide[192] = function(global,require,module,exports) {\\n'use strict';\\nvar utils = require('../utils');\\n\\nfunction DataReader(data) {\\n    this.data = data; // type : see implementation\\n    this.length = data.length;\\n    this.index = 0;\\n    this.zero = 0;\\n}\\nDataReader.prototype = {\\n    /**\\n     * Check that the offset will not go too far.\\n     * @param {string} offset the additional offset to check.\\n     * @throws {Error} an Error if the offset is out of bounds.\\n     */\\n    checkOffset: function(offset) {\\n        this.checkIndex(this.index + offset);\\n    },\\n    /**\\n     * Check that the specified index will not be too far.\\n     * @param {string} newIndex the index to check.\\n     * @throws {Error} an Error if the index is out of bounds.\\n     */\\n    checkIndex: function(newIndex) {\\n        if (this.length < this.zero + newIndex || newIndex < 0) {\\n            throw new Error(\\\"End of data reached (data length = \\\" + this.length + \\\", asked index = \\\" + (newIndex) + \\\"). Corrupted zip ?\\\");\\n        }\\n    },\\n    /**\\n     * Change the index.\\n     * @param {number} newIndex The new index.\\n     * @throws {Error} if the new index is out of the data.\\n     */\\n    setIndex: function(newIndex) {\\n        this.checkIndex(newIndex);\\n        this.index = newIndex;\\n    },\\n    /**\\n     * Skip the next n bytes.\\n     * @param {number} n the number of bytes to skip.\\n     * @throws {Error} if the new index is out of the data.\\n     */\\n    skip: function(n) {\\n        this.setIndex(this.index + n);\\n    },\\n    /**\\n     * Get the byte at the specified index.\\n     * @param {number} i the index to use.\\n     * @return {number} a byte.\\n     */\\n    byteAt: function(i) {\\n        // see implementations\\n    },\\n    /**\\n     * Get the next number with a given byte size.\\n     * @param {number} size the number of bytes to read.\\n     * @return {number} the corresponding number.\\n     */\\n    readInt: function(size) {\\n        var result = 0,\\n            i;\\n        this.checkOffset(size);\\n        for (i = this.index + size - 1; i >= this.index; i--) {\\n            result = (result << 8) + this.byteAt(i);\\n        }\\n        this.index += size;\\n        return result;\\n    },\\n    /**\\n     * Get the next string with a given byte size.\\n     * @param {number} size the number of bytes to read.\\n     * @return {string} the corresponding string.\\n     */\\n    readString: function(size) {\\n        return utils.transformTo(\\\"string\\\", this.readData(size));\\n    },\\n    /**\\n     * Get raw data without conversion, <size> bytes.\\n     * @param {number} size the number of bytes to read.\\n     * @return {Object} the raw data, implementation specific.\\n     */\\n    readData: function(size) {\\n        // see implementations\\n    },\\n    /**\\n     * Find the last occurrence of a zip signature (4 bytes).\\n     * @param {string} sig the signature to find.\\n     * @return {number} the index of the last occurrence, -1 if not found.\\n     */\\n    lastIndexOfSignature: function(sig) {\\n        // see implementations\\n    },\\n    /**\\n     * Read the signature (4 bytes) at the current position and compare it with sig.\\n     * @param {string} sig the expected signature\\n     * @return {boolean} true if the signature matches, false otherwise.\\n     */\\n    readAndCheckSignature: function(sig) {\\n        // see implementations\\n    },\\n    /**\\n     * Get the next date.\\n     * @return {Date} the date.\\n     */\\n    readDate: function() {\\n        var dostime = this.readInt(4);\\n        return new Date(Date.UTC(\\n        ((dostime >> 25) & 0x7f) + 1980, // year\\n        ((dostime >> 21) & 0x0f) - 1, // month\\n        (dostime >> 16) & 0x1f, // day\\n        (dostime >> 11) & 0x1f, // hour\\n        (dostime >> 5) & 0x3f, // minute\\n        (dostime & 0x1f) << 1)); // second\\n    }\\n};\\nmodule.exports = DataReader;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"DataReader\",\"data\",\"length\",\"zero\",\"index\",\"utils\",\"prototype\",\"checkOffset\",\"offset\",\"checkIndex\",\"newIndex\",\"Error\",\"setIndex\",\"skip\",\"n\",\"byteAt\",\"i\",\"readInt\",\"size\",\"result\",\"readString\",\"transformTo\",\"readData\",\"lastIndexOfSignature\",\"sig\",\"readAndCheckSignature\",\"readDate\",\"dostime\",\"Date\",\"UTC\"]\n}\n"]