["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/nodejs/NodejsStreamInputAdapter.js"],"~:js","shadow$provide[190]=function(ra,X,Ra,P){function w(B,p){Z.call(this,\"Nodejs stream input adapter for \"+B);this._upstreamEnded=!1;this._bindStream(p)}ra=X(156);var Z=X(157);ra.inherits(w,Z);w.prototype._bindStream=function(B){var p=this;this._stream=B;B.pause();B.on(\"data\",function(c){p.push({data:c,meta:{percent:0}})}).on(\"error\",function(c){p.isPaused?this.generatedError=c:p.error(c)}).on(\"end\",function(){p.isPaused?p._upstreamEnded=!0:p.end()})};w.prototype.pause=function(){if(!Z.prototype.pause.call(this))return!1;\nthis._stream.pause();return!0};w.prototype.resume=function(){if(!Z.prototype.resume.call(this))return!1;this._upstreamEnded?this.end():this._stream.resume();return!0};Ra.exports=w}","~:source","shadow$provide[190] = function(global,require,module,exports) {\n\"use strict\";\n\nvar utils = require('../utils');\nvar GenericWorker = require('../stream/GenericWorker');\n\n/**\n * A worker that use a nodejs stream as source.\n * @constructor\n * @param {String} filename the name of the file entry for this stream.\n * @param {Readable} stream the nodejs stream.\n */\nfunction NodejsStreamInputAdapter(filename, stream) {\n    GenericWorker.call(this, \"Nodejs stream input adapter for \" + filename);\n    this._upstreamEnded = false;\n    this._bindStream(stream);\n}\n\nutils.inherits(NodejsStreamInputAdapter, GenericWorker);\n\n/**\n * Prepare the stream and bind the callbacks on it.\n * Do this ASAP on node 0.10 ! A lazy binding doesn't always work.\n * @param {Stream} stream the nodejs stream to use.\n */\nNodejsStreamInputAdapter.prototype._bindStream = function (stream) {\n    var self = this;\n    this._stream = stream;\n    stream.pause();\n    stream\n    .on(\"data\", function (chunk) {\n        self.push({\n            data: chunk,\n            meta : {\n                percent : 0\n            }\n        });\n    })\n    .on(\"error\", function (e) {\n        if(self.isPaused) {\n            this.generatedError = e;\n        } else {\n            self.error(e);\n        }\n    })\n    .on(\"end\", function () {\n        if(self.isPaused) {\n            self._upstreamEnded = true;\n        } else {\n            self.end();\n        }\n    });\n};\nNodejsStreamInputAdapter.prototype.pause = function () {\n    if(!GenericWorker.prototype.pause.call(this)) {\n        return false;\n    }\n    this._stream.pause();\n    return true;\n};\nNodejsStreamInputAdapter.prototype.resume = function () {\n    if(!GenericWorker.prototype.resume.call(this)) {\n        return false;\n    }\n\n    if(this._upstreamEnded) {\n        this.end();\n    } else {\n        this._stream.resume();\n    }\n\n    return true;\n};\n\nmodule.exports = NodejsStreamInputAdapter;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$jszip$lib$stream$GenericWorker","~$shadow.js","~$module$node_modules$jszip$lib$utils"]],"~:properties",["^5",["percent","generatedError","_stream","pause","meta","_upstreamEnded","data","_bindStream","resume"]],"~:compiled-at",1766065009567,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$nodejs$NodejsStreamInputAdapter.js\",\n\"lineCount\":2,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAY9DC,QAASA,EAAwB,CAACC,CAAD,CAAWC,CAAX,CAAmB,CAChDC,CAAcC,CAAAA,IAAd,CAAmB,IAAnB,CAAyB,kCAAzB,CAA8DH,CAA9D,CACA,KAAKI,CAAAA,cAAL,CAAsB,CAAA,CACtB,KAAKC,CAAAA,WAAL,CAAiBJ,CAAjB,CAHgD,CAThDK,EAAAA,CAAQV,CAAA,CAAQ,GAAR,CACZ,KAAIM,EAAgBN,CAAA,CAAQ,GAAR,CAcpBU,GAAMC,CAAAA,QAAN,CAAeR,CAAf,CAAyCG,CAAzC,CAOAH,EAAyBS,CAAAA,SAAUH,CAAAA,WAAnC,CAAiDI,QAAS,CAACR,CAAD,CAAS,CAC/D,IAAIS,EAAO,IACX,KAAKC,CAAAA,OAAL,CAAeV,CACfA,EAAOW,CAAAA,KAAP,EACAX,EACCY,CAAAA,EADD,CACI,MADJ,CACY,QAAS,CAACC,CAAD,CAAQ,CACzBJ,CAAKK,CAAAA,IAAL,CAAU,CACNC,KAAMF,CADA,CAENG,KAAO,CACHC,QAAU,CADP,CAFD,CAAV,CADyB,CAD7B,CASCL,CAAAA,EATD,CASI,OATJ,CASa,QAAS,CAACM,CAAD,CAAI,CACnBT,CAAKU,CAAAA,QAAR,CACI,IAAKC,CAAAA,cADT,CAC0BF,CAD1B,CAGIT,CAAKY,CAAAA,KAAL,CAAWH,CAAX,CAJkB,CAT1B,CAgBCN,CAAAA,EAhBD,CAgBI,KAhBJ,CAgBW,QAAS,EAAG,CAChBH,CAAKU,CAAAA,QAAR,CACIV,CAAKN,CAAAA,cADT,CAC0B,CAAA,CAD1B,CAGIM,CAAKa,CAAAA,GAAL,EAJe,CAhBvB,CAJ+D,CA4BnExB,EAAyBS,CAAAA,SAAUI,CAAAA,KAAnC,CAA2CY,QAAS,EAAG,CACnD,GAAG,CAACtB,CAAcM,CAAAA,SAAUI,CAAAA,KAAMT,CAAAA,IAA9B,CAAmC,IAAnC,CAAJ,CACI,MAAO,CAAA,CAEX;IAAKQ,CAAAA,OAAQC,CAAAA,KAAb,EACA,OAAO,CAAA,CAL4C,CAOvDb,EAAyBS,CAAAA,SAAUiB,CAAAA,MAAnC,CAA4CC,QAAS,EAAG,CACpD,GAAG,CAACxB,CAAcM,CAAAA,SAAUiB,CAAAA,MAAOtB,CAAAA,IAA/B,CAAoC,IAApC,CAAJ,CACI,MAAO,CAAA,CAGR,KAAKC,CAAAA,cAAR,CACI,IAAKmB,CAAAA,GAAL,EADJ,CAGI,IAAKZ,CAAAA,OAAQc,CAAAA,MAAb,EAGJ,OAAO,CAAA,CAX6C,CAcxD5B,GAAOC,CAAAA,OAAP,CAAiBC,CA1E6C;\",\n\"sources\":[\"node_modules/jszip/lib/nodejs/NodejsStreamInputAdapter.js\"],\n\"sourcesContent\":[\"shadow$provide[190] = function(global,require,module,exports) {\\n\\\"use strict\\\";\\n\\nvar utils = require('../utils');\\nvar GenericWorker = require('../stream/GenericWorker');\\n\\n/**\\n * A worker that use a nodejs stream as source.\\n * @constructor\\n * @param {String} filename the name of the file entry for this stream.\\n * @param {Readable} stream the nodejs stream.\\n */\\nfunction NodejsStreamInputAdapter(filename, stream) {\\n    GenericWorker.call(this, \\\"Nodejs stream input adapter for \\\" + filename);\\n    this._upstreamEnded = false;\\n    this._bindStream(stream);\\n}\\n\\nutils.inherits(NodejsStreamInputAdapter, GenericWorker);\\n\\n/**\\n * Prepare the stream and bind the callbacks on it.\\n * Do this ASAP on node 0.10 ! A lazy binding doesn't always work.\\n * @param {Stream} stream the nodejs stream to use.\\n */\\nNodejsStreamInputAdapter.prototype._bindStream = function (stream) {\\n    var self = this;\\n    this._stream = stream;\\n    stream.pause();\\n    stream\\n    .on(\\\"data\\\", function (chunk) {\\n        self.push({\\n            data: chunk,\\n            meta : {\\n                percent : 0\\n            }\\n        });\\n    })\\n    .on(\\\"error\\\", function (e) {\\n        if(self.isPaused) {\\n            this.generatedError = e;\\n        } else {\\n            self.error(e);\\n        }\\n    })\\n    .on(\\\"end\\\", function () {\\n        if(self.isPaused) {\\n            self._upstreamEnded = true;\\n        } else {\\n            self.end();\\n        }\\n    });\\n};\\nNodejsStreamInputAdapter.prototype.pause = function () {\\n    if(!GenericWorker.prototype.pause.call(this)) {\\n        return false;\\n    }\\n    this._stream.pause();\\n    return true;\\n};\\nNodejsStreamInputAdapter.prototype.resume = function () {\\n    if(!GenericWorker.prototype.resume.call(this)) {\\n        return false;\\n    }\\n\\n    if(this._upstreamEnded) {\\n        this.end();\\n    } else {\\n        this._stream.resume();\\n    }\\n\\n    return true;\\n};\\n\\nmodule.exports = NodejsStreamInputAdapter;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"NodejsStreamInputAdapter\",\"filename\",\"stream\",\"GenericWorker\",\"call\",\"_upstreamEnded\",\"_bindStream\",\"utils\",\"inherits\",\"prototype\",\"NodejsStreamInputAdapter.prototype._bindStream\",\"self\",\"_stream\",\"pause\",\"on\",\"chunk\",\"push\",\"data\",\"meta\",\"percent\",\"e\",\"isPaused\",\"generatedError\",\"error\",\"end\",\"NodejsStreamInputAdapter.prototype.pause\",\"resume\",\"NodejsStreamInputAdapter.prototype.resume\"]\n}\n"]