["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/generate/ZipFileWorker.js"],"~:js","shadow$provide[188]=function(ra,X,Ra,P){function w(x,Q,g,h){B.call(this,\"ZipFileWorker\");this.bytesWritten=0;this.zipComment=Q;this.zipPlatform=g;this.encodeFileName=h;this.streamFiles=x;this.accumulate=!1;this.contentBuffer=[];this.dirRecords=[];this.entriesCount=this.currentSourceOffset=0;this.currentFile=null;this._sources=[]}var Z=X(156),B=X(157),p=X(158),c=X(164),u=X(187),A=function(x,Q){var g=\"\",h;for(h=0;h<Q;h++)g+=String.fromCharCode(x&255),x>>>=8;return g},y=function(x,Q,g,h,b,l){var k=x.file,\nr=x.compression,D=l!==p.utf8encode,v=Z.transformTo(\"string\",l(k.name)),t=Z.transformTo(\"string\",p.utf8encode(k.name)),q=k.comment;l=Z.transformTo(\"string\",l(q));var f=Z.transformTo(\"string\",p.utf8encode(q)),E=t.length!==k.name.length,C=f.length!==q.length;q=\"\";var J=k.dir;var V=k.date,G=0,T=0,K=0;if(!Q||g)G=x.crc32,T=x.compressedSize,K=x.uncompressedSize;x=0;Q&&(x|=8);D||!E&&!C||(x|=2048);Q=0;J&&(Q|=16);\"UNIX\"===b?(b=798,(D=k=k.unixPermissions)||(D=J?16893:33204),Q|=(D&65535)<<16):(b=20,Q|=(k.dosPermissions||\n0)&63);k=V.getUTCHours();k=k<<6|V.getUTCMinutes();k=k<<5|V.getUTCSeconds()/2;J=V.getUTCFullYear()-1980;J=J<<4|V.getUTCMonth()+1;J=J<<5|V.getUTCDate();E&&(t=A(1,1)+A(c(v),4)+t,q+=\"up\"+A(t.length,2)+t);C&&(t=A(1,1)+A(c(l),4)+f,q+=\"uc\"+A(t.length,2)+t);t=\"\\n\\x00\"+A(x,2);t+=r.magic;t+=A(k,2);t+=A(J,2);t+=A(G,4);t+=A(T,4);t+=A(K,4);t+=A(v.length,2);t+=A(q.length,2);r=u.LOCAL_FILE_HEADER+t+v+q;h=u.CENTRAL_FILE_HEADER+A(b,2)+t+A(l.length,2)+\"\\x00\\x00\\x00\\x00\"+A(Q,4)+A(h,4)+v+q+l;return{fileRecord:r,dirRecord:h}};\nZ.inherits(w,B);w.prototype.push=function(x){var Q=x.meta.percent||0,g=this.entriesCount,h=this._sources.length;this.accumulate?this.contentBuffer.push(x):(this.bytesWritten+=x.data.length,B.prototype.push.call(this,{data:x.data,meta:{currentFile:this.currentFile,percent:g?(Q+100*(g-h-1))/g:100}}))};w.prototype.openedSource=function(x){this.currentSourceOffset=this.bytesWritten;this.currentFile=x.file.name;var Q=this.streamFiles&&!x.file.dir;Q?(x=y(x,Q,!1,this.currentSourceOffset,this.zipPlatform,\nthis.encodeFileName),this.push({data:x.fileRecord,meta:{percent:0}})):this.accumulate=!0};w.prototype.closedSource=function(x){this.accumulate=!1;var Q=this.streamFiles&&!x.file.dir,g=y(x,Q,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.dirRecords.push(g.dirRecord);if(Q)Q=this.push,x=u.DATA_DESCRIPTOR+A(x.crc32,4)+A(x.compressedSize,4)+A(x.uncompressedSize,4),Q.call(this,{data:x,meta:{percent:100}});else for(this.push({data:g.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());\nthis.currentFile=null};w.prototype.flush=function(){for(var x=this.bytesWritten,Q=0;Q<this.dirRecords.length;Q++)this.push({data:this.dirRecords[Q],meta:{percent:100}});Q=this.dirRecords.length;var g=this.bytesWritten-x,h=Z.transformTo(\"string\",(0,this.encodeFileName)(this.zipComment));x=u.CENTRAL_DIRECTORY_END+\"\\x00\\x00\\x00\\x00\"+A(Q,2)+A(Q,2)+A(g,4)+A(x,4)+A(h.length,2)+h;this.push({data:x,meta:{percent:100}})};w.prototype.prepareNextSource=function(){this.previous=this._sources.shift();this.openedSource(this.previous.streamInfo);\nthis.isPaused?this.previous.pause():this.previous.resume()};w.prototype.registerPrevious=function(x){this._sources.push(x);var Q=this;x.on(\"data\",function(g){Q.processChunk(g)});x.on(\"end\",function(){Q.closedSource(Q.previous.streamInfo);Q._sources.length?Q.prepareNextSource():Q.end()});x.on(\"error\",function(g){Q.error(g)});return this};w.prototype.resume=function(){if(!B.prototype.resume.call(this))return!1;if(!this.previous&&this._sources.length)return this.prepareNextSource(),!0;if(!this.previous&&\n!this._sources.length&&!this.generatedError)return this.end(),!0};w.prototype.error=function(x){var Q=this._sources;if(!B.prototype.error.call(this,x))return!1;for(var g=0;g<Q.length;g++)try{Q[g].error(x)}catch(h){}return!0};w.prototype.lock=function(){B.prototype.lock.call(this);for(var x=this._sources,Q=0;Q<x.length;Q++)x[Q].lock()};Ra.exports=w}","~:source","shadow$provide[188] = function(global,require,module,exports) {\n'use strict';\n\nvar utils = require('../utils');\nvar GenericWorker = require('../stream/GenericWorker');\nvar utf8 = require('../utf8');\nvar crc32 = require('../crc32');\nvar signature = require('../signature');\n\n/**\n * Transform an integer into a string in hexadecimal.\n * @private\n * @param {number} dec the number to convert.\n * @param {number} bytes the number of bytes to generate.\n * @returns {string} the result.\n */\nvar decToHex = function(dec, bytes) {\n    var hex = \"\", i;\n    for (i = 0; i < bytes; i++) {\n        hex += String.fromCharCode(dec & 0xff);\n        dec = dec >>> 8;\n    }\n    return hex;\n};\n\n/**\n * Generate the UNIX part of the external file attributes.\n * @param {Object} unixPermissions the unix permissions or null.\n * @param {Boolean} isDir true if the entry is a directory, false otherwise.\n * @return {Number} a 32 bit integer.\n *\n * adapted from http://unix.stackexchange.com/questions/14705/the-zip-formats-external-file-attribute :\n *\n * TTTTsstrwxrwxrwx0000000000ADVSHR\n * ^^^^____________________________ file type, see zipinfo.c (UNX_*)\n *     ^^^_________________________ setuid, setgid, sticky\n *        ^^^^^^^^^________________ permissions\n *                 ^^^^^^^^^^______ not used ?\n *                           ^^^^^^ DOS attribute bits : Archive, Directory, Volume label, System file, Hidden, Read only\n */\nvar generateUnixExternalFileAttr = function (unixPermissions, isDir) {\n\n    var result = unixPermissions;\n    if (!unixPermissions) {\n        // I can't use octal values in strict mode, hence the hexa.\n        //  040775 => 0x41fd\n        // 0100664 => 0x81b4\n        result = isDir ? 0x41fd : 0x81b4;\n    }\n    return (result & 0xFFFF) << 16;\n};\n\n/**\n * Generate the DOS part of the external file attributes.\n * @param {Object} dosPermissions the dos permissions or null.\n * @param {Boolean} isDir true if the entry is a directory, false otherwise.\n * @return {Number} a 32 bit integer.\n *\n * Bit 0     Read-Only\n * Bit 1     Hidden\n * Bit 2     System\n * Bit 3     Volume Label\n * Bit 4     Directory\n * Bit 5     Archive\n */\nvar generateDosExternalFileAttr = function (dosPermissions, isDir) {\n\n    // the dir flag is already set for compatibility\n    return (dosPermissions || 0)  & 0x3F;\n};\n\n/**\n * Generate the various parts used in the construction of the final zip file.\n * @param {Object} streamInfo the hash with information about the compressed file.\n * @param {Boolean} streamedContent is the content streamed ?\n * @param {Boolean} streamingEnded is the stream finished ?\n * @param {number} offset the current offset from the start of the zip file.\n * @param {String} platform let's pretend we are this platform (change platform dependents fields)\n * @param {Function} encodeFileName the function to encode the file name / comment.\n * @return {Object} the zip parts.\n */\nvar generateZipParts = function(streamInfo, streamedContent, streamingEnded, offset, platform, encodeFileName) {\n    var file = streamInfo['file'],\n    compression = streamInfo['compression'],\n    useCustomEncoding = encodeFileName !== utf8.utf8encode,\n    encodedFileName = utils.transformTo(\"string\", encodeFileName(file.name)),\n    utfEncodedFileName = utils.transformTo(\"string\", utf8.utf8encode(file.name)),\n    comment = file.comment,\n    encodedComment = utils.transformTo(\"string\", encodeFileName(comment)),\n    utfEncodedComment = utils.transformTo(\"string\", utf8.utf8encode(comment)),\n    useUTF8ForFileName = utfEncodedFileName.length !== file.name.length,\n    useUTF8ForComment = utfEncodedComment.length !== comment.length,\n    dosTime,\n    dosDate,\n    extraFields = \"\",\n    unicodePathExtraField = \"\",\n    unicodeCommentExtraField = \"\",\n    dir = file.dir,\n    date = file.date;\n\n\n    var dataInfo = {\n        crc32 : 0,\n        compressedSize : 0,\n        uncompressedSize : 0\n    };\n\n    // if the content is streamed, the sizes/crc32 are only available AFTER\n    // the end of the stream.\n    if (!streamedContent || streamingEnded) {\n        dataInfo.crc32 = streamInfo['crc32'];\n        dataInfo.compressedSize = streamInfo['compressedSize'];\n        dataInfo.uncompressedSize = streamInfo['uncompressedSize'];\n    }\n\n    var bitflag = 0;\n    if (streamedContent) {\n        // Bit 3: the sizes/crc32 are set to zero in the local header.\n        // The correct values are put in the data descriptor immediately\n        // following the compressed data.\n        bitflag |= 0x0008;\n    }\n    if (!useCustomEncoding && (useUTF8ForFileName || useUTF8ForComment)) {\n        // Bit 11: Language encoding flag (EFS).\n        bitflag |= 0x0800;\n    }\n\n\n    var extFileAttr = 0;\n    var versionMadeBy = 0;\n    if (dir) {\n        // dos or unix, we set the dos dir flag\n        extFileAttr |= 0x00010;\n    }\n    if(platform === \"UNIX\") {\n        versionMadeBy = 0x031E; // UNIX, version 3.0\n        extFileAttr |= generateUnixExternalFileAttr(file.unixPermissions, dir);\n    } else { // DOS or other, fallback to DOS\n        versionMadeBy = 0x0014; // DOS, version 2.0\n        extFileAttr |= generateDosExternalFileAttr(file.dosPermissions, dir);\n    }\n\n    // date\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/52/13.html\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/65/16.html\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/66/16.html\n\n    dosTime = date.getUTCHours();\n    dosTime = dosTime << 6;\n    dosTime = dosTime | date.getUTCMinutes();\n    dosTime = dosTime << 5;\n    dosTime = dosTime | date.getUTCSeconds() / 2;\n\n    dosDate = date.getUTCFullYear() - 1980;\n    dosDate = dosDate << 4;\n    dosDate = dosDate | (date.getUTCMonth() + 1);\n    dosDate = dosDate << 5;\n    dosDate = dosDate | date.getUTCDate();\n\n    if (useUTF8ForFileName) {\n        // set the unicode path extra field. unzip needs at least one extra\n        // field to correctly handle unicode path, so using the path is as good\n        // as any other information. This could improve the situation with\n        // other archive managers too.\n        // This field is usually used without the utf8 flag, with a non\n        // unicode path in the header (winrar, winzip). This helps (a bit)\n        // with the messy Windows' default compressed folders feature but\n        // breaks on p7zip which doesn't seek the unicode path extra field.\n        // So for now, UTF-8 everywhere !\n        unicodePathExtraField =\n            // Version\n            decToHex(1, 1) +\n            // NameCRC32\n            decToHex(crc32(encodedFileName), 4) +\n            // UnicodeName\n            utfEncodedFileName;\n\n        extraFields +=\n            // Info-ZIP Unicode Path Extra Field\n            \"\\x75\\x70\" +\n            // size\n            decToHex(unicodePathExtraField.length, 2) +\n            // content\n            unicodePathExtraField;\n    }\n\n    if(useUTF8ForComment) {\n\n        unicodeCommentExtraField =\n            // Version\n            decToHex(1, 1) +\n            // CommentCRC32\n            decToHex(crc32(encodedComment), 4) +\n            // UnicodeName\n            utfEncodedComment;\n\n        extraFields +=\n            // Info-ZIP Unicode Path Extra Field\n            \"\\x75\\x63\" +\n            // size\n            decToHex(unicodeCommentExtraField.length, 2) +\n            // content\n            unicodeCommentExtraField;\n    }\n\n    var header = \"\";\n\n    // version needed to extract\n    header += \"\\x0A\\x00\";\n    // general purpose bit flag\n    header += decToHex(bitflag, 2);\n    // compression method\n    header += compression.magic;\n    // last mod file time\n    header += decToHex(dosTime, 2);\n    // last mod file date\n    header += decToHex(dosDate, 2);\n    // crc-32\n    header += decToHex(dataInfo.crc32, 4);\n    // compressed size\n    header += decToHex(dataInfo.compressedSize, 4);\n    // uncompressed size\n    header += decToHex(dataInfo.uncompressedSize, 4);\n    // file name length\n    header += decToHex(encodedFileName.length, 2);\n    // extra field length\n    header += decToHex(extraFields.length, 2);\n\n\n    var fileRecord = signature.LOCAL_FILE_HEADER + header + encodedFileName + extraFields;\n\n    var dirRecord = signature.CENTRAL_FILE_HEADER +\n        // version made by (00: DOS)\n        decToHex(versionMadeBy, 2) +\n        // file header (common to file and central directory)\n        header +\n        // file comment length\n        decToHex(encodedComment.length, 2) +\n        // disk number start\n        \"\\x00\\x00\" +\n        // internal file attributes TODO\n        \"\\x00\\x00\" +\n        // external file attributes\n        decToHex(extFileAttr, 4) +\n        // relative offset of local header\n        decToHex(offset, 4) +\n        // file name\n        encodedFileName +\n        // extra field\n        extraFields +\n        // file comment\n        encodedComment;\n\n    return {\n        fileRecord: fileRecord,\n        dirRecord: dirRecord\n    };\n};\n\n/**\n * Generate the EOCD record.\n * @param {Number} entriesCount the number of entries in the zip file.\n * @param {Number} centralDirLength the length (in bytes) of the central dir.\n * @param {Number} localDirLength the length (in bytes) of the local dir.\n * @param {String} comment the zip file comment as a binary string.\n * @param {Function} encodeFileName the function to encode the comment.\n * @return {String} the EOCD record.\n */\nvar generateCentralDirectoryEnd = function (entriesCount, centralDirLength, localDirLength, comment, encodeFileName) {\n    var dirEnd = \"\";\n    var encodedComment = utils.transformTo(\"string\", encodeFileName(comment));\n\n    // end of central dir signature\n    dirEnd = signature.CENTRAL_DIRECTORY_END +\n        // number of this disk\n        \"\\x00\\x00\" +\n        // number of the disk with the start of the central directory\n        \"\\x00\\x00\" +\n        // total number of entries in the central directory on this disk\n        decToHex(entriesCount, 2) +\n        // total number of entries in the central directory\n        decToHex(entriesCount, 2) +\n        // size of the central directory   4 bytes\n        decToHex(centralDirLength, 4) +\n        // offset of start of central directory with respect to the starting disk number\n        decToHex(localDirLength, 4) +\n        // .ZIP file comment length\n        decToHex(encodedComment.length, 2) +\n        // .ZIP file comment\n        encodedComment;\n\n    return dirEnd;\n};\n\n/**\n * Generate data descriptors for a file entry.\n * @param {Object} streamInfo the hash generated by a worker, containing information\n * on the file entry.\n * @return {String} the data descriptors.\n */\nvar generateDataDescriptors = function (streamInfo) {\n    var descriptor = \"\";\n    descriptor = signature.DATA_DESCRIPTOR +\n        // crc-32                          4 bytes\n        decToHex(streamInfo['crc32'], 4) +\n        // compressed size                 4 bytes\n        decToHex(streamInfo['compressedSize'], 4) +\n        // uncompressed size               4 bytes\n        decToHex(streamInfo['uncompressedSize'], 4);\n\n    return descriptor;\n};\n\n\n/**\n * A worker to concatenate other workers to create a zip file.\n * @param {Boolean} streamFiles `true` to stream the content of the files,\n * `false` to accumulate it.\n * @param {String} comment the comment to use.\n * @param {String} platform the platform to use, \"UNIX\" or \"DOS\".\n * @param {Function} encodeFileName the function to encode file names and comments.\n */\nfunction ZipFileWorker(streamFiles, comment, platform, encodeFileName) {\n    GenericWorker.call(this, \"ZipFileWorker\");\n    // The number of bytes written so far. This doesn't count accumulated chunks.\n    this.bytesWritten = 0;\n    // The comment of the zip file\n    this.zipComment = comment;\n    // The platform \"generating\" the zip file.\n    this.zipPlatform = platform;\n    // the function to encode file names and comments.\n    this.encodeFileName = encodeFileName;\n    // Should we stream the content of the files ?\n    this.streamFiles = streamFiles;\n    // If `streamFiles` is false, we will need to accumulate the content of the\n    // files to calculate sizes / crc32 (and write them *before* the content).\n    // This boolean indicates if we are accumulating chunks (it will change a lot\n    // during the lifetime of this worker).\n    this.accumulate = false;\n    // The buffer receiving chunks when accumulating content.\n    this.contentBuffer = [];\n    // The list of generated directory records.\n    this.dirRecords = [];\n    // The offset (in bytes) from the beginning of the zip file for the current source.\n    this.currentSourceOffset = 0;\n    // The total number of entries in this zip file.\n    this.entriesCount = 0;\n    // the name of the file currently being added, null when handling the end of the zip file.\n    // Used for the emitted metadata.\n    this.currentFile = null;\n\n\n\n    this._sources = [];\n}\nutils.inherits(ZipFileWorker, GenericWorker);\n\n/**\n * @see GenericWorker.push\n */\nZipFileWorker.prototype.push = function (chunk) {\n\n    var currentFilePercent = chunk.meta.percent || 0;\n    var entriesCount = this.entriesCount;\n    var remainingFiles = this._sources.length;\n\n    if(this.accumulate) {\n        this.contentBuffer.push(chunk);\n    } else {\n        this.bytesWritten += chunk.data.length;\n\n        GenericWorker.prototype.push.call(this, {\n            data : chunk.data,\n            meta : {\n                currentFile : this.currentFile,\n                percent : entriesCount ? (currentFilePercent + 100 * (entriesCount - remainingFiles - 1)) / entriesCount : 100\n            }\n        });\n    }\n};\n\n/**\n * The worker started a new source (an other worker).\n * @param {Object} streamInfo the streamInfo object from the new source.\n */\nZipFileWorker.prototype.openedSource = function (streamInfo) {\n    this.currentSourceOffset = this.bytesWritten;\n    this.currentFile = streamInfo['file'].name;\n\n    var streamedContent = this.streamFiles && !streamInfo['file'].dir;\n\n    // don't stream folders (because they don't have any content)\n    if(streamedContent) {\n        var record = generateZipParts(streamInfo, streamedContent, false, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);\n        this.push({\n            data : record.fileRecord,\n            meta : {percent:0}\n        });\n    } else {\n        // we need to wait for the whole file before pushing anything\n        this.accumulate = true;\n    }\n};\n\n/**\n * The worker finished a source (an other worker).\n * @param {Object} streamInfo the streamInfo object from the finished source.\n */\nZipFileWorker.prototype.closedSource = function (streamInfo) {\n    this.accumulate = false;\n    var streamedContent = this.streamFiles && !streamInfo['file'].dir;\n    var record = generateZipParts(streamInfo, streamedContent, true, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);\n\n    this.dirRecords.push(record.dirRecord);\n    if(streamedContent) {\n        // after the streamed file, we put data descriptors\n        this.push({\n            data : generateDataDescriptors(streamInfo),\n            meta : {percent:100}\n        });\n    } else {\n        // the content wasn't streamed, we need to push everything now\n        // first the file record, then the content\n        this.push({\n            data : record.fileRecord,\n            meta : {percent:0}\n        });\n        while(this.contentBuffer.length) {\n            this.push(this.contentBuffer.shift());\n        }\n    }\n    this.currentFile = null;\n};\n\n/**\n * @see GenericWorker.flush\n */\nZipFileWorker.prototype.flush = function () {\n\n    var localDirLength = this.bytesWritten;\n    for(var i = 0; i < this.dirRecords.length; i++) {\n        this.push({\n            data : this.dirRecords[i],\n            meta : {percent:100}\n        });\n    }\n    var centralDirLength = this.bytesWritten - localDirLength;\n\n    var dirEnd = generateCentralDirectoryEnd(this.dirRecords.length, centralDirLength, localDirLength, this.zipComment, this.encodeFileName);\n\n    this.push({\n        data : dirEnd,\n        meta : {percent:100}\n    });\n};\n\n/**\n * Prepare the next source to be read.\n */\nZipFileWorker.prototype.prepareNextSource = function () {\n    this.previous = this._sources.shift();\n    this.openedSource(this.previous.streamInfo);\n    if (this.isPaused) {\n        this.previous.pause();\n    } else {\n        this.previous.resume();\n    }\n};\n\n/**\n * @see GenericWorker.registerPrevious\n */\nZipFileWorker.prototype.registerPrevious = function (previous) {\n    this._sources.push(previous);\n    var self = this;\n\n    previous.on('data', function (chunk) {\n        self.processChunk(chunk);\n    });\n    previous.on('end', function () {\n        self.closedSource(self.previous.streamInfo);\n        if(self._sources.length) {\n            self.prepareNextSource();\n        } else {\n            self.end();\n        }\n    });\n    previous.on('error', function (e) {\n        self.error(e);\n    });\n    return this;\n};\n\n/**\n * @see GenericWorker.resume\n */\nZipFileWorker.prototype.resume = function () {\n    if(!GenericWorker.prototype.resume.call(this)) {\n        return false;\n    }\n\n    if (!this.previous && this._sources.length) {\n        this.prepareNextSource();\n        return true;\n    }\n    if (!this.previous && !this._sources.length && !this.generatedError) {\n        this.end();\n        return true;\n    }\n};\n\n/**\n * @see GenericWorker.error\n */\nZipFileWorker.prototype.error = function (e) {\n    var sources = this._sources;\n    if(!GenericWorker.prototype.error.call(this, e)) {\n        return false;\n    }\n    for(var i = 0; i < sources.length; i++) {\n        try {\n            sources[i].error(e);\n        } catch(e) {\n            // the `error` exploded, nothing to do\n        }\n    }\n    return true;\n};\n\n/**\n * @see GenericWorker.lock\n */\nZipFileWorker.prototype.lock = function () {\n    GenericWorker.prototype.lock.call(this);\n    var sources = this._sources;\n    for(var i = 0; i < sources.length; i++) {\n        sources[i].lock();\n    }\n};\n\nmodule.exports = ZipFileWorker;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$jszip$lib$stream$GenericWorker","~$shadow.js","~$module$node_modules$jszip$lib$utf8","~$module$node_modules$jszip$lib$signature","~$module$node_modules$jszip$lib$utils","~$module$node_modules$jszip$lib$crc32"]],"~:properties",["^5",["prepareNextSource","percent","currentSourceOffset","dirRecord","_sources","closedSource","dirRecords","contentBuffer","openedSource","encodeFileName","zipComment","error","flush","currentFile","zipPlatform","push","fileRecord","bytesWritten","registerPrevious","streamFiles","previous","entriesCount","accumulate","meta","lock","data","resume"]],"~:compiled-at",1766065009567,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$generate$ZipFileWorker.js\",\n\"lineCount\":8,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAkU9DC,QAASA,EAAa,CAACC,CAAD,CAAcC,CAAd,CAAuBC,CAAvB,CAAiCC,CAAjC,CAAiD,CACnEC,CAAcC,CAAAA,IAAd,CAAmB,IAAnB,CAAyB,eAAzB,CAEA,KAAKC,CAAAA,YAAL,CAAoB,CAEpB,KAAKC,CAAAA,UAAL,CAAkBN,CAElB,KAAKO,CAAAA,WAAL,CAAmBN,CAEnB,KAAKC,CAAAA,cAAL,CAAsBA,CAEtB,KAAKH,CAAAA,WAAL,CAAmBA,CAKnB,KAAKS,CAAAA,UAAL,CAAkB,CAAA,CAElB,KAAKC,CAAAA,aAAL,CAAqB,EAErB,KAAKC,CAAAA,UAAL,CAAkB,EAIlB,KAAKC,CAAAA,YAAL,CAFA,IAAKC,CAAAA,mBAEL,CAF2B,CAK3B,KAAKC,CAAAA,WAAL,CAAmB,IAInB,KAAKC,CAAAA,QAAL,CAAgB,EA/BmD,CA/TvE,IAAIC,EAAQpB,CAAA,CAAQ,GAAR,CAAZ,CACIQ,EAAgBR,CAAA,CAAQ,GAAR,CADpB,CAEIqB,EAAOrB,CAAA,CAAQ,GAAR,CAFX,CAGIsB,EAAQtB,CAAA,CAAQ,GAAR,CAHZ,CAIIuB,EAAYvB,CAAA,CAAQ,GAAR,CAJhB,CAaIwB,EAAWA,QAAQ,CAACC,CAAD,CAAMC,CAAN,CAAa,CAAA,IAC5BC,EAAM,EADsB,CAClBC,CACd,KAAKA,CAAL,CAAS,CAAT,CAAYA,CAAZ,CAAgBF,CAAhB,CAAuBE,CAAA,EAAvB,CACID,CACM,EADCE,MAAOC,CAAAA,YAAP,CAAoBL,CAApB,CAA0B,GAA1B,CACD,CAAAA,CAAA,IAAQ,CAElB,OAAOE,EANyB,CAbpC,CA8EII,EAAmBA,QAAQ,CAACC,CAAD,CAAaC,CAAb,CAA8BC,CAA9B,CAA8CC,CAA9C,CAAsD7B,CAAtD,CAAgEC,CAAhE,CAAgF,CAAA,IACvG6B,EAAOJ,CAAA,CAAA,IADgG;AAE3GK,EAAcL,CAAA,CAAA,WAF6F,CAG3GM,EAAoB/B,CAApB+B,GAAuCjB,CAAKkB,CAAAA,UAH+D,CAI3GC,EAAkBpB,CAAMqB,CAAAA,WAAN,CAAkB,QAAlB,CAA4BlC,CAAA,CAAe6B,CAAKM,CAAAA,IAApB,CAA5B,CAJyF,CAK3GC,EAAqBvB,CAAMqB,CAAAA,WAAN,CAAkB,QAAlB,CAA4BpB,CAAKkB,CAAAA,UAAL,CAAgBH,CAAKM,CAAAA,IAArB,CAA5B,CALsF,CAM3GrC,EAAU+B,CAAK/B,CAAAA,OACfuC,EAAAA,CAAiBxB,CAAMqB,CAAAA,WAAN,CAAkB,QAAlB,CAA4BlC,CAAA,CAAeF,CAAf,CAA5B,CAP0F,KAQ3GwC,EAAoBzB,CAAMqB,CAAAA,WAAN,CAAkB,QAAlB,CAA4BpB,CAAKkB,CAAAA,UAAL,CAAgBlC,CAAhB,CAA5B,CARuF,CAS3GyC,EAAqBH,CAAmBI,CAAAA,MAAxCD,GAAmDV,CAAKM,CAAAA,IAAKK,CAAAA,MAT8C,CAU3GC,EAAoBH,CAAkBE,CAAAA,MAAtCC,GAAiD3C,CAAQ0C,CAAAA,MAGzDE,EAAAA,CAAc,EAGdC,KAAAA,EAAMd,CAAKc,CAAAA,GAfX,KAgBAC,EAAOf,CAAKe,CAAAA,IAhBZ,CAoBY,EAAA,CApBZ,CAqBqB,EAAA,CArBrB,CAsBuB,EAAA,CAKvB,IAAI,CAAClB,CAAL,EAAwBC,CAAxB,CACaZ,CAET,CAFiBU,CAAA,CAAA,KAEjB,CADSoB,CACT,CAD0BpB,CAAA,CAAA,cAC1B,CAASqB,CAAT,CAA4BrB,CAAA,CAAA,gBAG5BsB,EAAAA,CAAU,CACVrB,EAAJ,GAIIqB,CAJJ,EAIe,CAJf,CAMKhB,EAAL,EAA2BQ,CAAAA,CAA3B,EAAiDE,CAAAA,CAAjD,GAEIM,CAFJ,EAEe,IAFf,CAMIC,EAAAA,CAAc,CAEdL,EAAJ,GAEIK,CAFJ,EAEmB,EAFnB,CAIgB,OAAhB,GAAGjD,CAAH,EACIkD,CACA,CADgB,GAChB,EA9FAC,CA8FA,CAAiDC,CAAjD,CAA4CtB,CAAKsB,CAAAA,eAAjD,IAzFAD,CAyFA,CAAkEP,CAzFzD,CAAQ,KAAR,CAAiB,KAyF1B,EAAAK,CAAA,GAvFIE,CAuFJ,CAvFa,KAuFb,GAvFwB,EAqF5B,GAIID,CACA,CADgB,EAChB,CAAAD,CAAA,GAA2CnB,CAAKuB,CAAAA,cAAhD;AAvEsB,CAuEtB,EAvE4B,EAkEhC,CAaAC,EAAA,CAAUT,CAAKU,CAAAA,WAAL,EAEVD,EAAA,CADUA,CACV,EADqB,CACrB,CAAoBT,CAAKW,CAAAA,aAAL,EAEpBF,EAAA,CADUA,CACV,EADqB,CACrB,CAAoBT,CAAKY,CAAAA,aAAL,EAApB,CAA2C,CAE3CC,EAAA,CAAUb,CAAKc,CAAAA,cAAL,EAAV,CAAkC,IAElCD,EAAA,CADUA,CACV,EADqB,CACrB,CAAqBb,CAAKe,CAAAA,WAAL,EAArB,CAA0C,CAE1CF,EAAA,CADUA,CACV,EADqB,CACrB,CAAoBb,CAAKgB,CAAAA,UAAL,EAEhBrB,EAAJ,GAUIsB,CAQA,CANI5C,CAAA,CAAS,CAAT,CAAY,CAAZ,CAMJ,CAJIA,CAAA,CAASF,CAAA,CAAMkB,CAAN,CAAT,CAAiC,CAAjC,CAIJ,CAFIG,CAEJ,CAAAM,CAAA,EAEI,IAFJ,CAIIzB,CAAA,CAAS4C,CAAsBrB,CAAAA,MAA/B,CAAuC,CAAvC,CAJJ,CAMIqB,CAxBR,CA2BGpB,EAAH,GAEIqB,CAQA,CANI7C,CAAA,CAAS,CAAT,CAAY,CAAZ,CAMJ,CAJIA,CAAA,CAASF,CAAA,CAAMsB,CAAN,CAAT,CAAgC,CAAhC,CAIJ,CAFIC,CAEJ,CAAAI,CAAA,EAEI,IAFJ,CAIIzB,CAAA,CAAS6C,CAAyBtB,CAAAA,MAAlC,CAA0C,CAA1C,CAJJ,CAMIsB,CAhBR,CAwBAC,EAAA,CAFAA,QAEA,CAAU9C,CAAA,CAAS8B,CAAT,CAAkB,CAAlB,CAEVgB,EAAA,EAAUjC,CAAYkC,CAAAA,KAEtBD,EAAA,EAAU9C,CAAA,CAASoC,CAAT,CAAkB,CAAlB,CAEVU,EAAA,EAAU9C,CAAA,CAASwC,CAAT,CAAkB,CAAlB,CAEVM,EAAA,EAAU9C,CAAA,CAAkBF,CAAlB,CAAyB,CAAzB,CAEVgD,EAAA,EAAU9C,CAAA,CAAkB4B,CAAlB,CAAkC,CAAlC,CAEVkB,EAAA,EAAU9C,CAAA,CAAkB6B,CAAlB,CAAoC,CAApC,CAEViB,EAAA,EAAU9C,CAAA,CAASgB,CAAgBO,CAAAA,MAAzB,CAAiC,CAAjC,CAEVuB,EAAA,EAAU9C,CAAA,CAASyB,CAAYF,CAAAA,MAArB,CAA6B,CAA7B,CAGNyB,EAAAA,CAAajD,CAAUkD,CAAAA,iBAAvBD,CAA2CF,CAA3CE,CAAoDhC,CAApDgC,CAAsEvB,CAEtEyB,EAAAA,CAAYnD,CAAUoD,CAAAA,mBAAtBD,CAEAlD,CAAA,CAASgC,CAAT,CAAwB,CAAxB,CAFAkB,CAIAJ,CAJAI,CAMAlD,CAAA,CAASoB,CAAeG,CAAAA,MAAxB,CAAgC,CAAhC,CANA2B,CAQA,kBARAA,CAYAlD,CAAA,CAAS+B,CAAT,CAAsB,CAAtB,CAZAmB,CAcAlD,CAAA,CAASW,CAAT,CAAiB,CAAjB,CAdAuC,CAgBAlC,CAhBAkC,CAkBAzB,CAlBAyB,CAoBA9B,CAEJ,OAAO,CACH4B,WAAYA,CADT,CAEHE,UAAWA,CAFR,CA5KoG,CAkR/GtD;CAAMwD,CAAAA,QAAN,CAAezE,CAAf,CAA8BK,CAA9B,CAKAL,EAAc0E,CAAAA,SAAUC,CAAAA,IAAxB,CAA+BC,QAAS,CAACC,CAAD,CAAQ,CAE5C,IAAIC,EAAqBD,CAAME,CAAAA,IAAKC,CAAAA,OAAhCF,EAA2C,CAA/C,CACIjE,EAAe,IAAKA,CAAAA,YADxB,CAEIoE,EAAiB,IAAKjE,CAAAA,QAAS4B,CAAAA,MAEhC,KAAKlC,CAAAA,UAAR,CACI,IAAKC,CAAAA,aAAcgE,CAAAA,IAAnB,CAAwBE,CAAxB,CADJ,EAGI,IAAKtE,CAAAA,YAEL,EAFqBsE,CAAMK,CAAAA,IAAKtC,CAAAA,MAEhC,CAAAvC,CAAcqE,CAAAA,SAAUC,CAAAA,IAAKrE,CAAAA,IAA7B,CAAkC,IAAlC,CAAwC,CACpC4E,KAAOL,CAAMK,CAAAA,IADuB,CAEpCH,KAAO,CACHhE,YAAc,IAAKA,CAAAA,WADhB,CAEHiE,QAAUnE,CAAA,EAAgBiE,CAAhB,CAAqC,GAArC,EAA4CjE,CAA5C,CAA2DoE,CAA3D,CAA4E,CAA5E,GAAkFpE,CAAlF,CAAiG,GAFxG,CAF6B,CAAxC,CALJ,CAN4C,CAyBhDb,EAAc0E,CAAAA,SAAUS,CAAAA,YAAxB,CAAuCC,QAAS,CAACvD,CAAD,CAAa,CACzD,IAAKf,CAAAA,mBAAL,CAA2B,IAAKP,CAAAA,YAChC,KAAKQ,CAAAA,WAAL,CAAmBc,CAAA,CAAA,IAAmBU,CAAAA,IAEtC,KAAIT,EAAkB,IAAK7B,CAAAA,WAAvB6B,EAAsC,CAACD,CAAA,CAAA,IAAmBkB,CAAAA,GAG3DjB,EAAH,EACQuD,CACJ,CADazD,CAAA,CAAiBC,CAAjB,CAA6BC,CAA7B,CAA8C,CAAA,CAA9C,CAAqD,IAAKhB,CAAAA,mBAA1D,CAA+E,IAAKL,CAAAA,WAApF;AAAiG,IAAKL,CAAAA,cAAtG,CACb,CAAA,IAAKuE,CAAAA,IAAL,CAAU,CACNO,KAAOG,CAAOhB,CAAAA,UADR,CAENU,KAAO,CAACC,QAAQ,CAAT,CAFD,CAAV,CAFJ,EAQI,IAAKtE,CAAAA,UART,CAQsB,CAAA,CAfmC,CAuB7DV,EAAc0E,CAAAA,SAAUY,CAAAA,YAAxB,CAAuCC,QAAS,CAAC1D,CAAD,CAAa,CACzD,IAAKnB,CAAAA,UAAL,CAAkB,CAAA,CAClB,KAAIoB,EAAkB,IAAK7B,CAAAA,WAAvB6B,EAAsC,CAACD,CAAA,CAAA,IAAmBkB,CAAAA,GAA9D,CACIsC,EAASzD,CAAA,CAAiBC,CAAjB,CAA6BC,CAA7B,CAA8C,CAAA,CAA9C,CAAoD,IAAKhB,CAAAA,mBAAzD,CAA8E,IAAKL,CAAAA,WAAnF,CAAgG,IAAKL,CAAAA,cAArG,CAEb,KAAKQ,CAAAA,UAAW+D,CAAAA,IAAhB,CAAqBU,CAAOd,CAAAA,SAA5B,CACA,IAAGzC,CAAH,CAES6C,CAAL,CAAA,IAAKA,CAAAA,IAAL,CA1GJ,CA0GI,CAlHSvD,CAAUoE,CAAAA,eAkHnB,CAhHAnE,CAAA,CAiHmCQ,CAjH1B,CAAA,KAAT,CAA8B,CAA9B,CAgHA,CA9GAR,CAAA,CA+GmCQ,CA/G1B,CAAA,cAAT,CAAuC,CAAvC,CA8GA,CA5GAR,CAAA,CA6GmCQ,CA7G1B,CAAA,gBAAT,CAAyC,CAAzC,CA4GA,CAAK8C,CAAL,CAAA,IAAA,CAAA,IAAA,CAAU,CACNO,KAAO,CADD,CAENH,KAAO,CAACC,QAAQ,GAAT,CAFD,CAAV,CAFJ,KAaI,KAJA,IAAKL,CAAAA,IAAL,CAAU,CACNO,KAAOG,CAAOhB,CAAAA,UADR,CAENU,KAAO,CAACC,QAAQ,CAAT,CAFD,CAAV,CAIA,CAAM,IAAKrE,CAAAA,aAAciC,CAAAA,MAAzB,CAAA,CACI,IAAK+B,CAAAA,IAAL,CAAU,IAAKhE,CAAAA,aAAc8E,CAAAA,KAAnB,EAAV,CAGR;IAAK1E,CAAAA,WAAL,CAAmB,IAvBsC,CA6B7Df,EAAc0E,CAAAA,SAAUgB,CAAAA,KAAxB,CAAgCC,QAAS,EAAG,CAGxC,IADA,IAAIC,EAAiB,IAAKrF,CAAAA,YAA1B,CACQkB,EAAI,CAAZ,CAAeA,CAAf,CAAmB,IAAKb,CAAAA,UAAWgC,CAAAA,MAAnC,CAA2CnB,CAAA,EAA3C,CACI,IAAKkD,CAAAA,IAAL,CAAU,CACNO,KAAO,IAAKtE,CAAAA,UAAL,CAAgBa,CAAhB,CADD,CAENsD,KAAO,CAACC,QAAQ,GAAT,CAFD,CAAV,CAOqDpC,EAAAA,CAAhBA,IAAKhC,CAAAA,UAAWgC,CAAAA,MAAQiD,KAAAA,EAF1C,IAAKtF,CAAAA,YAEqCsF,CAFtBD,CAEsBC,CAlL7DpD,EAAiBxB,CAAMqB,CAAAA,WAAN,CAAkB,QAAlB,CAA4B,GAkLmE,IAAKlC,CAAAA,cAlLxE,EAkLkD,IAAKI,CAAAA,UAlLvD,CAA5B,CAqBrB,EAAA,CAlBSY,CAAU0E,CAAAA,qBAkBnB,CAhBI,kBAgBJ,CAZIzE,CAAA,CAASR,CAAT,CAAuB,CAAvB,CAYJ,CAVIQ,CAAA,CAASR,CAAT,CAAuB,CAAvB,CAUJ,CARIQ,CAAA,CAASwE,CAAT,CAA2B,CAA3B,CAQJ,CANIxE,CAAA,CAmK+EuE,CAnK/E,CAAyB,CAAzB,CAMJ,CAJIvE,CAAA,CAASoB,CAAeG,CAAAA,MAAxB,CAAgC,CAAhC,CAIJ,CAFIH,CAiKJ,KAAKkC,CAAAA,IAAL,CAAU,CACNO,KAAOa,CADD,CAENhB,KAAO,CAACC,QAAQ,GAAT,CAFD,CAAV,CAbwC,CAsB5ChF,EAAc0E,CAAAA,SAAUsB,CAAAA,iBAAxB,CAA4CC,QAAS,EAAG,CACpD,IAAKC,CAAAA,QAAL,CAAgB,IAAKlF,CAAAA,QAASyE,CAAAA,KAAd,EAChB,KAAKN,CAAAA,YAAL,CAAkB,IAAKe,CAAAA,QAASrE,CAAAA,UAAhC,CACI;IAAKsE,CAAAA,QAAT,CACI,IAAKD,CAAAA,QAASE,CAAAA,KAAd,EADJ,CAGI,IAAKF,CAAAA,QAASG,CAAAA,MAAd,EANgD,CAaxDrG,EAAc0E,CAAAA,SAAU4B,CAAAA,gBAAxB,CAA2CC,QAAS,CAACL,CAAD,CAAW,CAC3D,IAAKlF,CAAAA,QAAS2D,CAAAA,IAAd,CAAmBuB,CAAnB,CACA,KAAIM,EAAO,IAEXN,EAASO,CAAAA,EAAT,CAAY,MAAZ,CAAoB,QAAS,CAAC5B,CAAD,CAAQ,CACjC2B,CAAKE,CAAAA,YAAL,CAAkB7B,CAAlB,CADiC,CAArC,CAGAqB,EAASO,CAAAA,EAAT,CAAY,KAAZ,CAAmB,QAAS,EAAG,CAC3BD,CAAKlB,CAAAA,YAAL,CAAkBkB,CAAKN,CAAAA,QAASrE,CAAAA,UAAhC,CACG2E,EAAKxF,CAAAA,QAAS4B,CAAAA,MAAjB,CACI4D,CAAKR,CAAAA,iBAAL,EADJ,CAGIQ,CAAKG,CAAAA,GAAL,EALuB,CAA/B,CAQAT,EAASO,CAAAA,EAAT,CAAY,OAAZ,CAAqB,QAAS,CAACG,CAAD,CAAI,CAC9BJ,CAAKK,CAAAA,KAAL,CAAWD,CAAX,CAD8B,CAAlC,CAGA,OAAO,KAlBoD,CAwB/D5G,EAAc0E,CAAAA,SAAU2B,CAAAA,MAAxB,CAAiCS,QAAS,EAAG,CACzC,GAAG,CAACzG,CAAcqE,CAAAA,SAAU2B,CAAAA,MAAO/F,CAAAA,IAA/B,CAAoC,IAApC,CAAJ,CACI,MAAO,CAAA,CAGX,IAAI,CAAC,IAAK4F,CAAAA,QAAV,EAAsB,IAAKlF,CAAAA,QAAS4B,CAAAA,MAApC,CAEI,MADA,KAAKoD,CAAAA,iBAAL,EACO,CAAA,CAAA,CAEX,IAAI,CAAC,IAAKE,CAAAA,QAAV;AAAsB,CAAC,IAAKlF,CAAAA,QAAS4B,CAAAA,MAArC,EAA+C,CAAC,IAAKmE,CAAAA,cAArD,CAEI,MADA,KAAKJ,CAAAA,GAAL,EACO,CAAA,CAAA,CAX8B,CAkB7C3G,EAAc0E,CAAAA,SAAUmC,CAAAA,KAAxB,CAAgCG,QAAS,CAACJ,CAAD,CAAI,CACzC,IAAIK,EAAU,IAAKjG,CAAAA,QACnB,IAAG,CAACX,CAAcqE,CAAAA,SAAUmC,CAAAA,KAAMvG,CAAAA,IAA9B,CAAmC,IAAnC,CAAyCsG,CAAzC,CAAJ,CACI,MAAO,CAAA,CAEX,KAAI,IAAInF,EAAI,CAAZ,CAAeA,CAAf,CAAmBwF,CAAQrE,CAAAA,MAA3B,CAAmCnB,CAAA,EAAnC,CACI,GAAI,CACAwF,CAAA,CAAQxF,CAAR,CAAWoF,CAAAA,KAAX,CAAiBD,CAAjB,CADA,CAEF,MAAMA,CAAN,CAAS,EAIf,MAAO,CAAA,CAZkC,CAkB7C5G,EAAc0E,CAAAA,SAAUwC,CAAAA,IAAxB,CAA+BC,QAAS,EAAG,CACvC9G,CAAcqE,CAAAA,SAAUwC,CAAAA,IAAK5G,CAAAA,IAA7B,CAAkC,IAAlC,CAEA,KADA,IAAI2G,EAAU,IAAKjG,CAAAA,QAAnB,CACQS,EAAI,CAAZ,CAAeA,CAAf,CAAmBwF,CAAQrE,CAAAA,MAA3B,CAAmCnB,CAAA,EAAnC,CACIwF,CAAA,CAAQxF,CAAR,CAAWyF,CAAAA,IAAX,EAJmC,CAQ3CpH,GAAOC,CAAAA,OAAP,CAAiBC,CA5hB6C;\",\n\"sources\":[\"node_modules/jszip/lib/generate/ZipFileWorker.js\"],\n\"sourcesContent\":[\"shadow$provide[188] = function(global,require,module,exports) {\\n'use strict';\\n\\nvar utils = require('../utils');\\nvar GenericWorker = require('../stream/GenericWorker');\\nvar utf8 = require('../utf8');\\nvar crc32 = require('../crc32');\\nvar signature = require('../signature');\\n\\n/**\\n * Transform an integer into a string in hexadecimal.\\n * @private\\n * @param {number} dec the number to convert.\\n * @param {number} bytes the number of bytes to generate.\\n * @returns {string} the result.\\n */\\nvar decToHex = function(dec, bytes) {\\n    var hex = \\\"\\\", i;\\n    for (i = 0; i < bytes; i++) {\\n        hex += String.fromCharCode(dec & 0xff);\\n        dec = dec >>> 8;\\n    }\\n    return hex;\\n};\\n\\n/**\\n * Generate the UNIX part of the external file attributes.\\n * @param {Object} unixPermissions the unix permissions or null.\\n * @param {Boolean} isDir true if the entry is a directory, false otherwise.\\n * @return {Number} a 32 bit integer.\\n *\\n * adapted from http://unix.stackexchange.com/questions/14705/the-zip-formats-external-file-attribute :\\n *\\n * TTTTsstrwxrwxrwx0000000000ADVSHR\\n * ^^^^____________________________ file type, see zipinfo.c (UNX_*)\\n *     ^^^_________________________ setuid, setgid, sticky\\n *        ^^^^^^^^^________________ permissions\\n *                 ^^^^^^^^^^______ not used ?\\n *                           ^^^^^^ DOS attribute bits : Archive, Directory, Volume label, System file, Hidden, Read only\\n */\\nvar generateUnixExternalFileAttr = function (unixPermissions, isDir) {\\n\\n    var result = unixPermissions;\\n    if (!unixPermissions) {\\n        // I can't use octal values in strict mode, hence the hexa.\\n        //  040775 => 0x41fd\\n        // 0100664 => 0x81b4\\n        result = isDir ? 0x41fd : 0x81b4;\\n    }\\n    return (result & 0xFFFF) << 16;\\n};\\n\\n/**\\n * Generate the DOS part of the external file attributes.\\n * @param {Object} dosPermissions the dos permissions or null.\\n * @param {Boolean} isDir true if the entry is a directory, false otherwise.\\n * @return {Number} a 32 bit integer.\\n *\\n * Bit 0     Read-Only\\n * Bit 1     Hidden\\n * Bit 2     System\\n * Bit 3     Volume Label\\n * Bit 4     Directory\\n * Bit 5     Archive\\n */\\nvar generateDosExternalFileAttr = function (dosPermissions, isDir) {\\n\\n    // the dir flag is already set for compatibility\\n    return (dosPermissions || 0)  & 0x3F;\\n};\\n\\n/**\\n * Generate the various parts used in the construction of the final zip file.\\n * @param {Object} streamInfo the hash with information about the compressed file.\\n * @param {Boolean} streamedContent is the content streamed ?\\n * @param {Boolean} streamingEnded is the stream finished ?\\n * @param {number} offset the current offset from the start of the zip file.\\n * @param {String} platform let's pretend we are this platform (change platform dependents fields)\\n * @param {Function} encodeFileName the function to encode the file name / comment.\\n * @return {Object} the zip parts.\\n */\\nvar generateZipParts = function(streamInfo, streamedContent, streamingEnded, offset, platform, encodeFileName) {\\n    var file = streamInfo['file'],\\n    compression = streamInfo['compression'],\\n    useCustomEncoding = encodeFileName !== utf8.utf8encode,\\n    encodedFileName = utils.transformTo(\\\"string\\\", encodeFileName(file.name)),\\n    utfEncodedFileName = utils.transformTo(\\\"string\\\", utf8.utf8encode(file.name)),\\n    comment = file.comment,\\n    encodedComment = utils.transformTo(\\\"string\\\", encodeFileName(comment)),\\n    utfEncodedComment = utils.transformTo(\\\"string\\\", utf8.utf8encode(comment)),\\n    useUTF8ForFileName = utfEncodedFileName.length !== file.name.length,\\n    useUTF8ForComment = utfEncodedComment.length !== comment.length,\\n    dosTime,\\n    dosDate,\\n    extraFields = \\\"\\\",\\n    unicodePathExtraField = \\\"\\\",\\n    unicodeCommentExtraField = \\\"\\\",\\n    dir = file.dir,\\n    date = file.date;\\n\\n\\n    var dataInfo = {\\n        crc32 : 0,\\n        compressedSize : 0,\\n        uncompressedSize : 0\\n    };\\n\\n    // if the content is streamed, the sizes/crc32 are only available AFTER\\n    // the end of the stream.\\n    if (!streamedContent || streamingEnded) {\\n        dataInfo.crc32 = streamInfo['crc32'];\\n        dataInfo.compressedSize = streamInfo['compressedSize'];\\n        dataInfo.uncompressedSize = streamInfo['uncompressedSize'];\\n    }\\n\\n    var bitflag = 0;\\n    if (streamedContent) {\\n        // Bit 3: the sizes/crc32 are set to zero in the local header.\\n        // The correct values are put in the data descriptor immediately\\n        // following the compressed data.\\n        bitflag |= 0x0008;\\n    }\\n    if (!useCustomEncoding && (useUTF8ForFileName || useUTF8ForComment)) {\\n        // Bit 11: Language encoding flag (EFS).\\n        bitflag |= 0x0800;\\n    }\\n\\n\\n    var extFileAttr = 0;\\n    var versionMadeBy = 0;\\n    if (dir) {\\n        // dos or unix, we set the dos dir flag\\n        extFileAttr |= 0x00010;\\n    }\\n    if(platform === \\\"UNIX\\\") {\\n        versionMadeBy = 0x031E; // UNIX, version 3.0\\n        extFileAttr |= generateUnixExternalFileAttr(file.unixPermissions, dir);\\n    } else { // DOS or other, fallback to DOS\\n        versionMadeBy = 0x0014; // DOS, version 2.0\\n        extFileAttr |= generateDosExternalFileAttr(file.dosPermissions, dir);\\n    }\\n\\n    // date\\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/52/13.html\\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/65/16.html\\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/66/16.html\\n\\n    dosTime = date.getUTCHours();\\n    dosTime = dosTime << 6;\\n    dosTime = dosTime | date.getUTCMinutes();\\n    dosTime = dosTime << 5;\\n    dosTime = dosTime | date.getUTCSeconds() / 2;\\n\\n    dosDate = date.getUTCFullYear() - 1980;\\n    dosDate = dosDate << 4;\\n    dosDate = dosDate | (date.getUTCMonth() + 1);\\n    dosDate = dosDate << 5;\\n    dosDate = dosDate | date.getUTCDate();\\n\\n    if (useUTF8ForFileName) {\\n        // set the unicode path extra field. unzip needs at least one extra\\n        // field to correctly handle unicode path, so using the path is as good\\n        // as any other information. This could improve the situation with\\n        // other archive managers too.\\n        // This field is usually used without the utf8 flag, with a non\\n        // unicode path in the header (winrar, winzip). This helps (a bit)\\n        // with the messy Windows' default compressed folders feature but\\n        // breaks on p7zip which doesn't seek the unicode path extra field.\\n        // So for now, UTF-8 everywhere !\\n        unicodePathExtraField =\\n            // Version\\n            decToHex(1, 1) +\\n            // NameCRC32\\n            decToHex(crc32(encodedFileName), 4) +\\n            // UnicodeName\\n            utfEncodedFileName;\\n\\n        extraFields +=\\n            // Info-ZIP Unicode Path Extra Field\\n            \\\"\\\\x75\\\\x70\\\" +\\n            // size\\n            decToHex(unicodePathExtraField.length, 2) +\\n            // content\\n            unicodePathExtraField;\\n    }\\n\\n    if(useUTF8ForComment) {\\n\\n        unicodeCommentExtraField =\\n            // Version\\n            decToHex(1, 1) +\\n            // CommentCRC32\\n            decToHex(crc32(encodedComment), 4) +\\n            // UnicodeName\\n            utfEncodedComment;\\n\\n        extraFields +=\\n            // Info-ZIP Unicode Path Extra Field\\n            \\\"\\\\x75\\\\x63\\\" +\\n            // size\\n            decToHex(unicodeCommentExtraField.length, 2) +\\n            // content\\n            unicodeCommentExtraField;\\n    }\\n\\n    var header = \\\"\\\";\\n\\n    // version needed to extract\\n    header += \\\"\\\\x0A\\\\x00\\\";\\n    // general purpose bit flag\\n    header += decToHex(bitflag, 2);\\n    // compression method\\n    header += compression.magic;\\n    // last mod file time\\n    header += decToHex(dosTime, 2);\\n    // last mod file date\\n    header += decToHex(dosDate, 2);\\n    // crc-32\\n    header += decToHex(dataInfo.crc32, 4);\\n    // compressed size\\n    header += decToHex(dataInfo.compressedSize, 4);\\n    // uncompressed size\\n    header += decToHex(dataInfo.uncompressedSize, 4);\\n    // file name length\\n    header += decToHex(encodedFileName.length, 2);\\n    // extra field length\\n    header += decToHex(extraFields.length, 2);\\n\\n\\n    var fileRecord = signature.LOCAL_FILE_HEADER + header + encodedFileName + extraFields;\\n\\n    var dirRecord = signature.CENTRAL_FILE_HEADER +\\n        // version made by (00: DOS)\\n        decToHex(versionMadeBy, 2) +\\n        // file header (common to file and central directory)\\n        header +\\n        // file comment length\\n        decToHex(encodedComment.length, 2) +\\n        // disk number start\\n        \\\"\\\\x00\\\\x00\\\" +\\n        // internal file attributes TODO\\n        \\\"\\\\x00\\\\x00\\\" +\\n        // external file attributes\\n        decToHex(extFileAttr, 4) +\\n        // relative offset of local header\\n        decToHex(offset, 4) +\\n        // file name\\n        encodedFileName +\\n        // extra field\\n        extraFields +\\n        // file comment\\n        encodedComment;\\n\\n    return {\\n        fileRecord: fileRecord,\\n        dirRecord: dirRecord\\n    };\\n};\\n\\n/**\\n * Generate the EOCD record.\\n * @param {Number} entriesCount the number of entries in the zip file.\\n * @param {Number} centralDirLength the length (in bytes) of the central dir.\\n * @param {Number} localDirLength the length (in bytes) of the local dir.\\n * @param {String} comment the zip file comment as a binary string.\\n * @param {Function} encodeFileName the function to encode the comment.\\n * @return {String} the EOCD record.\\n */\\nvar generateCentralDirectoryEnd = function (entriesCount, centralDirLength, localDirLength, comment, encodeFileName) {\\n    var dirEnd = \\\"\\\";\\n    var encodedComment = utils.transformTo(\\\"string\\\", encodeFileName(comment));\\n\\n    // end of central dir signature\\n    dirEnd = signature.CENTRAL_DIRECTORY_END +\\n        // number of this disk\\n        \\\"\\\\x00\\\\x00\\\" +\\n        // number of the disk with the start of the central directory\\n        \\\"\\\\x00\\\\x00\\\" +\\n        // total number of entries in the central directory on this disk\\n        decToHex(entriesCount, 2) +\\n        // total number of entries in the central directory\\n        decToHex(entriesCount, 2) +\\n        // size of the central directory   4 bytes\\n        decToHex(centralDirLength, 4) +\\n        // offset of start of central directory with respect to the starting disk number\\n        decToHex(localDirLength, 4) +\\n        // .ZIP file comment length\\n        decToHex(encodedComment.length, 2) +\\n        // .ZIP file comment\\n        encodedComment;\\n\\n    return dirEnd;\\n};\\n\\n/**\\n * Generate data descriptors for a file entry.\\n * @param {Object} streamInfo the hash generated by a worker, containing information\\n * on the file entry.\\n * @return {String} the data descriptors.\\n */\\nvar generateDataDescriptors = function (streamInfo) {\\n    var descriptor = \\\"\\\";\\n    descriptor = signature.DATA_DESCRIPTOR +\\n        // crc-32                          4 bytes\\n        decToHex(streamInfo['crc32'], 4) +\\n        // compressed size                 4 bytes\\n        decToHex(streamInfo['compressedSize'], 4) +\\n        // uncompressed size               4 bytes\\n        decToHex(streamInfo['uncompressedSize'], 4);\\n\\n    return descriptor;\\n};\\n\\n\\n/**\\n * A worker to concatenate other workers to create a zip file.\\n * @param {Boolean} streamFiles `true` to stream the content of the files,\\n * `false` to accumulate it.\\n * @param {String} comment the comment to use.\\n * @param {String} platform the platform to use, \\\"UNIX\\\" or \\\"DOS\\\".\\n * @param {Function} encodeFileName the function to encode file names and comments.\\n */\\nfunction ZipFileWorker(streamFiles, comment, platform, encodeFileName) {\\n    GenericWorker.call(this, \\\"ZipFileWorker\\\");\\n    // The number of bytes written so far. This doesn't count accumulated chunks.\\n    this.bytesWritten = 0;\\n    // The comment of the zip file\\n    this.zipComment = comment;\\n    // The platform \\\"generating\\\" the zip file.\\n    this.zipPlatform = platform;\\n    // the function to encode file names and comments.\\n    this.encodeFileName = encodeFileName;\\n    // Should we stream the content of the files ?\\n    this.streamFiles = streamFiles;\\n    // If `streamFiles` is false, we will need to accumulate the content of the\\n    // files to calculate sizes / crc32 (and write them *before* the content).\\n    // This boolean indicates if we are accumulating chunks (it will change a lot\\n    // during the lifetime of this worker).\\n    this.accumulate = false;\\n    // The buffer receiving chunks when accumulating content.\\n    this.contentBuffer = [];\\n    // The list of generated directory records.\\n    this.dirRecords = [];\\n    // The offset (in bytes) from the beginning of the zip file for the current source.\\n    this.currentSourceOffset = 0;\\n    // The total number of entries in this zip file.\\n    this.entriesCount = 0;\\n    // the name of the file currently being added, null when handling the end of the zip file.\\n    // Used for the emitted metadata.\\n    this.currentFile = null;\\n\\n\\n\\n    this._sources = [];\\n}\\nutils.inherits(ZipFileWorker, GenericWorker);\\n\\n/**\\n * @see GenericWorker.push\\n */\\nZipFileWorker.prototype.push = function (chunk) {\\n\\n    var currentFilePercent = chunk.meta.percent || 0;\\n    var entriesCount = this.entriesCount;\\n    var remainingFiles = this._sources.length;\\n\\n    if(this.accumulate) {\\n        this.contentBuffer.push(chunk);\\n    } else {\\n        this.bytesWritten += chunk.data.length;\\n\\n        GenericWorker.prototype.push.call(this, {\\n            data : chunk.data,\\n            meta : {\\n                currentFile : this.currentFile,\\n                percent : entriesCount ? (currentFilePercent + 100 * (entriesCount - remainingFiles - 1)) / entriesCount : 100\\n            }\\n        });\\n    }\\n};\\n\\n/**\\n * The worker started a new source (an other worker).\\n * @param {Object} streamInfo the streamInfo object from the new source.\\n */\\nZipFileWorker.prototype.openedSource = function (streamInfo) {\\n    this.currentSourceOffset = this.bytesWritten;\\n    this.currentFile = streamInfo['file'].name;\\n\\n    var streamedContent = this.streamFiles && !streamInfo['file'].dir;\\n\\n    // don't stream folders (because they don't have any content)\\n    if(streamedContent) {\\n        var record = generateZipParts(streamInfo, streamedContent, false, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);\\n        this.push({\\n            data : record.fileRecord,\\n            meta : {percent:0}\\n        });\\n    } else {\\n        // we need to wait for the whole file before pushing anything\\n        this.accumulate = true;\\n    }\\n};\\n\\n/**\\n * The worker finished a source (an other worker).\\n * @param {Object} streamInfo the streamInfo object from the finished source.\\n */\\nZipFileWorker.prototype.closedSource = function (streamInfo) {\\n    this.accumulate = false;\\n    var streamedContent = this.streamFiles && !streamInfo['file'].dir;\\n    var record = generateZipParts(streamInfo, streamedContent, true, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);\\n\\n    this.dirRecords.push(record.dirRecord);\\n    if(streamedContent) {\\n        // after the streamed file, we put data descriptors\\n        this.push({\\n            data : generateDataDescriptors(streamInfo),\\n            meta : {percent:100}\\n        });\\n    } else {\\n        // the content wasn't streamed, we need to push everything now\\n        // first the file record, then the content\\n        this.push({\\n            data : record.fileRecord,\\n            meta : {percent:0}\\n        });\\n        while(this.contentBuffer.length) {\\n            this.push(this.contentBuffer.shift());\\n        }\\n    }\\n    this.currentFile = null;\\n};\\n\\n/**\\n * @see GenericWorker.flush\\n */\\nZipFileWorker.prototype.flush = function () {\\n\\n    var localDirLength = this.bytesWritten;\\n    for(var i = 0; i < this.dirRecords.length; i++) {\\n        this.push({\\n            data : this.dirRecords[i],\\n            meta : {percent:100}\\n        });\\n    }\\n    var centralDirLength = this.bytesWritten - localDirLength;\\n\\n    var dirEnd = generateCentralDirectoryEnd(this.dirRecords.length, centralDirLength, localDirLength, this.zipComment, this.encodeFileName);\\n\\n    this.push({\\n        data : dirEnd,\\n        meta : {percent:100}\\n    });\\n};\\n\\n/**\\n * Prepare the next source to be read.\\n */\\nZipFileWorker.prototype.prepareNextSource = function () {\\n    this.previous = this._sources.shift();\\n    this.openedSource(this.previous.streamInfo);\\n    if (this.isPaused) {\\n        this.previous.pause();\\n    } else {\\n        this.previous.resume();\\n    }\\n};\\n\\n/**\\n * @see GenericWorker.registerPrevious\\n */\\nZipFileWorker.prototype.registerPrevious = function (previous) {\\n    this._sources.push(previous);\\n    var self = this;\\n\\n    previous.on('data', function (chunk) {\\n        self.processChunk(chunk);\\n    });\\n    previous.on('end', function () {\\n        self.closedSource(self.previous.streamInfo);\\n        if(self._sources.length) {\\n            self.prepareNextSource();\\n        } else {\\n            self.end();\\n        }\\n    });\\n    previous.on('error', function (e) {\\n        self.error(e);\\n    });\\n    return this;\\n};\\n\\n/**\\n * @see GenericWorker.resume\\n */\\nZipFileWorker.prototype.resume = function () {\\n    if(!GenericWorker.prototype.resume.call(this)) {\\n        return false;\\n    }\\n\\n    if (!this.previous && this._sources.length) {\\n        this.prepareNextSource();\\n        return true;\\n    }\\n    if (!this.previous && !this._sources.length && !this.generatedError) {\\n        this.end();\\n        return true;\\n    }\\n};\\n\\n/**\\n * @see GenericWorker.error\\n */\\nZipFileWorker.prototype.error = function (e) {\\n    var sources = this._sources;\\n    if(!GenericWorker.prototype.error.call(this, e)) {\\n        return false;\\n    }\\n    for(var i = 0; i < sources.length; i++) {\\n        try {\\n            sources[i].error(e);\\n        } catch(e) {\\n            // the `error` exploded, nothing to do\\n        }\\n    }\\n    return true;\\n};\\n\\n/**\\n * @see GenericWorker.lock\\n */\\nZipFileWorker.prototype.lock = function () {\\n    GenericWorker.prototype.lock.call(this);\\n    var sources = this._sources;\\n    for(var i = 0; i < sources.length; i++) {\\n        sources[i].lock();\\n    }\\n};\\n\\nmodule.exports = ZipFileWorker;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"ZipFileWorker\",\"streamFiles\",\"comment\",\"platform\",\"encodeFileName\",\"GenericWorker\",\"call\",\"bytesWritten\",\"zipComment\",\"zipPlatform\",\"accumulate\",\"contentBuffer\",\"dirRecords\",\"entriesCount\",\"currentSourceOffset\",\"currentFile\",\"_sources\",\"utils\",\"utf8\",\"crc32\",\"signature\",\"decToHex\",\"dec\",\"bytes\",\"hex\",\"i\",\"String\",\"fromCharCode\",\"generateZipParts\",\"streamInfo\",\"streamedContent\",\"streamingEnded\",\"offset\",\"file\",\"compression\",\"useCustomEncoding\",\"utf8encode\",\"encodedFileName\",\"transformTo\",\"name\",\"utfEncodedFileName\",\"encodedComment\",\"utfEncodedComment\",\"useUTF8ForFileName\",\"length\",\"useUTF8ForComment\",\"extraFields\",\"dir\",\"date\",\"compressedSize\",\"uncompressedSize\",\"bitflag\",\"extFileAttr\",\"versionMadeBy\",\"result\",\"unixPermissions\",\"dosPermissions\",\"dosTime\",\"getUTCHours\",\"getUTCMinutes\",\"getUTCSeconds\",\"dosDate\",\"getUTCFullYear\",\"getUTCMonth\",\"getUTCDate\",\"unicodePathExtraField\",\"unicodeCommentExtraField\",\"header\",\"magic\",\"fileRecord\",\"LOCAL_FILE_HEADER\",\"dirRecord\",\"CENTRAL_FILE_HEADER\",\"inherits\",\"prototype\",\"push\",\"ZipFileWorker.prototype.push\",\"chunk\",\"currentFilePercent\",\"meta\",\"percent\",\"remainingFiles\",\"data\",\"openedSource\",\"ZipFileWorker.prototype.openedSource\",\"record\",\"closedSource\",\"ZipFileWorker.prototype.closedSource\",\"DATA_DESCRIPTOR\",\"shift\",\"flush\",\"ZipFileWorker.prototype.flush\",\"localDirLength\",\"centralDirLength\",\"CENTRAL_DIRECTORY_END\",\"dirEnd\",\"prepareNextSource\",\"ZipFileWorker.prototype.prepareNextSource\",\"previous\",\"isPaused\",\"pause\",\"resume\",\"registerPrevious\",\"ZipFileWorker.prototype.registerPrevious\",\"self\",\"on\",\"processChunk\",\"end\",\"e\",\"error\",\"ZipFileWorker.prototype.resume\",\"generatedError\",\"ZipFileWorker.prototype.error\",\"sources\",\"lock\",\"ZipFileWorker.prototype.lock\"]\n}\n"]