["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/compressedObject.js"],"~:js","shadow$provide[167]=function(ra,X,Ra,P){function w(u,A,y,x,Q){this.compressedSize=u;this.uncompressedSize=A;this.crc32=y;this.compression=x;this.compressedContent=Q}var Z=X(155),B=X(163),p=X(165),c=X(166);w.prototype={getContentWorker:function(){var u=(new B(Z.Promise.resolve(this.compressedContent))).pipe(this.compression.uncompressWorker()).pipe(new c(\"data_length\")),A=this;u.on(\"end\",function(){if(this.streamInfo.data_length!==A.uncompressedSize)throw Error(\"Bug : uncompressed data size mismatch\");\n});return u},getCompressedWorker:function(){return(new B(Z.Promise.resolve(this.compressedContent))).withStreamInfo(\"compressedSize\",this.compressedSize).withStreamInfo(\"uncompressedSize\",this.uncompressedSize).withStreamInfo(\"crc32\",this.crc32).withStreamInfo(\"compression\",this.compression)}};w.createWorkerFrom=function(u,A,y){return u.pipe(new p).pipe(new c(\"uncompressedSize\")).pipe(A.compressWorker(y)).pipe(new c(\"compressedSize\")).withStreamInfo(\"compression\",A)};Ra.exports=w}","~:source","shadow$provide[167] = function(global,require,module,exports) {\n'use strict';\n\nvar external = require(\"./external\");\nvar DataWorker = require('./stream/DataWorker');\nvar Crc32Probe = require('./stream/Crc32Probe');\nvar DataLengthProbe = require('./stream/DataLengthProbe');\n\n/**\n * Represent a compressed object, with everything needed to decompress it.\n * @constructor\n * @param {number} compressedSize the size of the data compressed.\n * @param {number} uncompressedSize the size of the data after decompression.\n * @param {number} crc32 the crc32 of the decompressed file.\n * @param {object} compression the type of compression, see lib/compressions.js.\n * @param {String|ArrayBuffer|Uint8Array|Buffer} data the compressed data.\n */\nfunction CompressedObject(compressedSize, uncompressedSize, crc32, compression, data) {\n    this.compressedSize = compressedSize;\n    this.uncompressedSize = uncompressedSize;\n    this.crc32 = crc32;\n    this.compression = compression;\n    this.compressedContent = data;\n}\n\nCompressedObject.prototype = {\n    /**\n     * Create a worker to get the uncompressed content.\n     * @return {GenericWorker} the worker.\n     */\n    getContentWorker: function () {\n        var worker = new DataWorker(external.Promise.resolve(this.compressedContent))\n            .pipe(this.compression.uncompressWorker())\n            .pipe(new DataLengthProbe(\"data_length\"));\n\n        var that = this;\n        worker.on(\"end\", function () {\n            if (this.streamInfo['data_length'] !== that.uncompressedSize) {\n                throw new Error(\"Bug : uncompressed data size mismatch\");\n            }\n        });\n        return worker;\n    },\n    /**\n     * Create a worker to get the compressed content.\n     * @return {GenericWorker} the worker.\n     */\n    getCompressedWorker: function () {\n        return new DataWorker(external.Promise.resolve(this.compressedContent))\n            .withStreamInfo(\"compressedSize\", this.compressedSize)\n            .withStreamInfo(\"uncompressedSize\", this.uncompressedSize)\n            .withStreamInfo(\"crc32\", this.crc32)\n            .withStreamInfo(\"compression\", this.compression)\n            ;\n    }\n};\n\n/**\n * Chain the given worker with other workers to compress the content with the\n * given compression.\n * @param {GenericWorker} uncompressedWorker the worker to pipe.\n * @param {Object} compression the compression object.\n * @param {Object} compressionOptions the options to use when compressing.\n * @return {GenericWorker} the new worker compressing the content.\n */\nCompressedObject.createWorkerFrom = function (uncompressedWorker, compression, compressionOptions) {\n    return uncompressedWorker\n        .pipe(new Crc32Probe())\n        .pipe(new DataLengthProbe(\"uncompressedSize\"))\n        .pipe(compression.compressWorker(compressionOptions))\n        .pipe(new DataLengthProbe(\"compressedSize\"))\n        .withStreamInfo(\"compression\", compression);\n};\n\nmodule.exports = CompressedObject;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$jszip$lib$stream$Crc32Probe","~$module$node_modules$jszip$lib$stream$DataLengthProbe","~$module$node_modules$jszip$lib$stream$DataWorker","~$module$node_modules$jszip$lib$external"]],"~:properties",["^5",["prototype","compression","uncompressedSize","getContentWorker","compressedContent","crc32","getCompressedWorker","compressedSize","createWorkerFrom"]],"~:compiled-at",1766065009557,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$compressedObject.js\",\n\"lineCount\":2,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAiB9DC,QAASA,EAAgB,CAACC,CAAD,CAAiBC,CAAjB,CAAmCC,CAAnC,CAA0CC,CAA1C,CAAuDC,CAAvD,CAA6D,CAClF,IAAKJ,CAAAA,cAAL,CAAsBA,CACtB,KAAKC,CAAAA,gBAAL,CAAwBA,CACxB,KAAKC,CAAAA,KAAL,CAAaA,CACb,KAAKC,CAAAA,WAAL,CAAmBA,CACnB,KAAKE,CAAAA,iBAAL,CAAyBD,CALyD,CAdtF,IAAIE,EAAWV,CAAA,CAAQ,GAAR,CAAf,CACIW,EAAaX,CAAA,CAAQ,GAAR,CADjB,CAEIY,EAAaZ,CAAA,CAAQ,GAAR,CAFjB,CAGIa,EAAkBb,CAAA,CAAQ,GAAR,CAmBtBG,EAAiBW,CAAAA,SAAjB,CAA6B,CAKzBC,iBAAkBA,QAAS,EAAG,CAC1B,IAAIC,EACCC,CADQ,IAAIN,CAAJ,CAAeD,CAASQ,CAAAA,OAAQC,CAAAA,OAAjB,CAAyB,IAAKV,CAAAA,iBAA9B,CAAf,CACRQ,EAAAA,IADQ,CACH,IAAKV,CAAAA,WAAYa,CAAAA,gBAAjB,EADG,CAERH,CAAAA,IAFQ,CAEH,IAAIJ,CAAJ,CAAoB,aAApB,CAFG,CAAb,CAIIQ,EAAO,IACXL,EAAOM,CAAAA,EAAP,CAAU,KAAV,CAAiB,QAAS,EAAG,CACzB,GAAI,IAAKC,CAAAA,UAAL,CAAA,WAAJ,GAAuCF,CAAKhB,CAAAA,gBAA5C,CACI,KAAUmB,MAAJ,CAAU,uCAAV,CAAN;AAFqB,CAA7B,CAKA,OAAOR,EAXmB,CALL,CAsBzBS,oBAAqBA,QAAS,EAAG,CAC7B,MACKC,CADE,IAAIf,CAAJ,CAAeD,CAASQ,CAAAA,OAAQC,CAAAA,OAAjB,CAAyB,IAAKV,CAAAA,iBAA9B,CAAf,CACFiB,EAAAA,cADE,CACa,gBADb,CAC+B,IAAKtB,CAAAA,cADpC,CAEFsB,CAAAA,cAFE,CAEa,kBAFb,CAEiC,IAAKrB,CAAAA,gBAFtC,CAGFqB,CAAAA,cAHE,CAGa,OAHb,CAGsB,IAAKpB,CAAAA,KAH3B,CAIFoB,CAAAA,cAJE,CAIa,aAJb,CAI4B,IAAKnB,CAAAA,WAJjC,CADsB,CAtBR,CAwC7BJ,EAAiBwB,CAAAA,gBAAjB,CAAoCC,QAAS,CAACC,CAAD,CAAqBtB,CAArB,CAAkCuB,CAAlC,CAAsD,CAC/F,MAAOD,EACFZ,CAAAA,IADE,CACG,IAAIL,CADP,CAEFK,CAAAA,IAFE,CAEG,IAAIJ,CAAJ,CAAoB,kBAApB,CAFH,CAGFI,CAAAA,IAHE,CAGGV,CAAYwB,CAAAA,cAAZ,CAA2BD,CAA3B,CAHH,CAIFb,CAAAA,IAJE,CAIG,IAAIJ,CAAJ,CAAoB,gBAApB,CAJH,CAKFa,CAAAA,cALE,CAKa,aALb,CAK4BnB,CAL5B,CADwF,CASnGN,GAAOC,CAAAA,OAAP,CAAiBC,CA1E6C;\",\n\"sources\":[\"node_modules/jszip/lib/compressedObject.js\"],\n\"sourcesContent\":[\"shadow$provide[167] = function(global,require,module,exports) {\\n'use strict';\\n\\nvar external = require(\\\"./external\\\");\\nvar DataWorker = require('./stream/DataWorker');\\nvar Crc32Probe = require('./stream/Crc32Probe');\\nvar DataLengthProbe = require('./stream/DataLengthProbe');\\n\\n/**\\n * Represent a compressed object, with everything needed to decompress it.\\n * @constructor\\n * @param {number} compressedSize the size of the data compressed.\\n * @param {number} uncompressedSize the size of the data after decompression.\\n * @param {number} crc32 the crc32 of the decompressed file.\\n * @param {object} compression the type of compression, see lib/compressions.js.\\n * @param {String|ArrayBuffer|Uint8Array|Buffer} data the compressed data.\\n */\\nfunction CompressedObject(compressedSize, uncompressedSize, crc32, compression, data) {\\n    this.compressedSize = compressedSize;\\n    this.uncompressedSize = uncompressedSize;\\n    this.crc32 = crc32;\\n    this.compression = compression;\\n    this.compressedContent = data;\\n}\\n\\nCompressedObject.prototype = {\\n    /**\\n     * Create a worker to get the uncompressed content.\\n     * @return {GenericWorker} the worker.\\n     */\\n    getContentWorker: function () {\\n        var worker = new DataWorker(external.Promise.resolve(this.compressedContent))\\n            .pipe(this.compression.uncompressWorker())\\n            .pipe(new DataLengthProbe(\\\"data_length\\\"));\\n\\n        var that = this;\\n        worker.on(\\\"end\\\", function () {\\n            if (this.streamInfo['data_length'] !== that.uncompressedSize) {\\n                throw new Error(\\\"Bug : uncompressed data size mismatch\\\");\\n            }\\n        });\\n        return worker;\\n    },\\n    /**\\n     * Create a worker to get the compressed content.\\n     * @return {GenericWorker} the worker.\\n     */\\n    getCompressedWorker: function () {\\n        return new DataWorker(external.Promise.resolve(this.compressedContent))\\n            .withStreamInfo(\\\"compressedSize\\\", this.compressedSize)\\n            .withStreamInfo(\\\"uncompressedSize\\\", this.uncompressedSize)\\n            .withStreamInfo(\\\"crc32\\\", this.crc32)\\n            .withStreamInfo(\\\"compression\\\", this.compression)\\n            ;\\n    }\\n};\\n\\n/**\\n * Chain the given worker with other workers to compress the content with the\\n * given compression.\\n * @param {GenericWorker} uncompressedWorker the worker to pipe.\\n * @param {Object} compression the compression object.\\n * @param {Object} compressionOptions the options to use when compressing.\\n * @return {GenericWorker} the new worker compressing the content.\\n */\\nCompressedObject.createWorkerFrom = function (uncompressedWorker, compression, compressionOptions) {\\n    return uncompressedWorker\\n        .pipe(new Crc32Probe())\\n        .pipe(new DataLengthProbe(\\\"uncompressedSize\\\"))\\n        .pipe(compression.compressWorker(compressionOptions))\\n        .pipe(new DataLengthProbe(\\\"compressedSize\\\"))\\n        .withStreamInfo(\\\"compression\\\", compression);\\n};\\n\\nmodule.exports = CompressedObject;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"CompressedObject\",\"compressedSize\",\"uncompressedSize\",\"crc32\",\"compression\",\"data\",\"compressedContent\",\"external\",\"DataWorker\",\"Crc32Probe\",\"DataLengthProbe\",\"prototype\",\"getContentWorker\",\"worker\",\"pipe\",\"Promise\",\"resolve\",\"uncompressWorker\",\"that\",\"on\",\"streamInfo\",\"Error\",\"getCompressedWorker\",\"withStreamInfo\",\"createWorkerFrom\",\"CompressedObject.createWorkerFrom\",\"uncompressedWorker\",\"compressionOptions\",\"compressWorker\"]\n}\n"]