["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/element-resize-detector/src/element-resize-detector.js"],"~:js","shadow$provide[218]=function(ra,X,Ra,P){function w(k){return Array.isArray(k)||void 0!==k.length}function Z(k){if(Array.isArray(k))return k;var r=[];p(k,function(D){r.push(D)});return r}function B(k,r,D){k=k[r];return void 0!==k&&null!==k||void 0===D?k:D}var p=X(206).forEach,c=X(207),u=X(208),A=X(209),y=X(210),x=X(211),Q=X(212),g=X(214),h=X(215),b=X(216),l=X(217);Ra.exports=function(k){k=k||{};if(k.idHandler)var r={get:function(T){return k.idHandler.get(T,!0)},set:k.idHandler.set};else{var D=A();\nr=y({idGenerator:D,stateHandler:h})}var v=k.reporter;v||(v=x(!1===v));var t=B(k,\"batchProcessor\",g({reporter:v}));var q=!!B(k,\"callOnAdd\",!0);var f=!!B(k,\"debug\",!1);var E=u(r),C=c({stateHandler:h});D=B(k,\"strategy\",\"object\");var J=B(k,\"important\",!1);t={reporter:v,batchProcessor:t,stateHandler:h,idHandler:r,important:J};\"scroll\"===D&&(Q.isLegacyOpera()?(v.warn(\"Scroll strategy is not supported on legacy Opera. Changing to object strategy.\"),D=\"object\"):Q.isIE(9)&&(v.warn(\"Scroll strategy is not supported on IE9. Changing to object strategy.\"),\nD=\"object\"));if(\"scroll\"===D)var V=l(t);else if(\"object\"===D)V=b(t);else throw Error(\"Invalid strategy name: \"+D);var G={};return{listenTo:function(T,K,S){function R(ia){var U=E.get(ia);p(U,function(aa){aa(ia)})}function I(ia,U,aa){E.add(U,aa);ia&&aa(U)}S||(S=K,K=T,T={});if(!K)throw Error(\"At least one element required.\");if(!S)throw Error(\"Listener required.\");if(K&&1===K.nodeType)K=[K];else if(w(K))K=Z(K);else return v.error(\"Invalid arguments. Must be a DOM element or a collection of DOM elements.\");\nvar F=0,O=B(T,\"callOnAdd\",q),L=B(T,\"onReady\",function(){}),H=B(T,\"debug\",f);p(K,function(ia){h.getState(ia)||(h.initState(ia),r.set(ia));var U=r.get(ia);H&&v.log(\"Attaching listener to element\",U,ia);if(!C.isDetectable(ia)){H&&v.log(U,\"Not detectable.\");if(C.isBusy(ia)){H&&v.log(U,\"System busy making it detectable\");I(O,ia,S);G[U]=G[U]||[];G[U].push(function(){F++;F===K.length&&L()});return}H&&v.log(U,\"Making detectable...\");C.markBusy(ia,!0);return V.makeDetectable({debug:H,important:J},ia,function(aa){H&&\nv.log(U,\"onElementDetectable\");if(h.getState(aa)){C.markAsDetectable(aa);C.markBusy(aa,!1);V.addListener(aa,R);I(O,aa,S);var ba=h.getState(aa);if(ba&&ba.startSize){var W=aa.offsetHeight;ba.startSize.width===aa.offsetWidth&&ba.startSize.height===W||R(aa)}G[U]&&p(G[U],function(fa){fa()})}else H&&v.log(U,\"Element uninstalled before being detectable.\");delete G[U];F++;F===K.length&&L()})}H&&v.log(U,\"Already detecable, adding listener.\");I(O,ia,S);F++});F===K.length&&L()},removeListener:E.removeListener,\nremoveAllListeners:E.removeAllListeners,uninstall:function(T){if(!T)return v.error(\"At least one element is required.\");if(T&&1===T.nodeType)T=[T];else if(w(T))T=Z(T);else return v.error(\"Invalid arguments. Must be a DOM element or a collection of DOM elements.\");p(T,function(K){E.removeAllListeners(K);V.uninstall(K);h.cleanState(K)})},initDocument:function(T){V.initDocument&&V.initDocument(T)}}}}","~:source","shadow$provide[218] = function(global,require,module,exports) {\n\"use strict\";\n\nvar forEach                 = require(\"./collection-utils\").forEach;\nvar elementUtilsMaker       = require(\"./element-utils\");\nvar listenerHandlerMaker    = require(\"./listener-handler\");\nvar idGeneratorMaker        = require(\"./id-generator\");\nvar idHandlerMaker          = require(\"./id-handler\");\nvar reporterMaker           = require(\"./reporter\");\nvar browserDetector         = require(\"./browser-detector\");\nvar batchProcessorMaker     = require(\"batch-processor\");\nvar stateHandler            = require(\"./state-handler\");\n\n//Detection strategies.\nvar objectStrategyMaker     = require(\"./detection-strategy/object.js\");\nvar scrollStrategyMaker     = require(\"./detection-strategy/scroll.js\");\n\nfunction isCollection(obj) {\n    return Array.isArray(obj) || obj.length !== undefined;\n}\n\nfunction toArray(collection) {\n    if (!Array.isArray(collection)) {\n        var array = [];\n        forEach(collection, function (obj) {\n            array.push(obj);\n        });\n        return array;\n    } else {\n        return collection;\n    }\n}\n\nfunction isElement(obj) {\n    return obj && obj.nodeType === 1;\n}\n\n/**\n * @typedef idHandler\n * @type {object}\n * @property {function} get Gets the resize detector id of the element.\n * @property {function} set Generate and sets the resize detector id of the element.\n */\n\n/**\n * @typedef Options\n * @type {object}\n * @property {boolean} callOnAdd    Determines if listeners should be called when they are getting added.\n                                    Default is true. If true, the listener is guaranteed to be called when it has been added.\n                                    If false, the listener will not be guarenteed to be called when it has been added (does not prevent it from being called).\n * @property {idHandler} idHandler  A custom id handler that is responsible for generating, setting and retrieving id's for elements.\n                                    If not provided, a default id handler will be used.\n * @property {reporter} reporter    A custom reporter that handles reporting logs, warnings and errors.\n                                    If not provided, a default id handler will be used.\n                                    If set to false, then nothing will be reported.\n * @property {boolean} debug        If set to true, the the system will report debug messages as default for the listenTo method.\n */\n\n/**\n * Creates an element resize detector instance.\n * @public\n * @param {Options?} options Optional global options object that will decide how this instance will work.\n */\nmodule.exports = function(options) {\n    options = options || {};\n\n    //idHandler is currently not an option to the listenTo function, so it should not be added to globalOptions.\n    var idHandler;\n\n    if (options.idHandler) {\n        // To maintain compatability with idHandler.get(element, readonly), make sure to wrap the given idHandler\n        // so that readonly flag always is true when it's used here. This may be removed next major version bump.\n        idHandler = {\n            get: function (element) { return options.idHandler.get(element, true); },\n            set: options.idHandler.set\n        };\n    } else {\n        var idGenerator = idGeneratorMaker();\n        var defaultIdHandler = idHandlerMaker({\n            idGenerator: idGenerator,\n            stateHandler: stateHandler\n        });\n        idHandler = defaultIdHandler;\n    }\n\n    //reporter is currently not an option to the listenTo function, so it should not be added to globalOptions.\n    var reporter = options.reporter;\n\n    if(!reporter) {\n        //If options.reporter is false, then the reporter should be quiet.\n        var quiet = reporter === false;\n        reporter = reporterMaker(quiet);\n    }\n\n    //batchProcessor is currently not an option to the listenTo function, so it should not be added to globalOptions.\n    var batchProcessor = getOption(options, \"batchProcessor\", batchProcessorMaker({ reporter: reporter }));\n\n    //Options to be used as default for the listenTo function.\n    var globalOptions = {};\n    globalOptions.callOnAdd     = !!getOption(options, \"callOnAdd\", true);\n    globalOptions.debug         = !!getOption(options, \"debug\", false);\n\n    var eventListenerHandler    = listenerHandlerMaker(idHandler);\n    var elementUtils            = elementUtilsMaker({\n        stateHandler: stateHandler\n    });\n\n    //The detection strategy to be used.\n    var detectionStrategy;\n    var desiredStrategy = getOption(options, \"strategy\", \"object\");\n    var importantCssRules = getOption(options, \"important\", false);\n    var strategyOptions = {\n        reporter: reporter,\n        batchProcessor: batchProcessor,\n        stateHandler: stateHandler,\n        idHandler: idHandler,\n        important: importantCssRules\n    };\n\n    if(desiredStrategy === \"scroll\") {\n        if (browserDetector.isLegacyOpera()) {\n            reporter.warn(\"Scroll strategy is not supported on legacy Opera. Changing to object strategy.\");\n            desiredStrategy = \"object\";\n        } else if (browserDetector.isIE(9)) {\n            reporter.warn(\"Scroll strategy is not supported on IE9. Changing to object strategy.\");\n            desiredStrategy = \"object\";\n        }\n    }\n\n    if(desiredStrategy === \"scroll\") {\n        detectionStrategy = scrollStrategyMaker(strategyOptions);\n    } else if(desiredStrategy === \"object\") {\n        detectionStrategy = objectStrategyMaker(strategyOptions);\n    } else {\n        throw new Error(\"Invalid strategy name: \" + desiredStrategy);\n    }\n\n    //Calls can be made to listenTo with elements that are still being installed.\n    //Also, same elements can occur in the elements list in the listenTo function.\n    //With this map, the ready callbacks can be synchronized between the calls\n    //so that the ready callback can always be called when an element is ready - even if\n    //it wasn't installed from the function itself.\n    var onReadyCallbacks = {};\n\n    /**\n     * Makes the given elements resize-detectable and starts listening to resize events on the elements. Calls the event callback for each event for each element.\n     * @public\n     * @param {Options?} options Optional options object. These options will override the global options. Some options may not be overriden, such as idHandler.\n     * @param {element[]|element} elements The given array of elements to detect resize events of. Single element is also valid.\n     * @param {function} listener The callback to be executed for each resize event for each element.\n     */\n    function listenTo(options, elements, listener) {\n        function onResizeCallback(element) {\n            var listeners = eventListenerHandler.get(element);\n            forEach(listeners, function callListenerProxy(listener) {\n                listener(element);\n            });\n        }\n\n        function addListener(callOnAdd, element, listener) {\n            eventListenerHandler.add(element, listener);\n\n            if(callOnAdd) {\n                listener(element);\n            }\n        }\n\n        //Options object may be omitted.\n        if(!listener) {\n            listener = elements;\n            elements = options;\n            options = {};\n        }\n\n        if(!elements) {\n            throw new Error(\"At least one element required.\");\n        }\n\n        if(!listener) {\n            throw new Error(\"Listener required.\");\n        }\n\n        if (isElement(elements)) {\n            // A single element has been passed in.\n            elements = [elements];\n        } else if (isCollection(elements)) {\n            // Convert collection to array for plugins.\n            // TODO: May want to check so that all the elements in the collection are valid elements.\n            elements = toArray(elements);\n        } else {\n            return reporter.error(\"Invalid arguments. Must be a DOM element or a collection of DOM elements.\");\n        }\n\n        var elementsReady = 0;\n\n        var callOnAdd = getOption(options, \"callOnAdd\", globalOptions.callOnAdd);\n        var onReadyCallback = getOption(options, \"onReady\", function noop() {});\n        var debug = getOption(options, \"debug\", globalOptions.debug);\n\n        forEach(elements, function attachListenerToElement(element) {\n            if (!stateHandler.getState(element)) {\n                stateHandler.initState(element);\n                idHandler.set(element);\n            }\n\n            var id = idHandler.get(element);\n\n            debug && reporter.log(\"Attaching listener to element\", id, element);\n\n            if(!elementUtils.isDetectable(element)) {\n                debug && reporter.log(id, \"Not detectable.\");\n                if(elementUtils.isBusy(element)) {\n                    debug && reporter.log(id, \"System busy making it detectable\");\n\n                    //The element is being prepared to be detectable. Do not make it detectable.\n                    //Just add the listener, because the element will soon be detectable.\n                    addListener(callOnAdd, element, listener);\n                    onReadyCallbacks[id] = onReadyCallbacks[id] || [];\n                    onReadyCallbacks[id].push(function onReady() {\n                        elementsReady++;\n\n                        if(elementsReady === elements.length) {\n                            onReadyCallback();\n                        }\n                    });\n                    return;\n                }\n\n                debug && reporter.log(id, \"Making detectable...\");\n                //The element is not prepared to be detectable, so do prepare it and add a listener to it.\n                elementUtils.markBusy(element, true);\n                return detectionStrategy.makeDetectable({ debug: debug, important: importantCssRules }, element, function onElementDetectable(element) {\n                    debug && reporter.log(id, \"onElementDetectable\");\n\n                    if (stateHandler.getState(element)) {\n                        elementUtils.markAsDetectable(element);\n                        elementUtils.markBusy(element, false);\n                        detectionStrategy.addListener(element, onResizeCallback);\n                        addListener(callOnAdd, element, listener);\n\n                        // Since the element size might have changed since the call to \"listenTo\", we need to check for this change,\n                        // so that a resize event may be emitted.\n                        // Having the startSize object is optional (since it does not make sense in some cases such as unrendered elements), so check for its existance before.\n                        // Also, check the state existance before since the element may have been uninstalled in the installation process.\n                        var state = stateHandler.getState(element);\n                        if (state && state.startSize) {\n                            var width = element.offsetWidth;\n                            var height = element.offsetHeight;\n                            if (state.startSize.width !== width || state.startSize.height !== height) {\n                                onResizeCallback(element);\n                            }\n                        }\n\n                        if(onReadyCallbacks[id]) {\n                            forEach(onReadyCallbacks[id], function(callback) {\n                                callback();\n                            });\n                        }\n                    } else {\n                        // The element has been unisntalled before being detectable.\n                        debug && reporter.log(id, \"Element uninstalled before being detectable.\");\n                    }\n\n                    delete onReadyCallbacks[id];\n\n                    elementsReady++;\n                    if(elementsReady === elements.length) {\n                        onReadyCallback();\n                    }\n                });\n            }\n\n            debug && reporter.log(id, \"Already detecable, adding listener.\");\n\n            //The element has been prepared to be detectable and is ready to be listened to.\n            addListener(callOnAdd, element, listener);\n            elementsReady++;\n        });\n\n        if(elementsReady === elements.length) {\n            onReadyCallback();\n        }\n    }\n\n    function uninstall(elements) {\n        if(!elements) {\n            return reporter.error(\"At least one element is required.\");\n        }\n\n        if (isElement(elements)) {\n            // A single element has been passed in.\n            elements = [elements];\n        } else if (isCollection(elements)) {\n            // Convert collection to array for plugins.\n            // TODO: May want to check so that all the elements in the collection are valid elements.\n            elements = toArray(elements);\n        } else {\n            return reporter.error(\"Invalid arguments. Must be a DOM element or a collection of DOM elements.\");\n        }\n\n        forEach(elements, function (element) {\n            eventListenerHandler.removeAllListeners(element);\n            detectionStrategy.uninstall(element);\n            stateHandler.cleanState(element);\n        });\n    }\n\n    function initDocument(targetDocument) {\n        detectionStrategy.initDocument && detectionStrategy.initDocument(targetDocument);\n    }\n\n    return {\n        listenTo: listenTo,\n        removeListener: eventListenerHandler.removeListener,\n        removeAllListeners: eventListenerHandler.removeAllListeners,\n        uninstall: uninstall,\n        initDocument: initDocument\n    };\n};\n\nfunction getOption(options, name, defaultValue) {\n    var value = options[name];\n\n    if((value === undefined || value === null) && defaultValue !== undefined) {\n        return defaultValue;\n    }\n\n    return value;\n}\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$element_resize_detector$src$detection_strategy$scroll","~$module$node_modules$element_resize_detector$src$listener_handler","~$shadow.js","~$module$node_modules$element_resize_detector$src$id_generator","~$module$node_modules$element_resize_detector$src$element_utils","~$module$node_modules$element_resize_detector$src$reporter","~$module$node_modules$element_resize_detector$src$state_handler","~$module$node_modules$element_resize_detector$src$collection_utils","~$module$node_modules$element_resize_detector$src$browser_detector","~$module$node_modules$element_resize_detector$src$detection_strategy$object","~$module$node_modules$batch_processor$src$batch_processor","~$module$node_modules$element_resize_detector$src$id_handler"]],"~:properties",["^5",["listenTo","reporter","important","idGenerator","removeAllListeners","uninstall","removeListener","debug","batchProcessor","idHandler","stateHandler","set","get","initDocument"]],"~:compiled-at",1766065009575,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$element_resize_detector$src$element_resize_detector.js\",\n\"lineCount\":6,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAiB9DC,QAASA,EAAY,CAACC,CAAD,CAAM,CACvB,MAAOC,MAAMC,CAAAA,OAAN,CAAcF,CAAd,CAAP,EAA4CG,IAAAA,EAA5C,GAA6BH,CAAII,CAAAA,MADV,CAI3BC,QAASA,EAAO,CAACC,CAAD,CAAa,CACzB,GAAKL,KAAMC,CAAAA,OAAN,CAAcI,CAAd,CAAL,CAOI,MAAOA,EANP,KAAIC,EAAQ,EACZC,EAAA,CAAQF,CAAR,CAAoB,QAAS,CAACN,CAAD,CAAM,CAC/BO,CAAME,CAAAA,IAAN,CAAWT,CAAX,CAD+B,CAAnC,CAGA,OAAOO,EANc,CA2S7BG,QAASA,EAAS,CAACC,CAAD,CAAUC,CAAV,CAAgBC,CAAhB,CAA8B,CACxCC,CAAAA,CAAQH,CAAA,CAAQC,CAAR,CAEZ,OAAcT,KAAAA,EAAd,GAAIW,CAAJ,EAAqC,IAArC,GAA2BA,CAA3B,EAA+DX,IAAAA,EAA/D,GAA8CU,CAA9C,CAIOC,CAJP,CACWD,CAJiC,CA7ThD,IAAIL,EAA0BZ,CAAA,CAAQ,GAAR,CAA8BY,CAAAA,OAA5D,CACIO,EAA0BnB,CAAA,CAAQ,GAAR,CAD9B,CAEIoB,EAA0BpB,CAAA,CAAQ,GAAR,CAF9B,CAGIqB,EAA0BrB,CAAA,CAAQ,GAAR,CAH9B,CAIIsB,EAA0BtB,CAAA,CAAQ,GAAR,CAJ9B,CAKIuB,EAA0BvB,CAAA,CAAQ,GAAR,CAL9B,CAMIwB,EAA0BxB,CAAA,CAAQ,GAAR,CAN9B,CAOIyB,EAA0BzB,CAAA,CAAQ,GAAR,CAP9B,CAQI0B,EAA0B1B,CAAA,CAAQ,GAAR,CAR9B,CAWI2B,EAA0B3B,CAAA,CAAQ,GAAR,CAX9B,CAYI4B,EAA0B5B,CAAA,CAAQ,GAAR,CAgD9BC,GAAOC,CAAAA,OAAP,CAAiB2B,QAAQ,CAACd,CAAD,CAAU,CAC/BA,CAAA,CAAUA,CAAV,EAAqB,EAKrB,IAAIA,CAAQe,CAAAA,SAAZ,CAGI,IAAAA,EAAY,CACRC,IAAKA,QAAS,CAACC,CAAD,CAAU,CAAE,MAAOjB,EAAQe,CAAAA,SAAUC,CAAAA,GAAlB,CAAsBC,CAAtB,CAA+B,CAAA,CAA/B,CAAT,CADhB,CAERC,IAAKlB,CAAQe,CAAAA,SAAUG,CAAAA,GAFf,CAHhB,KAOO,CACH,IAAIC,EAAcb,CAAA,EAKlBS;CAAA,CAJuBR,CAAAa,CAAe,CAClCD,YAAaA,CADqB,CAElCR,aAAcA,CAFoB,CAAfS,CAFpB,CAUP,IAAIC,EAAWrB,CAAQqB,CAAAA,QAEnBA,EAAJ,GAGIA,CAHJ,CAGeb,CAAA,CADc,CAAA,CACd,GADCa,CACD,CAHf,CAOA,KAAIC,EAAiBvB,CAAA,CAAUC,CAAV,CAAmB,gBAAnB,CAAqCU,CAAA,CAAoB,CAAEW,SAAUA,CAAZ,CAApB,CAArC,CAIrB,KAAcE,EAAgB,CAAC,CAACxB,CAAA,CAAUC,CAAV,CAAmB,WAAnB,CAAgC,CAAA,CAAhC,CAChC,KAAcwB,EAAgB,CAAC,CAACzB,CAAA,CAAUC,CAAV,CAAmB,OAAnB,CAA4B,CAAA,CAA5B,CAEhC,KAAIyB,EAA0BpB,CAAA,CAAqBU,CAArB,CAA9B,CACIW,EAA0BtB,CAAA,CAAkB,CAC5CO,aAAcA,CAD8B,CAAlB,CAM1BgB,EAAAA,CAAkB5B,CAAA,CAAUC,CAAV,CAAmB,UAAnB,CAA+B,QAA/B,CACtB,KAAI4B,EAAoB7B,CAAA,CAAUC,CAAV,CAAmB,WAAnB,CAAgC,CAAA,CAAhC,CACpB6B,EAAAA,CAAkB,CAClBR,SAAUA,CADQ,CAElBC,eAAgBA,CAFE,CAGlBX,aAAcA,CAHI,CAIlBI,UAAWA,CAJO,CAKlBe,UAAWF,CALO,CAQC,SAAvB,GAAGD,CAAH,GACQlB,CAAgBsB,CAAAA,aAAhB,EAAJ,EACIV,CAASW,CAAAA,IAAT,CAAc,gFAAd,CACA,CAAAL,CAAA,CAAkB,QAFtB,EAGWlB,CAAgBwB,CAAAA,IAAhB,CAAqB,CAArB,CAHX,GAIIZ,CAASW,CAAAA,IAAT,CAAc,uEAAd,CACA;AAAAL,CAAA,CAAkB,QALtB,CADJ,CAUA,IAAuB,QAAvB,GAAGA,CAAH,CACI,IAAAO,EAAoBrB,CAAA,CAAoBgB,CAApB,CADxB,KAEO,IAAuB,QAAvB,GAAGF,CAAH,CACHO,CAAA,CAAoBtB,CAAA,CAAoBiB,CAApB,CADjB,KAGH,MAAUM,MAAJ,CAAU,yBAAV,CAAsCR,CAAtC,CAAN,CAQJ,IAAIS,EAAmB,EAyKvB,OAAO,CACHC,SAjKJA,QAAiB,CAACrC,CAAD,CAAUsC,CAAV,CAAoBC,CAApB,CAA8B,CAC3CC,QAASA,EAAgB,CAACvB,EAAD,CAAU,CAC/B,IAAIwB,EAAYhB,CAAqBT,CAAAA,GAArB,CAAyBC,EAAzB,CAChBpB,EAAA,CAAQ4C,CAAR,CAAmBC,QAA0B,CAACH,EAAD,CAAW,CACpDA,EAAA,CAAStB,EAAT,CADoD,CAAxD,CAF+B,CAOnC0B,QAASA,EAAW,CAACpB,EAAD,CAAYN,CAAZ,CAAqBsB,EAArB,CAA+B,CAC/Cd,CAAqBmB,CAAAA,GAArB,CAAyB3B,CAAzB,CAAkCsB,EAAlC,CAEGhB,GAAH,EACIgB,EAAA,CAAStB,CAAT,CAJ2C,CAS/CsB,CAAJ,GACIA,CAEA,CAFWD,CAEX,CADAA,CACA,CADWtC,CACX,CAAAA,CAAA,CAAU,EAHd,CAMA,IAAG,CAACsC,CAAJ,CACI,KAAUH,MAAJ,CAAU,gCAAV,CAAN,CAGJ,GAAG,CAACI,CAAJ,CACI,KAAUJ,MAAJ,CAAU,oBAAV,CAAN,CAGJ,GAAcG,CAAd,EApJ2B,CAoJ3B,GAAcA,CApJAO,CAAAA,QAoJd,CAEIP,CAAA,CAAW,CAACA,CAAD,CAFf,KAGO,IAAIlD,CAAA,CAAakD,CAAb,CAAJ,CAGHA,CAAA,CAAW5C,CAAA,CAAQ4C,CAAR,CAHR,KAKH,OAAOjB,EAASyB,CAAAA,KAAT,CAAe,2EAAf,CAGX;IAAIC,EAAgB,CAApB,CAEIxB,EAAYxB,CAAA,CAAUC,CAAV,CAAmB,WAAnB,CAA8CuB,CAA9C,CAFhB,CAGIyB,EAAkBjD,CAAA,CAAUC,CAAV,CAAmB,SAAnB,CAA8BiD,QAAa,EAAG,EAA9C,CAHtB,CAIIzB,EAAQzB,CAAA,CAAUC,CAAV,CAAmB,OAAnB,CAA0CwB,CAA1C,CAEZ3B,EAAA,CAAQyC,CAAR,CAAkBY,QAAgC,CAACjC,EAAD,CAAU,CACnDN,CAAawC,CAAAA,QAAb,CAAsBlC,EAAtB,CAAL,GACIN,CAAayC,CAAAA,SAAb,CAAuBnC,EAAvB,CACA,CAAAF,CAAUG,CAAAA,GAAV,CAAcD,EAAd,CAFJ,CAKA,KAAIoC,EAAKtC,CAAUC,CAAAA,GAAV,CAAcC,EAAd,CAETO,EAAA,EAASH,CAASiC,CAAAA,GAAT,CAAa,+BAAb,CAA8CD,CAA9C,CAAkDpC,EAAlD,CAET,IAAG,CAACS,CAAa6B,CAAAA,YAAb,CAA0BtC,EAA1B,CAAJ,CAAwC,CACpCO,CAAA,EAASH,CAASiC,CAAAA,GAAT,CAAaD,CAAb,CAAiB,iBAAjB,CACT,IAAG3B,CAAa8B,CAAAA,MAAb,CAAoBvC,EAApB,CAAH,CAAiC,CAC7BO,CAAA,EAASH,CAASiC,CAAAA,GAAT,CAAaD,CAAb,CAAiB,kCAAjB,CAITV,EAAA,CAAYpB,CAAZ,CAAuBN,EAAvB,CAAgCsB,CAAhC,CACAH,EAAA,CAAiBiB,CAAjB,CAAA,CAAuBjB,CAAA,CAAiBiB,CAAjB,CAAvB,EAA+C,EAC/CjB,EAAA,CAAiBiB,CAAjB,CAAqBvD,CAAAA,IAArB,CAA0B2D,QAAgB,EAAG,CACzCV,CAAA,EAEGA,EAAH,GAAqBT,CAAS7C,CAAAA,MAA9B,EACIuD,CAAA,EAJqC,CAA7C,CAOA,OAd6B,CAiBjCxB,CAAA,EAASH,CAASiC,CAAAA,GAAT,CAAaD,CAAb,CAAiB,sBAAjB,CAET3B,EAAagC,CAAAA,QAAb,CAAsBzC,EAAtB,CAA+B,CAAA,CAA/B,CACA,OAAOiB,EAAkByB,CAAAA,cAAlB,CAAiC,CAAEnC,MAAOA,CAAT,CAAgBM,UAAWF,CAA3B,CAAjC,CAAiFX,EAAjF,CAA0F2C,QAA4B,CAAC3C,EAAD,CAAU,CACnIO,CAAA;AAASH,CAASiC,CAAAA,GAAT,CAAaD,CAAb,CAAiB,qBAAjB,CAET,IAAI1C,CAAawC,CAAAA,QAAb,CAAsBlC,EAAtB,CAAJ,CAAoC,CAChCS,CAAamC,CAAAA,gBAAb,CAA8B5C,EAA9B,CACAS,EAAagC,CAAAA,QAAb,CAAsBzC,EAAtB,CAA+B,CAAA,CAA/B,CACAiB,EAAkBS,CAAAA,WAAlB,CAA8B1B,EAA9B,CAAuCuB,CAAvC,CACAG,EAAA,CAAYpB,CAAZ,CAAuBN,EAAvB,CAAgCsB,CAAhC,CAMA,KAAIuB,GAAQnD,CAAawC,CAAAA,QAAb,CAAsBlC,EAAtB,CACZ,IAAI6C,EAAJ,EAAaA,EAAMC,CAAAA,SAAnB,CAA8B,CAE1B,IAAIC,EAAS/C,EAAQgD,CAAAA,YACjBH,GAAMC,CAAAA,SAAUG,CAAAA,KAApB,GAFYjD,EAAQkD,CAAAA,WAEpB,EAAuCL,EAAMC,CAAAA,SAAUC,CAAAA,MAAvD,GAAkEA,CAAlE,EACIxB,CAAA,CAAiBvB,EAAjB,CAJsB,CAQ3BmB,CAAA,CAAiBiB,CAAjB,CAAH,EACIxD,CAAA,CAAQuC,CAAA,CAAiBiB,CAAjB,CAAR,CAA8B,QAAQ,CAACe,EAAD,CAAW,CAC7CA,EAAA,EAD6C,CAAjD,CApB4B,CAApC,IA0BI5C,EAAA,EAASH,CAASiC,CAAAA,GAAT,CAAaD,CAAb,CAAiB,8CAAjB,CAGb,QAAOjB,CAAA,CAAiBiB,CAAjB,CAEPN,EAAA,EACGA,EAAH,GAAqBT,CAAS7C,CAAAA,MAA9B,EACIuD,CAAA,EApC+H,CAAhI,CAtB6B,CA+DxCxB,CAAA,EAASH,CAASiC,CAAAA,GAAT,CAAaD,CAAb,CAAiB,qCAAjB,CAGTV,EAAA,CAAYpB,CAAZ,CAAuBN,EAAvB,CAAgCsB,CAAhC,CACAQ,EAAA,EA7EwD,CAA5D,CAgFGA,EAAH,GAAqBT,CAAS7C,CAAAA,MAA9B,EACIuD,CAAA,EAjIuC,CAgKxC,CAEHqB,eAAgB5C,CAAqB4C,CAAAA,cAFlC;AAGHC,mBAAoB7C,CAAqB6C,CAAAA,kBAHtC,CAIHC,UA/BJA,QAAkB,CAACjC,CAAD,CAAW,CACzB,GAAG,CAACA,CAAJ,CACI,MAAOjB,EAASyB,CAAAA,KAAT,CAAe,mCAAf,CAGX,IAAcR,CAAd,EA/P2B,CA+P3B,GAAcA,CA/PAO,CAAAA,QA+Pd,CAEIP,CAAA,CAAW,CAACA,CAAD,CAFf,KAGO,IAAIlD,CAAA,CAAakD,CAAb,CAAJ,CAGHA,CAAA,CAAW5C,CAAA,CAAQ4C,CAAR,CAHR,KAKH,OAAOjB,EAASyB,CAAAA,KAAT,CAAe,2EAAf,CAGXjD,EAAA,CAAQyC,CAAR,CAAkB,QAAS,CAACrB,CAAD,CAAU,CACjCQ,CAAqB6C,CAAAA,kBAArB,CAAwCrD,CAAxC,CACAiB,EAAkBqC,CAAAA,SAAlB,CAA4BtD,CAA5B,CACAN,EAAa6D,CAAAA,UAAb,CAAwBvD,CAAxB,CAHiC,CAArC,CAhByB,CA2BtB,CAKHwD,aATJA,QAAqB,CAACC,CAAD,CAAiB,CAClCxC,CAAkBuC,CAAAA,YAAlB,EAAkCvC,CAAkBuC,CAAAA,YAAlB,CAA+BC,CAA/B,CADA,CAI/B,CAxPwB,CA/D2B;\",\n\"sources\":[\"node_modules/element-resize-detector/src/element-resize-detector.js\"],\n\"sourcesContent\":[\"shadow$provide[218] = function(global,require,module,exports) {\\n\\\"use strict\\\";\\n\\nvar forEach                 = require(\\\"./collection-utils\\\").forEach;\\nvar elementUtilsMaker       = require(\\\"./element-utils\\\");\\nvar listenerHandlerMaker    = require(\\\"./listener-handler\\\");\\nvar idGeneratorMaker        = require(\\\"./id-generator\\\");\\nvar idHandlerMaker          = require(\\\"./id-handler\\\");\\nvar reporterMaker           = require(\\\"./reporter\\\");\\nvar browserDetector         = require(\\\"./browser-detector\\\");\\nvar batchProcessorMaker     = require(\\\"batch-processor\\\");\\nvar stateHandler            = require(\\\"./state-handler\\\");\\n\\n//Detection strategies.\\nvar objectStrategyMaker     = require(\\\"./detection-strategy/object.js\\\");\\nvar scrollStrategyMaker     = require(\\\"./detection-strategy/scroll.js\\\");\\n\\nfunction isCollection(obj) {\\n    return Array.isArray(obj) || obj.length !== undefined;\\n}\\n\\nfunction toArray(collection) {\\n    if (!Array.isArray(collection)) {\\n        var array = [];\\n        forEach(collection, function (obj) {\\n            array.push(obj);\\n        });\\n        return array;\\n    } else {\\n        return collection;\\n    }\\n}\\n\\nfunction isElement(obj) {\\n    return obj && obj.nodeType === 1;\\n}\\n\\n/**\\n * @typedef idHandler\\n * @type {object}\\n * @property {function} get Gets the resize detector id of the element.\\n * @property {function} set Generate and sets the resize detector id of the element.\\n */\\n\\n/**\\n * @typedef Options\\n * @type {object}\\n * @property {boolean} callOnAdd    Determines if listeners should be called when they are getting added.\\n                                    Default is true. If true, the listener is guaranteed to be called when it has been added.\\n                                    If false, the listener will not be guarenteed to be called when it has been added (does not prevent it from being called).\\n * @property {idHandler} idHandler  A custom id handler that is responsible for generating, setting and retrieving id's for elements.\\n                                    If not provided, a default id handler will be used.\\n * @property {reporter} reporter    A custom reporter that handles reporting logs, warnings and errors.\\n                                    If not provided, a default id handler will be used.\\n                                    If set to false, then nothing will be reported.\\n * @property {boolean} debug        If set to true, the the system will report debug messages as default for the listenTo method.\\n */\\n\\n/**\\n * Creates an element resize detector instance.\\n * @public\\n * @param {Options?} options Optional global options object that will decide how this instance will work.\\n */\\nmodule.exports = function(options) {\\n    options = options || {};\\n\\n    //idHandler is currently not an option to the listenTo function, so it should not be added to globalOptions.\\n    var idHandler;\\n\\n    if (options.idHandler) {\\n        // To maintain compatability with idHandler.get(element, readonly), make sure to wrap the given idHandler\\n        // so that readonly flag always is true when it's used here. This may be removed next major version bump.\\n        idHandler = {\\n            get: function (element) { return options.idHandler.get(element, true); },\\n            set: options.idHandler.set\\n        };\\n    } else {\\n        var idGenerator = idGeneratorMaker();\\n        var defaultIdHandler = idHandlerMaker({\\n            idGenerator: idGenerator,\\n            stateHandler: stateHandler\\n        });\\n        idHandler = defaultIdHandler;\\n    }\\n\\n    //reporter is currently not an option to the listenTo function, so it should not be added to globalOptions.\\n    var reporter = options.reporter;\\n\\n    if(!reporter) {\\n        //If options.reporter is false, then the reporter should be quiet.\\n        var quiet = reporter === false;\\n        reporter = reporterMaker(quiet);\\n    }\\n\\n    //batchProcessor is currently not an option to the listenTo function, so it should not be added to globalOptions.\\n    var batchProcessor = getOption(options, \\\"batchProcessor\\\", batchProcessorMaker({ reporter: reporter }));\\n\\n    //Options to be used as default for the listenTo function.\\n    var globalOptions = {};\\n    globalOptions.callOnAdd     = !!getOption(options, \\\"callOnAdd\\\", true);\\n    globalOptions.debug         = !!getOption(options, \\\"debug\\\", false);\\n\\n    var eventListenerHandler    = listenerHandlerMaker(idHandler);\\n    var elementUtils            = elementUtilsMaker({\\n        stateHandler: stateHandler\\n    });\\n\\n    //The detection strategy to be used.\\n    var detectionStrategy;\\n    var desiredStrategy = getOption(options, \\\"strategy\\\", \\\"object\\\");\\n    var importantCssRules = getOption(options, \\\"important\\\", false);\\n    var strategyOptions = {\\n        reporter: reporter,\\n        batchProcessor: batchProcessor,\\n        stateHandler: stateHandler,\\n        idHandler: idHandler,\\n        important: importantCssRules\\n    };\\n\\n    if(desiredStrategy === \\\"scroll\\\") {\\n        if (browserDetector.isLegacyOpera()) {\\n            reporter.warn(\\\"Scroll strategy is not supported on legacy Opera. Changing to object strategy.\\\");\\n            desiredStrategy = \\\"object\\\";\\n        } else if (browserDetector.isIE(9)) {\\n            reporter.warn(\\\"Scroll strategy is not supported on IE9. Changing to object strategy.\\\");\\n            desiredStrategy = \\\"object\\\";\\n        }\\n    }\\n\\n    if(desiredStrategy === \\\"scroll\\\") {\\n        detectionStrategy = scrollStrategyMaker(strategyOptions);\\n    } else if(desiredStrategy === \\\"object\\\") {\\n        detectionStrategy = objectStrategyMaker(strategyOptions);\\n    } else {\\n        throw new Error(\\\"Invalid strategy name: \\\" + desiredStrategy);\\n    }\\n\\n    //Calls can be made to listenTo with elements that are still being installed.\\n    //Also, same elements can occur in the elements list in the listenTo function.\\n    //With this map, the ready callbacks can be synchronized between the calls\\n    //so that the ready callback can always be called when an element is ready - even if\\n    //it wasn't installed from the function itself.\\n    var onReadyCallbacks = {};\\n\\n    /**\\n     * Makes the given elements resize-detectable and starts listening to resize events on the elements. Calls the event callback for each event for each element.\\n     * @public\\n     * @param {Options?} options Optional options object. These options will override the global options. Some options may not be overriden, such as idHandler.\\n     * @param {element[]|element} elements The given array of elements to detect resize events of. Single element is also valid.\\n     * @param {function} listener The callback to be executed for each resize event for each element.\\n     */\\n    function listenTo(options, elements, listener) {\\n        function onResizeCallback(element) {\\n            var listeners = eventListenerHandler.get(element);\\n            forEach(listeners, function callListenerProxy(listener) {\\n                listener(element);\\n            });\\n        }\\n\\n        function addListener(callOnAdd, element, listener) {\\n            eventListenerHandler.add(element, listener);\\n\\n            if(callOnAdd) {\\n                listener(element);\\n            }\\n        }\\n\\n        //Options object may be omitted.\\n        if(!listener) {\\n            listener = elements;\\n            elements = options;\\n            options = {};\\n        }\\n\\n        if(!elements) {\\n            throw new Error(\\\"At least one element required.\\\");\\n        }\\n\\n        if(!listener) {\\n            throw new Error(\\\"Listener required.\\\");\\n        }\\n\\n        if (isElement(elements)) {\\n            // A single element has been passed in.\\n            elements = [elements];\\n        } else if (isCollection(elements)) {\\n            // Convert collection to array for plugins.\\n            // TODO: May want to check so that all the elements in the collection are valid elements.\\n            elements = toArray(elements);\\n        } else {\\n            return reporter.error(\\\"Invalid arguments. Must be a DOM element or a collection of DOM elements.\\\");\\n        }\\n\\n        var elementsReady = 0;\\n\\n        var callOnAdd = getOption(options, \\\"callOnAdd\\\", globalOptions.callOnAdd);\\n        var onReadyCallback = getOption(options, \\\"onReady\\\", function noop() {});\\n        var debug = getOption(options, \\\"debug\\\", globalOptions.debug);\\n\\n        forEach(elements, function attachListenerToElement(element) {\\n            if (!stateHandler.getState(element)) {\\n                stateHandler.initState(element);\\n                idHandler.set(element);\\n            }\\n\\n            var id = idHandler.get(element);\\n\\n            debug && reporter.log(\\\"Attaching listener to element\\\", id, element);\\n\\n            if(!elementUtils.isDetectable(element)) {\\n                debug && reporter.log(id, \\\"Not detectable.\\\");\\n                if(elementUtils.isBusy(element)) {\\n                    debug && reporter.log(id, \\\"System busy making it detectable\\\");\\n\\n                    //The element is being prepared to be detectable. Do not make it detectable.\\n                    //Just add the listener, because the element will soon be detectable.\\n                    addListener(callOnAdd, element, listener);\\n                    onReadyCallbacks[id] = onReadyCallbacks[id] || [];\\n                    onReadyCallbacks[id].push(function onReady() {\\n                        elementsReady++;\\n\\n                        if(elementsReady === elements.length) {\\n                            onReadyCallback();\\n                        }\\n                    });\\n                    return;\\n                }\\n\\n                debug && reporter.log(id, \\\"Making detectable...\\\");\\n                //The element is not prepared to be detectable, so do prepare it and add a listener to it.\\n                elementUtils.markBusy(element, true);\\n                return detectionStrategy.makeDetectable({ debug: debug, important: importantCssRules }, element, function onElementDetectable(element) {\\n                    debug && reporter.log(id, \\\"onElementDetectable\\\");\\n\\n                    if (stateHandler.getState(element)) {\\n                        elementUtils.markAsDetectable(element);\\n                        elementUtils.markBusy(element, false);\\n                        detectionStrategy.addListener(element, onResizeCallback);\\n                        addListener(callOnAdd, element, listener);\\n\\n                        // Since the element size might have changed since the call to \\\"listenTo\\\", we need to check for this change,\\n                        // so that a resize event may be emitted.\\n                        // Having the startSize object is optional (since it does not make sense in some cases such as unrendered elements), so check for its existance before.\\n                        // Also, check the state existance before since the element may have been uninstalled in the installation process.\\n                        var state = stateHandler.getState(element);\\n                        if (state && state.startSize) {\\n                            var width = element.offsetWidth;\\n                            var height = element.offsetHeight;\\n                            if (state.startSize.width !== width || state.startSize.height !== height) {\\n                                onResizeCallback(element);\\n                            }\\n                        }\\n\\n                        if(onReadyCallbacks[id]) {\\n                            forEach(onReadyCallbacks[id], function(callback) {\\n                                callback();\\n                            });\\n                        }\\n                    } else {\\n                        // The element has been unisntalled before being detectable.\\n                        debug && reporter.log(id, \\\"Element uninstalled before being detectable.\\\");\\n                    }\\n\\n                    delete onReadyCallbacks[id];\\n\\n                    elementsReady++;\\n                    if(elementsReady === elements.length) {\\n                        onReadyCallback();\\n                    }\\n                });\\n            }\\n\\n            debug && reporter.log(id, \\\"Already detecable, adding listener.\\\");\\n\\n            //The element has been prepared to be detectable and is ready to be listened to.\\n            addListener(callOnAdd, element, listener);\\n            elementsReady++;\\n        });\\n\\n        if(elementsReady === elements.length) {\\n            onReadyCallback();\\n        }\\n    }\\n\\n    function uninstall(elements) {\\n        if(!elements) {\\n            return reporter.error(\\\"At least one element is required.\\\");\\n        }\\n\\n        if (isElement(elements)) {\\n            // A single element has been passed in.\\n            elements = [elements];\\n        } else if (isCollection(elements)) {\\n            // Convert collection to array for plugins.\\n            // TODO: May want to check so that all the elements in the collection are valid elements.\\n            elements = toArray(elements);\\n        } else {\\n            return reporter.error(\\\"Invalid arguments. Must be a DOM element or a collection of DOM elements.\\\");\\n        }\\n\\n        forEach(elements, function (element) {\\n            eventListenerHandler.removeAllListeners(element);\\n            detectionStrategy.uninstall(element);\\n            stateHandler.cleanState(element);\\n        });\\n    }\\n\\n    function initDocument(targetDocument) {\\n        detectionStrategy.initDocument && detectionStrategy.initDocument(targetDocument);\\n    }\\n\\n    return {\\n        listenTo: listenTo,\\n        removeListener: eventListenerHandler.removeListener,\\n        removeAllListeners: eventListenerHandler.removeAllListeners,\\n        uninstall: uninstall,\\n        initDocument: initDocument\\n    };\\n};\\n\\nfunction getOption(options, name, defaultValue) {\\n    var value = options[name];\\n\\n    if((value === undefined || value === null) && defaultValue !== undefined) {\\n        return defaultValue;\\n    }\\n\\n    return value;\\n}\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"isCollection\",\"obj\",\"Array\",\"isArray\",\"undefined\",\"length\",\"toArray\",\"collection\",\"array\",\"forEach\",\"push\",\"getOption\",\"options\",\"name\",\"defaultValue\",\"value\",\"elementUtilsMaker\",\"listenerHandlerMaker\",\"idGeneratorMaker\",\"idHandlerMaker\",\"reporterMaker\",\"browserDetector\",\"batchProcessorMaker\",\"stateHandler\",\"objectStrategyMaker\",\"scrollStrategyMaker\",\"module.exports\",\"idHandler\",\"get\",\"element\",\"set\",\"idGenerator\",\"defaultIdHandler\",\"reporter\",\"batchProcessor\",\"callOnAdd\",\"debug\",\"eventListenerHandler\",\"elementUtils\",\"desiredStrategy\",\"importantCssRules\",\"strategyOptions\",\"important\",\"isLegacyOpera\",\"warn\",\"isIE\",\"detectionStrategy\",\"Error\",\"onReadyCallbacks\",\"listenTo\",\"elements\",\"listener\",\"onResizeCallback\",\"listeners\",\"callListenerProxy\",\"addListener\",\"add\",\"nodeType\",\"error\",\"elementsReady\",\"onReadyCallback\",\"noop\",\"attachListenerToElement\",\"getState\",\"initState\",\"id\",\"log\",\"isDetectable\",\"isBusy\",\"onReady\",\"markBusy\",\"makeDetectable\",\"onElementDetectable\",\"markAsDetectable\",\"state\",\"startSize\",\"height\",\"offsetHeight\",\"width\",\"offsetWidth\",\"callback\",\"removeListener\",\"removeAllListeners\",\"uninstall\",\"cleanState\",\"initDocument\",\"targetDocument\"]\n}\n"]