["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/element-resize-detector/src/detection-strategy/object.js"],"~:js","shadow$provide[216]=function(ra,X,Ra,P){var w=X(212);Ra.exports=function(Z){function B(A){var y=Z.important?\" !important; \":\"; \";return(A.join(y)+y).trim()}Z=Z||{};var p=Z.reporter,c=Z.batchProcessor,u=Z.stateHandler.getState;if(!p)throw Error(\"Missing required dependency: reporter.\");return{makeDetectable:function(A,y,x){function Q(g,h){function b(){function t(){if(\"static\"===r.position){g.style.setProperty(\"position\",\"relative\",A.important?\"important\":\"\");var f=function(E,C,J,V){J=J[V];\"auto\"!==\nJ&&\"0\"!==J.replace(/[^-\\d\\.]/g,\"\")&&(E.warn(\"An element that is positioned static has style.\"+V+\"\\x3d\"+J+\" which is ignored due to the static positioning. The element will need to be positioned relative, so the style.\"+V+\" will be set to 0. Element: \",C),C.style.setProperty(V,\"0\",A.important?\"important\":\"\"))};f(p,g,r,\"top\");f(p,g,r,\"right\");f(p,g,r,\"bottom\");f(p,g,r,\"left\")}}\"\"!==r.position&&(t(r),k=!0);var q=document.createElement(\"object\");q.style.cssText=l;q.tabIndex=-1;q.type=\"text/html\";q.setAttribute(\"aria-hidden\",\n\"true\");q.onload=function(){function f(E,C){if(E.contentDocument)C(E.contentDocument);else{var J=u(E);J.checkForObjectDocumentTimeoutId&&window.clearTimeout(J.checkForObjectDocumentTimeoutId);J.checkForObjectDocumentTimeoutId=setTimeout(function(){J.checkForObjectDocumentTimeoutId=0;f(E,C)},100)}}k||t();f(this,function(E){h(g)})};w.isIE()||(q.data=\"about:blank\");u(g)&&(g.appendChild(q),u(g).object=q,w.isIE()&&(q.data=\"about:blank\"))}var l=B(\"display: block;position: absolute;top: 0;left: 0;width: 100%;height: 100%;border: none;padding: 0;margin: 0;opacity: 0;z-index: -1000;pointer-events: none\".split(\";\")),\nk=!1,r=window.getComputedStyle(g),D=g.offsetWidth,v=g.offsetHeight;u(g).startSize={width:D,height:v};c?c.add(b):b()}x||(x=y,y=A,A=null);A=A||{};w.isIE(8)?x(y):Q(y,x)},addListener:function(A,y){function x(){y(A)}if(w.isIE(8))u(A).object={proxy:x},A.attachEvent(\"onresize\",x);else{var Q=u(A).object;if(!Q)throw Error(\"Element is not detectable by this strategy.\");Q.contentDocument.defaultView.addEventListener(\"resize\",x)}},uninstall:function(A){if(u(A)){var y=u(A).object;y&&(w.isIE(8)?A.detachEvent(\"onresize\",\ny.proxy):A.removeChild(y),u(A).checkForObjectDocumentTimeoutId&&window.clearTimeout(u(A).checkForObjectDocumentTimeoutId),delete u(A).object)}}}}}","~:source","shadow$provide[216] = function(global,require,module,exports) {\n/**\n * Resize detection strategy that injects objects to elements in order to detect resize events.\n * Heavily inspired by: http://www.backalleycoder.com/2013/03/18/cross-browser-event-based-element-resize-detection/\n */\n\n\"use strict\";\n\nvar browserDetector = require(\"../browser-detector\");\n\nmodule.exports = function(options) {\n    options             = options || {};\n    var reporter        = options.reporter;\n    var batchProcessor  = options.batchProcessor;\n    var getState        = options.stateHandler.getState;\n\n    if(!reporter) {\n        throw new Error(\"Missing required dependency: reporter.\");\n    }\n\n    /**\n     * Adds a resize event listener to the element.\n     * @public\n     * @param {element} element The element that should have the listener added.\n     * @param {function} listener The listener callback to be called for each resize event of the element. The element will be given as a parameter to the listener callback.\n     */\n    function addListener(element, listener) {\n        function listenerProxy() {\n            listener(element);\n        }\n\n        if(browserDetector.isIE(8)) {\n            //IE 8 does not support object, but supports the resize event directly on elements.\n            getState(element).object = {\n                proxy: listenerProxy\n            };\n            element.attachEvent(\"onresize\", listenerProxy);\n        } else {\n            var object = getObject(element);\n\n            if(!object) {\n                throw new Error(\"Element is not detectable by this strategy.\");\n            }\n\n            object.contentDocument.defaultView.addEventListener(\"resize\", listenerProxy);\n        }\n    }\n\n    function buildCssTextString(rules) {\n        var seperator = options.important ? \" !important; \" : \"; \";\n\n        return (rules.join(seperator) + seperator).trim();\n    }\n\n    /**\n     * Makes an element detectable and ready to be listened for resize events. Will call the callback when the element is ready to be listened for resize changes.\n     * @private\n     * @param {object} options Optional options object.\n     * @param {element} element The element to make detectable\n     * @param {function} callback The callback to be called when the element is ready to be listened for resize changes. Will be called with the element as first parameter.\n     */\n    function makeDetectable(options, element, callback) {\n        if (!callback) {\n            callback = element;\n            element = options;\n            options = null;\n        }\n\n        options = options || {};\n        var debug = options.debug;\n\n        function injectObject(element, callback) {\n            var OBJECT_STYLE = buildCssTextString([\"display: block\", \"position: absolute\", \"top: 0\", \"left: 0\", \"width: 100%\", \"height: 100%\", \"border: none\", \"padding: 0\", \"margin: 0\", \"opacity: 0\", \"z-index: -1000\", \"pointer-events: none\"]);\n\n            //The target element needs to be positioned (everything except static) so the absolute positioned object will be positioned relative to the target element.\n\n            // Position altering may be performed directly or on object load, depending on if style resolution is possible directly or not.\n            var positionCheckPerformed = false;\n\n            // The element may not yet be attached to the DOM, and therefore the style object may be empty in some browsers.\n            // Since the style object is a reference, it will be updated as soon as the element is attached to the DOM.\n            var style = window.getComputedStyle(element);\n            var width = element.offsetWidth;\n            var height = element.offsetHeight;\n\n            getState(element).startSize = {\n                width: width,\n                height: height\n            };\n\n            function mutateDom() {\n                function alterPositionStyles() {\n                    if(style.position === \"static\") {\n                        element.style.setProperty(\"position\", \"relative\", options.important ? \"important\" : \"\");\n\n                        var removeRelativeStyles = function(reporter, element, style, property) {\n                            function getNumericalValue(value) {\n                                return value.replace(/[^-\\d\\.]/g, \"\");\n                            }\n\n                            var value = style[property];\n\n                            if(value !== \"auto\" && getNumericalValue(value) !== \"0\") {\n                                reporter.warn(\"An element that is positioned static has style.\" + property + \"=\" + value + \" which is ignored due to the static positioning. The element will need to be positioned relative, so the style.\" + property + \" will be set to 0. Element: \", element);\n                                element.style.setProperty(property, \"0\", options.important ? \"important\" : \"\");\n                            }\n                        };\n\n                        //Check so that there are no accidental styles that will make the element styled differently now that is is relative.\n                        //If there are any, set them to 0 (this should be okay with the user since the style properties did nothing before [since the element was positioned static] anyway).\n                        removeRelativeStyles(reporter, element, style, \"top\");\n                        removeRelativeStyles(reporter, element, style, \"right\");\n                        removeRelativeStyles(reporter, element, style, \"bottom\");\n                        removeRelativeStyles(reporter, element, style, \"left\");\n                    }\n                }\n\n                function onObjectLoad() {\n                    // The object has been loaded, which means that the element now is guaranteed to be attached to the DOM.\n                    if (!positionCheckPerformed) {\n                        alterPositionStyles();\n                    }\n\n                    /*jshint validthis: true */\n\n                    function getDocument(element, callback) {\n                        //Opera 12 seem to call the object.onload before the actual document has been created.\n                        //So if it is not present, poll it with an timeout until it is present.\n                        //TODO: Could maybe be handled better with object.onreadystatechange or similar.\n                        if(!element.contentDocument) {\n                            var state = getState(element);\n                            if (state.checkForObjectDocumentTimeoutId) {\n                                window.clearTimeout(state.checkForObjectDocumentTimeoutId);\n                            }\n                            state.checkForObjectDocumentTimeoutId = setTimeout(function checkForObjectDocument() {\n                                state.checkForObjectDocumentTimeoutId = 0;\n                                getDocument(element, callback);\n                            }, 100);\n\n                            return;\n                        }\n\n                        callback(element.contentDocument);\n                    }\n\n                    //Mutating the object element here seems to fire another load event.\n                    //Mutating the inner document of the object element is fine though.\n                    var objectElement = this;\n\n                    //Create the style element to be added to the object.\n                    getDocument(objectElement, function onObjectDocumentReady(objectDocument) {\n                        //Notify that the element is ready to be listened to.\n                        callback(element);\n                    });\n                }\n\n                // The element may be detached from the DOM, and some browsers does not support style resolving of detached elements.\n                // The alterPositionStyles needs to be delayed until we know the element has been attached to the DOM (which we are sure of when the onObjectLoad has been fired), if style resolution is not possible.\n                if (style.position !== \"\") {\n                    alterPositionStyles(style);\n                    positionCheckPerformed = true;\n                }\n\n                //Add an object element as a child to the target element that will be listened to for resize events.\n                var object = document.createElement(\"object\");\n                object.style.cssText = OBJECT_STYLE;\n                object.tabIndex = -1;\n                object.type = \"text/html\";\n                object.setAttribute(\"aria-hidden\", \"true\");\n                object.onload = onObjectLoad;\n\n                //Safari: This must occur before adding the object to the DOM.\n                //IE: Does not like that this happens before, even if it is also added after.\n                if(!browserDetector.isIE()) {\n                    object.data = \"about:blank\";\n                }\n\n                if (!getState(element)) {\n                    // The element has been uninstalled before the actual loading happened.\n                    return;\n                }\n\n                element.appendChild(object);\n                getState(element).object = object;\n\n                //IE: This must occur after adding the object to the DOM.\n                if(browserDetector.isIE()) {\n                    object.data = \"about:blank\";\n                }\n            }\n\n            if(batchProcessor) {\n                batchProcessor.add(mutateDom);\n            } else {\n                mutateDom();\n            }\n        }\n\n        if(browserDetector.isIE(8)) {\n            //IE 8 does not support objects properly. Luckily they do support the resize event.\n            //So do not inject the object and notify that the element is already ready to be listened to.\n            //The event handler for the resize event is attached in the utils.addListener instead.\n            callback(element);\n        } else {\n            injectObject(element, callback);\n        }\n    }\n\n    /**\n     * Returns the child object of the target element.\n     * @private\n     * @param {element} element The target element.\n     * @returns The object element of the target.\n     */\n    function getObject(element) {\n        return getState(element).object;\n    }\n\n    function uninstall(element) {\n        if (!getState(element)) {\n            return;\n        }\n\n        var object = getObject(element);\n\n        if (!object) {\n            return;\n        }\n\n        if (browserDetector.isIE(8)) {\n            element.detachEvent(\"onresize\", object.proxy);\n        } else {\n            element.removeChild(object);\n        }\n\n        if (getState(element).checkForObjectDocumentTimeoutId) {\n            window.clearTimeout(getState(element).checkForObjectDocumentTimeoutId);\n        }\n\n        delete getState(element).object;\n    }\n\n    return {\n        makeDetectable: makeDetectable,\n        addListener: addListener,\n        uninstall: uninstall\n    };\n};\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$element_resize_detector$src$browser_detector"]],"~:properties",["^5",["object","checkForObjectDocumentTimeoutId","width","makeDetectable","startSize","height","tabIndex","uninstall","addListener","onload","type","cssText","proxy","data"]],"~:compiled-at",1766065009573,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$element_resize_detector$src$detection_strategy$object.js\",\n\"lineCount\":5,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAQ9D,IAAIC,EAAkBH,CAAA,CAAQ,GAAR,CAEtBC,GAAOC,CAAAA,OAAP,CAAiBE,QAAQ,CAACC,CAAD,CAAU,CAsC/BC,QAASA,EAAkB,CAACC,CAAD,CAAQ,CAC/B,IAAIC,EAAYH,CAAQI,CAAAA,SAAR,CAAoB,eAApB,CAAsC,IAEtD,OAA2CC,CAAnCH,CAAMI,CAAAA,IAAN,CAAWH,CAAX,CAAmCE,CAAXF,CAAWE,EAAAA,IAApC,EAHwB,CArCnCL,CAAA,CAAsBA,CAAtB,EAAiC,EACjC,KAAIO,EAAkBP,CAAQO,CAAAA,QAA9B,CACIC,EAAkBR,CAAQQ,CAAAA,cAD9B,CAEIC,EAAkBT,CAAQU,CAAAA,YAAaD,CAAAA,QAE3C,IAAG,CAACF,CAAJ,CACI,KAAUI,MAAJ,CAAU,wCAAV,CAAN,CAiOJ,MAAO,CACHC,eAtLJA,QAAuB,CAACZ,CAAD,CAAUa,CAAV,CAAmBC,CAAnB,CAA6B,CAUhDC,QAASA,EAAY,CAACF,CAAD,CAAUC,CAAV,CAAoB,CAmBrCE,QAASA,EAAS,EAAG,CACjBC,QAASA,EAAmB,EAAG,CAC3B,GAAsB,QAAtB,GAAGC,CAAMC,CAAAA,QAAT,CAAgC,CAC5BN,CAAQK,CAAAA,KAAME,CAAAA,WAAd,CAA0B,UAA1B,CAAsC,UAAtC,CAAkDpB,CAAQI,CAAAA,SAAR,CAAoB,WAApB,CAAkC,EAApF,CAEA,KAAIiB,EAAuBA,QAAQ,CAACd,CAAD,CAAWM,CAAX,CAAoBK,CAApB,CAA2BI,CAA3B,CAAqC,CAKhEC,CAAAA,CAAQL,CAAA,CAAMI,CAAN,CAEC,OAAb;AAAGC,CAAH,EAAoD,GAApD,GAAyCA,CALxBC,CAAAA,OAAN,CAAc,WAAd,CAA2B,EAA3B,CAKX,GACIjB,CAASkB,CAAAA,IAAT,CAAc,iDAAd,CAAkEH,CAAlE,CAA6E,MAA7E,CAAmFC,CAAnF,CAA2F,iHAA3F,CAA+MD,CAA/M,CAA0N,8BAA1N,CAA0PT,CAA1P,CACA,CAAAA,CAAQK,CAAAA,KAAME,CAAAA,WAAd,CAA0BE,CAA1B,CAAoC,GAApC,CAAyCtB,CAAQI,CAAAA,SAAR,CAAoB,WAApB,CAAkC,EAA3E,CAFJ,CAPoE,CAexEiB,EAAA,CAAqBd,CAArB,CAA+BM,CAA/B,CAAwCK,CAAxC,CAA+C,KAA/C,CACAG,EAAA,CAAqBd,CAArB,CAA+BM,CAA/B,CAAwCK,CAAxC,CAA+C,OAA/C,CACAG,EAAA,CAAqBd,CAArB,CAA+BM,CAA/B,CAAwCK,CAAxC,CAA+C,QAA/C,CACAG,EAAA,CAAqBd,CAArB,CAA+BM,CAA/B,CAAwCK,CAAxC,CAA+C,MAA/C,CArB4B,CADL,CAmER,EAAvB,GAAIA,CAAMC,CAAAA,QAAV,GACIF,CAAA,CAAoBC,CAApB,CACA,CAAAQ,CAAA,CAAyB,CAAA,CAF7B,CAMA,KAAIC,EAASC,QAASC,CAAAA,aAAT,CAAuB,QAAvB,CACbF,EAAOT,CAAAA,KAAMY,CAAAA,OAAb,CAAuBC,CACvBJ,EAAOK,CAAAA,QAAP,CAAkB,CAAC,CACnBL,EAAOM,CAAAA,IAAP,CAAc,WACdN,EAAOO,CAAAA,YAAP,CAAoB,aAApB;AAAmC,MAAnC,CACAP,EAAOQ,CAAAA,MAAP,CApDAC,QAAqB,EAAG,CAQpBC,QAASA,EAAW,CAACxB,CAAD,CAAUC,CAAV,CAAoB,CAIpC,GAAID,CAAQyB,CAAAA,eAAZ,CAaAxB,CAAA,CAASD,CAAQyB,CAAAA,eAAjB,CAbA,KAA6B,CACzB,IAAIC,EAAQ9B,CAAA,CAASI,CAAT,CACR0B,EAAMC,CAAAA,+BAAV,EACIC,MAAOC,CAAAA,YAAP,CAAoBH,CAAMC,CAAAA,+BAA1B,CAEJD,EAAMC,CAAAA,+BAAN,CAAwCG,UAAA,CAAWC,QAA+B,EAAG,CACjFL,CAAMC,CAAAA,+BAAN,CAAwC,CACxCH,EAAA,CAAYxB,CAAZ,CAAqBC,CAArB,CAFiF,CAA7C,CAGrC,GAHqC,CALf,CAJO,CANnCY,CAAL,EACIT,CAAA,EA8BJoB,EAAA,CAHoBQ,IAGpB,CAA2BC,QAA8B,CAACC,CAAD,CAAiB,CAEtEjC,CAAA,CAASD,CAAT,CAFsE,CAA1E,CAjCoB,CAwDpBf,EAAgBkD,CAAAA,IAAhB,EAAJ,GACIrB,CAAOsB,CAAAA,IADX,CACkB,aADlB,CAIKxC,EAAA,CAASI,CAAT,CAAL,GAKAA,CAAQqC,CAAAA,WAAR,CAAoBvB,CAApB,CAIA,CAHAlB,CAAA,CAASI,CAAT,CAAkBc,CAAAA,MAGlB,CAH2BA,CAG3B,CAAG7B,CAAgBkD,CAAAA,IAAhB,EAAH,GACIrB,CAAOsB,CAAAA,IADX,CACkB,aADlB,CATA,CAvFiB,CAlBrB,IAAIlB,EAAe9B,CAAA,CAAmB,4JAAA,CAAA,KAAA,CAAA,GAAA,CAAnB,CAAnB;AAKIyB,EAAyB,CAAA,CAL7B,CASIR,EAAQuB,MAAOU,CAAAA,gBAAP,CAAwBtC,CAAxB,CATZ,CAUIuC,EAAQvC,CAAQwC,CAAAA,WAVpB,CAWIC,EAASzC,CAAQ0C,CAAAA,YAErB9C,EAAA,CAASI,CAAT,CAAkB2C,CAAAA,SAAlB,CAA8B,CAC1BJ,MAAOA,CADmB,CAE1BE,OAAQA,CAFkB,CA0G3B9C,EAAH,CACIA,CAAeiD,CAAAA,GAAf,CAAmBzC,CAAnB,CADJ,CAGIA,CAAA,EA3HiC,CATpCF,CAAL,GACIA,CAEA,CAFWD,CAEX,CADAA,CACA,CADUb,CACV,CAAAA,CAAA,CAAU,IAHd,CAMAA,EAAA,CAAUA,CAAV,EAAqB,EAkIlBF,EAAgBkD,CAAAA,IAAhB,CAAqB,CAArB,CAAH,CAIIlC,CAAA,CAASD,CAAT,CAJJ,CAMIE,CAAA,CAAaF,CAAb,CAAsBC,CAAtB,CA/I4C,CAqL7C,CAEH4C,YA1NJA,QAAoB,CAAC7C,CAAD,CAAU8C,CAAV,CAAoB,CACpCC,QAASA,EAAa,EAAG,CACrBD,CAAA,CAAS9C,CAAT,CADqB,CAIzB,GAAGf,CAAgBkD,CAAAA,IAAhB,CAAqB,CAArB,CAAH,CAEIvC,CAAA,CAASI,CAAT,CAAkBc,CAAAA,MAGlB,CAH2B,CACvBkC,MAAOD,CADgB,CAG3B,CAAA/C,CAAQiD,CAAAA,WAAR,CAAoB,UAApB,CAAgCF,CAAhC,CALJ,KAMO,CACH,IAAIjC,EAiLDlB,CAAA,CAjLoBI,CAiLpB,CAAkBc,CAAAA,MA/KrB,IAAG,CAACA,CAAJ,CACI,KAAUhB,MAAJ,CAAU,6CAAV,CAAN,CAGJgB,CAAOW,CAAAA,eAAgByB,CAAAA,WAAYC,CAAAA,gBAAnC,CAAoD,QAApD,CAA8DJ,CAA9D,CAPG,CAX6B,CAwNjC,CAGHK,UA3BJA,QAAkB,CAACpD,CAAD,CAAU,CACxB,GAAKJ,CAAA,CAASI,CAAT,CAAL,CAAA,CAIA,IAAIc,EARGlB,CAAA,CAQgBI,CARhB,CAAkBc,CAAAA,MAUpBA,EAAL,GAII7B,CAAgBkD,CAAAA,IAAhB,CAAqB,CAArB,CAAJ,CACInC,CAAQqD,CAAAA,WAAR,CAAoB,UAApB;AAAgCvC,CAAOkC,CAAAA,KAAvC,CADJ,CAGIhD,CAAQsD,CAAAA,WAAR,CAAoBxC,CAApB,CAOJ,CAJIlB,CAAA,CAASI,CAAT,CAAkB2B,CAAAA,+BAItB,EAHIC,MAAOC,CAAAA,YAAP,CAAoBjC,CAAA,CAASI,CAAT,CAAkB2B,CAAAA,+BAAtC,CAGJ,CAAA,OAAO/B,CAAA,CAASI,CAAT,CAAkBc,CAAAA,MAdzB,CANA,CADwB,CAwBrB,CAxOwB,CAV2B;\",\n\"sources\":[\"node_modules/element-resize-detector/src/detection-strategy/object.js\"],\n\"sourcesContent\":[\"shadow$provide[216] = function(global,require,module,exports) {\\n/**\\n * Resize detection strategy that injects objects to elements in order to detect resize events.\\n * Heavily inspired by: http://www.backalleycoder.com/2013/03/18/cross-browser-event-based-element-resize-detection/\\n */\\n\\n\\\"use strict\\\";\\n\\nvar browserDetector = require(\\\"../browser-detector\\\");\\n\\nmodule.exports = function(options) {\\n    options             = options || {};\\n    var reporter        = options.reporter;\\n    var batchProcessor  = options.batchProcessor;\\n    var getState        = options.stateHandler.getState;\\n\\n    if(!reporter) {\\n        throw new Error(\\\"Missing required dependency: reporter.\\\");\\n    }\\n\\n    /**\\n     * Adds a resize event listener to the element.\\n     * @public\\n     * @param {element} element The element that should have the listener added.\\n     * @param {function} listener The listener callback to be called for each resize event of the element. The element will be given as a parameter to the listener callback.\\n     */\\n    function addListener(element, listener) {\\n        function listenerProxy() {\\n            listener(element);\\n        }\\n\\n        if(browserDetector.isIE(8)) {\\n            //IE 8 does not support object, but supports the resize event directly on elements.\\n            getState(element).object = {\\n                proxy: listenerProxy\\n            };\\n            element.attachEvent(\\\"onresize\\\", listenerProxy);\\n        } else {\\n            var object = getObject(element);\\n\\n            if(!object) {\\n                throw new Error(\\\"Element is not detectable by this strategy.\\\");\\n            }\\n\\n            object.contentDocument.defaultView.addEventListener(\\\"resize\\\", listenerProxy);\\n        }\\n    }\\n\\n    function buildCssTextString(rules) {\\n        var seperator = options.important ? \\\" !important; \\\" : \\\"; \\\";\\n\\n        return (rules.join(seperator) + seperator).trim();\\n    }\\n\\n    /**\\n     * Makes an element detectable and ready to be listened for resize events. Will call the callback when the element is ready to be listened for resize changes.\\n     * @private\\n     * @param {object} options Optional options object.\\n     * @param {element} element The element to make detectable\\n     * @param {function} callback The callback to be called when the element is ready to be listened for resize changes. Will be called with the element as first parameter.\\n     */\\n    function makeDetectable(options, element, callback) {\\n        if (!callback) {\\n            callback = element;\\n            element = options;\\n            options = null;\\n        }\\n\\n        options = options || {};\\n        var debug = options.debug;\\n\\n        function injectObject(element, callback) {\\n            var OBJECT_STYLE = buildCssTextString([\\\"display: block\\\", \\\"position: absolute\\\", \\\"top: 0\\\", \\\"left: 0\\\", \\\"width: 100%\\\", \\\"height: 100%\\\", \\\"border: none\\\", \\\"padding: 0\\\", \\\"margin: 0\\\", \\\"opacity: 0\\\", \\\"z-index: -1000\\\", \\\"pointer-events: none\\\"]);\\n\\n            //The target element needs to be positioned (everything except static) so the absolute positioned object will be positioned relative to the target element.\\n\\n            // Position altering may be performed directly or on object load, depending on if style resolution is possible directly or not.\\n            var positionCheckPerformed = false;\\n\\n            // The element may not yet be attached to the DOM, and therefore the style object may be empty in some browsers.\\n            // Since the style object is a reference, it will be updated as soon as the element is attached to the DOM.\\n            var style = window.getComputedStyle(element);\\n            var width = element.offsetWidth;\\n            var height = element.offsetHeight;\\n\\n            getState(element).startSize = {\\n                width: width,\\n                height: height\\n            };\\n\\n            function mutateDom() {\\n                function alterPositionStyles() {\\n                    if(style.position === \\\"static\\\") {\\n                        element.style.setProperty(\\\"position\\\", \\\"relative\\\", options.important ? \\\"important\\\" : \\\"\\\");\\n\\n                        var removeRelativeStyles = function(reporter, element, style, property) {\\n                            function getNumericalValue(value) {\\n                                return value.replace(/[^-\\\\d\\\\.]/g, \\\"\\\");\\n                            }\\n\\n                            var value = style[property];\\n\\n                            if(value !== \\\"auto\\\" && getNumericalValue(value) !== \\\"0\\\") {\\n                                reporter.warn(\\\"An element that is positioned static has style.\\\" + property + \\\"=\\\" + value + \\\" which is ignored due to the static positioning. The element will need to be positioned relative, so the style.\\\" + property + \\\" will be set to 0. Element: \\\", element);\\n                                element.style.setProperty(property, \\\"0\\\", options.important ? \\\"important\\\" : \\\"\\\");\\n                            }\\n                        };\\n\\n                        //Check so that there are no accidental styles that will make the element styled differently now that is is relative.\\n                        //If there are any, set them to 0 (this should be okay with the user since the style properties did nothing before [since the element was positioned static] anyway).\\n                        removeRelativeStyles(reporter, element, style, \\\"top\\\");\\n                        removeRelativeStyles(reporter, element, style, \\\"right\\\");\\n                        removeRelativeStyles(reporter, element, style, \\\"bottom\\\");\\n                        removeRelativeStyles(reporter, element, style, \\\"left\\\");\\n                    }\\n                }\\n\\n                function onObjectLoad() {\\n                    // The object has been loaded, which means that the element now is guaranteed to be attached to the DOM.\\n                    if (!positionCheckPerformed) {\\n                        alterPositionStyles();\\n                    }\\n\\n                    /*jshint validthis: true */\\n\\n                    function getDocument(element, callback) {\\n                        //Opera 12 seem to call the object.onload before the actual document has been created.\\n                        //So if it is not present, poll it with an timeout until it is present.\\n                        //TODO: Could maybe be handled better with object.onreadystatechange or similar.\\n                        if(!element.contentDocument) {\\n                            var state = getState(element);\\n                            if (state.checkForObjectDocumentTimeoutId) {\\n                                window.clearTimeout(state.checkForObjectDocumentTimeoutId);\\n                            }\\n                            state.checkForObjectDocumentTimeoutId = setTimeout(function checkForObjectDocument() {\\n                                state.checkForObjectDocumentTimeoutId = 0;\\n                                getDocument(element, callback);\\n                            }, 100);\\n\\n                            return;\\n                        }\\n\\n                        callback(element.contentDocument);\\n                    }\\n\\n                    //Mutating the object element here seems to fire another load event.\\n                    //Mutating the inner document of the object element is fine though.\\n                    var objectElement = this;\\n\\n                    //Create the style element to be added to the object.\\n                    getDocument(objectElement, function onObjectDocumentReady(objectDocument) {\\n                        //Notify that the element is ready to be listened to.\\n                        callback(element);\\n                    });\\n                }\\n\\n                // The element may be detached from the DOM, and some browsers does not support style resolving of detached elements.\\n                // The alterPositionStyles needs to be delayed until we know the element has been attached to the DOM (which we are sure of when the onObjectLoad has been fired), if style resolution is not possible.\\n                if (style.position !== \\\"\\\") {\\n                    alterPositionStyles(style);\\n                    positionCheckPerformed = true;\\n                }\\n\\n                //Add an object element as a child to the target element that will be listened to for resize events.\\n                var object = document.createElement(\\\"object\\\");\\n                object.style.cssText = OBJECT_STYLE;\\n                object.tabIndex = -1;\\n                object.type = \\\"text/html\\\";\\n                object.setAttribute(\\\"aria-hidden\\\", \\\"true\\\");\\n                object.onload = onObjectLoad;\\n\\n                //Safari: This must occur before adding the object to the DOM.\\n                //IE: Does not like that this happens before, even if it is also added after.\\n                if(!browserDetector.isIE()) {\\n                    object.data = \\\"about:blank\\\";\\n                }\\n\\n                if (!getState(element)) {\\n                    // The element has been uninstalled before the actual loading happened.\\n                    return;\\n                }\\n\\n                element.appendChild(object);\\n                getState(element).object = object;\\n\\n                //IE: This must occur after adding the object to the DOM.\\n                if(browserDetector.isIE()) {\\n                    object.data = \\\"about:blank\\\";\\n                }\\n            }\\n\\n            if(batchProcessor) {\\n                batchProcessor.add(mutateDom);\\n            } else {\\n                mutateDom();\\n            }\\n        }\\n\\n        if(browserDetector.isIE(8)) {\\n            //IE 8 does not support objects properly. Luckily they do support the resize event.\\n            //So do not inject the object and notify that the element is already ready to be listened to.\\n            //The event handler for the resize event is attached in the utils.addListener instead.\\n            callback(element);\\n        } else {\\n            injectObject(element, callback);\\n        }\\n    }\\n\\n    /**\\n     * Returns the child object of the target element.\\n     * @private\\n     * @param {element} element The target element.\\n     * @returns The object element of the target.\\n     */\\n    function getObject(element) {\\n        return getState(element).object;\\n    }\\n\\n    function uninstall(element) {\\n        if (!getState(element)) {\\n            return;\\n        }\\n\\n        var object = getObject(element);\\n\\n        if (!object) {\\n            return;\\n        }\\n\\n        if (browserDetector.isIE(8)) {\\n            element.detachEvent(\\\"onresize\\\", object.proxy);\\n        } else {\\n            element.removeChild(object);\\n        }\\n\\n        if (getState(element).checkForObjectDocumentTimeoutId) {\\n            window.clearTimeout(getState(element).checkForObjectDocumentTimeoutId);\\n        }\\n\\n        delete getState(element).object;\\n    }\\n\\n    return {\\n        makeDetectable: makeDetectable,\\n        addListener: addListener,\\n        uninstall: uninstall\\n    };\\n};\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"browserDetector\",\"module.exports\",\"options\",\"buildCssTextString\",\"rules\",\"seperator\",\"important\",\"trim\",\"join\",\"reporter\",\"batchProcessor\",\"getState\",\"stateHandler\",\"Error\",\"makeDetectable\",\"element\",\"callback\",\"injectObject\",\"mutateDom\",\"alterPositionStyles\",\"style\",\"position\",\"setProperty\",\"removeRelativeStyles\",\"property\",\"value\",\"replace\",\"warn\",\"positionCheckPerformed\",\"object\",\"document\",\"createElement\",\"cssText\",\"OBJECT_STYLE\",\"tabIndex\",\"type\",\"setAttribute\",\"onload\",\"onObjectLoad\",\"getDocument\",\"contentDocument\",\"state\",\"checkForObjectDocumentTimeoutId\",\"window\",\"clearTimeout\",\"setTimeout\",\"checkForObjectDocument\",\"objectElement\",\"onObjectDocumentReady\",\"objectDocument\",\"isIE\",\"data\",\"appendChild\",\"getComputedStyle\",\"width\",\"offsetWidth\",\"height\",\"offsetHeight\",\"startSize\",\"add\",\"addListener\",\"listener\",\"listenerProxy\",\"proxy\",\"attachEvent\",\"defaultView\",\"addEventListener\",\"uninstall\",\"detachEvent\",\"removeChild\"]\n}\n"]