["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/chrono-node/dist/locales/nl/parsers/NLCasualDateTimeParser.js"],"~:js","shadow$provide[113]=function(ra,X,Ra,P){ra=this&&this.__importDefault||function(c){return c&&c.__esModule?c:{\"default\":c}};Object.defineProperty(P,\"__esModule\",{value:!0});Ra=X(29);const w=X(115),Z=X(27),B=ra(X(23));class p extends Ra.AbstractParserWithWordBoundaryChecking{innerPattern(c){return/(gisteren|morgen|van)(ochtend|middag|namiddag|avond|nacht)(?=\\W|$)/i}innerExtract(c,u){const A=u[1].toLowerCase();u=u[2].toLowerCase();const y=c.createParsingComponents();c=B.default(c.refDate);switch(A){case \"gisteren\":Z.assignSimilarDate(y,\nc.add(-1,\"day\"));break;case \"van\":Z.assignSimilarDate(y,c);break;case \"morgen\":Z.assignTheNextDay(y,c)}switch(u){case \"ochtend\":y.imply(\"meridiem\",w.Meridiem.AM);y.imply(\"hour\",6);break;case \"middag\":y.imply(\"meridiem\",w.Meridiem.AM);y.imply(\"hour\",12);break;case \"namiddag\":y.imply(\"meridiem\",w.Meridiem.PM);y.imply(\"hour\",15);break;case \"avond\":y.imply(\"meridiem\",w.Meridiem.PM),y.imply(\"hour\",20)}return y}}P.default=p}","~:source","shadow$provide[113] = function(global,require,module,exports) {\n\"use strict\";\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { \"default\": mod };\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nconst AbstractParserWithWordBoundary_1 = require(\"../../../common/parsers/AbstractParserWithWordBoundary\");\nconst index_1 = require(\"../../../index\");\nconst dayjs_1 = require(\"../../../utils/dayjs\");\nconst dayjs_2 = __importDefault(require(\"dayjs\"));\nconst DATE_GROUP = 1;\nconst TIME_OF_DAY_GROUP = 2;\nclass NLCasualDateTimeParser extends AbstractParserWithWordBoundary_1.AbstractParserWithWordBoundaryChecking {\n    innerPattern(context) {\n        return /(gisteren|morgen|van)(ochtend|middag|namiddag|avond|nacht)(?=\\W|$)/i;\n    }\n    innerExtract(context, match) {\n        const dateText = match[DATE_GROUP].toLowerCase();\n        const timeText = match[TIME_OF_DAY_GROUP].toLowerCase();\n        const component = context.createParsingComponents();\n        const targetDate = dayjs_2.default(context.refDate);\n        switch (dateText) {\n            case \"gisteren\":\n                dayjs_1.assignSimilarDate(component, targetDate.add(-1, \"day\"));\n                break;\n            case \"van\":\n                dayjs_1.assignSimilarDate(component, targetDate);\n                break;\n            case \"morgen\":\n                dayjs_1.assignTheNextDay(component, targetDate);\n                break;\n        }\n        switch (timeText) {\n            case \"ochtend\":\n                component.imply(\"meridiem\", index_1.Meridiem.AM);\n                component.imply(\"hour\", 6);\n                break;\n            case \"middag\":\n                component.imply(\"meridiem\", index_1.Meridiem.AM);\n                component.imply(\"hour\", 12);\n                break;\n            case \"namiddag\":\n                component.imply(\"meridiem\", index_1.Meridiem.PM);\n                component.imply(\"hour\", 15);\n                break;\n            case \"avond\":\n                component.imply(\"meridiem\", index_1.Meridiem.PM);\n                component.imply(\"hour\", 20);\n                break;\n        }\n        return component;\n    }\n}\nexports.default = NLCasualDateTimeParser;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$chrono_node$dist$index","~$module$node_modules$chrono_node$dist$utils$dayjs","~$shadow.js","~$module$node_modules$chrono_node$dist$common$parsers$AbstractParserWithWordBoundary","~$module$node_modules$dayjs$dayjs_min"]],"~:properties",["^5",["__esModule","value","default"]],"~:compiled-at",1766065009523,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$chrono_node$dist$locales$nl$parsers$NLCasualDateTimeParser.js\",\n\"lineCount\":2,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAE1DC,EAAAA,CAAmB,IAAnBA,EAA2B,IAAKA,CAAAA,eAAhCA,EAAoD,QAAS,CAACC,CAAD,CAAM,CACnE,MAAQA,EAAD,EAAQA,CAAIC,CAAAA,UAAZ,CAA0BD,CAA1B,CAAgC,CAAE,UAAWA,CAAb,CAD4B,CAGvEE,OAAOC,CAAAA,cAAP,CAAsBL,CAAtB,CAA+B,YAA/B,CAA6C,CAAEM,MAAO,CAAA,CAAT,CAA7C,CACMC,GAAAA,CAAmCT,CAAA,CAAQ,EAAR,CACzC,OAAMU,EAAUV,CAAA,CAAQ,GAAR,CAAhB,CACMW,EAAUX,CAAA,CAAQ,EAAR,CADhB,CAEMY,EAAUT,EAAA,CAAgBH,CAAA,CAAQ,EAAR,CAAhB,CAGhB,MAAMa,EAAN,QAAqCJ,GAAiCK,CAAAA,sCAAtE,CACIC,YAAY,CAACC,CAAD,CAAU,CAClB,MAAO,qEADW,CAGtBC,YAAY,CAACD,CAAD,CAAUE,CAAV,CAAiB,CACzB,MAAMC,EAAWD,CAAA,CAPNE,CAOM,CAAkBC,CAAAA,WAAlB,EACXC,EAAAA,CAAWJ,CAAA,CAPCK,CAOD,CAAyBF,CAAAA,WAAzB,EACjB,OAAMG,EAAYR,CAAQS,CAAAA,uBAAR,EACZC,EAAAA,CAAad,CAAQe,CAAAA,OAAR,CAAgBX,CAAQY,CAAAA,OAAxB,CACnB,QAAQT,CAAR,EACI,KAAK,UAAL,CACIR,CAAQkB,CAAAA,iBAAR,CAA0BL,CAA1B;AAAqCE,CAAWI,CAAAA,GAAX,CAAe,CAAC,CAAhB,CAAmB,KAAnB,CAArC,CACA,MACJ,MAAK,KAAL,CACInB,CAAQkB,CAAAA,iBAAR,CAA0BL,CAA1B,CAAqCE,CAArC,CACA,MACJ,MAAK,QAAL,CACIf,CAAQoB,CAAAA,gBAAR,CAAyBP,CAAzB,CAAoCE,CAApC,CARR,CAWA,OAAQJ,CAAR,EACI,KAAK,SAAL,CACIE,CAAUQ,CAAAA,KAAV,CAAgB,UAAhB,CAA4BtB,CAAQuB,CAAAA,QAASC,CAAAA,EAA7C,CACAV,EAAUQ,CAAAA,KAAV,CAAgB,MAAhB,CAAwB,CAAxB,CACA,MACJ,MAAK,QAAL,CACIR,CAAUQ,CAAAA,KAAV,CAAgB,UAAhB,CAA4BtB,CAAQuB,CAAAA,QAASC,CAAAA,EAA7C,CACAV,EAAUQ,CAAAA,KAAV,CAAgB,MAAhB,CAAwB,EAAxB,CACA,MACJ,MAAK,UAAL,CACIR,CAAUQ,CAAAA,KAAV,CAAgB,UAAhB,CAA4BtB,CAAQuB,CAAAA,QAASE,CAAAA,EAA7C,CACAX,EAAUQ,CAAAA,KAAV,CAAgB,MAAhB,CAAwB,EAAxB,CACA,MACJ,MAAK,OAAL,CACIR,CAAUQ,CAAAA,KAAV,CAAgB,UAAhB,CAA4BtB,CAAQuB,CAAAA,QAASE,CAAAA,EAA7C,CACA,CAAAX,CAAUQ,CAAAA,KAAV,CAAgB,MAAhB,CAAwB,EAAxB,CAfR,CAkBA,MAAOR,EAlCkB,CAJjC,CAyCAtB,CAAQyB,CAAAA,OAAR,CAAkBd,CArD4C;\",\n\"sources\":[\"node_modules/chrono-node/dist/locales/nl/parsers/NLCasualDateTimeParser.js\"],\n\"sourcesContent\":[\"shadow$provide[113] = function(global,require,module,exports) {\\n\\\"use strict\\\";\\nvar __importDefault = (this && this.__importDefault) || function (mod) {\\n    return (mod && mod.__esModule) ? mod : { \\\"default\\\": mod };\\n};\\nObject.defineProperty(exports, \\\"__esModule\\\", { value: true });\\nconst AbstractParserWithWordBoundary_1 = require(\\\"../../../common/parsers/AbstractParserWithWordBoundary\\\");\\nconst index_1 = require(\\\"../../../index\\\");\\nconst dayjs_1 = require(\\\"../../../utils/dayjs\\\");\\nconst dayjs_2 = __importDefault(require(\\\"dayjs\\\"));\\nconst DATE_GROUP = 1;\\nconst TIME_OF_DAY_GROUP = 2;\\nclass NLCasualDateTimeParser extends AbstractParserWithWordBoundary_1.AbstractParserWithWordBoundaryChecking {\\n    innerPattern(context) {\\n        return /(gisteren|morgen|van)(ochtend|middag|namiddag|avond|nacht)(?=\\\\W|$)/i;\\n    }\\n    innerExtract(context, match) {\\n        const dateText = match[DATE_GROUP].toLowerCase();\\n        const timeText = match[TIME_OF_DAY_GROUP].toLowerCase();\\n        const component = context.createParsingComponents();\\n        const targetDate = dayjs_2.default(context.refDate);\\n        switch (dateText) {\\n            case \\\"gisteren\\\":\\n                dayjs_1.assignSimilarDate(component, targetDate.add(-1, \\\"day\\\"));\\n                break;\\n            case \\\"van\\\":\\n                dayjs_1.assignSimilarDate(component, targetDate);\\n                break;\\n            case \\\"morgen\\\":\\n                dayjs_1.assignTheNextDay(component, targetDate);\\n                break;\\n        }\\n        switch (timeText) {\\n            case \\\"ochtend\\\":\\n                component.imply(\\\"meridiem\\\", index_1.Meridiem.AM);\\n                component.imply(\\\"hour\\\", 6);\\n                break;\\n            case \\\"middag\\\":\\n                component.imply(\\\"meridiem\\\", index_1.Meridiem.AM);\\n                component.imply(\\\"hour\\\", 12);\\n                break;\\n            case \\\"namiddag\\\":\\n                component.imply(\\\"meridiem\\\", index_1.Meridiem.PM);\\n                component.imply(\\\"hour\\\", 15);\\n                break;\\n            case \\\"avond\\\":\\n                component.imply(\\\"meridiem\\\", index_1.Meridiem.PM);\\n                component.imply(\\\"hour\\\", 20);\\n                break;\\n        }\\n        return component;\\n    }\\n}\\nexports.default = NLCasualDateTimeParser;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"__importDefault\",\"mod\",\"__esModule\",\"Object\",\"defineProperty\",\"value\",\"AbstractParserWithWordBoundary_1\",\"index_1\",\"dayjs_1\",\"dayjs_2\",\"NLCasualDateTimeParser\",\"AbstractParserWithWordBoundaryChecking\",\"innerPattern\",\"context\",\"innerExtract\",\"match\",\"dateText\",\"DATE_GROUP\",\"toLowerCase\",\"timeText\",\"TIME_OF_DAY_GROUP\",\"component\",\"createParsingComponents\",\"targetDate\",\"default\",\"refDate\",\"assignSimilarDate\",\"add\",\"assignTheNextDay\",\"imply\",\"Meridiem\",\"AM\",\"PM\"]\n}\n"]