["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/chrono-node/dist/common/parsers/AbstractTimeExpressionParser.js"],"~:js","shadow$provide[36]=function(ra,X,Ra,P){ra=this&&this.__importDefault||function(p){return p&&p.__esModule?p:{\"default\":p}};Object.defineProperty(P,\"__esModule\",{value:!0});P.AbstractTimeExpressionParser=void 0;const w=X(115),Z=ra(X(23));class B{constructor(p=!1){this.cachedFollowingTimePatten=this.cachedFollowingSuffix=this.cachedFollowingPhase=this.cachedPrimaryTimePattern=this.cachedPrimarySuffix=this.cachedPrimaryPrefix=null;this.strictMode=p}primarySuffix(){return\"(?\\x3d\\\\W|$)\"}followingSuffix(){return\"(?\\x3d\\\\W|$)\"}pattern(p){return this.getPrimaryTimePatternThroughCache()}extract(p,\nc){const u=Z.default(p.refDate),A=p.createParsingResult(c.index+c[1].length,c[0].substring(c[1].length));A.start.imply(\"day\",u.date());A.start.imply(\"month\",u.month()+1);A.start.imply(\"year\",u.year());A.start=this.extractPrimaryTimeComponents(p,c);if(!A.start)return c.index+=c[0].length,null;c=p.text.substring(c.index+c[0].length);c=this.getFollowingTimePatternThroughCache().exec(c);if(!c||c[0].match(/^\\s*([+-])\\s*\\d{3,4}$/))return this.checkAndReturnWithoutFollowingPattern(A);A.end=this.extractFollowingTimeComponents(p,\nc,A);A.end&&A.end&&(A.text+=c[0]);return A}extractPrimaryTimeComponents(p,c,u){p=p.createParsingComponents();let A=0,y=null;u=parseInt(c[2]);if(null!=c[3]){if(1==c[3].length&&!c[6])return null;A=parseInt(c[3])}else if(100<u){if(this.strictMode)return null;A=u%100;u=Math.floor(u/100)}if(60<=A||24<u)return null;12<u&&(y=w.Meridiem.PM);if(null!=c[6]){if(12<u)return null;const x=c[6][0].toLowerCase();\"a\"==x&&(y=w.Meridiem.AM,12==u&&(u=0));\"p\"==x&&(y=w.Meridiem.PM,12!=u&&(u+=12))}p.assign(\"hour\",u);p.assign(\"minute\",\nA);null!==y?p.assign(\"meridiem\",y):12>u?p.imply(\"meridiem\",w.Meridiem.AM):p.imply(\"meridiem\",w.Meridiem.PM);if(null!=c[5]){u=parseInt(c[5].substring(0,3));if(1E3<=u)return null;p.assign(\"millisecond\",u)}if(null!=c[4]){c=parseInt(c[4]);if(60<=c)return null;p.assign(\"second\",c)}return p}extractFollowingTimeComponents(p,c,u){p=p.createParsingComponents();if(null!=c[5]){var A=parseInt(c[5].substring(0,3));if(1E3<=A)return null;p.assign(\"millisecond\",A)}if(null!=c[4]){A=parseInt(c[4]);if(60<=A)return null;\np.assign(\"second\",A)}A=parseInt(c[2]);let y=0,x=-1;null!=c[3]?y=parseInt(c[3]):100<A&&(y=A%100,A=Math.floor(A/100));if(60<=y||24<A)return null;12<=A&&(x=w.Meridiem.PM);if(null!=c[6]){if(12<A)return null;c=c[6][0].toLowerCase();\"a\"==c&&(x=w.Meridiem.AM,12==A&&(A=0,p.isCertain(\"day\")||p.imply(\"day\",p.get(\"day\")+1)));\"p\"==c&&(x=w.Meridiem.PM,12!=A&&(A+=12));u.start.isCertain(\"meridiem\")||(x==w.Meridiem.AM?(u.start.imply(\"meridiem\",w.Meridiem.AM),12==u.start.get(\"hour\")&&u.start.assign(\"hour\",0)):(u.start.imply(\"meridiem\",\nw.Meridiem.PM),12!=u.start.get(\"hour\")&&u.start.assign(\"hour\",u.start.get(\"hour\")+12)))}p.assign(\"hour\",A);p.assign(\"minute\",y);0<=x?p.assign(\"meridiem\",x):u.start.isCertain(\"meridiem\")&&12<u.start.get(\"hour\")?u.start.get(\"hour\")-12>A?p.imply(\"meridiem\",w.Meridiem.AM):12>=A&&(p.assign(\"hour\",A+12),p.assign(\"meridiem\",w.Meridiem.PM)):12<A?p.imply(\"meridiem\",w.Meridiem.PM):12>=A&&p.imply(\"meridiem\",w.Meridiem.AM);p.date().getTime()<u.start.date().getTime()&&p.imply(\"day\",p.get(\"day\")+1);return p}checkAndReturnWithoutFollowingPattern(p){if(p.text.match(/^\\d$/))return null;\nvar c=p.text.match(/[^\\d:.](\\d[\\d.]+)$/);return c&&(c=c[1],this.strictMode||c.includes(\".\")&&!c.match(/\\d(\\.\\d{2})+$/)||24<parseInt(c))?null:p}getPrimaryTimePatternThroughCache(){const p=this.primaryPrefix(),c=this.primarySuffix();if(this.cachedPrimaryPrefix===p&&this.cachedPrimarySuffix===c)return this.cachedPrimaryTimePattern;this.cachedPrimaryTimePattern=new RegExp(\"(^|\\\\s|T)\"+`${p}`+\"(\\\\d{1,4})(?:(?:\\\\.|\\\\:|\\\\：)(\\\\d{1,2})(?:(?:\\\\:|\\\\：)(\\\\d{2})(?:\\\\.(\\\\d{1,6}))?)?)?(?:\\\\s*(a\\\\.m\\\\.|p\\\\.m\\\\.|am?|pm?))?\"+\n`${c}`,\"i\");this.cachedPrimaryPrefix=p;this.cachedPrimarySuffix=c;return this.cachedPrimaryTimePattern}getFollowingTimePatternThroughCache(){const p=this.followingPhase(),c=this.followingSuffix();if(this.cachedFollowingPhase===p&&this.cachedFollowingSuffix===c)return this.cachedFollowingTimePatten;this.cachedFollowingTimePatten=new RegExp(`^(${p})`+\"(\\\\d{1,4})(?:(?:\\\\.|\\\\:|\\\\：)(\\\\d{1,2})(?:(?:\\\\.|\\\\:|\\\\：)(\\\\d{1,2})(?:\\\\.(\\\\d{1,6}))?)?)?(?:\\\\s*(a\\\\.m\\\\.|p\\\\.m\\\\.|am?|pm?))?\"+`${c}`,\"i\");this.cachedFollowingPhase=\np;this.cachedFollowingSuffix=c;return this.cachedFollowingTimePatten}}P.AbstractTimeExpressionParser=B}","~:source","shadow$provide[36] = function(global,require,module,exports) {\n\"use strict\";\nvar __importDefault = (this && this.__importDefault) || function (mod) {\n    return (mod && mod.__esModule) ? mod : { \"default\": mod };\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nexports.AbstractTimeExpressionParser = void 0;\nconst index_1 = require(\"../../index\");\nconst dayjs_1 = __importDefault(require(\"dayjs\"));\nfunction primaryTimePattern(primaryPrefix, primarySuffix) {\n    return new RegExp(\"(^|\\\\s|T)\" +\n        `${primaryPrefix}` +\n        \"(\\\\d{1,4})\" +\n        \"(?:\" +\n        \"(?:\\\\.|\\\\:|\\\\：)\" +\n        \"(\\\\d{1,2})\" +\n        \"(?:\" +\n        \"(?:\\\\:|\\\\：)\" +\n        \"(\\\\d{2})\" +\n        \"(?:\\\\.(\\\\d{1,6}))?\" +\n        \")?\" +\n        \")?\" +\n        \"(?:\\\\s*(a\\\\.m\\\\.|p\\\\.m\\\\.|am?|pm?))?\" +\n        `${primarySuffix}`, \"i\");\n}\nfunction followingTimePatten(followingPhase, followingSuffix) {\n    return new RegExp(`^(${followingPhase})` +\n        \"(\\\\d{1,4})\" +\n        \"(?:\" +\n        \"(?:\\\\.|\\\\:|\\\\：)\" +\n        \"(\\\\d{1,2})\" +\n        \"(?:\" +\n        \"(?:\\\\.|\\\\:|\\\\：)\" +\n        \"(\\\\d{1,2})(?:\\\\.(\\\\d{1,6}))?\" +\n        \")?\" +\n        \")?\" +\n        \"(?:\\\\s*(a\\\\.m\\\\.|p\\\\.m\\\\.|am?|pm?))?\" +\n        `${followingSuffix}`, \"i\");\n}\nconst HOUR_GROUP = 2;\nconst MINUTE_GROUP = 3;\nconst SECOND_GROUP = 4;\nconst MILLI_SECOND_GROUP = 5;\nconst AM_PM_HOUR_GROUP = 6;\nclass AbstractTimeExpressionParser {\n    constructor(strictMode = false) {\n        this.cachedPrimaryPrefix = null;\n        this.cachedPrimarySuffix = null;\n        this.cachedPrimaryTimePattern = null;\n        this.cachedFollowingPhase = null;\n        this.cachedFollowingSuffix = null;\n        this.cachedFollowingTimePatten = null;\n        this.strictMode = strictMode;\n    }\n    primarySuffix() {\n        return \"(?=\\\\W|$)\";\n    }\n    followingSuffix() {\n        return \"(?=\\\\W|$)\";\n    }\n    pattern(context) {\n        return this.getPrimaryTimePatternThroughCache();\n    }\n    extract(context, match) {\n        const refDate = dayjs_1.default(context.refDate);\n        const result = context.createParsingResult(match.index + match[1].length, match[0].substring(match[1].length));\n        result.start.imply(\"day\", refDate.date());\n        result.start.imply(\"month\", refDate.month() + 1);\n        result.start.imply(\"year\", refDate.year());\n        result.start = this.extractPrimaryTimeComponents(context, match);\n        if (!result.start) {\n            match.index += match[0].length;\n            return null;\n        }\n        const remainingText = context.text.substring(match.index + match[0].length);\n        const followingPattern = this.getFollowingTimePatternThroughCache();\n        match = followingPattern.exec(remainingText);\n        if (!match ||\n            match[0].match(/^\\s*([+-])\\s*\\d{3,4}$/)) {\n            return this.checkAndReturnWithoutFollowingPattern(result);\n        }\n        result.end = this.extractFollowingTimeComponents(context, match, result);\n        if (result.end) {\n            if (result.end) {\n                result.text += match[0];\n            }\n        }\n        return result;\n    }\n    extractPrimaryTimeComponents(context, match, strict = false) {\n        const components = context.createParsingComponents();\n        let hour = 0;\n        let minute = 0;\n        let meridiem = null;\n        hour = parseInt(match[HOUR_GROUP]);\n        if (match[MINUTE_GROUP] != null) {\n            if (match[MINUTE_GROUP].length == 1 && !match[AM_PM_HOUR_GROUP]) {\n                return null;\n            }\n            minute = parseInt(match[MINUTE_GROUP]);\n        }\n        else if (hour > 100) {\n            if (this.strictMode) {\n                return null;\n            }\n            minute = hour % 100;\n            hour = Math.floor(hour / 100);\n        }\n        if (minute >= 60 || hour > 24) {\n            return null;\n        }\n        if (hour > 12) {\n            meridiem = index_1.Meridiem.PM;\n        }\n        if (match[AM_PM_HOUR_GROUP] != null) {\n            if (hour > 12)\n                return null;\n            const ampm = match[AM_PM_HOUR_GROUP][0].toLowerCase();\n            if (ampm == \"a\") {\n                meridiem = index_1.Meridiem.AM;\n                if (hour == 12) {\n                    hour = 0;\n                }\n            }\n            if (ampm == \"p\") {\n                meridiem = index_1.Meridiem.PM;\n                if (hour != 12) {\n                    hour += 12;\n                }\n            }\n        }\n        components.assign(\"hour\", hour);\n        components.assign(\"minute\", minute);\n        if (meridiem !== null) {\n            components.assign(\"meridiem\", meridiem);\n        }\n        else {\n            if (hour < 12) {\n                components.imply(\"meridiem\", index_1.Meridiem.AM);\n            }\n            else {\n                components.imply(\"meridiem\", index_1.Meridiem.PM);\n            }\n        }\n        if (match[MILLI_SECOND_GROUP] != null) {\n            const millisecond = parseInt(match[MILLI_SECOND_GROUP].substring(0, 3));\n            if (millisecond >= 1000)\n                return null;\n            components.assign(\"millisecond\", millisecond);\n        }\n        if (match[SECOND_GROUP] != null) {\n            const second = parseInt(match[SECOND_GROUP]);\n            if (second >= 60)\n                return null;\n            components.assign(\"second\", second);\n        }\n        return components;\n    }\n    extractFollowingTimeComponents(context, match, result) {\n        const components = context.createParsingComponents();\n        if (match[MILLI_SECOND_GROUP] != null) {\n            const millisecond = parseInt(match[MILLI_SECOND_GROUP].substring(0, 3));\n            if (millisecond >= 1000)\n                return null;\n            components.assign(\"millisecond\", millisecond);\n        }\n        if (match[SECOND_GROUP] != null) {\n            const second = parseInt(match[SECOND_GROUP]);\n            if (second >= 60)\n                return null;\n            components.assign(\"second\", second);\n        }\n        let hour = parseInt(match[HOUR_GROUP]);\n        let minute = 0;\n        let meridiem = -1;\n        if (match[MINUTE_GROUP] != null) {\n            minute = parseInt(match[MINUTE_GROUP]);\n        }\n        else if (hour > 100) {\n            minute = hour % 100;\n            hour = Math.floor(hour / 100);\n        }\n        if (minute >= 60 || hour > 24) {\n            return null;\n        }\n        if (hour >= 12) {\n            meridiem = index_1.Meridiem.PM;\n        }\n        if (match[AM_PM_HOUR_GROUP] != null) {\n            if (hour > 12) {\n                return null;\n            }\n            const ampm = match[AM_PM_HOUR_GROUP][0].toLowerCase();\n            if (ampm == \"a\") {\n                meridiem = index_1.Meridiem.AM;\n                if (hour == 12) {\n                    hour = 0;\n                    if (!components.isCertain(\"day\")) {\n                        components.imply(\"day\", components.get(\"day\") + 1);\n                    }\n                }\n            }\n            if (ampm == \"p\") {\n                meridiem = index_1.Meridiem.PM;\n                if (hour != 12)\n                    hour += 12;\n            }\n            if (!result.start.isCertain(\"meridiem\")) {\n                if (meridiem == index_1.Meridiem.AM) {\n                    result.start.imply(\"meridiem\", index_1.Meridiem.AM);\n                    if (result.start.get(\"hour\") == 12) {\n                        result.start.assign(\"hour\", 0);\n                    }\n                }\n                else {\n                    result.start.imply(\"meridiem\", index_1.Meridiem.PM);\n                    if (result.start.get(\"hour\") != 12) {\n                        result.start.assign(\"hour\", result.start.get(\"hour\") + 12);\n                    }\n                }\n            }\n        }\n        components.assign(\"hour\", hour);\n        components.assign(\"minute\", minute);\n        if (meridiem >= 0) {\n            components.assign(\"meridiem\", meridiem);\n        }\n        else {\n            const startAtPM = result.start.isCertain(\"meridiem\") && result.start.get(\"hour\") > 12;\n            if (startAtPM) {\n                if (result.start.get(\"hour\") - 12 > hour) {\n                    components.imply(\"meridiem\", index_1.Meridiem.AM);\n                }\n                else if (hour <= 12) {\n                    components.assign(\"hour\", hour + 12);\n                    components.assign(\"meridiem\", index_1.Meridiem.PM);\n                }\n            }\n            else if (hour > 12) {\n                components.imply(\"meridiem\", index_1.Meridiem.PM);\n            }\n            else if (hour <= 12) {\n                components.imply(\"meridiem\", index_1.Meridiem.AM);\n            }\n        }\n        if (components.date().getTime() < result.start.date().getTime()) {\n            components.imply(\"day\", components.get(\"day\") + 1);\n        }\n        return components;\n    }\n    checkAndReturnWithoutFollowingPattern(result) {\n        if (result.text.match(/^\\d$/)) {\n            return null;\n        }\n        const endingWithNumbers = result.text.match(/[^\\d:.](\\d[\\d.]+)$/);\n        if (endingWithNumbers) {\n            const endingNumbers = endingWithNumbers[1];\n            if (this.strictMode) {\n                return null;\n            }\n            if (endingNumbers.includes(\".\") && !endingNumbers.match(/\\d(\\.\\d{2})+$/)) {\n                return null;\n            }\n            const endingNumberVal = parseInt(endingNumbers);\n            if (endingNumberVal > 24) {\n                return null;\n            }\n        }\n        return result;\n    }\n    getPrimaryTimePatternThroughCache() {\n        const primaryPrefix = this.primaryPrefix();\n        const primarySuffix = this.primarySuffix();\n        if (this.cachedPrimaryPrefix === primaryPrefix && this.cachedPrimarySuffix === primarySuffix) {\n            return this.cachedPrimaryTimePattern;\n        }\n        this.cachedPrimaryTimePattern = primaryTimePattern(primaryPrefix, primarySuffix);\n        this.cachedPrimaryPrefix = primaryPrefix;\n        this.cachedPrimarySuffix = primarySuffix;\n        return this.cachedPrimaryTimePattern;\n    }\n    getFollowingTimePatternThroughCache() {\n        const followingPhase = this.followingPhase();\n        const followingSuffix = this.followingSuffix();\n        if (this.cachedFollowingPhase === followingPhase && this.cachedFollowingSuffix === followingSuffix) {\n            return this.cachedFollowingTimePatten;\n        }\n        this.cachedFollowingTimePatten = followingTimePatten(followingPhase, followingSuffix);\n        this.cachedFollowingPhase = followingPhase;\n        this.cachedFollowingSuffix = followingSuffix;\n        return this.cachedFollowingTimePatten;\n    }\n}\nexports.AbstractTimeExpressionParser = AbstractTimeExpressionParser;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$chrono_node$dist$index","~$shadow.js","~$module$node_modules$dayjs$dayjs_min"]],"~:properties",["^5",["cachedPrimaryTimePattern","cachedFollowingPhase","index","cachedFollowingTimePatten","strictMode","__esModule","value","start","text","cachedFollowingSuffix","cachedPrimaryPrefix","cachedPrimarySuffix","AbstractTimeExpressionParser","end"]],"~:compiled-at",1766065009504,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$chrono_node$dist$common$parsers$AbstractTimeExpressionParser.js\",\n\"lineCount\":9,\n\"mappings\":\"AAAAA,cAAA,CAAe,EAAf,CAAA,CAAqB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAEzDC,EAAAA,CAAmB,IAAnBA,EAA2B,IAAKA,CAAAA,eAAhCA,EAAoD,QAAS,CAACC,CAAD,CAAM,CACnE,MAAQA,EAAD,EAAQA,CAAIC,CAAAA,UAAZ,CAA0BD,CAA1B,CAAgC,CAAE,UAAWA,CAAb,CAD4B,CAGvEE,OAAOC,CAAAA,cAAP,CAAsBL,CAAtB,CAA+B,YAA/B,CAA6C,CAAEM,MAAO,CAAA,CAAT,CAA7C,CACAN,EAAQO,CAAAA,4BAAR,CAAuC,IAAK,EAC5C,OAAMC,EAAUV,CAAA,CAAQ,GAAR,CAAhB,CACMW,EAAUR,EAAA,CAAgBH,CAAA,CAAQ,EAAR,CAAhB,CAoChB,MAAMS,EAAN,CACIG,WAAW,CAACC,CAAA,CAAa,CAAA,CAAd,CAAqB,CAM5B,IAAKC,CAAAA,yBAAL,CADA,IAAKC,CAAAA,qBACL,CAFA,IAAKC,CAAAA,oBAEL,CAHA,IAAKC,CAAAA,wBAGL,CAJA,IAAKC,CAAAA,mBAIL,CALA,IAAKC,CAAAA,mBAKL,CAL2B,IAM3B,KAAKN,CAAAA,UAAL,CAAkBA,CAPU,CAShCO,aAAa,EAAG,CACZ,MAAO,cADK,CAGhBC,eAAe,EAAG,CACd,MAAO,cADO,CAGlBC,OAAO,CAACC,CAAD,CAAU,CACb,MAAO,KAAKC,CAAAA,iCAAL,EADM,CAGjBC,OAAO,CAACF,CAAD;AAAUG,CAAV,CAAiB,CACpB,MAAMC,EAAUhB,CAAQiB,CAAAA,OAAR,CAAgBL,CAAQI,CAAAA,OAAxB,CAAhB,CACME,EAASN,CAAQO,CAAAA,mBAAR,CAA4BJ,CAAMK,CAAAA,KAAlC,CAA0CL,CAAA,CAAM,CAAN,CAASM,CAAAA,MAAnD,CAA2DN,CAAA,CAAM,CAAN,CAASO,CAAAA,SAAT,CAAmBP,CAAA,CAAM,CAAN,CAASM,CAAAA,MAA5B,CAA3D,CACfH,EAAOK,CAAAA,KAAMC,CAAAA,KAAb,CAAmB,KAAnB,CAA0BR,CAAQS,CAAAA,IAAR,EAA1B,CACAP,EAAOK,CAAAA,KAAMC,CAAAA,KAAb,CAAmB,OAAnB,CAA4BR,CAAQU,CAAAA,KAAR,EAA5B,CAA8C,CAA9C,CACAR,EAAOK,CAAAA,KAAMC,CAAAA,KAAb,CAAmB,MAAnB,CAA2BR,CAAQW,CAAAA,IAAR,EAA3B,CACAT,EAAOK,CAAAA,KAAP,CAAe,IAAKK,CAAAA,4BAAL,CAAkChB,CAAlC,CAA2CG,CAA3C,CACf,IAAI,CAACG,CAAOK,CAAAA,KAAZ,CAEI,MADAR,EAAMK,CAAAA,KACC,EADQL,CAAA,CAAM,CAAN,CAASM,CAAAA,MACjB,CAAA,IAELQ,EAAAA,CAAgBjB,CAAQkB,CAAAA,IAAKR,CAAAA,SAAb,CAAuBP,CAAMK,CAAAA,KAA7B,CAAqCL,CAAA,CAAM,CAAN,CAASM,CAAAA,MAA9C,CAEtBN,EAAA,CADyB,IAAKgB,CAAAA,mCAALC,EACAC,CAAAA,IAAjB,CAAsBJ,CAAtB,CACR,IAAI,CAACd,CAAL,EACIA,CAAA,CAAM,CAAN,CAASA,CAAAA,KAAT,CAAe,uBAAf,CADJ,CAEI,MAAO,KAAKmB,CAAAA,qCAAL,CAA2ChB,CAA3C,CAEXA,EAAOiB,CAAAA,GAAP,CAAa,IAAKC,CAAAA,8BAAL,CAAoCxB,CAApC;AAA6CG,CAA7C,CAAoDG,CAApD,CACTA,EAAOiB,CAAAA,GAAX,EACQjB,CAAOiB,CAAAA,GADf,GAEQjB,CAAOY,CAAAA,IAFf,EAEuBf,CAAA,CAAM,CAAN,CAFvB,CAKA,OAAOG,EAxBa,CA0BxBU,4BAA4B,CAAChB,CAAD,CAAUG,CAAV,CAAiBsB,CAAjB,CAAiC,CACnDC,CAAAA,CAAa1B,CAAQ2B,CAAAA,uBAAR,EAEnB,KAAIC,EAAS,CAAb,CACIC,EAAW,IACfC,EAAA,CAAOC,QAAA,CAAS5B,CAAA,CAvDL6B,CAuDK,CAAT,CACP,IAA2B,IAA3B,EAAI7B,CAAA,CAvDS8B,CAuDT,CAAJ,CAAiC,CAC7B,GAAkC,CAAlC,EAAI9B,CAAA,CAxDK8B,CAwDL,CAAoBxB,CAAAA,MAAxB,EAAuC,CAACN,CAAA,CArD3B+B,CAqD2B,CAAxC,CACI,MAAO,KAEXN,EAAA,CAASG,QAAA,CAAS5B,CAAA,CA3DT8B,CA2DS,CAAT,CAJoB,CAAjC,IAMK,IAAW,GAAX,CAAIH,CAAJ,CAAgB,CACjB,GAAI,IAAKxC,CAAAA,UAAT,CACI,MAAO,KAEXsC,EAAA,CAASE,CAAT,CAAgB,GAChBA,EAAA,CAAOK,IAAKC,CAAAA,KAAL,CAAWN,CAAX,CAAkB,GAAlB,CALU,CAOrB,GAAc,EAAd,EAAIF,CAAJ,EAA2B,EAA3B,CAAoBE,CAApB,CACI,MAAO,KAEA,GAAX,CAAIA,CAAJ,GACID,CADJ,CACe1C,CAAQkD,CAAAA,QAASC,CAAAA,EADhC,CAGA,IAA+B,IAA/B,EAAInC,CAAA,CAvEa+B,CAuEb,CAAJ,CAAqC,CACjC,GAAW,EAAX,CAAIJ,CAAJ,CACI,MAAO,KACX,OAAMS,EAAOpC,CAAA,CA1EA+B,CA0EA,CAAA,CAAwB,CAAxB,CAA2BM,CAAAA,WAA3B,EACD,IAAZ,EAAID,CAAJ,GACIV,CACA,CADW1C,CAAQkD,CAAAA,QAASI,CAAAA,EAC5B,CAAY,EAAZ,EAAIX,CAAJ,GACIA,CADJ,CACW,CADX,CAFJ,CAMY,IAAZ,EAAIS,CAAJ,GACIV,CACA,CADW1C,CAAQkD,CAAAA,QAASC,CAAAA,EAC5B,CAAY,EAAZ,EAAIR,CAAJ,GACIA,CADJ,EACY,EADZ,CAFJ,CAViC,CAiBrCJ,CAAWgB,CAAAA,MAAX,CAAkB,MAAlB,CAA0BZ,CAA1B,CACAJ,EAAWgB,CAAAA,MAAX,CAAkB,QAAlB;AAA4Bd,CAA5B,CACiB,KAAjB,GAAIC,CAAJ,CACIH,CAAWgB,CAAAA,MAAX,CAAkB,UAAlB,CAA8Bb,CAA9B,CADJ,CAIe,EAAX,CAAIC,CAAJ,CACIJ,CAAWd,CAAAA,KAAX,CAAiB,UAAjB,CAA6BzB,CAAQkD,CAAAA,QAASI,CAAAA,EAA9C,CADJ,CAIIf,CAAWd,CAAAA,KAAX,CAAiB,UAAjB,CAA6BzB,CAAQkD,CAAAA,QAASC,CAAAA,EAA9C,CAGR,IAAiC,IAAjC,EAAInC,CAAA,CAtGewC,CAsGf,CAAJ,CAAuC,CAC7BC,CAAAA,CAAcb,QAAA,CAAS5B,CAAA,CAvGdwC,CAuGc,CAA0BjC,CAAAA,SAA1B,CAAoC,CAApC,CAAuC,CAAvC,CAAT,CACpB,IAAmB,GAAnB,EAAIkC,CAAJ,CACI,MAAO,KACXlB,EAAWgB,CAAAA,MAAX,CAAkB,aAAlB,CAAiCE,CAAjC,CAJmC,CAMvC,GAA2B,IAA3B,EAAIzC,CAAA,CA7GS0C,CA6GT,CAAJ,CAAiC,CACvBC,CAAAA,CAASf,QAAA,CAAS5B,CAAA,CA9Gf0C,CA8Ge,CAAT,CACf,IAAc,EAAd,EAAIC,CAAJ,CACI,MAAO,KACXpB,EAAWgB,CAAAA,MAAX,CAAkB,QAAlB,CAA4BI,CAA5B,CAJ6B,CAMjC,MAAOpB,EAnEkD,CAqE7DF,8BAA8B,CAACxB,CAAD,CAAUG,CAAV,CAAiBG,CAAjB,CAAyB,CAC7CoB,CAAAA,CAAa1B,CAAQ2B,CAAAA,uBAAR,EACnB,IAAiC,IAAjC,EAAIxB,CAAA,CAtHewC,CAsHf,CAAJ,CAAuC,CACnC,IAAMC,EAAcb,QAAA,CAAS5B,CAAA,CAvHdwC,CAuHc,CAA0BjC,CAAAA,SAA1B,CAAoC,CAApC,CAAuC,CAAvC,CAAT,CACpB,IAAmB,GAAnB,EAAIkC,CAAJ,CACI,MAAO,KACXlB,EAAWgB,CAAAA,MAAX,CAAkB,aAAlB,CAAiCE,CAAjC,CAJmC,CAMvC,GAA2B,IAA3B,EAAIzC,CAAA,CA7HS0C,CA6HT,CAAJ,CAAiC,CACvBC,CAAAA,CAASf,QAAA,CAAS5B,CAAA,CA9Hf0C,CA8He,CAAT,CACf,IAAc,EAAd,EAAIC,CAAJ,CACI,MAAO,KACXpB;CAAWgB,CAAAA,MAAX,CAAkB,QAAlB,CAA4BI,CAA5B,CAJ6B,CAM7BhB,CAAAA,CAAOC,QAAA,CAAS5B,CAAA,CArIT6B,CAqIS,CAAT,CACX,KAAIJ,EAAS,CAAb,CACIC,EAAW,CAAC,CACW,KAA3B,EAAI1B,CAAA,CAvIS8B,CAuIT,CAAJ,CACIL,CADJ,CACaG,QAAA,CAAS5B,CAAA,CAxIT8B,CAwIS,CAAT,CADb,CAGgB,GAHhB,CAGSH,CAHT,GAIIF,CACA,CADSE,CACT,CADgB,GAChB,CAAAA,CAAA,CAAOK,IAAKC,CAAAA,KAAL,CAAWN,CAAX,CAAkB,GAAlB,CALX,CAOA,IAAc,EAAd,EAAIF,CAAJ,EAA2B,EAA3B,CAAoBE,CAApB,CACI,MAAO,KAEC,GAAZ,EAAIA,CAAJ,GACID,CADJ,CACe1C,CAAQkD,CAAAA,QAASC,CAAAA,EADhC,CAGA,IAA+B,IAA/B,EAAInC,CAAA,CAjJa+B,CAiJb,CAAJ,CAAqC,CACjC,GAAW,EAAX,CAAIJ,CAAJ,CACI,MAAO,KAELS,EAAAA,CAAOpC,CAAA,CArJA+B,CAqJA,CAAA,CAAwB,CAAxB,CAA2BM,CAAAA,WAA3B,EACD,IAAZ,EAAID,CAAJ,GACIV,CACA,CADW1C,CAAQkD,CAAAA,QAASI,CAAAA,EAC5B,CAAY,EAAZ,EAAIX,CAAJ,GACIA,CACA,CADO,CACP,CAAKJ,CAAWqB,CAAAA,SAAX,CAAqB,KAArB,CAAL,EACIrB,CAAWd,CAAAA,KAAX,CAAiB,KAAjB,CAAwBc,CAAWsB,CAAAA,GAAX,CAAe,KAAf,CAAxB,CAAgD,CAAhD,CAHR,CAFJ,CASY,IAAZ,EAAIT,CAAJ,GACIV,CACA,CADW1C,CAAQkD,CAAAA,QAASC,CAAAA,EAC5B,CAAY,EAAZ,EAAIR,CAAJ,GACIA,CADJ,EACY,EADZ,CAFJ,CAKKxB,EAAOK,CAAAA,KAAMoC,CAAAA,SAAb,CAAuB,UAAvB,CAAL,GACQlB,CAAJ,EAAgB1C,CAAQkD,CAAAA,QAASI,CAAAA,EAAjC,EACInC,CAAOK,CAAAA,KAAMC,CAAAA,KAAb,CAAmB,UAAnB,CAA+BzB,CAAQkD,CAAAA,QAASI,CAAAA,EAAhD,CACA,CAAgC,EAAhC,EAAInC,CAAOK,CAAAA,KAAMqC,CAAAA,GAAb,CAAiB,MAAjB,CAAJ,EACI1C,CAAOK,CAAAA,KAAM+B,CAAAA,MAAb,CAAoB,MAApB,CAA4B,CAA5B,CAHR,GAOIpC,CAAOK,CAAAA,KAAMC,CAAAA,KAAb,CAAmB,UAAnB;AAA+BzB,CAAQkD,CAAAA,QAASC,CAAAA,EAAhD,CACA,CAAgC,EAAhC,EAAIhC,CAAOK,CAAAA,KAAMqC,CAAAA,GAAb,CAAiB,MAAjB,CAAJ,EACI1C,CAAOK,CAAAA,KAAM+B,CAAAA,MAAb,CAAoB,MAApB,CAA4BpC,CAAOK,CAAAA,KAAMqC,CAAAA,GAAb,CAAiB,MAAjB,CAA5B,CAAuD,EAAvD,CATR,CADJ,CAnBiC,CAkCrCtB,CAAWgB,CAAAA,MAAX,CAAkB,MAAlB,CAA0BZ,CAA1B,CACAJ,EAAWgB,CAAAA,MAAX,CAAkB,QAAlB,CAA4Bd,CAA5B,CACgB,EAAhB,EAAIC,CAAJ,CACIH,CAAWgB,CAAAA,MAAX,CAAkB,UAAlB,CAA8Bb,CAA9B,CADJ,CAIsBvB,CAAOK,CAAAA,KAAMoC,CAAAA,SAAb,CAAuB,UAAvB,CAClB,EADmF,EACnF,CADwDzC,CAAOK,CAAAA,KAAMqC,CAAAA,GAAb,CAAiB,MAAjB,CACxD,CACQ1C,CAAOK,CAAAA,KAAMqC,CAAAA,GAAb,CAAiB,MAAjB,CAAJ,CAA+B,EAA/B,CAAoClB,CAApC,CACIJ,CAAWd,CAAAA,KAAX,CAAiB,UAAjB,CAA6BzB,CAAQkD,CAAAA,QAASI,CAAAA,EAA9C,CADJ,CAGiB,EAHjB,EAGSX,CAHT,GAIIJ,CAAWgB,CAAAA,MAAX,CAAkB,MAAlB,CAA0BZ,CAA1B,CAAiC,EAAjC,CACA,CAAAJ,CAAWgB,CAAAA,MAAX,CAAkB,UAAlB,CAA8BvD,CAAQkD,CAAAA,QAASC,CAAAA,EAA/C,CALJ,CADJ,CASgB,EAAX,CAAIR,CAAJ,CACDJ,CAAWd,CAAAA,KAAX,CAAiB,UAAjB,CAA6BzB,CAAQkD,CAAAA,QAASC,CAAAA,EAA9C,CADC,CAGY,EAHZ,EAGIR,CAHJ,EAIDJ,CAAWd,CAAAA,KAAX,CAAiB,UAAjB,CAA6BzB,CAAQkD,CAAAA,QAASI,CAAAA,EAA9C,CAGJf,EAAWb,CAAAA,IAAX,EAAkBoC,CAAAA,OAAlB,EAAJ,CAAkC3C,CAAOK,CAAAA,KAAME,CAAAA,IAAb,EAAoBoC,CAAAA,OAApB,EAAlC,EACIvB,CAAWd,CAAAA,KAAX,CAAiB,KAAjB,CAAwBc,CAAWsB,CAAAA,GAAX,CAAe,KAAf,CAAxB,CAAgD,CAAhD,CAEJ,OAAOtB,EA1F4C,CA4FvDJ,qCAAqC,CAAChB,CAAD,CAAS,CAC1C,GAAIA,CAAOY,CAAAA,IAAKf,CAAAA,KAAZ,CAAkB,MAAlB,CAAJ,CACI,MAAO,KAEX;IAAM+C,EAAoB5C,CAAOY,CAAAA,IAAKf,CAAAA,KAAZ,CAAkB,oBAAlB,CAC1B,OAAI+C,EAAJ,GACUC,CAQF,CARkBD,CAAA,CAAkB,CAAlB,CAQlB,CAPA,IAAK5D,CAAAA,UAOL,EAJA6D,CAAcC,CAAAA,QAAd,CAAuB,GAAvB,CAIA,EAJ+B,CAACD,CAAchD,CAAAA,KAAd,CAAoB,eAApB,CAIhC,EAAkB,EAAlB,CADoB4B,QAAAsB,CAASF,CAATE,CAR5B,EAUe,IAVf,CAaO/C,CAlBmC,CAoB9CL,iCAAiC,EAAG,CAChC,MAAMqD,EAAgB,IAAKA,CAAAA,aAAL,EAAtB,CACMzD,EAAgB,IAAKA,CAAAA,aAAL,EACtB,IAAI,IAAKD,CAAAA,mBAAT,GAAiC0D,CAAjC,EAAkD,IAAK3D,CAAAA,mBAAvD,GAA+EE,CAA/E,CACI,MAAO,KAAKH,CAAAA,wBAEhB,KAAKA,CAAAA,wBAAL,CA1QG,IAAI6D,MAAJ,CAAW,WAAX,CACF,GAyQkDD,CAzQlD,EADE,CAEH,wHAFG;AAaF,GA6PiEzD,CA7PjE,EAbE,CAaiB,GAbjB,CA2QH,KAAKD,CAAAA,mBAAL,CAA2B0D,CAC3B,KAAK3D,CAAAA,mBAAL,CAA2BE,CAC3B,OAAO,KAAKH,CAAAA,wBAToB,CAWpCyB,mCAAmC,EAAG,CAClC,MAAMqC,EAAiB,IAAKA,CAAAA,cAAL,EAAvB,CACM1D,EAAkB,IAAKA,CAAAA,eAAL,EACxB,IAAI,IAAKL,CAAAA,oBAAT,GAAkC+D,CAAlC,EAAoD,IAAKhE,CAAAA,qBAAzD,GAAmFM,CAAnF,CACI,MAAO,KAAKP,CAAAA,yBAEhB,KAAKA,CAAAA,yBAAL,CArQG,IAAIgE,MAAJ,CAAY,KAqQsCC,CArQtC,GAAZ,CACH,8HADG,CAWF,GA0PoE1D,CA1PpE,EAXE,CAWmB,GAXnB,CAsQH,KAAKL,CAAAA,oBAAL;AAA4B+D,CAC5B,KAAKhE,CAAAA,qBAAL,CAA6BM,CAC7B,OAAO,KAAKP,CAAAA,yBATsB,CA7O1C,CAyPAZ,CAAQO,CAAAA,4BAAR,CAAuCA,CArSsB;\",\n\"sources\":[\"node_modules/chrono-node/dist/common/parsers/AbstractTimeExpressionParser.js\"],\n\"sourcesContent\":[\"shadow$provide[36] = function(global,require,module,exports) {\\n\\\"use strict\\\";\\nvar __importDefault = (this && this.__importDefault) || function (mod) {\\n    return (mod && mod.__esModule) ? mod : { \\\"default\\\": mod };\\n};\\nObject.defineProperty(exports, \\\"__esModule\\\", { value: true });\\nexports.AbstractTimeExpressionParser = void 0;\\nconst index_1 = require(\\\"../../index\\\");\\nconst dayjs_1 = __importDefault(require(\\\"dayjs\\\"));\\nfunction primaryTimePattern(primaryPrefix, primarySuffix) {\\n    return new RegExp(\\\"(^|\\\\\\\\s|T)\\\" +\\n        `${primaryPrefix}` +\\n        \\\"(\\\\\\\\d{1,4})\\\" +\\n        \\\"(?:\\\" +\\n        \\\"(?:\\\\\\\\.|\\\\\\\\:|\\\\\\\\\\uff1a)\\\" +\\n        \\\"(\\\\\\\\d{1,2})\\\" +\\n        \\\"(?:\\\" +\\n        \\\"(?:\\\\\\\\:|\\\\\\\\\\uff1a)\\\" +\\n        \\\"(\\\\\\\\d{2})\\\" +\\n        \\\"(?:\\\\\\\\.(\\\\\\\\d{1,6}))?\\\" +\\n        \\\")?\\\" +\\n        \\\")?\\\" +\\n        \\\"(?:\\\\\\\\s*(a\\\\\\\\.m\\\\\\\\.|p\\\\\\\\.m\\\\\\\\.|am?|pm?))?\\\" +\\n        `${primarySuffix}`, \\\"i\\\");\\n}\\nfunction followingTimePatten(followingPhase, followingSuffix) {\\n    return new RegExp(`^(${followingPhase})` +\\n        \\\"(\\\\\\\\d{1,4})\\\" +\\n        \\\"(?:\\\" +\\n        \\\"(?:\\\\\\\\.|\\\\\\\\:|\\\\\\\\\\uff1a)\\\" +\\n        \\\"(\\\\\\\\d{1,2})\\\" +\\n        \\\"(?:\\\" +\\n        \\\"(?:\\\\\\\\.|\\\\\\\\:|\\\\\\\\\\uff1a)\\\" +\\n        \\\"(\\\\\\\\d{1,2})(?:\\\\\\\\.(\\\\\\\\d{1,6}))?\\\" +\\n        \\\")?\\\" +\\n        \\\")?\\\" +\\n        \\\"(?:\\\\\\\\s*(a\\\\\\\\.m\\\\\\\\.|p\\\\\\\\.m\\\\\\\\.|am?|pm?))?\\\" +\\n        `${followingSuffix}`, \\\"i\\\");\\n}\\nconst HOUR_GROUP = 2;\\nconst MINUTE_GROUP = 3;\\nconst SECOND_GROUP = 4;\\nconst MILLI_SECOND_GROUP = 5;\\nconst AM_PM_HOUR_GROUP = 6;\\nclass AbstractTimeExpressionParser {\\n    constructor(strictMode = false) {\\n        this.cachedPrimaryPrefix = null;\\n        this.cachedPrimarySuffix = null;\\n        this.cachedPrimaryTimePattern = null;\\n        this.cachedFollowingPhase = null;\\n        this.cachedFollowingSuffix = null;\\n        this.cachedFollowingTimePatten = null;\\n        this.strictMode = strictMode;\\n    }\\n    primarySuffix() {\\n        return \\\"(?=\\\\\\\\W|$)\\\";\\n    }\\n    followingSuffix() {\\n        return \\\"(?=\\\\\\\\W|$)\\\";\\n    }\\n    pattern(context) {\\n        return this.getPrimaryTimePatternThroughCache();\\n    }\\n    extract(context, match) {\\n        const refDate = dayjs_1.default(context.refDate);\\n        const result = context.createParsingResult(match.index + match[1].length, match[0].substring(match[1].length));\\n        result.start.imply(\\\"day\\\", refDate.date());\\n        result.start.imply(\\\"month\\\", refDate.month() + 1);\\n        result.start.imply(\\\"year\\\", refDate.year());\\n        result.start = this.extractPrimaryTimeComponents(context, match);\\n        if (!result.start) {\\n            match.index += match[0].length;\\n            return null;\\n        }\\n        const remainingText = context.text.substring(match.index + match[0].length);\\n        const followingPattern = this.getFollowingTimePatternThroughCache();\\n        match = followingPattern.exec(remainingText);\\n        if (!match ||\\n            match[0].match(/^\\\\s*([+-])\\\\s*\\\\d{3,4}$/)) {\\n            return this.checkAndReturnWithoutFollowingPattern(result);\\n        }\\n        result.end = this.extractFollowingTimeComponents(context, match, result);\\n        if (result.end) {\\n            if (result.end) {\\n                result.text += match[0];\\n            }\\n        }\\n        return result;\\n    }\\n    extractPrimaryTimeComponents(context, match, strict = false) {\\n        const components = context.createParsingComponents();\\n        let hour = 0;\\n        let minute = 0;\\n        let meridiem = null;\\n        hour = parseInt(match[HOUR_GROUP]);\\n        if (match[MINUTE_GROUP] != null) {\\n            if (match[MINUTE_GROUP].length == 1 && !match[AM_PM_HOUR_GROUP]) {\\n                return null;\\n            }\\n            minute = parseInt(match[MINUTE_GROUP]);\\n        }\\n        else if (hour > 100) {\\n            if (this.strictMode) {\\n                return null;\\n            }\\n            minute = hour % 100;\\n            hour = Math.floor(hour / 100);\\n        }\\n        if (minute >= 60 || hour > 24) {\\n            return null;\\n        }\\n        if (hour > 12) {\\n            meridiem = index_1.Meridiem.PM;\\n        }\\n        if (match[AM_PM_HOUR_GROUP] != null) {\\n            if (hour > 12)\\n                return null;\\n            const ampm = match[AM_PM_HOUR_GROUP][0].toLowerCase();\\n            if (ampm == \\\"a\\\") {\\n                meridiem = index_1.Meridiem.AM;\\n                if (hour == 12) {\\n                    hour = 0;\\n                }\\n            }\\n            if (ampm == \\\"p\\\") {\\n                meridiem = index_1.Meridiem.PM;\\n                if (hour != 12) {\\n                    hour += 12;\\n                }\\n            }\\n        }\\n        components.assign(\\\"hour\\\", hour);\\n        components.assign(\\\"minute\\\", minute);\\n        if (meridiem !== null) {\\n            components.assign(\\\"meridiem\\\", meridiem);\\n        }\\n        else {\\n            if (hour < 12) {\\n                components.imply(\\\"meridiem\\\", index_1.Meridiem.AM);\\n            }\\n            else {\\n                components.imply(\\\"meridiem\\\", index_1.Meridiem.PM);\\n            }\\n        }\\n        if (match[MILLI_SECOND_GROUP] != null) {\\n            const millisecond = parseInt(match[MILLI_SECOND_GROUP].substring(0, 3));\\n            if (millisecond >= 1000)\\n                return null;\\n            components.assign(\\\"millisecond\\\", millisecond);\\n        }\\n        if (match[SECOND_GROUP] != null) {\\n            const second = parseInt(match[SECOND_GROUP]);\\n            if (second >= 60)\\n                return null;\\n            components.assign(\\\"second\\\", second);\\n        }\\n        return components;\\n    }\\n    extractFollowingTimeComponents(context, match, result) {\\n        const components = context.createParsingComponents();\\n        if (match[MILLI_SECOND_GROUP] != null) {\\n            const millisecond = parseInt(match[MILLI_SECOND_GROUP].substring(0, 3));\\n            if (millisecond >= 1000)\\n                return null;\\n            components.assign(\\\"millisecond\\\", millisecond);\\n        }\\n        if (match[SECOND_GROUP] != null) {\\n            const second = parseInt(match[SECOND_GROUP]);\\n            if (second >= 60)\\n                return null;\\n            components.assign(\\\"second\\\", second);\\n        }\\n        let hour = parseInt(match[HOUR_GROUP]);\\n        let minute = 0;\\n        let meridiem = -1;\\n        if (match[MINUTE_GROUP] != null) {\\n            minute = parseInt(match[MINUTE_GROUP]);\\n        }\\n        else if (hour > 100) {\\n            minute = hour % 100;\\n            hour = Math.floor(hour / 100);\\n        }\\n        if (minute >= 60 || hour > 24) {\\n            return null;\\n        }\\n        if (hour >= 12) {\\n            meridiem = index_1.Meridiem.PM;\\n        }\\n        if (match[AM_PM_HOUR_GROUP] != null) {\\n            if (hour > 12) {\\n                return null;\\n            }\\n            const ampm = match[AM_PM_HOUR_GROUP][0].toLowerCase();\\n            if (ampm == \\\"a\\\") {\\n                meridiem = index_1.Meridiem.AM;\\n                if (hour == 12) {\\n                    hour = 0;\\n                    if (!components.isCertain(\\\"day\\\")) {\\n                        components.imply(\\\"day\\\", components.get(\\\"day\\\") + 1);\\n                    }\\n                }\\n            }\\n            if (ampm == \\\"p\\\") {\\n                meridiem = index_1.Meridiem.PM;\\n                if (hour != 12)\\n                    hour += 12;\\n            }\\n            if (!result.start.isCertain(\\\"meridiem\\\")) {\\n                if (meridiem == index_1.Meridiem.AM) {\\n                    result.start.imply(\\\"meridiem\\\", index_1.Meridiem.AM);\\n                    if (result.start.get(\\\"hour\\\") == 12) {\\n                        result.start.assign(\\\"hour\\\", 0);\\n                    }\\n                }\\n                else {\\n                    result.start.imply(\\\"meridiem\\\", index_1.Meridiem.PM);\\n                    if (result.start.get(\\\"hour\\\") != 12) {\\n                        result.start.assign(\\\"hour\\\", result.start.get(\\\"hour\\\") + 12);\\n                    }\\n                }\\n            }\\n        }\\n        components.assign(\\\"hour\\\", hour);\\n        components.assign(\\\"minute\\\", minute);\\n        if (meridiem >= 0) {\\n            components.assign(\\\"meridiem\\\", meridiem);\\n        }\\n        else {\\n            const startAtPM = result.start.isCertain(\\\"meridiem\\\") && result.start.get(\\\"hour\\\") > 12;\\n            if (startAtPM) {\\n                if (result.start.get(\\\"hour\\\") - 12 > hour) {\\n                    components.imply(\\\"meridiem\\\", index_1.Meridiem.AM);\\n                }\\n                else if (hour <= 12) {\\n                    components.assign(\\\"hour\\\", hour + 12);\\n                    components.assign(\\\"meridiem\\\", index_1.Meridiem.PM);\\n                }\\n            }\\n            else if (hour > 12) {\\n                components.imply(\\\"meridiem\\\", index_1.Meridiem.PM);\\n            }\\n            else if (hour <= 12) {\\n                components.imply(\\\"meridiem\\\", index_1.Meridiem.AM);\\n            }\\n        }\\n        if (components.date().getTime() < result.start.date().getTime()) {\\n            components.imply(\\\"day\\\", components.get(\\\"day\\\") + 1);\\n        }\\n        return components;\\n    }\\n    checkAndReturnWithoutFollowingPattern(result) {\\n        if (result.text.match(/^\\\\d$/)) {\\n            return null;\\n        }\\n        const endingWithNumbers = result.text.match(/[^\\\\d:.](\\\\d[\\\\d.]+)$/);\\n        if (endingWithNumbers) {\\n            const endingNumbers = endingWithNumbers[1];\\n            if (this.strictMode) {\\n                return null;\\n            }\\n            if (endingNumbers.includes(\\\".\\\") && !endingNumbers.match(/\\\\d(\\\\.\\\\d{2})+$/)) {\\n                return null;\\n            }\\n            const endingNumberVal = parseInt(endingNumbers);\\n            if (endingNumberVal > 24) {\\n                return null;\\n            }\\n        }\\n        return result;\\n    }\\n    getPrimaryTimePatternThroughCache() {\\n        const primaryPrefix = this.primaryPrefix();\\n        const primarySuffix = this.primarySuffix();\\n        if (this.cachedPrimaryPrefix === primaryPrefix && this.cachedPrimarySuffix === primarySuffix) {\\n            return this.cachedPrimaryTimePattern;\\n        }\\n        this.cachedPrimaryTimePattern = primaryTimePattern(primaryPrefix, primarySuffix);\\n        this.cachedPrimaryPrefix = primaryPrefix;\\n        this.cachedPrimarySuffix = primarySuffix;\\n        return this.cachedPrimaryTimePattern;\\n    }\\n    getFollowingTimePatternThroughCache() {\\n        const followingPhase = this.followingPhase();\\n        const followingSuffix = this.followingSuffix();\\n        if (this.cachedFollowingPhase === followingPhase && this.cachedFollowingSuffix === followingSuffix) {\\n            return this.cachedFollowingTimePatten;\\n        }\\n        this.cachedFollowingTimePatten = followingTimePatten(followingPhase, followingSuffix);\\n        this.cachedFollowingPhase = followingPhase;\\n        this.cachedFollowingSuffix = followingSuffix;\\n        return this.cachedFollowingTimePatten;\\n    }\\n}\\nexports.AbstractTimeExpressionParser = AbstractTimeExpressionParser;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"__importDefault\",\"mod\",\"__esModule\",\"Object\",\"defineProperty\",\"value\",\"AbstractTimeExpressionParser\",\"index_1\",\"dayjs_1\",\"constructor\",\"strictMode\",\"cachedFollowingTimePatten\",\"cachedFollowingSuffix\",\"cachedFollowingPhase\",\"cachedPrimaryTimePattern\",\"cachedPrimarySuffix\",\"cachedPrimaryPrefix\",\"primarySuffix\",\"followingSuffix\",\"pattern\",\"context\",\"getPrimaryTimePatternThroughCache\",\"extract\",\"match\",\"refDate\",\"default\",\"result\",\"createParsingResult\",\"index\",\"length\",\"substring\",\"start\",\"imply\",\"date\",\"month\",\"year\",\"extractPrimaryTimeComponents\",\"remainingText\",\"text\",\"getFollowingTimePatternThroughCache\",\"followingPattern\",\"exec\",\"checkAndReturnWithoutFollowingPattern\",\"end\",\"extractFollowingTimeComponents\",\"strict\",\"components\",\"createParsingComponents\",\"minute\",\"meridiem\",\"hour\",\"parseInt\",\"HOUR_GROUP\",\"MINUTE_GROUP\",\"AM_PM_HOUR_GROUP\",\"Math\",\"floor\",\"Meridiem\",\"PM\",\"ampm\",\"toLowerCase\",\"AM\",\"assign\",\"MILLI_SECOND_GROUP\",\"millisecond\",\"SECOND_GROUP\",\"second\",\"isCertain\",\"get\",\"getTime\",\"endingWithNumbers\",\"endingNumbers\",\"includes\",\"endingNumberVal\",\"primaryPrefix\",\"RegExp\",\"followingPhase\"]\n}\n"]