["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/capacitor-voice-recorder/dist/plugin.cjs.js"],"~:js","shadow$provide[480]=function(ra,X,Ra,P){ra=X(7);var w=X(479);X=ra.registerPlugin(\"VoiceRecorder\",{web:()=>Promise.resolve().then(function(){return A}).then(y=>new y.VoiceRecorderWeb)});const Z=()=>Error(\"RECORDING_HAS_NOT_STARTED\"),B=[\"audio/aac\",\"audio/webm;codecs\\x3dopus\",\"audio/mp4\",\"audio/webm\",\"audio/ogg;codecs\\x3dopus\"],p=()=>new Promise(()=>{});class c{constructor(){this.mediaRecorder=null;this.chunks=[];this.pendingResult=p()}static canDeviceVoiceRecord(){return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){var y;\nreturn null==(null===(y=null===navigator||void 0===navigator?void 0:navigator.mediaDevices)||void 0===y?void 0:y.getUserMedia)||null==c.getSupportedMimeType()?{value:!1}:{value:!0}})}startRecording(){const y=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(null!=y.mediaRecorder)throw Error(\"ALREADY_RECORDING\");if(!(yield c.canDeviceVoiceRecord()).value)throw Error(\"DEVICE_CANNOT_VOICE_RECORD\");if(!(yield c.hasAudioRecordingPermission().catch(()=>({value:!0}))).value)throw Error(\"MISSING_PERMISSION\");\nreturn navigator.mediaDevices.getUserMedia({audio:!0}).then(y.onSuccessfullyStartedRecording.bind(y)).catch(y.onFailedToStartRecording.bind(y))})}stopRecording(){const y=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(null==y.mediaRecorder)throw Z();try{return y.mediaRecorder.stop(),y.mediaRecorder.stream.getTracks().forEach(x=>x.stop()),y.pendingResult}catch(x){throw Error(\"FAILED_TO_FETCH_RECORDING\");}finally{y.prepareInstanceForNextOperation()}})}static hasAudioRecordingPermission(){return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){return navigator.permissions.query({name:\"microphone\"}).then(y=>\n({value:\"granted\"===y.state})).catch(()=>{throw Error(\"COULD_NOT_QUERY_PERMISSION_STATUS\");})})}static requestAudioRecordingPermission(){return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){return(yield c.hasAudioRecordingPermission().catch(()=>({value:!1}))).value?{value:!0}:navigator.mediaDevices.getUserMedia({audio:!0}).then(()=>({value:!0})).catch(()=>({value:!1}))})}pauseRecording(){if(null==this.mediaRecorder)throw Z();return\"recording\"===this.mediaRecorder.state?(this.mediaRecorder.pause(),\nPromise.resolve({value:!0})):Promise.resolve({value:!1})}resumeRecording(){if(null==this.mediaRecorder)throw Z();return\"paused\"===this.mediaRecorder.state?(this.mediaRecorder.resume(),Promise.resolve({value:!0})):Promise.resolve({value:!1})}getCurrentStatus(){return null==this.mediaRecorder?Promise.resolve({status:\"NONE\"}):\"recording\"===this.mediaRecorder.state?Promise.resolve({status:\"RECORDING\"}):\"paused\"===this.mediaRecorder.state?Promise.resolve({status:\"PAUSED\"}):Promise.resolve({status:\"NONE\"})}static getSupportedMimeType(){if(null==\n(null===MediaRecorder||void 0===MediaRecorder?void 0:MediaRecorder.isTypeSupported))return null;const y=B.find(x=>MediaRecorder.isTypeSupported(x));return null!==y&&void 0!==y?y:null}onSuccessfullyStartedRecording(y){this.pendingResult=new Promise((x,Q)=>{this.mediaRecorder=new MediaRecorder(y);this.mediaRecorder.onerror=()=>{this.prepareInstanceForNextOperation();Q(Error(\"FAILED_TO_RECORD\"))};this.mediaRecorder.onstop=()=>{const g=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const h=\nc.getSupportedMimeType();if(null==h)g.prepareInstanceForNextOperation(),Q(Error(\"FAILED_TO_FETCH_RECORDING\"));else{var b=new Blob(g.chunks,{type:h});if(0>=b.size)g.prepareInstanceForNextOperation(),Q(Error(\"EMPTY_RECORDING\"));else{var l=yield c.blobToBase64(b);b=yield w(b);g.prepareInstanceForNextOperation();x({value:{recordDataBase64:l,mimeType:h,msDuration:1E3*b}})}}})};this.mediaRecorder.ondataavailable=g=>this.chunks.push(g.data);this.mediaRecorder.start()});return{value:!0}}onFailedToStartRecording(){this.prepareInstanceForNextOperation();\nthrow Error(\"FAILED_TO_RECORD\");}static blobToBase64(y){return new Promise(x=>{const Q=new FileReader;Q.onloadend=()=>{const g=String(Q.result),h=g.split(\"base64,\");x((1<h.length?h[1]:g).trim())};Q.readAsDataURL(y)})}prepareInstanceForNextOperation(){if(null!=this.mediaRecorder&&\"recording\"===this.mediaRecorder.state)try{this.mediaRecorder.stop()}catch(y){}this.pendingResult=p();this.mediaRecorder=null;this.chunks=[]}}class u extends ra.WebPlugin{constructor(){super(...arguments);this.voiceRecorderInstance=\nnew c}canDeviceVoiceRecord(){return c.canDeviceVoiceRecord()}hasAudioRecordingPermission(){return c.hasAudioRecordingPermission()}requestAudioRecordingPermission(){return c.requestAudioRecordingPermission()}startRecording(){return this.voiceRecorderInstance.startRecording()}stopRecording(){return this.voiceRecorderInstance.stopRecording()}pauseRecording(){return this.voiceRecorderInstance.pauseRecording()}resumeRecording(){return this.voiceRecorderInstance.resumeRecording()}getCurrentStatus(){return this.voiceRecorderInstance.getCurrentStatus()}}\nvar A=Object.freeze({__proto__:null,VoiceRecorderWeb:u});P.VoiceRecorder=X}","~:source","shadow$provide[480] = function(global,require,module,exports) {\n'use strict';\n\nvar core = require('@capacitor/core');\nvar getBlobDuration = require('get-blob-duration');\n\nconst VoiceRecorder = core.registerPlugin('VoiceRecorder', {\n    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.VoiceRecorderWeb()),\n});\n\nconst successResponse = () => ({ value: true });\nconst failureResponse = () => ({ value: false });\nconst missingPermissionError = () => new Error('MISSING_PERMISSION');\nconst alreadyRecordingError = () => new Error('ALREADY_RECORDING');\nconst deviceCannotVoiceRecordError = () => new Error('DEVICE_CANNOT_VOICE_RECORD');\nconst failedToRecordError = () => new Error('FAILED_TO_RECORD');\nconst emptyRecordingError = () => new Error('EMPTY_RECORDING');\nconst recordingHasNotStartedError = () => new Error('RECORDING_HAS_NOT_STARTED');\nconst failedToFetchRecordingError = () => new Error('FAILED_TO_FETCH_RECORDING');\nconst couldNotQueryPermissionStatusError = () => new Error('COULD_NOT_QUERY_PERMISSION_STATUS');\n\n// these mime types will be checked one by one in order until one of them is found to be supported by the current browser\nconst possibleMimeTypes = ['audio/aac', 'audio/webm;codecs=opus', 'audio/mp4', 'audio/webm', 'audio/ogg;codecs=opus'];\nconst neverResolvingPromise = () => new Promise(() => undefined);\nclass VoiceRecorderImpl {\n    constructor() {\n        this.mediaRecorder = null;\n        this.chunks = [];\n        this.pendingResult = neverResolvingPromise();\n    }\n    static async canDeviceVoiceRecord() {\n        var _a;\n        if (((_a = navigator === null || navigator === void 0 ? void 0 : navigator.mediaDevices) === null || _a === void 0 ? void 0 : _a.getUserMedia) == null || VoiceRecorderImpl.getSupportedMimeType() == null) {\n            return failureResponse();\n        }\n        else {\n            return successResponse();\n        }\n    }\n    async startRecording() {\n        if (this.mediaRecorder != null) {\n            throw alreadyRecordingError();\n        }\n        const deviceCanRecord = await VoiceRecorderImpl.canDeviceVoiceRecord();\n        if (!deviceCanRecord.value) {\n            throw deviceCannotVoiceRecordError();\n        }\n        const havingPermission = await VoiceRecorderImpl.hasAudioRecordingPermission().catch(() => successResponse());\n        if (!havingPermission.value) {\n            throw missingPermissionError();\n        }\n        return navigator.mediaDevices.getUserMedia({ audio: true })\n            .then(this.onSuccessfullyStartedRecording.bind(this))\n            .catch(this.onFailedToStartRecording.bind(this));\n    }\n    async stopRecording() {\n        if (this.mediaRecorder == null) {\n            throw recordingHasNotStartedError();\n        }\n        try {\n            this.mediaRecorder.stop();\n            this.mediaRecorder.stream.getTracks().forEach(track => track.stop());\n            return this.pendingResult;\n        }\n        catch (ignore) {\n            throw failedToFetchRecordingError();\n        }\n        finally {\n            this.prepareInstanceForNextOperation();\n        }\n    }\n    static async hasAudioRecordingPermission() {\n        return navigator.permissions.query({ name: 'microphone' })\n            .then(result => ({ value: result.state === 'granted' }))\n            .catch(() => {\n            throw couldNotQueryPermissionStatusError();\n        });\n    }\n    static async requestAudioRecordingPermission() {\n        const havingPermission = await VoiceRecorderImpl.hasAudioRecordingPermission().catch(() => failureResponse());\n        if (havingPermission.value) {\n            return successResponse();\n        }\n        return navigator.mediaDevices.getUserMedia({ audio: true })\n            .then(() => successResponse())\n            .catch(() => failureResponse());\n    }\n    pauseRecording() {\n        if (this.mediaRecorder == null) {\n            throw recordingHasNotStartedError();\n        }\n        else if (this.mediaRecorder.state === 'recording') {\n            this.mediaRecorder.pause();\n            return Promise.resolve(successResponse());\n        }\n        else {\n            return Promise.resolve(failureResponse());\n        }\n    }\n    resumeRecording() {\n        if (this.mediaRecorder == null) {\n            throw recordingHasNotStartedError();\n        }\n        else if (this.mediaRecorder.state === 'paused') {\n            this.mediaRecorder.resume();\n            return Promise.resolve(successResponse());\n        }\n        else {\n            return Promise.resolve(failureResponse());\n        }\n    }\n    getCurrentStatus() {\n        if (this.mediaRecorder == null) {\n            return Promise.resolve({ status: 'NONE' });\n        }\n        else if (this.mediaRecorder.state === 'recording') {\n            return Promise.resolve({ status: 'RECORDING' });\n        }\n        else if (this.mediaRecorder.state === 'paused') {\n            return Promise.resolve({ status: 'PAUSED' });\n        }\n        else {\n            return Promise.resolve({ status: 'NONE' });\n        }\n    }\n    static getSupportedMimeType() {\n        if ((MediaRecorder === null || MediaRecorder === void 0 ? void 0 : MediaRecorder.isTypeSupported) == null)\n            return null;\n        const foundSupportedType = possibleMimeTypes.find(type => MediaRecorder.isTypeSupported(type));\n        return foundSupportedType !== null && foundSupportedType !== void 0 ? foundSupportedType : null;\n    }\n    onSuccessfullyStartedRecording(stream) {\n        this.pendingResult = new Promise((resolve, reject) => {\n            this.mediaRecorder = new MediaRecorder(stream);\n            this.mediaRecorder.onerror = () => {\n                this.prepareInstanceForNextOperation();\n                reject(failedToRecordError());\n            };\n            this.mediaRecorder.onstop = async () => {\n                const mimeType = VoiceRecorderImpl.getSupportedMimeType();\n                if (mimeType == null) {\n                    this.prepareInstanceForNextOperation();\n                    reject(failedToFetchRecordingError());\n                    return;\n                }\n                const blobVoiceRecording = new Blob(this.chunks, { 'type': mimeType });\n                if (blobVoiceRecording.size <= 0) {\n                    this.prepareInstanceForNextOperation();\n                    reject(emptyRecordingError());\n                    return;\n                }\n                const recordDataBase64 = await VoiceRecorderImpl.blobToBase64(blobVoiceRecording);\n                const recordingDuration = await getBlobDuration(blobVoiceRecording);\n                this.prepareInstanceForNextOperation();\n                resolve({ value: { recordDataBase64, mimeType, msDuration: recordingDuration * 1000 } });\n            };\n            this.mediaRecorder.ondataavailable = (event) => this.chunks.push(event.data);\n            this.mediaRecorder.start();\n        });\n        return successResponse();\n    }\n    onFailedToStartRecording() {\n        this.prepareInstanceForNextOperation();\n        throw failedToRecordError();\n    }\n    static blobToBase64(blob) {\n        return new Promise(resolve => {\n            const reader = new FileReader();\n            reader.onloadend = () => {\n                const recordingResult = String(reader.result);\n                const splitResult = recordingResult.split('base64,');\n                const toResolve = (splitResult.length > 1) ? splitResult[1] : recordingResult;\n                resolve(toResolve.trim());\n            };\n            reader.readAsDataURL(blob);\n        });\n    }\n    prepareInstanceForNextOperation() {\n        if (this.mediaRecorder != null && this.mediaRecorder.state === 'recording') {\n            try {\n                this.mediaRecorder.stop();\n            }\n            catch (ignore) {\n            }\n        }\n        this.pendingResult = neverResolvingPromise();\n        this.mediaRecorder = null;\n        this.chunks = [];\n    }\n}\n\nclass VoiceRecorderWeb extends core.WebPlugin {\n    constructor() {\n        super(...arguments);\n        this.voiceRecorderInstance = new VoiceRecorderImpl();\n    }\n    canDeviceVoiceRecord() {\n        return VoiceRecorderImpl.canDeviceVoiceRecord();\n    }\n    hasAudioRecordingPermission() {\n        return VoiceRecorderImpl.hasAudioRecordingPermission();\n    }\n    requestAudioRecordingPermission() {\n        return VoiceRecorderImpl.requestAudioRecordingPermission();\n    }\n    startRecording() {\n        return this.voiceRecorderInstance.startRecording();\n    }\n    stopRecording() {\n        return this.voiceRecorderInstance.stopRecording();\n    }\n    pauseRecording() {\n        return this.voiceRecorderInstance.pauseRecording();\n    }\n    resumeRecording() {\n        return this.voiceRecorderInstance.resumeRecording();\n    }\n    getCurrentStatus() {\n        return this.voiceRecorderInstance.getCurrentStatus();\n    }\n}\n\nvar web = /*#__PURE__*/Object.freeze({\n    __proto__: null,\n    VoiceRecorderWeb: VoiceRecorderWeb\n});\n\nexports.VoiceRecorder = VoiceRecorder;\n//# sourceMappingURL=plugin.cjs.js.map\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$get_blob_duration$dist$getBlobDuration","~$module$node_modules$$capacitor$core$dist$index_cjs"]],"~:properties",["^5",["chunks","onerror","web","recordDataBase64","pendingResult","VoiceRecorderWeb","onstop","name","value","VoiceRecorder","msDuration","status","ondataavailable","voiceRecorderInstance","audio","onloadend","__proto__","mimeType","mediaRecorder"]],"~:compiled-at",1766065009708,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$capacitor_voice_recorder$dist$plugin_cjs.js\",\n\"lineCount\":10,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAG1DC,EAAAA,CAAOH,CAAA,CAAQ,CAAR,CACX,KAAII,EAAkBJ,CAAA,CAAQ,GAAR,CAEhBK,EAAAA,CAAgBF,EAAKG,CAAAA,cAAL,CAAoB,eAApB,CAAqC,CACvDC,IAAK,EAAAA,EAAMC,OAAQC,CAAAA,OAAR,EAAkBC,CAAAA,IAAlB,CAAuB,QAAS,EAAG,CAAE,MAAOH,EAAT,CAAnC,CAAoDG,CAAAA,IAApD,CAAyDC,CAAA,EAAK,IAAIA,CAAEC,CAAAA,gBAApE,CAD4C,CAArC,CAWtB,OAAMC,EAA8B,EAAAA,EAAUC,KAAJ,CAAU,2BAAV,CAA1C,CAKMC,EAAoB,CAAC,WAAD,CAAc,2BAAd,CAAwC,WAAxC,CAAqD,YAArD,CAAmE,0BAAnE,CAL1B,CAMMC,EAAwB,EAAAA,EAAM,IAAIR,OAAJ,CAAY,EAAA,EAAMS,EAAlB,CACpC,MAAMC,EAAN,CACIC,WAAW,EAAG,CACV,IAAKC,CAAAA,aAAL,CAAqB,IACrB,KAAKC,CAAAA,MAAL,CAAc,EACd,KAAKC,CAAAA,aAAL,CAAqBN,CAAA,EAHX,CAKDO,2BAAoB,EAAG,CAAA,MAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAChC,IAAIC,CACJ;MAAkJ,KAAlJ,GAA6F,IAAxF,IAACA,CAAD,CAAoB,IAAd,GAAAC,SAAA,EAAoC,IAAK,EAAzC,GAAsBA,SAAtB,CAA6C,IAAK,EAAlD,CAAsDA,SAAUC,CAAAA,YAAtE,GAAuG,IAAK,EAA5G,GAAgGF,CAAhG,CAAgH,IAAK,EAArH,CAAyHA,CAAGG,CAAAA,YAAjI,GAAsM,IAAtM,EAA0JT,CAAkBU,CAAAA,oBAAlB,EAA1J,CArBuB,CAAEC,MAAO,CAAA,CAAT,CAqBvB,CAtBuB,CAAEA,MAAO,CAAA,CAAT,CAoBS,CAAA,CAAA,CAS9BC,cAAc,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACnB,GAA0B,IAA1B,EAAI,CAAKV,CAAAA,aAAT,CACI,KA5B4BN,MAAJ,CAAU,mBAAV,CA4BxB,CAGJ,GAAI,CAAiBe,CADGE,KAAMb,EAAkBK,CAAAA,oBAAlB,EACTM,EAAAA,KAArB,CACI,KA/BmCf,MAAJ,CAAU,4BAAV,CA+B/B,CAGJ,GAAI,CAAkBe,CADGG,KAAMd,EAAkBe,CAAAA,2BAAlB,EAAgDC,CAAAA,KAAhD,CAAsD,EAAA,EArC9D,EAAEL,MAAO,CAAA,CAAT,EAqCQ,CACTA,EAAAA,KAAtB,CACI,KArC6Bf,MAAJ,CAAU,oBAAV,CAqCzB;AAEJ,MAAOW,UAAUC,CAAAA,YAAaC,CAAAA,YAAvB,CAAoC,CAAEQ,MAAO,CAAA,CAAT,CAApC,CACFzB,CAAAA,IADE,CACG,CAAK0B,CAAAA,8BAA+BC,CAAAA,IAApC,CAAyC,CAAzC,CADH,CAEFH,CAAAA,KAFE,CAEI,CAAKI,CAAAA,wBAAyBD,CAAAA,IAA9B,CAAmC,CAAnC,CAFJ,CAZY,CAAA,CAAA,CAgBjBE,aAAa,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAClB,GAA0B,IAA1B,EAAI,CAAKnB,CAAAA,aAAT,CACI,KAAMP,EAAA,EAAN,CAEJ,GAAI,CAGA,MAFA,EAAKO,CAAAA,aAAcoB,CAAAA,IAAnB,EAEYlB,CADZ,CAAKF,CAAAA,aAAcqB,CAAAA,MAAOC,CAAAA,SAA1B,EAAsCC,CAAAA,OAAtC,CAA8CC,CAAA,EAASA,CAAMJ,CAAAA,IAAN,EAAvD,CACYlB,CAAL,CAAKA,CAAAA,aAHZ,CAKJ,MAAOuB,CAAP,CAAe,CACX,KA/CkC/B,MAAJ,CAAU,2BAAV,CA+C9B,CADW,CALf,OAQQ,CACJ,CAAKgC,CAAAA,+BAAL,EADI,CAZU,CAAA,CAAA,CAgBTb,kCAA2B,EAAG,CAAA,MAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACvC,MAAOR,UAAUsB,CAAAA,WAAYC,CAAAA,KAAtB,CAA4B,CAAEC,KAAM,YAAR,CAA5B,CACFvC,CAAAA,IADE,CACGwC,CAAA;AAAW,EAAErB,MAAwB,SAAxBA,GAAOqB,CAAOC,CAAAA,KAAhB,EADd,CAEFjB,CAAAA,KAFE,CAEI,EAAA,EAAM,CACb,KAxDyCpB,MAAJ,CAAU,mCAAV,CAwDrC,CADa,CAFV,CADgC,CAAA,CAAA,CAO9BsC,sCAA+B,EAAG,CAAA,MAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAE3C,MAAqBvB,CADIG,KAAMd,EAAkBe,CAAAA,2BAAlB,EAAgDC,CAAAA,KAAhD,CAAsD,EAAA,EApE9D,EAAEL,MAAO,CAAA,CAAT,EAoEQ,CACVA,EAAAA,KAArB,CAtEuB,CAAEA,MAAO,CAAA,CAAT,CAsEvB,CAGOJ,SAAUC,CAAAA,YAAaC,CAAAA,YAAvB,CAAoC,CAAEQ,MAAO,CAAA,CAAT,CAApC,CACFzB,CAAAA,IADE,CACG,EAAA,EA1Ea,EAAEmB,MAAO,CAAA,CAAT,EAyEhB,CAEFK,CAAAA,KAFE,CAEI,EAAA,EA1EY,EAAEL,MAAO,CAAA,CAAT,EAwEhB,CALoC,CAAA,CAAA,CAS/CwB,cAAc,EAAG,CACb,GAA0B,IAA1B,EAAI,IAAKjC,CAAAA,aAAT,CACI,KAAMP,EAAA,EAAN,CAEC,MAAiC,WAAjC,GAAI,IAAKO,CAAAA,aAAc+B,CAAAA,KAAvB,EACD,IAAK/B,CAAAA,aAAckC,CAAAA,KAAnB,EACO;AAAA9C,OAAQC,CAAAA,OAAR,CAnFY,CAAEoB,MAAO,CAAA,CAAT,CAmFZ,CAFN,EAKMrB,OAAQC,CAAAA,OAAR,CArFY,CAAEoB,MAAO,CAAA,CAAT,CAqFZ,CATE,CAYjB0B,eAAe,EAAG,CACd,GAA0B,IAA1B,EAAI,IAAKnC,CAAAA,aAAT,CACI,KAAMP,EAAA,EAAN,CAEC,MAAiC,QAAjC,GAAI,IAAKO,CAAAA,aAAc+B,CAAAA,KAAvB,EACD,IAAK/B,CAAAA,aAAcoC,CAAAA,MAAnB,EACO,CAAAhD,OAAQC,CAAAA,OAAR,CA/FY,CAAEoB,MAAO,CAAA,CAAT,CA+FZ,CAFN,EAKMrB,OAAQC,CAAAA,OAAR,CAjGY,CAAEoB,MAAO,CAAA,CAAT,CAiGZ,CATG,CAYlB4B,gBAAgB,EAAG,CACf,MAA0B,KAA1B,EAAI,IAAKrC,CAAAA,aAAT,CACWZ,OAAQC,CAAAA,OAAR,CAAgB,CAAEiD,OAAQ,MAAV,CAAhB,CADX,CAGsC,WAAjC,GAAI,IAAKtC,CAAAA,aAAc+B,CAAAA,KAAvB,CACM3C,OAAQC,CAAAA,OAAR,CAAgB,CAAEiD,OAAQ,WAAV,CAAhB,CADN,CAGiC,QAAjC,GAAI,IAAKtC,CAAAA,aAAc+B,CAAAA,KAAvB,CACM3C,OAAQC,CAAAA,OAAR,CAAgB,CAAEiD,OAAQ,QAAV,CAAhB,CADN,CAIMlD,OAAQC,CAAAA,OAAR,CAAgB,CAAEiD,OAAQ,MAAV,CAAhB,CAXI,CAcZ9B,2BAAoB,EAAG,CAC1B,GAAqG,IAArG;CAAuB,IAAlB,GAAA+B,aAAA,EAA4C,IAAK,EAAjD,GAA0BA,aAA1B,CAAqD,IAAK,EAA1D,CAA8DA,aAAcC,CAAAA,eAAjF,EACI,MAAO,KACX,OAAMC,EAAqB9C,CAAkB+C,CAAAA,IAAlB,CAAuBC,CAAA,EAAQJ,aAAcC,CAAAA,eAAd,CAA8BG,CAA9B,CAA/B,CAC3B,OAA8B,KAAvB,GAAAF,CAAA,EAAsD,IAAK,EAA3D,GAA+BA,CAA/B,CAA+DA,CAA/D,CAAoF,IAJjE,CAM9BzB,8BAA8B,CAACK,CAAD,CAAS,CACnC,IAAKnB,CAAAA,aAAL,CAAqB,IAAId,OAAJ,CAAY,CAACC,CAAD,CAAUuD,CAAV,CAAA,EAAqB,CAClD,IAAK5C,CAAAA,aAAL,CAAqB,IAAIuC,aAAJ,CAAkBlB,CAAlB,CACrB,KAAKrB,CAAAA,aAAc6C,CAAAA,OAAnB,CAA6B,EAAAC,EAAM,CAC/B,IAAKpB,CAAAA,+BAAL,EACAkB,EAAA,CAzHsBlD,KAAJ,CAAU,kBAAV,CAyHlB,CAF+B,CAInC,KAAKM,CAAAA,aAAc+C,CAAAA,MAAnB,CAAkC,EAANC,EAAY,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACpC,MAAMC;AAAWnD,CAAkBU,CAAAA,oBAAlB,EACjB,IAAgB,IAAhB,EAAIyC,CAAJ,CACI,CAAKvB,CAAAA,+BAAL,EACA,CAAAkB,CAAA,CA5H0BlD,KAAJ,CAAU,2BAAV,CA4HtB,CAFJ,KAAA,CAKA,IAAMwD,EAAqB,IAAIC,IAAJ,CAAS,CAAKlD,CAAAA,MAAd,CAAsB,CAAE,KAAQgD,CAAV,CAAtB,CAC3B,IAA+B,CAA/B,EAAIC,CAAmBE,CAAAA,IAAvB,CACI,CAAK1B,CAAAA,+BAAL,EACA,CAAAkB,CAAA,CApIkBlD,KAAJ,CAAU,iBAAV,CAoId,CAFJ,KAAA,CAKA,IAAM2D,EAAmB,KAAMvD,EAAkBwD,CAAAA,YAAlB,CAA+BJ,CAA/B,CACzBK,EAAAA,CAAoB,KAAMvE,EAAA,CAAgBkE,CAAhB,CAChC,EAAKxB,CAAAA,+BAAL,EACArC,EAAA,CAAQ,CAAEoB,MAAO,CAAE4C,iBAAAA,CAAF,CAAoBJ,SAAAA,CAApB,CAA8BO,WAAgC,GAAhCA,CAAYD,CAA1C,CAAT,CAAR,CARA,CANA,CAFoC,CAAA,CAAA,CAkBxC,KAAKvD,CAAAA,aAAcyD,CAAAA,eAAnB,CAAsCC,CAADC,EAAW,IAAK1D,CAAAA,MAAO2D,CAAAA,IAAZ,CAAiBF,CAAMG,CAAAA,IAAvB,CAChD,KAAK7D,CAAAA,aAAc8D,CAAAA,KAAnB,EAzBkD,CAAjC,CA2BrB,OArJuB,CAAErD,MAAO,CAAA,CAAT,CAyHY,CA8BvCS,wBAAwB,EAAG,CACvB,IAAKQ,CAAAA,+BAAL,EACA;KApJ8BhC,MAAJ,CAAU,kBAAV,CAoJ1B,CAFuB,CAIpB4D,mBAAY,CAACS,CAAD,CAAO,CACtB,MAAO,KAAI3E,OAAJ,CAAYC,CAAA,EAAW,CAC1B,MAAM2E,EAAS,IAAIC,UACnBD,EAAOE,CAAAA,SAAP,CAAmB,EAAAC,EAAM,CACrB,MAAMC,EAAkBC,MAAA,CAAOL,CAAOlC,CAAAA,MAAd,CAAxB,CACMwC,EAAcF,CAAgBG,CAAAA,KAAhB,CAAsB,SAAtB,CAEpBlF,EAAA,CAAkBmF,CADsB,CAAtBC,CAACH,CAAYI,CAAAA,MAAbD,CAA2BH,CAAA,CAAY,CAAZ,CAA3BG,CAA4CL,CAC5CI,EAAAA,IAAV,EAAR,CAJqB,CAMzBR,EAAOW,CAAAA,aAAP,CAAqBZ,CAArB,CAR0B,CAAvB,CADe,CAY1BrC,+BAA+B,EAAG,CAC9B,GAA0B,IAA1B,EAAI,IAAK1B,CAAAA,aAAT,EAA+D,WAA/D,GAAkC,IAAKA,CAAAA,aAAc+B,CAAAA,KAArD,CACI,GAAI,CACA,IAAK/B,CAAAA,aAAcoB,CAAAA,IAAnB,EADA,CAGJ,MAAOK,CAAP,CAAe,EAGnB,IAAKvB,CAAAA,aAAL,CAAqBN,CAAA,EACrB,KAAKI,CAAAA,aAAL,CAAqB,IACrB,KAAKC,CAAAA,MAAL,CAAc,EAVgB,CAzJtC,CAuKA,KAAMT,EAAN,QAA+BT,GAAK6F,CAAAA,SAApC,CACI7E,WAAW,EAAG,CACV,KAAA,CAAM,GAAG8E,SAAT,CACA,KAAKC,CAAAA,qBAAL;AAA6B,IAAIhF,CAFvB,CAIdK,oBAAoB,EAAG,CACnB,MAAOL,EAAkBK,CAAAA,oBAAlB,EADY,CAGvBU,2BAA2B,EAAG,CAC1B,MAAOf,EAAkBe,CAAAA,2BAAlB,EADmB,CAG9BmB,+BAA+B,EAAG,CAC9B,MAAOlC,EAAkBkC,CAAAA,+BAAlB,EADuB,CAGlCtB,cAAc,EAAG,CACb,MAAO,KAAKoE,CAAAA,qBAAsBpE,CAAAA,cAA3B,EADM,CAGjBS,aAAa,EAAG,CACZ,MAAO,KAAK2D,CAAAA,qBAAsB3D,CAAAA,aAA3B,EADK,CAGhBc,cAAc,EAAG,CACb,MAAO,KAAK6C,CAAAA,qBAAsB7C,CAAAA,cAA3B,EADM,CAGjBE,eAAe,EAAG,CACd,MAAO,KAAK2C,CAAAA,qBAAsB3C,CAAAA,eAA3B,EADO,CAGlBE,gBAAgB,EAAG,CACf,MAAO,KAAKyC,CAAAA,qBAAsBzC,CAAAA,gBAA3B,EADQ,CA1BvB;AA+BA,IAAIlD,EAAmB4F,MAAOC,CAAAA,MAAP,CAAc,CACjCC,UAAW,IADsB,CAEjCzF,iBAAkBA,CAFe,CAAd,CAKvBV,EAAQG,CAAAA,aAAR,CAAwBA,CAnOsC;\",\n\"sources\":[\"node_modules/capacitor-voice-recorder/dist/plugin.cjs.js\"],\n\"sourcesContent\":[\"shadow$provide[480] = function(global,require,module,exports) {\\n'use strict';\\n\\nvar core = require('@capacitor/core');\\nvar getBlobDuration = require('get-blob-duration');\\n\\nconst VoiceRecorder = core.registerPlugin('VoiceRecorder', {\\n    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.VoiceRecorderWeb()),\\n});\\n\\nconst successResponse = () => ({ value: true });\\nconst failureResponse = () => ({ value: false });\\nconst missingPermissionError = () => new Error('MISSING_PERMISSION');\\nconst alreadyRecordingError = () => new Error('ALREADY_RECORDING');\\nconst deviceCannotVoiceRecordError = () => new Error('DEVICE_CANNOT_VOICE_RECORD');\\nconst failedToRecordError = () => new Error('FAILED_TO_RECORD');\\nconst emptyRecordingError = () => new Error('EMPTY_RECORDING');\\nconst recordingHasNotStartedError = () => new Error('RECORDING_HAS_NOT_STARTED');\\nconst failedToFetchRecordingError = () => new Error('FAILED_TO_FETCH_RECORDING');\\nconst couldNotQueryPermissionStatusError = () => new Error('COULD_NOT_QUERY_PERMISSION_STATUS');\\n\\n// these mime types will be checked one by one in order until one of them is found to be supported by the current browser\\nconst possibleMimeTypes = ['audio/aac', 'audio/webm;codecs=opus', 'audio/mp4', 'audio/webm', 'audio/ogg;codecs=opus'];\\nconst neverResolvingPromise = () => new Promise(() => undefined);\\nclass VoiceRecorderImpl {\\n    constructor() {\\n        this.mediaRecorder = null;\\n        this.chunks = [];\\n        this.pendingResult = neverResolvingPromise();\\n    }\\n    static async canDeviceVoiceRecord() {\\n        var _a;\\n        if (((_a = navigator === null || navigator === void 0 ? void 0 : navigator.mediaDevices) === null || _a === void 0 ? void 0 : _a.getUserMedia) == null || VoiceRecorderImpl.getSupportedMimeType() == null) {\\n            return failureResponse();\\n        }\\n        else {\\n            return successResponse();\\n        }\\n    }\\n    async startRecording() {\\n        if (this.mediaRecorder != null) {\\n            throw alreadyRecordingError();\\n        }\\n        const deviceCanRecord = await VoiceRecorderImpl.canDeviceVoiceRecord();\\n        if (!deviceCanRecord.value) {\\n            throw deviceCannotVoiceRecordError();\\n        }\\n        const havingPermission = await VoiceRecorderImpl.hasAudioRecordingPermission().catch(() => successResponse());\\n        if (!havingPermission.value) {\\n            throw missingPermissionError();\\n        }\\n        return navigator.mediaDevices.getUserMedia({ audio: true })\\n            .then(this.onSuccessfullyStartedRecording.bind(this))\\n            .catch(this.onFailedToStartRecording.bind(this));\\n    }\\n    async stopRecording() {\\n        if (this.mediaRecorder == null) {\\n            throw recordingHasNotStartedError();\\n        }\\n        try {\\n            this.mediaRecorder.stop();\\n            this.mediaRecorder.stream.getTracks().forEach(track => track.stop());\\n            return this.pendingResult;\\n        }\\n        catch (ignore) {\\n            throw failedToFetchRecordingError();\\n        }\\n        finally {\\n            this.prepareInstanceForNextOperation();\\n        }\\n    }\\n    static async hasAudioRecordingPermission() {\\n        return navigator.permissions.query({ name: 'microphone' })\\n            .then(result => ({ value: result.state === 'granted' }))\\n            .catch(() => {\\n            throw couldNotQueryPermissionStatusError();\\n        });\\n    }\\n    static async requestAudioRecordingPermission() {\\n        const havingPermission = await VoiceRecorderImpl.hasAudioRecordingPermission().catch(() => failureResponse());\\n        if (havingPermission.value) {\\n            return successResponse();\\n        }\\n        return navigator.mediaDevices.getUserMedia({ audio: true })\\n            .then(() => successResponse())\\n            .catch(() => failureResponse());\\n    }\\n    pauseRecording() {\\n        if (this.mediaRecorder == null) {\\n            throw recordingHasNotStartedError();\\n        }\\n        else if (this.mediaRecorder.state === 'recording') {\\n            this.mediaRecorder.pause();\\n            return Promise.resolve(successResponse());\\n        }\\n        else {\\n            return Promise.resolve(failureResponse());\\n        }\\n    }\\n    resumeRecording() {\\n        if (this.mediaRecorder == null) {\\n            throw recordingHasNotStartedError();\\n        }\\n        else if (this.mediaRecorder.state === 'paused') {\\n            this.mediaRecorder.resume();\\n            return Promise.resolve(successResponse());\\n        }\\n        else {\\n            return Promise.resolve(failureResponse());\\n        }\\n    }\\n    getCurrentStatus() {\\n        if (this.mediaRecorder == null) {\\n            return Promise.resolve({ status: 'NONE' });\\n        }\\n        else if (this.mediaRecorder.state === 'recording') {\\n            return Promise.resolve({ status: 'RECORDING' });\\n        }\\n        else if (this.mediaRecorder.state === 'paused') {\\n            return Promise.resolve({ status: 'PAUSED' });\\n        }\\n        else {\\n            return Promise.resolve({ status: 'NONE' });\\n        }\\n    }\\n    static getSupportedMimeType() {\\n        if ((MediaRecorder === null || MediaRecorder === void 0 ? void 0 : MediaRecorder.isTypeSupported) == null)\\n            return null;\\n        const foundSupportedType = possibleMimeTypes.find(type => MediaRecorder.isTypeSupported(type));\\n        return foundSupportedType !== null && foundSupportedType !== void 0 ? foundSupportedType : null;\\n    }\\n    onSuccessfullyStartedRecording(stream) {\\n        this.pendingResult = new Promise((resolve, reject) => {\\n            this.mediaRecorder = new MediaRecorder(stream);\\n            this.mediaRecorder.onerror = () => {\\n                this.prepareInstanceForNextOperation();\\n                reject(failedToRecordError());\\n            };\\n            this.mediaRecorder.onstop = async () => {\\n                const mimeType = VoiceRecorderImpl.getSupportedMimeType();\\n                if (mimeType == null) {\\n                    this.prepareInstanceForNextOperation();\\n                    reject(failedToFetchRecordingError());\\n                    return;\\n                }\\n                const blobVoiceRecording = new Blob(this.chunks, { 'type': mimeType });\\n                if (blobVoiceRecording.size <= 0) {\\n                    this.prepareInstanceForNextOperation();\\n                    reject(emptyRecordingError());\\n                    return;\\n                }\\n                const recordDataBase64 = await VoiceRecorderImpl.blobToBase64(blobVoiceRecording);\\n                const recordingDuration = await getBlobDuration(blobVoiceRecording);\\n                this.prepareInstanceForNextOperation();\\n                resolve({ value: { recordDataBase64, mimeType, msDuration: recordingDuration * 1000 } });\\n            };\\n            this.mediaRecorder.ondataavailable = (event) => this.chunks.push(event.data);\\n            this.mediaRecorder.start();\\n        });\\n        return successResponse();\\n    }\\n    onFailedToStartRecording() {\\n        this.prepareInstanceForNextOperation();\\n        throw failedToRecordError();\\n    }\\n    static blobToBase64(blob) {\\n        return new Promise(resolve => {\\n            const reader = new FileReader();\\n            reader.onloadend = () => {\\n                const recordingResult = String(reader.result);\\n                const splitResult = recordingResult.split('base64,');\\n                const toResolve = (splitResult.length > 1) ? splitResult[1] : recordingResult;\\n                resolve(toResolve.trim());\\n            };\\n            reader.readAsDataURL(blob);\\n        });\\n    }\\n    prepareInstanceForNextOperation() {\\n        if (this.mediaRecorder != null && this.mediaRecorder.state === 'recording') {\\n            try {\\n                this.mediaRecorder.stop();\\n            }\\n            catch (ignore) {\\n            }\\n        }\\n        this.pendingResult = neverResolvingPromise();\\n        this.mediaRecorder = null;\\n        this.chunks = [];\\n    }\\n}\\n\\nclass VoiceRecorderWeb extends core.WebPlugin {\\n    constructor() {\\n        super(...arguments);\\n        this.voiceRecorderInstance = new VoiceRecorderImpl();\\n    }\\n    canDeviceVoiceRecord() {\\n        return VoiceRecorderImpl.canDeviceVoiceRecord();\\n    }\\n    hasAudioRecordingPermission() {\\n        return VoiceRecorderImpl.hasAudioRecordingPermission();\\n    }\\n    requestAudioRecordingPermission() {\\n        return VoiceRecorderImpl.requestAudioRecordingPermission();\\n    }\\n    startRecording() {\\n        return this.voiceRecorderInstance.startRecording();\\n    }\\n    stopRecording() {\\n        return this.voiceRecorderInstance.stopRecording();\\n    }\\n    pauseRecording() {\\n        return this.voiceRecorderInstance.pauseRecording();\\n    }\\n    resumeRecording() {\\n        return this.voiceRecorderInstance.resumeRecording();\\n    }\\n    getCurrentStatus() {\\n        return this.voiceRecorderInstance.getCurrentStatus();\\n    }\\n}\\n\\nvar web = /*#__PURE__*/Object.freeze({\\n    __proto__: null,\\n    VoiceRecorderWeb: VoiceRecorderWeb\\n});\\n\\nexports.VoiceRecorder = VoiceRecorder;\\n//# sourceMappingURL=plugin.cjs.js.map\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"core\",\"getBlobDuration\",\"VoiceRecorder\",\"registerPlugin\",\"web\",\"Promise\",\"resolve\",\"then\",\"m\",\"VoiceRecorderWeb\",\"recordingHasNotStartedError\",\"Error\",\"possibleMimeTypes\",\"neverResolvingPromise\",\"undefined\",\"VoiceRecorderImpl\",\"constructor\",\"mediaRecorder\",\"chunks\",\"pendingResult\",\"canDeviceVoiceRecord\",\"_a\",\"navigator\",\"mediaDevices\",\"getUserMedia\",\"getSupportedMimeType\",\"value\",\"startRecording\",\"deviceCanRecord\",\"havingPermission\",\"hasAudioRecordingPermission\",\"catch\",\"audio\",\"onSuccessfullyStartedRecording\",\"bind\",\"onFailedToStartRecording\",\"stopRecording\",\"stop\",\"stream\",\"getTracks\",\"forEach\",\"track\",\"ignore\",\"prepareInstanceForNextOperation\",\"permissions\",\"query\",\"name\",\"result\",\"state\",\"requestAudioRecordingPermission\",\"pauseRecording\",\"pause\",\"resumeRecording\",\"resume\",\"getCurrentStatus\",\"status\",\"MediaRecorder\",\"isTypeSupported\",\"foundSupportedType\",\"find\",\"type\",\"reject\",\"onerror\",\"this.mediaRecorder.onerror\",\"onstop\",\"this.mediaRecorder.onstop\",\"mimeType\",\"blobVoiceRecording\",\"Blob\",\"size\",\"recordDataBase64\",\"blobToBase64\",\"recordingDuration\",\"msDuration\",\"ondataavailable\",\"event\",\"this.mediaRecorder.ondataavailable\",\"push\",\"data\",\"start\",\"blob\",\"reader\",\"FileReader\",\"onloadend\",\"reader.onloadend\",\"recordingResult\",\"String\",\"splitResult\",\"split\",\"trim\",\"toResolve\",\"length\",\"readAsDataURL\",\"WebPlugin\",\"arguments\",\"voiceRecorderInstance\",\"Object\",\"freeze\",\"__proto__\"]\n}\n"]