["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@sentry/utils/dist/ratelimit.js"],"~:js","shadow$provide[414]=function(ra,X,Ra,P){function w(p,c){void 0===c&&(c=Date.now());var u=parseInt(\"\"+p,10);if(!isNaN(u))return 1E3*u;p=Date.parse(\"\"+p);return isNaN(p)?P.DEFAULT_RETRY_AFTER:p-c}function Z(p,c){return p[c]||p.all||0}Object.defineProperty(P,\"__esModule\",{value:!0});var B=X(384);P.DEFAULT_RETRY_AFTER=6E4;P.parseRetryAfterHeader=w;P.disabledUntil=Z;P.isRateLimited=function(p,c,u){void 0===u&&(u=Date.now());return Z(p,c)>u};P.updateRateLimits=function(p,c,u){var A,y,x;void 0===u&&(u=Date.now());\np=B.__assign({},p);var Q=c[\"x-sentry-rate-limits\"];c=c[\"retry-after\"];if(Q)try{for(var g=B.__values(Q.trim().split(\",\")),h=g.next();!h.done;h=g.next()){var b=h.value.split(\":\",2),l=parseInt(b[0],10),k=1E3*(isNaN(l)?60:l);if(b[1])try{for(var r=(y=void 0,B.__values(b[1].split(\";\"))),D=r.next();!D.done;D=r.next())p[D.value]=u+k}catch(t){y={error:t}}finally{try{D&&!D.done&&(x=r.return)&&x.call(r)}finally{if(y)throw y.error;}}else p.all=u+k}}catch(t){var v={error:t}}finally{try{h&&!h.done&&(A=g.return)&&\nA.call(g)}finally{if(v)throw v.error;}}else c&&(p.all=u+w(c,u));return p}}","~:source","shadow$provide[414] = function(global,require,module,exports) {\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar tslib_1 = require(\"tslib\");\nexports.DEFAULT_RETRY_AFTER = 60 * 1000; // 60 seconds\n/**\n * Extracts Retry-After value from the request header or returns default value\n * @param header string representation of 'Retry-After' header\n * @param now current unix timestamp\n *\n */\nfunction parseRetryAfterHeader(header, now) {\n    if (now === void 0) { now = Date.now(); }\n    var headerDelay = parseInt(\"\" + header, 10);\n    if (!isNaN(headerDelay)) {\n        return headerDelay * 1000;\n    }\n    var headerDate = Date.parse(\"\" + header);\n    if (!isNaN(headerDate)) {\n        return headerDate - now;\n    }\n    return exports.DEFAULT_RETRY_AFTER;\n}\nexports.parseRetryAfterHeader = parseRetryAfterHeader;\n/**\n * Gets the time that given category is disabled until for rate limiting\n */\nfunction disabledUntil(limits, category) {\n    return limits[category] || limits.all || 0;\n}\nexports.disabledUntil = disabledUntil;\n/**\n * Checks if a category is rate limited\n */\nfunction isRateLimited(limits, category, now) {\n    if (now === void 0) { now = Date.now(); }\n    return disabledUntil(limits, category) > now;\n}\nexports.isRateLimited = isRateLimited;\n/**\n * Update ratelimits from incoming headers.\n * Returns true if headers contains a non-empty rate limiting header.\n */\nfunction updateRateLimits(limits, headers, now) {\n    var e_1, _a, e_2, _b;\n    if (now === void 0) { now = Date.now(); }\n    var updatedRateLimits = tslib_1.__assign({}, limits);\n    // \"The name is case-insensitive.\"\n    // https://developer.mozilla.org/en-US/docs/Web/API/Headers/get\n    var rateLimitHeader = headers['x-sentry-rate-limits'];\n    var retryAfterHeader = headers['retry-after'];\n    if (rateLimitHeader) {\n        try {\n            /**\n             * rate limit headers are of the form\n             *     <header>,<header>,..\n             * where each <header> is of the form\n             *     <retry_after>: <categories>: <scope>: <reason_code>\n             * where\n             *     <retry_after> is a delay in seconds\n             *     <categories> is the event type(s) (error, transaction, etc) being rate limited and is of the form\n             *         <category>;<category>;...\n             *     <scope> is what's being limited (org, project, or key) - ignored by SDK\n             *     <reason_code> is an arbitrary string like \"org_quota\" - ignored by SDK\n             */\n            for (var _c = tslib_1.__values(rateLimitHeader.trim().split(',')), _d = _c.next(); !_d.done; _d = _c.next()) {\n                var limit = _d.value;\n                var parameters = limit.split(':', 2);\n                var headerDelay = parseInt(parameters[0], 10);\n                var delay = (!isNaN(headerDelay) ? headerDelay : 60) * 1000; // 60sec default\n                if (!parameters[1]) {\n                    updatedRateLimits.all = now + delay;\n                }\n                else {\n                    try {\n                        for (var _e = (e_2 = void 0, tslib_1.__values(parameters[1].split(';'))), _f = _e.next(); !_f.done; _f = _e.next()) {\n                            var category = _f.value;\n                            updatedRateLimits[category] = now + delay;\n                        }\n                    }\n                    catch (e_2_1) { e_2 = { error: e_2_1 }; }\n                    finally {\n                        try {\n                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);\n                        }\n                        finally { if (e_2) throw e_2.error; }\n                    }\n                }\n            }\n        }\n        catch (e_1_1) { e_1 = { error: e_1_1 }; }\n        finally {\n            try {\n                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);\n            }\n            finally { if (e_1) throw e_1.error; }\n        }\n    }\n    else if (retryAfterHeader) {\n        updatedRateLimits.all = now + parseRetryAfterHeader(retryAfterHeader, now);\n    }\n    return updatedRateLimits;\n}\nexports.updateRateLimits = updateRateLimits;\n//# sourceMappingURL=ratelimit.js.map\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$$sentry$utils$node_modules$tslib$tslib"]],"~:properties",["^5",["parseRetryAfterHeader","__esModule","disabledUntil","error","value","all","isRateLimited","updateRateLimits","DEFAULT_RETRY_AFTER"]],"~:compiled-at",1766065009695,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$sentry$utils$dist$ratelimit.js\",\n\"lineCount\":3,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAU9DC,QAASA,EAAqB,CAACC,CAAD,CAASC,CAAT,CAAc,CAC5B,IAAK,EAAjB,GAAIA,CAAJ,GAAsBA,CAAtB,CAA4BC,IAAKD,CAAAA,GAAL,EAA5B,CACA,KAAIE,EAAcC,QAAA,CAAS,EAAT,CAAcJ,CAAd,CAAsB,EAAtB,CAClB,IAAI,CAACK,KAAA,CAAMF,CAAN,CAAL,CACI,MAAqB,IAArB,CAAOA,CAEPG,EAAAA,CAAaJ,IAAKK,CAAAA,KAAL,CAAW,EAAX,CAAgBP,CAAhB,CACjB,OAAKK,MAAA,CAAMC,CAAN,CAAL,CAGOR,CAAQU,CAAAA,mBAHf,CACWF,CADX,CACwBL,CARgB,CAgB5CQ,QAASA,EAAa,CAACC,CAAD,CAASC,CAAT,CAAmB,CACrC,MAAOD,EAAA,CAAOC,CAAP,CAAP,EAA2BD,CAAOE,CAAAA,GAAlC,EAAyC,CADJ,CAzBzCC,MAAOC,CAAAA,cAAP,CAAsBhB,CAAtB,CAA+B,YAA/B,CAA6C,CAAEiB,MAAO,CAAA,CAAT,CAA7C,CACA,KAAIC,EAAUpB,CAAA,CAAQ,GAAR,CACdE,EAAQU,CAAAA,mBAAR,CAA8B,GAmB9BV,EAAQC,CAAAA,qBAAR,CAAgCA,CAOhCD,EAAQW,CAAAA,aAAR,CAAwBA,CAQxBX,EAAQmB,CAAAA,aAAR,CAJAA,QAAsB,CAACP,CAAD,CAASC,CAAT,CAAmBV,CAAnB,CAAwB,CAC9B,IAAK,EAAjB,GAAIA,CAAJ,GAAsBA,CAAtB,CAA4BC,IAAKD,CAAAA,GAAL,EAA5B,CACA,OAAOQ,EAAA,CAAcC,CAAd,CAAsBC,CAAtB,CAAP,CAAyCV,CAFC,CAqE9CH,EAAQoB,CAAAA,gBAAR,CA5DAA,QAAyB,CAACR,CAAD,CAASS,CAAT,CAAkBlB,CAAlB,CAAuB,CAAA,IACnCmB,CADmC,CAC/BC,CAD+B,CAC1BC,CACN,KAAK,EAAjB,GAAIrB,CAAJ,GAAsBA,CAAtB,CAA4BC,IAAKD,CAAAA,GAAL,EAA5B,CACIsB;CAAAA,CAAoBP,CAAQQ,CAAAA,QAAR,CAAiB,EAAjB,CAAqBd,CAArB,CAGxB,KAAIe,EAAkBN,CAAA,CAAQ,sBAAR,CAClBO,EAAAA,CAAmBP,CAAA,CAAQ,aAAR,CACvB,IAAIM,CAAJ,CACI,GAAI,CAaA,IAbA,IAaSE,EAAKX,CAAQY,CAAAA,QAAR,CAAiBH,CAAgBI,CAAAA,IAAhB,EAAuBC,CAAAA,KAAvB,CAA6B,GAA7B,CAAjB,CAbd,CAamEC,EAAKJ,CAAGK,CAAAA,IAAH,EAAxE,CAAmF,CAACD,CAAGE,CAAAA,IAAvF,CAA6FF,CAA7F,CAAkGJ,CAAGK,CAAAA,IAAH,EAAlG,CAA6G,CAEzG,IAAIE,EADQH,CAAGhB,CAAAA,KACQe,CAAAA,KAAN,CAAY,GAAZ,CAAiB,CAAjB,CAAjB,CACI3B,EAAcC,QAAA,CAAS8B,CAAA,CAAW,CAAX,CAAT,CAAwB,EAAxB,CADlB,CAEIC,EAAmD,GAAnDA,EAAU9B,KAAA,CAAMF,CAAN,CAAD,CAAoC,EAApC,CAAsBA,CAA/BgC,CACJ,IAAKD,CAAA,CAAW,CAAX,CAAL,CAII,GAAI,CACA,IADA,IACSE,GAAMf,CAAA,CAAM,IAAK,EAAX,CAAcL,CAAQY,CAAAA,QAAR,CAAiBM,CAAA,CAAW,CAAX,CAAcJ,CAAAA,KAAd,CAAoB,GAApB,CAAjB,CAApBM,CADT,CAC0EC,EAAKD,CAAGJ,CAAAA,IAAH,EAA/E,CAA0F,CAACK,CAAGJ,CAAAA,IAA9F,CAAoGI,CAApG,CAAyGD,CAAGJ,CAAAA,IAAH,EAAzG,CAEIT,CAAA,CADec,CAAGtB,CAAAA,KAClB,CAAA,CAA8Bd,CAA9B,CAAoCkC,CAHxC,CAMJ,MAAOG,CAAP,CAAc,CAAEjB,CAAA,CAAM,CAAEkB,MAAOD,CAAT,CAAR,CANd,OAOQ,CACJ,GAAI,CACID,CAAJ,EAAU,CAACA,CAAGJ,CAAAA,IAAd,GAAuBX,CAAvB,CAA4Bc,CAAGI,CAAAA,MAA/B,GAAwClB,CAAGmB,CAAAA,IAAH,CAAQL,CAAR,CADxC,CAAJ,OAGQ,CAAE,GAAIf,CAAJ,CAAS,KAAMA,EAAIkB,CAAAA,KAAV,CAAX,CAJJ,CAXZ,IACIhB,EAAkBX,CAAAA,GAAlB,CAAwBX,CAAxB,CAA8BkC,CANuE,CAb7G,CAsCJ,MAAOO,CAAP,CAAc,CAAE,IAAAC,EAAM,CAAEJ,MAAOG,CAAT,CAAR,CAtCd,OAuCQ,CACJ,GAAI,CACIX,CAAJ,EAAU,CAACA,CAAGE,CAAAA,IAAd,GAAuBb,CAAvB,CAA4BO,CAAGa,CAAAA,MAA/B;AAAwCpB,CAAGqB,CAAAA,IAAH,CAAQd,CAAR,CADxC,CAAJ,OAGQ,CAAE,GAAIgB,CAAJ,CAAS,KAAMA,EAAIJ,CAAAA,KAAV,CAAX,CAJJ,CAxCZ,IA+CSb,EAAJ,GACDH,CAAkBX,CAAAA,GADjB,CACuBX,CADvB,CAC6BF,CAAA,CAAsB2B,CAAtB,CAAwCzB,CAAxC,CAD7B,CAGL,OAAOsB,EA1DqC,CA1Cc;\",\n\"sources\":[\"node_modules/@sentry/utils/dist/ratelimit.js\"],\n\"sourcesContent\":[\"shadow$provide[414] = function(global,require,module,exports) {\\nObject.defineProperty(exports, \\\"__esModule\\\", { value: true });\\nvar tslib_1 = require(\\\"tslib\\\");\\nexports.DEFAULT_RETRY_AFTER = 60 * 1000; // 60 seconds\\n/**\\n * Extracts Retry-After value from the request header or returns default value\\n * @param header string representation of 'Retry-After' header\\n * @param now current unix timestamp\\n *\\n */\\nfunction parseRetryAfterHeader(header, now) {\\n    if (now === void 0) { now = Date.now(); }\\n    var headerDelay = parseInt(\\\"\\\" + header, 10);\\n    if (!isNaN(headerDelay)) {\\n        return headerDelay * 1000;\\n    }\\n    var headerDate = Date.parse(\\\"\\\" + header);\\n    if (!isNaN(headerDate)) {\\n        return headerDate - now;\\n    }\\n    return exports.DEFAULT_RETRY_AFTER;\\n}\\nexports.parseRetryAfterHeader = parseRetryAfterHeader;\\n/**\\n * Gets the time that given category is disabled until for rate limiting\\n */\\nfunction disabledUntil(limits, category) {\\n    return limits[category] || limits.all || 0;\\n}\\nexports.disabledUntil = disabledUntil;\\n/**\\n * Checks if a category is rate limited\\n */\\nfunction isRateLimited(limits, category, now) {\\n    if (now === void 0) { now = Date.now(); }\\n    return disabledUntil(limits, category) > now;\\n}\\nexports.isRateLimited = isRateLimited;\\n/**\\n * Update ratelimits from incoming headers.\\n * Returns true if headers contains a non-empty rate limiting header.\\n */\\nfunction updateRateLimits(limits, headers, now) {\\n    var e_1, _a, e_2, _b;\\n    if (now === void 0) { now = Date.now(); }\\n    var updatedRateLimits = tslib_1.__assign({}, limits);\\n    // \\\"The name is case-insensitive.\\\"\\n    // https://developer.mozilla.org/en-US/docs/Web/API/Headers/get\\n    var rateLimitHeader = headers['x-sentry-rate-limits'];\\n    var retryAfterHeader = headers['retry-after'];\\n    if (rateLimitHeader) {\\n        try {\\n            /**\\n             * rate limit headers are of the form\\n             *     <header>,<header>,..\\n             * where each <header> is of the form\\n             *     <retry_after>: <categories>: <scope>: <reason_code>\\n             * where\\n             *     <retry_after> is a delay in seconds\\n             *     <categories> is the event type(s) (error, transaction, etc) being rate limited and is of the form\\n             *         <category>;<category>;...\\n             *     <scope> is what's being limited (org, project, or key) - ignored by SDK\\n             *     <reason_code> is an arbitrary string like \\\"org_quota\\\" - ignored by SDK\\n             */\\n            for (var _c = tslib_1.__values(rateLimitHeader.trim().split(',')), _d = _c.next(); !_d.done; _d = _c.next()) {\\n                var limit = _d.value;\\n                var parameters = limit.split(':', 2);\\n                var headerDelay = parseInt(parameters[0], 10);\\n                var delay = (!isNaN(headerDelay) ? headerDelay : 60) * 1000; // 60sec default\\n                if (!parameters[1]) {\\n                    updatedRateLimits.all = now + delay;\\n                }\\n                else {\\n                    try {\\n                        for (var _e = (e_2 = void 0, tslib_1.__values(parameters[1].split(';'))), _f = _e.next(); !_f.done; _f = _e.next()) {\\n                            var category = _f.value;\\n                            updatedRateLimits[category] = now + delay;\\n                        }\\n                    }\\n                    catch (e_2_1) { e_2 = { error: e_2_1 }; }\\n                    finally {\\n                        try {\\n                            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);\\n                        }\\n                        finally { if (e_2) throw e_2.error; }\\n                    }\\n                }\\n            }\\n        }\\n        catch (e_1_1) { e_1 = { error: e_1_1 }; }\\n        finally {\\n            try {\\n                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);\\n            }\\n            finally { if (e_1) throw e_1.error; }\\n        }\\n    }\\n    else if (retryAfterHeader) {\\n        updatedRateLimits.all = now + parseRetryAfterHeader(retryAfterHeader, now);\\n    }\\n    return updatedRateLimits;\\n}\\nexports.updateRateLimits = updateRateLimits;\\n//# sourceMappingURL=ratelimit.js.map\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"parseRetryAfterHeader\",\"header\",\"now\",\"Date\",\"headerDelay\",\"parseInt\",\"isNaN\",\"headerDate\",\"parse\",\"DEFAULT_RETRY_AFTER\",\"disabledUntil\",\"limits\",\"category\",\"all\",\"Object\",\"defineProperty\",\"value\",\"tslib_1\",\"isRateLimited\",\"updateRateLimits\",\"headers\",\"_a\",\"e_2\",\"_b\",\"updatedRateLimits\",\"__assign\",\"rateLimitHeader\",\"retryAfterHeader\",\"_c\",\"__values\",\"trim\",\"split\",\"_d\",\"next\",\"done\",\"parameters\",\"delay\",\"_e\",\"_f\",\"e_2_1\",\"error\",\"return\",\"call\",\"e_1_1\",\"e_1\"]\n}\n"]