["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@sentry/hub/dist/sessionflusher.js"],"~:js","shadow$provide[420]=function(ra,X,Ra,P){Object.defineProperty(P,\"__esModule\",{value:!0});var w=X(415),Z=X(418),B=X(419);ra=function(){function p(c,u){var A=this;this.flushTimeout=60;this._pendingAggregates={};this._isEnabled=!0;this._transport=c;this._intervalId=setInterval(function(){return A.flush()},1E3*this.flushTimeout);this._sessionAttrs=u}p.prototype.sendSessionAggregates=function(c){this._transport.sendSession?void this._transport.sendSession(c).then(null,function(u){Z.IS_DEBUG_BUILD&&w.logger.error(\"Error while sending session:\",\nu)}):Z.IS_DEBUG_BUILD&&w.logger.warn(\"Dropping session because custom transport doesn't implement sendSession\")};p.prototype.flush=function(){var c=this.getSessionAggregates();0!==c.aggregates.length&&(this._pendingAggregates={},this.sendSessionAggregates(c))};p.prototype.getSessionAggregates=function(){var c=this,u=Object.keys(this._pendingAggregates).map(function(A){return c._pendingAggregates[parseInt(A)]});return w.dropUndefinedKeys({attrs:this._sessionAttrs,aggregates:u})};p.prototype.close=\nfunction(){clearInterval(this._intervalId);this._isEnabled=!1;this.flush()};p.prototype.incrementSessionStatusCount=function(){if(this._isEnabled){var c=B.getCurrentHub().getScope(),u=c&&c.getRequestSession();u&&u.status&&(this._incrementSessionStatusCount(u.status,new Date),c&&c.setRequestSession(void 0))}};p.prototype._incrementSessionStatusCount=function(c,u){u=(new Date(u)).setSeconds(0,0);this._pendingAggregates[u]=this._pendingAggregates[u]||{};var A=this._pendingAggregates[u];A.started||(A.started=\n(new Date(u)).toISOString());switch(c){case \"errored\":return A.errored=(A.errored||0)+1,A.errored;case \"ok\":return A.exited=(A.exited||0)+1,A.exited;default:return A.crashed=(A.crashed||0)+1,A.crashed}};return p}();P.SessionFlusher=ra}","~:source","shadow$provide[420] = function(global,require,module,exports) {\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar utils_1 = require(\"@sentry/utils\");\nvar flags_1 = require(\"./flags\");\nvar hub_1 = require(\"./hub\");\n/**\n * @inheritdoc\n */\nvar SessionFlusher = /** @class */ (function () {\n    function SessionFlusher(transport, attrs) {\n        var _this = this;\n        this.flushTimeout = 60;\n        this._pendingAggregates = {};\n        this._isEnabled = true;\n        this._transport = transport;\n        // Call to setInterval, so that flush is called every 60 seconds\n        this._intervalId = setInterval(function () { return _this.flush(); }, this.flushTimeout * 1000);\n        this._sessionAttrs = attrs;\n    }\n    /** Sends session aggregates to Transport */\n    SessionFlusher.prototype.sendSessionAggregates = function (sessionAggregates) {\n        if (!this._transport.sendSession) {\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.warn(\"Dropping session because custom transport doesn't implement sendSession\");\n            return;\n        }\n        void this._transport.sendSession(sessionAggregates).then(null, function (reason) {\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending session:', reason);\n        });\n    };\n    /** Checks if `pendingAggregates` has entries, and if it does flushes them by calling `sendSessions` */\n    SessionFlusher.prototype.flush = function () {\n        var sessionAggregates = this.getSessionAggregates();\n        if (sessionAggregates.aggregates.length === 0) {\n            return;\n        }\n        this._pendingAggregates = {};\n        this.sendSessionAggregates(sessionAggregates);\n    };\n    /** Massages the entries in `pendingAggregates` and returns aggregated sessions */\n    SessionFlusher.prototype.getSessionAggregates = function () {\n        var _this = this;\n        var aggregates = Object.keys(this._pendingAggregates).map(function (key) {\n            return _this._pendingAggregates[parseInt(key)];\n        });\n        var sessionAggregates = {\n            attrs: this._sessionAttrs,\n            aggregates: aggregates,\n        };\n        return utils_1.dropUndefinedKeys(sessionAggregates);\n    };\n    /** JSDoc */\n    SessionFlusher.prototype.close = function () {\n        clearInterval(this._intervalId);\n        this._isEnabled = false;\n        this.flush();\n    };\n    /**\n     * Wrapper function for _incrementSessionStatusCount that checks if the instance of SessionFlusher is enabled then\n     * fetches the session status of the request from `Scope.getRequestSession().status` on the scope and passes them to\n     * `_incrementSessionStatusCount` along with the start date\n     */\n    SessionFlusher.prototype.incrementSessionStatusCount = function () {\n        if (!this._isEnabled) {\n            return;\n        }\n        var scope = hub_1.getCurrentHub().getScope();\n        var requestSession = scope && scope.getRequestSession();\n        if (requestSession && requestSession.status) {\n            this._incrementSessionStatusCount(requestSession.status, new Date());\n            // This is not entirely necessarily but is added as a safe guard to indicate the bounds of a request and so in\n            // case captureRequestSession is called more than once to prevent double count\n            if (scope) {\n                scope.setRequestSession(undefined);\n            }\n            /* eslint-enable @typescript-eslint/no-unsafe-member-access */\n        }\n    };\n    /**\n     * Increments status bucket in pendingAggregates buffer (internal state) corresponding to status of\n     * the session received\n     */\n    SessionFlusher.prototype._incrementSessionStatusCount = function (status, date) {\n        // Truncate minutes and seconds on Session Started attribute to have one minute bucket keys\n        var sessionStartedTrunc = new Date(date).setSeconds(0, 0);\n        this._pendingAggregates[sessionStartedTrunc] = this._pendingAggregates[sessionStartedTrunc] || {};\n        // corresponds to aggregated sessions in one specific minute bucket\n        // for example, {\"started\":\"2021-03-16T08:00:00.000Z\",\"exited\":4, \"errored\": 1}\n        var aggregationCounts = this._pendingAggregates[sessionStartedTrunc];\n        if (!aggregationCounts.started) {\n            aggregationCounts.started = new Date(sessionStartedTrunc).toISOString();\n        }\n        switch (status) {\n            case 'errored':\n                aggregationCounts.errored = (aggregationCounts.errored || 0) + 1;\n                return aggregationCounts.errored;\n            case 'ok':\n                aggregationCounts.exited = (aggregationCounts.exited || 0) + 1;\n                return aggregationCounts.exited;\n            default:\n                aggregationCounts.crashed = (aggregationCounts.crashed || 0) + 1;\n                return aggregationCounts.crashed;\n        }\n    };\n    return SessionFlusher;\n}());\nexports.SessionFlusher = SessionFlusher;\n//# sourceMappingURL=sessionflusher.js.map\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$$sentry$hub$dist$flags","~$module$node_modules$$sentry$hub$dist$hub","~$shadow.js","~$module$node_modules$$sentry$utils$dist$index"]],"~:properties",["^5",["crashed","attrs","SessionFlusher","started","_incrementSessionStatusCount","getSessionAggregates","_sessionAttrs","errored","__esModule","flush","flushTimeout","incrementSessionStatusCount","value","_isEnabled","close","_pendingAggregates","_intervalId","aggregates","_transport","exited","sendSessionAggregates"]],"~:compiled-at",1766065009696,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$sentry$hub$dist$sessionflusher.js\",\n\"lineCount\":4,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAC9DC,MAAOC,CAAAA,cAAP,CAAsBF,CAAtB,CAA+B,YAA/B,CAA6C,CAAEG,MAAO,CAAA,CAAT,CAA7C,CACA,KAAIC,EAAUN,CAAA,CAAQ,GAAR,CAAd,CACIO,EAAUP,CAAA,CAAQ,GAAR,CADd,CAEIQ,EAAQR,CAAA,CAAQ,GAAR,CAIRS,GAAAA,CAAgC,QAAS,EAAG,CAC5CA,QAASA,EAAc,CAACC,CAAD,CAAYC,CAAZ,CAAmB,CACtC,IAAIC,EAAQ,IACZ,KAAKC,CAAAA,YAAL,CAAoB,EACpB,KAAKC,CAAAA,kBAAL,CAA0B,EAC1B,KAAKC,CAAAA,UAAL,CAAkB,CAAA,CAClB,KAAKC,CAAAA,UAAL,CAAkBN,CAElB,KAAKO,CAAAA,WAAL,CAAmBC,WAAA,CAAY,QAAS,EAAG,CAAE,MAAON,EAAMO,CAAAA,KAAN,EAAT,CAAxB,CAAuE,GAAvE,CAAmD,IAAKN,CAAAA,YAAxD,CACnB,KAAKO,CAAAA,aAAL,CAAqBT,CARiB,CAW1CF,CAAeY,CAAAA,SAAUC,CAAAA,qBAAzB,CAAiDC,QAAS,CAACC,CAAD,CAAoB,CACrE,IAAKR,CAAAA,UAAWS,CAAAA,WAArB,CAIA,IAAK,KAAKT,CAAAA,UAAWS,CAAAA,WAAhB,CAA4BD,CAA5B,CAA+CE,CAAAA,IAA/C,CAAoD,IAApD,CAA0D,QAAS,CAACC,CAAD,CAAS,CAC7EpB,CAAQqB,CAAAA,cAAR,EAA0BtB,CAAQuB,CAAAA,MAAOC,CAAAA,KAAf,CAAqB,8BAArB;AAAqDH,CAArD,CADmD,CAA5E,CAJL,CACIpB,CAAQqB,CAAAA,cADZ,EAC8BtB,CAAQuB,CAAAA,MAAOE,CAAAA,IAAf,CAAoB,yEAApB,CAF4C,CAU9EtB,EAAeY,CAAAA,SAAUF,CAAAA,KAAzB,CAAiCa,QAAS,EAAG,CACzC,IAAIR,EAAoB,IAAKS,CAAAA,oBAAL,EACoB,EAA5C,GAAIT,CAAkBU,CAAAA,UAAWC,CAAAA,MAAjC,GAGA,IAAKrB,CAAAA,kBACL,CAD0B,EAC1B,CAAA,IAAKQ,CAAAA,qBAAL,CAA2BE,CAA3B,CAJA,CAFyC,CAS7Cf,EAAeY,CAAAA,SAAUY,CAAAA,oBAAzB,CAAgDG,QAAS,EAAG,CACxD,IAAIxB,EAAQ,IAAZ,CACIsB,EAAa/B,MAAOkC,CAAAA,IAAP,CAAY,IAAKvB,CAAAA,kBAAjB,CAAqCwB,CAAAA,GAArC,CAAyC,QAAS,CAACC,CAAD,CAAM,CACrE,MAAO3B,EAAME,CAAAA,kBAAN,CAAyB0B,QAAA,CAASD,CAAT,CAAzB,CAD8D,CAAxD,CAOjB,OAAOjC,EAAQmC,CAAAA,iBAAR,CAJiBjB,CACpBb,MAAO,IAAKS,CAAAA,aADQI,CAEpBU,WAAYA,CAFQV,CAIjB,CATiD,CAY5Df,EAAeY,CAAAA,SAAUqB,CAAAA,KAAzB;AAAiCC,QAAS,EAAG,CACzCC,aAAA,CAAc,IAAK3B,CAAAA,WAAnB,CACA,KAAKF,CAAAA,UAAL,CAAkB,CAAA,CAClB,KAAKI,CAAAA,KAAL,EAHyC,CAU7CV,EAAeY,CAAAA,SAAUwB,CAAAA,2BAAzB,CAAuDC,QAAS,EAAG,CAC/D,GAAK,IAAK/B,CAAAA,UAAV,CAAA,CAGA,IAAIgC,EAAQvC,CAAMwC,CAAAA,aAAN,EAAsBC,CAAAA,QAAtB,EAAZ,CACIC,EAAiBH,CAAjBG,EAA0BH,CAAMI,CAAAA,iBAAN,EAC1BD,EAAJ,EAAsBA,CAAeE,CAAAA,MAArC,GACI,IAAKC,CAAAA,4BAAL,CAAkCH,CAAeE,CAAAA,MAAjD,CAAyD,IAAIE,IAA7D,CAGA,CAAIP,CAAJ,EACIA,CAAMQ,CAAAA,iBAAN,CAAwBC,IAAAA,EAAxB,CALR,CALA,CAD+D,CAoBnE/C,EAAeY,CAAAA,SAAUgC,CAAAA,4BAAzB,CAAwDI,QAAS,CAACL,CAAD,CAASM,CAAT,CAAe,CAExEC,CAAAA,CAAqCC,CAAf,IAAIN,IAAJ,CAASI,CAAT,CAAeE,EAAAA,UAAf,CAA0B,CAA1B,CAA6B,CAA7B,CAC1B,KAAK9C,CAAAA,kBAAL,CAAwB6C,CAAxB,CAAA,CAA+C,IAAK7C,CAAAA,kBAAL,CAAwB6C,CAAxB,CAA/C,EAA+F,EAG/F,KAAIE,EAAoB,IAAK/C,CAAAA,kBAAL,CAAwB6C,CAAxB,CACnBE,EAAkBC,CAAAA,OAAvB,GACID,CAAkBC,CAAAA,OADtB;AAC8DC,CAA9B,IAAIT,IAAJ,CAASK,CAAT,CAA8BI,EAAAA,WAA9B,EADhC,CAGA,QAAQX,CAAR,EACI,KAAK,SAAL,CAEI,MADAS,EAAkBG,CAAAA,OACOA,EADIH,CAAkBG,CAAAA,OACtBA,EADiC,CACjCA,EADsC,CACtCA,CAAlBH,CAAkBG,CAAAA,OAC7B,MAAK,IAAL,CAEI,MADAH,EAAkBI,CAAAA,MACOA,EADGJ,CAAkBI,CAAAA,MACrBA,EAD+B,CAC/BA,EADoC,CACpCA,CAAlBJ,CAAkBI,CAAAA,MAC7B,SAEI,MADAJ,EAAkBK,CAAAA,OACOA,EADIL,CAAkBK,CAAAA,OACtBA,EADiC,CACjCA,EADsC,CACtCA,CAAlBL,CAAkBK,CAAAA,OATjC,CAV4E,CAsBhF,OAAOzD,EA/FqC,CAAZ,EAiGpCP,EAAQO,CAAAA,cAAR,CAAyBA,EAzGqC;\",\n\"sources\":[\"node_modules/@sentry/hub/dist/sessionflusher.js\"],\n\"sourcesContent\":[\"shadow$provide[420] = function(global,require,module,exports) {\\nObject.defineProperty(exports, \\\"__esModule\\\", { value: true });\\nvar utils_1 = require(\\\"@sentry/utils\\\");\\nvar flags_1 = require(\\\"./flags\\\");\\nvar hub_1 = require(\\\"./hub\\\");\\n/**\\n * @inheritdoc\\n */\\nvar SessionFlusher = /** @class */ (function () {\\n    function SessionFlusher(transport, attrs) {\\n        var _this = this;\\n        this.flushTimeout = 60;\\n        this._pendingAggregates = {};\\n        this._isEnabled = true;\\n        this._transport = transport;\\n        // Call to setInterval, so that flush is called every 60 seconds\\n        this._intervalId = setInterval(function () { return _this.flush(); }, this.flushTimeout * 1000);\\n        this._sessionAttrs = attrs;\\n    }\\n    /** Sends session aggregates to Transport */\\n    SessionFlusher.prototype.sendSessionAggregates = function (sessionAggregates) {\\n        if (!this._transport.sendSession) {\\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.warn(\\\"Dropping session because custom transport doesn't implement sendSession\\\");\\n            return;\\n        }\\n        void this._transport.sendSession(sessionAggregates).then(null, function (reason) {\\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending session:', reason);\\n        });\\n    };\\n    /** Checks if `pendingAggregates` has entries, and if it does flushes them by calling `sendSessions` */\\n    SessionFlusher.prototype.flush = function () {\\n        var sessionAggregates = this.getSessionAggregates();\\n        if (sessionAggregates.aggregates.length === 0) {\\n            return;\\n        }\\n        this._pendingAggregates = {};\\n        this.sendSessionAggregates(sessionAggregates);\\n    };\\n    /** Massages the entries in `pendingAggregates` and returns aggregated sessions */\\n    SessionFlusher.prototype.getSessionAggregates = function () {\\n        var _this = this;\\n        var aggregates = Object.keys(this._pendingAggregates).map(function (key) {\\n            return _this._pendingAggregates[parseInt(key)];\\n        });\\n        var sessionAggregates = {\\n            attrs: this._sessionAttrs,\\n            aggregates: aggregates,\\n        };\\n        return utils_1.dropUndefinedKeys(sessionAggregates);\\n    };\\n    /** JSDoc */\\n    SessionFlusher.prototype.close = function () {\\n        clearInterval(this._intervalId);\\n        this._isEnabled = false;\\n        this.flush();\\n    };\\n    /**\\n     * Wrapper function for _incrementSessionStatusCount that checks if the instance of SessionFlusher is enabled then\\n     * fetches the session status of the request from `Scope.getRequestSession().status` on the scope and passes them to\\n     * `_incrementSessionStatusCount` along with the start date\\n     */\\n    SessionFlusher.prototype.incrementSessionStatusCount = function () {\\n        if (!this._isEnabled) {\\n            return;\\n        }\\n        var scope = hub_1.getCurrentHub().getScope();\\n        var requestSession = scope && scope.getRequestSession();\\n        if (requestSession && requestSession.status) {\\n            this._incrementSessionStatusCount(requestSession.status, new Date());\\n            // This is not entirely necessarily but is added as a safe guard to indicate the bounds of a request and so in\\n            // case captureRequestSession is called more than once to prevent double count\\n            if (scope) {\\n                scope.setRequestSession(undefined);\\n            }\\n            /* eslint-enable @typescript-eslint/no-unsafe-member-access */\\n        }\\n    };\\n    /**\\n     * Increments status bucket in pendingAggregates buffer (internal state) corresponding to status of\\n     * the session received\\n     */\\n    SessionFlusher.prototype._incrementSessionStatusCount = function (status, date) {\\n        // Truncate minutes and seconds on Session Started attribute to have one minute bucket keys\\n        var sessionStartedTrunc = new Date(date).setSeconds(0, 0);\\n        this._pendingAggregates[sessionStartedTrunc] = this._pendingAggregates[sessionStartedTrunc] || {};\\n        // corresponds to aggregated sessions in one specific minute bucket\\n        // for example, {\\\"started\\\":\\\"2021-03-16T08:00:00.000Z\\\",\\\"exited\\\":4, \\\"errored\\\": 1}\\n        var aggregationCounts = this._pendingAggregates[sessionStartedTrunc];\\n        if (!aggregationCounts.started) {\\n            aggregationCounts.started = new Date(sessionStartedTrunc).toISOString();\\n        }\\n        switch (status) {\\n            case 'errored':\\n                aggregationCounts.errored = (aggregationCounts.errored || 0) + 1;\\n                return aggregationCounts.errored;\\n            case 'ok':\\n                aggregationCounts.exited = (aggregationCounts.exited || 0) + 1;\\n                return aggregationCounts.exited;\\n            default:\\n                aggregationCounts.crashed = (aggregationCounts.crashed || 0) + 1;\\n                return aggregationCounts.crashed;\\n        }\\n    };\\n    return SessionFlusher;\\n}());\\nexports.SessionFlusher = SessionFlusher;\\n//# sourceMappingURL=sessionflusher.js.map\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Object\",\"defineProperty\",\"value\",\"utils_1\",\"flags_1\",\"hub_1\",\"SessionFlusher\",\"transport\",\"attrs\",\"_this\",\"flushTimeout\",\"_pendingAggregates\",\"_isEnabled\",\"_transport\",\"_intervalId\",\"setInterval\",\"flush\",\"_sessionAttrs\",\"prototype\",\"sendSessionAggregates\",\"SessionFlusher.prototype.sendSessionAggregates\",\"sessionAggregates\",\"sendSession\",\"then\",\"reason\",\"IS_DEBUG_BUILD\",\"logger\",\"error\",\"warn\",\"SessionFlusher.prototype.flush\",\"getSessionAggregates\",\"aggregates\",\"length\",\"SessionFlusher.prototype.getSessionAggregates\",\"keys\",\"map\",\"key\",\"parseInt\",\"dropUndefinedKeys\",\"close\",\"SessionFlusher.prototype.close\",\"clearInterval\",\"incrementSessionStatusCount\",\"SessionFlusher.prototype.incrementSessionStatusCount\",\"scope\",\"getCurrentHub\",\"getScope\",\"requestSession\",\"getRequestSession\",\"status\",\"_incrementSessionStatusCount\",\"Date\",\"setRequestSession\",\"undefined\",\"SessionFlusher.prototype._incrementSessionStatusCount\",\"date\",\"sessionStartedTrunc\",\"setSeconds\",\"aggregationCounts\",\"started\",\"toISOString\",\"errored\",\"exited\",\"crashed\"]\n}\n"]