["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@sentry/hub/dist/session.js"],"~:js","shadow$provide[417]=function(ra,X,Ra,P){Object.defineProperty(P,\"__esModule\",{value:!0});var w=X(415);ra=function(){function Z(B){this.errors=0;this.sid=w.uuid4();this.duration=0;this.status=\"ok\";this.init=!0;this.ignoreDuration=!1;var p=w.timestampInSeconds();this.started=this.timestamp=p;B&&this.update(B)}Z.prototype.update=function(B){void 0===B&&(B={});B.user&&(!this.ipAddress&&B.user.ip_address&&(this.ipAddress=B.user.ip_address),this.did||B.did||(this.did=B.user.id||B.user.email||B.user.username));\nthis.timestamp=B.timestamp||w.timestampInSeconds();B.ignoreDuration&&(this.ignoreDuration=B.ignoreDuration);B.sid&&(this.sid=32===B.sid.length?B.sid:w.uuid4());void 0!==B.init&&(this.init=B.init);!this.did&&B.did&&(this.did=\"\"+B.did);\"number\"===typeof B.started&&(this.started=B.started);if(this.ignoreDuration)this.duration=void 0;else if(\"number\"===typeof B.duration)this.duration=B.duration;else{var p=this.timestamp-this.started;this.duration=0<=p?p:0}B.release&&(this.release=B.release);B.environment&&\n(this.environment=B.environment);!this.ipAddress&&B.ipAddress&&(this.ipAddress=B.ipAddress);!this.userAgent&&B.userAgent&&(this.userAgent=B.userAgent);\"number\"===typeof B.errors&&(this.errors=B.errors);B.status&&(this.status=B.status)};Z.prototype.close=function(B){B?this.update({status:B}):\"ok\"===this.status?this.update({status:\"exited\"}):this.update()};Z.prototype.toJSON=function(){return w.dropUndefinedKeys({sid:\"\"+this.sid,init:this.init,started:(new Date(1E3*this.started)).toISOString(),timestamp:(new Date(1E3*\nthis.timestamp)).toISOString(),status:this.status,errors:this.errors,did:\"number\"===typeof this.did||\"string\"===typeof this.did?\"\"+this.did:void 0,duration:this.duration,attrs:{release:this.release,environment:this.environment,ip_address:this.ipAddress,user_agent:this.userAgent}})};return Z}();P.Session=ra}","~:source","shadow$provide[417] = function(global,require,module,exports) {\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar utils_1 = require(\"@sentry/utils\");\n/**\n * @inheritdoc\n */\nvar Session = /** @class */ (function () {\n    function Session(context) {\n        this.errors = 0;\n        this.sid = utils_1.uuid4();\n        this.duration = 0;\n        this.status = 'ok';\n        this.init = true;\n        this.ignoreDuration = false;\n        // Both timestamp and started are in seconds since the UNIX epoch.\n        var startingTime = utils_1.timestampInSeconds();\n        this.timestamp = startingTime;\n        this.started = startingTime;\n        if (context) {\n            this.update(context);\n        }\n    }\n    /** JSDoc */\n    // eslint-disable-next-line complexity\n    Session.prototype.update = function (context) {\n        if (context === void 0) { context = {}; }\n        if (context.user) {\n            if (!this.ipAddress && context.user.ip_address) {\n                this.ipAddress = context.user.ip_address;\n            }\n            if (!this.did && !context.did) {\n                this.did = context.user.id || context.user.email || context.user.username;\n            }\n        }\n        this.timestamp = context.timestamp || utils_1.timestampInSeconds();\n        if (context.ignoreDuration) {\n            this.ignoreDuration = context.ignoreDuration;\n        }\n        if (context.sid) {\n            // Good enough uuid validation. — Kamil\n            this.sid = context.sid.length === 32 ? context.sid : utils_1.uuid4();\n        }\n        if (context.init !== undefined) {\n            this.init = context.init;\n        }\n        if (!this.did && context.did) {\n            this.did = \"\" + context.did;\n        }\n        if (typeof context.started === 'number') {\n            this.started = context.started;\n        }\n        if (this.ignoreDuration) {\n            this.duration = undefined;\n        }\n        else if (typeof context.duration === 'number') {\n            this.duration = context.duration;\n        }\n        else {\n            var duration = this.timestamp - this.started;\n            this.duration = duration >= 0 ? duration : 0;\n        }\n        if (context.release) {\n            this.release = context.release;\n        }\n        if (context.environment) {\n            this.environment = context.environment;\n        }\n        if (!this.ipAddress && context.ipAddress) {\n            this.ipAddress = context.ipAddress;\n        }\n        if (!this.userAgent && context.userAgent) {\n            this.userAgent = context.userAgent;\n        }\n        if (typeof context.errors === 'number') {\n            this.errors = context.errors;\n        }\n        if (context.status) {\n            this.status = context.status;\n        }\n    };\n    /** JSDoc */\n    Session.prototype.close = function (status) {\n        if (status) {\n            this.update({ status: status });\n        }\n        else if (this.status === 'ok') {\n            this.update({ status: 'exited' });\n        }\n        else {\n            this.update();\n        }\n    };\n    /** JSDoc */\n    Session.prototype.toJSON = function () {\n        return utils_1.dropUndefinedKeys({\n            sid: \"\" + this.sid,\n            init: this.init,\n            // Make sure that sec is converted to ms for date constructor\n            started: new Date(this.started * 1000).toISOString(),\n            timestamp: new Date(this.timestamp * 1000).toISOString(),\n            status: this.status,\n            errors: this.errors,\n            did: typeof this.did === 'number' || typeof this.did === 'string' ? \"\" + this.did : undefined,\n            duration: this.duration,\n            attrs: {\n                release: this.release,\n                environment: this.environment,\n                ip_address: this.ipAddress,\n                user_agent: this.userAgent,\n            },\n        });\n    };\n    return Session;\n}());\nexports.Session = Session;\n//# sourceMappingURL=session.js.map\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$$sentry$utils$dist$index"]],"~:properties",["^5",["release","userAgent","attrs","started","ignoreDuration","__esModule","timestamp","errors","update","did","value","status","close","duration","environment","init","ip_address","Session","user_agent","ipAddress","toJSON","sid"]],"~:compiled-at",1766065009696,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$sentry$hub$dist$session.js\",\n\"lineCount\":4,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAC9DC,MAAOC,CAAAA,cAAP,CAAsBF,CAAtB,CAA+B,YAA/B,CAA6C,CAAEG,MAAO,CAAA,CAAT,CAA7C,CACA,KAAIC,EAAUN,CAAA,CAAQ,GAAR,CAIVO,GAAAA,CAAyB,QAAS,EAAG,CACrCA,QAASA,EAAO,CAACC,CAAD,CAAU,CACtB,IAAKC,CAAAA,MAAL,CAAc,CACd,KAAKC,CAAAA,GAAL,CAAWJ,CAAQK,CAAAA,KAAR,EACX,KAAKC,CAAAA,QAAL,CAAgB,CAChB,KAAKC,CAAAA,MAAL,CAAc,IACd,KAAKC,CAAAA,IAAL,CAAY,CAAA,CACZ,KAAKC,CAAAA,cAAL,CAAsB,CAAA,CAEtB,KAAIC,EAAeV,CAAQW,CAAAA,kBAAR,EAEnB,KAAKC,CAAAA,OAAL,CADA,IAAKC,CAAAA,SACL,CADiBH,CAEbR,EAAJ,EACI,IAAKY,CAAAA,MAAL,CAAYZ,CAAZ,CAZkB,CAiB1BD,CAAQc,CAAAA,SAAUD,CAAAA,MAAlB,CAA2BE,QAAS,CAACd,CAAD,CAAU,CAC1B,IAAK,EAArB,GAAIA,CAAJ,GAA0BA,CAA1B,CAAoC,EAApC,CACIA,EAAQe,CAAAA,IAAZ,GACQ,CAAC,IAAKC,CAAAA,SAGV,EAHuBhB,CAAQe,CAAAA,IAAKE,CAAAA,UAGpC,GAFI,IAAKD,CAAAA,SAET,CAFqBhB,CAAQe,CAAAA,IAAKE,CAAAA,UAElC,EAAK,IAAKC,CAAAA,GAAV,EAAkBlB,CAAQkB,CAAAA,GAA1B,GACI,IAAKA,CAAAA,GADT,CACelB,CAAQe,CAAAA,IAAKI,CAAAA,EAD5B,EACkCnB,CAAQe,CAAAA,IAAKK,CAAAA,KAD/C,EACwDpB,CAAQe,CAAAA,IAAKM,CAAAA,QADrE,CAJJ,CAQA;IAAKV,CAAAA,SAAL,CAAiBX,CAAQW,CAAAA,SAAzB,EAAsCb,CAAQW,CAAAA,kBAAR,EAClCT,EAAQO,CAAAA,cAAZ,GACI,IAAKA,CAAAA,cADT,CAC0BP,CAAQO,CAAAA,cADlC,CAGIP,EAAQE,CAAAA,GAAZ,GAEI,IAAKA,CAAAA,GAFT,CAEsC,EAAvB,GAAAF,CAAQE,CAAAA,GAAIoB,CAAAA,MAAZ,CAA4BtB,CAAQE,CAAAA,GAApC,CAA0CJ,CAAQK,CAAAA,KAAR,EAFzD,CAIqBoB,KAAAA,EAArB,GAAIvB,CAAQM,CAAAA,IAAZ,GACI,IAAKA,CAAAA,IADT,CACgBN,CAAQM,CAAAA,IADxB,CAGI,EAAC,IAAKY,CAAAA,GAAV,EAAiBlB,CAAQkB,CAAAA,GAAzB,GACI,IAAKA,CAAAA,GADT,CACe,EADf,CACoBlB,CAAQkB,CAAAA,GAD5B,CAG+B,SAA/B,GAAI,MAAOlB,EAAQU,CAAAA,OAAnB,GACI,IAAKA,CAAAA,OADT,CACmBV,CAAQU,CAAAA,OAD3B,CAGA,IAAI,IAAKH,CAAAA,cAAT,CACI,IAAKH,CAAAA,QAAL,CAAgBmB,IAAAA,EADpB,KAGK,IAAgC,QAAhC,GAAI,MAAOvB,EAAQI,CAAAA,QAAnB,CACD,IAAKA,CAAAA,QAAL,CAAgBJ,CAAQI,CAAAA,QADvB,KAGA,CACD,IAAIA,EAAW,IAAKO,CAAAA,SAAhBP,CAA4B,IAAKM,CAAAA,OACrC,KAAKN,CAAAA,QAAL,CAA4B,CAAZ,EAAAA,CAAA,CAAgBA,CAAhB,CAA2B,CAF1C,CAIDJ,CAAQwB,CAAAA,OAAZ,GACI,IAAKA,CAAAA,OADT,CACmBxB,CAAQwB,CAAAA,OAD3B,CAGIxB,EAAQyB,CAAAA,WAAZ;CACI,IAAKA,CAAAA,WADT,CACuBzB,CAAQyB,CAAAA,WAD/B,CAGI,EAAC,IAAKT,CAAAA,SAAV,EAAuBhB,CAAQgB,CAAAA,SAA/B,GACI,IAAKA,CAAAA,SADT,CACqBhB,CAAQgB,CAAAA,SAD7B,CAGI,EAAC,IAAKU,CAAAA,SAAV,EAAuB1B,CAAQ0B,CAAAA,SAA/B,GACI,IAAKA,CAAAA,SADT,CACqB1B,CAAQ0B,CAAAA,SAD7B,CAG8B,SAA9B,GAAI,MAAO1B,EAAQC,CAAAA,MAAnB,GACI,IAAKA,CAAAA,MADT,CACkBD,CAAQC,CAAAA,MAD1B,CAGID,EAAQK,CAAAA,MAAZ,GACI,IAAKA,CAAAA,MADT,CACkBL,CAAQK,CAAAA,MAD1B,CApD0C,CAyD9CN,EAAQc,CAAAA,SAAUc,CAAAA,KAAlB,CAA0BC,QAAS,CAACvB,CAAD,CAAS,CACpCA,CAAJ,CACI,IAAKO,CAAAA,MAAL,CAAY,CAAEP,OAAQA,CAAV,CAAZ,CADJ,CAGyB,IAApB,GAAI,IAAKA,CAAAA,MAAT,CACD,IAAKO,CAAAA,MAAL,CAAY,CAAEP,OAAQ,QAAV,CAAZ,CADC,CAID,IAAKO,CAAAA,MAAL,EARoC,CAY5Cb,EAAQc,CAAAA,SAAUgB,CAAAA,MAAlB,CAA2BC,QAAS,EAAG,CACnC,MAAOhC,EAAQiC,CAAAA,iBAAR,CAA0B,CAC7B7B,IAAK,EAALA,CAAU,IAAKA,CAAAA,GADc,CAE7BI,KAAM,IAAKA,CAAAA,IAFkB,CAI7BI,QAAuCsB,CAA9B,IAAIC,IAAJ,CAAwB,GAAxB,CAAS,IAAKvB,CAAAA,OAAd,CAA8BsB,EAAAA,WAA9B,EAJoB,CAK7BrB,UAA2CqB,CAAhC,IAAIC,IAAJ,CAA0B,GAA1B;AAAS,IAAKtB,CAAAA,SAAd,CAAgCqB,EAAAA,WAAhC,EALkB,CAM7B3B,OAAQ,IAAKA,CAAAA,MANgB,CAO7BJ,OAAQ,IAAKA,CAAAA,MAPgB,CAQ7BiB,IAAyB,QAApB,GAAA,MAAO,KAAKA,CAAAA,GAAZ,EAAoD,QAApD,GAAgC,MAAO,KAAKA,CAAAA,GAA5C,CAA+D,EAA/D,CAAoE,IAAKA,CAAAA,GAAzE,CAA+EK,IAAAA,EARvD,CAS7BnB,SAAU,IAAKA,CAAAA,QATc,CAU7B8B,MAAO,CACHV,QAAS,IAAKA,CAAAA,OADX,CAEHC,YAAa,IAAKA,CAAAA,WAFf,CAGHR,WAAY,IAAKD,CAAAA,SAHd,CAIHmB,WAAY,IAAKT,CAAAA,SAJd,CAVsB,CAA1B,CAD4B,CAmBvC,OAAO3B,EA1G8B,CAAZ,EA4G7BL,EAAQK,CAAAA,OAAR,CAAkBA,EAlH4C;\",\n\"sources\":[\"node_modules/@sentry/hub/dist/session.js\"],\n\"sourcesContent\":[\"shadow$provide[417] = function(global,require,module,exports) {\\nObject.defineProperty(exports, \\\"__esModule\\\", { value: true });\\nvar utils_1 = require(\\\"@sentry/utils\\\");\\n/**\\n * @inheritdoc\\n */\\nvar Session = /** @class */ (function () {\\n    function Session(context) {\\n        this.errors = 0;\\n        this.sid = utils_1.uuid4();\\n        this.duration = 0;\\n        this.status = 'ok';\\n        this.init = true;\\n        this.ignoreDuration = false;\\n        // Both timestamp and started are in seconds since the UNIX epoch.\\n        var startingTime = utils_1.timestampInSeconds();\\n        this.timestamp = startingTime;\\n        this.started = startingTime;\\n        if (context) {\\n            this.update(context);\\n        }\\n    }\\n    /** JSDoc */\\n    // eslint-disable-next-line complexity\\n    Session.prototype.update = function (context) {\\n        if (context === void 0) { context = {}; }\\n        if (context.user) {\\n            if (!this.ipAddress && context.user.ip_address) {\\n                this.ipAddress = context.user.ip_address;\\n            }\\n            if (!this.did && !context.did) {\\n                this.did = context.user.id || context.user.email || context.user.username;\\n            }\\n        }\\n        this.timestamp = context.timestamp || utils_1.timestampInSeconds();\\n        if (context.ignoreDuration) {\\n            this.ignoreDuration = context.ignoreDuration;\\n        }\\n        if (context.sid) {\\n            // Good enough uuid validation. \\u2014 Kamil\\n            this.sid = context.sid.length === 32 ? context.sid : utils_1.uuid4();\\n        }\\n        if (context.init !== undefined) {\\n            this.init = context.init;\\n        }\\n        if (!this.did && context.did) {\\n            this.did = \\\"\\\" + context.did;\\n        }\\n        if (typeof context.started === 'number') {\\n            this.started = context.started;\\n        }\\n        if (this.ignoreDuration) {\\n            this.duration = undefined;\\n        }\\n        else if (typeof context.duration === 'number') {\\n            this.duration = context.duration;\\n        }\\n        else {\\n            var duration = this.timestamp - this.started;\\n            this.duration = duration >= 0 ? duration : 0;\\n        }\\n        if (context.release) {\\n            this.release = context.release;\\n        }\\n        if (context.environment) {\\n            this.environment = context.environment;\\n        }\\n        if (!this.ipAddress && context.ipAddress) {\\n            this.ipAddress = context.ipAddress;\\n        }\\n        if (!this.userAgent && context.userAgent) {\\n            this.userAgent = context.userAgent;\\n        }\\n        if (typeof context.errors === 'number') {\\n            this.errors = context.errors;\\n        }\\n        if (context.status) {\\n            this.status = context.status;\\n        }\\n    };\\n    /** JSDoc */\\n    Session.prototype.close = function (status) {\\n        if (status) {\\n            this.update({ status: status });\\n        }\\n        else if (this.status === 'ok') {\\n            this.update({ status: 'exited' });\\n        }\\n        else {\\n            this.update();\\n        }\\n    };\\n    /** JSDoc */\\n    Session.prototype.toJSON = function () {\\n        return utils_1.dropUndefinedKeys({\\n            sid: \\\"\\\" + this.sid,\\n            init: this.init,\\n            // Make sure that sec is converted to ms for date constructor\\n            started: new Date(this.started * 1000).toISOString(),\\n            timestamp: new Date(this.timestamp * 1000).toISOString(),\\n            status: this.status,\\n            errors: this.errors,\\n            did: typeof this.did === 'number' || typeof this.did === 'string' ? \\\"\\\" + this.did : undefined,\\n            duration: this.duration,\\n            attrs: {\\n                release: this.release,\\n                environment: this.environment,\\n                ip_address: this.ipAddress,\\n                user_agent: this.userAgent,\\n            },\\n        });\\n    };\\n    return Session;\\n}());\\nexports.Session = Session;\\n//# sourceMappingURL=session.js.map\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Object\",\"defineProperty\",\"value\",\"utils_1\",\"Session\",\"context\",\"errors\",\"sid\",\"uuid4\",\"duration\",\"status\",\"init\",\"ignoreDuration\",\"startingTime\",\"timestampInSeconds\",\"started\",\"timestamp\",\"update\",\"prototype\",\"Session.prototype.update\",\"user\",\"ipAddress\",\"ip_address\",\"did\",\"id\",\"email\",\"username\",\"length\",\"undefined\",\"release\",\"environment\",\"userAgent\",\"close\",\"Session.prototype.close\",\"toJSON\",\"Session.prototype.toJSON\",\"dropUndefinedKeys\",\"toISOString\",\"Date\",\"attrs\",\"user_agent\"]\n}\n"]