["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@sentry/core/dist/basebackend.js"],"~:js","shadow$provide[430]=function(ra,X,Ra,P){Object.defineProperty(P,\"__esModule\",{value:!0});var w=X(424),Z=X(415),B=X(423),p=X(425),c=X(428),u=X(429);ra=function(){function A(y){this._options=y;this._options.dsn||p.IS_DEBUG_BUILD&&Z.logger.warn(\"No DSN provided, backend will not do anything.\");this._transport=this._setupTransport()}A.prototype.eventFromException=function(y,x){throw new Z.SentryError(\"Backend has to implement `eventFromException` method\");};A.prototype.eventFromMessage=function(y,x,Q){throw new Z.SentryError(\"Backend has to implement `eventFromMessage` method\");\n};A.prototype.sendEvent=function(y){if(this._newTransport&&this._options.dsn&&this._options._experiments&&this._options._experiments.newTransport){var x=B.initAPIDetails(this._options.dsn,this._options._metadata,this._options.tunnel);y=c.createEventEnvelope(y,x);void this._newTransport.send(y).then(null,function(Q){p.IS_DEBUG_BUILD&&Z.logger.error(\"Error while sending event:\",Q)})}else void this._transport.sendEvent(y).then(null,function(Q){p.IS_DEBUG_BUILD&&Z.logger.error(\"Error while sending event:\",\nQ)})};A.prototype.sendSession=function(y){if(this._transport.sendSession)if(this._newTransport&&this._options.dsn&&this._options._experiments&&this._options._experiments.newTransport){var x=B.initAPIDetails(this._options.dsn,this._options._metadata,this._options.tunnel);y=w.__read(c.createSessionEnvelope(y,x),1)[0];void this._newTransport.send(y).then(null,function(Q){p.IS_DEBUG_BUILD&&Z.logger.error(\"Error while sending session:\",Q)})}else void this._transport.sendSession(y).then(null,function(Q){p.IS_DEBUG_BUILD&&\nZ.logger.error(\"Error while sending session:\",Q)});else p.IS_DEBUG_BUILD&&Z.logger.warn(\"Dropping session because custom transport doesn't implement sendSession\")};A.prototype.getTransport=function(){return this._transport};A.prototype._setupTransport=function(){return new u.NoopTransport};return A}();P.BaseBackend=ra}","~:source","shadow$provide[430] = function(global,require,module,exports) {\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar tslib_1 = require(\"tslib\");\nvar utils_1 = require(\"@sentry/utils\");\nvar api_1 = require(\"./api\");\nvar flags_1 = require(\"./flags\");\nvar request_1 = require(\"./request\");\nvar noop_1 = require(\"./transports/noop\");\n/**\n * This is the base implemention of a Backend.\n * @hidden\n */\nvar BaseBackend = /** @class */ (function () {\n    /** Creates a new backend instance. */\n    function BaseBackend(options) {\n        this._options = options;\n        if (!this._options.dsn) {\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.warn('No DSN provided, backend will not do anything.');\n        }\n        this._transport = this._setupTransport();\n    }\n    /**\n     * @inheritDoc\n     */\n    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types\n    BaseBackend.prototype.eventFromException = function (_exception, _hint) {\n        throw new utils_1.SentryError('Backend has to implement `eventFromException` method');\n    };\n    /**\n     * @inheritDoc\n     */\n    BaseBackend.prototype.eventFromMessage = function (_message, _level, _hint) {\n        throw new utils_1.SentryError('Backend has to implement `eventFromMessage` method');\n    };\n    /**\n     * @inheritDoc\n     */\n    BaseBackend.prototype.sendEvent = function (event) {\n        // TODO(v7): Remove the if-else\n        if (this._newTransport &&\n            this._options.dsn &&\n            this._options._experiments &&\n            this._options._experiments.newTransport) {\n            var api = api_1.initAPIDetails(this._options.dsn, this._options._metadata, this._options.tunnel);\n            var env = request_1.createEventEnvelope(event, api);\n            void this._newTransport.send(env).then(null, function (reason) {\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending event:', reason);\n            });\n        }\n        else {\n            void this._transport.sendEvent(event).then(null, function (reason) {\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending event:', reason);\n            });\n        }\n    };\n    /**\n     * @inheritDoc\n     */\n    BaseBackend.prototype.sendSession = function (session) {\n        if (!this._transport.sendSession) {\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.warn(\"Dropping session because custom transport doesn't implement sendSession\");\n            return;\n        }\n        // TODO(v7): Remove the if-else\n        if (this._newTransport &&\n            this._options.dsn &&\n            this._options._experiments &&\n            this._options._experiments.newTransport) {\n            var api = api_1.initAPIDetails(this._options.dsn, this._options._metadata, this._options.tunnel);\n            var _a = tslib_1.__read(request_1.createSessionEnvelope(session, api), 1), env = _a[0];\n            void this._newTransport.send(env).then(null, function (reason) {\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending session:', reason);\n            });\n        }\n        else {\n            void this._transport.sendSession(session).then(null, function (reason) {\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending session:', reason);\n            });\n        }\n    };\n    /**\n     * @inheritDoc\n     */\n    BaseBackend.prototype.getTransport = function () {\n        return this._transport;\n    };\n    /**\n     * Sets up the transport so it can be used later to send requests.\n     */\n    BaseBackend.prototype._setupTransport = function () {\n        return new noop_1.NoopTransport();\n    };\n    return BaseBackend;\n}());\nexports.BaseBackend = BaseBackend;\n//# sourceMappingURL=basebackend.js.map\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$$sentry$utils$dist$index","~$module$node_modules$$sentry$core$dist$flags","~$module$node_modules$$sentry$core$dist$request","~$module$node_modules$$sentry$core$node_modules$tslib$tslib","~$module$node_modules$$sentry$core$dist$api","~$module$node_modules$$sentry$core$dist$transports$noop"]],"~:properties",["^5",["eventFromMessage","__esModule","sendEvent","sendSession","value","_setupTransport","getTransport","BaseBackend","eventFromException","_options","_transport"]],"~:compiled-at",1766065009698,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$sentry$core$dist$basebackend.js\",\n\"lineCount\":4,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAC9DC,MAAOC,CAAAA,cAAP,CAAsBF,CAAtB,CAA+B,YAA/B,CAA6C,CAAEG,MAAO,CAAA,CAAT,CAA7C,CACA,KAAIC,EAAUN,CAAA,CAAQ,GAAR,CAAd,CACIO,EAAUP,CAAA,CAAQ,GAAR,CADd,CAEIQ,EAAQR,CAAA,CAAQ,GAAR,CAFZ,CAGIS,EAAUT,CAAA,CAAQ,GAAR,CAHd,CAIIU,EAAYV,CAAA,CAAQ,GAAR,CAJhB,CAKIW,EAASX,CAAA,CAAQ,GAAR,CAKTY,GAAAA,CAA6B,QAAS,EAAG,CAEzCA,QAASA,EAAW,CAACC,CAAD,CAAU,CAC1B,IAAKC,CAAAA,QAAL,CAAgBD,CACX,KAAKC,CAAAA,QAASC,CAAAA,GAAnB,EACIN,CAAQO,CAAAA,cADZ,EAC8BT,CAAQU,CAAAA,MAAOC,CAAAA,IAAf,CAAoB,gDAApB,CAE9B,KAAKC,CAAAA,UAAL,CAAkB,IAAKC,CAAAA,eAAL,EALQ,CAW9BR,CAAYS,CAAAA,SAAUC,CAAAA,kBAAtB,CAA2CC,QAAS,CAACC,CAAD,CAAaC,CAAb,CAAoB,CACpE,KAAM,KAAIlB,CAAQmB,CAAAA,WAAZ,CAAwB,sDAAxB,CAAN,CADoE,CAMxEd,EAAYS,CAAAA,SAAUM,CAAAA,gBAAtB,CAAyCC,QAAS,CAACC,CAAD,CAAWC,CAAX,CAAmBL,CAAnB,CAA0B,CACxE,KAAM,KAAIlB,CAAQmB,CAAAA,WAAZ,CAAwB,oDAAxB,CAAN;AADwE,CAM5Ed,EAAYS,CAAAA,SAAUU,CAAAA,SAAtB,CAAkCC,QAAS,CAACC,CAAD,CAAQ,CAE/C,GAAI,IAAKC,CAAAA,aAAT,EACI,IAAKpB,CAAAA,QAASC,CAAAA,GADlB,EAEI,IAAKD,CAAAA,QAASqB,CAAAA,YAFlB,EAGI,IAAKrB,CAAAA,QAASqB,CAAAA,YAAaC,CAAAA,YAH/B,CAG6C,CACzC,IAAIC,EAAM7B,CAAM8B,CAAAA,cAAN,CAAqB,IAAKxB,CAAAA,QAASC,CAAAA,GAAnC,CAAwC,IAAKD,CAAAA,QAASyB,CAAAA,SAAtD,CAAiE,IAAKzB,CAAAA,QAAS0B,CAAAA,MAA/E,CACNC,EAAAA,CAAM/B,CAAUgC,CAAAA,mBAAV,CAA8BT,CAA9B,CAAqCI,CAArC,CACV,KAAK,KAAKH,CAAAA,aAAcS,CAAAA,IAAnB,CAAwBF,CAAxB,CAA6BG,CAAAA,IAA7B,CAAkC,IAAlC,CAAwC,QAAS,CAACC,CAAD,CAAS,CAC3DpC,CAAQO,CAAAA,cAAR,EAA0BT,CAAQU,CAAAA,MAAO6B,CAAAA,KAAf,CAAqB,4BAArB,CAAmDD,CAAnD,CADiC,CAA1D,CAHoC,CAH7C,IAWI,KAAK,KAAK1B,CAAAA,UAAWY,CAAAA,SAAhB,CAA0BE,CAA1B,CAAiCW,CAAAA,IAAjC,CAAsC,IAAtC,CAA4C,QAAS,CAACC,CAAD,CAAS,CAC/DpC,CAAQO,CAAAA,cAAR,EAA0BT,CAAQU,CAAAA,MAAO6B,CAAAA,KAAf,CAAqB,4BAArB;AAAmDD,CAAnD,CADqC,CAA9D,CAbsC,CAqBnDjC,EAAYS,CAAAA,SAAU0B,CAAAA,WAAtB,CAAoCC,QAAS,CAACC,CAAD,CAAU,CACnD,GAAK,IAAK9B,CAAAA,UAAW4B,CAAAA,WAArB,CAKA,GAAI,IAAKb,CAAAA,aAAT,EACI,IAAKpB,CAAAA,QAASC,CAAAA,GADlB,EAEI,IAAKD,CAAAA,QAASqB,CAAAA,YAFlB,EAGI,IAAKrB,CAAAA,QAASqB,CAAAA,YAAaC,CAAAA,YAH/B,CAG6C,CACzC,IAAIC,EAAM7B,CAAM8B,CAAAA,cAAN,CAAqB,IAAKxB,CAAAA,QAASC,CAAAA,GAAnC,CAAwC,IAAKD,CAAAA,QAASyB,CAAAA,SAAtD,CAAiE,IAAKzB,CAAAA,QAAS0B,CAAAA,MAA/E,CACiEC,EAAAA,CAAlEnC,CAAQ4C,CAAAA,MAARC,CAAezC,CAAU0C,CAAAA,qBAAV,CAAgCH,CAAhC,CAAyCZ,CAAzC,CAAfc,CAA8D,CAA9DA,CAAwE,CAAG,CAAH,CACjF,KAAK,KAAKjB,CAAAA,aAAcS,CAAAA,IAAnB,CAAwBF,CAAxB,CAA6BG,CAAAA,IAA7B,CAAkC,IAAlC,CAAwC,QAAS,CAACC,CAAD,CAAS,CAC3DpC,CAAQO,CAAAA,cAAR,EAA0BT,CAAQU,CAAAA,MAAO6B,CAAAA,KAAf,CAAqB,8BAArB,CAAqDD,CAArD,CADiC,CAA1D,CAHoC,CAH7C,IAWI,KAAK,KAAK1B,CAAAA,UAAW4B,CAAAA,WAAhB,CAA4BE,CAA5B,CAAqCL,CAAAA,IAArC,CAA0C,IAA1C,CAAgD,QAAS,CAACC,CAAD,CAAS,CACnEpC,CAAQO,CAAAA,cAAR;AAA0BT,CAAQU,CAAAA,MAAO6B,CAAAA,KAAf,CAAqB,8BAArB,CAAqDD,CAArD,CADyC,CAAlE,CAhBT,KACIpC,EAAQO,CAAAA,cAAR,EAA0BT,CAAQU,CAAAA,MAAOC,CAAAA,IAAf,CAAoB,yEAApB,CAFqB,CAyBvDN,EAAYS,CAAAA,SAAUgC,CAAAA,YAAtB,CAAqCC,QAAS,EAAG,CAC7C,MAAO,KAAKnC,CAAAA,UADiC,CAMjDP,EAAYS,CAAAA,SAAUD,CAAAA,eAAtB,CAAwCmC,QAAS,EAAG,CAChD,MAAO,KAAI5C,CAAO6C,CAAAA,aAD8B,CAGpD,OAAO5C,EAhFkC,CAAZ,EAkFjCV,EAAQU,CAAAA,WAAR,CAAsBA,EA9FwC;\",\n\"sources\":[\"node_modules/@sentry/core/dist/basebackend.js\"],\n\"sourcesContent\":[\"shadow$provide[430] = function(global,require,module,exports) {\\nObject.defineProperty(exports, \\\"__esModule\\\", { value: true });\\nvar tslib_1 = require(\\\"tslib\\\");\\nvar utils_1 = require(\\\"@sentry/utils\\\");\\nvar api_1 = require(\\\"./api\\\");\\nvar flags_1 = require(\\\"./flags\\\");\\nvar request_1 = require(\\\"./request\\\");\\nvar noop_1 = require(\\\"./transports/noop\\\");\\n/**\\n * This is the base implemention of a Backend.\\n * @hidden\\n */\\nvar BaseBackend = /** @class */ (function () {\\n    /** Creates a new backend instance. */\\n    function BaseBackend(options) {\\n        this._options = options;\\n        if (!this._options.dsn) {\\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.warn('No DSN provided, backend will not do anything.');\\n        }\\n        this._transport = this._setupTransport();\\n    }\\n    /**\\n     * @inheritDoc\\n     */\\n    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types\\n    BaseBackend.prototype.eventFromException = function (_exception, _hint) {\\n        throw new utils_1.SentryError('Backend has to implement `eventFromException` method');\\n    };\\n    /**\\n     * @inheritDoc\\n     */\\n    BaseBackend.prototype.eventFromMessage = function (_message, _level, _hint) {\\n        throw new utils_1.SentryError('Backend has to implement `eventFromMessage` method');\\n    };\\n    /**\\n     * @inheritDoc\\n     */\\n    BaseBackend.prototype.sendEvent = function (event) {\\n        // TODO(v7): Remove the if-else\\n        if (this._newTransport &&\\n            this._options.dsn &&\\n            this._options._experiments &&\\n            this._options._experiments.newTransport) {\\n            var api = api_1.initAPIDetails(this._options.dsn, this._options._metadata, this._options.tunnel);\\n            var env = request_1.createEventEnvelope(event, api);\\n            void this._newTransport.send(env).then(null, function (reason) {\\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending event:', reason);\\n            });\\n        }\\n        else {\\n            void this._transport.sendEvent(event).then(null, function (reason) {\\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending event:', reason);\\n            });\\n        }\\n    };\\n    /**\\n     * @inheritDoc\\n     */\\n    BaseBackend.prototype.sendSession = function (session) {\\n        if (!this._transport.sendSession) {\\n            flags_1.IS_DEBUG_BUILD && utils_1.logger.warn(\\\"Dropping session because custom transport doesn't implement sendSession\\\");\\n            return;\\n        }\\n        // TODO(v7): Remove the if-else\\n        if (this._newTransport &&\\n            this._options.dsn &&\\n            this._options._experiments &&\\n            this._options._experiments.newTransport) {\\n            var api = api_1.initAPIDetails(this._options.dsn, this._options._metadata, this._options.tunnel);\\n            var _a = tslib_1.__read(request_1.createSessionEnvelope(session, api), 1), env = _a[0];\\n            void this._newTransport.send(env).then(null, function (reason) {\\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending session:', reason);\\n            });\\n        }\\n        else {\\n            void this._transport.sendSession(session).then(null, function (reason) {\\n                flags_1.IS_DEBUG_BUILD && utils_1.logger.error('Error while sending session:', reason);\\n            });\\n        }\\n    };\\n    /**\\n     * @inheritDoc\\n     */\\n    BaseBackend.prototype.getTransport = function () {\\n        return this._transport;\\n    };\\n    /**\\n     * Sets up the transport so it can be used later to send requests.\\n     */\\n    BaseBackend.prototype._setupTransport = function () {\\n        return new noop_1.NoopTransport();\\n    };\\n    return BaseBackend;\\n}());\\nexports.BaseBackend = BaseBackend;\\n//# sourceMappingURL=basebackend.js.map\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Object\",\"defineProperty\",\"value\",\"tslib_1\",\"utils_1\",\"api_1\",\"flags_1\",\"request_1\",\"noop_1\",\"BaseBackend\",\"options\",\"_options\",\"dsn\",\"IS_DEBUG_BUILD\",\"logger\",\"warn\",\"_transport\",\"_setupTransport\",\"prototype\",\"eventFromException\",\"BaseBackend.prototype.eventFromException\",\"_exception\",\"_hint\",\"SentryError\",\"eventFromMessage\",\"BaseBackend.prototype.eventFromMessage\",\"_message\",\"_level\",\"sendEvent\",\"BaseBackend.prototype.sendEvent\",\"event\",\"_newTransport\",\"_experiments\",\"newTransport\",\"api\",\"initAPIDetails\",\"_metadata\",\"tunnel\",\"env\",\"createEventEnvelope\",\"send\",\"then\",\"reason\",\"error\",\"sendSession\",\"BaseBackend.prototype.sendSession\",\"session\",\"__read\",\"_a\",\"createSessionEnvelope\",\"getTransport\",\"BaseBackend.prototype.getTransport\",\"BaseBackend.prototype._setupTransport\",\"NoopTransport\"]\n}\n"]