["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@pixi-essentials/cull/lib/cull.js"],"~:js","shadow$provide[368]=function(ra,X,Ra,P){Object.defineProperty(P,\"__esModule\",{value:!0});const w=new (X(357).Rectangle);class Z{constructor(B={}){this._recursive=\"boolean\"===typeof B.recursive?B.recursive:!0;this._toggle=B.toggle||\"visible\";this._targetList=new Set}add(B){this._targetList.add(B);return this}addAll(B){for(let p=0,c=B.length;p<c;p++)this._targetList.add(B[p]);return this}remove(B){this._targetList.delete(B);return this}removeAll(B){for(let p=0,c=B.length;p<c;p++)this._targetList.delete(B[p]);\nreturn this}clear(){this._targetList.clear();return this}cull(B,p=!1){p||this.uncull();this._targetList.forEach(c=>{p||c.getBounds(!1,w);this._recursive?this.cullRecursive(B,c,p):(p&&c._bounds.getRectangle(B),c[this._toggle]=w.right>B.left&&w.left<B.right&&w.bottom>B.top&&w.top<B.bottom)});return this}uncull(){this._targetList.forEach(B=>{this._recursive?this.uncullRecursive(B):B[this._toggle]=!1});return this}cullRecursive(B,p,c){c=c?p._bounds.getRectangle(w):p.getBounds(!0,w);p[this._toggle]=c.right>\nB.left&&c.left<B.right&&c.bottom>B.top&&c.top<B.bottom;if(!(c.left>=B.left&&c.top>=B.top&&c.right<=B.right&&c.bottom<=B.bottom)&&p[this._toggle]&&p.children&&p.children.length){p=p.children;for(let u=0,A=p.length;u<A;u++)this.cullRecursive(B,p[u])}}uncullRecursive(B){B[this._toggle]=!0;if(B.children&&B.children.length){B=B.children;for(let p=0,c=B.length;p<c;p++)this.uncullRecursive(B[p])}}}P.Cull=Z}","~:source","shadow$provide[368] = function(global,require,module,exports) {\n/* eslint-disable */\n \n/*!\n * @pixi-essentials/cull - v1.0.12\n * Compiled Wed, 17 Mar 2021 16:10:19 UTC\n *\n * @pixi-essentials/cull is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n * \n * Copyright 2019-2020, Shukant Pal <shukantpal@outlook.com>, All Rights Reserved\n */\n'use strict';\n\nObject.defineProperty(exports, '__esModule', { value: true });\n\nvar math = require('@pixi/math');\n\nconst tempRect = new math.Rectangle();\n\n/**\n * The culling options for {@code Cull}.\n *\n * @ignore\n * @public\n */\n\n\n\n\n\n\n/**\n * Provides a simple, configurable mechanism for culling a subtree of your scene graph.\n *\n * If your scene graph is not static, culling needs to be done before rendering. You\n * can run it on the `prerender` event fired by the renderer.\n *\n * @public\n */\nclass Cull\n{\n    \n    \n    \n\n    /**\n     * @param options\n     * @param [options.recursive] - whether culling should be recursive\n     * @param [options.toggle='renderable'] - which property of display-object was be set to indicate\n     *      its culling state. It should be one of `renderable`, `visible`.\n     */\n    constructor(options = {})\n    {\n        this._recursive = typeof options.recursive === 'boolean' ? options.recursive : true;\n        this._toggle = options.toggle || 'visible';\n        this._targetList = new Set();\n    }\n\n    /**\n     * Adds a display-object to the culling list\n     *\n     * @param target - the display-object to be culled\n     * @return this\n     */\n    add(target)\n    {\n        this._targetList.add(target);\n\n        return this;\n    }\n\n    /**\n     * Adds all the display-objects to the culling list\n     *\n     * @param targets - the display-objects to be culled\n     * @return this\n     */\n    addAll(targets)\n    {\n        for (let i = 0, j = targets.length; i < j; i++)\n        {\n            this._targetList.add(targets[i]);\n        }\n\n        return this;\n    }\n\n    /**\n     * Removes the display-object from the culling list\n     *\n     * @param target - the display-object to be removed\n     * @return this\n     */\n    remove(target)\n    {\n        this._targetList.delete(target);\n\n        return this;\n    }\n\n    /**\n     * Removes all the passed display-objects from the culling list\n     *\n     * @param targets - the display-objects to be removed\n     * @return this\n     */\n    removeAll(targets)\n    {\n        for (let i = 0, j = targets.length; i < j; i++)\n        {\n            this._targetList.delete(targets[i]);\n        }\n\n        return this;\n    }\n\n    /**\n     * Clears the culling list\n     *\n     * @return this\n     */\n    clear()\n    {\n        this._targetList.clear();\n\n        return this;\n    }\n\n    /**\n     * @param rect - the rectangle outside of which display-objects should be culled\n     * @param skipUpdate - whether to skip unculling, transform update, bounds calculation. It is\n     *  highly recommended you enable this by calling _this.uncull()_ and _root.getBounds(false)_ manually\n     *  before your render loop.\n     * @return this\n     */\n    cull(rect, skipUpdate = false)\n    {\n        if (!skipUpdate)\n        {\n            this.uncull();\n        }\n\n        this._targetList.forEach((target) =>\n        {\n            if (!skipUpdate)\n            {\n                // Update transforms, bounds of display-objects in this target's subtree\n                target.getBounds(false, tempRect);\n            }\n\n            if (this._recursive)\n            {\n                this.cullRecursive(rect, target, skipUpdate);\n            }\n            else\n            {\n                // NOTE: If skipUpdate is false, then tempRect already contains the bounds of the target\n                if (skipUpdate)\n                {\n                    target._bounds.getRectangle(rect);\n                }\n\n                target[this._toggle] = tempRect.right > rect.left\n                    && tempRect.left < rect.right\n                    && tempRect.bottom > rect.top\n                    && tempRect.top < rect.bottom;\n            }\n        });\n\n        return this;\n    }\n\n    /**\n     * Sets all display-objects to the unculled state.\n     *\n     * This happens regardless of whether the culling toggle was set by {@code this.cull} or manually. This\n     * is why it is recommended to one of `visible` or `renderable` for normal use and the other for culling.\n     *\n     * @return this\n     */\n    uncull()\n    {\n        this._targetList.forEach((target) =>\n        {\n            if (this._recursive)\n            {\n                this.uncullRecursive(target);\n            }\n            else\n            {\n                target[this._toggle] = false;\n            }\n        });\n\n        return this;\n    }\n\n    /**\n     * Recursively culls the subtree of {@code displayObject}.\n     *\n     * @param rect - the visiblity rectangle\n     * @param displayObject - the root of the subtree to cull\n     * @param skipUpdate - whether to skip bounds calculation. However, transforms are expected to be updated by the caller.\n     */\n     cullRecursive(rect, displayObject, skipUpdate)\n    {\n        // NOTE: getBounds can skipUpdate because updateTransform is invoked before culling.\n        const bounds = skipUpdate\n            ? displayObject._bounds.getRectangle(tempRect)\n            : displayObject.getBounds(true, tempRect);\n\n        displayObject[this._toggle] = bounds.right > rect.left\n            && bounds.left < rect.right\n            && bounds.bottom > rect.top\n            && bounds.top < rect.bottom;\n\n        const fullyVisible = bounds.left >= rect.left\n            && bounds.top >= rect.top\n            && bounds.right <= rect.right\n            && bounds.bottom <= rect.bottom;\n\n        // Only cull children if this display-object is *not* fully-visible. It is expected that the bounds\n        // of children lie inside of its own. Hence, further culling is only required if the display-object\n        // intersects with the boundaries of \"rect\". Otherwise, if the object is fully outside/inside the\n        // screen, the children don't need to be evaluated as they are presumed to be unculled.\n        if (!fullyVisible\n                && displayObject[this._toggle]\n                && (displayObject ).children\n                && (displayObject ).children.length)\n        {\n            const children = (displayObject ).children;\n\n            for (let i = 0, j = children.length; i < j; i++)\n            {\n                this.cullRecursive(rect, children[i]);\n            }\n        }\n    }\n\n    /**\n     * Recursively unculls the subtree of {@code displayObject}.\n     *\n     * @param displayObject\n     */\n     uncullRecursive(displayObject)\n    {\n        displayObject[this._toggle] = true;\n\n        if ((displayObject ).children && (displayObject ).children.length)\n        {\n            const children = (displayObject ).children;\n\n            for (let i = 0, j = children.length; i < j; i++)\n            {\n                this.uncullRecursive(children[i]);\n            }\n        }\n    }\n}\n\nexports.Cull = Cull;\n//# sourceMappingURL=cull.js.map\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$$pixi$math$dist$cjs$math"]],"~:properties",["^5",["_toggle","__esModule","_targetList","Cull","_recursive","value"]],"~:compiled-at",1766065009675,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$pixi_essentials$cull$lib$cull.js\",\n\"lineCount\":3,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAc9DC,MAAOC,CAAAA,cAAP,CAAsBF,CAAtB,CAA+B,YAA/B,CAA6C,CAAEG,MAAO,CAAA,CAAT,CAA7C,CAIA,OAAMC,EAAW,KAFNN,CAAAO,CAAQ,GAARA,CAEeC,CAAAA,SAAT,CAsBjB,MAAMC,EAAN,CAYIC,WAAW,CAACC,CAAA,CAAU,EAAX,CACX,CACI,IAAKC,CAAAA,UAAL,CAA+C,SAA7B,GAAA,MAAOD,EAAQE,CAAAA,SAAf,CAAyCF,CAAQE,CAAAA,SAAjD,CAA6D,CAAA,CAC/E,KAAKC,CAAAA,OAAL,CAAeH,CAAQI,CAAAA,MAAvB,EAAiC,SACjC,KAAKC,CAAAA,WAAL,CAAmB,IAAIC,GAH3B,CAYAC,GAAG,CAACC,CAAD,CACH,CACI,IAAKH,CAAAA,WAAYE,CAAAA,GAAjB,CAAqBC,CAArB,CAEA,OAAO,KAHX,CAYAC,MAAM,CAACC,CAAD,CACN,CACI,IAAK,IAAIC,EAAI,CAAR,CAAWC,EAAIF,CAAQG,CAAAA,MAA5B,CAAoCF,CAApC,CAAwCC,CAAxC,CAA2CD,CAAA,EAA3C,CAEI,IAAKN,CAAAA,WAAYE,CAAAA,GAAjB,CAAqBG,CAAA,CAAQC,CAAR,CAArB,CAGJ,OAAO,KANX,CAeAG,MAAM,CAACN,CAAD,CACN,CACI,IAAKH,CAAAA,WAAYU,CAAAA,MAAjB,CAAwBP,CAAxB,CAEA,OAAO,KAHX,CAYAQ,SAAS,CAACN,CAAD,CACT,CACI,IAAK,IAAIC,EAAI,CAAR,CAAWC,EAAIF,CAAQG,CAAAA,MAA5B,CAAoCF,CAApC,CAAwCC,CAAxC,CAA2CD,CAAA,EAA3C,CAEI,IAAKN,CAAAA,WAAYU,CAAAA,MAAjB,CAAwBL,CAAA,CAAQC,CAAR,CAAxB,CAGJ;MAAO,KANX,CAcAM,KAAK,EACL,CACI,IAAKZ,CAAAA,WAAYY,CAAAA,KAAjB,EAEA,OAAO,KAHX,CAaAC,IAAI,CAACC,CAAD,CAAOC,CAAA,CAAa,CAAA,CAApB,CACJ,CACSA,CAAL,EAEI,IAAKC,CAAAA,MAAL,EAGJ,KAAKhB,CAAAA,WAAYiB,CAAAA,OAAjB,CAA0Bd,CAAD,EACzB,CACSY,CAAL,EAGIZ,CAAOe,CAAAA,SAAP,CAAiB,CAAA,CAAjB,CAAwB5B,CAAxB,CAGA,KAAKM,CAAAA,UAAT,CAEI,IAAKuB,CAAAA,aAAL,CAAmBL,CAAnB,CAAyBX,CAAzB,CAAiCY,CAAjC,CAFJ,EAOQA,CAKJ,EAHIZ,CAAOiB,CAAAA,OAAQC,CAAAA,YAAf,CAA4BP,CAA5B,CAGJ,CAAAX,CAAA,CAAO,IAAKL,CAAAA,OAAZ,CAAA,CAAuBR,CAASgC,CAAAA,KAAhC,CAAwCR,CAAKS,CAAAA,IAA7C,EACOjC,CAASiC,CAAAA,IADhB,CACuBT,CAAKQ,CAAAA,KAD5B,EAEOhC,CAASkC,CAAAA,MAFhB,CAEyBV,CAAKW,CAAAA,GAF9B,EAGOnC,CAASmC,CAAAA,GAHhB,CAGsBX,CAAKU,CAAAA,MAf/B,CAPJ,CADA,CA2BA,OAAO,KAjCX,CA4CAR,MAAM,EACN,CACI,IAAKhB,CAAAA,WAAYiB,CAAAA,OAAjB,CAA0Bd,CAAD,EACzB,CACQ,IAAKP,CAAAA,UAAT,CAEI,IAAK8B,CAAAA,eAAL,CAAqBvB,CAArB,CAFJ,CAMIA,CAAA,CAAO,IAAKL,CAAAA,OAAZ,CANJ,CAM2B,CAAA,CAP/B,CADA,CAYA,OAAO,KAbX,CAuBCqB,aAAa,CAACL,CAAD,CAAOa,CAAP,CAAsBZ,CAAtB,CACd,CAEUa,CAAAA,CAASb,CAAA,CACTY,CAAcP,CAAAA,OAAQC,CAAAA,YAAtB,CAAmC/B,CAAnC,CADS,CAETqC,CAAcT,CAAAA,SAAd,CAAwB,CAAA,CAAxB,CAA8B5B,CAA9B,CAENqC,EAAA,CAAc,IAAK7B,CAAAA,OAAnB,CAAA,CAA8B8B,CAAON,CAAAA,KAArC;AAA6CR,CAAKS,CAAAA,IAAlD,EACOK,CAAOL,CAAAA,IADd,CACqBT,CAAKQ,CAAAA,KAD1B,EAEOM,CAAOJ,CAAAA,MAFd,CAEuBV,CAAKW,CAAAA,GAF5B,EAGOG,CAAOH,CAAAA,GAHd,CAGoBX,CAAKU,CAAAA,MAWzB,IAAI,EATiBI,CAAOL,CAAAA,IASxB,EATgCT,CAAKS,CAAAA,IASrC,EARGK,CAAOH,CAAAA,GAQV,EARiBX,CAAKW,CAAAA,GAQtB,EAPGG,CAAON,CAAAA,KAOV,EAPmBR,CAAKQ,CAAAA,KAOxB,EANGM,CAAOJ,CAAAA,MAMV,EANoBV,CAAKU,CAAAA,MAMzB,CAAJ,EACWG,CAAA,CAAc,IAAK7B,CAAAA,OAAnB,CADX,EAEY6B,CAAgBE,CAAAA,QAF5B,EAGYF,CAAgBE,CAAAA,QAASrB,CAAAA,MAHrC,CAIA,CACUqB,CAAAA,CAAYF,CAAgBE,CAAAA,QAElC,KAAK,IAAIvB,EAAI,CAAR,CAAWC,EAAIsB,CAASrB,CAAAA,MAA7B,CAAqCF,CAArC,CAAyCC,CAAzC,CAA4CD,CAAA,EAA5C,CAEI,IAAKa,CAAAA,aAAL,CAAmBL,CAAnB,CAAyBe,CAAA,CAASvB,CAAT,CAAzB,CALR,CAxBJ,CAuCCoB,eAAe,CAACC,CAAD,CAChB,CACIA,CAAA,CAAc,IAAK7B,CAAAA,OAAnB,CAAA,CAA8B,CAAA,CAE9B,IAAK6B,CAAgBE,CAAAA,QAArB,EAAkCF,CAAgBE,CAAAA,QAASrB,CAAAA,MAA3D,CACA,CACUqB,CAAAA,CAAYF,CAAgBE,CAAAA,QAElC,KAAK,IAAIvB,EAAI,CAAR,CAAWC,EAAIsB,CAASrB,CAAAA,MAA7B,CAAqCF,CAArC,CAAyCC,CAAzC,CAA4CD,CAAA,EAA5C,CAEI,IAAKoB,CAAAA,eAAL,CAAqBG,CAAA,CAASvB,CAAT,CAArB,CALR,CAJJ,CA9MJ,CA6NApB,CAAQO,CAAAA,IAAR,CAAeA,CArQ+C;\",\n\"sources\":[\"node_modules/@pixi-essentials/cull/lib/cull.js\"],\n\"sourcesContent\":[\"shadow$provide[368] = function(global,require,module,exports) {\\n/* eslint-disable */\\n \\n/*!\\n * @pixi-essentials/cull - v1.0.12\\n * Compiled Wed, 17 Mar 2021 16:10:19 UTC\\n *\\n * @pixi-essentials/cull is licensed under the MIT License.\\n * http://www.opensource.org/licenses/mit-license\\n * \\n * Copyright 2019-2020, Shukant Pal <shukantpal@outlook.com>, All Rights Reserved\\n */\\n'use strict';\\n\\nObject.defineProperty(exports, '__esModule', { value: true });\\n\\nvar math = require('@pixi/math');\\n\\nconst tempRect = new math.Rectangle();\\n\\n/**\\n * The culling options for {@code Cull}.\\n *\\n * @ignore\\n * @public\\n */\\n\\n\\n\\n\\n\\n\\n/**\\n * Provides a simple, configurable mechanism for culling a subtree of your scene graph.\\n *\\n * If your scene graph is not static, culling needs to be done before rendering. You\\n * can run it on the `prerender` event fired by the renderer.\\n *\\n * @public\\n */\\nclass Cull\\n{\\n    \\n    \\n    \\n\\n    /**\\n     * @param options\\n     * @param [options.recursive] - whether culling should be recursive\\n     * @param [options.toggle='renderable'] - which property of display-object was be set to indicate\\n     *      its culling state. It should be one of `renderable`, `visible`.\\n     */\\n    constructor(options = {})\\n    {\\n        this._recursive = typeof options.recursive === 'boolean' ? options.recursive : true;\\n        this._toggle = options.toggle || 'visible';\\n        this._targetList = new Set();\\n    }\\n\\n    /**\\n     * Adds a display-object to the culling list\\n     *\\n     * @param target - the display-object to be culled\\n     * @return this\\n     */\\n    add(target)\\n    {\\n        this._targetList.add(target);\\n\\n        return this;\\n    }\\n\\n    /**\\n     * Adds all the display-objects to the culling list\\n     *\\n     * @param targets - the display-objects to be culled\\n     * @return this\\n     */\\n    addAll(targets)\\n    {\\n        for (let i = 0, j = targets.length; i < j; i++)\\n        {\\n            this._targetList.add(targets[i]);\\n        }\\n\\n        return this;\\n    }\\n\\n    /**\\n     * Removes the display-object from the culling list\\n     *\\n     * @param target - the display-object to be removed\\n     * @return this\\n     */\\n    remove(target)\\n    {\\n        this._targetList.delete(target);\\n\\n        return this;\\n    }\\n\\n    /**\\n     * Removes all the passed display-objects from the culling list\\n     *\\n     * @param targets - the display-objects to be removed\\n     * @return this\\n     */\\n    removeAll(targets)\\n    {\\n        for (let i = 0, j = targets.length; i < j; i++)\\n        {\\n            this._targetList.delete(targets[i]);\\n        }\\n\\n        return this;\\n    }\\n\\n    /**\\n     * Clears the culling list\\n     *\\n     * @return this\\n     */\\n    clear()\\n    {\\n        this._targetList.clear();\\n\\n        return this;\\n    }\\n\\n    /**\\n     * @param rect - the rectangle outside of which display-objects should be culled\\n     * @param skipUpdate - whether to skip unculling, transform update, bounds calculation. It is\\n     *  highly recommended you enable this by calling _this.uncull()_ and _root.getBounds(false)_ manually\\n     *  before your render loop.\\n     * @return this\\n     */\\n    cull(rect, skipUpdate = false)\\n    {\\n        if (!skipUpdate)\\n        {\\n            this.uncull();\\n        }\\n\\n        this._targetList.forEach((target) =>\\n        {\\n            if (!skipUpdate)\\n            {\\n                // Update transforms, bounds of display-objects in this target's subtree\\n                target.getBounds(false, tempRect);\\n            }\\n\\n            if (this._recursive)\\n            {\\n                this.cullRecursive(rect, target, skipUpdate);\\n            }\\n            else\\n            {\\n                // NOTE: If skipUpdate is false, then tempRect already contains the bounds of the target\\n                if (skipUpdate)\\n                {\\n                    target._bounds.getRectangle(rect);\\n                }\\n\\n                target[this._toggle] = tempRect.right > rect.left\\n                    && tempRect.left < rect.right\\n                    && tempRect.bottom > rect.top\\n                    && tempRect.top < rect.bottom;\\n            }\\n        });\\n\\n        return this;\\n    }\\n\\n    /**\\n     * Sets all display-objects to the unculled state.\\n     *\\n     * This happens regardless of whether the culling toggle was set by {@code this.cull} or manually. This\\n     * is why it is recommended to one of `visible` or `renderable` for normal use and the other for culling.\\n     *\\n     * @return this\\n     */\\n    uncull()\\n    {\\n        this._targetList.forEach((target) =>\\n        {\\n            if (this._recursive)\\n            {\\n                this.uncullRecursive(target);\\n            }\\n            else\\n            {\\n                target[this._toggle] = false;\\n            }\\n        });\\n\\n        return this;\\n    }\\n\\n    /**\\n     * Recursively culls the subtree of {@code displayObject}.\\n     *\\n     * @param rect - the visiblity rectangle\\n     * @param displayObject - the root of the subtree to cull\\n     * @param skipUpdate - whether to skip bounds calculation. However, transforms are expected to be updated by the caller.\\n     */\\n     cullRecursive(rect, displayObject, skipUpdate)\\n    {\\n        // NOTE: getBounds can skipUpdate because updateTransform is invoked before culling.\\n        const bounds = skipUpdate\\n            ? displayObject._bounds.getRectangle(tempRect)\\n            : displayObject.getBounds(true, tempRect);\\n\\n        displayObject[this._toggle] = bounds.right > rect.left\\n            && bounds.left < rect.right\\n            && bounds.bottom > rect.top\\n            && bounds.top < rect.bottom;\\n\\n        const fullyVisible = bounds.left >= rect.left\\n            && bounds.top >= rect.top\\n            && bounds.right <= rect.right\\n            && bounds.bottom <= rect.bottom;\\n\\n        // Only cull children if this display-object is *not* fully-visible. It is expected that the bounds\\n        // of children lie inside of its own. Hence, further culling is only required if the display-object\\n        // intersects with the boundaries of \\\"rect\\\". Otherwise, if the object is fully outside/inside the\\n        // screen, the children don't need to be evaluated as they are presumed to be unculled.\\n        if (!fullyVisible\\n                && displayObject[this._toggle]\\n                && (displayObject ).children\\n                && (displayObject ).children.length)\\n        {\\n            const children = (displayObject ).children;\\n\\n            for (let i = 0, j = children.length; i < j; i++)\\n            {\\n                this.cullRecursive(rect, children[i]);\\n            }\\n        }\\n    }\\n\\n    /**\\n     * Recursively unculls the subtree of {@code displayObject}.\\n     *\\n     * @param displayObject\\n     */\\n     uncullRecursive(displayObject)\\n    {\\n        displayObject[this._toggle] = true;\\n\\n        if ((displayObject ).children && (displayObject ).children.length)\\n        {\\n            const children = (displayObject ).children;\\n\\n            for (let i = 0, j = children.length; i < j; i++)\\n            {\\n                this.uncullRecursive(children[i]);\\n            }\\n        }\\n    }\\n}\\n\\nexports.Cull = Cull;\\n//# sourceMappingURL=cull.js.map\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Object\",\"defineProperty\",\"value\",\"tempRect\",\"math\",\"Rectangle\",\"Cull\",\"constructor\",\"options\",\"_recursive\",\"recursive\",\"_toggle\",\"toggle\",\"_targetList\",\"Set\",\"add\",\"target\",\"addAll\",\"targets\",\"i\",\"j\",\"length\",\"remove\",\"delete\",\"removeAll\",\"clear\",\"cull\",\"rect\",\"skipUpdate\",\"uncull\",\"forEach\",\"getBounds\",\"cullRecursive\",\"_bounds\",\"getRectangle\",\"right\",\"left\",\"bottom\",\"top\",\"uncullRecursive\",\"displayObject\",\"bounds\",\"children\"]\n}\n"]