["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@pixi/ticker/dist/cjs/ticker.js"],"~:js","shadow$provide[356]=function(ra,X,Ra,P){Object.defineProperty(P,\"__esModule\",{value:!0});var w=X(303);w.settings.TARGET_FPMS=.06;(function(p){p[p.INTERACTION=50]=\"INTERACTION\";p[p.HIGH=25]=\"HIGH\";p[p.NORMAL=0]=\"NORMAL\";p[p.LOW=-25]=\"LOW\";p[p.UTILITY=-50]=\"UTILITY\"})(P.UPDATE_PRIORITY||(P.UPDATE_PRIORITY={}));var Z=function(){function p(c,u,A,y){void 0===u&&(u=null);void 0===A&&(A=0);void 0===y&&(y=!1);this.previous=this.next=null;this._destroyed=!1;this.fn=c;this.context=u;this.priority=A;this.once=\ny}p.prototype.match=function(c,u){void 0===u&&(u=null);return this.fn===c&&this.context===u};p.prototype.emit=function(c){this.fn&&(this.context?this.fn.call(this.context,c):this.fn(c));c=this.next;this.once&&this.destroy(!0);this._destroyed&&(this.next=null);return c};p.prototype.connect=function(c){this.previous=c;c.next&&(c.next.previous=this);this.next=c.next;c.next=this};p.prototype.destroy=function(c){void 0===c&&(c=!1);this._destroyed=!0;this.context=this.fn=null;this.previous&&(this.previous.next=\nthis.next);this.next&&(this.next.previous=this.previous);var u=this.next;this.next=c?null:u;this.previous=null;return u};return p}(),B=function(){function p(){var c=this;this.autoStart=!1;this.deltaTime=1;this.lastTime=-1;this.speed=1;this.started=!1;this._requestId=null;this._maxElapsedMS=100;this._minElapsedMS=0;this._protected=!1;this._lastFrame=-1;this._head=new Z(null,null,Infinity);this.deltaMS=1/w.settings.TARGET_FPMS;this.elapsedMS=1/w.settings.TARGET_FPMS;this._tick=function(u){c._requestId=\nnull;c.started&&(c.update(u),c.started&&null===c._requestId&&c._head.next&&(c._requestId=requestAnimationFrame(c._tick)))}}p.prototype._requestIfNeeded=function(){null===this._requestId&&this._head.next&&(this._lastFrame=this.lastTime=performance.now(),this._requestId=requestAnimationFrame(this._tick))};p.prototype._cancelIfNeeded=function(){null!==this._requestId&&(cancelAnimationFrame(this._requestId),this._requestId=null)};p.prototype._startIfPossible=function(){this.started?this._requestIfNeeded():\nthis.autoStart&&this.start()};p.prototype.add=function(c,u,A){void 0===A&&(A=P.UPDATE_PRIORITY.NORMAL);return this._addListener(new Z(c,u,A))};p.prototype.addOnce=function(c,u,A){void 0===A&&(A=P.UPDATE_PRIORITY.NORMAL);return this._addListener(new Z(c,u,A,!0))};p.prototype._addListener=function(c){var u=this._head.next,A=this._head;if(u){for(;u;){if(c.priority>u.priority){c.connect(A);break}A=u;u=u.next}c.previous||c.connect(A)}else c.connect(A);this._startIfPossible();return this};p.prototype.remove=\nfunction(c,u){for(var A=this._head.next;A;)A=A.match(c,u)?A.destroy():A.next;this._head.next||this._cancelIfNeeded();return this};Object.defineProperty(p.prototype,\"count\",{get:function(){if(!this._head)return 0;for(var c=0,u=this._head;u=u.next;)c++;return c},enumerable:!1,configurable:!0});p.prototype.start=function(){this.started||(this.started=!0,this._requestIfNeeded())};p.prototype.stop=function(){this.started&&(this.started=!1,this._cancelIfNeeded())};p.prototype.destroy=function(){if(!this._protected){this.stop();\nfor(var c=this._head.next;c;)c=c.destroy(!0);this._head.destroy();this._head=null}};p.prototype.update=function(c){void 0===c&&(c=performance.now());if(c>this.lastTime){var u=this.elapsedMS=c-this.lastTime;u>this._maxElapsedMS&&(u=this._maxElapsedMS);u*=this.speed;if(this._minElapsedMS){var A=c-this._lastFrame|0;if(A<this._minElapsedMS)return;this._lastFrame=c-A%this._minElapsedMS}this.deltaMS=u;this.deltaTime=this.deltaMS*w.settings.TARGET_FPMS;u=this._head;for(A=u.next;A;)A=A.emit(this.deltaTime);\nu.next||this._cancelIfNeeded()}else this.deltaTime=this.deltaMS=this.elapsedMS=0;this.lastTime=c};Object.defineProperty(p.prototype,\"FPS\",{get:function(){return 1E3/this.elapsedMS},enumerable:!1,configurable:!0});Object.defineProperty(p.prototype,\"minFPS\",{get:function(){return 1E3/this._maxElapsedMS},set:function(c){this._maxElapsedMS=1/Math.min(Math.max(0,Math.min(this.maxFPS,c))/1E3,w.settings.TARGET_FPMS)},enumerable:!1,configurable:!0});Object.defineProperty(p.prototype,\"maxFPS\",{get:function(){return this._minElapsedMS?\nMath.round(1E3/this._minElapsedMS):0},set:function(c){this._minElapsedMS=0===c?0:1/(Math.max(this.minFPS,c)/1E3)},enumerable:!1,configurable:!0});Object.defineProperty(p,\"shared\",{get:function(){if(!p._shared){var c=p._shared=new p;c.autoStart=!0;c._protected=!0}return p._shared},enumerable:!1,configurable:!0});Object.defineProperty(p,\"system\",{get:function(){if(!p._system){var c=p._system=new p;c.autoStart=!0;c._protected=!0}return p._system},enumerable:!1,configurable:!0});return p}();ra=function(){function p(){}\np.init=function(c){var u=this;c=Object.assign({autoStart:!0,sharedTicker:!1},c);Object.defineProperty(this,\"ticker\",{set:function(A){this._ticker&&this._ticker.remove(this.render,this);(this._ticker=A)&&A.add(this.render,this,P.UPDATE_PRIORITY.LOW)},get:function(){return this._ticker}});this.stop=function(){u._ticker.stop()};this.start=function(){u._ticker.start()};this._ticker=null;this.ticker=c.sharedTicker?B.shared:new B;c.autoStart&&this.start()};p.destroy=function(){if(this._ticker){var c=this._ticker;\nthis.ticker=null;c.destroy()}};return p}();P.Ticker=B;P.TickerPlugin=ra}","~:source","shadow$provide[356] = function(global,require,module,exports) {\n/*!\n * @pixi/ticker - v6.2.0\n * Compiled Mon, 01 Nov 2021 16:52:10 UTC\n *\n * @pixi/ticker is licensed under the MIT License.\n * http://www.opensource.org/licenses/mit-license\n */\n'use strict';\n\nObject.defineProperty(exports, '__esModule', { value: true });\n\nvar settings = require('@pixi/settings');\n\n/**\n * Target frames per millisecond.\n *\n * @static\n * @name TARGET_FPMS\n * @memberof PIXI.settings\n * @type {number}\n * @default 0.06\n */\nsettings.settings.TARGET_FPMS = 0.06;\n\n/**\n * Represents the update priorities used by internal PIXI classes when registered with\n * the {@link PIXI.Ticker} object. Higher priority items are updated first and lower\n * priority items, such as render, should go later.\n *\n * @static\n * @constant\n * @name UPDATE_PRIORITY\n * @memberof PIXI\n * @enum {number}\n * @property {number} INTERACTION=50 Highest priority, used for {@link PIXI.InteractionManager}\n * @property {number} HIGH=25 High priority updating, {@link PIXI.VideoBaseTexture} and {@link PIXI.AnimatedSprite}\n * @property {number} NORMAL=0 Default priority for ticker events, see {@link PIXI.Ticker#add}.\n * @property {number} LOW=-25 Low priority used for {@link PIXI.Application} rendering.\n * @property {number} UTILITY=-50 Lowest priority used for {@link PIXI.BasePrepare} utility.\n */\n(function (UPDATE_PRIORITY) {\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\"INTERACTION\"] = 50] = \"INTERACTION\";\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\"HIGH\"] = 25] = \"HIGH\";\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\"NORMAL\"] = 0] = \"NORMAL\";\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\"LOW\"] = -25] = \"LOW\";\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\"UTILITY\"] = -50] = \"UTILITY\";\n})(exports.UPDATE_PRIORITY || (exports.UPDATE_PRIORITY = {}));\n\n/**\n * Internal class for handling the priority sorting of ticker handlers.\n *\n * @private\n * @class\n * @memberof PIXI\n */\nvar TickerListener = /** @class */ (function () {\n    /**\n     * Constructor\n     * @private\n     * @param fn - The listener function to be added for one update\n     * @param context - The listener context\n     * @param priority - The priority for emitting\n     * @param once - If the handler should fire once\n     */\n    function TickerListener(fn, context, priority, once) {\n        if (context === void 0) { context = null; }\n        if (priority === void 0) { priority = 0; }\n        if (once === void 0) { once = false; }\n        /** The next item in chain. */\n        this.next = null;\n        /** The previous item in chain. */\n        this.previous = null;\n        /** `true` if this listener has been destroyed already. */\n        this._destroyed = false;\n        this.fn = fn;\n        this.context = context;\n        this.priority = priority;\n        this.once = once;\n    }\n    /**\n     * Simple compare function to figure out if a function and context match.\n     * @private\n     * @param fn - The listener function to be added for one update\n     * @param context - The listener context\n     * @return `true` if the listener match the arguments\n     */\n    TickerListener.prototype.match = function (fn, context) {\n        if (context === void 0) { context = null; }\n        return this.fn === fn && this.context === context;\n    };\n    /**\n     * Emit by calling the current function.\n     * @private\n     * @param deltaTime - time since the last emit.\n     * @return Next ticker\n     */\n    TickerListener.prototype.emit = function (deltaTime) {\n        if (this.fn) {\n            if (this.context) {\n                this.fn.call(this.context, deltaTime);\n            }\n            else {\n                this.fn(deltaTime);\n            }\n        }\n        var redirect = this.next;\n        if (this.once) {\n            this.destroy(true);\n        }\n        // Soft-destroying should remove\n        // the next reference\n        if (this._destroyed) {\n            this.next = null;\n        }\n        return redirect;\n    };\n    /**\n     * Connect to the list.\n     * @private\n     * @param previous - Input node, previous listener\n     */\n    TickerListener.prototype.connect = function (previous) {\n        this.previous = previous;\n        if (previous.next) {\n            previous.next.previous = this;\n        }\n        this.next = previous.next;\n        previous.next = this;\n    };\n    /**\n     * Destroy and don't use after this.\n     * @private\n     * @param hard - `true` to remove the `next` reference, this\n     *        is considered a hard destroy. Soft destroy maintains the next reference.\n     * @return The listener to redirect while emitting or removing.\n     */\n    TickerListener.prototype.destroy = function (hard) {\n        if (hard === void 0) { hard = false; }\n        this._destroyed = true;\n        this.fn = null;\n        this.context = null;\n        // Disconnect, hook up next and previous\n        if (this.previous) {\n            this.previous.next = this.next;\n        }\n        if (this.next) {\n            this.next.previous = this.previous;\n        }\n        // Redirect to the next item\n        var redirect = this.next;\n        // Remove references\n        this.next = hard ? null : redirect;\n        this.previous = null;\n        return redirect;\n    };\n    return TickerListener;\n}());\n\n/**\n * A Ticker class that runs an update loop that other objects listen to.\n *\n * This class is composed around listeners meant for execution on the next requested animation frame.\n * Animation frames are requested only when necessary, e.g. When the ticker is started and the emitter has listeners.\n *\n * @class\n * @memberof PIXI\n */\nvar Ticker = /** @class */ (function () {\n    function Ticker() {\n        var _this = this;\n        /**\n         * Whether or not this ticker should invoke the method\n         * {@link PIXI.Ticker#start} automatically\n         * when a listener is added.\n         */\n        this.autoStart = false;\n        /**\n         * Scalar time value from last frame to this frame.\n         * This value is capped by setting {@link PIXI.Ticker#minFPS}\n         * and is scaled with {@link PIXI.Ticker#speed}.\n         * **Note:** The cap may be exceeded by scaling.\n         */\n        this.deltaTime = 1;\n        /**\n         * The last time {@link PIXI.Ticker#update} was invoked.\n         * This value is also reset internally outside of invoking\n         * update, but only when a new animation frame is requested.\n         * If the platform supports DOMHighResTimeStamp,\n         * this value will have a precision of 1 µs.\n         */\n        this.lastTime = -1;\n        /**\n         * Factor of current {@link PIXI.Ticker#deltaTime}.\n         * @example\n         * // Scales ticker.deltaTime to what would be\n         * // the equivalent of approximately 120 FPS\n         * ticker.speed = 2;\n         */\n        this.speed = 1;\n        /**\n         * Whether or not this ticker has been started.\n         * `true` if {@link PIXI.Ticker#start} has been called.\n         * `false` if {@link PIXI.Ticker#stop} has been called.\n         * While `false`, this value may change to `true` in the\n         * event of {@link PIXI.Ticker#autoStart} being `true`\n         * and a listener is added.\n         */\n        this.started = false;\n        /** Internal current frame request ID */\n        this._requestId = null;\n        /**\n         * Internal value managed by minFPS property setter and getter.\n         * This is the maximum allowed milliseconds between updates.\n         */\n        this._maxElapsedMS = 100;\n        /**\n         * Internal value managed by minFPS property setter and getter.\n         * This is the maximum allowed milliseconds between updates.\n         */\n        this._minElapsedMS = 0;\n        /** If enabled, deleting is disabled.*/\n        this._protected = false;\n        /**\n         * The last time keyframe was executed.\n         * Maintains a relatively fixed interval with the previous value.\n         */\n        this._lastFrame = -1;\n        this._head = new TickerListener(null, null, Infinity);\n        this.deltaMS = 1 / settings.settings.TARGET_FPMS;\n        this.elapsedMS = 1 / settings.settings.TARGET_FPMS;\n        this._tick = function (time) {\n            _this._requestId = null;\n            if (_this.started) {\n                // Invoke listeners now\n                _this.update(time);\n                // Listener side effects may have modified ticker state.\n                if (_this.started && _this._requestId === null && _this._head.next) {\n                    _this._requestId = requestAnimationFrame(_this._tick);\n                }\n            }\n        };\n    }\n    /**\n     * Conditionally requests a new animation frame.\n     * If a frame has not already been requested, and if the internal\n     * emitter has listeners, a new frame is requested.\n     *\n     * @private\n     */\n    Ticker.prototype._requestIfNeeded = function () {\n        if (this._requestId === null && this._head.next) {\n            // ensure callbacks get correct delta\n            this.lastTime = performance.now();\n            this._lastFrame = this.lastTime;\n            this._requestId = requestAnimationFrame(this._tick);\n        }\n    };\n    /**\n     * Conditionally cancels a pending animation frame.\n     * @private\n     */\n    Ticker.prototype._cancelIfNeeded = function () {\n        if (this._requestId !== null) {\n            cancelAnimationFrame(this._requestId);\n            this._requestId = null;\n        }\n    };\n    /**\n     * Conditionally requests a new animation frame.\n     * If the ticker has been started it checks if a frame has not already\n     * been requested, and if the internal emitter has listeners. If these\n     * conditions are met, a new frame is requested. If the ticker has not\n     * been started, but autoStart is `true`, then the ticker starts now,\n     * and continues with the previous conditions to request a new frame.\n     *\n     * @private\n     */\n    Ticker.prototype._startIfPossible = function () {\n        if (this.started) {\n            this._requestIfNeeded();\n        }\n        else if (this.autoStart) {\n            this.start();\n        }\n    };\n    /**\n     * Register a handler for tick events. Calls continuously unless\n     * it is removed or the ticker is stopped.\n     *\n     * @param fn - The listener function to be added for updates\n     * @param context - The listener context\n     * @param {number} [priority=PIXI.UPDATE_PRIORITY.NORMAL] - The priority for emitting\n     * @returns This instance of a ticker\n     */\n    Ticker.prototype.add = function (fn, context, priority) {\n        if (priority === void 0) { priority = exports.UPDATE_PRIORITY.NORMAL; }\n        return this._addListener(new TickerListener(fn, context, priority));\n    };\n    /**\n     * Add a handler for the tick event which is only execute once.\n     *\n     * @param fn - The listener function to be added for one update\n     * @param context - The listener context\n     * @param {number} [priority=PIXI.UPDATE_PRIORITY.NORMAL] - The priority for emitting\n     * @returns This instance of a ticker\n     */\n    Ticker.prototype.addOnce = function (fn, context, priority) {\n        if (priority === void 0) { priority = exports.UPDATE_PRIORITY.NORMAL; }\n        return this._addListener(new TickerListener(fn, context, priority, true));\n    };\n    /**\n     * Internally adds the event handler so that it can be sorted by priority.\n     * Priority allows certain handler (user, AnimatedSprite, Interaction) to be run\n     * before the rendering.\n     *\n     * @private\n     * @param listener - Current listener being added.\n     * @returns This instance of a ticker\n     */\n    Ticker.prototype._addListener = function (listener) {\n        // For attaching to head\n        var current = this._head.next;\n        var previous = this._head;\n        // Add the first item\n        if (!current) {\n            listener.connect(previous);\n        }\n        else {\n            // Go from highest to lowest priority\n            while (current) {\n                if (listener.priority > current.priority) {\n                    listener.connect(previous);\n                    break;\n                }\n                previous = current;\n                current = current.next;\n            }\n            // Not yet connected\n            if (!listener.previous) {\n                listener.connect(previous);\n            }\n        }\n        this._startIfPossible();\n        return this;\n    };\n    /**\n     * Removes any handlers matching the function and context parameters.\n     * If no handlers are left after removing, then it cancels the animation frame.\n     *\n     * @param fn - The listener function to be removed\n     * @param context - The listener context to be removed\n     * @returns This instance of a ticker\n     */\n    Ticker.prototype.remove = function (fn, context) {\n        var listener = this._head.next;\n        while (listener) {\n            // We found a match, lets remove it\n            // no break to delete all possible matches\n            // incase a listener was added 2+ times\n            if (listener.match(fn, context)) {\n                listener = listener.destroy();\n            }\n            else {\n                listener = listener.next;\n            }\n        }\n        if (!this._head.next) {\n            this._cancelIfNeeded();\n        }\n        return this;\n    };\n    Object.defineProperty(Ticker.prototype, \"count\", {\n        /**\n         * The number of listeners on this ticker, calculated by walking through linked list\n         *\n         * @readonly\n         * @member {number}\n         */\n        get: function () {\n            if (!this._head) {\n                return 0;\n            }\n            var count = 0;\n            var current = this._head;\n            while ((current = current.next)) {\n                count++;\n            }\n            return count;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    /**\n     * Starts the ticker. If the ticker has listeners\n     * a new animation frame is requested at this point.\n     */\n    Ticker.prototype.start = function () {\n        if (!this.started) {\n            this.started = true;\n            this._requestIfNeeded();\n        }\n    };\n    /**\n     * Stops the ticker. If the ticker has requested\n     * an animation frame it is canceled at this point.\n     */\n    Ticker.prototype.stop = function () {\n        if (this.started) {\n            this.started = false;\n            this._cancelIfNeeded();\n        }\n    };\n    /**\n     * Destroy the ticker and don't use after this. Calling\n     * this method removes all references to internal events.\n     */\n    Ticker.prototype.destroy = function () {\n        if (!this._protected) {\n            this.stop();\n            var listener = this._head.next;\n            while (listener) {\n                listener = listener.destroy(true);\n            }\n            this._head.destroy();\n            this._head = null;\n        }\n    };\n    /**\n     * Triggers an update. An update entails setting the\n     * current {@link PIXI.Ticker#elapsedMS},\n     * the current {@link PIXI.Ticker#deltaTime},\n     * invoking all listeners with current deltaTime,\n     * and then finally setting {@link PIXI.Ticker#lastTime}\n     * with the value of currentTime that was provided.\n     * This method will be called automatically by animation\n     * frame callbacks if the ticker instance has been started\n     * and listeners are added.\n     *\n     * @param {number} [currentTime=performance.now()] - the current time of execution\n     */\n    Ticker.prototype.update = function (currentTime) {\n        if (currentTime === void 0) { currentTime = performance.now(); }\n        var elapsedMS;\n        // If the difference in time is zero or negative, we ignore most of the work done here.\n        // If there is no valid difference, then should be no reason to let anyone know about it.\n        // A zero delta, is exactly that, nothing should update.\n        //\n        // The difference in time can be negative, and no this does not mean time traveling.\n        // This can be the result of a race condition between when an animation frame is requested\n        // on the current JavaScript engine event loop, and when the ticker's start method is invoked\n        // (which invokes the internal _requestIfNeeded method). If a frame is requested before\n        // _requestIfNeeded is invoked, then the callback for the animation frame the ticker requests,\n        // can receive a time argument that can be less than the lastTime value that was set within\n        // _requestIfNeeded. This difference is in microseconds, but this is enough to cause problems.\n        //\n        // This check covers this browser engine timing issue, as well as if consumers pass an invalid\n        // currentTime value. This may happen if consumers opt-out of the autoStart, and update themselves.\n        if (currentTime > this.lastTime) {\n            // Save uncapped elapsedMS for measurement\n            elapsedMS = this.elapsedMS = currentTime - this.lastTime;\n            // cap the milliseconds elapsed used for deltaTime\n            if (elapsedMS > this._maxElapsedMS) {\n                elapsedMS = this._maxElapsedMS;\n            }\n            elapsedMS *= this.speed;\n            // If not enough time has passed, exit the function.\n            // Get ready for next frame by setting _lastFrame, but based on _minElapsedMS\n            // adjustment to ensure a relatively stable interval.\n            if (this._minElapsedMS) {\n                var delta = currentTime - this._lastFrame | 0;\n                if (delta < this._minElapsedMS) {\n                    return;\n                }\n                this._lastFrame = currentTime - (delta % this._minElapsedMS);\n            }\n            this.deltaMS = elapsedMS;\n            this.deltaTime = this.deltaMS * settings.settings.TARGET_FPMS;\n            // Cache a local reference, in-case ticker is destroyed\n            // during the emit, we can still check for head.next\n            var head = this._head;\n            // Invoke listeners added to internal emitter\n            var listener = head.next;\n            while (listener) {\n                listener = listener.emit(this.deltaTime);\n            }\n            if (!head.next) {\n                this._cancelIfNeeded();\n            }\n        }\n        else {\n            this.deltaTime = this.deltaMS = this.elapsedMS = 0;\n        }\n        this.lastTime = currentTime;\n    };\n    Object.defineProperty(Ticker.prototype, \"FPS\", {\n        /**\n         * The frames per second at which this ticker is running.\n         * The default is approximately 60 in most modern browsers.\n         * **Note:** This does not factor in the value of\n         * {@link PIXI.Ticker#speed}, which is specific\n         * to scaling {@link PIXI.Ticker#deltaTime}.\n         *\n         * @member {number}\n         * @readonly\n         */\n        get: function () {\n            return 1000 / this.elapsedMS;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Ticker.prototype, \"minFPS\", {\n        /**\n         * Manages the maximum amount of milliseconds allowed to\n         * elapse between invoking {@link PIXI.Ticker#update}.\n         * This value is used to cap {@link PIXI.Ticker#deltaTime},\n         * but does not effect the measured value of {@link PIXI.Ticker#FPS}.\n         * When setting this property it is clamped to a value between\n         * `0` and `PIXI.settings.TARGET_FPMS * 1000`.\n         *\n         * @member {number}\n         * @default 10\n         */\n        get: function () {\n            return 1000 / this._maxElapsedMS;\n        },\n        set: function (fps) {\n            // Minimum must be below the maxFPS\n            var minFPS = Math.min(this.maxFPS, fps);\n            // Must be at least 0, but below 1 / settings.TARGET_FPMS\n            var minFPMS = Math.min(Math.max(0, minFPS) / 1000, settings.settings.TARGET_FPMS);\n            this._maxElapsedMS = 1 / minFPMS;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Ticker.prototype, \"maxFPS\", {\n        /**\n         * Manages the minimum amount of milliseconds required to\n         * elapse between invoking {@link PIXI.Ticker#update}.\n         * This will effect the measured value of {@link PIXI.Ticker#FPS}.\n         * If it is set to `0`, then there is no limit; PixiJS will render as many frames as it can.\n         * Otherwise it will be at least `minFPS`\n         *\n         * @member {number}\n         * @default 0\n         */\n        get: function () {\n            if (this._minElapsedMS) {\n                return Math.round(1000 / this._minElapsedMS);\n            }\n            return 0;\n        },\n        set: function (fps) {\n            if (fps === 0) {\n                this._minElapsedMS = 0;\n            }\n            else {\n                // Max must be at least the minFPS\n                var maxFPS = Math.max(this.minFPS, fps);\n                this._minElapsedMS = 1 / (maxFPS / 1000);\n            }\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Ticker, \"shared\", {\n        /**\n         * The shared ticker instance used by {@link PIXI.AnimatedSprite} and by\n         * {@link PIXI.VideoResource} to update animation frames / video textures.\n         *\n         * It may also be used by {@link PIXI.Application} if created with the `sharedTicker` option property set to true.\n         *\n         * The property {@link PIXI.Ticker#autoStart} is set to `true` for this instance.\n         * Please follow the examples for usage, including how to opt-out of auto-starting the shared ticker.\n         *\n         * @example\n         * let ticker = PIXI.Ticker.shared;\n         * // Set this to prevent starting this ticker when listeners are added.\n         * // By default this is true only for the PIXI.Ticker.shared instance.\n         * ticker.autoStart = false;\n         * // FYI, call this to ensure the ticker is stopped. It should be stopped\n         * // if you have not attempted to render anything yet.\n         * ticker.stop();\n         * // Call this when you are ready for a running shared ticker.\n         * ticker.start();\n         *\n         * @example\n         * // You may use the shared ticker to render...\n         * let renderer = PIXI.autoDetectRenderer();\n         * let stage = new PIXI.Container();\n         * document.body.appendChild(renderer.view);\n         * ticker.add(function (time) {\n         *     renderer.render(stage);\n         * });\n         *\n         * @example\n         * // Or you can just update it manually.\n         * ticker.autoStart = false;\n         * ticker.stop();\n         * function animate(time) {\n         *     ticker.update(time);\n         *     renderer.render(stage);\n         *     requestAnimationFrame(animate);\n         * }\n         * animate(performance.now());\n         *\n         * @member {PIXI.Ticker}\n         * @static\n         */\n        get: function () {\n            if (!Ticker._shared) {\n                var shared = Ticker._shared = new Ticker();\n                shared.autoStart = true;\n                shared._protected = true;\n            }\n            return Ticker._shared;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    Object.defineProperty(Ticker, \"system\", {\n        /**\n         * The system ticker instance used by {@link PIXI.InteractionManager} and by\n         * {@link PIXI.BasePrepare} for core timing functionality that shouldn't usually need to be paused,\n         * unlike the `shared` ticker which drives visual animations and rendering which may want to be paused.\n         *\n         * The property {@link PIXI.Ticker#autoStart} is set to `true` for this instance.\n         *\n         * @member {PIXI.Ticker}\n         * @static\n         */\n        get: function () {\n            if (!Ticker._system) {\n                var system = Ticker._system = new Ticker();\n                system.autoStart = true;\n                system._protected = true;\n            }\n            return Ticker._system;\n        },\n        enumerable: false,\n        configurable: true\n    });\n    return Ticker;\n}());\n\n/**\n * Middleware for for Application Ticker.\n *\n * @example\n * import {TickerPlugin} from '@pixi/ticker';\n * import {Application} from '@pixi/app';\n * Application.registerPlugin(TickerPlugin);\n *\n * @class\n * @memberof PIXI\n */\nvar TickerPlugin = /** @class */ (function () {\n    function TickerPlugin() {\n    }\n    /**\n     * Initialize the plugin with scope of application instance\n     *\n     * @static\n     * @private\n     * @param {object} [options] - See application options\n     */\n    TickerPlugin.init = function (options) {\n        var _this = this;\n        // Set default\n        options = Object.assign({\n            autoStart: true,\n            sharedTicker: false,\n        }, options);\n        // Create ticker setter\n        Object.defineProperty(this, 'ticker', {\n            set: function (ticker) {\n                if (this._ticker) {\n                    this._ticker.remove(this.render, this);\n                }\n                this._ticker = ticker;\n                if (ticker) {\n                    ticker.add(this.render, this, exports.UPDATE_PRIORITY.LOW);\n                }\n            },\n            get: function () {\n                return this._ticker;\n            },\n        });\n        /**\n         * Convenience method for stopping the render.\n         *\n         * @method\n         * @memberof PIXI.Application\n         * @instance\n         */\n        this.stop = function () {\n            _this._ticker.stop();\n        };\n        /**\n         * Convenience method for starting the render.\n         *\n         * @method\n         * @memberof PIXI.Application\n         * @instance\n         */\n        this.start = function () {\n            _this._ticker.start();\n        };\n        /**\n         * Internal reference to the ticker.\n         *\n         * @type {PIXI.Ticker}\n         * @name _ticker\n         * @memberof PIXI.Application#\n         * @private\n         */\n        this._ticker = null;\n        /**\n         * Ticker for doing render updates.\n         *\n         * @type {PIXI.Ticker}\n         * @name ticker\n         * @memberof PIXI.Application#\n         * @default PIXI.Ticker.shared\n         */\n        this.ticker = options.sharedTicker ? Ticker.shared : new Ticker();\n        // Start the rendering\n        if (options.autoStart) {\n            this.start();\n        }\n    };\n    /**\n     * Clean up the ticker, scoped to application.\n     *\n     * @static\n     * @private\n     */\n    TickerPlugin.destroy = function () {\n        if (this._ticker) {\n            var oldTicker = this._ticker;\n            this.ticker = null;\n            oldTicker.destroy();\n        }\n    };\n    return TickerPlugin;\n}());\n\nexports.Ticker = Ticker;\nexports.TickerPlugin = TickerPlugin;\n//# sourceMappingURL=ticker.js.map\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$$pixi$settings$dist$cjs$settings","~$shadow.js"]],"~:properties",["^5",["stop","_shared","_protected","_system","started","priority","next","once","addOnce","shared","__esModule","_cancelIfNeeded","sharedTicker","elapsedMS","fn","count","update","_requestIfNeeded","_minElapsedMS","configurable","deltaMS","value","destroy","connect","enumerable","context","previous","emit","start","TARGET_FPMS","remove","_head","Ticker","ticker","FPS","_destroyed","match","init","UPDATE_PRIORITY","_startIfPossible","add","set","autoStart","_requestId","_maxElapsedMS","minFPS","system","_addListener","speed","get","maxFPS","_ticker","TickerPlugin","_lastFrame","lastTime","_tick","deltaTime"]],"~:compiled-at",1766065009638,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$pixi$ticker$dist$cjs$ticker.js\",\n\"lineCount\":11,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAU9DC,MAAOC,CAAAA,cAAP,CAAsBF,CAAtB,CAA+B,YAA/B,CAA6C,CAAEG,MAAO,CAAA,CAAT,CAA7C,CAEA,KAAIC,EAAWN,CAAA,CAAQ,GAAR,CAWfM,EAASA,CAAAA,QAASC,CAAAA,WAAlB,CAAgC,GAkB/B,UAAS,CAACC,CAAD,CAAkB,CACxBA,CAAA,CAAgBA,CAAA,CAAA,WAAhB,CAAiD,EAAjD,CAAA,CAAuD,aACvDA,EAAA,CAAgBA,CAAA,CAAA,IAAhB,CAA0C,EAA1C,CAAA,CAAgD,MAChDA,EAAA,CAAgBA,CAAA,CAAA,MAAhB,CAA4C,CAA5C,CAAA,CAAiD,QACjDA,EAAA,CAAgBA,CAAA,CAAA,GAAhB,CAAyC,CAAC,EAA1C,CAAA,CAAgD,KAChDA,EAAA,CAAgBA,CAAA,CAAA,OAAhB,CAA6C,CAAC,EAA9C,CAAA,CAAoD,SAL5B,CAA3B,CAAD,CAMGN,CAAQM,CAAAA,eANX,GAM+BN,CAAQM,CAAAA,eANvC,CAMyD,EANzD,EAeA,KAAIC,EAAgC,QAAS,EAAG,CAS5CA,QAASA,EAAc,CAACC,CAAD,CAAKC,CAAL,CAAcC,CAAd,CAAwBC,CAAxB,CAA8B,CACjC,IAAK,EAArB,GAAIF,CAAJ,GAA0BA,CAA1B,CAAoC,IAApC,CACiB,KAAK,EAAtB,GAAIC,CAAJ,GAA2BA,CAA3B,CAAsC,CAAtC,CACa,KAAK,EAAlB,GAAIC,CAAJ,GAAuBA,CAAvB,CAA8B,CAAA,CAA9B,CAIA,KAAKC,CAAAA,QAAL,CAFA,IAAKC,CAAAA,IAEL,CAFY,IAIZ,KAAKC,CAAAA,UAAL,CAAkB,CAAA,CAClB,KAAKN,CAAAA,EAAL,CAAUA,CACV,KAAKC,CAAAA,OAAL,CAAeA,CACf,KAAKC,CAAAA,QAAL,CAAgBA,CAChB,KAAKC,CAAAA,IAAL;AAAYA,CAbqC,CAsBrDJ,CAAeQ,CAAAA,SAAUC,CAAAA,KAAzB,CAAiCC,QAAS,CAACT,CAAD,CAAKC,CAAL,CAAc,CACpC,IAAK,EAArB,GAAIA,CAAJ,GAA0BA,CAA1B,CAAoC,IAApC,CACA,OAAO,KAAKD,CAAAA,EAAZ,GAAmBA,CAAnB,EAAyB,IAAKC,CAAAA,OAA9B,GAA0CA,CAFU,CAUxDF,EAAeQ,CAAAA,SAAUG,CAAAA,IAAzB,CAAgCC,QAAS,CAACC,CAAD,CAAY,CAC7C,IAAKZ,CAAAA,EAAT,GACQ,IAAKC,CAAAA,OAAT,CACI,IAAKD,CAAAA,EAAGa,CAAAA,IAAR,CAAa,IAAKZ,CAAAA,OAAlB,CAA2BW,CAA3B,CADJ,CAII,IAAKZ,CAAAA,EAAL,CAAQY,CAAR,CALR,CAQIE,EAAAA,CAAW,IAAKT,CAAAA,IAChB,KAAKF,CAAAA,IAAT,EACI,IAAKY,CAAAA,OAAL,CAAa,CAAA,CAAb,CAIA,KAAKT,CAAAA,UAAT,GACI,IAAKD,CAAAA,IADT,CACgB,IADhB,CAGA,OAAOS,EAlB0C,CAyBrDf,EAAeQ,CAAAA,SAAUS,CAAAA,OAAzB,CAAmCC,QAAS,CAACb,CAAD,CAAW,CACnD,IAAKA,CAAAA,QAAL,CAAgBA,CACZA,EAASC,CAAAA,IAAb,GACID,CAASC,CAAAA,IAAKD,CAAAA,QADlB,CAC6B,IAD7B,CAGA,KAAKC,CAAAA,IAAL,CAAYD,CAASC,CAAAA,IACrBD,EAASC,CAAAA,IAAT,CAAgB,IANmC,CAevDN,EAAeQ,CAAAA,SAAUQ,CAAAA,OAAzB,CAAmCG,QAAS,CAACC,CAAD,CAAO,CAClC,IAAK,EAAlB,GAAIA,CAAJ,GAAuBA,CAAvB,CAA8B,CAAA,CAA9B,CACA,KAAKb,CAAAA,UAAL,CAAkB,CAAA,CAElB,KAAKL,CAAAA,OAAL,CADA,IAAKD,CAAAA,EACL,CADU,IAGN,KAAKI,CAAAA,QAAT,GACI,IAAKA,CAAAA,QAASC,CAAAA,IADlB;AACyB,IAAKA,CAAAA,IAD9B,CAGI,KAAKA,CAAAA,IAAT,GACI,IAAKA,CAAAA,IAAKD,CAAAA,QADd,CACyB,IAAKA,CAAAA,QAD9B,CAIA,KAAIU,EAAW,IAAKT,CAAAA,IAEpB,KAAKA,CAAAA,IAAL,CAAYc,CAAA,CAAO,IAAP,CAAcL,CAC1B,KAAKV,CAAAA,QAAL,CAAgB,IAChB,OAAOU,EAjBwC,CAmBnD,OAAOf,EApGqC,CAAZ,EAApC,CAgHIqB,EAAwB,QAAS,EAAG,CACpCA,QAASA,EAAM,EAAG,CACd,IAAIC,EAAQ,IAMZ,KAAKC,CAAAA,SAAL,CAAiB,CAAA,CAOjB,KAAKV,CAAAA,SAAL,CAAiB,CAQjB,KAAKW,CAAAA,QAAL,CAAgB,CAAC,CAQjB,KAAKC,CAAAA,KAAL,CAAa,CASb,KAAKC,CAAAA,OAAL,CAAe,CAAA,CAEf,KAAKC,CAAAA,UAAL,CAAkB,IAKlB,KAAKC,CAAAA,aAAL,CAAqB,GAKrB,KAAKC,CAAAA,aAAL,CAAqB,CAErB,KAAKC,CAAAA,UAAL,CAAkB,CAAA,CAKlB,KAAKC,CAAAA,UAAL,CAAkB,CAAC,CACnB,KAAKC,CAAAA,KAAL,CAAa,IAAIhC,CAAJ,CAAmB,IAAnB,CAAyB,IAAzB,CAA+BiC,QAA/B,CACb,KAAKC,CAAAA,OAAL,CAAe,CAAf,CAAmBrC,CAASA,CAAAA,QAASC,CAAAA,WACrC,KAAKqC,CAAAA,SAAL,CAAiB,CAAjB,CAAqBtC,CAASA,CAAAA,QAASC,CAAAA,WACvC,KAAKsC,CAAAA,KAAL,CAAaC,QAAS,CAACC,CAAD,CAAO,CACzBhB,CAAMK,CAAAA,UAAN;AAAmB,IACfL,EAAMI,CAAAA,OAAV,GAEIJ,CAAMiB,CAAAA,MAAN,CAAaD,CAAb,CAEA,CAAIhB,CAAMI,CAAAA,OAAV,EAA0C,IAA1C,GAAqBJ,CAAMK,CAAAA,UAA3B,EAAkDL,CAAMU,CAAAA,KAAM1B,CAAAA,IAA9D,GACIgB,CAAMK,CAAAA,UADV,CACuBa,qBAAA,CAAsBlB,CAAMc,CAAAA,KAA5B,CADvB,CAJJ,CAFyB,CA9Df,CAiFlBf,CAAOb,CAAAA,SAAUiC,CAAAA,gBAAjB,CAAoCC,QAAS,EAAG,CACpB,IAAxB,GAAI,IAAKf,CAAAA,UAAT,EAAgC,IAAKK,CAAAA,KAAM1B,CAAAA,IAA3C,GAGI,IAAKyB,CAAAA,UACL,CAFA,IAAKP,CAAAA,QAEL,CAFgBmB,WAAYC,CAAAA,GAAZ,EAEhB,CAAA,IAAKjB,CAAAA,UAAL,CAAkBa,qBAAA,CAAsB,IAAKJ,CAAAA,KAA3B,CAJtB,CAD4C,CAYhDf,EAAOb,CAAAA,SAAUqC,CAAAA,eAAjB,CAAmCC,QAAS,EAAG,CACnB,IAAxB,GAAI,IAAKnB,CAAAA,UAAT,GACIoB,oBAAA,CAAqB,IAAKpB,CAAAA,UAA1B,CACA,CAAA,IAAKA,CAAAA,UAAL,CAAkB,IAFtB,CAD2C,CAgB/CN,EAAOb,CAAAA,SAAUwC,CAAAA,gBAAjB,CAAoCC,QAAS,EAAG,CACxC,IAAKvB,CAAAA,OAAT,CACI,IAAKe,CAAAA,gBAAL,EADJ;AAGS,IAAKlB,CAAAA,SAHd,EAII,IAAK2B,CAAAA,KAAL,EALwC,CAiBhD7B,EAAOb,CAAAA,SAAU2C,CAAAA,GAAjB,CAAuBC,QAAS,CAACnD,CAAD,CAAKC,CAAL,CAAcC,CAAd,CAAwB,CACnC,IAAK,EAAtB,GAAIA,CAAJ,GAA2BA,CAA3B,CAAsCV,CAAQM,CAAAA,eAAgBsD,CAAAA,MAA9D,CACA,OAAO,KAAKC,CAAAA,YAAL,CAAkB,IAAItD,CAAJ,CAAmBC,CAAnB,CAAuBC,CAAvB,CAAgCC,CAAhC,CAAlB,CAF6C,CAYxDkB,EAAOb,CAAAA,SAAU+C,CAAAA,OAAjB,CAA2BC,QAAS,CAACvD,CAAD,CAAKC,CAAL,CAAcC,CAAd,CAAwB,CACvC,IAAK,EAAtB,GAAIA,CAAJ,GAA2BA,CAA3B,CAAsCV,CAAQM,CAAAA,eAAgBsD,CAAAA,MAA9D,CACA,OAAO,KAAKC,CAAAA,YAAL,CAAkB,IAAItD,CAAJ,CAAmBC,CAAnB,CAAuBC,CAAvB,CAAgCC,CAAhC,CAA0C,CAAA,CAA1C,CAAlB,CAFiD,CAa5DkB,EAAOb,CAAAA,SAAU8C,CAAAA,YAAjB,CAAgCG,QAAS,CAACC,CAAD,CAAW,CAEhD,IAAIC,EAAU,IAAK3B,CAAAA,KAAM1B,CAAAA,IAAzB,CACID,EAAW,IAAK2B,CAAAA,KAEpB,IAAK2B,CAAL,CAGK,CAED,IAAA,CAAOA,CAAP,CAAA,CAAgB,CACZ,GAAID,CAASvD,CAAAA,QAAb,CAAwBwD,CAAQxD,CAAAA,QAAhC,CAA0C,CACtCuD,CAASzC,CAAAA,OAAT,CAAiBZ,CAAjB,CACA,MAFsC,CAI1CA,CAAA,CAAWsD,CACXA,EAAA,CAAUA,CAAQrD,CAAAA,IANN,CASXoD,CAASrD,CAAAA,QAAd,EACIqD,CAASzC,CAAAA,OAAT,CAAiBZ,CAAjB,CAZH,CAHL,IACIqD,EAASzC,CAAAA,OAAT,CAAiBZ,CAAjB,CAiBJ,KAAK2C,CAAAA,gBAAL,EACA,OAAO,KAxByC,CAkCpD3B,EAAOb,CAAAA,SAAUoD,CAAAA,MAAjB;AAA0BC,QAAS,CAAC5D,CAAD,CAAKC,CAAL,CAAc,CAE7C,IADA,IAAIwD,EAAW,IAAK1B,CAAAA,KAAM1B,CAAAA,IAC1B,CAAOoD,CAAP,CAAA,CAKQA,CAAA,CADAA,CAASjD,CAAAA,KAAT,CAAeR,CAAf,CAAmBC,CAAnB,CAAJ,CACewD,CAAS1C,CAAAA,OAAT,EADf,CAIe0C,CAASpD,CAAAA,IAGvB,KAAK0B,CAAAA,KAAM1B,CAAAA,IAAhB,EACI,IAAKuC,CAAAA,eAAL,EAEJ,OAAO,KAhBsC,CAkBjDnD,OAAOC,CAAAA,cAAP,CAAsB0B,CAAOb,CAAAA,SAA7B,CAAwC,OAAxC,CAAiD,CAO7CsD,IAAKA,QAAS,EAAG,CACb,GAAI,CAAC,IAAK9B,CAAAA,KAAV,CACI,MAAO,EAIX,KAFA,IAAI+B,EAAQ,CAAZ,CACIJ,EAAU,IAAK3B,CAAAA,KACnB,CAAQ2B,CAAR,CAAkBA,CAAQrD,CAAAA,IAA1B,CAAA,CACIyD,CAAA,EAEJ,OAAOA,EATM,CAP4B,CAkB7CC,WAAY,CAAA,CAlBiC,CAmB7CC,aAAc,CAAA,CAnB+B,CAAjD,CAyBA5C,EAAOb,CAAAA,SAAU0C,CAAAA,KAAjB,CAAyBgB,QAAS,EAAG,CAC5B,IAAKxC,CAAAA,OAAV,GACI,IAAKA,CAAAA,OACL,CADe,CAAA,CACf,CAAA,IAAKe,CAAAA,gBAAL,EAFJ,CADiC,CAUrCpB,EAAOb,CAAAA,SAAU2D,CAAAA,IAAjB,CAAwBC,QAAS,EAAG,CAC5B,IAAK1C,CAAAA,OAAT,GACI,IAAKA,CAAAA,OACL,CADe,CAAA,CACf,CAAA,IAAKmB,CAAAA,eAAL,EAFJ,CADgC,CAUpCxB,EAAOb,CAAAA,SAAUQ,CAAAA,OAAjB,CAA2BqD,QAAS,EAAG,CACnC,GAAI,CAAC,IAAKvC,CAAAA,UAAV,CAAsB,CAClB,IAAKqC,CAAAA,IAAL,EAEA;IADA,IAAIT,EAAW,IAAK1B,CAAAA,KAAM1B,CAAAA,IAC1B,CAAOoD,CAAP,CAAA,CACIA,CAAA,CAAWA,CAAS1C,CAAAA,OAAT,CAAiB,CAAA,CAAjB,CAEf,KAAKgB,CAAAA,KAAMhB,CAAAA,OAAX,EACA,KAAKgB,CAAAA,KAAL,CAAa,IAPK,CADa,CAwBvCX,EAAOb,CAAAA,SAAU+B,CAAAA,MAAjB,CAA0B+B,QAAS,CAACC,CAAD,CAAc,CACzB,IAAK,EAAzB,GAAIA,CAAJ,GAA8BA,CAA9B,CAA4C5B,WAAYC,CAAAA,GAAZ,EAA5C,CAgBA,IAAI2B,CAAJ,CAAkB,IAAK/C,CAAAA,QAAvB,CAAiC,CAE7B,IAAAW,EAAY,IAAKA,CAAAA,SAAjBA,CAA6BoC,CAA7BpC,CAA2C,IAAKX,CAAAA,QAE5CW,EAAJ,CAAgB,IAAKP,CAAAA,aAArB,GACIO,CADJ,CACgB,IAAKP,CAAAA,aADrB,CAGAO,EAAA,EAAa,IAAKV,CAAAA,KAIlB,IAAI,IAAKI,CAAAA,aAAT,CAAwB,CACpB,IAAI2C,EAAQD,CAARC,CAAsB,IAAKzC,CAAAA,UAA3ByC,CAAwC,CAC5C,IAAIA,CAAJ,CAAY,IAAK3C,CAAAA,aAAjB,CACI,MAEJ,KAAKE,CAAAA,UAAL,CAAkBwC,CAAlB,CAAiCC,CAAjC,CAAyC,IAAK3C,CAAAA,aAL1B,CAOxB,IAAKK,CAAAA,OAAL,CAAeC,CACf,KAAKtB,CAAAA,SAAL,CAAiB,IAAKqB,CAAAA,OAAtB,CAAgCrC,CAASA,CAAAA,QAASC,CAAAA,WAG9C2E,EAAAA,CAAO,IAAKzC,CAAAA,KAGhB,KADI0B,CACJ,CADee,CAAKnE,CAAAA,IACpB,CAAOoD,CAAP,CAAA,CACIA,CAAA,CAAWA,CAAS/C,CAAAA,IAAT,CAAc,IAAKE,CAAAA,SAAnB,CAEV4D;CAAKnE,CAAAA,IAAV,EACI,IAAKuC,CAAAA,eAAL,EA7ByB,CAAjC,IAiCI,KAAKhC,CAAAA,SAAL,CAAiB,IAAKqB,CAAAA,OAAtB,CAAgC,IAAKC,CAAAA,SAArC,CAAiD,CAErD,KAAKX,CAAAA,QAAL,CAAgB+C,CApD6B,CAsDjD7E,OAAOC,CAAAA,cAAP,CAAsB0B,CAAOb,CAAAA,SAA7B,CAAwC,KAAxC,CAA+C,CAW3CsD,IAAKA,QAAS,EAAG,CACb,MAAO,IAAP,CAAc,IAAK3B,CAAAA,SADN,CAX0B,CAc3C6B,WAAY,CAAA,CAd+B,CAe3CC,aAAc,CAAA,CAf6B,CAA/C,CAiBAvE,OAAOC,CAAAA,cAAP,CAAsB0B,CAAOb,CAAAA,SAA7B,CAAwC,QAAxC,CAAkD,CAY9CsD,IAAKA,QAAS,EAAG,CACb,MAAO,IAAP,CAAc,IAAKlC,CAAAA,aADN,CAZ6B,CAe9C8C,IAAKA,QAAS,CAACC,CAAD,CAAM,CAKhB,IAAK/C,CAAAA,aAAL,CAAqB,CAArB,CADcgD,IAAKC,CAAAA,GAALC,CAASF,IAAKG,CAAAA,GAAL,CAAS,CAAT,CAFVH,IAAKC,CAAAA,GAALG,CAAS,IAAKC,CAAAA,MAAdD,CAAsBL,CAAtBK,CAEU,CAATF,CAA+B,GAA/BA,CAAqCjF,CAASA,CAAAA,QAASC,CAAAA,WAAvDgF,CAJE,CAf0B,CAsB9Cd,WAAY,CAAA,CAtBkC,CAuB9CC,aAAc,CAAA,CAvBgC,CAAlD,CAyBAvE,OAAOC,CAAAA,cAAP,CAAsB0B,CAAOb,CAAAA,SAA7B,CAAwC,QAAxC,CAAkD,CAW9CsD,IAAKA,QAAS,EAAG,CACb,MAAI,KAAKjC,CAAAA,aAAT;AACW+C,IAAKM,CAAAA,KAAL,CAAW,GAAX,CAAkB,IAAKrD,CAAAA,aAAvB,CADX,CAGO,CAJM,CAX6B,CAiB9C6C,IAAKA,QAAS,CAACC,CAAD,CAAM,CAEZ,IAAK9C,CAAAA,aAAL,CADQ,CAAZ,GAAI8C,CAAJ,CACyB,CADzB,CAMyB,CANzB,EAKiBC,IAAKG,CAAAA,GAALE,CAAS,IAAKD,CAAAA,MAAdC,CAAsBN,CAAtBM,CALjB,CAMuC,GANvC,CADgB,CAjB0B,CA2B9CjB,WAAY,CAAA,CA3BkC,CA4B9CC,aAAc,CAAA,CA5BgC,CAAlD,CA8BAvE,OAAOC,CAAAA,cAAP,CAAsB0B,CAAtB,CAA8B,QAA9B,CAAwC,CA4CpCyC,IAAKA,QAAS,EAAG,CACb,GAAI,CAACzC,CAAO8D,CAAAA,OAAZ,CAAqB,CACjB,IAAIC,EAAS/D,CAAO8D,CAAAA,OAAhBC,CAA0B,IAAI/D,CAClC+D,EAAO7D,CAAAA,SAAP,CAAmB,CAAA,CACnB6D,EAAOtD,CAAAA,UAAP,CAAoB,CAAA,CAHH,CAKrB,MAAOT,EAAO8D,CAAAA,OAND,CA5CmB,CAoDpCnB,WAAY,CAAA,CApDwB,CAqDpCC,aAAc,CAAA,CArDsB,CAAxC,CAuDAvE,OAAOC,CAAAA,cAAP,CAAsB0B,CAAtB,CAA8B,QAA9B,CAAwC,CAWpCyC,IAAKA,QAAS,EAAG,CACb,GAAI,CAACzC,CAAOgE,CAAAA,OAAZ,CAAqB,CACjB,IAAIC,EAASjE,CAAOgE,CAAAA,OAAhBC,CAA0B,IAAIjE,CAClCiE,EAAO/D,CAAAA,SAAP,CAAmB,CAAA,CACnB+D,EAAOxD,CAAAA,UAAP,CAAoB,CAAA,CAHH,CAKrB,MAAOT,EAAOgE,CAAAA,OAND,CAXmB,CAmBpCrB,WAAY,CAAA,CAnBwB,CAoBpCC,aAAc,CAAA,CApBsB,CAAxC,CAsBA,OAAO5C,EA5d6B,CAAZ,EA0exBkE,GAAAA,CAA8B,QAAS,EAAG,CAC1CA,QAASA,EAAY,EAAG;AASxBA,CAAaC,CAAAA,IAAb,CAAoBC,QAAS,CAACC,CAAD,CAAU,CACnC,IAAIpE,EAAQ,IAEZoE,EAAA,CAAUhG,MAAOiG,CAAAA,MAAP,CAAc,CACpBpE,UAAW,CAAA,CADS,CAEpBqE,aAAc,CAAA,CAFM,CAAd,CAGPF,CAHO,CAKVhG,OAAOC,CAAAA,cAAP,CAAsB,IAAtB,CAA4B,QAA5B,CAAsC,CAClC+E,IAAKA,QAAS,CAACmB,CAAD,CAAS,CACf,IAAKC,CAAAA,OAAT,EACI,IAAKA,CAAAA,OAAQlC,CAAAA,MAAb,CAAoB,IAAKmC,CAAAA,MAAzB,CAAiC,IAAjC,CAGJ,EADA,IAAKD,CAAAA,OACL,CADeD,CACf,GACIA,CAAO1C,CAAAA,GAAP,CAAW,IAAK4C,CAAAA,MAAhB,CAAwB,IAAxB,CAA8BtG,CAAQM,CAAAA,eAAgBiG,CAAAA,GAAtD,CANe,CADW,CAUlClC,IAAKA,QAAS,EAAG,CACb,MAAO,KAAKgC,CAAAA,OADC,CAViB,CAAtC,CAqBA,KAAK3B,CAAAA,IAAL,CAAY8B,QAAS,EAAG,CACpB3E,CAAMwE,CAAAA,OAAQ3B,CAAAA,IAAd,EADoB,CAUxB,KAAKjB,CAAAA,KAAL,CAAagD,QAAS,EAAG,CACrB5E,CAAMwE,CAAAA,OAAQ5C,CAAAA,KAAd,EADqB,CAWzB,KAAK4C,CAAAA,OAAL,CAAe,IASf,KAAKD,CAAAA,MAAL,CAAcH,CAAQE,CAAAA,YAAR,CAAuBvE,CAAO+D,CAAAA,MAA9B,CAAuC,IAAI/D,CAErDqE,EAAQnE,CAAAA,SAAZ,EACI,IAAK2B,CAAAA,KAAL,EA9D+B,CAuEvCqC,EAAavE,CAAAA,OAAb,CAAuBmF,QAAS,EAAG,CAC/B,GAAI,IAAKL,CAAAA,OAAT,CAAkB,CACd,IAAIM,EAAY,IAAKN,CAAAA,OACrB;IAAKD,CAAAA,MAAL,CAAc,IACdO,EAAUpF,CAAAA,OAAV,EAHc,CADa,CAOnC,OAAOuE,EAxFmC,CAAZ,EA2FlC9F,EAAQ4B,CAAAA,MAAR,CAAiBA,CACjB5B,EAAQ8F,CAAAA,YAAR,CAAuBA,EA9uBuC;\",\n\"sources\":[\"node_modules/@pixi/ticker/dist/cjs/ticker.js\"],\n\"sourcesContent\":[\"shadow$provide[356] = function(global,require,module,exports) {\\n/*!\\n * @pixi/ticker - v6.2.0\\n * Compiled Mon, 01 Nov 2021 16:52:10 UTC\\n *\\n * @pixi/ticker is licensed under the MIT License.\\n * http://www.opensource.org/licenses/mit-license\\n */\\n'use strict';\\n\\nObject.defineProperty(exports, '__esModule', { value: true });\\n\\nvar settings = require('@pixi/settings');\\n\\n/**\\n * Target frames per millisecond.\\n *\\n * @static\\n * @name TARGET_FPMS\\n * @memberof PIXI.settings\\n * @type {number}\\n * @default 0.06\\n */\\nsettings.settings.TARGET_FPMS = 0.06;\\n\\n/**\\n * Represents the update priorities used by internal PIXI classes when registered with\\n * the {@link PIXI.Ticker} object. Higher priority items are updated first and lower\\n * priority items, such as render, should go later.\\n *\\n * @static\\n * @constant\\n * @name UPDATE_PRIORITY\\n * @memberof PIXI\\n * @enum {number}\\n * @property {number} INTERACTION=50 Highest priority, used for {@link PIXI.InteractionManager}\\n * @property {number} HIGH=25 High priority updating, {@link PIXI.VideoBaseTexture} and {@link PIXI.AnimatedSprite}\\n * @property {number} NORMAL=0 Default priority for ticker events, see {@link PIXI.Ticker#add}.\\n * @property {number} LOW=-25 Low priority used for {@link PIXI.Application} rendering.\\n * @property {number} UTILITY=-50 Lowest priority used for {@link PIXI.BasePrepare} utility.\\n */\\n(function (UPDATE_PRIORITY) {\\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\\\"INTERACTION\\\"] = 50] = \\\"INTERACTION\\\";\\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\\\"HIGH\\\"] = 25] = \\\"HIGH\\\";\\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\\\"NORMAL\\\"] = 0] = \\\"NORMAL\\\";\\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\\\"LOW\\\"] = -25] = \\\"LOW\\\";\\n    UPDATE_PRIORITY[UPDATE_PRIORITY[\\\"UTILITY\\\"] = -50] = \\\"UTILITY\\\";\\n})(exports.UPDATE_PRIORITY || (exports.UPDATE_PRIORITY = {}));\\n\\n/**\\n * Internal class for handling the priority sorting of ticker handlers.\\n *\\n * @private\\n * @class\\n * @memberof PIXI\\n */\\nvar TickerListener = /** @class */ (function () {\\n    /**\\n     * Constructor\\n     * @private\\n     * @param fn - The listener function to be added for one update\\n     * @param context - The listener context\\n     * @param priority - The priority for emitting\\n     * @param once - If the handler should fire once\\n     */\\n    function TickerListener(fn, context, priority, once) {\\n        if (context === void 0) { context = null; }\\n        if (priority === void 0) { priority = 0; }\\n        if (once === void 0) { once = false; }\\n        /** The next item in chain. */\\n        this.next = null;\\n        /** The previous item in chain. */\\n        this.previous = null;\\n        /** `true` if this listener has been destroyed already. */\\n        this._destroyed = false;\\n        this.fn = fn;\\n        this.context = context;\\n        this.priority = priority;\\n        this.once = once;\\n    }\\n    /**\\n     * Simple compare function to figure out if a function and context match.\\n     * @private\\n     * @param fn - The listener function to be added for one update\\n     * @param context - The listener context\\n     * @return `true` if the listener match the arguments\\n     */\\n    TickerListener.prototype.match = function (fn, context) {\\n        if (context === void 0) { context = null; }\\n        return this.fn === fn && this.context === context;\\n    };\\n    /**\\n     * Emit by calling the current function.\\n     * @private\\n     * @param deltaTime - time since the last emit.\\n     * @return Next ticker\\n     */\\n    TickerListener.prototype.emit = function (deltaTime) {\\n        if (this.fn) {\\n            if (this.context) {\\n                this.fn.call(this.context, deltaTime);\\n            }\\n            else {\\n                this.fn(deltaTime);\\n            }\\n        }\\n        var redirect = this.next;\\n        if (this.once) {\\n            this.destroy(true);\\n        }\\n        // Soft-destroying should remove\\n        // the next reference\\n        if (this._destroyed) {\\n            this.next = null;\\n        }\\n        return redirect;\\n    };\\n    /**\\n     * Connect to the list.\\n     * @private\\n     * @param previous - Input node, previous listener\\n     */\\n    TickerListener.prototype.connect = function (previous) {\\n        this.previous = previous;\\n        if (previous.next) {\\n            previous.next.previous = this;\\n        }\\n        this.next = previous.next;\\n        previous.next = this;\\n    };\\n    /**\\n     * Destroy and don't use after this.\\n     * @private\\n     * @param hard - `true` to remove the `next` reference, this\\n     *        is considered a hard destroy. Soft destroy maintains the next reference.\\n     * @return The listener to redirect while emitting or removing.\\n     */\\n    TickerListener.prototype.destroy = function (hard) {\\n        if (hard === void 0) { hard = false; }\\n        this._destroyed = true;\\n        this.fn = null;\\n        this.context = null;\\n        // Disconnect, hook up next and previous\\n        if (this.previous) {\\n            this.previous.next = this.next;\\n        }\\n        if (this.next) {\\n            this.next.previous = this.previous;\\n        }\\n        // Redirect to the next item\\n        var redirect = this.next;\\n        // Remove references\\n        this.next = hard ? null : redirect;\\n        this.previous = null;\\n        return redirect;\\n    };\\n    return TickerListener;\\n}());\\n\\n/**\\n * A Ticker class that runs an update loop that other objects listen to.\\n *\\n * This class is composed around listeners meant for execution on the next requested animation frame.\\n * Animation frames are requested only when necessary, e.g. When the ticker is started and the emitter has listeners.\\n *\\n * @class\\n * @memberof PIXI\\n */\\nvar Ticker = /** @class */ (function () {\\n    function Ticker() {\\n        var _this = this;\\n        /**\\n         * Whether or not this ticker should invoke the method\\n         * {@link PIXI.Ticker#start} automatically\\n         * when a listener is added.\\n         */\\n        this.autoStart = false;\\n        /**\\n         * Scalar time value from last frame to this frame.\\n         * This value is capped by setting {@link PIXI.Ticker#minFPS}\\n         * and is scaled with {@link PIXI.Ticker#speed}.\\n         * **Note:** The cap may be exceeded by scaling.\\n         */\\n        this.deltaTime = 1;\\n        /**\\n         * The last time {@link PIXI.Ticker#update} was invoked.\\n         * This value is also reset internally outside of invoking\\n         * update, but only when a new animation frame is requested.\\n         * If the platform supports DOMHighResTimeStamp,\\n         * this value will have a precision of 1 \\u00b5s.\\n         */\\n        this.lastTime = -1;\\n        /**\\n         * Factor of current {@link PIXI.Ticker#deltaTime}.\\n         * @example\\n         * // Scales ticker.deltaTime to what would be\\n         * // the equivalent of approximately 120 FPS\\n         * ticker.speed = 2;\\n         */\\n        this.speed = 1;\\n        /**\\n         * Whether or not this ticker has been started.\\n         * `true` if {@link PIXI.Ticker#start} has been called.\\n         * `false` if {@link PIXI.Ticker#stop} has been called.\\n         * While `false`, this value may change to `true` in the\\n         * event of {@link PIXI.Ticker#autoStart} being `true`\\n         * and a listener is added.\\n         */\\n        this.started = false;\\n        /** Internal current frame request ID */\\n        this._requestId = null;\\n        /**\\n         * Internal value managed by minFPS property setter and getter.\\n         * This is the maximum allowed milliseconds between updates.\\n         */\\n        this._maxElapsedMS = 100;\\n        /**\\n         * Internal value managed by minFPS property setter and getter.\\n         * This is the maximum allowed milliseconds between updates.\\n         */\\n        this._minElapsedMS = 0;\\n        /** If enabled, deleting is disabled.*/\\n        this._protected = false;\\n        /**\\n         * The last time keyframe was executed.\\n         * Maintains a relatively fixed interval with the previous value.\\n         */\\n        this._lastFrame = -1;\\n        this._head = new TickerListener(null, null, Infinity);\\n        this.deltaMS = 1 / settings.settings.TARGET_FPMS;\\n        this.elapsedMS = 1 / settings.settings.TARGET_FPMS;\\n        this._tick = function (time) {\\n            _this._requestId = null;\\n            if (_this.started) {\\n                // Invoke listeners now\\n                _this.update(time);\\n                // Listener side effects may have modified ticker state.\\n                if (_this.started && _this._requestId === null && _this._head.next) {\\n                    _this._requestId = requestAnimationFrame(_this._tick);\\n                }\\n            }\\n        };\\n    }\\n    /**\\n     * Conditionally requests a new animation frame.\\n     * If a frame has not already been requested, and if the internal\\n     * emitter has listeners, a new frame is requested.\\n     *\\n     * @private\\n     */\\n    Ticker.prototype._requestIfNeeded = function () {\\n        if (this._requestId === null && this._head.next) {\\n            // ensure callbacks get correct delta\\n            this.lastTime = performance.now();\\n            this._lastFrame = this.lastTime;\\n            this._requestId = requestAnimationFrame(this._tick);\\n        }\\n    };\\n    /**\\n     * Conditionally cancels a pending animation frame.\\n     * @private\\n     */\\n    Ticker.prototype._cancelIfNeeded = function () {\\n        if (this._requestId !== null) {\\n            cancelAnimationFrame(this._requestId);\\n            this._requestId = null;\\n        }\\n    };\\n    /**\\n     * Conditionally requests a new animation frame.\\n     * If the ticker has been started it checks if a frame has not already\\n     * been requested, and if the internal emitter has listeners. If these\\n     * conditions are met, a new frame is requested. If the ticker has not\\n     * been started, but autoStart is `true`, then the ticker starts now,\\n     * and continues with the previous conditions to request a new frame.\\n     *\\n     * @private\\n     */\\n    Ticker.prototype._startIfPossible = function () {\\n        if (this.started) {\\n            this._requestIfNeeded();\\n        }\\n        else if (this.autoStart) {\\n            this.start();\\n        }\\n    };\\n    /**\\n     * Register a handler for tick events. Calls continuously unless\\n     * it is removed or the ticker is stopped.\\n     *\\n     * @param fn - The listener function to be added for updates\\n     * @param context - The listener context\\n     * @param {number} [priority=PIXI.UPDATE_PRIORITY.NORMAL] - The priority for emitting\\n     * @returns This instance of a ticker\\n     */\\n    Ticker.prototype.add = function (fn, context, priority) {\\n        if (priority === void 0) { priority = exports.UPDATE_PRIORITY.NORMAL; }\\n        return this._addListener(new TickerListener(fn, context, priority));\\n    };\\n    /**\\n     * Add a handler for the tick event which is only execute once.\\n     *\\n     * @param fn - The listener function to be added for one update\\n     * @param context - The listener context\\n     * @param {number} [priority=PIXI.UPDATE_PRIORITY.NORMAL] - The priority for emitting\\n     * @returns This instance of a ticker\\n     */\\n    Ticker.prototype.addOnce = function (fn, context, priority) {\\n        if (priority === void 0) { priority = exports.UPDATE_PRIORITY.NORMAL; }\\n        return this._addListener(new TickerListener(fn, context, priority, true));\\n    };\\n    /**\\n     * Internally adds the event handler so that it can be sorted by priority.\\n     * Priority allows certain handler (user, AnimatedSprite, Interaction) to be run\\n     * before the rendering.\\n     *\\n     * @private\\n     * @param listener - Current listener being added.\\n     * @returns This instance of a ticker\\n     */\\n    Ticker.prototype._addListener = function (listener) {\\n        // For attaching to head\\n        var current = this._head.next;\\n        var previous = this._head;\\n        // Add the first item\\n        if (!current) {\\n            listener.connect(previous);\\n        }\\n        else {\\n            // Go from highest to lowest priority\\n            while (current) {\\n                if (listener.priority > current.priority) {\\n                    listener.connect(previous);\\n                    break;\\n                }\\n                previous = current;\\n                current = current.next;\\n            }\\n            // Not yet connected\\n            if (!listener.previous) {\\n                listener.connect(previous);\\n            }\\n        }\\n        this._startIfPossible();\\n        return this;\\n    };\\n    /**\\n     * Removes any handlers matching the function and context parameters.\\n     * If no handlers are left after removing, then it cancels the animation frame.\\n     *\\n     * @param fn - The listener function to be removed\\n     * @param context - The listener context to be removed\\n     * @returns This instance of a ticker\\n     */\\n    Ticker.prototype.remove = function (fn, context) {\\n        var listener = this._head.next;\\n        while (listener) {\\n            // We found a match, lets remove it\\n            // no break to delete all possible matches\\n            // incase a listener was added 2+ times\\n            if (listener.match(fn, context)) {\\n                listener = listener.destroy();\\n            }\\n            else {\\n                listener = listener.next;\\n            }\\n        }\\n        if (!this._head.next) {\\n            this._cancelIfNeeded();\\n        }\\n        return this;\\n    };\\n    Object.defineProperty(Ticker.prototype, \\\"count\\\", {\\n        /**\\n         * The number of listeners on this ticker, calculated by walking through linked list\\n         *\\n         * @readonly\\n         * @member {number}\\n         */\\n        get: function () {\\n            if (!this._head) {\\n                return 0;\\n            }\\n            var count = 0;\\n            var current = this._head;\\n            while ((current = current.next)) {\\n                count++;\\n            }\\n            return count;\\n        },\\n        enumerable: false,\\n        configurable: true\\n    });\\n    /**\\n     * Starts the ticker. If the ticker has listeners\\n     * a new animation frame is requested at this point.\\n     */\\n    Ticker.prototype.start = function () {\\n        if (!this.started) {\\n            this.started = true;\\n            this._requestIfNeeded();\\n        }\\n    };\\n    /**\\n     * Stops the ticker. If the ticker has requested\\n     * an animation frame it is canceled at this point.\\n     */\\n    Ticker.prototype.stop = function () {\\n        if (this.started) {\\n            this.started = false;\\n            this._cancelIfNeeded();\\n        }\\n    };\\n    /**\\n     * Destroy the ticker and don't use after this. Calling\\n     * this method removes all references to internal events.\\n     */\\n    Ticker.prototype.destroy = function () {\\n        if (!this._protected) {\\n            this.stop();\\n            var listener = this._head.next;\\n            while (listener) {\\n                listener = listener.destroy(true);\\n            }\\n            this._head.destroy();\\n            this._head = null;\\n        }\\n    };\\n    /**\\n     * Triggers an update. An update entails setting the\\n     * current {@link PIXI.Ticker#elapsedMS},\\n     * the current {@link PIXI.Ticker#deltaTime},\\n     * invoking all listeners with current deltaTime,\\n     * and then finally setting {@link PIXI.Ticker#lastTime}\\n     * with the value of currentTime that was provided.\\n     * This method will be called automatically by animation\\n     * frame callbacks if the ticker instance has been started\\n     * and listeners are added.\\n     *\\n     * @param {number} [currentTime=performance.now()] - the current time of execution\\n     */\\n    Ticker.prototype.update = function (currentTime) {\\n        if (currentTime === void 0) { currentTime = performance.now(); }\\n        var elapsedMS;\\n        // If the difference in time is zero or negative, we ignore most of the work done here.\\n        // If there is no valid difference, then should be no reason to let anyone know about it.\\n        // A zero delta, is exactly that, nothing should update.\\n        //\\n        // The difference in time can be negative, and no this does not mean time traveling.\\n        // This can be the result of a race condition between when an animation frame is requested\\n        // on the current JavaScript engine event loop, and when the ticker's start method is invoked\\n        // (which invokes the internal _requestIfNeeded method). If a frame is requested before\\n        // _requestIfNeeded is invoked, then the callback for the animation frame the ticker requests,\\n        // can receive a time argument that can be less than the lastTime value that was set within\\n        // _requestIfNeeded. This difference is in microseconds, but this is enough to cause problems.\\n        //\\n        // This check covers this browser engine timing issue, as well as if consumers pass an invalid\\n        // currentTime value. This may happen if consumers opt-out of the autoStart, and update themselves.\\n        if (currentTime > this.lastTime) {\\n            // Save uncapped elapsedMS for measurement\\n            elapsedMS = this.elapsedMS = currentTime - this.lastTime;\\n            // cap the milliseconds elapsed used for deltaTime\\n            if (elapsedMS > this._maxElapsedMS) {\\n                elapsedMS = this._maxElapsedMS;\\n            }\\n            elapsedMS *= this.speed;\\n            // If not enough time has passed, exit the function.\\n            // Get ready for next frame by setting _lastFrame, but based on _minElapsedMS\\n            // adjustment to ensure a relatively stable interval.\\n            if (this._minElapsedMS) {\\n                var delta = currentTime - this._lastFrame | 0;\\n                if (delta < this._minElapsedMS) {\\n                    return;\\n                }\\n                this._lastFrame = currentTime - (delta % this._minElapsedMS);\\n            }\\n            this.deltaMS = elapsedMS;\\n            this.deltaTime = this.deltaMS * settings.settings.TARGET_FPMS;\\n            // Cache a local reference, in-case ticker is destroyed\\n            // during the emit, we can still check for head.next\\n            var head = this._head;\\n            // Invoke listeners added to internal emitter\\n            var listener = head.next;\\n            while (listener) {\\n                listener = listener.emit(this.deltaTime);\\n            }\\n            if (!head.next) {\\n                this._cancelIfNeeded();\\n            }\\n        }\\n        else {\\n            this.deltaTime = this.deltaMS = this.elapsedMS = 0;\\n        }\\n        this.lastTime = currentTime;\\n    };\\n    Object.defineProperty(Ticker.prototype, \\\"FPS\\\", {\\n        /**\\n         * The frames per second at which this ticker is running.\\n         * The default is approximately 60 in most modern browsers.\\n         * **Note:** This does not factor in the value of\\n         * {@link PIXI.Ticker#speed}, which is specific\\n         * to scaling {@link PIXI.Ticker#deltaTime}.\\n         *\\n         * @member {number}\\n         * @readonly\\n         */\\n        get: function () {\\n            return 1000 / this.elapsedMS;\\n        },\\n        enumerable: false,\\n        configurable: true\\n    });\\n    Object.defineProperty(Ticker.prototype, \\\"minFPS\\\", {\\n        /**\\n         * Manages the maximum amount of milliseconds allowed to\\n         * elapse between invoking {@link PIXI.Ticker#update}.\\n         * This value is used to cap {@link PIXI.Ticker#deltaTime},\\n         * but does not effect the measured value of {@link PIXI.Ticker#FPS}.\\n         * When setting this property it is clamped to a value between\\n         * `0` and `PIXI.settings.TARGET_FPMS * 1000`.\\n         *\\n         * @member {number}\\n         * @default 10\\n         */\\n        get: function () {\\n            return 1000 / this._maxElapsedMS;\\n        },\\n        set: function (fps) {\\n            // Minimum must be below the maxFPS\\n            var minFPS = Math.min(this.maxFPS, fps);\\n            // Must be at least 0, but below 1 / settings.TARGET_FPMS\\n            var minFPMS = Math.min(Math.max(0, minFPS) / 1000, settings.settings.TARGET_FPMS);\\n            this._maxElapsedMS = 1 / minFPMS;\\n        },\\n        enumerable: false,\\n        configurable: true\\n    });\\n    Object.defineProperty(Ticker.prototype, \\\"maxFPS\\\", {\\n        /**\\n         * Manages the minimum amount of milliseconds required to\\n         * elapse between invoking {@link PIXI.Ticker#update}.\\n         * This will effect the measured value of {@link PIXI.Ticker#FPS}.\\n         * If it is set to `0`, then there is no limit; PixiJS will render as many frames as it can.\\n         * Otherwise it will be at least `minFPS`\\n         *\\n         * @member {number}\\n         * @default 0\\n         */\\n        get: function () {\\n            if (this._minElapsedMS) {\\n                return Math.round(1000 / this._minElapsedMS);\\n            }\\n            return 0;\\n        },\\n        set: function (fps) {\\n            if (fps === 0) {\\n                this._minElapsedMS = 0;\\n            }\\n            else {\\n                // Max must be at least the minFPS\\n                var maxFPS = Math.max(this.minFPS, fps);\\n                this._minElapsedMS = 1 / (maxFPS / 1000);\\n            }\\n        },\\n        enumerable: false,\\n        configurable: true\\n    });\\n    Object.defineProperty(Ticker, \\\"shared\\\", {\\n        /**\\n         * The shared ticker instance used by {@link PIXI.AnimatedSprite} and by\\n         * {@link PIXI.VideoResource} to update animation frames / video textures.\\n         *\\n         * It may also be used by {@link PIXI.Application} if created with the `sharedTicker` option property set to true.\\n         *\\n         * The property {@link PIXI.Ticker#autoStart} is set to `true` for this instance.\\n         * Please follow the examples for usage, including how to opt-out of auto-starting the shared ticker.\\n         *\\n         * @example\\n         * let ticker = PIXI.Ticker.shared;\\n         * // Set this to prevent starting this ticker when listeners are added.\\n         * // By default this is true only for the PIXI.Ticker.shared instance.\\n         * ticker.autoStart = false;\\n         * // FYI, call this to ensure the ticker is stopped. It should be stopped\\n         * // if you have not attempted to render anything yet.\\n         * ticker.stop();\\n         * // Call this when you are ready for a running shared ticker.\\n         * ticker.start();\\n         *\\n         * @example\\n         * // You may use the shared ticker to render...\\n         * let renderer = PIXI.autoDetectRenderer();\\n         * let stage = new PIXI.Container();\\n         * document.body.appendChild(renderer.view);\\n         * ticker.add(function (time) {\\n         *     renderer.render(stage);\\n         * });\\n         *\\n         * @example\\n         * // Or you can just update it manually.\\n         * ticker.autoStart = false;\\n         * ticker.stop();\\n         * function animate(time) {\\n         *     ticker.update(time);\\n         *     renderer.render(stage);\\n         *     requestAnimationFrame(animate);\\n         * }\\n         * animate(performance.now());\\n         *\\n         * @member {PIXI.Ticker}\\n         * @static\\n         */\\n        get: function () {\\n            if (!Ticker._shared) {\\n                var shared = Ticker._shared = new Ticker();\\n                shared.autoStart = true;\\n                shared._protected = true;\\n            }\\n            return Ticker._shared;\\n        },\\n        enumerable: false,\\n        configurable: true\\n    });\\n    Object.defineProperty(Ticker, \\\"system\\\", {\\n        /**\\n         * The system ticker instance used by {@link PIXI.InteractionManager} and by\\n         * {@link PIXI.BasePrepare} for core timing functionality that shouldn't usually need to be paused,\\n         * unlike the `shared` ticker which drives visual animations and rendering which may want to be paused.\\n         *\\n         * The property {@link PIXI.Ticker#autoStart} is set to `true` for this instance.\\n         *\\n         * @member {PIXI.Ticker}\\n         * @static\\n         */\\n        get: function () {\\n            if (!Ticker._system) {\\n                var system = Ticker._system = new Ticker();\\n                system.autoStart = true;\\n                system._protected = true;\\n            }\\n            return Ticker._system;\\n        },\\n        enumerable: false,\\n        configurable: true\\n    });\\n    return Ticker;\\n}());\\n\\n/**\\n * Middleware for for Application Ticker.\\n *\\n * @example\\n * import {TickerPlugin} from '@pixi/ticker';\\n * import {Application} from '@pixi/app';\\n * Application.registerPlugin(TickerPlugin);\\n *\\n * @class\\n * @memberof PIXI\\n */\\nvar TickerPlugin = /** @class */ (function () {\\n    function TickerPlugin() {\\n    }\\n    /**\\n     * Initialize the plugin with scope of application instance\\n     *\\n     * @static\\n     * @private\\n     * @param {object} [options] - See application options\\n     */\\n    TickerPlugin.init = function (options) {\\n        var _this = this;\\n        // Set default\\n        options = Object.assign({\\n            autoStart: true,\\n            sharedTicker: false,\\n        }, options);\\n        // Create ticker setter\\n        Object.defineProperty(this, 'ticker', {\\n            set: function (ticker) {\\n                if (this._ticker) {\\n                    this._ticker.remove(this.render, this);\\n                }\\n                this._ticker = ticker;\\n                if (ticker) {\\n                    ticker.add(this.render, this, exports.UPDATE_PRIORITY.LOW);\\n                }\\n            },\\n            get: function () {\\n                return this._ticker;\\n            },\\n        });\\n        /**\\n         * Convenience method for stopping the render.\\n         *\\n         * @method\\n         * @memberof PIXI.Application\\n         * @instance\\n         */\\n        this.stop = function () {\\n            _this._ticker.stop();\\n        };\\n        /**\\n         * Convenience method for starting the render.\\n         *\\n         * @method\\n         * @memberof PIXI.Application\\n         * @instance\\n         */\\n        this.start = function () {\\n            _this._ticker.start();\\n        };\\n        /**\\n         * Internal reference to the ticker.\\n         *\\n         * @type {PIXI.Ticker}\\n         * @name _ticker\\n         * @memberof PIXI.Application#\\n         * @private\\n         */\\n        this._ticker = null;\\n        /**\\n         * Ticker for doing render updates.\\n         *\\n         * @type {PIXI.Ticker}\\n         * @name ticker\\n         * @memberof PIXI.Application#\\n         * @default PIXI.Ticker.shared\\n         */\\n        this.ticker = options.sharedTicker ? Ticker.shared : new Ticker();\\n        // Start the rendering\\n        if (options.autoStart) {\\n            this.start();\\n        }\\n    };\\n    /**\\n     * Clean up the ticker, scoped to application.\\n     *\\n     * @static\\n     * @private\\n     */\\n    TickerPlugin.destroy = function () {\\n        if (this._ticker) {\\n            var oldTicker = this._ticker;\\n            this.ticker = null;\\n            oldTicker.destroy();\\n        }\\n    };\\n    return TickerPlugin;\\n}());\\n\\nexports.Ticker = Ticker;\\nexports.TickerPlugin = TickerPlugin;\\n//# sourceMappingURL=ticker.js.map\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Object\",\"defineProperty\",\"value\",\"settings\",\"TARGET_FPMS\",\"UPDATE_PRIORITY\",\"TickerListener\",\"fn\",\"context\",\"priority\",\"once\",\"previous\",\"next\",\"_destroyed\",\"prototype\",\"match\",\"TickerListener.prototype.match\",\"emit\",\"TickerListener.prototype.emit\",\"deltaTime\",\"call\",\"redirect\",\"destroy\",\"connect\",\"TickerListener.prototype.connect\",\"TickerListener.prototype.destroy\",\"hard\",\"Ticker\",\"_this\",\"autoStart\",\"lastTime\",\"speed\",\"started\",\"_requestId\",\"_maxElapsedMS\",\"_minElapsedMS\",\"_protected\",\"_lastFrame\",\"_head\",\"Infinity\",\"deltaMS\",\"elapsedMS\",\"_tick\",\"this._tick\",\"time\",\"update\",\"requestAnimationFrame\",\"_requestIfNeeded\",\"Ticker.prototype._requestIfNeeded\",\"performance\",\"now\",\"_cancelIfNeeded\",\"Ticker.prototype._cancelIfNeeded\",\"cancelAnimationFrame\",\"_startIfPossible\",\"Ticker.prototype._startIfPossible\",\"start\",\"add\",\"Ticker.prototype.add\",\"NORMAL\",\"_addListener\",\"addOnce\",\"Ticker.prototype.addOnce\",\"Ticker.prototype._addListener\",\"listener\",\"current\",\"remove\",\"Ticker.prototype.remove\",\"get\",\"count\",\"enumerable\",\"configurable\",\"Ticker.prototype.start\",\"stop\",\"Ticker.prototype.stop\",\"Ticker.prototype.destroy\",\"Ticker.prototype.update\",\"currentTime\",\"delta\",\"head\",\"set\",\"fps\",\"Math\",\"min\",\"minFPMS\",\"max\",\"minFPS\",\"maxFPS\",\"round\",\"_shared\",\"shared\",\"_system\",\"system\",\"TickerPlugin\",\"init\",\"TickerPlugin.init\",\"options\",\"assign\",\"sharedTicker\",\"ticker\",\"_ticker\",\"render\",\"LOW\",\"this.stop\",\"this.start\",\"TickerPlugin.destroy\",\"oldTicker\"]\n}\n"]