["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@capacitor/filesystem/dist/plugin.cjs.js"],"~:js","shadow$provide[119]=function(ra,X,Ra,P){function w(u){const A=[];u.split(\"/\").filter(y=>\".\"!==y).forEach(y=>{\"..\"===y&&0<A.length&&\"..\"!==A[A.length-1]?A.pop():A.push(y)});return A.join(\"/\")}function Z(u,A){u=w(u);A=w(A);const y=u.split(\"/\"),x=A.split(\"/\");return u!==A&&y.every((Q,g)=>Q===x[g])}Object.defineProperty(P,\"__esModule\",{value:!0});var B=X(7);P.Directory=void 0;(function(u){u.Documents=\"DOCUMENTS\";u.Data=\"DATA\";u.Library=\"LIBRARY\";u.Cache=\"CACHE\";u.External=\"EXTERNAL\";u.ExternalStorage=\n\"EXTERNAL_STORAGE\"})(P.Directory||(P.Directory={}));P.Encoding=void 0;(function(u){u.UTF8=\"utf8\";u.ASCII=\"ascii\";u.UTF16=\"utf16\"})(P.Encoding||(P.Encoding={}));ra=P.Directory;X=P.Encoding;Ra=B.registerPlugin(\"Filesystem\",{web:()=>Promise.resolve().then(function(){return c}).then(u=>new u.FilesystemWeb)});class p extends B.WebPlugin{constructor(){super(...arguments);this.DB_VERSION=1;this.DB_NAME=\"Disc\";this._writeCmds=[\"add\",\"put\",\"delete\"];this.downloadFile=u=>{const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){var y,\nx,Q=B.buildRequestInit(u,u.webFetchExtra),g=yield fetch(u.url,Q);if(u.progress)if(null===g||void 0===g?0:g.body){var h=g.body.getReader(),b=0;Q=[];const k=g.headers.get(\"content-type\");for(g=parseInt(g.headers.get(\"content-length\")||\"0\",10);;){const {done:r,value:D}=yield h.read();if(r)break;Q.push(D);b+=(null===D||void 0===D?void 0:D.length)||0;A.notifyListeners(\"progress\",{url:u.url,bytes:b,contentLength:g})}h=new Uint8Array(b);b=0;for(l of Q)\"undefined\"!==typeof l&&(h.set(l,b),b+=l.length);var l=\nnew Blob([h.buffer],{type:k||void 0})}else l=new Blob;else l=yield g.blob();return{path:(yield A.writeFile({path:u.path,directory:null!==(y=u.directory)&&void 0!==y?y:void 0,recursive:null!==(x=u.recursive)&&void 0!==x?x:!1,data:l})).uri,blob:l}})}}initDb(){const u=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(void 0!==u._db)return u._db;if(!(\"indexedDB\"in window))throw u.unavailable(\"This browser doesn't support IndexedDB\");return new Promise((A,y)=>{const x=indexedDB.open(u.DB_NAME,\nu.DB_VERSION);x.onupgradeneeded=p.doUpgrade;x.onsuccess=()=>{u._db=x.result;A(x.result)};x.onerror=()=>y(x.error);x.onblocked=()=>{console.warn(\"db blocked\")}})})}static doUpgrade(u){u=u.target.result;u.objectStoreNames.contains(\"FileStorage\")&&u.deleteObjectStore(\"FileStorage\");u.createObjectStore(\"FileStorage\",{keyPath:\"path\"}).createIndex(\"by_folder\",\"folder\")}dbRequest(u,A){const y=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const x=-1!==y._writeCmds.indexOf(u)?\"readwrite\":\n\"readonly\";return y.initDb().then(Q=>new Promise((g,h)=>{const b=Q.transaction([\"FileStorage\"],x).objectStore(\"FileStorage\")[u](...A);b.onsuccess=()=>g(b.result);b.onerror=()=>h(b.error)}))})}dbIndexRequest(u,A,y){const x=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const Q=-1!==x._writeCmds.indexOf(A)?\"readwrite\":\"readonly\";return x.initDb().then(g=>new Promise((h,b)=>{const l=g.transaction([\"FileStorage\"],Q).objectStore(\"FileStorage\").index(u)[A](...y);l.onsuccess=()=>h(l.result);\nl.onerror=()=>b(l.error)}))})}getPath(u,A){const y=void 0!==A?A.replace(/^[/]+|[/]+$/g,\"\"):\"\";let x=\"\";void 0!==u&&(x+=\"/\"+u);\"\"!==A&&(x+=\"/\"+y);return x}clear(){const u=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){(yield u.initDb()).transaction([\"FileStorage\"],\"readwrite\").objectStore(\"FileStorage\").clear()})}readFile(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){var y=A.getPath(u.directory,u.path);y=yield A.dbRequest(\"get\",[y]);if(void 0===\ny)throw Error(\"File does not exist.\");return{data:y.content?y.content:\"\"}})}writeFile(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){var y=A.getPath(u.directory,u.path);let x=u.data;var Q=u.encoding;const g=u.recursive;var h=yield A.dbRequest(\"get\",[y]);if(h&&\"directory\"===h.type)throw Error(\"The supplied path is a directory.\");h=y.substr(0,y.lastIndexOf(\"/\"));if(void 0===(yield A.dbRequest(\"get\",[h]))){var b=h.indexOf(\"/\",1);-1!==b&&(b=h.substr(b),yield A.mkdir({path:b,\ndirectory:u.directory,recursive:g}))}if(!(Q||x instanceof Blob||(x=0<=x.indexOf(\",\")?x.split(\",\")[1]:x,A.isBase64String(x))))throw Error(\"The supplied data is not valid base64 content.\");Q=Date.now();y={path:y,folder:h,type:\"file\",size:x instanceof Blob?x.size:x.length,ctime:Q,mtime:Q,content:x};yield A.dbRequest(\"put\",[y]);return{uri:y.path}})}appendFile(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=A.getPath(u.directory,u.path);let x=u.data;const Q=u.encoding,\ng=y.substr(0,y.lastIndexOf(\"/\")),h=Date.now();let b=h;const l=yield A.dbRequest(\"get\",[y]);if(l&&\"directory\"===l.type)throw Error(\"The supplied path is a directory.\");if(void 0===(yield A.dbRequest(\"get\",[g]))){var k=g.indexOf(\"/\",1);-1!==k&&(k=g.substr(k),yield A.mkdir({path:k,directory:u.directory,recursive:!0}))}if(!Q&&!A.isBase64String(x))throw Error(\"The supplied data is not valid base64 content.\");if(void 0!==l){if(l.content instanceof Blob)throw Error(\"The occupied entry contains a Blob object which cannot be appended to.\");\nx=void 0===l.content||Q?l.content+x:btoa(atob(l.content)+atob(x));b=l.ctime}yield A.dbRequest(\"put\",[{path:y,folder:g,type:\"file\",size:x.length,ctime:b,mtime:h,content:x}])})}deleteFile(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=A.getPath(u.directory,u.path);if(void 0===(yield A.dbRequest(\"get\",[y])))throw Error(\"File does not exist.\");if(0!==(yield A.dbIndexRequest(\"by_folder\",\"getAllKeys\",[IDBKeyRange.only(y)])).length)throw Error(\"Folder is not empty.\");\nyield A.dbRequest(\"delete\",[y])})}mkdir(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=A.getPath(u.directory,u.path);var x=u.recursive;const Q=y.substr(0,y.lastIndexOf(\"/\"));var g=(y.match(/\\//g)||[]).length;const h=yield A.dbRequest(\"get\",[Q]),b=yield A.dbRequest(\"get\",[y]);if(1===g)throw Error(\"Cannot create Root directory\");if(void 0!==b)throw Error(\"Current directory does already exist.\");if(!x&&2!==g&&void 0===h)throw Error(\"Parent directory must exist\");\nx&&2!==g&&void 0===h&&(g=Q.substr(Q.indexOf(\"/\",1)),yield A.mkdir({path:g,directory:u.directory,recursive:x}));x=Date.now();yield A.dbRequest(\"put\",[{path:y,folder:Q,type:\"directory\",size:0,ctime:x,mtime:x}])})}rmdir(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const {path:y,directory:x,recursive:Q}=u,g=A.getPath(x,y);var h=yield A.dbRequest(\"get\",[g]);if(void 0===h)throw Error(\"Folder does not exist.\");if(\"directory\"!==h.type)throw Error(\"Requested path is not a directory\");\nh=yield A.readdir({path:y,directory:x});if(0!==h.files.length&&!Q)throw Error(\"Folder is not empty\");for(const b of h.files)h=`${y}/${b.name}`,\"file\"===(yield A.stat({path:h,directory:x})).type?yield A.deleteFile({path:h,directory:x}):yield A.rmdir({path:h,directory:x,recursive:Q});yield A.dbRequest(\"delete\",[g])})}readdir(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=A.getPath(u.directory,u.path);var x=yield A.dbRequest(\"get\",[y]);if(\"\"!==u.path&&void 0===\nx)throw Error(\"Folder does not exist.\");x=yield A.dbIndexRequest(\"by_folder\",\"getAllKeys\",[IDBKeyRange.only(y)]);return{files:yield Promise.all(x.map(Q=>$jscomp.asyncExecutePromiseGeneratorFunction(function*(){let g=yield A.dbRequest(\"get\",[Q]);void 0===g&&(g=yield A.dbRequest(\"get\",[Q+\"/\"]));return{name:Q.substring(y.length+1),type:g.type,size:g.size,ctime:g.ctime,mtime:g.mtime,uri:g.path}})))}})}getUri(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=A.getPath(u.directory,\nu.path);let x=yield A.dbRequest(\"get\",[y]);void 0===x&&(x=yield A.dbRequest(\"get\",[y+\"/\"]));return{uri:(null===x||void 0===x?void 0:x.path)||y}})}stat(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=A.getPath(u.directory,u.path);let x=yield A.dbRequest(\"get\",[y]);void 0===x&&(x=yield A.dbRequest(\"get\",[y+\"/\"]));if(void 0===x)throw Error(\"Entry does not exist.\");return{type:x.type,size:x.size,ctime:x.ctime,mtime:x.mtime,uri:x.path}})}rename(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){yield A._copy(u,\n!0)})}copy(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){return A._copy(u,!1)})}requestPermissions(){return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){return{publicStorage:\"granted\"}})}checkPermissions(){return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){return{publicStorage:\"granted\"}})}_copy(u,A=!1){const y=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){let {toDirectory:x}=u;const {to:Q,from:g,directory:h}=u;if(!Q||\n!g)throw Error(\"Both to and from must be provided\");x||(x=h);var b=y.getPath(h,g),l=y.getPath(x,Q);if(b===l)return{uri:l};if(Z(b,l))throw Error(\"To path cannot contain the from path\");let k;try{k=yield y.stat({path:Q,directory:x})}catch(t){b=Q.split(\"/\");b.pop();var r=b.join(\"/\");if(0<b.length&&\"directory\"!==(yield y.stat({path:r,directory:x})).type)throw Error(\"Parent directory of the to path is a file\");}if(k&&\"directory\"===k.type)throw Error(\"Cannot overwrite a directory with a file\");b=yield y.stat({path:g,\ndirectory:h});r=(t,q,f)=>$jscomp.asyncExecutePromiseGeneratorFunction(function*(){var E=y.getPath(x,t);E=yield y.dbRequest(\"get\",[E]);E.ctime=q;E.mtime=f;yield y.dbRequest(\"put\",[E])});const D=b.ctime?b.ctime:Date.now();switch(b.type){case \"file\":l=yield y.readFile({path:g,directory:h});A&&(yield y.deleteFile({path:g,directory:h}));if(!(l.data instanceof Blob||y.isBase64String(l.data)))var v=P.Encoding.UTF8;l=yield y.writeFile({path:Q,directory:x,data:l.data,encoding:v});A&&(yield r(Q,D,b.mtime));\nreturn l;case \"directory\":if(k)throw Error(\"Cannot move a directory over an existing object\");try{yield y.mkdir({path:Q,directory:x,recursive:!1}),A&&(yield r(Q,D,b.mtime))}catch(t){}v=(yield y.readdir({path:g,directory:h})).files;for(const t of v)yield y._copy({from:`${g}/${t.name}`,to:`${Q}/${t.name}`,directory:h,toDirectory:x},A);A&&(yield y.rmdir({path:g,directory:h}))}return{uri:l}})}isBase64String(u){try{return btoa(atob(u))==u}catch(A){return!1}}}p._debug=!0;var c=Object.freeze({__proto__:null,\nFilesystemWeb:p});P.Filesystem=Ra;P.FilesystemDirectory=ra;P.FilesystemEncoding=X}","~:source","shadow$provide[119] = function(global,require,module,exports) {\n'use strict';\n\nObject.defineProperty(exports, '__esModule', { value: true });\n\nvar core = require('@capacitor/core');\n\nexports.Directory = void 0;\n(function (Directory) {\n    /**\n     * The Documents directory.\n     * On iOS it's the app's documents directory.\n     * Use this directory to store user-generated content.\n     * On Android it's the Public Documents folder, so it's accessible from other apps.\n     * It's not accesible on Android 10 unless the app enables legacy External Storage\n     * by adding `android:requestLegacyExternalStorage=\"true\"` in the `application` tag\n     * in the `AndroidManifest.xml`.\n     * On Android 11 or newer the app can only access the files/folders the app created.\n     *\n     * @since 1.0.0\n     */\n    Directory[\"Documents\"] = \"DOCUMENTS\";\n    /**\n     * The Data directory.\n     * On iOS it will use the Documents directory.\n     * On Android it's the directory holding application files.\n     * Files will be deleted when the application is uninstalled.\n     *\n     * @since 1.0.0\n     */\n    Directory[\"Data\"] = \"DATA\";\n    /**\n     * The Library directory.\n     * On iOS it will use the Library directory.\n     * On Android it's the directory holding application files.\n     * Files will be deleted when the application is uninstalled.\n     *\n     * @since 1.1.0\n     */\n    Directory[\"Library\"] = \"LIBRARY\";\n    /**\n     * The Cache directory.\n     * Can be deleted in cases of low memory, so use this directory to write app-specific files.\n     * that your app can re-create easily.\n     *\n     * @since 1.0.0\n     */\n    Directory[\"Cache\"] = \"CACHE\";\n    /**\n     * The external directory.\n     * On iOS it will use the Documents directory.\n     * On Android it's the directory on the primary shared/external\n     * storage device where the application can place persistent files it owns.\n     * These files are internal to the applications, and not typically visible\n     * to the user as media.\n     * Files will be deleted when the application is uninstalled.\n     *\n     * @since 1.0.0\n     */\n    Directory[\"External\"] = \"EXTERNAL\";\n    /**\n     * The external storage directory.\n     * On iOS it will use the Documents directory.\n     * On Android it's the primary shared/external storage directory.\n     * It's not accesible on Android 10 unless the app enables legacy External Storage\n     * by adding `android:requestLegacyExternalStorage=\"true\"` in the `application` tag\n     * in the `AndroidManifest.xml`.\n     * It's not accesible on Android 11 or newer.\n     *\n     * @since 1.0.0\n     */\n    Directory[\"ExternalStorage\"] = \"EXTERNAL_STORAGE\";\n})(exports.Directory || (exports.Directory = {}));\nexports.Encoding = void 0;\n(function (Encoding) {\n    /**\n     * Eight-bit UCS Transformation Format\n     *\n     * @since 1.0.0\n     */\n    Encoding[\"UTF8\"] = \"utf8\";\n    /**\n     * Seven-bit ASCII, a.k.a. ISO646-US, a.k.a. the Basic Latin block of the\n     * Unicode character set\n     * This encoding is only supported on Android.\n     *\n     * @since 1.0.0\n     */\n    Encoding[\"ASCII\"] = \"ascii\";\n    /**\n     * Sixteen-bit UCS Transformation Format, byte order identified by an\n     * optional byte-order mark\n     * This encoding is only supported on Android.\n     *\n     * @since 1.0.0\n     */\n    Encoding[\"UTF16\"] = \"utf16\";\n})(exports.Encoding || (exports.Encoding = {}));\n/**\n * @deprecated Use `Directory`.\n * @since 1.0.0\n */\nconst FilesystemDirectory = exports.Directory;\n/**\n * @deprecated Use `Encoding`.\n * @since 1.0.0\n */\nconst FilesystemEncoding = exports.Encoding;\n\nconst Filesystem = core.registerPlugin('Filesystem', {\n    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.FilesystemWeb()),\n});\n\nfunction resolve(path) {\n    const posix = path.split('/').filter(item => item !== '.');\n    const newPosix = [];\n    posix.forEach(item => {\n        if (item === '..' &&\n            newPosix.length > 0 &&\n            newPosix[newPosix.length - 1] !== '..') {\n            newPosix.pop();\n        }\n        else {\n            newPosix.push(item);\n        }\n    });\n    return newPosix.join('/');\n}\nfunction isPathParent(parent, children) {\n    parent = resolve(parent);\n    children = resolve(children);\n    const pathsA = parent.split('/');\n    const pathsB = children.split('/');\n    return (parent !== children &&\n        pathsA.every((value, index) => value === pathsB[index]));\n}\nclass FilesystemWeb extends core.WebPlugin {\n    constructor() {\n        super(...arguments);\n        this.DB_VERSION = 1;\n        this.DB_NAME = 'Disc';\n        this._writeCmds = ['add', 'put', 'delete'];\n        /**\n         * Function that performs a http request to a server and downloads the file to the specified destination\n         *\n         * @param options the options for the download operation\n         * @returns a promise that resolves with the download file result\n         */\n        this.downloadFile = async (options) => {\n            var _a, _b;\n            const requestInit = core.buildRequestInit(options, options.webFetchExtra);\n            const response = await fetch(options.url, requestInit);\n            let blob;\n            if (!options.progress)\n                blob = await response.blob();\n            else if (!(response === null || response === void 0 ? void 0 : response.body))\n                blob = new Blob();\n            else {\n                const reader = response.body.getReader();\n                let bytes = 0;\n                const chunks = [];\n                const contentType = response.headers.get('content-type');\n                const contentLength = parseInt(response.headers.get('content-length') || '0', 10);\n                while (true) {\n                    const { done, value } = await reader.read();\n                    if (done)\n                        break;\n                    chunks.push(value);\n                    bytes += (value === null || value === void 0 ? void 0 : value.length) || 0;\n                    const status = {\n                        url: options.url,\n                        bytes,\n                        contentLength,\n                    };\n                    this.notifyListeners('progress', status);\n                }\n                const allChunks = new Uint8Array(bytes);\n                let position = 0;\n                for (const chunk of chunks) {\n                    if (typeof chunk === 'undefined')\n                        continue;\n                    allChunks.set(chunk, position);\n                    position += chunk.length;\n                }\n                blob = new Blob([allChunks.buffer], { type: contentType || undefined });\n            }\n            const result = await this.writeFile({\n                path: options.path,\n                directory: (_a = options.directory) !== null && _a !== void 0 ? _a : undefined,\n                recursive: (_b = options.recursive) !== null && _b !== void 0 ? _b : false,\n                data: blob,\n            });\n            return { path: result.uri, blob };\n        };\n    }\n    async initDb() {\n        if (this._db !== undefined) {\n            return this._db;\n        }\n        if (!('indexedDB' in window)) {\n            throw this.unavailable(\"This browser doesn't support IndexedDB\");\n        }\n        return new Promise((resolve, reject) => {\n            const request = indexedDB.open(this.DB_NAME, this.DB_VERSION);\n            request.onupgradeneeded = FilesystemWeb.doUpgrade;\n            request.onsuccess = () => {\n                this._db = request.result;\n                resolve(request.result);\n            };\n            request.onerror = () => reject(request.error);\n            request.onblocked = () => {\n                console.warn('db blocked');\n            };\n        });\n    }\n    static doUpgrade(event) {\n        const eventTarget = event.target;\n        const db = eventTarget.result;\n        switch (event.oldVersion) {\n            case 0:\n            case 1:\n            default: {\n                if (db.objectStoreNames.contains('FileStorage')) {\n                    db.deleteObjectStore('FileStorage');\n                }\n                const store = db.createObjectStore('FileStorage', { keyPath: 'path' });\n                store.createIndex('by_folder', 'folder');\n            }\n        }\n    }\n    async dbRequest(cmd, args) {\n        const readFlag = this._writeCmds.indexOf(cmd) !== -1 ? 'readwrite' : 'readonly';\n        return this.initDb().then((conn) => {\n            return new Promise((resolve, reject) => {\n                const tx = conn.transaction(['FileStorage'], readFlag);\n                const store = tx.objectStore('FileStorage');\n                const req = store[cmd](...args);\n                req.onsuccess = () => resolve(req.result);\n                req.onerror = () => reject(req.error);\n            });\n        });\n    }\n    async dbIndexRequest(indexName, cmd, args) {\n        const readFlag = this._writeCmds.indexOf(cmd) !== -1 ? 'readwrite' : 'readonly';\n        return this.initDb().then((conn) => {\n            return new Promise((resolve, reject) => {\n                const tx = conn.transaction(['FileStorage'], readFlag);\n                const store = tx.objectStore('FileStorage');\n                const index = store.index(indexName);\n                const req = index[cmd](...args);\n                req.onsuccess = () => resolve(req.result);\n                req.onerror = () => reject(req.error);\n            });\n        });\n    }\n    getPath(directory, uriPath) {\n        const cleanedUriPath = uriPath !== undefined ? uriPath.replace(/^[/]+|[/]+$/g, '') : '';\n        let fsPath = '';\n        if (directory !== undefined)\n            fsPath += '/' + directory;\n        if (uriPath !== '')\n            fsPath += '/' + cleanedUriPath;\n        return fsPath;\n    }\n    async clear() {\n        const conn = await this.initDb();\n        const tx = conn.transaction(['FileStorage'], 'readwrite');\n        const store = tx.objectStore('FileStorage');\n        store.clear();\n    }\n    /**\n     * Read a file from disk\n     * @param options options for the file read\n     * @return a promise that resolves with the read file data result\n     */\n    async readFile(options) {\n        const path = this.getPath(options.directory, options.path);\n        // const encoding = options.encoding;\n        const entry = (await this.dbRequest('get', [path]));\n        if (entry === undefined)\n            throw Error('File does not exist.');\n        return { data: entry.content ? entry.content : '' };\n    }\n    /**\n     * Write a file to disk in the specified location on device\n     * @param options options for the file write\n     * @return a promise that resolves with the file write result\n     */\n    async writeFile(options) {\n        const path = this.getPath(options.directory, options.path);\n        let data = options.data;\n        const encoding = options.encoding;\n        const doRecursive = options.recursive;\n        const occupiedEntry = (await this.dbRequest('get', [path]));\n        if (occupiedEntry && occupiedEntry.type === 'directory')\n            throw Error('The supplied path is a directory.');\n        const parentPath = path.substr(0, path.lastIndexOf('/'));\n        const parentEntry = (await this.dbRequest('get', [parentPath]));\n        if (parentEntry === undefined) {\n            const subDirIndex = parentPath.indexOf('/', 1);\n            if (subDirIndex !== -1) {\n                const parentArgPath = parentPath.substr(subDirIndex);\n                await this.mkdir({\n                    path: parentArgPath,\n                    directory: options.directory,\n                    recursive: doRecursive,\n                });\n            }\n        }\n        if (!encoding && !(data instanceof Blob)) {\n            data = data.indexOf(',') >= 0 ? data.split(',')[1] : data;\n            if (!this.isBase64String(data))\n                throw Error('The supplied data is not valid base64 content.');\n        }\n        const now = Date.now();\n        const pathObj = {\n            path: path,\n            folder: parentPath,\n            type: 'file',\n            size: data instanceof Blob ? data.size : data.length,\n            ctime: now,\n            mtime: now,\n            content: data,\n        };\n        await this.dbRequest('put', [pathObj]);\n        return {\n            uri: pathObj.path,\n        };\n    }\n    /**\n     * Append to a file on disk in the specified location on device\n     * @param options options for the file append\n     * @return a promise that resolves with the file write result\n     */\n    async appendFile(options) {\n        const path = this.getPath(options.directory, options.path);\n        let data = options.data;\n        const encoding = options.encoding;\n        const parentPath = path.substr(0, path.lastIndexOf('/'));\n        const now = Date.now();\n        let ctime = now;\n        const occupiedEntry = (await this.dbRequest('get', [path]));\n        if (occupiedEntry && occupiedEntry.type === 'directory')\n            throw Error('The supplied path is a directory.');\n        const parentEntry = (await this.dbRequest('get', [parentPath]));\n        if (parentEntry === undefined) {\n            const subDirIndex = parentPath.indexOf('/', 1);\n            if (subDirIndex !== -1) {\n                const parentArgPath = parentPath.substr(subDirIndex);\n                await this.mkdir({\n                    path: parentArgPath,\n                    directory: options.directory,\n                    recursive: true,\n                });\n            }\n        }\n        if (!encoding && !this.isBase64String(data))\n            throw Error('The supplied data is not valid base64 content.');\n        if (occupiedEntry !== undefined) {\n            if (occupiedEntry.content instanceof Blob) {\n                throw Error('The occupied entry contains a Blob object which cannot be appended to.');\n            }\n            if (occupiedEntry.content !== undefined && !encoding) {\n                data = btoa(atob(occupiedEntry.content) + atob(data));\n            }\n            else {\n                data = occupiedEntry.content + data;\n            }\n            ctime = occupiedEntry.ctime;\n        }\n        const pathObj = {\n            path: path,\n            folder: parentPath,\n            type: 'file',\n            size: data.length,\n            ctime: ctime,\n            mtime: now,\n            content: data,\n        };\n        await this.dbRequest('put', [pathObj]);\n    }\n    /**\n     * Delete a file from disk\n     * @param options options for the file delete\n     * @return a promise that resolves with the deleted file data result\n     */\n    async deleteFile(options) {\n        const path = this.getPath(options.directory, options.path);\n        const entry = (await this.dbRequest('get', [path]));\n        if (entry === undefined)\n            throw Error('File does not exist.');\n        const entries = await this.dbIndexRequest('by_folder', 'getAllKeys', [\n            IDBKeyRange.only(path),\n        ]);\n        if (entries.length !== 0)\n            throw Error('Folder is not empty.');\n        await this.dbRequest('delete', [path]);\n    }\n    /**\n     * Create a directory.\n     * @param options options for the mkdir\n     * @return a promise that resolves with the mkdir result\n     */\n    async mkdir(options) {\n        const path = this.getPath(options.directory, options.path);\n        const doRecursive = options.recursive;\n        const parentPath = path.substr(0, path.lastIndexOf('/'));\n        const depth = (path.match(/\\//g) || []).length;\n        const parentEntry = (await this.dbRequest('get', [parentPath]));\n        const occupiedEntry = (await this.dbRequest('get', [path]));\n        if (depth === 1)\n            throw Error('Cannot create Root directory');\n        if (occupiedEntry !== undefined)\n            throw Error('Current directory does already exist.');\n        if (!doRecursive && depth !== 2 && parentEntry === undefined)\n            throw Error('Parent directory must exist');\n        if (doRecursive && depth !== 2 && parentEntry === undefined) {\n            const parentArgPath = parentPath.substr(parentPath.indexOf('/', 1));\n            await this.mkdir({\n                path: parentArgPath,\n                directory: options.directory,\n                recursive: doRecursive,\n            });\n        }\n        const now = Date.now();\n        const pathObj = {\n            path: path,\n            folder: parentPath,\n            type: 'directory',\n            size: 0,\n            ctime: now,\n            mtime: now,\n        };\n        await this.dbRequest('put', [pathObj]);\n    }\n    /**\n     * Remove a directory\n     * @param options the options for the directory remove\n     */\n    async rmdir(options) {\n        const { path, directory, recursive } = options;\n        const fullPath = this.getPath(directory, path);\n        const entry = (await this.dbRequest('get', [fullPath]));\n        if (entry === undefined)\n            throw Error('Folder does not exist.');\n        if (entry.type !== 'directory')\n            throw Error('Requested path is not a directory');\n        const readDirResult = await this.readdir({ path, directory });\n        if (readDirResult.files.length !== 0 && !recursive)\n            throw Error('Folder is not empty');\n        for (const entry of readDirResult.files) {\n            const entryPath = `${path}/${entry.name}`;\n            const entryObj = await this.stat({ path: entryPath, directory });\n            if (entryObj.type === 'file') {\n                await this.deleteFile({ path: entryPath, directory });\n            }\n            else {\n                await this.rmdir({ path: entryPath, directory, recursive });\n            }\n        }\n        await this.dbRequest('delete', [fullPath]);\n    }\n    /**\n     * Return a list of files from the directory (not recursive)\n     * @param options the options for the readdir operation\n     * @return a promise that resolves with the readdir directory listing result\n     */\n    async readdir(options) {\n        const path = this.getPath(options.directory, options.path);\n        const entry = (await this.dbRequest('get', [path]));\n        if (options.path !== '' && entry === undefined)\n            throw Error('Folder does not exist.');\n        const entries = await this.dbIndexRequest('by_folder', 'getAllKeys', [IDBKeyRange.only(path)]);\n        const files = await Promise.all(entries.map(async (e) => {\n            let subEntry = (await this.dbRequest('get', [e]));\n            if (subEntry === undefined) {\n                subEntry = (await this.dbRequest('get', [e + '/']));\n            }\n            return {\n                name: e.substring(path.length + 1),\n                type: subEntry.type,\n                size: subEntry.size,\n                ctime: subEntry.ctime,\n                mtime: subEntry.mtime,\n                uri: subEntry.path,\n            };\n        }));\n        return { files: files };\n    }\n    /**\n     * Return full File URI for a path and directory\n     * @param options the options for the stat operation\n     * @return a promise that resolves with the file stat result\n     */\n    async getUri(options) {\n        const path = this.getPath(options.directory, options.path);\n        let entry = (await this.dbRequest('get', [path]));\n        if (entry === undefined) {\n            entry = (await this.dbRequest('get', [path + '/']));\n        }\n        return {\n            uri: (entry === null || entry === void 0 ? void 0 : entry.path) || path,\n        };\n    }\n    /**\n     * Return data about a file\n     * @param options the options for the stat operation\n     * @return a promise that resolves with the file stat result\n     */\n    async stat(options) {\n        const path = this.getPath(options.directory, options.path);\n        let entry = (await this.dbRequest('get', [path]));\n        if (entry === undefined) {\n            entry = (await this.dbRequest('get', [path + '/']));\n        }\n        if (entry === undefined)\n            throw Error('Entry does not exist.');\n        return {\n            type: entry.type,\n            size: entry.size,\n            ctime: entry.ctime,\n            mtime: entry.mtime,\n            uri: entry.path,\n        };\n    }\n    /**\n     * Rename a file or directory\n     * @param options the options for the rename operation\n     * @return a promise that resolves with the rename result\n     */\n    async rename(options) {\n        await this._copy(options, true);\n        return;\n    }\n    /**\n     * Copy a file or directory\n     * @param options the options for the copy operation\n     * @return a promise that resolves with the copy result\n     */\n    async copy(options) {\n        return this._copy(options, false);\n    }\n    async requestPermissions() {\n        return { publicStorage: 'granted' };\n    }\n    async checkPermissions() {\n        return { publicStorage: 'granted' };\n    }\n    /**\n     * Function that can perform a copy or a rename\n     * @param options the options for the rename operation\n     * @param doRename whether to perform a rename or copy operation\n     * @return a promise that resolves with the result\n     */\n    async _copy(options, doRename = false) {\n        let { toDirectory } = options;\n        const { to, from, directory: fromDirectory } = options;\n        if (!to || !from) {\n            throw Error('Both to and from must be provided');\n        }\n        // If no \"to\" directory is provided, use the \"from\" directory\n        if (!toDirectory) {\n            toDirectory = fromDirectory;\n        }\n        const fromPath = this.getPath(fromDirectory, from);\n        const toPath = this.getPath(toDirectory, to);\n        // Test that the \"to\" and \"from\" locations are different\n        if (fromPath === toPath) {\n            return {\n                uri: toPath,\n            };\n        }\n        if (isPathParent(fromPath, toPath)) {\n            throw Error('To path cannot contain the from path');\n        }\n        // Check the state of the \"to\" location\n        let toObj;\n        try {\n            toObj = await this.stat({\n                path: to,\n                directory: toDirectory,\n            });\n        }\n        catch (e) {\n            // To location does not exist, ensure the directory containing \"to\" location exists and is a directory\n            const toPathComponents = to.split('/');\n            toPathComponents.pop();\n            const toPath = toPathComponents.join('/');\n            // Check the containing directory of the \"to\" location exists\n            if (toPathComponents.length > 0) {\n                const toParentDirectory = await this.stat({\n                    path: toPath,\n                    directory: toDirectory,\n                });\n                if (toParentDirectory.type !== 'directory') {\n                    throw new Error('Parent directory of the to path is a file');\n                }\n            }\n        }\n        // Cannot overwrite a directory\n        if (toObj && toObj.type === 'directory') {\n            throw new Error('Cannot overwrite a directory with a file');\n        }\n        // Ensure the \"from\" object exists\n        const fromObj = await this.stat({\n            path: from,\n            directory: fromDirectory,\n        });\n        // Set the mtime/ctime of the supplied path\n        const updateTime = async (path, ctime, mtime) => {\n            const fullPath = this.getPath(toDirectory, path);\n            const entry = (await this.dbRequest('get', [fullPath]));\n            entry.ctime = ctime;\n            entry.mtime = mtime;\n            await this.dbRequest('put', [entry]);\n        };\n        const ctime = fromObj.ctime ? fromObj.ctime : Date.now();\n        switch (fromObj.type) {\n            // The \"from\" object is a file\n            case 'file': {\n                // Read the file\n                const file = await this.readFile({\n                    path: from,\n                    directory: fromDirectory,\n                });\n                // Optionally remove the file\n                if (doRename) {\n                    await this.deleteFile({\n                        path: from,\n                        directory: fromDirectory,\n                    });\n                }\n                let encoding;\n                if (!(file.data instanceof Blob) && !this.isBase64String(file.data)) {\n                    encoding = exports.Encoding.UTF8;\n                }\n                // Write the file to the new location\n                const writeResult = await this.writeFile({\n                    path: to,\n                    directory: toDirectory,\n                    data: file.data,\n                    encoding: encoding,\n                });\n                // Copy the mtime/ctime of a renamed file\n                if (doRename) {\n                    await updateTime(to, ctime, fromObj.mtime);\n                }\n                // Resolve promise\n                return writeResult;\n            }\n            case 'directory': {\n                if (toObj) {\n                    throw Error('Cannot move a directory over an existing object');\n                }\n                try {\n                    // Create the to directory\n                    await this.mkdir({\n                        path: to,\n                        directory: toDirectory,\n                        recursive: false,\n                    });\n                    // Copy the mtime/ctime of a renamed directory\n                    if (doRename) {\n                        await updateTime(to, ctime, fromObj.mtime);\n                    }\n                }\n                catch (e) {\n                    // ignore\n                }\n                // Iterate over the contents of the from location\n                const contents = (await this.readdir({\n                    path: from,\n                    directory: fromDirectory,\n                })).files;\n                for (const filename of contents) {\n                    // Move item from the from directory to the to directory\n                    await this._copy({\n                        from: `${from}/${filename.name}`,\n                        to: `${to}/${filename.name}`,\n                        directory: fromDirectory,\n                        toDirectory,\n                    }, doRename);\n                }\n                // Optionally remove the original from directory\n                if (doRename) {\n                    await this.rmdir({\n                        path: from,\n                        directory: fromDirectory,\n                    });\n                }\n            }\n        }\n        return {\n            uri: toPath,\n        };\n    }\n    isBase64String(str) {\n        try {\n            return btoa(atob(str)) == str;\n        }\n        catch (err) {\n            return false;\n        }\n    }\n}\nFilesystemWeb._debug = true;\n\nvar web = /*#__PURE__*/Object.freeze({\n    __proto__: null,\n    FilesystemWeb: FilesystemWeb\n});\n\nexports.Filesystem = Filesystem;\nexports.FilesystemDirectory = FilesystemDirectory;\nexports.FilesystemEncoding = FilesystemEncoding;\n//# sourceMappingURL=plugin.cjs.js.map\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$$capacitor$core$dist$index_cjs"]],"~:properties",["^5",["DB_NAME","folder","url","onerror","web","Encoding","Filesystem","FilesystemDirectory","blob","toDirectory","onsuccess","uri","__esModule","directory","path","encoding","FilesystemEncoding","files","downloadFile","Directory","keyPath","name","FilesystemWeb","value","onupgradeneeded","publicStorage","_debug","bytes","content","ctime","type","DB_VERSION","__proto__","from","recursive","onblocked","size","to","data","_db","contentLength","_writeCmds","mtime"]],"~:compiled-at",1766065009529,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$capacitor$filesystem$dist$plugin_cjs.js\",\n\"lineCount\":21,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAiH9DC,QAASA,EAAO,CAACC,CAAD,CAAO,CAEnB,MAAMC,EAAW,EADHD,EAAKE,CAAAA,KAAL,CAAW,GAAX,CAAgBC,CAAAA,MAAhBC,CAAuBC,CAAA,EAAiB,GAAjB,GAAQA,CAA/BD,CAERE,CAAAA,OAAN,CAAcD,CAAA,EAAQ,CACL,IAAb,GAAIA,CAAJ,EACsB,CADtB,CACIJ,CAASM,CAAAA,MADb,EAEsC,IAFtC,GAEIN,CAAA,CAASA,CAASM,CAAAA,MAAlB,CAA2B,CAA3B,CAFJ,CAGIN,CAASO,CAAAA,GAAT,EAHJ,CAMIP,CAASQ,CAAAA,IAAT,CAAcJ,CAAd,CAPc,CAAtB,CAUA,OAAOJ,EAASS,CAAAA,IAAT,CAAc,GAAd,CAbY,CAevBC,QAASA,EAAY,CAACC,CAAD,CAASC,CAAT,CAAmB,CACpCD,CAAA,CAASb,CAAA,CAAQa,CAAR,CACTC,EAAA,CAAWd,CAAA,CAAQc,CAAR,CACX,OAAMC,EAASF,CAAOV,CAAAA,KAAP,CAAa,GAAb,CAAf,CACMa,EAASF,CAASX,CAAAA,KAAT,CAAe,GAAf,CACf,OAAQU,EAAR,GAAmBC,CAAnB,EACIC,CAAOE,CAAAA,KAAP,CAAa,CAACC,CAAD,CAAQC,CAAR,CAAA,EAAkBD,CAAlB,GAA4BF,CAAA,CAAOG,CAAP,CAAzC,CANgC,CA7HxCC,MAAOC,CAAAA,cAAP,CAAsBtB,CAAtB,CAA+B,YAA/B,CAA6C,CAAEmB,MAAO,CAAA,CAAT,CAA7C,CAEA,KAAII,EAAOzB,CAAA,CAAQ,CAAR,CAEXE,EAAQwB,CAAAA,SAAR,CAAoB,IAAK,EACxB,UAAS,CAACA,CAAD,CAAY,CAalBA,CAAA,CAAA,SAAA,CAAyB,WASzBA,EAAA,CAAA,IAAA,CAAoB,MASpBA,EAAA,CAAA,OAAA,CAAuB,SAQvBA,EAAA,CAAA,KAAA,CAAqB,OAYrBA,EAAA,CAAA,QAAA,CAAwB,UAYxBA,EAAA,CAAA,eAAA;AAA+B,kBA/Db,CAArB,CAAD,CAgEGxB,CAAQwB,CAAAA,SAhEX,GAgEyBxB,CAAQwB,CAAAA,SAhEjC,CAgE6C,EAhE7C,EAiEAxB,EAAQyB,CAAAA,QAAR,CAAmB,IAAK,EACvB,UAAS,CAACA,CAAD,CAAW,CAMjBA,CAAA,CAAA,IAAA,CAAmB,MAQnBA,EAAA,CAAA,KAAA,CAAoB,OAQpBA,EAAA,CAAA,KAAA,CAAoB,OAtBH,CAApB,CAAD,CAuBGzB,CAAQyB,CAAAA,QAvBX,GAuBwBzB,CAAQyB,CAAAA,QAvBhC,CAuB2C,EAvB3C,EA4BMC,GAAAA,CAAsB1B,CAAQwB,CAAAA,SAK9BG,EAAAA,CAAqB3B,CAAQyB,CAAAA,QAE7BG,GAAAA,CAAaL,CAAKM,CAAAA,cAAL,CAAoB,YAApB,CAAkC,CACjDC,IAAK,EAAAA,EAAMC,OAAQ9B,CAAAA,OAAR,EAAkB+B,CAAAA,IAAlB,CAAuB,QAAS,EAAG,CAAE,MAAOF,EAAT,CAAnC,CAAoDE,CAAAA,IAApD,CAAyDC,CAAA,EAAK,IAAIA,CAAEC,CAAAA,aAApE,CADsC,CAAlC,CA2BnB,MAAMA,EAAN,QAA4BX,EAAKY,CAAAA,SAAjC,CACIC,WAAW,EAAG,CACV,KAAA,CAAM,GAAGC,SAAT,CACA,KAAKC,CAAAA,UAAL,CAAkB,CAClB,KAAKC,CAAAA,OAAL,CAAe,MACf,KAAKC,CAAAA,UAAL,CAAkB,CAAC,KAAD,CAAQ,KAAR,CAAe,QAAf,CAOlB,KAAKC,CAAAA,YAAL,CAA2BC,CAAPC,EAAmB,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAAA,IAC/BC,CAD+B;AAC3BC,CAD2B,CAE7BC,EAAcvB,CAAKwB,CAAAA,gBAAL,CAAsBL,CAAtB,CAA+BA,CAAQM,CAAAA,aAAvC,CAFe,CAG7BC,EAAW,KAAMC,MAAA,CAAMR,CAAQS,CAAAA,GAAd,CAAmBL,CAAnB,CAEvB,IAAKJ,CAAQU,CAAAA,QAAb,CAEK,GAAmB,IAAb,GAAAH,CAAA,EAAkC,IAAK,EAAvC,GAAqBA,CAArB,CAA2C,CAA3C,CAAoDA,CAASI,CAAAA,IAAnE,CAEA,CACD,IAAMC,EAASL,CAASI,CAAAA,IAAKE,CAAAA,SAAd,EAAf,CACIC,EAAQ,CACNC,EAAAA,CAAS,EACf,OAAMC,EAAcT,CAASU,CAAAA,OAAQC,CAAAA,GAAjB,CAAqB,cAArB,CAEpB,KADMC,CACN,CADsBC,QAAA,CAASb,CAASU,CAAAA,OAAQC,CAAAA,GAAjB,CAAqB,gBAArB,CAAT,EAAmD,GAAnD,CAAwD,EAAxD,CACtB,CAAA,CAAA,CAAa,CACT,MAAM,CAAE,KAAAG,CAAF,CAAQ,MAAA5C,CAAR,CAAA,CAAkB,KAAMmC,EAAOU,CAAAA,IAAP,EAC9B,IAAID,CAAJ,CACI,KACJN,EAAO9C,CAAAA,IAAP,CAAYQ,CAAZ,CACAqC,EAAA,GAAoB,IAAV,GAAArC,CAAA,EAA4B,IAAK,EAAjC,GAAkBA,CAAlB,CAAqC,IAAK,EAA1C,CAA8CA,CAAMV,CAAAA,MAA9D,GAAyE,CAMzE,EAAKwD,CAAAA,eAAL,CAAqB,UAArB,CALeC,CACXf,IAAKT,CAAQS,CAAAA,GADFe,CAEXV,MAAAA,CAFWU,CAGXL,cAAAA,CAHWK,CAKf,CAXS,CAaPC,CAAAA,CAAY,IAAIC,UAAJ,CAAeZ,CAAf,CACda,EAAAA,CAAW,CACf,KAAWC,CAAX,GAAoBb,EAApB,CACyB,WAArB,GAAI,MAAOa,EAAX,GAEAH,CAAUI,CAAAA,GAAV,CAAcD,CAAd,CAAqBD,CAArB,CACA,CAAAA,CAAA,EAAYC,CAAM7D,CAAAA,MAHlB,CAKJ,KAAA+D;AAAO,IAAIC,IAAJ,CAAS,CAACN,CAAUO,CAAAA,MAAX,CAAT,CAA6B,CAAEC,KAAMjB,CAANiB,EAAqBC,IAAAA,EAAvB,CAA7B,CA3BN,CAFA,IACDJ,EAAA,CAAO,IAAIC,IAHf,KACID,EAAA,CAAO,KAAMvB,EAASuB,CAAAA,IAAT,EAsCjB,OAAO,CAAEtE,KAAa2E,CANPC,KAAM,EAAKC,CAAAA,SAAL,CAAe,CAChC7E,KAAMwC,CAAQxC,CAAAA,IADkB,CAEhC8E,UAAwC,IAA7B,IAACpC,CAAD,CAAMF,CAAQsC,CAAAA,SAAd,GAA4C,IAAK,EAAjD,GAAqCpC,CAArC,CAAqDA,CAArD,CAA0DgC,IAAAA,EAFrC,CAGhCK,UAAwC,IAA7B,IAACpC,CAAD,CAAMH,CAAQuC,CAAAA,SAAd,GAA4C,IAAK,EAAjD,GAAqCpC,CAArC,CAAqDA,CAArD,CAA0D,CAAA,CAHrC,CAIhCqC,KAAMV,CAJ0B,CAAf,CAMCK,EAAAA,GAAf,CAAoBL,KAAAA,CAApB,CA5C4B,CAAA,CAAA,CAX7B,CA0DRW,MAAM,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACX,GAAiBP,IAAAA,EAAjB,GAAI,CAAKQ,CAAAA,GAAT,CACI,MAAO,EAAKA,CAAAA,GAEhB,IAAI,EAAE,WAAF,EAAiBC,OAAjB,CAAJ,CACI,KAAM,EAAKC,CAAAA,WAAL,CAAiB,wCAAjB,CAAN,CAEJ,MAAO,KAAIvD,OAAJ,CAAY,CAAC9B,CAAD,CAAUsF,CAAV,CAAA,EAAqB,CACpC,MAAMC,EAAUC,SAAUC,CAAAA,IAAV,CAAe,CAAKnD,CAAAA,OAApB;AAA6B,CAAKD,CAAAA,UAAlC,CAChBkD,EAAQG,CAAAA,eAAR,CAA0BzD,CAAc0D,CAAAA,SACxCJ,EAAQK,CAAAA,SAAR,CAAoB,EAAAC,EAAM,CACtB,CAAKV,CAAAA,GAAL,CAAWI,CAAQV,CAAAA,MACnB7E,EAAA,CAAQuF,CAAQV,CAAAA,MAAhB,CAFsB,CAI1BU,EAAQO,CAAAA,OAAR,CAAkB,EAAAC,EAAMT,CAAA,CAAOC,CAAQS,CAAAA,KAAf,CACxBT,EAAQU,CAAAA,SAAR,CAAoB,EAAAC,EAAM,CACtBC,OAAQC,CAAAA,IAAR,CAAa,YAAb,CADsB,CARU,CAAjC,CAPI,CAAA,CAAA,CAoBRT,gBAAS,CAACU,CAAD,CAAQ,CAEdC,CAAAA,CADcD,CAAME,CAAAA,MACH1B,CAAAA,MAKXyB,EAAGE,CAAAA,gBAAiBC,CAAAA,QAApB,CAA6B,aAA7B,CAAJ,EACIH,CAAGI,CAAAA,iBAAH,CAAqB,aAArB,CAEUJ,EAAGK,CAAAA,iBAAHC,CAAqB,aAArBA,CAAoC,CAAEC,QAAS,MAAX,CAApCD,CACRE,CAAAA,WAAN,CAAkB,WAAlB,CAA+B,QAA/B,CAXY,CAelBC,SAAS,CAACC,CAAD,CAAMC,CAAN,CAAY,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACvB,MAAMC,EAA4C,CAAC,CAAlC,GAAA,CAAK3E,CAAAA,UAAW4E,CAAAA,OAAhB,CAAwBH,CAAxB,CAAA,CAAsC,WAAtC;AAAoD,UACrE,OAAO,EAAK9B,CAAAA,MAAL,EAAcnD,CAAAA,IAAd,CAAoBqF,CAAD,EACf,IAAItF,OAAJ,CAAY,CAAC9B,CAAD,CAAUsF,CAAV,CAAA,EAAqB,CAGpC,MAAM+B,EAFKD,CAAKE,CAAAA,WAALC,CAAiB,CAAC,aAAD,CAAjBA,CAAkCL,CAAlCK,CACMC,CAAAA,WAAHZ,CAAe,aAAfA,CACF,CAAMI,CAAN,CAAA,CAAW,GAAGC,CAAd,CACZI,EAAIzB,CAAAA,SAAJ,CAAgB,EAAA6B,EAAMzH,CAAA,CAAQqH,CAAIxC,CAAAA,MAAZ,CACtBwC,EAAIvB,CAAAA,OAAJ,CAAc,EAAA4B,EAAMpC,CAAA,CAAO+B,CAAIrB,CAAAA,KAAX,CALgB,CAAjC,CADJ,CAFgB,CAAA,CAAA,CAYrB2B,cAAc,CAACC,CAAD,CAAYZ,CAAZ,CAAiBC,CAAjB,CAAuB,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACvC,MAAMC,EAA4C,CAAC,CAAlC,GAAA,CAAK3E,CAAAA,UAAW4E,CAAAA,OAAhB,CAAwBH,CAAxB,CAAA,CAAsC,WAAtC,CAAoD,UACrE,OAAO,EAAK9B,CAAAA,MAAL,EAAcnD,CAAAA,IAAd,CAAoBqF,CAAD,EACf,IAAItF,OAAJ,CAAY,CAAC9B,CAAD,CAAUsF,CAAV,CAAA,EAAqB,CAIpC,MAAM+B,EAHKD,CAAKE,CAAAA,WAALC,CAAiB,CAAC,aAAD,CAAjBA,CAAkCL,CAAlCK,CACMC,CAAAA,WAAHZ,CAAe,aAAfA,CACMzF,CAAAA,KAANA,CAAYyG,CAAZzG,CACF,CAAM6F,CAAN,CAAA,CAAW,GAAGC,CAAd,CACZI,EAAIzB,CAAAA,SAAJ,CAAgB,EAAA6B,EAAMzH,CAAA,CAAQqH,CAAIxC,CAAAA,MAAZ,CACtBwC;CAAIvB,CAAAA,OAAJ,CAAc,EAAA4B,EAAMpC,CAAA,CAAO+B,CAAIrB,CAAAA,KAAX,CANgB,CAAjC,CADJ,CAFgC,CAAA,CAAA,CAa3C6B,OAAO,CAAC9C,CAAD,CAAY+C,CAAZ,CAAqB,CACxB,MAAMC,EAA6BpD,IAAAA,EAAZ,GAAAmD,CAAA,CAAwBA,CAAQE,CAAAA,OAAR,CAAgB,cAAhB,CAAgC,EAAhC,CAAxB,CAA8D,EACrF,KAAIC,EAAS,EACKtD,KAAAA,EAAlB,GAAII,CAAJ,GACIkD,CADJ,EACc,GADd,CACoBlD,CADpB,CAEgB,GAAhB,GAAI+C,CAAJ,GACIG,CADJ,EACc,GADd,CACoBF,CADpB,CAEA,OAAOE,EAPiB,CAStBC,KAAK,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAEMZ,CADHF,KAAM,EAAKlC,CAAAA,MAAL,EACHoC,EAAAA,WAALC,CAAiB,CAAC,aAAD,CAAjBA,CAAkC,WAAlCA,CACMC,CAAAA,WAAHZ,CAAe,aAAfA,CACRsB,CAAAA,KAAN,EAJU,CAAA,CAAA,CAWRC,QAAQ,CAAC1F,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACpB,IAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CAEPmI,EAAAA,CAAS,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CACrB,IAAc0E,IAAAA,EAAd;AAAIyD,CAAJ,CACI,KAAMC,MAAA,CAAM,sBAAN,CAAN,CACJ,MAAO,CAAEpD,KAAMmD,CAAME,CAAAA,OAAN,CAAgBF,CAAME,CAAAA,OAAtB,CAAgC,EAAxC,CANa,CAAA,CAAA,CAalBxD,SAAS,CAACrC,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACrB,IAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CACb,KAAIgF,EAAOxC,CAAQwC,CAAAA,IACnB,KAAMsD,EAAW9F,CAAQ8F,CAAAA,QACzB,OAAMC,EAAc/F,CAAQuC,CAAAA,SAC5B,KAAMyD,EAAiB,KAAM,EAAK1B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CAC7B,IAAIwI,CAAJ,EAA4C,WAA5C,GAAqBA,CAAc/D,CAAAA,IAAnC,CACI,KAAM2D,MAAA,CAAM,mCAAN,CAAN,CACEK,CAAAA,CAAazI,CAAK0I,CAAAA,MAAL,CAAY,CAAZ,CAAe1I,CAAK2I,CAAAA,WAAL,CAAiB,GAAjB,CAAf,CAEnB,IAAoBjE,IAAAA,EAApB,IADqBkE,KAAM,EAAK9B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC2B,CAAD,CAAtB,CAC3B,EAA+B,CAC3B,IAAMI,EAAcJ,CAAWvB,CAAAA,OAAX,CAAmB,GAAnB,CAAwB,CAAxB,CACA,EAAC,CAArB,GAAI2B,CAAJ,GACUC,CACN,CADsBL,CAAWC,CAAAA,MAAX,CAAkBG,CAAlB,CACtB,CAAA,KAAM,EAAKE,CAAAA,KAAL,CAAW,CACb/I,KAAM8I,CADO;AAEbhE,UAAWtC,CAAQsC,CAAAA,SAFN,CAGbC,UAAWwD,CAHE,CAAX,CAFV,CAF2B,CAW/B,GAAI,EAACD,CAAD,EAAetD,CAAf,WAA+BT,KAA/B,GACAS,CACI,CADwB,CAArB,EAAAA,CAAKkC,CAAAA,OAAL,CAAa,GAAb,CAAA,CAAyBlC,CAAK9E,CAAAA,KAAL,CAAW,GAAX,CAAA,CAAgB,CAAhB,CAAzB,CAA8C8E,CACjD,CAAC,CAAKgE,CAAAA,cAAL,CAAoBhE,CAApB,CAFL,EAAJ,CAGQ,KAAMoD,MAAA,CAAM,gDAAN,CAAN,CAEFa,CAAAA,CAAMC,IAAKD,CAAAA,GAAL,EACNE,EAAAA,CAAU,CACZnJ,KAAMA,CADM,CAEZoJ,OAAQX,CAFI,CAGZhE,KAAM,MAHM,CAIZ4E,KAAMrE,CAAA,WAAgBT,KAAhB,CAAuBS,CAAKqE,CAAAA,IAA5B,CAAmCrE,CAAKzE,CAAAA,MAJlC,CAKZ+I,MAAOL,CALK,CAMZM,MAAON,CANK,CAOZZ,QAASrD,CAPG,CAShB,MAAM,EAAK8B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAACqC,CAAD,CAAtB,CACN,OAAO,CACHxE,IAAKwE,CAAQnJ,CAAAA,IADV,CArCc,CAAA,CAAA,CA8CnBwJ,UAAU,CAAChH,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACtB,MAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CACb,KAAIgF,EAAOxC,CAAQwC,CAAAA,IACnB,OAAMsD,EAAW9F,CAAQ8F,CAAAA,QAAzB;AACMG,EAAazI,CAAK0I,CAAAA,MAAL,CAAY,CAAZ,CAAe1I,CAAK2I,CAAAA,WAAL,CAAiB,GAAjB,CAAf,CADnB,CAEMM,EAAMC,IAAKD,CAAAA,GAAL,EACZ,KAAIK,EAAQL,CACZ,OAAMT,EAAiB,KAAM,EAAK1B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CAC7B,IAAIwI,CAAJ,EAA4C,WAA5C,GAAqBA,CAAc/D,CAAAA,IAAnC,CACI,KAAM2D,MAAA,CAAM,mCAAN,CAAN,CAEJ,GAAoB1D,IAAAA,EAApB,IADqBkE,KAAM,EAAK9B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC2B,CAAD,CAAtB,CAC3B,EAA+B,CAC3B,IAAMI,EAAcJ,CAAWvB,CAAAA,OAAX,CAAmB,GAAnB,CAAwB,CAAxB,CACA,EAAC,CAArB,GAAI2B,CAAJ,GACUC,CACN,CADsBL,CAAWC,CAAAA,MAAX,CAAkBG,CAAlB,CACtB,CAAA,KAAM,EAAKE,CAAAA,KAAL,CAAW,CACb/I,KAAM8I,CADO,CAEbhE,UAAWtC,CAAQsC,CAAAA,SAFN,CAGbC,UAAW,CAAA,CAHE,CAAX,CAFV,CAF2B,CAW/B,GAAI,CAACuD,CAAL,EAAiB,CAAC,CAAKU,CAAAA,cAAL,CAAoBhE,CAApB,CAAlB,CACI,KAAMoD,MAAA,CAAM,gDAAN,CAAN,CACJ,GAAsB1D,IAAAA,EAAtB,GAAI8D,CAAJ,CAAiC,CAC7B,GAAIA,CAAcH,CAAAA,OAAlB,WAAqC9D,KAArC,CACI,KAAM6D,MAAA,CAAM,wEAAN,CAAN;AAMApD,CAAA,CAJ0BN,IAAAA,EAA9B,GAAI8D,CAAcH,CAAAA,OAAlB,EAA4CC,CAA5C,CAIWE,CAAcH,CAAAA,OAJzB,CAImCrD,CAJnC,CACWyE,IAAA,CAAKC,IAAA,CAAKlB,CAAcH,CAAAA,OAAnB,CAAL,CAAmCqB,IAAA,CAAK1E,CAAL,CAAnC,CAKXsE,EAAA,CAAQd,CAAcc,CAAAA,KAVO,CAqBjC,KAAM,EAAKxC,CAAAA,SAAL,CAAe,KAAf,CAAsB,CATZqC,CACZnJ,KAAMA,CADMmJ,CAEZC,OAAQX,CAFIU,CAGZ1E,KAAM,MAHM0E,CAIZE,KAAMrE,CAAKzE,CAAAA,MAJC4I,CAKZG,MAAOA,CALKH,CAMZI,MAAON,CANKE,CAOZd,QAASrD,CAPGmE,CASY,CAAtB,CA7CgB,CAAA,CAAA,CAoDpBQ,UAAU,CAACnH,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACtB,MAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CAEb,IAAc0E,IAAAA,EAAd,IADeyD,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CACrB,EACI,KAAMoI,MAAA,CAAM,sBAAN,CAAN,CAIJ,GAAuB,CAAvB,GAAY7H,CAHIqJ,KAAM,EAAKlC,CAAAA,cAAL,CAAoB,WAApB,CAAiC,YAAjC,CAA+C,CACjEmC,WAAYC,CAAAA,IAAZ,CAAiB9J,CAAjB,CADiE,CAA/C,CAGVO,EAAAA,MAAZ,CACI,KAAM6H,MAAA,CAAM,sBAAN,CAAN;AACJ,KAAM,EAAKtB,CAAAA,SAAL,CAAe,QAAf,CAAyB,CAAC9G,CAAD,CAAzB,CAVgB,CAAA,CAAA,CAiBpB+I,KAAK,CAACvG,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACjB,MAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CACb,KAAMuI,EAAc/F,CAAQuC,CAAAA,SAC5B,OAAM0D,EAAazI,CAAK0I,CAAAA,MAAL,CAAY,CAAZ,CAAe1I,CAAK2I,CAAAA,WAAL,CAAiB,GAAjB,CAAf,CACnB,KAAMoB,EAAkCxJ,CAAzBP,CAAKgK,CAAAA,KAAL,CAAW,KAAX,CAAyBzJ,EAAJ,EAAIA,EAAAA,MACxC,OAAMqI,EAAe,KAAM,EAAK9B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC2B,CAAD,CAAtB,CAA3B,CACMD,EAAiB,KAAM,EAAK1B,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CAC7B,IAAc,CAAd,GAAI+J,CAAJ,CACI,KAAM3B,MAAA,CAAM,8BAAN,CAAN,CACJ,GAAsB1D,IAAAA,EAAtB,GAAI8D,CAAJ,CACI,KAAMJ,MAAA,CAAM,uCAAN,CAAN,CACJ,GAAI,CAACG,CAAL,EAA8B,CAA9B,GAAoBwB,CAApB,EAAmDrF,IAAAA,EAAnD,GAAmCkE,CAAnC,CACI,KAAMR,MAAA,CAAM,6BAAN,CAAN;AACAG,CAAJ,EAA6B,CAA7B,GAAmBwB,CAAnB,EAAkDrF,IAAAA,EAAlD,GAAkCkE,CAAlC,GACUE,CACN,CADsBL,CAAWC,CAAAA,MAAX,CAAkBD,CAAWvB,CAAAA,OAAX,CAAmB,GAAnB,CAAwB,CAAxB,CAAlB,CACtB,CAAA,KAAM,EAAK6B,CAAAA,KAAL,CAAW,CACb/I,KAAM8I,CADO,CAEbhE,UAAWtC,CAAQsC,CAAAA,SAFN,CAGbC,UAAWwD,CAHE,CAAX,CAFV,CAQMU,EAAAA,CAAMC,IAAKD,CAAAA,GAAL,EASZ,MAAM,EAAKnC,CAAAA,SAAL,CAAe,KAAf,CAAsB,CARZqC,CACZnJ,KAAMA,CADMmJ,CAEZC,OAAQX,CAFIU,CAGZ1E,KAAM,WAHM0E,CAIZE,KAAM,CAJMF,CAKZG,MAAOL,CALKE,CAMZI,MAAON,CANKE,CAQY,CAAtB,CA9BW,CAAA,CAAA,CAoCfc,KAAK,CAACzH,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACjB,MAAM,CAAE,KAAAxC,CAAF,CAAQ,UAAA8E,CAAR,CAAmB,UAAAC,CAAnB,CAAA,CAAiCvC,CAAvC,CACM0H,EAAW,CAAKtC,CAAAA,OAAL,CAAa9C,CAAb,CAAwB9E,CAAxB,CACjB,KAAMmI,EAAS,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAACoD,CAAD,CAAtB,CACrB,IAAcxF,IAAAA,EAAd,GAAIyD,CAAJ,CACI,KAAMC,MAAA,CAAM,wBAAN,CAAN,CACJ,GAAmB,WAAnB,GAAID,CAAM1D,CAAAA,IAAV,CACI,KAAM2D,MAAA,CAAM,mCAAN,CAAN;AACE+B,CAAAA,CAAgB,KAAM,EAAKC,CAAAA,OAAL,CAAa,CAAEpK,KAAAA,CAAF,CAAQ8E,UAAAA,CAAR,CAAb,CAC5B,IAAmC,CAAnC,GAAIqF,CAAcE,CAAAA,KAAM9J,CAAAA,MAAxB,EAAwC,CAACwE,CAAzC,CACI,KAAMqD,MAAA,CAAM,qBAAN,CAAN,CACJ,IAAK,MAAMD,CAAX,GAAoBgC,EAAcE,CAAAA,KAAlC,CACUC,CAEN,CAFmB,GAAEtK,CAAF,IAAUmI,CAAMoC,CAAAA,IAAhB,EAEnB,CAAsB,MAAtB,GAAa9F,CADI+F,KAAM,EAAKC,CAAAA,IAAL,CAAU,CAAEzK,KAAMsK,CAAR,CAAmBxF,UAAAA,CAAnB,CAAV,CACVL,EAAAA,IAAb,CACI,KAAM,EAAKkF,CAAAA,UAAL,CAAgB,CAAE3J,KAAMsK,CAAR,CAAmBxF,UAAAA,CAAnB,CAAhB,CADV,CAII,KAAM,EAAKmF,CAAAA,KAAL,CAAW,CAAEjK,KAAMsK,CAAR,CAAmBxF,UAAAA,CAAnB,CAA8BC,UAAAA,CAA9B,CAAX,CAGd,MAAM,EAAK+B,CAAAA,SAAL,CAAe,QAAf,CAAyB,CAACoD,CAAD,CAAzB,CArBW,CAAA,CAAA,CA4BfE,OAAO,CAAC5H,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACnB,MAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CACb,KAAMmI,EAAS,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CACrB,IAAqB,EAArB,GAAIwC,CAAQxC,CAAAA,IAAZ,EAAqC0E,IAAAA,EAArC;AAA2ByD,CAA3B,CACI,KAAMC,MAAA,CAAM,wBAAN,CAAN,CACEwB,CAAAA,CAAU,KAAM,EAAKlC,CAAAA,cAAL,CAAoB,WAApB,CAAiC,YAAjC,CAA+C,CAACmC,WAAYC,CAAAA,IAAZ,CAAiB9J,CAAjB,CAAD,CAA/C,CAetB,OAAO,CAAEqK,MAdKA,KAAMxI,QAAQ6I,CAAAA,GAAR,CAAYd,CAAQe,CAAAA,GAAR,CAAmBC,CAAP,EAAa,OAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACrD,IAAIC,EAAY,KAAM,EAAK/D,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC8D,CAAD,CAAtB,CACLlG,KAAAA,EAAjB,GAAImG,CAAJ,GACIA,CADJ,CACgB,KAAM,EAAK/D,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC8D,CAAD,CAAK,GAAL,CAAtB,CADtB,CAGA,OAAO,CACHL,KAAMK,CAAEE,CAAAA,SAAF,CAAY9K,CAAKO,CAAAA,MAAjB,CAA0B,CAA1B,CADH,CAEHkE,KAAMoG,CAASpG,CAAAA,IAFZ,CAGH4E,KAAMwB,CAASxB,CAAAA,IAHZ,CAIHC,MAAOuB,CAASvB,CAAAA,KAJb,CAKHC,MAAOsB,CAAStB,CAAAA,KALb,CAMH5E,IAAKkG,CAAS7K,CAAAA,IANX,CAL8C,CAAA,CAAzB,CAAZ,CAcb,CApBY,CAAA,CAAA,CA2BjB+K,MAAM,CAACvI,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAClB,MAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB;AAAgCtC,CAAQxC,CAAAA,IAAxC,CACb,KAAImI,EAAS,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CACL0E,KAAAA,EAAd,GAAIyD,CAAJ,GACIA,CADJ,CACa,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAQ,GAAR,CAAtB,CADnB,CAGA,OAAO,CACH2E,KAAgB,IAAV,GAAAwD,CAAA,EAA4B,IAAK,EAAjC,GAAkBA,CAAlB,CAAqC,IAAK,EAA1C,CAA8CA,CAAMnI,CAAAA,IAA1D2E,GAAmE3E,CADhE,CANW,CAAA,CAAA,CAehByK,IAAI,CAACjI,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAChB,MAAMxC,EAAO,CAAK4H,CAAAA,OAAL,CAAapF,CAAQsC,CAAAA,SAArB,CAAgCtC,CAAQxC,CAAAA,IAAxC,CACb,KAAImI,EAAS,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAtB,CACL0E,KAAAA,EAAd,GAAIyD,CAAJ,GACIA,CADJ,CACa,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAAC9G,CAAD,CAAQ,GAAR,CAAtB,CADnB,CAGA,IAAc0E,IAAAA,EAAd,GAAIyD,CAAJ,CACI,KAAMC,MAAA,CAAM,uBAAN,CAAN,CACJ,MAAO,CACH3D,KAAM0D,CAAM1D,CAAAA,IADT,CAEH4E,KAAMlB,CAAMkB,CAAAA,IAFT,CAGHC,MAAOnB,CAAMmB,CAAAA,KAHV,CAIHC,MAAOpB,CAAMoB,CAAAA,KAJV,CAKH5E,IAAKwD,CAAMnI,CAAAA,IALR,CARS,CAAA,CAAA,CAqBdgL,MAAM,CAACxI,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAClB,KAAM,EAAKyI,CAAAA,KAAL,CAAWzI,CAAX;AAAoB,CAAA,CAApB,CADY,CAAA,CAAA,CAShB0I,IAAI,CAAC1I,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAChB,MAAO,EAAKyI,CAAAA,KAAL,CAAWzI,CAAX,CAAoB,CAAA,CAApB,CADS,CAAA,CAAA,CAGd2I,kBAAkB,EAAG,CAAA,MAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACvB,MAAO,CAAEC,cAAe,SAAjB,CADgB,CAAA,CAAA,CAGrBC,gBAAgB,EAAG,CAAA,MAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACrB,MAAO,CAAED,cAAe,SAAjB,CADc,CAAA,CAAA,CASnBH,KAAK,CAACzI,CAAD,CAAU8I,CAAA,CAAW,CAAA,CAArB,CAA4B,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACnC,IAAI,CAAE,YAAAC,CAAF,CAAA,CAAkB/I,CACtB,OAAM,CAAE,GAAAgJ,CAAF,CAAM,KAAAC,CAAN,CAAY,UAAWC,CAAvB,CAAA,CAAyClJ,CAC/C,IAAI,CAACgJ,CAAL;AAAW,CAACC,CAAZ,CACI,KAAMrD,MAAA,CAAM,mCAAN,CAAN,CAGCmD,CAAL,GACIA,CADJ,CACkBG,CADlB,CAGA,KAAMC,EAAW,CAAK/D,CAAAA,OAAL,CAAa8D,CAAb,CAA4BD,CAA5B,CAAjB,CACMG,EAAS,CAAKhE,CAAAA,OAAL,CAAa2D,CAAb,CAA0BC,CAA1B,CAEf,IAAIG,CAAJ,GAAiBC,CAAjB,CACI,MAAO,CACHjH,IAAKiH,CADF,CAIX,IAAIjL,CAAA,CAAagL,CAAb,CAAuBC,CAAvB,CAAJ,CACI,KAAMxD,MAAA,CAAM,sCAAN,CAAN,CAGJ,IAAIyD,CACJ,IAAI,CACAA,CAAA,CAAQ,KAAM,EAAKpB,CAAAA,IAAL,CAAU,CACpBzK,KAAMwL,CADc,CAEpB1G,UAAWyG,CAFS,CAAV,CADd,CAMJ,MAAOX,CAAP,CAAU,CAEAkB,CAAAA,CAAmBN,CAAGtL,CAAAA,KAAH,CAAS,GAAT,CACzB4L,EAAiBtL,CAAAA,GAAjB,EACA,KAAMoL,EAASE,CAAiBpL,CAAAA,IAAjB,CAAsB,GAAtB,CAEf,IAA8B,CAA9B,CAAIoL,CAAiBvL,CAAAA,MAArB,EAKmC,WALnC,GAK0BkE,CAJIsH,KAAM,EAAKtB,CAAAA,IAAL,CAAU,CACtCzK,KAAM4L,CADgC,CAEtC9G,UAAWyG,CAF2B,CAAV,CAIV9G,EAAAA,IAL1B,CAMQ,KAAU2D,MAAJ,CAAU,2CAAV,CAAN,CAZF,CAiBV,GAAIyD,CAAJ,EAA4B,WAA5B,GAAaA,CAAMpH,CAAAA,IAAnB,CACI,KAAU2D,MAAJ,CAAU,0CAAV,CAAN,CAGE4D,CAAAA,CAAU,KAAM,EAAKvB,CAAAA,IAAL,CAAU,CAC5BzK,KAAMyL,CADsB;AAE5B3G,UAAW4G,CAFiB,CAAV,CAKhBO,EAAAA,CAAmB,CAACjM,CAAD,CAAOsJ,CAAP,CAAcC,CAAd,CAAN0C,EAA8B,OAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAC7C,IAAM/B,EAAW,CAAKtC,CAAAA,OAAL,CAAa2D,CAAb,CAA0BvL,CAA1B,CACXmI,EAAAA,CAAS,KAAM,EAAKrB,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAACoD,CAAD,CAAtB,CACrB/B,EAAMmB,CAAAA,KAAN,CAAcA,CACdnB,EAAMoB,CAAAA,KAAN,CAAcA,CACd,MAAM,EAAKzC,CAAAA,SAAL,CAAe,KAAf,CAAsB,CAACqB,CAAD,CAAtB,CALuC,CAAA,CAOjD,OAAMmB,EAAQ0C,CAAQ1C,CAAAA,KAAR,CAAgB0C,CAAQ1C,CAAAA,KAAxB,CAAgCJ,IAAKD,CAAAA,GAAL,EAC9C,QAAQ+C,CAAQvH,CAAAA,IAAhB,EAEI,KAAK,MAAL,CAEUyH,CAAAA,CAAO,KAAM,EAAKhE,CAAAA,QAAL,CAAc,CAC7BlI,KAAMyL,CADuB,CAE7B3G,UAAW4G,CAFkB,CAAd,CAKfJ,EAAJ,GACI,KAAM,EAAK3B,CAAAA,UAAL,CAAgB,CAClB3J,KAAMyL,CADY,CAElB3G,UAAW4G,CAFO,CAAhB,CADV,CAOA,IAAI,EAAEQ,CAAKlH,CAAAA,IAAP,WAAuBT,KAAvB,EAAiC,CAAKyE,CAAAA,cAAL,CAAoBkD,CAAKlH,CAAAA,IAAzB,CAAjC,CAAJ,CACI,IAAAsD,EAAWxI,CAAQyB,CAAAA,QAAS4K,CAAAA,IAG1BC,EAAAA,CAAc,KAAM,EAAKvH,CAAAA,SAAL,CAAe,CACrC7E,KAAMwL,CAD+B,CAErC1G,UAAWyG,CAF0B,CAGrCvG,KAAMkH,CAAKlH,CAAAA,IAH0B,CAIrCsD,SAAUA,CAJ2B,CAAf,CAOtBgD,EAAJ,GACI,KAAMW,EAAA,CAAWT,CAAX,CAAelC,CAAf,CAAsB0C,CAAQzC,CAAAA,KAA9B,CADV,CAIA;MAAO6C,EAEX,MAAK,WAAL,CACI,GAAIP,CAAJ,CACI,KAAMzD,MAAA,CAAM,iDAAN,CAAN,CAEJ,GAAI,CAEA,KAAM,EAAKW,CAAAA,KAAL,CAAW,CACb/I,KAAMwL,CADO,CAEb1G,UAAWyG,CAFE,CAGbxG,UAAW,CAAA,CAHE,CAAX,CAMN,CAAIuG,CAAJ,GACI,KAAMW,EAAA,CAAWT,CAAX,CAAelC,CAAf,CAAsB0C,CAAQzC,CAAAA,KAA9B,CADV,CARA,CAYJ,MAAOqB,CAAP,CAAU,EAIJyB,CAAAA,CAGFhC,CAHc,KAAM,EAAKD,CAAAA,OAAL,CAAa,CACjCpK,KAAMyL,CAD2B,CAEjC3G,UAAW4G,CAFsB,CAAb,CAGpBrB,EAAAA,KACJ,KAAK,MAAMiC,CAAX,GAAuBD,EAAvB,CAEI,KAAM,EAAKpB,CAAAA,KAAL,CAAW,CACbQ,KAAO,GAAEA,CAAF,IAAUa,CAAS/B,CAAAA,IAAnB,EADM,CAEbiB,GAAK,GAAEA,CAAF,IAAQc,CAAS/B,CAAAA,IAAjB,EAFQ,CAGbzF,UAAW4G,CAHE,CAIbH,YAAAA,CAJa,CAAX,CAKHD,CALG,CAQNA,EAAJ,GACI,KAAM,EAAKrB,CAAAA,KAAL,CAAW,CACbjK,KAAMyL,CADO,CAEb3G,UAAW4G,CAFE,CAAX,CADV,CAnER,CA2EA,MAAO,CACH/G,IAAKiH,CADF,CA1I4B,CAAA,CAAA,CA8IvC5C,cAAc,CAACuD,CAAD,CAAM,CAChB,GAAI,CACA,MAAO9C,KAAA,CAAKC,IAAA,CAAK6C,CAAL,CAAL,CAAP,EAA0BA,CAD1B,CAGJ,MAAOC,CAAP,CAAY,CACR,MAAO,CAAA,CADC,CAJI,CAhjBxB,CAyjBAxK,CAAcyK,CAAAA,MAAd,CAAuB,CAAA,CAEvB,KAAI7K,EAAmBT,MAAOuL,CAAAA,MAAP,CAAc,CACjCC,UAAW,IADsB;AAEjC3K,cAAeA,CAFkB,CAAd,CAKvBlC,EAAQ4B,CAAAA,UAAR,CAAqBA,EACrB5B,EAAQ0B,CAAAA,mBAAR,CAA8BA,EAC9B1B,EAAQ2B,CAAAA,kBAAR,CAA6BA,CA1sBiC;\",\n\"sources\":[\"node_modules/@capacitor/filesystem/dist/plugin.cjs.js\"],\n\"sourcesContent\":[\"shadow$provide[119] = function(global,require,module,exports) {\\n'use strict';\\n\\nObject.defineProperty(exports, '__esModule', { value: true });\\n\\nvar core = require('@capacitor/core');\\n\\nexports.Directory = void 0;\\n(function (Directory) {\\n    /**\\n     * The Documents directory.\\n     * On iOS it's the app's documents directory.\\n     * Use this directory to store user-generated content.\\n     * On Android it's the Public Documents folder, so it's accessible from other apps.\\n     * It's not accesible on Android 10 unless the app enables legacy External Storage\\n     * by adding `android:requestLegacyExternalStorage=\\\"true\\\"` in the `application` tag\\n     * in the `AndroidManifest.xml`.\\n     * On Android 11 or newer the app can only access the files/folders the app created.\\n     *\\n     * @since 1.0.0\\n     */\\n    Directory[\\\"Documents\\\"] = \\\"DOCUMENTS\\\";\\n    /**\\n     * The Data directory.\\n     * On iOS it will use the Documents directory.\\n     * On Android it's the directory holding application files.\\n     * Files will be deleted when the application is uninstalled.\\n     *\\n     * @since 1.0.0\\n     */\\n    Directory[\\\"Data\\\"] = \\\"DATA\\\";\\n    /**\\n     * The Library directory.\\n     * On iOS it will use the Library directory.\\n     * On Android it's the directory holding application files.\\n     * Files will be deleted when the application is uninstalled.\\n     *\\n     * @since 1.1.0\\n     */\\n    Directory[\\\"Library\\\"] = \\\"LIBRARY\\\";\\n    /**\\n     * The Cache directory.\\n     * Can be deleted in cases of low memory, so use this directory to write app-specific files.\\n     * that your app can re-create easily.\\n     *\\n     * @since 1.0.0\\n     */\\n    Directory[\\\"Cache\\\"] = \\\"CACHE\\\";\\n    /**\\n     * The external directory.\\n     * On iOS it will use the Documents directory.\\n     * On Android it's the directory on the primary shared/external\\n     * storage device where the application can place persistent files it owns.\\n     * These files are internal to the applications, and not typically visible\\n     * to the user as media.\\n     * Files will be deleted when the application is uninstalled.\\n     *\\n     * @since 1.0.0\\n     */\\n    Directory[\\\"External\\\"] = \\\"EXTERNAL\\\";\\n    /**\\n     * The external storage directory.\\n     * On iOS it will use the Documents directory.\\n     * On Android it's the primary shared/external storage directory.\\n     * It's not accesible on Android 10 unless the app enables legacy External Storage\\n     * by adding `android:requestLegacyExternalStorage=\\\"true\\\"` in the `application` tag\\n     * in the `AndroidManifest.xml`.\\n     * It's not accesible on Android 11 or newer.\\n     *\\n     * @since 1.0.0\\n     */\\n    Directory[\\\"ExternalStorage\\\"] = \\\"EXTERNAL_STORAGE\\\";\\n})(exports.Directory || (exports.Directory = {}));\\nexports.Encoding = void 0;\\n(function (Encoding) {\\n    /**\\n     * Eight-bit UCS Transformation Format\\n     *\\n     * @since 1.0.0\\n     */\\n    Encoding[\\\"UTF8\\\"] = \\\"utf8\\\";\\n    /**\\n     * Seven-bit ASCII, a.k.a. ISO646-US, a.k.a. the Basic Latin block of the\\n     * Unicode character set\\n     * This encoding is only supported on Android.\\n     *\\n     * @since 1.0.0\\n     */\\n    Encoding[\\\"ASCII\\\"] = \\\"ascii\\\";\\n    /**\\n     * Sixteen-bit UCS Transformation Format, byte order identified by an\\n     * optional byte-order mark\\n     * This encoding is only supported on Android.\\n     *\\n     * @since 1.0.0\\n     */\\n    Encoding[\\\"UTF16\\\"] = \\\"utf16\\\";\\n})(exports.Encoding || (exports.Encoding = {}));\\n/**\\n * @deprecated Use `Directory`.\\n * @since 1.0.0\\n */\\nconst FilesystemDirectory = exports.Directory;\\n/**\\n * @deprecated Use `Encoding`.\\n * @since 1.0.0\\n */\\nconst FilesystemEncoding = exports.Encoding;\\n\\nconst Filesystem = core.registerPlugin('Filesystem', {\\n    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.FilesystemWeb()),\\n});\\n\\nfunction resolve(path) {\\n    const posix = path.split('/').filter(item => item !== '.');\\n    const newPosix = [];\\n    posix.forEach(item => {\\n        if (item === '..' &&\\n            newPosix.length > 0 &&\\n            newPosix[newPosix.length - 1] !== '..') {\\n            newPosix.pop();\\n        }\\n        else {\\n            newPosix.push(item);\\n        }\\n    });\\n    return newPosix.join('/');\\n}\\nfunction isPathParent(parent, children) {\\n    parent = resolve(parent);\\n    children = resolve(children);\\n    const pathsA = parent.split('/');\\n    const pathsB = children.split('/');\\n    return (parent !== children &&\\n        pathsA.every((value, index) => value === pathsB[index]));\\n}\\nclass FilesystemWeb extends core.WebPlugin {\\n    constructor() {\\n        super(...arguments);\\n        this.DB_VERSION = 1;\\n        this.DB_NAME = 'Disc';\\n        this._writeCmds = ['add', 'put', 'delete'];\\n        /**\\n         * Function that performs a http request to a server and downloads the file to the specified destination\\n         *\\n         * @param options the options for the download operation\\n         * @returns a promise that resolves with the download file result\\n         */\\n        this.downloadFile = async (options) => {\\n            var _a, _b;\\n            const requestInit = core.buildRequestInit(options, options.webFetchExtra);\\n            const response = await fetch(options.url, requestInit);\\n            let blob;\\n            if (!options.progress)\\n                blob = await response.blob();\\n            else if (!(response === null || response === void 0 ? void 0 : response.body))\\n                blob = new Blob();\\n            else {\\n                const reader = response.body.getReader();\\n                let bytes = 0;\\n                const chunks = [];\\n                const contentType = response.headers.get('content-type');\\n                const contentLength = parseInt(response.headers.get('content-length') || '0', 10);\\n                while (true) {\\n                    const { done, value } = await reader.read();\\n                    if (done)\\n                        break;\\n                    chunks.push(value);\\n                    bytes += (value === null || value === void 0 ? void 0 : value.length) || 0;\\n                    const status = {\\n                        url: options.url,\\n                        bytes,\\n                        contentLength,\\n                    };\\n                    this.notifyListeners('progress', status);\\n                }\\n                const allChunks = new Uint8Array(bytes);\\n                let position = 0;\\n                for (const chunk of chunks) {\\n                    if (typeof chunk === 'undefined')\\n                        continue;\\n                    allChunks.set(chunk, position);\\n                    position += chunk.length;\\n                }\\n                blob = new Blob([allChunks.buffer], { type: contentType || undefined });\\n            }\\n            const result = await this.writeFile({\\n                path: options.path,\\n                directory: (_a = options.directory) !== null && _a !== void 0 ? _a : undefined,\\n                recursive: (_b = options.recursive) !== null && _b !== void 0 ? _b : false,\\n                data: blob,\\n            });\\n            return { path: result.uri, blob };\\n        };\\n    }\\n    async initDb() {\\n        if (this._db !== undefined) {\\n            return this._db;\\n        }\\n        if (!('indexedDB' in window)) {\\n            throw this.unavailable(\\\"This browser doesn't support IndexedDB\\\");\\n        }\\n        return new Promise((resolve, reject) => {\\n            const request = indexedDB.open(this.DB_NAME, this.DB_VERSION);\\n            request.onupgradeneeded = FilesystemWeb.doUpgrade;\\n            request.onsuccess = () => {\\n                this._db = request.result;\\n                resolve(request.result);\\n            };\\n            request.onerror = () => reject(request.error);\\n            request.onblocked = () => {\\n                console.warn('db blocked');\\n            };\\n        });\\n    }\\n    static doUpgrade(event) {\\n        const eventTarget = event.target;\\n        const db = eventTarget.result;\\n        switch (event.oldVersion) {\\n            case 0:\\n            case 1:\\n            default: {\\n                if (db.objectStoreNames.contains('FileStorage')) {\\n                    db.deleteObjectStore('FileStorage');\\n                }\\n                const store = db.createObjectStore('FileStorage', { keyPath: 'path' });\\n                store.createIndex('by_folder', 'folder');\\n            }\\n        }\\n    }\\n    async dbRequest(cmd, args) {\\n        const readFlag = this._writeCmds.indexOf(cmd) !== -1 ? 'readwrite' : 'readonly';\\n        return this.initDb().then((conn) => {\\n            return new Promise((resolve, reject) => {\\n                const tx = conn.transaction(['FileStorage'], readFlag);\\n                const store = tx.objectStore('FileStorage');\\n                const req = store[cmd](...args);\\n                req.onsuccess = () => resolve(req.result);\\n                req.onerror = () => reject(req.error);\\n            });\\n        });\\n    }\\n    async dbIndexRequest(indexName, cmd, args) {\\n        const readFlag = this._writeCmds.indexOf(cmd) !== -1 ? 'readwrite' : 'readonly';\\n        return this.initDb().then((conn) => {\\n            return new Promise((resolve, reject) => {\\n                const tx = conn.transaction(['FileStorage'], readFlag);\\n                const store = tx.objectStore('FileStorage');\\n                const index = store.index(indexName);\\n                const req = index[cmd](...args);\\n                req.onsuccess = () => resolve(req.result);\\n                req.onerror = () => reject(req.error);\\n            });\\n        });\\n    }\\n    getPath(directory, uriPath) {\\n        const cleanedUriPath = uriPath !== undefined ? uriPath.replace(/^[/]+|[/]+$/g, '') : '';\\n        let fsPath = '';\\n        if (directory !== undefined)\\n            fsPath += '/' + directory;\\n        if (uriPath !== '')\\n            fsPath += '/' + cleanedUriPath;\\n        return fsPath;\\n    }\\n    async clear() {\\n        const conn = await this.initDb();\\n        const tx = conn.transaction(['FileStorage'], 'readwrite');\\n        const store = tx.objectStore('FileStorage');\\n        store.clear();\\n    }\\n    /**\\n     * Read a file from disk\\n     * @param options options for the file read\\n     * @return a promise that resolves with the read file data result\\n     */\\n    async readFile(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        // const encoding = options.encoding;\\n        const entry = (await this.dbRequest('get', [path]));\\n        if (entry === undefined)\\n            throw Error('File does not exist.');\\n        return { data: entry.content ? entry.content : '' };\\n    }\\n    /**\\n     * Write a file to disk in the specified location on device\\n     * @param options options for the file write\\n     * @return a promise that resolves with the file write result\\n     */\\n    async writeFile(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        let data = options.data;\\n        const encoding = options.encoding;\\n        const doRecursive = options.recursive;\\n        const occupiedEntry = (await this.dbRequest('get', [path]));\\n        if (occupiedEntry && occupiedEntry.type === 'directory')\\n            throw Error('The supplied path is a directory.');\\n        const parentPath = path.substr(0, path.lastIndexOf('/'));\\n        const parentEntry = (await this.dbRequest('get', [parentPath]));\\n        if (parentEntry === undefined) {\\n            const subDirIndex = parentPath.indexOf('/', 1);\\n            if (subDirIndex !== -1) {\\n                const parentArgPath = parentPath.substr(subDirIndex);\\n                await this.mkdir({\\n                    path: parentArgPath,\\n                    directory: options.directory,\\n                    recursive: doRecursive,\\n                });\\n            }\\n        }\\n        if (!encoding && !(data instanceof Blob)) {\\n            data = data.indexOf(',') >= 0 ? data.split(',')[1] : data;\\n            if (!this.isBase64String(data))\\n                throw Error('The supplied data is not valid base64 content.');\\n        }\\n        const now = Date.now();\\n        const pathObj = {\\n            path: path,\\n            folder: parentPath,\\n            type: 'file',\\n            size: data instanceof Blob ? data.size : data.length,\\n            ctime: now,\\n            mtime: now,\\n            content: data,\\n        };\\n        await this.dbRequest('put', [pathObj]);\\n        return {\\n            uri: pathObj.path,\\n        };\\n    }\\n    /**\\n     * Append to a file on disk in the specified location on device\\n     * @param options options for the file append\\n     * @return a promise that resolves with the file write result\\n     */\\n    async appendFile(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        let data = options.data;\\n        const encoding = options.encoding;\\n        const parentPath = path.substr(0, path.lastIndexOf('/'));\\n        const now = Date.now();\\n        let ctime = now;\\n        const occupiedEntry = (await this.dbRequest('get', [path]));\\n        if (occupiedEntry && occupiedEntry.type === 'directory')\\n            throw Error('The supplied path is a directory.');\\n        const parentEntry = (await this.dbRequest('get', [parentPath]));\\n        if (parentEntry === undefined) {\\n            const subDirIndex = parentPath.indexOf('/', 1);\\n            if (subDirIndex !== -1) {\\n                const parentArgPath = parentPath.substr(subDirIndex);\\n                await this.mkdir({\\n                    path: parentArgPath,\\n                    directory: options.directory,\\n                    recursive: true,\\n                });\\n            }\\n        }\\n        if (!encoding && !this.isBase64String(data))\\n            throw Error('The supplied data is not valid base64 content.');\\n        if (occupiedEntry !== undefined) {\\n            if (occupiedEntry.content instanceof Blob) {\\n                throw Error('The occupied entry contains a Blob object which cannot be appended to.');\\n            }\\n            if (occupiedEntry.content !== undefined && !encoding) {\\n                data = btoa(atob(occupiedEntry.content) + atob(data));\\n            }\\n            else {\\n                data = occupiedEntry.content + data;\\n            }\\n            ctime = occupiedEntry.ctime;\\n        }\\n        const pathObj = {\\n            path: path,\\n            folder: parentPath,\\n            type: 'file',\\n            size: data.length,\\n            ctime: ctime,\\n            mtime: now,\\n            content: data,\\n        };\\n        await this.dbRequest('put', [pathObj]);\\n    }\\n    /**\\n     * Delete a file from disk\\n     * @param options options for the file delete\\n     * @return a promise that resolves with the deleted file data result\\n     */\\n    async deleteFile(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        const entry = (await this.dbRequest('get', [path]));\\n        if (entry === undefined)\\n            throw Error('File does not exist.');\\n        const entries = await this.dbIndexRequest('by_folder', 'getAllKeys', [\\n            IDBKeyRange.only(path),\\n        ]);\\n        if (entries.length !== 0)\\n            throw Error('Folder is not empty.');\\n        await this.dbRequest('delete', [path]);\\n    }\\n    /**\\n     * Create a directory.\\n     * @param options options for the mkdir\\n     * @return a promise that resolves with the mkdir result\\n     */\\n    async mkdir(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        const doRecursive = options.recursive;\\n        const parentPath = path.substr(0, path.lastIndexOf('/'));\\n        const depth = (path.match(/\\\\//g) || []).length;\\n        const parentEntry = (await this.dbRequest('get', [parentPath]));\\n        const occupiedEntry = (await this.dbRequest('get', [path]));\\n        if (depth === 1)\\n            throw Error('Cannot create Root directory');\\n        if (occupiedEntry !== undefined)\\n            throw Error('Current directory does already exist.');\\n        if (!doRecursive && depth !== 2 && parentEntry === undefined)\\n            throw Error('Parent directory must exist');\\n        if (doRecursive && depth !== 2 && parentEntry === undefined) {\\n            const parentArgPath = parentPath.substr(parentPath.indexOf('/', 1));\\n            await this.mkdir({\\n                path: parentArgPath,\\n                directory: options.directory,\\n                recursive: doRecursive,\\n            });\\n        }\\n        const now = Date.now();\\n        const pathObj = {\\n            path: path,\\n            folder: parentPath,\\n            type: 'directory',\\n            size: 0,\\n            ctime: now,\\n            mtime: now,\\n        };\\n        await this.dbRequest('put', [pathObj]);\\n    }\\n    /**\\n     * Remove a directory\\n     * @param options the options for the directory remove\\n     */\\n    async rmdir(options) {\\n        const { path, directory, recursive } = options;\\n        const fullPath = this.getPath(directory, path);\\n        const entry = (await this.dbRequest('get', [fullPath]));\\n        if (entry === undefined)\\n            throw Error('Folder does not exist.');\\n        if (entry.type !== 'directory')\\n            throw Error('Requested path is not a directory');\\n        const readDirResult = await this.readdir({ path, directory });\\n        if (readDirResult.files.length !== 0 && !recursive)\\n            throw Error('Folder is not empty');\\n        for (const entry of readDirResult.files) {\\n            const entryPath = `${path}/${entry.name}`;\\n            const entryObj = await this.stat({ path: entryPath, directory });\\n            if (entryObj.type === 'file') {\\n                await this.deleteFile({ path: entryPath, directory });\\n            }\\n            else {\\n                await this.rmdir({ path: entryPath, directory, recursive });\\n            }\\n        }\\n        await this.dbRequest('delete', [fullPath]);\\n    }\\n    /**\\n     * Return a list of files from the directory (not recursive)\\n     * @param options the options for the readdir operation\\n     * @return a promise that resolves with the readdir directory listing result\\n     */\\n    async readdir(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        const entry = (await this.dbRequest('get', [path]));\\n        if (options.path !== '' && entry === undefined)\\n            throw Error('Folder does not exist.');\\n        const entries = await this.dbIndexRequest('by_folder', 'getAllKeys', [IDBKeyRange.only(path)]);\\n        const files = await Promise.all(entries.map(async (e) => {\\n            let subEntry = (await this.dbRequest('get', [e]));\\n            if (subEntry === undefined) {\\n                subEntry = (await this.dbRequest('get', [e + '/']));\\n            }\\n            return {\\n                name: e.substring(path.length + 1),\\n                type: subEntry.type,\\n                size: subEntry.size,\\n                ctime: subEntry.ctime,\\n                mtime: subEntry.mtime,\\n                uri: subEntry.path,\\n            };\\n        }));\\n        return { files: files };\\n    }\\n    /**\\n     * Return full File URI for a path and directory\\n     * @param options the options for the stat operation\\n     * @return a promise that resolves with the file stat result\\n     */\\n    async getUri(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        let entry = (await this.dbRequest('get', [path]));\\n        if (entry === undefined) {\\n            entry = (await this.dbRequest('get', [path + '/']));\\n        }\\n        return {\\n            uri: (entry === null || entry === void 0 ? void 0 : entry.path) || path,\\n        };\\n    }\\n    /**\\n     * Return data about a file\\n     * @param options the options for the stat operation\\n     * @return a promise that resolves with the file stat result\\n     */\\n    async stat(options) {\\n        const path = this.getPath(options.directory, options.path);\\n        let entry = (await this.dbRequest('get', [path]));\\n        if (entry === undefined) {\\n            entry = (await this.dbRequest('get', [path + '/']));\\n        }\\n        if (entry === undefined)\\n            throw Error('Entry does not exist.');\\n        return {\\n            type: entry.type,\\n            size: entry.size,\\n            ctime: entry.ctime,\\n            mtime: entry.mtime,\\n            uri: entry.path,\\n        };\\n    }\\n    /**\\n     * Rename a file or directory\\n     * @param options the options for the rename operation\\n     * @return a promise that resolves with the rename result\\n     */\\n    async rename(options) {\\n        await this._copy(options, true);\\n        return;\\n    }\\n    /**\\n     * Copy a file or directory\\n     * @param options the options for the copy operation\\n     * @return a promise that resolves with the copy result\\n     */\\n    async copy(options) {\\n        return this._copy(options, false);\\n    }\\n    async requestPermissions() {\\n        return { publicStorage: 'granted' };\\n    }\\n    async checkPermissions() {\\n        return { publicStorage: 'granted' };\\n    }\\n    /**\\n     * Function that can perform a copy or a rename\\n     * @param options the options for the rename operation\\n     * @param doRename whether to perform a rename or copy operation\\n     * @return a promise that resolves with the result\\n     */\\n    async _copy(options, doRename = false) {\\n        let { toDirectory } = options;\\n        const { to, from, directory: fromDirectory } = options;\\n        if (!to || !from) {\\n            throw Error('Both to and from must be provided');\\n        }\\n        // If no \\\"to\\\" directory is provided, use the \\\"from\\\" directory\\n        if (!toDirectory) {\\n            toDirectory = fromDirectory;\\n        }\\n        const fromPath = this.getPath(fromDirectory, from);\\n        const toPath = this.getPath(toDirectory, to);\\n        // Test that the \\\"to\\\" and \\\"from\\\" locations are different\\n        if (fromPath === toPath) {\\n            return {\\n                uri: toPath,\\n            };\\n        }\\n        if (isPathParent(fromPath, toPath)) {\\n            throw Error('To path cannot contain the from path');\\n        }\\n        // Check the state of the \\\"to\\\" location\\n        let toObj;\\n        try {\\n            toObj = await this.stat({\\n                path: to,\\n                directory: toDirectory,\\n            });\\n        }\\n        catch (e) {\\n            // To location does not exist, ensure the directory containing \\\"to\\\" location exists and is a directory\\n            const toPathComponents = to.split('/');\\n            toPathComponents.pop();\\n            const toPath = toPathComponents.join('/');\\n            // Check the containing directory of the \\\"to\\\" location exists\\n            if (toPathComponents.length > 0) {\\n                const toParentDirectory = await this.stat({\\n                    path: toPath,\\n                    directory: toDirectory,\\n                });\\n                if (toParentDirectory.type !== 'directory') {\\n                    throw new Error('Parent directory of the to path is a file');\\n                }\\n            }\\n        }\\n        // Cannot overwrite a directory\\n        if (toObj && toObj.type === 'directory') {\\n            throw new Error('Cannot overwrite a directory with a file');\\n        }\\n        // Ensure the \\\"from\\\" object exists\\n        const fromObj = await this.stat({\\n            path: from,\\n            directory: fromDirectory,\\n        });\\n        // Set the mtime/ctime of the supplied path\\n        const updateTime = async (path, ctime, mtime) => {\\n            const fullPath = this.getPath(toDirectory, path);\\n            const entry = (await this.dbRequest('get', [fullPath]));\\n            entry.ctime = ctime;\\n            entry.mtime = mtime;\\n            await this.dbRequest('put', [entry]);\\n        };\\n        const ctime = fromObj.ctime ? fromObj.ctime : Date.now();\\n        switch (fromObj.type) {\\n            // The \\\"from\\\" object is a file\\n            case 'file': {\\n                // Read the file\\n                const file = await this.readFile({\\n                    path: from,\\n                    directory: fromDirectory,\\n                });\\n                // Optionally remove the file\\n                if (doRename) {\\n                    await this.deleteFile({\\n                        path: from,\\n                        directory: fromDirectory,\\n                    });\\n                }\\n                let encoding;\\n                if (!(file.data instanceof Blob) && !this.isBase64String(file.data)) {\\n                    encoding = exports.Encoding.UTF8;\\n                }\\n                // Write the file to the new location\\n                const writeResult = await this.writeFile({\\n                    path: to,\\n                    directory: toDirectory,\\n                    data: file.data,\\n                    encoding: encoding,\\n                });\\n                // Copy the mtime/ctime of a renamed file\\n                if (doRename) {\\n                    await updateTime(to, ctime, fromObj.mtime);\\n                }\\n                // Resolve promise\\n                return writeResult;\\n            }\\n            case 'directory': {\\n                if (toObj) {\\n                    throw Error('Cannot move a directory over an existing object');\\n                }\\n                try {\\n                    // Create the to directory\\n                    await this.mkdir({\\n                        path: to,\\n                        directory: toDirectory,\\n                        recursive: false,\\n                    });\\n                    // Copy the mtime/ctime of a renamed directory\\n                    if (doRename) {\\n                        await updateTime(to, ctime, fromObj.mtime);\\n                    }\\n                }\\n                catch (e) {\\n                    // ignore\\n                }\\n                // Iterate over the contents of the from location\\n                const contents = (await this.readdir({\\n                    path: from,\\n                    directory: fromDirectory,\\n                })).files;\\n                for (const filename of contents) {\\n                    // Move item from the from directory to the to directory\\n                    await this._copy({\\n                        from: `${from}/${filename.name}`,\\n                        to: `${to}/${filename.name}`,\\n                        directory: fromDirectory,\\n                        toDirectory,\\n                    }, doRename);\\n                }\\n                // Optionally remove the original from directory\\n                if (doRename) {\\n                    await this.rmdir({\\n                        path: from,\\n                        directory: fromDirectory,\\n                    });\\n                }\\n            }\\n        }\\n        return {\\n            uri: toPath,\\n        };\\n    }\\n    isBase64String(str) {\\n        try {\\n            return btoa(atob(str)) == str;\\n        }\\n        catch (err) {\\n            return false;\\n        }\\n    }\\n}\\nFilesystemWeb._debug = true;\\n\\nvar web = /*#__PURE__*/Object.freeze({\\n    __proto__: null,\\n    FilesystemWeb: FilesystemWeb\\n});\\n\\nexports.Filesystem = Filesystem;\\nexports.FilesystemDirectory = FilesystemDirectory;\\nexports.FilesystemEncoding = FilesystemEncoding;\\n//# sourceMappingURL=plugin.cjs.js.map\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"resolve\",\"path\",\"newPosix\",\"split\",\"filter\",\"posix\",\"item\",\"forEach\",\"length\",\"pop\",\"push\",\"join\",\"isPathParent\",\"parent\",\"children\",\"pathsA\",\"pathsB\",\"every\",\"value\",\"index\",\"Object\",\"defineProperty\",\"core\",\"Directory\",\"Encoding\",\"FilesystemDirectory\",\"FilesystemEncoding\",\"Filesystem\",\"registerPlugin\",\"web\",\"Promise\",\"then\",\"m\",\"FilesystemWeb\",\"WebPlugin\",\"constructor\",\"arguments\",\"DB_VERSION\",\"DB_NAME\",\"_writeCmds\",\"downloadFile\",\"options\",\"this.downloadFile\",\"_a\",\"_b\",\"requestInit\",\"buildRequestInit\",\"webFetchExtra\",\"response\",\"fetch\",\"url\",\"progress\",\"body\",\"reader\",\"getReader\",\"bytes\",\"chunks\",\"contentType\",\"headers\",\"get\",\"contentLength\",\"parseInt\",\"done\",\"read\",\"notifyListeners\",\"status\",\"allChunks\",\"Uint8Array\",\"position\",\"chunk\",\"set\",\"blob\",\"Blob\",\"buffer\",\"type\",\"undefined\",\"uri\",\"result\",\"writeFile\",\"directory\",\"recursive\",\"data\",\"initDb\",\"_db\",\"window\",\"unavailable\",\"reject\",\"request\",\"indexedDB\",\"open\",\"onupgradeneeded\",\"doUpgrade\",\"onsuccess\",\"request.onsuccess\",\"onerror\",\"request.onerror\",\"error\",\"onblocked\",\"request.onblocked\",\"console\",\"warn\",\"event\",\"db\",\"target\",\"objectStoreNames\",\"contains\",\"deleteObjectStore\",\"createObjectStore\",\"store\",\"keyPath\",\"createIndex\",\"dbRequest\",\"cmd\",\"args\",\"readFlag\",\"indexOf\",\"conn\",\"req\",\"transaction\",\"tx\",\"objectStore\",\"req.onsuccess\",\"req.onerror\",\"dbIndexRequest\",\"indexName\",\"getPath\",\"uriPath\",\"cleanedUriPath\",\"replace\",\"fsPath\",\"clear\",\"readFile\",\"entry\",\"Error\",\"content\",\"encoding\",\"doRecursive\",\"occupiedEntry\",\"parentPath\",\"substr\",\"lastIndexOf\",\"parentEntry\",\"subDirIndex\",\"parentArgPath\",\"mkdir\",\"isBase64String\",\"now\",\"Date\",\"pathObj\",\"folder\",\"size\",\"ctime\",\"mtime\",\"appendFile\",\"btoa\",\"atob\",\"deleteFile\",\"entries\",\"IDBKeyRange\",\"only\",\"depth\",\"match\",\"rmdir\",\"fullPath\",\"readDirResult\",\"readdir\",\"files\",\"entryPath\",\"name\",\"entryObj\",\"stat\",\"all\",\"map\",\"e\",\"subEntry\",\"substring\",\"getUri\",\"rename\",\"_copy\",\"copy\",\"requestPermissions\",\"publicStorage\",\"checkPermissions\",\"doRename\",\"toDirectory\",\"to\",\"from\",\"fromDirectory\",\"fromPath\",\"toPath\",\"toObj\",\"toPathComponents\",\"toParentDirectory\",\"fromObj\",\"updateTime\",\"file\",\"UTF8\",\"writeResult\",\"contents\",\"filename\",\"str\",\"err\",\"_debug\",\"freeze\",\"__proto__\"]\n}\n"]