["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/@capacitor/clipboard/dist/plugin.cjs.js"],"~:js","shadow$provide[9]=function(ra,X,Ra,P){Object.defineProperty(P,\"__esModule\",{value:!0});ra=X(7);class w extends ra.WebPlugin{write(Z){const B=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(\"undefined\"===typeof navigator||!navigator.clipboard)throw B.unavailable(\"Clipboard API not available in this browser\");if(void 0!==Z.string)yield B.writeText(Z.string);else if(Z.url)yield B.writeText(Z.url);else if(Z.image)if(\"undefined\"!==typeof ClipboardItem)try{const p=yield(yield fetch(Z.image)).blob(),\nc=new ClipboardItem({[p.type]:p});yield navigator.clipboard.write([c])}catch(p){throw Error(\"Failed to write image\");}else throw B.unavailable(\"Writing images to the clipboard is not supported in this browser\");else throw Error(\"Nothing to write\");})}read(){const Z=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(\"undefined\"===typeof navigator||!navigator.clipboard)throw Z.unavailable(\"Clipboard API not available in this browser\");if(\"undefined\"!==typeof ClipboardItem)try{const B=\nyield navigator.clipboard.read(),p=B[0].types[0],c=yield B[0].getType(p);return{value:yield Z._getBlobData(c,p),type:p}}catch(B){return Z.readText()}else return Z.readText()})}readText(){const Z=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(\"undefined\"===typeof navigator||!navigator.clipboard||!navigator.clipboard.readText)throw Z.unavailable(\"Reading from clipboard not supported in this browser\");return{value:yield navigator.clipboard.readText(),type:\"text/plain\"}})}writeText(Z){const B=\nthis;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){if(\"undefined\"===typeof navigator||!navigator.clipboard||!navigator.clipboard.writeText)throw B.unavailable(\"Writting to clipboard not supported in this browser\");yield navigator.clipboard.writeText(Z)})}_getBlobData(Z,B){return new Promise((p,c)=>{const u=new FileReader;B.includes(\"image\")?u.readAsDataURL(Z):u.readAsText(Z);u.onloadend=()=>{p(u.result)};u.onerror=A=>{c(A)}})}}ra=ra.registerPlugin(\"Clipboard\",{web:()=>new w});P.Clipboard=\nra}","~:source","shadow$provide[9] = function(global,require,module,exports) {\n'use strict';\n\nObject.defineProperty(exports, '__esModule', { value: true });\n\nvar core = require('@capacitor/core');\n\nclass ClipboardWeb extends core.WebPlugin {\n    async write(options) {\n        if (typeof navigator === 'undefined' || !navigator.clipboard) {\n            throw this.unavailable('Clipboard API not available in this browser');\n        }\n        if (options.string !== undefined) {\n            await this.writeText(options.string);\n        }\n        else if (options.url) {\n            await this.writeText(options.url);\n        }\n        else if (options.image) {\n            if (typeof ClipboardItem !== 'undefined') {\n                try {\n                    const blob = await (await fetch(options.image)).blob();\n                    const clipboardItemInput = new ClipboardItem({ [blob.type]: blob });\n                    await navigator.clipboard.write([clipboardItemInput]);\n                }\n                catch (err) {\n                    throw new Error('Failed to write image');\n                }\n            }\n            else {\n                throw this.unavailable('Writing images to the clipboard is not supported in this browser');\n            }\n        }\n        else {\n            throw new Error('Nothing to write');\n        }\n    }\n    async read() {\n        if (typeof navigator === 'undefined' || !navigator.clipboard) {\n            throw this.unavailable('Clipboard API not available in this browser');\n        }\n        if (typeof ClipboardItem !== 'undefined') {\n            try {\n                const clipboardItems = await navigator.clipboard.read();\n                const type = clipboardItems[0].types[0];\n                const clipboardBlob = await clipboardItems[0].getType(type);\n                const data = await this._getBlobData(clipboardBlob, type);\n                return { value: data, type };\n            }\n            catch (err) {\n                return this.readText();\n            }\n        }\n        else {\n            return this.readText();\n        }\n    }\n    async readText() {\n        if (typeof navigator === 'undefined' ||\n            !navigator.clipboard ||\n            !navigator.clipboard.readText) {\n            throw this.unavailable('Reading from clipboard not supported in this browser');\n        }\n        const text = await navigator.clipboard.readText();\n        return { value: text, type: 'text/plain' };\n    }\n    async writeText(text) {\n        if (typeof navigator === 'undefined' ||\n            !navigator.clipboard ||\n            !navigator.clipboard.writeText) {\n            throw this.unavailable('Writting to clipboard not supported in this browser');\n        }\n        await navigator.clipboard.writeText(text);\n    }\n    _getBlobData(clipboardBlob, type) {\n        return new Promise((resolve, reject) => {\n            const reader = new FileReader();\n            if (type.includes('image')) {\n                reader.readAsDataURL(clipboardBlob);\n            }\n            else {\n                reader.readAsText(clipboardBlob);\n            }\n            reader.onloadend = () => {\n                const r = reader.result;\n                resolve(r);\n            };\n            reader.onerror = e => {\n                reject(e);\n            };\n        });\n    }\n}\n\nconst Clipboard = core.registerPlugin('Clipboard', {\n    web: () => new ClipboardWeb(),\n});\n\nexports.Clipboard = Clipboard;\n//# sourceMappingURL=plugin.cjs.js.map\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$$capacitor$core$dist$index_cjs"]],"~:properties",["^5",["onerror","web","__esModule","value","type","onloadend","Clipboard"]],"~:compiled-at",1766065009392,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$$capacitor$clipboard$dist$plugin_cjs.js\",\n\"lineCount\":5,\n\"mappings\":\"AAAAA,cAAA,CAAe,CAAf,CAAA,CAAoB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAG5DC,MAAOC,CAAAA,cAAP,CAAsBF,CAAtB,CAA+B,YAA/B,CAA6C,CAAEG,MAAO,CAAA,CAAT,CAA7C,CAEIC,GAAAA,CAAON,CAAA,CAAQ,CAAR,CAEX,MAAMO,EAAN,QAA2BD,GAAKE,CAAAA,SAAhC,CACUC,KAAK,CAACC,CAAD,CAAU,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACjB,GAAyB,WAAzB,GAAI,MAAOC,UAAX,EAAwC,CAACA,SAAUC,CAAAA,SAAnD,CACI,KAAM,EAAKC,CAAAA,WAAL,CAAiB,6CAAjB,CAAN,CAEJ,GAAuBC,IAAAA,EAAvB,GAAIJ,CAAQK,CAAAA,MAAZ,CACI,KAAM,EAAKC,CAAAA,SAAL,CAAeN,CAAQK,CAAAA,MAAvB,CADV,KAGK,IAAIL,CAAQO,CAAAA,GAAZ,CACD,KAAM,EAAKD,CAAAA,SAAL,CAAeN,CAAQO,CAAAA,GAAvB,CADL,KAGA,IAAIP,CAAQQ,CAAAA,KAAZ,CACD,GAA6B,WAA7B,GAAI,MAAOC,cAAX,CACI,GAAI,CACA,MAAMC,EAAO,KAAmCA,CAA5B,KAAMC,MAAA,CAAMX,CAAQQ,CAAAA,KAAd,CAAsBE,EAAAA,IAA7B,EAAnB;AACME,EAAqB,IAAIH,aAAJ,CAAkB,CAAE,CAACC,CAAKG,CAAAA,IAAN,EAAaH,CAAf,CAAlB,CAC3B,MAAMT,UAAUC,CAAAA,SAAUH,CAAAA,KAApB,CAA0B,CAACa,CAAD,CAA1B,CAHN,CAKJ,MAAOE,CAAP,CAAY,CACR,KAAUC,MAAJ,CAAU,uBAAV,CAAN,CADQ,CANhB,IAWI,MAAM,EAAKZ,CAAAA,WAAL,CAAiB,kEAAjB,CAAN,CAZH,IAgBD,MAAUY,MAAJ,CAAU,kBAAV,CAAN,CA1Ba,CAAA,CAAA,CA6BfC,IAAI,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACT,GAAyB,WAAzB,GAAI,MAAOf,UAAX,EAAwC,CAACA,SAAUC,CAAAA,SAAnD,CACI,KAAM,EAAKC,CAAAA,WAAL,CAAiB,6CAAjB,CAAN,CAEJ,GAA6B,WAA7B,GAAI,MAAOM,cAAX,CACI,GAAI,CACA,MAAMQ;AAAiB,KAAMhB,UAAUC,CAAAA,SAAUc,CAAAA,IAApB,EAA7B,CACMH,EAAOI,CAAA,CAAe,CAAf,CAAkBC,CAAAA,KAAlB,CAAwB,CAAxB,CADb,CAEMC,EAAgB,KAAMF,EAAA,CAAe,CAAf,CAAkBG,CAAAA,OAAlB,CAA0BP,CAA1B,CAE5B,OAAO,CAAElB,MADI0B,KAAM,EAAKC,CAAAA,YAAL,CAAkBH,CAAlB,CAAiCN,CAAjC,CACZ,CAAeA,KAAAA,CAAf,CALP,CAOJ,MAAOC,CAAP,CAAY,CACR,MAAO,EAAKS,CAAAA,QAAL,EADC,CARhB,IAaI,OAAO,EAAKA,CAAAA,QAAL,EAjBF,CAAA,CAAA,CAoBPA,QAAQ,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACb,GAAyB,WAAzB,GAAI,MAAOtB,UAAX,EACI,CAACA,SAAUC,CAAAA,SADf,EAEI,CAACD,SAAUC,CAAAA,SAAUqB,CAAAA,QAFzB,CAGI,KAAM,EAAKpB,CAAAA,WAAL,CAAiB,sDAAjB,CAAN,CAGJ,MAAO,CAAER,MADI6B,KAAMvB,UAAUC,CAAAA,SAAUqB,CAAAA,QAApB,EACZ,CAAeV,KAAM,YAArB,CAPM,CAAA,CAAA,CASXP,SAAS,CAACkB,CAAD,CAAO,CAAA,MAAA;AAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CAClB,GAAyB,WAAzB,GAAI,MAAOvB,UAAX,EACI,CAACA,SAAUC,CAAAA,SADf,EAEI,CAACD,SAAUC,CAAAA,SAAUI,CAAAA,SAFzB,CAGI,KAAM,EAAKH,CAAAA,WAAL,CAAiB,qDAAjB,CAAN,CAEJ,KAAMF,UAAUC,CAAAA,SAAUI,CAAAA,SAApB,CAA8BkB,CAA9B,CANY,CAAA,CAAA,CAQtBF,YAAY,CAACH,CAAD,CAAgBN,CAAhB,CAAsB,CAC9B,MAAO,KAAIY,OAAJ,CAAY,CAACC,CAAD,CAAUC,CAAV,CAAA,EAAqB,CACpC,MAAMC,EAAS,IAAIC,UACfhB,EAAKiB,CAAAA,QAAL,CAAc,OAAd,CAAJ,CACIF,CAAOG,CAAAA,aAAP,CAAqBZ,CAArB,CADJ,CAIIS,CAAOI,CAAAA,UAAP,CAAkBb,CAAlB,CAEJS,EAAOK,CAAAA,SAAP,CAAmB,EAAAC,EAAM,CAErBR,CAAA,CADUE,CAAOO,CAAAA,MACjB,CAFqB,CAIzBP,EAAOQ,CAAAA,OAAP,CAAiBC,CAAAC,EAAK,CAClBX,CAAA,CAAOU,CAAP,CADkB,CAZc,CAAjC,CADuB,CAnEtC,CAuFME,EAAAA,CAAY3C,EAAK4C,CAAAA,cAAL,CAAoB,WAApB,CAAiC,CAC/CC,IAAK,EAAAA,EAAM,IAAI5C,CADgC,CAAjC,CAIlBL,EAAQ+C,CAAAA,SAAR;AAAoBA,EAlGwC;\",\n\"sources\":[\"node_modules/@capacitor/clipboard/dist/plugin.cjs.js\"],\n\"sourcesContent\":[\"shadow$provide[9] = function(global,require,module,exports) {\\n'use strict';\\n\\nObject.defineProperty(exports, '__esModule', { value: true });\\n\\nvar core = require('@capacitor/core');\\n\\nclass ClipboardWeb extends core.WebPlugin {\\n    async write(options) {\\n        if (typeof navigator === 'undefined' || !navigator.clipboard) {\\n            throw this.unavailable('Clipboard API not available in this browser');\\n        }\\n        if (options.string !== undefined) {\\n            await this.writeText(options.string);\\n        }\\n        else if (options.url) {\\n            await this.writeText(options.url);\\n        }\\n        else if (options.image) {\\n            if (typeof ClipboardItem !== 'undefined') {\\n                try {\\n                    const blob = await (await fetch(options.image)).blob();\\n                    const clipboardItemInput = new ClipboardItem({ [blob.type]: blob });\\n                    await navigator.clipboard.write([clipboardItemInput]);\\n                }\\n                catch (err) {\\n                    throw new Error('Failed to write image');\\n                }\\n            }\\n            else {\\n                throw this.unavailable('Writing images to the clipboard is not supported in this browser');\\n            }\\n        }\\n        else {\\n            throw new Error('Nothing to write');\\n        }\\n    }\\n    async read() {\\n        if (typeof navigator === 'undefined' || !navigator.clipboard) {\\n            throw this.unavailable('Clipboard API not available in this browser');\\n        }\\n        if (typeof ClipboardItem !== 'undefined') {\\n            try {\\n                const clipboardItems = await navigator.clipboard.read();\\n                const type = clipboardItems[0].types[0];\\n                const clipboardBlob = await clipboardItems[0].getType(type);\\n                const data = await this._getBlobData(clipboardBlob, type);\\n                return { value: data, type };\\n            }\\n            catch (err) {\\n                return this.readText();\\n            }\\n        }\\n        else {\\n            return this.readText();\\n        }\\n    }\\n    async readText() {\\n        if (typeof navigator === 'undefined' ||\\n            !navigator.clipboard ||\\n            !navigator.clipboard.readText) {\\n            throw this.unavailable('Reading from clipboard not supported in this browser');\\n        }\\n        const text = await navigator.clipboard.readText();\\n        return { value: text, type: 'text/plain' };\\n    }\\n    async writeText(text) {\\n        if (typeof navigator === 'undefined' ||\\n            !navigator.clipboard ||\\n            !navigator.clipboard.writeText) {\\n            throw this.unavailable('Writting to clipboard not supported in this browser');\\n        }\\n        await navigator.clipboard.writeText(text);\\n    }\\n    _getBlobData(clipboardBlob, type) {\\n        return new Promise((resolve, reject) => {\\n            const reader = new FileReader();\\n            if (type.includes('image')) {\\n                reader.readAsDataURL(clipboardBlob);\\n            }\\n            else {\\n                reader.readAsText(clipboardBlob);\\n            }\\n            reader.onloadend = () => {\\n                const r = reader.result;\\n                resolve(r);\\n            };\\n            reader.onerror = e => {\\n                reject(e);\\n            };\\n        });\\n    }\\n}\\n\\nconst Clipboard = core.registerPlugin('Clipboard', {\\n    web: () => new ClipboardWeb(),\\n});\\n\\nexports.Clipboard = Clipboard;\\n//# sourceMappingURL=plugin.cjs.js.map\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Object\",\"defineProperty\",\"value\",\"core\",\"ClipboardWeb\",\"WebPlugin\",\"write\",\"options\",\"navigator\",\"clipboard\",\"unavailable\",\"undefined\",\"string\",\"writeText\",\"url\",\"image\",\"ClipboardItem\",\"blob\",\"fetch\",\"clipboardItemInput\",\"type\",\"err\",\"Error\",\"read\",\"clipboardItems\",\"types\",\"clipboardBlob\",\"getType\",\"data\",\"_getBlobData\",\"readText\",\"text\",\"Promise\",\"resolve\",\"reject\",\"reader\",\"FileReader\",\"includes\",\"readAsDataURL\",\"readAsText\",\"onloadend\",\"reader.onloadend\",\"result\",\"onerror\",\"e\",\"reader.onerror\",\"Clipboard\",\"registerPlugin\",\"web\"]\n}\n"]