["^ ","~:resource-id",["~:shadow.build.classpath/resource","frontend/idbkv.js"],"~:js","shadow$provide[116]=function(ra,X,Ra,P){function w(){p||(p=new Z);return p}Object.defineProperty(P,\"__esModule\",{value:!0});class Z{constructor(u=\"keyval-store\",A=\"keyval\",y=1){this.storeName=A;this._dbName=u;this._storeName=A;this._version=y;this.id=`dbName:${u};;storeName:${A}`;this._init()}_init(){this._dbp||(this._dbp=new Promise((u,A)=>{const y=window.indexedDB.open(this._dbName,this._version);y.onerror=()=>A(y.error);y.onsuccess=()=>u(y.result);y.onupgradeneeded=()=>{y.result.createObjectStore(this._storeName)}}))}_withIDBStore(u,\nA){this._init();return this._dbp.then(y=>new Promise((x,Q)=>{const g=y.transaction(this.storeName,u);g.oncomplete=()=>x();g.onabort=g.onerror=()=>Q(g.error);A(g.objectStore(this.storeName))}))}_close(){this._init();return this._dbp.then(u=>{u.close();this._dbp=void 0})}}class B{constructor(u){this.executor=u;this.items=[]}process(){const u=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const A=u.items;u.items=[];yield u.executor(A.map(({item:y})=>y));A.map(({onProcessed:y})=>\ny());u.ongoing=u.items.length?u.process():void 0})}queue(u){const A=this;return $jscomp.asyncExecutePromiseGeneratorFunction(function*(){const y=new Promise(x=>A.items.push({item:u,onProcessed:x}));A.ongoing||(A.ongoing=A.process());return y})}}let p;const c={};P.Store=Z;P.get=function(u,A=w()){let y;return A._withIDBStore(\"readwrite\",x=>{y=x.get(u)}).then(()=>y.result)};P.set=function(u,A,y=w()){c[y.id]||(c[y.id]=new B(x=>y._withIDBStore(\"readwrite\",Q=>{for(const g of x)Q.put(g.value,g.key)})));\nreturn c[y.id].queue({key:u,value:A})};P.setBatch=function(u,A=w()){return A._withIDBStore(\"readwrite\",y=>{for(const x of u)y.put(x.value,x.key)})};P.update=function(u,A,y=w()){return y._withIDBStore(\"readwrite\",x=>{const Q=x.get(u);Q.onsuccess=()=>{x.put(A(Q.result),u)}})};P.del=function(u,A=w()){return A._withIDBStore(\"readwrite\",y=>{y.delete(u)})};P.clear=function(u=w()){return u._withIDBStore(\"readwrite\",A=>{A.clear()})};P.keys=function(u=w()){const A=[];return u._withIDBStore(\"readwrite\",y=>\n{(y.openKeyCursor||y.openCursor).call(y).onsuccess=function(){this.result&&(A.push(this.result.key),this.result.continue())}}).then(()=>A)};P.close=function(u=w()){return u._close()}}","~:source","shadow$provide[116] = function(global,require,module,exports) {\n'use strict';\n\nObject.defineProperty(exports, '__esModule', { value: true });\n\nclass Store {\n    constructor(dbName = 'keyval-store', storeName = 'keyval', version = 1) {\n        this.storeName = storeName;\n        this._dbName = dbName;\n        this._storeName = storeName;\n        this._version = version;\n        this.id = `dbName:${dbName};;storeName:${storeName}`;\n        this._init();\n    }\n    _init() {\n      if (this._dbp) {\n        return;\n      }\n      this._dbp = new Promise((resolve, reject) => {\n        const openreq = window.indexedDB.open(this._dbName, this._version);\n        openreq.onerror = () => reject(openreq.error);\n        openreq.onsuccess = () => resolve(openreq.result);\n        // First time setup: create an empty object store\n        openreq.onupgradeneeded = () => {\n          openreq.result.createObjectStore(this._storeName);\n        };\n      });\n    }\n    _withIDBStore(type, callback) {\n        this._init();\n        return this._dbp.then(db => new Promise((resolve, reject) => {\n            const transaction = db.transaction(this.storeName, type);\n            transaction.oncomplete = () => resolve();\n            transaction.onabort = transaction.onerror = () => reject(transaction.error);\n            callback(transaction.objectStore(this.storeName));\n        }));\n    }\n    _close() {\n        this._init();\n        return this._dbp.then(db => {\n            db.close();\n            this._dbp = undefined;\n        });\n    }\n}\nclass Batcher {\n    constructor(executor) {\n        this.executor = executor;\n        this.items = [];\n    }\n  async process() {\n        const toProcess = this.items;\n        this.items = [];\n        await this.executor(toProcess.map(({ item }) => item));\n        toProcess.map(({ onProcessed }) => onProcessed());\n        if (this.items.length) {\n            this.ongoing = this.process();\n        }\n        else {\n            this.ongoing = undefined;\n        }\n    }\n    async queue(item) {\n        const result = new Promise((resolve) => this.items.push({ item, onProcessed: resolve }));\n        if (!this.ongoing)\n            this.ongoing = this.process();\n        return result;\n    }\n}\nlet store;\nfunction getDefaultStore() {\n    if (!store)\n        store = new Store();\n    return store;\n}\nfunction get(key, store = getDefaultStore()) {\n    let req;\n    return store._withIDBStore('readwrite', store => {\n        req = store.get(key);\n    }).then(() => req.result);\n}\nconst setBatchers = {};\nfunction set(key, value, store = getDefaultStore()) {\n    if (!setBatchers[store.id]) {\n        setBatchers[store.id] = new Batcher((items) => store._withIDBStore('readwrite', store => {\n            for (const item of items) {\n                store.put(item.value, item.key);\n            }\n        }));\n    }\n    return setBatchers[store.id].queue({ key, value });\n}\nfunction setBatch(items, store = getDefaultStore()) {\n  return store._withIDBStore('readwrite', store => {\n    for (const item of items) {\n            store.put(item.value, item.key);\n    }\n  });\n}\nfunction update(key, updater, store = getDefaultStore()) {\n    return store._withIDBStore('readwrite', store => {\n        const req = store.get(key);\n        req.onsuccess = () => {\n            store.put(updater(req.result), key);\n        };\n    });\n}\nfunction del(key, store = getDefaultStore()) {\n    return store._withIDBStore('readwrite', store => {\n        store.delete(key);\n    });\n}\nfunction clear(store = getDefaultStore()) {\n    return store._withIDBStore('readwrite', store => {\n        store.clear();\n    });\n}\nfunction keys(store = getDefaultStore()) {\n    const keys = [];\n    return store._withIDBStore('readwrite', store => {\n        // This would be store.getAllKeys(), but it isn't supported by Edge or Safari.\n        // And openKeyCursor isn't supported by Safari.\n        (store.openKeyCursor || store.openCursor).call(store).onsuccess = function () {\n            if (!this.result)\n                return;\n            keys.push(this.result.key);\n            this.result.continue();\n        };\n    }).then(() => keys);\n}\nfunction close(store = getDefaultStore()) {\n    return store._close();\n}\n\nexports.Store = Store;\nexports.get = get;\nexports.set = set;\nexports.setBatch = setBatch;\nexports.update = update;\nexports.del = del;\nexports.clear = clear;\nexports.keys = keys;\nexports.close = close;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js"]],"~:properties",["^5",["Store","keys","onerror","_dbName","onsuccess","key","__esModule","id","update","oncomplete","del","executor","setBatch","value","items","onupgradeneeded","_dbp","item","onProcessed","ongoing","close","_version","storeName","set","clear","onabort","get","_storeName"]],"~:compiled-at",1766065009524,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$frontend$idbkv.js\",\n\"lineCount\":5,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAsE9DC,QAASA,EAAe,EAAG,CAClBC,CAAL,GACIA,CADJ,CACY,IAAIC,CADhB,CAEA,OAAOD,EAHgB,CAnE3BE,MAAOC,CAAAA,cAAP,CAAsBL,CAAtB,CAA+B,YAA/B,CAA6C,CAAEM,MAAO,CAAA,CAAT,CAA7C,CAEA,MAAMH,EAAN,CACII,WAAW,CAACC,CAAA,CAAS,cAAV,CAA0BC,CAAA,CAAY,QAAtC,CAAgDC,CAAA,CAAU,CAA1D,CAA6D,CACpE,IAAKD,CAAAA,SAAL,CAAiBA,CACjB,KAAKE,CAAAA,OAAL,CAAeH,CACf,KAAKI,CAAAA,UAAL,CAAkBH,CAClB,KAAKI,CAAAA,QAAL,CAAgBH,CAChB,KAAKI,CAAAA,EAAL,CAAW,UAASN,CAAT,eAA8BC,CAA9B,EACX,KAAKM,CAAAA,KAAL,EANoE,CAQxEA,KAAK,EAAG,CACF,IAAKC,CAAAA,IAAT,GAGA,IAAKA,CAAAA,IAHL,CAGY,IAAIC,OAAJ,CAAY,CAACC,CAAD,CAAUC,CAAV,CAAA,EAAqB,CAC3C,MAAMC,EAAUC,MAAOC,CAAAA,SAAUC,CAAAA,IAAjB,CAAsB,IAAKZ,CAAAA,OAA3B,CAAoC,IAAKE,CAAAA,QAAzC,CAChBO,EAAQI,CAAAA,OAAR,CAAkB,EAAAC,EAAMN,CAAA,CAAOC,CAAQM,CAAAA,KAAf,CACxBN,EAAQO,CAAAA,SAAR,CAAoB,EAAAC,EAAMV,CAAA,CAAQE,CAAQS,CAAAA,MAAhB,CAE1BT,EAAQU,CAAAA,eAAR,CAA0B,EAAAC,EAAM,CAC9BX,CAAQS,CAAAA,MAAOG,CAAAA,iBAAf,CAAiC,IAAKpB,CAAAA,UAAtC,CAD8B,CALW,CAAjC,CAHZ,CADM,CAcRqB,aAAa,CAACC,CAAD;AAAOC,CAAP,CAAiB,CAC1B,IAAKpB,CAAAA,KAAL,EACA,OAAO,KAAKC,CAAAA,IAAKoB,CAAAA,IAAV,CAAeC,CAAA,EAAM,IAAIpB,OAAJ,CAAY,CAACC,CAAD,CAAUC,CAAV,CAAA,EAAqB,CACzD,MAAMmB,EAAcD,CAAGC,CAAAA,WAAH,CAAe,IAAK7B,CAAAA,SAApB,CAA+ByB,CAA/B,CACpBI,EAAYC,CAAAA,UAAZ,CAAyB,EAAAC,EAAMtB,CAAA,EAC/BoB,EAAYG,CAAAA,OAAZ,CAAsBH,CAAYd,CAAAA,OAAlC,CAA4C,EAAAkB,EAAMvB,CAAA,CAAOmB,CAAYZ,CAAAA,KAAnB,CAClDS,EAAA,CAASG,CAAYK,CAAAA,WAAZ,CAAwB,IAAKlC,CAAAA,SAA7B,CAAT,CAJyD,CAAjC,CAArB,CAFmB,CAS9BmC,MAAM,EAAG,CACL,IAAK7B,CAAAA,KAAL,EACA,OAAO,KAAKC,CAAAA,IAAKoB,CAAAA,IAAV,CAAeC,CAAA,EAAM,CACxBA,CAAGQ,CAAAA,KAAH,EACA,KAAK7B,CAAAA,IAAL,CAAY8B,IAAAA,EAFY,CAArB,CAFF,CAhCb,CAwCA,KAAMC,EAAN,CACIxC,WAAW,CAACyC,CAAD,CAAW,CAClB,IAAKA,CAAAA,QAAL,CAAgBA,CAChB,KAAKC,CAAAA,KAAL,CAAa,EAFK,CAIlBC,OAAO,EAAG,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACV,MAAMC,EAAY,CAAKF,CAAAA,KACvB,EAAKA,CAAAA,KAAL,CAAa,EACb,MAAM,EAAKD,CAAAA,QAAL,CAAcG,CAAUC,CAAAA,GAAV,CAAc,CAAC,CAAE,KAAAC,CAAF,CAAD,CAAA,EAAcA,CAA5B,CAAd,CACNF,EAAUC,CAAAA,GAAV,CAAc,CAAC,CAAE,YAAAE,CAAF,CAAD,CAAA;AAAqBA,CAAA,EAAnC,CAEI,EAAKC,CAAAA,OAAL,CADA,CAAKN,CAAAA,KAAMO,CAAAA,MAAf,CACmB,CAAKN,CAAAA,OAAL,EADnB,CAImBJ,IAAAA,EATT,CAAA,CAAA,CAYRW,KAAK,CAACJ,CAAD,CAAO,CAAA,MAAA,EAAA,IAAA,OAAA,QAAA,CAAA,oCAAA,CAAA,SAAA,EAAA,CACd,MAAMxB,EAAS,IAAIZ,OAAJ,CAAaC,CAAD,EAAa,CAAK+B,CAAAA,KAAMS,CAAAA,IAAX,CAAgB,CAAEL,KAAAA,CAAF,CAAQC,YAAapC,CAArB,CAAhB,CAAzB,CACV,EAAKqC,CAAAA,OAAV,GACI,CAAKA,CAAAA,OADT,CACmB,CAAKL,CAAAA,OAAL,EADnB,CAEA,OAAOrB,EAJO,CAAA,CAAA,CAjBtB,CAwBA,IAAI3B,CAYJ,OAAMyD,EAAc,EAqDpB3D,EAAQG,CAAAA,KAAR,CAAgBA,CAChBH,EAAQ4D,CAAAA,GAAR,CA5DAA,QAAY,CAACC,CAAD,CAAM3D,CAAA,CAAQD,CAAA,EAAd,CAAiC,CACzC,IAAI6D,CACJ,OAAO5D,EAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA,EAAS,CAC7C4D,CAAA,CAAM5D,CAAM0D,CAAAA,GAAN,CAAUC,CAAV,CADuC,CAA1C,CAEJzB,CAAAA,IAFI,CAEC,EAAA,EAAM0B,CAAIjC,CAAAA,MAFX,CAFkC,CA6D7C7B,EAAQ+D,CAAAA,GAAR,CAtDAA,QAAY,CAACF,CAAD,CAAMvD,CAAN,CAAaJ,CAAA,CAAQD,CAAA,EAArB,CAAwC,CAC3C0D,CAAA,CAAYzD,CAAMY,CAAAA,EAAlB,CAAL,GACI6C,CAAA,CAAYzD,CAAMY,CAAAA,EAAlB,CADJ,CAC4B,IAAIiC,CAAJ,CAAaE,CAAD,EAAW/C,CAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA,EAAS,CACrF,IAAK,MAAMmD,CAAX,GAAmBJ,EAAnB,CACI/C,CAAM8D,CAAAA,GAAN,CAAUX,CAAK/C,CAAAA,KAAf,CAAsB+C,CAAKQ,CAAAA,GAA3B,CAFiF,CAA1C,CAAvB,CAD5B,CAOA;MAAOF,EAAA,CAAYzD,CAAMY,CAAAA,EAAlB,CAAsB2C,CAAAA,KAAtB,CAA4B,CAAEI,IAAAA,CAAF,CAAOvD,MAAAA,CAAP,CAA5B,CARyC,CAuDpDN,EAAQiE,CAAAA,QAAR,CA7CAA,QAAiB,CAAChB,CAAD,CAAQ/C,CAAA,CAAQD,CAAA,EAAhB,CAAmC,CAClD,MAAOC,EAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA,EAAS,CAC/C,IAAK,MAAMmD,CAAX,GAAmBJ,EAAnB,CACQ/C,CAAM8D,CAAAA,GAAN,CAAUX,CAAK/C,CAAAA,KAAf,CAAsB+C,CAAKQ,CAAAA,GAA3B,CAFuC,CAA1C,CAD2C,CA8CpD7D,EAAQkE,CAAAA,MAAR,CAvCAA,QAAe,CAACL,CAAD,CAAMM,CAAN,CAAejE,CAAA,CAAQD,CAAA,EAAvB,CAA0C,CACrD,MAAOC,EAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA,EAAS,CAC7C,MAAM4D,EAAM5D,CAAM0D,CAAAA,GAAN,CAAUC,CAAV,CACZC,EAAInC,CAAAA,SAAJ,CAAgB,EAAAyC,EAAM,CAClBlE,CAAM8D,CAAAA,GAAN,CAAUG,CAAA,CAAQL,CAAIjC,CAAAA,MAAZ,CAAV,CAA+BgC,CAA/B,CADkB,CAFuB,CAA1C,CAD8C,CAwCzD7D,EAAQqE,CAAAA,GAAR,CAhCAA,QAAY,CAACR,CAAD,CAAM3D,CAAA,CAAQD,CAAA,EAAd,CAAiC,CACzC,MAAOC,EAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA,EAAS,CAC7CA,CAAMoE,CAAAA,MAAN,CAAaT,CAAb,CAD6C,CAA1C,CADkC,CAiC7C7D,EAAQuE,CAAAA,KAAR,CA5BAA,QAAc,CAACrE,CAAA,CAAQD,CAAA,EAAT,CAA4B,CACtC,MAAOC,EAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA,EAAS,CAC7CA,CAAMqE,CAAAA,KAAN,EAD6C,CAA1C,CAD+B,CA6B1CvE,EAAQwE,CAAAA,IAAR,CAxBAA,QAAa,CAACtE,CAAA,CAAQD,CAAA,EAAT,CAA4B,CACrC,MAAMuE,EAAO,EACb,OAAOtE,EAAM+B,CAAAA,aAAN,CAAoB,WAApB,CAAiC/B,CAAA;AAAS,CAGHuE,CAAzCvE,CAAMwE,CAAAA,aAAmCD,EAAlBvE,CAAMyE,CAAAA,UAAYF,EAAAA,IAA1C,CAA+CvE,CAA/C,CAAsDyB,CAAAA,SAAtD,CAAkE,QAAS,EAAG,CACrE,IAAKE,CAAAA,MAAV,GAEA2C,CAAKd,CAAAA,IAAL,CAAU,IAAK7B,CAAAA,MAAOgC,CAAAA,GAAtB,CACA,CAAA,IAAKhC,CAAAA,MAAO+C,CAAAA,QAAZ,EAHA,CAD0E,CAHjC,CAA1C,CASJxC,CAAAA,IATI,CASC,EAAA,EAAMoC,CATP,CAF8B,CAyBzCxE,EAAQ6C,CAAAA,KAAR,CAZAA,QAAc,CAAC3C,CAAA,CAAQD,CAAA,EAAT,CAA4B,CACtC,MAAOC,EAAM0C,CAAAA,MAAN,EAD+B,CAlIoB;\",\n\"sources\":[\"frontend/idbkv.js\"],\n\"sourcesContent\":[\"shadow$provide[116] = function(global,require,module,exports) {\\n'use strict';\\n\\nObject.defineProperty(exports, '__esModule', { value: true });\\n\\nclass Store {\\n    constructor(dbName = 'keyval-store', storeName = 'keyval', version = 1) {\\n        this.storeName = storeName;\\n        this._dbName = dbName;\\n        this._storeName = storeName;\\n        this._version = version;\\n        this.id = `dbName:${dbName};;storeName:${storeName}`;\\n        this._init();\\n    }\\n    _init() {\\n      if (this._dbp) {\\n        return;\\n      }\\n      this._dbp = new Promise((resolve, reject) => {\\n        const openreq = window.indexedDB.open(this._dbName, this._version);\\n        openreq.onerror = () => reject(openreq.error);\\n        openreq.onsuccess = () => resolve(openreq.result);\\n        // First time setup: create an empty object store\\n        openreq.onupgradeneeded = () => {\\n          openreq.result.createObjectStore(this._storeName);\\n        };\\n      });\\n    }\\n    _withIDBStore(type, callback) {\\n        this._init();\\n        return this._dbp.then(db => new Promise((resolve, reject) => {\\n            const transaction = db.transaction(this.storeName, type);\\n            transaction.oncomplete = () => resolve();\\n            transaction.onabort = transaction.onerror = () => reject(transaction.error);\\n            callback(transaction.objectStore(this.storeName));\\n        }));\\n    }\\n    _close() {\\n        this._init();\\n        return this._dbp.then(db => {\\n            db.close();\\n            this._dbp = undefined;\\n        });\\n    }\\n}\\nclass Batcher {\\n    constructor(executor) {\\n        this.executor = executor;\\n        this.items = [];\\n    }\\n  async process() {\\n        const toProcess = this.items;\\n        this.items = [];\\n        await this.executor(toProcess.map(({ item }) => item));\\n        toProcess.map(({ onProcessed }) => onProcessed());\\n        if (this.items.length) {\\n            this.ongoing = this.process();\\n        }\\n        else {\\n            this.ongoing = undefined;\\n        }\\n    }\\n    async queue(item) {\\n        const result = new Promise((resolve) => this.items.push({ item, onProcessed: resolve }));\\n        if (!this.ongoing)\\n            this.ongoing = this.process();\\n        return result;\\n    }\\n}\\nlet store;\\nfunction getDefaultStore() {\\n    if (!store)\\n        store = new Store();\\n    return store;\\n}\\nfunction get(key, store = getDefaultStore()) {\\n    let req;\\n    return store._withIDBStore('readwrite', store => {\\n        req = store.get(key);\\n    }).then(() => req.result);\\n}\\nconst setBatchers = {};\\nfunction set(key, value, store = getDefaultStore()) {\\n    if (!setBatchers[store.id]) {\\n        setBatchers[store.id] = new Batcher((items) => store._withIDBStore('readwrite', store => {\\n            for (const item of items) {\\n                store.put(item.value, item.key);\\n            }\\n        }));\\n    }\\n    return setBatchers[store.id].queue({ key, value });\\n}\\nfunction setBatch(items, store = getDefaultStore()) {\\n  return store._withIDBStore('readwrite', store => {\\n    for (const item of items) {\\n            store.put(item.value, item.key);\\n    }\\n  });\\n}\\nfunction update(key, updater, store = getDefaultStore()) {\\n    return store._withIDBStore('readwrite', store => {\\n        const req = store.get(key);\\n        req.onsuccess = () => {\\n            store.put(updater(req.result), key);\\n        };\\n    });\\n}\\nfunction del(key, store = getDefaultStore()) {\\n    return store._withIDBStore('readwrite', store => {\\n        store.delete(key);\\n    });\\n}\\nfunction clear(store = getDefaultStore()) {\\n    return store._withIDBStore('readwrite', store => {\\n        store.clear();\\n    });\\n}\\nfunction keys(store = getDefaultStore()) {\\n    const keys = [];\\n    return store._withIDBStore('readwrite', store => {\\n        // This would be store.getAllKeys(), but it isn't supported by Edge or Safari.\\n        // And openKeyCursor isn't supported by Safari.\\n        (store.openKeyCursor || store.openCursor).call(store).onsuccess = function () {\\n            if (!this.result)\\n                return;\\n            keys.push(this.result.key);\\n            this.result.continue();\\n        };\\n    }).then(() => keys);\\n}\\nfunction close(store = getDefaultStore()) {\\n    return store._close();\\n}\\n\\nexports.Store = Store;\\nexports.get = get;\\nexports.set = set;\\nexports.setBatch = setBatch;\\nexports.update = update;\\nexports.del = del;\\nexports.clear = clear;\\nexports.keys = keys;\\nexports.close = close;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"getDefaultStore\",\"store\",\"Store\",\"Object\",\"defineProperty\",\"value\",\"constructor\",\"dbName\",\"storeName\",\"version\",\"_dbName\",\"_storeName\",\"_version\",\"id\",\"_init\",\"_dbp\",\"Promise\",\"resolve\",\"reject\",\"openreq\",\"window\",\"indexedDB\",\"open\",\"onerror\",\"openreq.onerror\",\"error\",\"onsuccess\",\"openreq.onsuccess\",\"result\",\"onupgradeneeded\",\"openreq.onupgradeneeded\",\"createObjectStore\",\"_withIDBStore\",\"type\",\"callback\",\"then\",\"db\",\"transaction\",\"oncomplete\",\"transaction.oncomplete\",\"onabort\",\"transaction.onerror\",\"objectStore\",\"_close\",\"close\",\"undefined\",\"Batcher\",\"executor\",\"items\",\"process\",\"toProcess\",\"map\",\"item\",\"onProcessed\",\"ongoing\",\"length\",\"queue\",\"push\",\"setBatchers\",\"get\",\"key\",\"req\",\"set\",\"put\",\"setBatch\",\"update\",\"updater\",\"req.onsuccess\",\"del\",\"delete\",\"clear\",\"keys\",\"call\",\"openKeyCursor\",\"openCursor\",\"continue\"]\n}\n"]