import "../../iso_codes/iso_code.dart";
import "../models/phone_metadata_examples.dart";

const metadataExamplesByIsoCode = {
  IsoCode.AC: PhoneMetadataExamples(
    fixedLine: r"62889",
    mobile: r"40123",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"542011",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AD: PhoneMetadataExamples(
    fixedLine: r"712345",
    mobile: r"312345",
    voip: r"",
    tollFree: r"18001234",
    premiumRate: r"912345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AE: PhoneMetadataExamples(
    fixedLine: r"22345678",
    mobile: r"501234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"900234567",
    sharedCost: r"700012345",
    personalNumber: r"",
    uan: r"600212345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AF: PhoneMetadataExamples(
    fixedLine: r"234567890",
    mobile: r"701234567",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AG: PhoneMetadataExamples(
    fixedLine: r"2684601234",
    mobile: r"2684641234",
    voip: r"2684801234",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"2684061234",
    voiceMail: r"",
  ),
  IsoCode.AI: PhoneMetadataExamples(
    fixedLine: r"2644612345",
    mobile: r"2642351234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"2647241234",
    voiceMail: r"",
  ),
  IsoCode.AL: PhoneMetadataExamples(
    fixedLine: r"22345678",
    mobile: r"672123456",
    voip: r"",
    tollFree: r"8001234",
    premiumRate: r"900123",
    sharedCost: r"808123",
    personalNumber: r"70021234",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AM: PhoneMetadataExamples(
    fixedLine: r"10123456",
    mobile: r"77123456",
    voip: r"60271234",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"80112345",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AO: PhoneMetadataExamples(
    fixedLine: r"222123456",
    mobile: r"923123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AR: PhoneMetadataExamples(
    fixedLine: r"1123456789",
    mobile: r"91123456789",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"6001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"8101234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AS: PhoneMetadataExamples(
    fixedLine: r"6846221234",
    mobile: r"6847331234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AT: PhoneMetadataExamples(
    fixedLine: r"1234567890",
    mobile: r"664123456",
    voip: r"780123456",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"810123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AU: PhoneMetadataExamples(
    fixedLine: r"212345678",
    mobile: r"412345678",
    voip: r"147101234",
    tollFree: r"1800123456",
    premiumRate: r"1900123456",
    sharedCost: r"1300123456",
    personalNumber: r"",
    uan: r"",
    pager: r"1631234",
    voiceMail: r"",
  ),
  IsoCode.AW: PhoneMetadataExamples(
    fixedLine: r"5212345",
    mobile: r"5601234",
    voip: r"5011234",
    tollFree: r"8001234",
    premiumRate: r"9001234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AX: PhoneMetadataExamples(
    fixedLine: r"181234567",
    mobile: r"412345678",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"600123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"10112345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.AZ: PhoneMetadataExamples(
    fixedLine: r"123123456",
    mobile: r"401234567",
    voip: r"",
    tollFree: r"881234567",
    premiumRate: r"900200123",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BA: PhoneMetadataExamples(
    fixedLine: r"30212345",
    mobile: r"61123456",
    voip: r"",
    tollFree: r"80123456",
    premiumRate: r"90123456",
    sharedCost: r"82123456",
    personalNumber: r"",
    uan: r"70341234",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BB: PhoneMetadataExamples(
    fixedLine: r"2464123456",
    mobile: r"2462501234",
    voip: r"2463101234",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"2464301234",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BD: PhoneMetadataExamples(
    fixedLine: r"27111234",
    mobile: r"1812345678",
    voip: r"9604123456",
    tollFree: r"8001234567",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BE: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"470123456",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"78791234",
    personalNumber: r"",
    uan: r"78102345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BF: PhoneMetadataExamples(
    fixedLine: r"20491234",
    mobile: r"70123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BG: PhoneMetadataExamples(
    fixedLine: r"2123456",
    mobile: r"43012345",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"90123456",
    sharedCost: r"70012345",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BH: PhoneMetadataExamples(
    fixedLine: r"17001234",
    mobile: r"36001234",
    voip: r"",
    tollFree: r"80123456",
    premiumRate: r"90123456",
    sharedCost: r"84123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BI: PhoneMetadataExamples(
    fixedLine: r"22201234",
    mobile: r"79561234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BJ: PhoneMetadataExamples(
    fixedLine: r"0120211234",
    mobile: r"0195123456",
    voip: r"85751234",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"81123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BL: PhoneMetadataExamples(
    fixedLine: r"590271234",
    mobile: r"690001234",
    voip: r"976012345",
    tollFree: r"800012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BM: PhoneMetadataExamples(
    fixedLine: r"4414123456",
    mobile: r"4413701234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BN: PhoneMetadataExamples(
    fixedLine: r"2345678",
    mobile: r"7123456",
    voip: r"5345678",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BO: PhoneMetadataExamples(
    fixedLine: r"22123456",
    mobile: r"71234567",
    voip: r"50123456",
    tollFree: r"800171234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BQ: PhoneMetadataExamples(
    fixedLine: r"7151234",
    mobile: r"3181234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BR: PhoneMetadataExamples(
    fixedLine: r"1123456789",
    mobile: r"11961234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"300123456",
    sharedCost: r"40041234",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BS: PhoneMetadataExamples(
    fixedLine: r"2423456789",
    mobile: r"2423591234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"2422250123",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BT: PhoneMetadataExamples(
    fixedLine: r"2345678",
    mobile: r"17123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BW: PhoneMetadataExamples(
    fixedLine: r"2401234",
    mobile: r"71123456",
    voip: r"79101234",
    tollFree: r"0800012345",
    premiumRate: r"9012345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BY: PhoneMetadataExamples(
    fixedLine: r"152450911",
    mobile: r"294911911",
    voip: r"249123456",
    tollFree: r"8011234567",
    premiumRate: r"9021234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.BZ: PhoneMetadataExamples(
    fixedLine: r"2221234",
    mobile: r"6221234",
    voip: r"",
    tollFree: r"08001234123",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CA: PhoneMetadataExamples(
    fixedLine: r"5062345678",
    mobile: r"5062345678",
    voip: r"6002012345",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"3101234",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CC: PhoneMetadataExamples(
    fixedLine: r"891621234",
    mobile: r"412345678",
    voip: r"147101234",
    tollFree: r"1800123456",
    premiumRate: r"1900123456",
    sharedCost: r"1300123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CD: PhoneMetadataExamples(
    fixedLine: r"1234567",
    mobile: r"991234567",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CF: PhoneMetadataExamples(
    fixedLine: r"21612345",
    mobile: r"70012345",
    voip: r"",
    tollFree: r"",
    premiumRate: r"87761234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CG: PhoneMetadataExamples(
    fixedLine: r"222123456",
    mobile: r"061234567",
    voip: r"",
    tollFree: r"",
    premiumRate: r"800123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CH: PhoneMetadataExamples(
    fixedLine: r"212345678",
    mobile: r"781234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"840123456",
    personalNumber: r"878123456",
    uan: r"581234567",
    pager: r"740123456",
    voiceMail: r"860123456789",
  ),
  IsoCode.CI: PhoneMetadataExamples(
    fixedLine: r"2123456789",
    mobile: r"0123456789",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CK: PhoneMetadataExamples(
    fixedLine: r"21234",
    mobile: r"71234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CL: PhoneMetadataExamples(
    fixedLine: r"221234567",
    mobile: r"221234567",
    voip: r"441234567",
    tollFree: r"800123456",
    premiumRate: r"",
    sharedCost: r"6001234567",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CM: PhoneMetadataExamples(
    fixedLine: r"222123456",
    mobile: r"671234567",
    voip: r"",
    tollFree: r"88012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CN: PhoneMetadataExamples(
    fixedLine: r"1012345678",
    mobile: r"13123456789",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"16812345",
    sharedCost: r"4001234567",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CO: PhoneMetadataExamples(
    fixedLine: r"6012345678",
    mobile: r"3211234567",
    voip: r"",
    tollFree: r"18001234567",
    premiumRate: r"19001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CR: PhoneMetadataExamples(
    fixedLine: r"22123456",
    mobile: r"83123456",
    voip: r"40001234",
    tollFree: r"8001234567",
    premiumRate: r"9001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CU: PhoneMetadataExamples(
    fixedLine: r"71234567",
    mobile: r"51234567",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"",
    sharedCost: r"8071234567",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CV: PhoneMetadataExamples(
    fixedLine: r"2211234",
    mobile: r"9911234",
    voip: r"3401234",
    tollFree: r"8001234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CW: PhoneMetadataExamples(
    fixedLine: r"94351234",
    mobile: r"95181234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"6001234",
    personalNumber: r"",
    uan: r"",
    pager: r"95581234",
    voiceMail: r"",
  ),
  IsoCode.CX: PhoneMetadataExamples(
    fixedLine: r"891641234",
    mobile: r"412345678",
    voip: r"147101234",
    tollFree: r"1800123456",
    premiumRate: r"1900123456",
    sharedCost: r"1300123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CY: PhoneMetadataExamples(
    fixedLine: r"22345678",
    mobile: r"96123456",
    voip: r"",
    tollFree: r"80001234",
    premiumRate: r"90012345",
    sharedCost: r"80112345",
    personalNumber: r"70012345",
    uan: r"77123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.CZ: PhoneMetadataExamples(
    fixedLine: r"212345678",
    mobile: r"601123456",
    voip: r"910123456",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"811234567",
    personalNumber: r"700123456",
    uan: r"972123456",
    pager: r"",
    voiceMail: r"93123456789",
  ),
  IsoCode.DE: PhoneMetadataExamples(
    fixedLine: r"30123456",
    mobile: r"15123456789",
    voip: r"",
    tollFree: r"8001234567890",
    premiumRate: r"9001234567",
    sharedCost: r"18012345",
    personalNumber: r"70012345678",
    uan: r"18500123456",
    pager: r"16412345",
    voiceMail: r"177991234567",
  ),
  IsoCode.DJ: PhoneMetadataExamples(
    fixedLine: r"21360003",
    mobile: r"77831001",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.DK: PhoneMetadataExamples(
    fixedLine: r"32123456",
    mobile: r"34412345",
    voip: r"",
    tollFree: r"80123456",
    premiumRate: r"90123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.DM: PhoneMetadataExamples(
    fixedLine: r"7674201234",
    mobile: r"7672251234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.DO: PhoneMetadataExamples(
    fixedLine: r"8092345678",
    mobile: r"8092345678",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.DZ: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"551234567",
    voip: r"983123456",
    tollFree: r"800123456",
    premiumRate: r"808123456",
    sharedCost: r"801123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.EC: PhoneMetadataExamples(
    fixedLine: r"22123456",
    mobile: r"991234567",
    voip: r"28901234",
    tollFree: r"18001234567",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.EE: PhoneMetadataExamples(
    fixedLine: r"3212345",
    mobile: r"51234567",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"9001234",
    sharedCost: r"",
    personalNumber: r"70012345",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.EG: PhoneMetadataExamples(
    fixedLine: r"234567890",
    mobile: r"1001234567",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"9001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.EH: PhoneMetadataExamples(
    fixedLine: r"528812345",
    mobile: r"650123456",
    voip: r"592401234",
    tollFree: r"801234567",
    premiumRate: r"891234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ER: PhoneMetadataExamples(
    fixedLine: r"8370362",
    mobile: r"7123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ES: PhoneMetadataExamples(
    fixedLine: r"810123456",
    mobile: r"612345678",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"803123456",
    sharedCost: r"901123456",
    personalNumber: r"701234567",
    uan: r"511234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ET: PhoneMetadataExamples(
    fixedLine: r"111112345",
    mobile: r"911234567",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.FI: PhoneMetadataExamples(
    fixedLine: r"131234567",
    mobile: r"412345678",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"600123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"10112345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.FJ: PhoneMetadataExamples(
    fixedLine: r"3212345",
    mobile: r"7012345",
    voip: r"",
    tollFree: r"08001234567",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.FK: PhoneMetadataExamples(
    fixedLine: r"31234",
    mobile: r"51234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.FM: PhoneMetadataExamples(
    fixedLine: r"3201234",
    mobile: r"3501234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.FO: PhoneMetadataExamples(
    fixedLine: r"201234",
    mobile: r"211234",
    voip: r"601234",
    tollFree: r"802123",
    premiumRate: r"901123",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.FR: PhoneMetadataExamples(
    fixedLine: r"123456789",
    mobile: r"612345678",
    voip: r"912345678",
    tollFree: r"801234567",
    premiumRate: r"891123456",
    sharedCost: r"884012345",
    personalNumber: r"",
    uan: r"806123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GA: PhoneMetadataExamples(
    fixedLine: r"01441234",
    mobile: r"06031234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GB: PhoneMetadataExamples(
    fixedLine: r"1212345678",
    mobile: r"7400123456",
    voip: r"5612345678",
    tollFree: r"8001234567",
    premiumRate: r"9012345678",
    sharedCost: r"",
    personalNumber: r"7012345678",
    uan: r"5512345678",
    pager: r"7640123456",
    voiceMail: r"",
  ),
  IsoCode.GD: PhoneMetadataExamples(
    fixedLine: r"4732691234",
    mobile: r"4734031234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GE: PhoneMetadataExamples(
    fixedLine: r"322123456",
    mobile: r"555123456",
    voip: r"706123456",
    tollFree: r"800123456",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GF: PhoneMetadataExamples(
    fixedLine: r"594101234",
    mobile: r"694201234",
    voip: r"976012345",
    tollFree: r"800012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GG: PhoneMetadataExamples(
    fixedLine: r"1481256789",
    mobile: r"7781123456",
    voip: r"5612345678",
    tollFree: r"8001234567",
    premiumRate: r"9012345678",
    sharedCost: r"",
    personalNumber: r"7012345678",
    uan: r"5512345678",
    pager: r"7640123456",
    voiceMail: r"",
  ),
  IsoCode.GH: PhoneMetadataExamples(
    fixedLine: r"302345678",
    mobile: r"231234567",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GI: PhoneMetadataExamples(
    fixedLine: r"20012345",
    mobile: r"57123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GL: PhoneMetadataExamples(
    fixedLine: r"321000",
    mobile: r"221234",
    voip: r"381234",
    tollFree: r"801234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GM: PhoneMetadataExamples(
    fixedLine: r"5661234",
    mobile: r"3012345",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GN: PhoneMetadataExamples(
    fixedLine: r"30241234",
    mobile: r"601123456",
    voip: r"722123456",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GP: PhoneMetadataExamples(
    fixedLine: r"590201234",
    mobile: r"690001234",
    voip: r"976012345",
    tollFree: r"800012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GQ: PhoneMetadataExamples(
    fixedLine: r"333091234",
    mobile: r"222123456",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GR: PhoneMetadataExamples(
    fixedLine: r"2123456789",
    mobile: r"6912345678",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"9091234567",
    sharedCost: r"8011234567",
    personalNumber: r"7012345678",
    uan: r"5005000123",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GT: PhoneMetadataExamples(
    fixedLine: r"22456789",
    mobile: r"51234567",
    voip: r"",
    tollFree: r"18001112222",
    premiumRate: r"19001112222",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GU: PhoneMetadataExamples(
    fixedLine: r"6713001234",
    mobile: r"6713001234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GW: PhoneMetadataExamples(
    fixedLine: r"443201234",
    mobile: r"955012345",
    voip: r"4012345",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.GY: PhoneMetadataExamples(
    fixedLine: r"2201234",
    mobile: r"6091234",
    voip: r"5151234",
    tollFree: r"2891234",
    premiumRate: r"9008123",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.HK: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"51234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"90012345678",
    sharedCost: r"",
    personalNumber: r"81123456",
    uan: r"30161234",
    pager: r"71123456",
    voiceMail: r"",
  ),
  IsoCode.HN: PhoneMetadataExamples(
    fixedLine: r"22123456",
    mobile: r"91234567",
    voip: r"",
    tollFree: r"80021234567",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.HR: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"921234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"611234",
    sharedCost: r"",
    personalNumber: r"74123456",
    uan: r"62123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.HT: PhoneMetadataExamples(
    fixedLine: r"22453300",
    mobile: r"34101234",
    voip: r"98901234",
    tollFree: r"80012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.HU: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"201234567",
    voip: r"211234567",
    tollFree: r"80123456",
    premiumRate: r"90123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"381234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ID: PhoneMetadataExamples(
    fixedLine: r"218350123",
    mobile: r"812345678",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"8091234567",
    sharedCost: r"8041234567",
    personalNumber: r"",
    uan: r"8071123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.IE: PhoneMetadataExamples(
    fixedLine: r"2212345",
    mobile: r"850123456",
    voip: r"761234567",
    tollFree: r"1800123456",
    premiumRate: r"1520123456",
    sharedCost: r"1850123456",
    personalNumber: r"700123456",
    uan: r"818123456",
    pager: r"",
    voiceMail: r"8551234567",
  ),
  IsoCode.IL: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"502345678",
    voip: r"771234567",
    tollFree: r"1800123456",
    premiumRate: r"1919123456",
    sharedCost: r"1700123456",
    personalNumber: r"",
    uan: r"1599123456",
    pager: r"",
    voiceMail: r"15112340000",
  ),
  IsoCode.IM: PhoneMetadataExamples(
    fixedLine: r"1624756789",
    mobile: r"7924123456",
    voip: r"5612345678",
    tollFree: r"8081624567",
    premiumRate: r"9016247890",
    sharedCost: r"",
    personalNumber: r"7012345678",
    uan: r"5512345678",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.IN: PhoneMetadataExamples(
    fixedLine: r"7410410123",
    mobile: r"8123456789",
    voip: r"",
    tollFree: r"1800123456",
    premiumRate: r"1861123456789",
    sharedCost: r"18603451234",
    personalNumber: r"",
    uan: r"1409305260",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.IO: PhoneMetadataExamples(
    fixedLine: r"3709100",
    mobile: r"3801234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.IQ: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"7912345678",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.IR: PhoneMetadataExamples(
    fixedLine: r"2123456789",
    mobile: r"9123456789",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"9601",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.IS: PhoneMetadataExamples(
    fixedLine: r"4101234",
    mobile: r"6111234",
    voip: r"4921234",
    tollFree: r"8001234",
    premiumRate: r"9001234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"8091234",
    pager: r"",
    voiceMail: r"6891234",
  ),
  IsoCode.IT: PhoneMetadataExamples(
    fixedLine: r"0212345678",
    mobile: r"3123456789",
    voip: r"5512345678",
    tollFree: r"800123456",
    premiumRate: r"899123456",
    sharedCost: r"848123456",
    personalNumber: r"1781234567",
    uan: r"",
    pager: r"",
    voiceMail: r"33101234501",
  ),
  IsoCode.JE: PhoneMetadataExamples(
    fixedLine: r"1534456789",
    mobile: r"7797712345",
    voip: r"5612345678",
    tollFree: r"8007354567",
    premiumRate: r"9018105678",
    sharedCost: r"",
    personalNumber: r"7015115678",
    uan: r"5512345678",
    pager: r"7640123456",
    voiceMail: r"",
  ),
  IsoCode.JM: PhoneMetadataExamples(
    fixedLine: r"8765230123",
    mobile: r"8762101234",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.JO: PhoneMetadataExamples(
    fixedLine: r"62001234",
    mobile: r"790123456",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"85012345",
    personalNumber: r"700123456",
    uan: r"88101234",
    pager: r"746612345",
    voiceMail: r"",
  ),
  IsoCode.JP: PhoneMetadataExamples(
    fixedLine: r"312345678",
    mobile: r"9012345678",
    voip: r"5012345678",
    tollFree: r"120123456",
    premiumRate: r"990123456",
    sharedCost: r"",
    personalNumber: r"601234567",
    uan: r"570123456",
    pager: r"2012345678",
    voiceMail: r"",
  ),
  IsoCode.KE: PhoneMetadataExamples(
    fixedLine: r"202012345",
    mobile: r"712123456",
    voip: r"",
    tollFree: r"800223456",
    premiumRate: r"900223456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KG: PhoneMetadataExamples(
    fixedLine: r"312123456",
    mobile: r"700123456",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KH: PhoneMetadataExamples(
    fixedLine: r"23756789",
    mobile: r"91234567",
    voip: r"",
    tollFree: r"1800123456",
    premiumRate: r"1900123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KI: PhoneMetadataExamples(
    fixedLine: r"31234",
    mobile: r"72001234",
    voip: r"30010000",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KM: PhoneMetadataExamples(
    fixedLine: r"7712345",
    mobile: r"3212345",
    voip: r"",
    tollFree: r"",
    premiumRate: r"8001234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KN: PhoneMetadataExamples(
    fixedLine: r"8692361234",
    mobile: r"8697652917",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KP: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"1921234567",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KR: PhoneMetadataExamples(
    fixedLine: r"22123456",
    mobile: r"1020000000",
    voip: r"7012345678",
    tollFree: r"801234567",
    premiumRate: r"602345678",
    sharedCost: r"",
    personalNumber: r"5012345678",
    uan: r"15441234",
    pager: r"1523456789",
    voiceMail: r"",
  ),
  IsoCode.KW: PhoneMetadataExamples(
    fixedLine: r"22345678",
    mobile: r"50012345",
    voip: r"",
    tollFree: r"1801234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.KY: PhoneMetadataExamples(
    fixedLine: r"3452221234",
    mobile: r"3453231234",
    voip: r"",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"3458491234",
    voiceMail: r"",
  ),
  IsoCode.KZ: PhoneMetadataExamples(
    fixedLine: r"7123456789",
    mobile: r"7710009998",
    voip: r"7511234567",
    tollFree: r"8001234567",
    premiumRate: r"8091234567",
    sharedCost: r"",
    personalNumber: r"8081234567",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LA: PhoneMetadataExamples(
    fixedLine: r"21212862",
    mobile: r"2023123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"301234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LB: PhoneMetadataExamples(
    fixedLine: r"1123456",
    mobile: r"71123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"90123456",
    sharedCost: r"80123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LC: PhoneMetadataExamples(
    fixedLine: r"7584305678",
    mobile: r"7582845678",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LI: PhoneMetadataExamples(
    fixedLine: r"2345678",
    mobile: r"660234567",
    voip: r"",
    tollFree: r"8002222",
    premiumRate: r"9002222",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"8702812",
    pager: r"",
    voiceMail: r"697861234",
  ),
  IsoCode.LK: PhoneMetadataExamples(
    fixedLine: r"112345678",
    mobile: r"712345678",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"197312345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LR: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"770123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"332021234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LS: PhoneMetadataExamples(
    fixedLine: r"22123456",
    mobile: r"50123456",
    voip: r"",
    tollFree: r"80021234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LT: PhoneMetadataExamples(
    fixedLine: r"31234567",
    mobile: r"61234567",
    voip: r"80123456",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"80812345",
    personalNumber: r"70012345",
    uan: r"70712345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LU: PhoneMetadataExamples(
    fixedLine: r"27123456",
    mobile: r"628123456",
    voip: r"20201234",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"80112345",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LV: PhoneMetadataExamples(
    fixedLine: r"63123456",
    mobile: r"21234567",
    voip: r"",
    tollFree: r"80123456",
    premiumRate: r"90123456",
    sharedCost: r"81123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.LY: PhoneMetadataExamples(
    fixedLine: r"212345678",
    mobile: r"912345678",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MA: PhoneMetadataExamples(
    fixedLine: r"520123456",
    mobile: r"650123456",
    voip: r"592401234",
    tollFree: r"801234567",
    premiumRate: r"891234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MC: PhoneMetadataExamples(
    fixedLine: r"99123456",
    mobile: r"612345678",
    voip: r"",
    tollFree: r"90123456",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MD: PhoneMetadataExamples(
    fixedLine: r"22212345",
    mobile: r"62112345",
    voip: r"30123456",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"80812345",
    personalNumber: r"",
    uan: r"80312345",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ME: PhoneMetadataExamples(
    fixedLine: r"30234567",
    mobile: r"67622901",
    voip: r"78108780",
    tollFree: r"80080002",
    premiumRate: r"94515151",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"77273012",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MF: PhoneMetadataExamples(
    fixedLine: r"590271234",
    mobile: r"690001234",
    voip: r"976012345",
    tollFree: r"800012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MG: PhoneMetadataExamples(
    fixedLine: r"202123456",
    mobile: r"321234567",
    voip: r"221234567",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MH: PhoneMetadataExamples(
    fixedLine: r"2471234",
    mobile: r"2351234",
    voip: r"6351234",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MK: PhoneMetadataExamples(
    fixedLine: r"22012345",
    mobile: r"72345678",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"50012345",
    sharedCost: r"80123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ML: PhoneMetadataExamples(
    fixedLine: r"20212345",
    mobile: r"65012345",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MM: PhoneMetadataExamples(
    fixedLine: r"1234567",
    mobile: r"92123456",
    voip: r"13331234",
    tollFree: r"8008001234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MN: PhoneMetadataExamples(
    fixedLine: r"53123456",
    mobile: r"88123456",
    voip: r"75123456",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MO: PhoneMetadataExamples(
    fixedLine: r"28212345",
    mobile: r"66123456",
    voip: r"",
    tollFree: r"0800501",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MP: PhoneMetadataExamples(
    fixedLine: r"6702345678",
    mobile: r"6702345678",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MQ: PhoneMetadataExamples(
    fixedLine: r"596301234",
    mobile: r"696201234",
    voip: r"976612345",
    tollFree: r"800012345",
    premiumRate: r"810123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MR: PhoneMetadataExamples(
    fixedLine: r"35123456",
    mobile: r"22123456",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MS: PhoneMetadataExamples(
    fixedLine: r"6644912345",
    mobile: r"6644923456",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MT: PhoneMetadataExamples(
    fixedLine: r"21001234",
    mobile: r"96961234",
    voip: r"35501234",
    tollFree: r"80071234",
    premiumRate: r"50037123",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"50112345",
    pager: r"71171234",
    voiceMail: r"",
  ),
  IsoCode.MU: PhoneMetadataExamples(
    fixedLine: r"54480123",
    mobile: r"52512345",
    voip: r"3201234",
    tollFree: r"8001234",
    premiumRate: r"3012345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MV: PhoneMetadataExamples(
    fixedLine: r"6701234",
    mobile: r"7712345",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"9001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"4001234",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MW: PhoneMetadataExamples(
    fixedLine: r"1234567",
    mobile: r"991234567",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MX: PhoneMetadataExamples(
    fixedLine: r"2001234567",
    mobile: r"2221234567",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"9001234567",
    sharedCost: r"3001234567",
    personalNumber: r"5001234567",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MY: PhoneMetadataExamples(
    fixedLine: r"323856789",
    mobile: r"123456789",
    voip: r"1546012345",
    tollFree: r"1300123456",
    premiumRate: r"1600123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.MZ: PhoneMetadataExamples(
    fixedLine: r"21123456",
    mobile: r"821234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NA: PhoneMetadataExamples(
    fixedLine: r"61221234",
    mobile: r"811234567",
    voip: r"88612345",
    tollFree: r"800123456",
    premiumRate: r"870123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NC: PhoneMetadataExamples(
    fixedLine: r"201234",
    mobile: r"751234",
    voip: r"",
    tollFree: r"050012",
    premiumRate: r"366711",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NE: PhoneMetadataExamples(
    fixedLine: r"20201234",
    mobile: r"93123456",
    voip: r"",
    tollFree: r"08123456",
    premiumRate: r"09123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NF: PhoneMetadataExamples(
    fixedLine: r"106609",
    mobile: r"381234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NG: PhoneMetadataExamples(
    fixedLine: r"2033123456",
    mobile: r"8021234567",
    voip: r"",
    tollFree: r"80017591759",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"7001234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NI: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"81234567",
    voip: r"",
    tollFree: r"18001234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NL: PhoneMetadataExamples(
    fixedLine: r"101234567",
    mobile: r"612345678",
    voip: r"851234567",
    tollFree: r"8001234",
    premiumRate: r"9061234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"14020",
    pager: r"662345678",
    voiceMail: r"",
  ),
  IsoCode.NO: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"40612345",
    voip: r"85012345",
    tollFree: r"80012345",
    premiumRate: r"82012345",
    sharedCost: r"81021234",
    personalNumber: r"88012345",
    uan: r"02000",
    pager: r"",
    voiceMail: r"81212345",
  ),
  IsoCode.NP: PhoneMetadataExamples(
    fixedLine: r"14567890",
    mobile: r"9841234567",
    voip: r"",
    tollFree: r"16600101234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NR: PhoneMetadataExamples(
    fixedLine: r"4441234",
    mobile: r"5551234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NU: PhoneMetadataExamples(
    fixedLine: r"7012",
    mobile: r"8884012",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.NZ: PhoneMetadataExamples(
    fixedLine: r"32345678",
    mobile: r"211234567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"",
    personalNumber: r"701234567",
    uan: r"83012378",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.OM: PhoneMetadataExamples(
    fixedLine: r"23123456",
    mobile: r"92123456",
    voip: r"",
    tollFree: r"80071234",
    premiumRate: r"90012345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PA: PhoneMetadataExamples(
    fixedLine: r"2001234",
    mobile: r"61234567",
    voip: r"",
    tollFree: r"8001234",
    premiumRate: r"8601234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PE: PhoneMetadataExamples(
    fixedLine: r"11234567",
    mobile: r"912345678",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"80512345",
    sharedCost: r"80112345",
    personalNumber: r"80212345",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PF: PhoneMetadataExamples(
    fixedLine: r"40412345",
    mobile: r"87123456",
    voip: r"49901234",
    tollFree: r"800012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"440123",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PG: PhoneMetadataExamples(
    fixedLine: r"3123456",
    mobile: r"70123456",
    voip: r"2751234",
    tollFree: r"1801234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"2700123",
    voiceMail: r"",
  ),
  IsoCode.PH: PhoneMetadataExamples(
    fixedLine: r"232345678",
    mobile: r"9051234567",
    voip: r"",
    tollFree: r"180012345678",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PK: PhoneMetadataExamples(
    fixedLine: r"2123456789",
    mobile: r"3012345678",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"",
    personalNumber: r"122044444",
    uan: r"21111825888",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PL: PhoneMetadataExamples(
    fixedLine: r"123456789",
    mobile: r"512345678",
    voip: r"391234567",
    tollFree: r"800123456",
    premiumRate: r"701234567",
    sharedCost: r"801234567",
    personalNumber: r"",
    uan: r"804123456",
    pager: r"641234567",
    voiceMail: r"",
  ),
  IsoCode.PM: PhoneMetadataExamples(
    fixedLine: r"430123",
    mobile: r"551234",
    voip: r"",
    tollFree: r"800012345",
    premiumRate: r"810123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PR: PhoneMetadataExamples(
    fixedLine: r"7872345678",
    mobile: r"7872345678",
    voip: r"",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PS: PhoneMetadataExamples(
    fixedLine: r"22234567",
    mobile: r"599123456",
    voip: r"",
    tollFree: r"1800123456",
    premiumRate: r"",
    sharedCost: r"1700123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PT: PhoneMetadataExamples(
    fixedLine: r"212345678",
    mobile: r"912345678",
    voip: r"301234567",
    tollFree: r"800123456",
    premiumRate: r"760123456",
    sharedCost: r"808123456",
    personalNumber: r"884123456",
    uan: r"707123456",
    pager: r"622212345",
    voiceMail: r"600110000",
  ),
  IsoCode.PW: PhoneMetadataExamples(
    fixedLine: r"2771234",
    mobile: r"6201234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.PY: PhoneMetadataExamples(
    fixedLine: r"212345678",
    mobile: r"961456789",
    voip: r"870012345",
    tollFree: r"98000123456",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"201234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.QA: PhoneMetadataExamples(
    fixedLine: r"44123456",
    mobile: r"33123456",
    voip: r"",
    tollFree: r"8001234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"2123456",
    voiceMail: r"",
  ),
  IsoCode.RE: PhoneMetadataExamples(
    fixedLine: r"262161234",
    mobile: r"692123456",
    voip: r"939901234",
    tollFree: r"801234567",
    premiumRate: r"891123456",
    sharedCost: r"810123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.RO: PhoneMetadataExamples(
    fixedLine: r"211234567",
    mobile: r"712034567",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"801123456",
    personalNumber: r"",
    uan: r"372123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.RS: PhoneMetadataExamples(
    fixedLine: r"10234567",
    mobile: r"601234567",
    voip: r"",
    tollFree: r"80012345",
    premiumRate: r"90012345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"700123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.RU: PhoneMetadataExamples(
    fixedLine: r"3011234567",
    mobile: r"9123456789",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"8091234567",
    sharedCost: r"",
    personalNumber: r"8081234567",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.RW: PhoneMetadataExamples(
    fixedLine: r"250123456",
    mobile: r"720123456",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SA: PhoneMetadataExamples(
    fixedLine: r"112345678",
    mobile: r"512345678",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"925012345",
    sharedCost: r"920012345",
    personalNumber: r"",
    uan: r"8110123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SB: PhoneMetadataExamples(
    fixedLine: r"40123",
    mobile: r"7421234",
    voip: r"51123",
    tollFree: r"18123",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SC: PhoneMetadataExamples(
    fixedLine: r"4217123",
    mobile: r"2510123",
    voip: r"6412345",
    tollFree: r"8000000",
    premiumRate: r"8512345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SD: PhoneMetadataExamples(
    fixedLine: r"153123456",
    mobile: r"911231234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SE: PhoneMetadataExamples(
    fixedLine: r"8123456",
    mobile: r"701234567",
    voip: r"",
    tollFree: r"20123456",
    premiumRate: r"9001234567",
    sharedCost: r"771234567",
    personalNumber: r"751234567",
    uan: r"102345678",
    pager: r"740123456",
    voiceMail: r"254123456789",
  ),
  IsoCode.SG: PhoneMetadataExamples(
    fixedLine: r"61234567",
    mobile: r"81234567",
    voip: r"31234567",
    tollFree: r"18001234567",
    premiumRate: r"19001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"70001234567",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SH: PhoneMetadataExamples(
    fixedLine: r"22158",
    mobile: r"51234",
    voip: r"26212",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SI: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"31234567",
    voip: r"59012345",
    tollFree: r"80123456",
    premiumRate: r"90123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SJ: PhoneMetadataExamples(
    fixedLine: r"79123456",
    mobile: r"41234567",
    voip: r"85012345",
    tollFree: r"80012345",
    premiumRate: r"82012345",
    sharedCost: r"81021234",
    personalNumber: r"88012345",
    uan: r"02000",
    pager: r"",
    voiceMail: r"81212345",
  ),
  IsoCode.SK: PhoneMetadataExamples(
    fixedLine: r"221234567",
    mobile: r"912123456",
    voip: r"690123456",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"850123456",
    personalNumber: r"",
    uan: r"961234567",
    pager: r"9090123",
    voiceMail: r"",
  ),
  IsoCode.SL: PhoneMetadataExamples(
    fixedLine: r"22221234",
    mobile: r"25123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SM: PhoneMetadataExamples(
    fixedLine: r"0549886377",
    mobile: r"66661212",
    voip: r"58001110",
    tollFree: r"",
    premiumRate: r"71123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SN: PhoneMetadataExamples(
    fixedLine: r"301012345",
    mobile: r"701234567",
    voip: r"933301234",
    tollFree: r"800123456",
    premiumRate: r"884123456",
    sharedCost: r"810123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SO: PhoneMetadataExamples(
    fixedLine: r"4012345",
    mobile: r"71123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SR: PhoneMetadataExamples(
    fixedLine: r"211234",
    mobile: r"7412345",
    voip: r"561234",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SS: PhoneMetadataExamples(
    fixedLine: r"181234567",
    mobile: r"977123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ST: PhoneMetadataExamples(
    fixedLine: r"2221234",
    mobile: r"9812345",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SV: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"70123456",
    voip: r"",
    tollFree: r"8001234",
    premiumRate: r"9001234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SX: PhoneMetadataExamples(
    fixedLine: r"7215425678",
    mobile: r"7215205678",
    voip: r"",
    tollFree: r"8002123456",
    premiumRate: r"9002123456",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SY: PhoneMetadataExamples(
    fixedLine: r"112345678",
    mobile: r"944567890",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.SZ: PhoneMetadataExamples(
    fixedLine: r"22171234",
    mobile: r"76123456",
    voip: r"70012345",
    tollFree: r"08001234",
    premiumRate: r"900012345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TA: PhoneMetadataExamples(
    fixedLine: r"8999",
    mobile: r"8999",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TC: PhoneMetadataExamples(
    fixedLine: r"6497121234",
    mobile: r"6492311234",
    voip: r"6497101234",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TD: PhoneMetadataExamples(
    fixedLine: r"22501234",
    mobile: r"63012345",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TG: PhoneMetadataExamples(
    fixedLine: r"22212345",
    mobile: r"90112345",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TH: PhoneMetadataExamples(
    fixedLine: r"21234567",
    mobile: r"812345678",
    voip: r"601234567",
    tollFree: r"1800123456",
    premiumRate: r"1900123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TJ: PhoneMetadataExamples(
    fixedLine: r"372123456",
    mobile: r"917123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TK: PhoneMetadataExamples(
    fixedLine: r"3101",
    mobile: r"7290",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TL: PhoneMetadataExamples(
    fixedLine: r"2112345",
    mobile: r"77212345",
    voip: r"",
    tollFree: r"8012345",
    premiumRate: r"9012345",
    sharedCost: r"",
    personalNumber: r"7012345",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TM: PhoneMetadataExamples(
    fixedLine: r"12345678",
    mobile: r"66123456",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TN: PhoneMetadataExamples(
    fixedLine: r"30010123",
    mobile: r"20123456",
    voip: r"",
    tollFree: r"80101234",
    premiumRate: r"88123456",
    sharedCost: r"81101234",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TO: PhoneMetadataExamples(
    fixedLine: r"20123",
    mobile: r"7715123",
    voip: r"5510123",
    tollFree: r"0800222",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TR: PhoneMetadataExamples(
    fixedLine: r"2123456789",
    mobile: r"5012345678",
    voip: r"8500123456",
    tollFree: r"8001234567",
    premiumRate: r"9001234567",
    sharedCost: r"",
    personalNumber: r"5922121234",
    uan: r"4441444",
    pager: r"5123456789",
    voiceMail: r"",
  ),
  IsoCode.TT: PhoneMetadataExamples(
    fixedLine: r"8682211234",
    mobile: r"8682911234",
    voip: r"",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"8686191234",
  ),
  IsoCode.TV: PhoneMetadataExamples(
    fixedLine: r"20123",
    mobile: r"901234",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TW: PhoneMetadataExamples(
    fixedLine: r"221234567",
    mobile: r"912345678",
    voip: r"7012345678",
    tollFree: r"800123456",
    premiumRate: r"203123456",
    sharedCost: r"",
    personalNumber: r"990123456",
    uan: r"500123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.TZ: PhoneMetadataExamples(
    fixedLine: r"222345678",
    mobile: r"621234567",
    voip: r"412345678",
    tollFree: r"800123456",
    premiumRate: r"900123456",
    sharedCost: r"840123456",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.UA: PhoneMetadataExamples(
    fixedLine: r"311234567",
    mobile: r"501234567",
    voip: r"891234567",
    tollFree: r"800123456",
    premiumRate: r"900212345",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.UG: PhoneMetadataExamples(
    fixedLine: r"312345678",
    mobile: r"712345678",
    voip: r"",
    tollFree: r"800123456",
    premiumRate: r"901123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.US: PhoneMetadataExamples(
    fixedLine: r"2015550123",
    mobile: r"2015550123",
    voip: r"3052090123",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.UY: PhoneMetadataExamples(
    fixedLine: r"21231234",
    mobile: r"94231234",
    voip: r"",
    tollFree: r"8001234",
    premiumRate: r"9001234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.UZ: PhoneMetadataExamples(
    fixedLine: r"669050123",
    mobile: r"912345678",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.VA: PhoneMetadataExamples(
    fixedLine: r"0669812345",
    mobile: r"3123456789",
    voip: r"5512345678",
    tollFree: r"800123456",
    premiumRate: r"899123456",
    sharedCost: r"848123456",
    personalNumber: r"1781234567",
    uan: r"",
    pager: r"",
    voiceMail: r"33101234501",
  ),
  IsoCode.VC: PhoneMetadataExamples(
    fixedLine: r"7842661234",
    mobile: r"7844301234",
    voip: r"7845101234",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.VE: PhoneMetadataExamples(
    fixedLine: r"2121234567",
    mobile: r"4121234567",
    voip: r"",
    tollFree: r"8001234567",
    premiumRate: r"9001234567",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"5010123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.VG: PhoneMetadataExamples(
    fixedLine: r"2842291234",
    mobile: r"2843001234",
    voip: r"",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.VI: PhoneMetadataExamples(
    fixedLine: r"3406421234",
    mobile: r"3406421234",
    voip: r"",
    tollFree: r"8002345678",
    premiumRate: r"9002345678",
    sharedCost: r"",
    personalNumber: r"5002345678",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.VN: PhoneMetadataExamples(
    fixedLine: r"2101234567",
    mobile: r"912345678",
    voip: r"672012345",
    tollFree: r"1800123456",
    premiumRate: r"1900123456",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"1992000",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.VU: PhoneMetadataExamples(
    fixedLine: r"22123",
    mobile: r"5912345",
    voip: r"9010123",
    tollFree: r"81123",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"30123",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.WF: PhoneMetadataExamples(
    fixedLine: r"721234",
    mobile: r"821234",
    voip: r"921234",
    tollFree: r"800012345",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"401234",
  ),
  IsoCode.WS: PhoneMetadataExamples(
    fixedLine: r"22123",
    mobile: r"7212345",
    voip: r"",
    tollFree: r"800123",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.XK: PhoneMetadataExamples(
    fixedLine: r"28012345",
    mobile: r"43201234",
    voip: r"",
    tollFree: r"80001234",
    premiumRate: r"90001234",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.YE: PhoneMetadataExamples(
    fixedLine: r"1234567",
    mobile: r"712345678",
    voip: r"",
    tollFree: r"",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.YT: PhoneMetadataExamples(
    fixedLine: r"269601234",
    mobile: r"639012345",
    voip: r"939801234",
    tollFree: r"801234567",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ZA: PhoneMetadataExamples(
    fixedLine: r"101234567",
    mobile: r"711234567",
    voip: r"871234567",
    tollFree: r"801234567",
    premiumRate: r"862345678",
    sharedCost: r"860123456",
    personalNumber: r"",
    uan: r"861123456",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ZM: PhoneMetadataExamples(
    fixedLine: r"211234567",
    mobile: r"955123456",
    voip: r"630123456",
    tollFree: r"800123456",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
  IsoCode.ZW: PhoneMetadataExamples(
    fixedLine: r"1312345",
    mobile: r"712345678",
    voip: r"8686123456",
    tollFree: r"8001234",
    premiumRate: r"",
    sharedCost: r"",
    personalNumber: r"",
    uan: r"",
    pager: r"",
    voiceMail: r"",
  ),
};
