// ignore_for_file: constant_identifier_names

enum IsoCode {
  AC,
  AD,
  AE,
  AF,
  AG,
  AI,
  AL,
  AM,
  AO,
  AR,
  AS,
  AT,
  AU,
  AW,
  AX,
  AZ,
  BA,
  BB,
  BD,
  BE,
  BF,
  BG,
  BH,
  BI,
  BJ,
  BL,
  BM,
  BN,
  BO,
  BQ,
  BR,
  BS,
  BT,
  BW,
  BY,
  BZ,
  CA,
  CC,
  CD,
  CF,
  CG,
  CH,
  CI,
  CK,
  CL,
  CM,
  CN,
  CO,
  CR,
  CU,
  CV,
  CW,
  CX,
  CY,
  CZ,
  DE,
  DJ,
  DK,
  DM,
  DO,
  DZ,
  EC,
  EE,
  EG,
  EH,
  ER,
  ES,
  ET,
  FI,
  FJ,
  FK,
  FM,
  FO,
  FR,
  GA,
  GB,
  GD,
  GE,
  GF,
  GG,
  GH,
  GI,
  GL,
  GM,
  GN,
  GP,
  GQ,
  GR,
  GT,
  GU,
  GW,
  GY,
  HK,
  HN,
  HR,
  HT,
  HU,
  ID,
  IE,
  IL,
  IM,
  IN,
  IO,
  IQ,
  IR,
  IS,
  IT,
  JE,
  JM,
  JO,
  JP,
  KE,
  KG,
  KH,
  KI,
  KM,
  KN,
  KP,
  KR,
  KW,
  KY,
  KZ,
  LA,
  LB,
  LC,
  LI,
  LK,
  LR,
  LS,
  LT,
  LU,
  LV,
  LY,
  MA,
  MC,
  MD,
  ME,
  MF,
  MG,
  MH,
  MK,
  ML,
  MM,
  MN,
  MO,
  MP,
  MQ,
  MR,
  MS,
  MT,
  MU,
  MV,
  MW,
  MX,
  MY,
  MZ,
  NA,
  NC,
  NE,
  NF,
  NG,
  NI,
  NL,
  NO,
  NP,
  NR,
  NU,
  NZ,
  OM,
  PA,
  PE,
  PF,
  PG,
  PH,
  PK,
  PL,
  PM,
  PR,
  PS,
  PT,
  PW,
  PY,
  QA,
  RE,
  RO,
  RS,
  RU,
  RW,
  SA,
  SB,
  SC,
  SD,
  SE,
  SG,
  SH,
  SI,
  SJ,
  SK,
  SL,
  SM,
  SN,
  SO,
  SR,
  SS,
  ST,
  SV,
  SX,
  SY,
  SZ,
  TA,
  TC,
  TD,
  TG,
  TH,
  TJ,
  TK,
  TL,
  TM,
  TN,
  TO,
  TR,
  TT,
  TV,
  TW,
  TZ,
  UA,
  UG,
  US,
  UY,
  UZ,
  VA,
  VC,
  VE,
  VG,
  VI,
  VN,
  VU,
  WF,
  WS,
  XK,
  YE,
  YT,
  ZA,
  ZM,
  ZW;

  const IsoCode();

  static IsoCode fromJson(String isoCodeStr) {
    final isoCode = isoCodeConversionMap[isoCodeStr];
    if (isoCode == null) {
      throw 'Iso code not found $isoCodeStr ';
    }
    return isoCode;
  }

  String toJson() => name;
}

const isoCodeConversionMap = {
  "AC": IsoCode.AC,
  "AD": IsoCode.AD,
  "AE": IsoCode.AE,
  "AF": IsoCode.AF,
  "AG": IsoCode.AG,
  "AI": IsoCode.AI,
  "AL": IsoCode.AL,
  "AM": IsoCode.AM,
  "AO": IsoCode.AO,
  "AR": IsoCode.AR,
  "AS": IsoCode.AS,
  "AT": IsoCode.AT,
  "AU": IsoCode.AU,
  "AW": IsoCode.AW,
  "AX": IsoCode.AX,
  "AZ": IsoCode.AZ,
  "BA": IsoCode.BA,
  "BB": IsoCode.BB,
  "BD": IsoCode.BD,
  "BE": IsoCode.BE,
  "BF": IsoCode.BF,
  "BG": IsoCode.BG,
  "BH": IsoCode.BH,
  "BI": IsoCode.BI,
  "BJ": IsoCode.BJ,
  "BL": IsoCode.BL,
  "BM": IsoCode.BM,
  "BN": IsoCode.BN,
  "BO": IsoCode.BO,
  "BQ": IsoCode.BQ,
  "BR": IsoCode.BR,
  "BS": IsoCode.BS,
  "BT": IsoCode.BT,
  "BW": IsoCode.BW,
  "BY": IsoCode.BY,
  "BZ": IsoCode.BZ,
  "CA": IsoCode.CA,
  "CC": IsoCode.CC,
  "CD": IsoCode.CD,
  "CF": IsoCode.CF,
  "CG": IsoCode.CG,
  "CH": IsoCode.CH,
  "CI": IsoCode.CI,
  "CK": IsoCode.CK,
  "CL": IsoCode.CL,
  "CM": IsoCode.CM,
  "CN": IsoCode.CN,
  "CO": IsoCode.CO,
  "CR": IsoCode.CR,
  "CU": IsoCode.CU,
  "CV": IsoCode.CV,
  "CW": IsoCode.CW,
  "CX": IsoCode.CX,
  "CY": IsoCode.CY,
  "CZ": IsoCode.CZ,
  "DE": IsoCode.DE,
  "DJ": IsoCode.DJ,
  "DK": IsoCode.DK,
  "DM": IsoCode.DM,
  "DO": IsoCode.DO,
  "DZ": IsoCode.DZ,
  "EC": IsoCode.EC,
  "EE": IsoCode.EE,
  "EG": IsoCode.EG,
  "EH": IsoCode.EH,
  "ER": IsoCode.ER,
  "ES": IsoCode.ES,
  "ET": IsoCode.ET,
  "FI": IsoCode.FI,
  "FJ": IsoCode.FJ,
  "FK": IsoCode.FK,
  "FM": IsoCode.FM,
  "FO": IsoCode.FO,
  "FR": IsoCode.FR,
  "GA": IsoCode.GA,
  "GB": IsoCode.GB,
  "GD": IsoCode.GD,
  "GE": IsoCode.GE,
  "GF": IsoCode.GF,
  "GG": IsoCode.GG,
  "GH": IsoCode.GH,
  "GI": IsoCode.GI,
  "GL": IsoCode.GL,
  "GM": IsoCode.GM,
  "GN": IsoCode.GN,
  "GP": IsoCode.GP,
  "GQ": IsoCode.GQ,
  "GR": IsoCode.GR,
  "GT": IsoCode.GT,
  "GU": IsoCode.GU,
  "GW": IsoCode.GW,
  "GY": IsoCode.GY,
  "HK": IsoCode.HK,
  "HN": IsoCode.HN,
  "HR": IsoCode.HR,
  "HT": IsoCode.HT,
  "HU": IsoCode.HU,
  "ID": IsoCode.ID,
  "IE": IsoCode.IE,
  "IL": IsoCode.IL,
  "IM": IsoCode.IM,
  "IN": IsoCode.IN,
  "IO": IsoCode.IO,
  "IQ": IsoCode.IQ,
  "IR": IsoCode.IR,
  "IS": IsoCode.IS,
  "IT": IsoCode.IT,
  "JE": IsoCode.JE,
  "JM": IsoCode.JM,
  "JO": IsoCode.JO,
  "JP": IsoCode.JP,
  "KE": IsoCode.KE,
  "KG": IsoCode.KG,
  "KH": IsoCode.KH,
  "KI": IsoCode.KI,
  "KM": IsoCode.KM,
  "KN": IsoCode.KN,
  "KP": IsoCode.KP,
  "KR": IsoCode.KR,
  "KW": IsoCode.KW,
  "KY": IsoCode.KY,
  "KZ": IsoCode.KZ,
  "LA": IsoCode.LA,
  "LB": IsoCode.LB,
  "LC": IsoCode.LC,
  "LI": IsoCode.LI,
  "LK": IsoCode.LK,
  "LR": IsoCode.LR,
  "LS": IsoCode.LS,
  "LT": IsoCode.LT,
  "LU": IsoCode.LU,
  "LV": IsoCode.LV,
  "LY": IsoCode.LY,
  "MA": IsoCode.MA,
  "MC": IsoCode.MC,
  "MD": IsoCode.MD,
  "ME": IsoCode.ME,
  "MF": IsoCode.MF,
  "MG": IsoCode.MG,
  "MH": IsoCode.MH,
  "MK": IsoCode.MK,
  "ML": IsoCode.ML,
  "MM": IsoCode.MM,
  "MN": IsoCode.MN,
  "MO": IsoCode.MO,
  "MP": IsoCode.MP,
  "MQ": IsoCode.MQ,
  "MR": IsoCode.MR,
  "MS": IsoCode.MS,
  "MT": IsoCode.MT,
  "MU": IsoCode.MU,
  "MV": IsoCode.MV,
  "MW": IsoCode.MW,
  "MX": IsoCode.MX,
  "MY": IsoCode.MY,
  "MZ": IsoCode.MZ,
  "NA": IsoCode.NA,
  "NC": IsoCode.NC,
  "NE": IsoCode.NE,
  "NF": IsoCode.NF,
  "NG": IsoCode.NG,
  "NI": IsoCode.NI,
  "NL": IsoCode.NL,
  "NO": IsoCode.NO,
  "NP": IsoCode.NP,
  "NR": IsoCode.NR,
  "NU": IsoCode.NU,
  "NZ": IsoCode.NZ,
  "OM": IsoCode.OM,
  "PA": IsoCode.PA,
  "PE": IsoCode.PE,
  "PF": IsoCode.PF,
  "PG": IsoCode.PG,
  "PH": IsoCode.PH,
  "PK": IsoCode.PK,
  "PL": IsoCode.PL,
  "PM": IsoCode.PM,
  "PR": IsoCode.PR,
  "PS": IsoCode.PS,
  "PT": IsoCode.PT,
  "PW": IsoCode.PW,
  "PY": IsoCode.PY,
  "QA": IsoCode.QA,
  "RE": IsoCode.RE,
  "RO": IsoCode.RO,
  "RS": IsoCode.RS,
  "RU": IsoCode.RU,
  "RW": IsoCode.RW,
  "SA": IsoCode.SA,
  "SB": IsoCode.SB,
  "SC": IsoCode.SC,
  "SD": IsoCode.SD,
  "SE": IsoCode.SE,
  "SG": IsoCode.SG,
  "SH": IsoCode.SH,
  "SI": IsoCode.SI,
  "SJ": IsoCode.SJ,
  "SK": IsoCode.SK,
  "SL": IsoCode.SL,
  "SM": IsoCode.SM,
  "SN": IsoCode.SN,
  "SO": IsoCode.SO,
  "SR": IsoCode.SR,
  "SS": IsoCode.SS,
  "ST": IsoCode.ST,
  "SV": IsoCode.SV,
  "SX": IsoCode.SX,
  "SY": IsoCode.SY,
  "SZ": IsoCode.SZ,
  "TA": IsoCode.TA,
  "TC": IsoCode.TC,
  "TD": IsoCode.TD,
  "TG": IsoCode.TG,
  "TH": IsoCode.TH,
  "TJ": IsoCode.TJ,
  "TK": IsoCode.TK,
  "TL": IsoCode.TL,
  "TM": IsoCode.TM,
  "TN": IsoCode.TN,
  "TO": IsoCode.TO,
  "TR": IsoCode.TR,
  "TT": IsoCode.TT,
  "TV": IsoCode.TV,
  "TW": IsoCode.TW,
  "TZ": IsoCode.TZ,
  "UA": IsoCode.UA,
  "UG": IsoCode.UG,
  "US": IsoCode.US,
  "UY": IsoCode.UY,
  "UZ": IsoCode.UZ,
  "VA": IsoCode.VA,
  "VC": IsoCode.VC,
  "VE": IsoCode.VE,
  "VG": IsoCode.VG,
  "VI": IsoCode.VI,
  "VN": IsoCode.VN,
  "VU": IsoCode.VU,
  "WF": IsoCode.WF,
  "WS": IsoCode.WS,
  "XK": IsoCode.XK,
  "YE": IsoCode.YE,
  "YT": IsoCode.YT,
  "ZA": IsoCode.ZA,
  "ZM": IsoCode.ZM,
  "ZW": IsoCode.ZW,
};
