# Logger

**Track, Analyze, and Manage Your Calls**

Logger is a user-friendly Android application built with Flutter that empowers you to view and export your call logs.

<a href="https://developer.android.com/">
<img src="https://img.shields.io/badge/Android-34A853.svg?style=for-the-badge&logo=Android&logoColor=white" alt="Android Badge" width="70" height="18"/>
</a>
<a href="https://developer.android.com/tools/releases/platforms">
<img src="https://img.shields.io/badge/min%20sdk%20version-21-red" alt="SDK Platform release notes " width="100" height="18"/>
</a>
<a href="https://f-droid.org/en/packages/com.logger.app/">
<img src="https://img.shields.io/f-droid/v/com.logger.app" alt="F-Droid Official Link" width="100" height="18"/>
</a>
</a>
<a href="https://apt.izzysoft.de/fdroid/index/apk/com.logger.app/">
<img src="https://img.shields.io/endpoint?url=https://apt.izzysoft.de/fdroid/api/v1/shield/com.logger.app" alt="IzzyOnDroid F-Droid Repository Link" width="100" height="18"/>
</a>

## 🧐 Key Features

- **Comprehensive Call Log Viewing:** Access and review your call history directly within the app.
- **Convenient Export Options:** Export your call logs in CSV or JSON formats for analysis or record-keeping.
- **Data Security:** Logger prioritizes your privacy by not storing any call log data on our servers.
- **Intuitive Interface:** Enjoy a user-friendly experience for effortless call log management.
- **Enhanced Filtering Options:** Filter call logs by phone number, date range, call type, and duration.
- **Customizable On-Device Call Log Analysis:** Perform light analysis including basic call statistics, call direction analysis, and call duration directly on your device.
- **Import Call Logs from Generated CSV Files:** Import call logs from CSV files generated by the app to restore your call history after a reset or switch to a new device.
- **Multi-Language Support**: Supports 15 different languages for internationalization, offering a seamless experience for users worldwide.

  <details>  
      <summary><emp>Supported Languages</emp></summary>  
        <ol type="1">
          <li>English (en)</li>
          <li>Hindi (hi)</li>
          <li>French (fr)</li>
          <li>Polish (pl)</li>
          <li>Portuguese (pt)</li>
          <li>Russian (ru)</li>
          <li>Spanish (es)</li>
          <li>Swedish (sv)</li>
          <li>German (de)</li>
          <li>Dutch (nl)</li>
          <li>Chinese (zh)</li>
          <li>Romanian (ro)</li>
          <li>Korean (ko)</li>
          <li>Finnish (fi)</li>
          <li>Japanese (ja)</li>
          <li>Turkish (tr)</li>
        </ol>
  </details>  


## 👏 **Benefits:**

- Gain insights from exported call logs in CSV or JSON format.
- Keep organized call records for future reference or analysis.
- Analyze call statistics and durations on your device for better decision-making.
- Easily export call logs for smooth data organization.
- Restore call history from generated CSV files after a reset or device switch.

## 🚀 Screenshots

![Screenshot-1](https://sanmeet007.github.io/public/logger/screenshot-16.png)
![Screenshot-2](https://sanmeet007.github.io/public/logger/screenshot-17.png)

## Built With

- Flutter: [https://flutter.dev/](https://flutter.dev/)
- Android: [https://www.android.com/](https://www.android.com/)

## 🍰 Contributing

We welcome contributions to improve Logger! Please follow the standard GitHub Flow by creating a branch, adding commits, and opening a pull request: [https://github.com/git-guides](https://github.com/git-guides)

## ❓ Questions and Feedback

For inquiries or feedback, feel free to reach out via:

[![LinkedInURL](https://img.shields.io/badge/linkedin-%230077B5.svg?&style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/in/sanmeet007/)
[![GmailURL](https://img.shields.io/badge/gmail-%23ca0b4a.svg?&style=for-the-badge&logo=gmail&logoColor=white)](mailto:ssanmeet007@gmail.com)

## ⬇️ Get Your Logger App

This section provides options to download the Logger app, both the official release and the build available on the F-Droid repository. Choose the method that best suits your needs.

<p>
<a href="https://github.com/Sanmeet007/logger/releases/tag/v3.2.7">
<img src="https://img.shields.io/badge/download%20now-%236a1ae3.svg?&style=for-the-badge&logoColor=white" alt="Download link button" width="160" height="40"/>
</a>
<a href="https://apt.izzysoft.de/fdroid/index/apk/com.logger.app/">
<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid2.png" alt="Download link button" width="160" height="40"/>
</a>
<a href="https://f-droid.org/packages/com.logger.app">
<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/a/a3/Get_it_on_F-Droid_%28material_design%29.svg/1199px-Get_it_on_F-Droid_%28material_design%29.svg.png" alt="Download link button" width="160" height="40"/>
</a>
<p align="center">
<hr>
Developed with ❤️ in India 🇮🇳
</p>
