import "../../iso_codes/iso_code.dart";
import "../models/phone_metadata.dart";

const metadataByIsoCode = {
  IsoCode.AC: PhoneMetadata(
    countryCode: r"247",
    isoCode: IsoCode.AC,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.AD: PhoneMetadata(
    countryCode: r"376",
    isoCode: IsoCode.AD,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.AE: PhoneMetadata(
    countryCode: r"971",
    isoCode: IsoCode.AE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AF: PhoneMetadata(
    countryCode: r"93",
    isoCode: IsoCode.AF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AG: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.AG,
    leadingDigits: r"268",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AI: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.AI,
    leadingDigits: r"264",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AL: PhoneMetadata(
    countryCode: r"355",
    isoCode: IsoCode.AL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AM: PhoneMetadata(
    countryCode: r"374",
    isoCode: IsoCode.AM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AO: PhoneMetadata(
    countryCode: r"244",
    isoCode: IsoCode.AO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.AR: PhoneMetadata(
    countryCode: r"54",
    isoCode: IsoCode.AR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AS: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.AS,
    leadingDigits: r"684",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AT: PhoneMetadata(
    countryCode: r"43",
    isoCode: IsoCode.AT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AU: PhoneMetadata(
    countryCode: r"61",
    isoCode: IsoCode.AU,
    leadingDigits: null,
    internationalPrefix: r"001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011",
    nationalPrefix: r"0",
    isMainCountryForDialCode: true,
  ),
  IsoCode.AW: PhoneMetadata(
    countryCode: r"297",
    isoCode: IsoCode.AW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.AX: PhoneMetadata(
    countryCode: r"358",
    isoCode: IsoCode.AX,
    leadingDigits: r"18",
    internationalPrefix: r"00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.AZ: PhoneMetadata(
    countryCode: r"994",
    isoCode: IsoCode.AZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BA: PhoneMetadata(
    countryCode: r"387",
    isoCode: IsoCode.BA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BB: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.BB,
    leadingDigits: r"246",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BD: PhoneMetadata(
    countryCode: r"880",
    isoCode: IsoCode.BD,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BE: PhoneMetadata(
    countryCode: r"32",
    isoCode: IsoCode.BE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BF: PhoneMetadata(
    countryCode: r"226",
    isoCode: IsoCode.BF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BG: PhoneMetadata(
    countryCode: r"359",
    isoCode: IsoCode.BG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BH: PhoneMetadata(
    countryCode: r"973",
    isoCode: IsoCode.BH,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BI: PhoneMetadata(
    countryCode: r"257",
    isoCode: IsoCode.BI,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BJ: PhoneMetadata(
    countryCode: r"229",
    isoCode: IsoCode.BJ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BL: PhoneMetadata(
    countryCode: r"590",
    isoCode: IsoCode.BL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BM: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.BM,
    leadingDigits: r"441",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BN: PhoneMetadata(
    countryCode: r"673",
    isoCode: IsoCode.BN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BO: PhoneMetadata(
    countryCode: r"591",
    isoCode: IsoCode.BO,
    leadingDigits: null,
    internationalPrefix: r"00(?:1\d)?",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BQ: PhoneMetadata(
    countryCode: r"599",
    isoCode: IsoCode.BQ,
    leadingDigits: r"[347]",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BR: PhoneMetadata(
    countryCode: r"55",
    isoCode: IsoCode.BR,
    leadingDigits: null,
    internationalPrefix: r"00(?:1[245]|2[1-35]|31|4[13]|[56]5|99)",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BS: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.BS,
    leadingDigits: r"242",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BT: PhoneMetadata(
    countryCode: r"975",
    isoCode: IsoCode.BT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BW: PhoneMetadata(
    countryCode: r"267",
    isoCode: IsoCode.BW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.BY: PhoneMetadata(
    countryCode: r"375",
    isoCode: IsoCode.BY,
    leadingDigits: null,
    internationalPrefix: r"810",
    nationalPrefix: r"8",
    isMainCountryForDialCode: false,
  ),
  IsoCode.BZ: PhoneMetadata(
    countryCode: r"501",
    isoCode: IsoCode.BZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CA: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.CA,
    leadingDigits: null,
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CC: PhoneMetadata(
    countryCode: r"61",
    isoCode: IsoCode.CC,
    leadingDigits: null,
    internationalPrefix: r"001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CD: PhoneMetadata(
    countryCode: r"243",
    isoCode: IsoCode.CD,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CF: PhoneMetadata(
    countryCode: r"236",
    isoCode: IsoCode.CF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CG: PhoneMetadata(
    countryCode: r"242",
    isoCode: IsoCode.CG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CH: PhoneMetadata(
    countryCode: r"41",
    isoCode: IsoCode.CH,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CI: PhoneMetadata(
    countryCode: r"225",
    isoCode: IsoCode.CI,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CK: PhoneMetadata(
    countryCode: r"682",
    isoCode: IsoCode.CK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CL: PhoneMetadata(
    countryCode: r"56",
    isoCode: IsoCode.CL,
    leadingDigits: null,
    internationalPrefix:
        r"(?:0|1(?:1[0-69]|2[02-5]|5[13-58]|69|7[0167]|8[018]))0",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CM: PhoneMetadata(
    countryCode: r"237",
    isoCode: IsoCode.CM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CN: PhoneMetadata(
    countryCode: r"86",
    isoCode: IsoCode.CN,
    leadingDigits: null,
    internationalPrefix: r"00|1(?:[12]\d|79)\d\d00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CO: PhoneMetadata(
    countryCode: r"57",
    isoCode: IsoCode.CO,
    leadingDigits: null,
    internationalPrefix: r"00(?:4(?:[14]4|56)|[579])",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CR: PhoneMetadata(
    countryCode: r"506",
    isoCode: IsoCode.CR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CU: PhoneMetadata(
    countryCode: r"53",
    isoCode: IsoCode.CU,
    leadingDigits: null,
    internationalPrefix: r"119",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CV: PhoneMetadata(
    countryCode: r"238",
    isoCode: IsoCode.CV,
    leadingDigits: null,
    internationalPrefix: r"0",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CW: PhoneMetadata(
    countryCode: r"599",
    isoCode: IsoCode.CW,
    leadingDigits: r"[69]",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: true,
  ),
  IsoCode.CX: PhoneMetadata(
    countryCode: r"61",
    isoCode: IsoCode.CX,
    leadingDigits: null,
    internationalPrefix: r"001[14-689]|14(?:1[14]|34|4[17]|[56]6|7[47]|88)0011",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.CY: PhoneMetadata(
    countryCode: r"357",
    isoCode: IsoCode.CY,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.CZ: PhoneMetadata(
    countryCode: r"420",
    isoCode: IsoCode.CZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.DE: PhoneMetadata(
    countryCode: r"49",
    isoCode: IsoCode.DE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.DJ: PhoneMetadata(
    countryCode: r"253",
    isoCode: IsoCode.DJ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.DK: PhoneMetadata(
    countryCode: r"45",
    isoCode: IsoCode.DK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.DM: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.DM,
    leadingDigits: r"767",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.DO: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.DO,
    leadingDigits: r"8001|8[024]9",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.DZ: PhoneMetadata(
    countryCode: r"213",
    isoCode: IsoCode.DZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.EC: PhoneMetadata(
    countryCode: r"593",
    isoCode: IsoCode.EC,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.EE: PhoneMetadata(
    countryCode: r"372",
    isoCode: IsoCode.EE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.EG: PhoneMetadata(
    countryCode: r"20",
    isoCode: IsoCode.EG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.EH: PhoneMetadata(
    countryCode: r"212",
    isoCode: IsoCode.EH,
    leadingDigits: r"528[89]",
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ER: PhoneMetadata(
    countryCode: r"291",
    isoCode: IsoCode.ER,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ES: PhoneMetadata(
    countryCode: r"34",
    isoCode: IsoCode.ES,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.ET: PhoneMetadata(
    countryCode: r"251",
    isoCode: IsoCode.ET,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.FI: PhoneMetadata(
    countryCode: r"358",
    isoCode: IsoCode.FI,
    leadingDigits: r"1[03-79]|[2-9]",
    internationalPrefix: r"00|99(?:[01469]|5(?:[14]1|3[23]|5[59]|77|88|9[09]))",
    nationalPrefix: r"0",
    isMainCountryForDialCode: true,
  ),
  IsoCode.FJ: PhoneMetadata(
    countryCode: r"679",
    isoCode: IsoCode.FJ,
    leadingDigits: null,
    internationalPrefix: r"0(?:0|52)",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.FK: PhoneMetadata(
    countryCode: r"500",
    isoCode: IsoCode.FK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.FM: PhoneMetadata(
    countryCode: r"691",
    isoCode: IsoCode.FM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.FO: PhoneMetadata(
    countryCode: r"298",
    isoCode: IsoCode.FO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.FR: PhoneMetadata(
    countryCode: r"33",
    isoCode: IsoCode.FR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GA: PhoneMetadata(
    countryCode: r"241",
    isoCode: IsoCode.GA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GB: PhoneMetadata(
    countryCode: r"44",
    isoCode: IsoCode.GB,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: true,
  ),
  IsoCode.GD: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.GD,
    leadingDigits: r"473",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GE: PhoneMetadata(
    countryCode: r"995",
    isoCode: IsoCode.GE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GF: PhoneMetadata(
    countryCode: r"594",
    isoCode: IsoCode.GF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GG: PhoneMetadata(
    countryCode: r"44",
    isoCode: IsoCode.GG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GH: PhoneMetadata(
    countryCode: r"233",
    isoCode: IsoCode.GH,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GI: PhoneMetadata(
    countryCode: r"350",
    isoCode: IsoCode.GI,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GL: PhoneMetadata(
    countryCode: r"299",
    isoCode: IsoCode.GL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GM: PhoneMetadata(
    countryCode: r"220",
    isoCode: IsoCode.GM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GN: PhoneMetadata(
    countryCode: r"224",
    isoCode: IsoCode.GN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GP: PhoneMetadata(
    countryCode: r"590",
    isoCode: IsoCode.GP,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: true,
  ),
  IsoCode.GQ: PhoneMetadata(
    countryCode: r"240",
    isoCode: IsoCode.GQ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GR: PhoneMetadata(
    countryCode: r"30",
    isoCode: IsoCode.GR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GT: PhoneMetadata(
    countryCode: r"502",
    isoCode: IsoCode.GT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GU: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.GU,
    leadingDigits: r"671",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.GW: PhoneMetadata(
    countryCode: r"245",
    isoCode: IsoCode.GW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.GY: PhoneMetadata(
    countryCode: r"592",
    isoCode: IsoCode.GY,
    leadingDigits: null,
    internationalPrefix: r"001",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.HK: PhoneMetadata(
    countryCode: r"852",
    isoCode: IsoCode.HK,
    leadingDigits: null,
    internationalPrefix: r"00(?:30|5[09]|[126-9]?)",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.HN: PhoneMetadata(
    countryCode: r"504",
    isoCode: IsoCode.HN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.HR: PhoneMetadata(
    countryCode: r"385",
    isoCode: IsoCode.HR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.HT: PhoneMetadata(
    countryCode: r"509",
    isoCode: IsoCode.HT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.HU: PhoneMetadata(
    countryCode: r"36",
    isoCode: IsoCode.HU,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"06",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ID: PhoneMetadata(
    countryCode: r"62",
    isoCode: IsoCode.ID,
    leadingDigits: null,
    internationalPrefix: r"00[89]",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IE: PhoneMetadata(
    countryCode: r"353",
    isoCode: IsoCode.IE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IL: PhoneMetadata(
    countryCode: r"972",
    isoCode: IsoCode.IL,
    leadingDigits: null,
    internationalPrefix: r"0(?:0|1[2-9])",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IM: PhoneMetadata(
    countryCode: r"44",
    isoCode: IsoCode.IM,
    leadingDigits: r"74576|(?:16|7[56])24",
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IN: PhoneMetadata(
    countryCode: r"91",
    isoCode: IsoCode.IN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IO: PhoneMetadata(
    countryCode: r"246",
    isoCode: IsoCode.IO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.IQ: PhoneMetadata(
    countryCode: r"964",
    isoCode: IsoCode.IQ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IR: PhoneMetadata(
    countryCode: r"98",
    isoCode: IsoCode.IR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.IS: PhoneMetadata(
    countryCode: r"354",
    isoCode: IsoCode.IS,
    leadingDigits: null,
    internationalPrefix: r"00|1(?:0(?:01|[12]0)|100)",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.IT: PhoneMetadata(
    countryCode: r"39",
    isoCode: IsoCode.IT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: true,
  ),
  IsoCode.JE: PhoneMetadata(
    countryCode: r"44",
    isoCode: IsoCode.JE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.JM: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.JM,
    leadingDigits: r"658|876",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.JO: PhoneMetadata(
    countryCode: r"962",
    isoCode: IsoCode.JO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.JP: PhoneMetadata(
    countryCode: r"81",
    isoCode: IsoCode.JP,
    leadingDigits: null,
    internationalPrefix: r"010",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KE: PhoneMetadata(
    countryCode: r"254",
    isoCode: IsoCode.KE,
    leadingDigits: null,
    internationalPrefix: r"000",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KG: PhoneMetadata(
    countryCode: r"996",
    isoCode: IsoCode.KG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KH: PhoneMetadata(
    countryCode: r"855",
    isoCode: IsoCode.KH,
    leadingDigits: null,
    internationalPrefix: r"00[14-9]",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KI: PhoneMetadata(
    countryCode: r"686",
    isoCode: IsoCode.KI,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KM: PhoneMetadata(
    countryCode: r"269",
    isoCode: IsoCode.KM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.KN: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.KN,
    leadingDigits: r"869",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KP: PhoneMetadata(
    countryCode: r"850",
    isoCode: IsoCode.KP,
    leadingDigits: null,
    internationalPrefix: r"00|99",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KR: PhoneMetadata(
    countryCode: r"82",
    isoCode: IsoCode.KR,
    leadingDigits: null,
    internationalPrefix: r"00(?:[125689]|3(?:[46]5|91)|7(?:00|27|3|55|6[126]))",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KW: PhoneMetadata(
    countryCode: r"965",
    isoCode: IsoCode.KW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.KY: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.KY,
    leadingDigits: r"345",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.KZ: PhoneMetadata(
    countryCode: r"7",
    isoCode: IsoCode.KZ,
    leadingDigits: r"33|7",
    internationalPrefix: r"810",
    nationalPrefix: r"8",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LA: PhoneMetadata(
    countryCode: r"856",
    isoCode: IsoCode.LA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LB: PhoneMetadata(
    countryCode: r"961",
    isoCode: IsoCode.LB,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LC: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.LC,
    leadingDigits: r"758",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LI: PhoneMetadata(
    countryCode: r"423",
    isoCode: IsoCode.LI,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LK: PhoneMetadata(
    countryCode: r"94",
    isoCode: IsoCode.LK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LR: PhoneMetadata(
    countryCode: r"231",
    isoCode: IsoCode.LR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LS: PhoneMetadata(
    countryCode: r"266",
    isoCode: IsoCode.LS,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.LT: PhoneMetadata(
    countryCode: r"370",
    isoCode: IsoCode.LT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.LU: PhoneMetadata(
    countryCode: r"352",
    isoCode: IsoCode.LU,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.LV: PhoneMetadata(
    countryCode: r"371",
    isoCode: IsoCode.LV,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.LY: PhoneMetadata(
    countryCode: r"218",
    isoCode: IsoCode.LY,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MA: PhoneMetadata(
    countryCode: r"212",
    isoCode: IsoCode.MA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: true,
  ),
  IsoCode.MC: PhoneMetadata(
    countryCode: r"377",
    isoCode: IsoCode.MC,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MD: PhoneMetadata(
    countryCode: r"373",
    isoCode: IsoCode.MD,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ME: PhoneMetadata(
    countryCode: r"382",
    isoCode: IsoCode.ME,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MF: PhoneMetadata(
    countryCode: r"590",
    isoCode: IsoCode.MF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MG: PhoneMetadata(
    countryCode: r"261",
    isoCode: IsoCode.MG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MH: PhoneMetadata(
    countryCode: r"692",
    isoCode: IsoCode.MH,
    leadingDigits: null,
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MK: PhoneMetadata(
    countryCode: r"389",
    isoCode: IsoCode.MK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ML: PhoneMetadata(
    countryCode: r"223",
    isoCode: IsoCode.ML,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MM: PhoneMetadata(
    countryCode: r"95",
    isoCode: IsoCode.MM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MN: PhoneMetadata(
    countryCode: r"976",
    isoCode: IsoCode.MN,
    leadingDigits: null,
    internationalPrefix: r"001",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MO: PhoneMetadata(
    countryCode: r"853",
    isoCode: IsoCode.MO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MP: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.MP,
    leadingDigits: r"670",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MQ: PhoneMetadata(
    countryCode: r"596",
    isoCode: IsoCode.MQ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MR: PhoneMetadata(
    countryCode: r"222",
    isoCode: IsoCode.MR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MS: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.MS,
    leadingDigits: r"664",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MT: PhoneMetadata(
    countryCode: r"356",
    isoCode: IsoCode.MT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MU: PhoneMetadata(
    countryCode: r"230",
    isoCode: IsoCode.MU,
    leadingDigits: null,
    internationalPrefix: r"0(?:0|[24-7]0|3[03])",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MV: PhoneMetadata(
    countryCode: r"960",
    isoCode: IsoCode.MV,
    leadingDigits: null,
    internationalPrefix: r"0(?:0|19)",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MW: PhoneMetadata(
    countryCode: r"265",
    isoCode: IsoCode.MW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MX: PhoneMetadata(
    countryCode: r"52",
    isoCode: IsoCode.MX,
    leadingDigits: null,
    internationalPrefix: r"0[09]",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.MY: PhoneMetadata(
    countryCode: r"60",
    isoCode: IsoCode.MY,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.MZ: PhoneMetadata(
    countryCode: r"258",
    isoCode: IsoCode.MZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NA: PhoneMetadata(
    countryCode: r"264",
    isoCode: IsoCode.NA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.NC: PhoneMetadata(
    countryCode: r"687",
    isoCode: IsoCode.NC,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NE: PhoneMetadata(
    countryCode: r"227",
    isoCode: IsoCode.NE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NF: PhoneMetadata(
    countryCode: r"672",
    isoCode: IsoCode.NF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NG: PhoneMetadata(
    countryCode: r"234",
    isoCode: IsoCode.NG,
    leadingDigits: null,
    internationalPrefix: r"009",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.NI: PhoneMetadata(
    countryCode: r"505",
    isoCode: IsoCode.NI,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NL: PhoneMetadata(
    countryCode: r"31",
    isoCode: IsoCode.NL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.NO: PhoneMetadata(
    countryCode: r"47",
    isoCode: IsoCode.NO,
    leadingDigits: r"[02-689]|7[0-8]",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: true,
  ),
  IsoCode.NP: PhoneMetadata(
    countryCode: r"977",
    isoCode: IsoCode.NP,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.NR: PhoneMetadata(
    countryCode: r"674",
    isoCode: IsoCode.NR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NU: PhoneMetadata(
    countryCode: r"683",
    isoCode: IsoCode.NU,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.NZ: PhoneMetadata(
    countryCode: r"64",
    isoCode: IsoCode.NZ,
    leadingDigits: null,
    internationalPrefix: r"0(?:0|161)",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.OM: PhoneMetadata(
    countryCode: r"968",
    isoCode: IsoCode.OM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PA: PhoneMetadata(
    countryCode: r"507",
    isoCode: IsoCode.PA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PE: PhoneMetadata(
    countryCode: r"51",
    isoCode: IsoCode.PE,
    leadingDigits: null,
    internationalPrefix: r"00|19(?:1[124]|77|90)00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.PF: PhoneMetadata(
    countryCode: r"689",
    isoCode: IsoCode.PF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PG: PhoneMetadata(
    countryCode: r"675",
    isoCode: IsoCode.PG,
    leadingDigits: null,
    internationalPrefix: r"00|140[1-3]",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PH: PhoneMetadata(
    countryCode: r"63",
    isoCode: IsoCode.PH,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.PK: PhoneMetadata(
    countryCode: r"92",
    isoCode: IsoCode.PK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.PL: PhoneMetadata(
    countryCode: r"48",
    isoCode: IsoCode.PL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PM: PhoneMetadata(
    countryCode: r"508",
    isoCode: IsoCode.PM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.PR: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.PR,
    leadingDigits: r"787|939",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.PS: PhoneMetadata(
    countryCode: r"970",
    isoCode: IsoCode.PS,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.PT: PhoneMetadata(
    countryCode: r"351",
    isoCode: IsoCode.PT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PW: PhoneMetadata(
    countryCode: r"680",
    isoCode: IsoCode.PW,
    leadingDigits: null,
    internationalPrefix: r"01[12]",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.PY: PhoneMetadata(
    countryCode: r"595",
    isoCode: IsoCode.PY,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.QA: PhoneMetadata(
    countryCode: r"974",
    isoCode: IsoCode.QA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.RE: PhoneMetadata(
    countryCode: r"262",
    isoCode: IsoCode.RE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: true,
  ),
  IsoCode.RO: PhoneMetadata(
    countryCode: r"40",
    isoCode: IsoCode.RO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.RS: PhoneMetadata(
    countryCode: r"381",
    isoCode: IsoCode.RS,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.RU: PhoneMetadata(
    countryCode: r"7",
    isoCode: IsoCode.RU,
    leadingDigits: r"3[04-689]|[489]",
    internationalPrefix: r"810",
    nationalPrefix: r"8",
    isMainCountryForDialCode: true,
  ),
  IsoCode.RW: PhoneMetadata(
    countryCode: r"250",
    isoCode: IsoCode.RW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SA: PhoneMetadata(
    countryCode: r"966",
    isoCode: IsoCode.SA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SB: PhoneMetadata(
    countryCode: r"677",
    isoCode: IsoCode.SB,
    leadingDigits: null,
    internationalPrefix: r"0[01]",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SC: PhoneMetadata(
    countryCode: r"248",
    isoCode: IsoCode.SC,
    leadingDigits: null,
    internationalPrefix: r"010|0[0-2]",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SD: PhoneMetadata(
    countryCode: r"249",
    isoCode: IsoCode.SD,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SE: PhoneMetadata(
    countryCode: r"46",
    isoCode: IsoCode.SE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SG: PhoneMetadata(
    countryCode: r"65",
    isoCode: IsoCode.SG,
    leadingDigits: null,
    internationalPrefix: r"0[0-3]\d",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SH: PhoneMetadata(
    countryCode: r"290",
    isoCode: IsoCode.SH,
    leadingDigits: r"[256]",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: true,
  ),
  IsoCode.SI: PhoneMetadata(
    countryCode: r"386",
    isoCode: IsoCode.SI,
    leadingDigits: null,
    internationalPrefix: r"00|10(?:22|66|88|99)",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SJ: PhoneMetadata(
    countryCode: r"47",
    isoCode: IsoCode.SJ,
    leadingDigits: r"79",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SK: PhoneMetadata(
    countryCode: r"421",
    isoCode: IsoCode.SK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SL: PhoneMetadata(
    countryCode: r"232",
    isoCode: IsoCode.SL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SM: PhoneMetadata(
    countryCode: r"378",
    isoCode: IsoCode.SM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SN: PhoneMetadata(
    countryCode: r"221",
    isoCode: IsoCode.SN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SO: PhoneMetadata(
    countryCode: r"252",
    isoCode: IsoCode.SO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SR: PhoneMetadata(
    countryCode: r"597",
    isoCode: IsoCode.SR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SS: PhoneMetadata(
    countryCode: r"211",
    isoCode: IsoCode.SS,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ST: PhoneMetadata(
    countryCode: r"239",
    isoCode: IsoCode.ST,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SV: PhoneMetadata(
    countryCode: r"503",
    isoCode: IsoCode.SV,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.SX: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.SX,
    leadingDigits: r"721",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SY: PhoneMetadata(
    countryCode: r"963",
    isoCode: IsoCode.SY,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.SZ: PhoneMetadata(
    countryCode: r"268",
    isoCode: IsoCode.SZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TA: PhoneMetadata(
    countryCode: r"290",
    isoCode: IsoCode.TA,
    leadingDigits: r"8",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TC: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.TC,
    leadingDigits: r"649",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.TD: PhoneMetadata(
    countryCode: r"235",
    isoCode: IsoCode.TD,
    leadingDigits: null,
    internationalPrefix: r"00|16",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TG: PhoneMetadata(
    countryCode: r"228",
    isoCode: IsoCode.TG,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TH: PhoneMetadata(
    countryCode: r"66",
    isoCode: IsoCode.TH,
    leadingDigits: null,
    internationalPrefix: r"00[1-9]",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.TJ: PhoneMetadata(
    countryCode: r"992",
    isoCode: IsoCode.TJ,
    leadingDigits: null,
    internationalPrefix: r"810",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TK: PhoneMetadata(
    countryCode: r"690",
    isoCode: IsoCode.TK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TL: PhoneMetadata(
    countryCode: r"670",
    isoCode: IsoCode.TL,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TM: PhoneMetadata(
    countryCode: r"993",
    isoCode: IsoCode.TM,
    leadingDigits: null,
    internationalPrefix: r"810",
    nationalPrefix: r"8",
    isMainCountryForDialCode: false,
  ),
  IsoCode.TN: PhoneMetadata(
    countryCode: r"216",
    isoCode: IsoCode.TN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TO: PhoneMetadata(
    countryCode: r"676",
    isoCode: IsoCode.TO,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TR: PhoneMetadata(
    countryCode: r"90",
    isoCode: IsoCode.TR,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.TT: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.TT,
    leadingDigits: r"868",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.TV: PhoneMetadata(
    countryCode: r"688",
    isoCode: IsoCode.TV,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.TW: PhoneMetadata(
    countryCode: r"886",
    isoCode: IsoCode.TW,
    leadingDigits: null,
    internationalPrefix: r"0(?:0[25-79]|19)",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.TZ: PhoneMetadata(
    countryCode: r"255",
    isoCode: IsoCode.TZ,
    leadingDigits: null,
    internationalPrefix: r"00[056]",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.UA: PhoneMetadata(
    countryCode: r"380",
    isoCode: IsoCode.UA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.UG: PhoneMetadata(
    countryCode: r"256",
    isoCode: IsoCode.UG,
    leadingDigits: null,
    internationalPrefix: r"00[057]",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.US: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.US,
    leadingDigits: null,
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: true,
  ),
  IsoCode.UY: PhoneMetadata(
    countryCode: r"598",
    isoCode: IsoCode.UY,
    leadingDigits: null,
    internationalPrefix: r"0(?:0|1[3-9]\d)",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.UZ: PhoneMetadata(
    countryCode: r"998",
    isoCode: IsoCode.UZ,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.VA: PhoneMetadata(
    countryCode: r"39",
    isoCode: IsoCode.VA,
    leadingDigits: r"06698",
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.VC: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.VC,
    leadingDigits: r"784",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.VE: PhoneMetadata(
    countryCode: r"58",
    isoCode: IsoCode.VE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.VG: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.VG,
    leadingDigits: r"284",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.VI: PhoneMetadata(
    countryCode: r"1",
    isoCode: IsoCode.VI,
    leadingDigits: r"340",
    internationalPrefix: r"011",
    nationalPrefix: r"1",
    isMainCountryForDialCode: false,
  ),
  IsoCode.VN: PhoneMetadata(
    countryCode: r"84",
    isoCode: IsoCode.VN,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.VU: PhoneMetadata(
    countryCode: r"678",
    isoCode: IsoCode.VU,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.WF: PhoneMetadata(
    countryCode: r"681",
    isoCode: IsoCode.WF,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.WS: PhoneMetadata(
    countryCode: r"685",
    isoCode: IsoCode.WS,
    leadingDigits: null,
    internationalPrefix: r"0",
    nationalPrefix: null,
    isMainCountryForDialCode: false,
  ),
  IsoCode.XK: PhoneMetadata(
    countryCode: r"383",
    isoCode: IsoCode.XK,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.YE: PhoneMetadata(
    countryCode: r"967",
    isoCode: IsoCode.YE,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.YT: PhoneMetadata(
    countryCode: r"262",
    isoCode: IsoCode.YT,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ZA: PhoneMetadata(
    countryCode: r"27",
    isoCode: IsoCode.ZA,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ZM: PhoneMetadata(
    countryCode: r"260",
    isoCode: IsoCode.ZM,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
  IsoCode.ZW: PhoneMetadata(
    countryCode: r"263",
    isoCode: IsoCode.ZW,
    leadingDigits: null,
    internationalPrefix: r"00",
    nationalPrefix: r"0",
    isMainCountryForDialCode: false,
  ),
};
