<p align="center">
  <img src="https://user-images.githubusercontent.com/51419598/161439601-fc228a0d-d09d-4dbb-b5a3-ebc5dbcf9f46.png">
</p>

<h6 align="center"><samp>#flutter, #package, #android, #saf, #storage</samp></h6>
<samp><h1 align="center">Shared Storage</h1></samp>

<h6 align="center">
    <samp>
      Access Android <kbd>Storage Access Framework</kbd>, <kbd>Media Store</kbd> and <kbd>Environment</kbd> APIs through your Flutter Apps
    </samp>
</h6>

<p align="center">
  <a href="https://pub.dev/packages/shared_storage"><img src="https://img.shields.io/pub/v/shared_storage.svg?style=for-the-badge&color=22272E&showLabel=false&labelColor=15191f&logo=dart&logoColor=blue"></a>
  <img src="https://img.shields.io/badge/Kotlin-22272E?&style=for-the-badge&logo=kotlin&logoColor=9966FF">
  <img src="https://img.shields.io/badge/Dart-22272E?style=for-the-badge&logo=dart&logoColor=2BB7F6">
  <img src="https://img.shields.io/badge/Flutter-22272E?style=for-the-badge&logo=flutter&logoColor=66B1F1">
</p>

<h4 align="center"><samp><a href="https://pub.dev/packages/shared_storage">Install It</a></samp></h4>

## Documentation

See the website for [documentation](https://alexrintt.github.io/shared-storage).

All documentation is also available under `/docs` to each released version which is the data source of the website.

You can contribute to the documentation by just editing these files.

To check all ways you can contribute to this package see [Contributing/Ways to contribute](https://alexrintt.github.io/shared-storage/Contributing/Ways%20to%20contribute/).

**To start developing, use `release` branch as base**, `master` is used for experimentation only and is likely to be not working.

All other branches are derivated from issues, new features or bug fixes.

## Supporters

- [aplicatii-romanesti](https://www.bibliotecaortodoxa.ro/) who bought me a whole month of caffeine!

## Contributors

- [Tamerlanchiques](https://github.com/Tamerlanchiques) thanks a lot for the thoughtful bug reports.
- [limshengli](https://github.com/limshengli) updated Android Gradle build version and Kotlin version on pull https://github.com/alexrintt/shared-storage/pull/115, thanks!
- [honjow](https://github.com/honjow) contributed by [implementing `openDocument` Android API #110](https://github.com/alexrintt/shared-storage/pull/110) to pick single or multiple file URIs. Really helpful, thanks!
- [clragon](https://github.com/clragon) submitted a severe [bug report #107](https://github.com/alexrintt/shared-storage/issues/107) and opened [discussions around package architecture #108](https://github.com/alexrintt/shared-storage/discussions/108), thanks!
- [jfaltis](https://github.com/jfaltis) fixed [a memory leak #86](https://github.com/alexrintt/shared-storage/pull/86) and implemented an API to [override existing files #85](https://github.com/alexrintt/shared-storage/pull/85), thanks for your contribution!
- [EternityForest](https://github.com/EternityForest) did [report a severe crash #50](https://github.com/alexrintt/shared-storage/issues/50) when the column ID was not provided and [implemented a new feature to list all subfolders #59](https://github.com/alexrintt/shared-storage/pull/59), thanks man!
- Thanks [dhaval-k-simformsolutions](https://github.com/dhaval-k-simformsolutions) for taking time to submit [bug reports](https://github.com/alexrintt/shared-storage/issues?q=is%3Aissue+author%3Adhaval-k-simformsolutions) related to duplicated file entries!
- [dangilbert](https://github.com/dangilbert) pointed and [fixed a bug #14](https://github.com/alexrintt/shared-storage/pull/14) when the user doesn't select a folder, thanks man!
- A huge thanks to [aplicatii-romanesti](https://www.bibliotecaortodoxa.ro/) for taking time to submit [device specific issues](https://github.com/alexrintt/shared-storage/issues?q=author%3Aaplicatii-romanesti)!
- I would thanks [ankitparmar007](https://github.com/ankitparmar007) for [discussing and requesting create file related APIs #20](https://github.com/alexrintt/shared-storage/issues/10)!
