/**
 * Copyright 2016 Lloyd Torres
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.lloydtorres.stately.dto;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Locale;

/**
 * Created by Lloyd on 2016-04-10.
 * Represents one trend dataset.
 */
public class Dataset implements Comparable<Dataset>, Parcelable {
    @SuppressWarnings("unused")
    public static final Parcelable.Creator<Dataset> CREATOR = new Parcelable.Creator<Dataset>() {
        @Override
        public Dataset createFromParcel(Parcel in) {
            return new Dataset(in);
        }

        @Override
        public Dataset[] newArray(int size) {
            return new Dataset[size];
        }
    };
    public String name;
    public int id;
    public boolean selected;

    public Dataset() {
        super();
    }

    protected Dataset(Parcel in) {
        name = in.readString();
        id = in.readInt();
        selected = in.readByte() != 0x00;
    }

    @Override
    public int compareTo(Dataset another) {
        return name.toLowerCase(Locale.US).compareTo(another.name.toLowerCase(Locale.US));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(name);
        dest.writeInt(id);
        dest.writeByte((byte) (selected ? 0x01 : 0x00));
    }
}
