/**
 * Copyright 2016 Lloyd Torres
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.lloydtorres.stately.core;

import android.content.Context;

import androidx.multidex.MultiDex;

import com.lloydtorres.stately.push.TrixHelper;
import com.orm.SugarApp;

/**
 * Created by Lloyd on 2016-01-29.
 * This class is used for app-wide changes.
 */
public class StatelyApp extends SugarApp {

    @Override
    public void onCreate() {
        super.onCreate();

        // notification channels
        TrixHelper.initNotificationChannels(this);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }
}
