/*
 * La Et Le — French Gender Classification Trainer
 *
 * Copyright (C) 2025 Seweryn Polec <sewerynpol@protonmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

package com.languageapp.laetle

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.Button
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import androidx.activity.enableEdgeToEdge
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat

class MainActivity : AppCompatActivity() {

    private val progressPrefs by lazy { getSharedPreferences("progress", MODE_PRIVATE) }
    private val gson = Gson()
    private val timeProvider: TimeProvider by lazy { RealTimeProvider() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        enableEdgeToEdge()

        setContentView(R.layout.activity_main)

        val rootView = findViewById<android.view.View>(android.R.id.content)
        ViewCompat.setOnApplyWindowInsetsListener(rootView) { v, insets ->
            val systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars())
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom)
            insets
        }

        TutorialManager.showDialogIfFirstRun(this)

        val btnStart = findViewById<Button>(R.id.btnStart)
        val btnSettings = findViewById<Button>(R.id.btnSettings)
        val btnStats = findViewById<Button>(R.id.btnStats)

        btnStart.setOnClickListener {
            val reviewDeckJson = progressPrefs.getString(PREF_REVIEW_DECK, "[]")
            val reviewDeck = gson.fromJson<MutableList<ReviewItem>>(
                reviewDeckJson,
                object : TypeToken<MutableList<ReviewItem>>() {}.type
            )

            val today = timeProvider.getCurrentTimeMillis()

            val cardsToReviewToday = reviewDeck.count { it.nextReviewDate <= today }

            val nextActivity = if (cardsToReviewToday > 0) {
                SessionActivity::class.java
            } else {
                StartActivity::class.java
            }
            startActivity(Intent(this, nextActivity))
        }

        btnSettings.setOnClickListener {
            val intent = Intent(this, SettingsActivity::class.java)
            startActivity(intent)
        }

        btnStats.setOnClickListener {
            val intent = Intent(this, StatisticsActivity::class.java)
            startActivity(intent)
        }
    }
}