import org.jetbrains.kotlin.gradle.dsl.JvmTarget

// build.gradle.kts

plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    alias(libs.plugins.kotlin.compose)
}

android {
    namespace = "com.languageapp.laetle"
    compileSdk = 36

    defaultConfig {
        applicationId = "com.languageapp.laetle"
        minSdk = 24
        targetSdk = 36
        versionCode = 8
        versionName = "7.0.1"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }

    compileOptions {
        isCoreLibraryDesugaringEnabled = true

        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    kotlin {
        compilerOptions {
            jvmTarget.set(JvmTarget.JVM_11)
        }
    }

    buildFeatures {
        compose = true
    }
    packaging {
        resources {
            excludes += setOf(
                "META-INF/LICENSE.md",
                "META-INF/LICENSE-notice.md",
                "META-INF/LICENSE.txt",
                "META-INF/NOTICE.txt"
            )
        }
    }

    configurations.all {
        exclude(group = "org.junit.jupiter")
        exclude(group = "org.junit.platform")
    }

}

dependencies {

    // ✅ AndroidX Test libraries (aligned with Compose’s 1.5.x versions)
    androidTestImplementation("androidx.test:core:1.5.0")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test:runner:1.5.2")
    androidTestImplementation("androidx.test:rules:1.5.0")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
    implementation("androidx.activity:activity-ktx:1.12.2")
    implementation("androidx.core:core-ktx:1.13.0")

    // ✅ Mockk for Android
    androidTestImplementation("io.mockk:mockk-android:1.13.11")

    // ✅ Gson
    implementation("com.google.code.gson:gson:2.11.0")

    // ✅ ActivityScenario / Fragment testing
    debugImplementation("androidx.fragment:fragment-testing:1.8.2")

    // ✅ Compose UI
    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.androidx.compose.ui)
    implementation(libs.androidx.compose.ui.graphics)
    implementation(libs.androidx.compose.ui.tooling.preview)
    implementation(libs.androidx.compose.material3)
    implementation(libs.androidx.activity.compose)

    // ✅ View UI
    implementation(libs.androidx.appcompat)
    implementation(libs.google.material)

    // ✅ Core + Lifecycle
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.lifecycle.runtime.ktx)

    // ✅ Compose testing (kept from BOM)
    androidTestImplementation(platform(libs.androidx.compose.bom))
    androidTestImplementation(libs.androidx.compose.ui.test.junit4)
    debugImplementation(libs.androidx.compose.ui.tooling)
    debugImplementation(libs.androidx.compose.ui.test.manifest)

    // ✅ JVM tests
    testImplementation("junit:junit:4.13.2")
    androidTestImplementation("androidx.test.espresso:espresso-intents:3.5.1") // <-- ADD THIS

    testImplementation(libs.junit)

    // ✅ Desugaring
    coreLibraryDesugaring(libs.desugar.jdk.libs)
}
