## About the Project

**La Et Le — French Gender Classification Trainer** is an Android app designed to help learners master the gender of French nouns (“le” or “la”).  
It uses a **Spaced Repetition System (SRS)** and a frequency-ranked list of thousands of nouns to help you memorize efficiently.  
Each card includes example sentences, progress tracking, wiktionary linking and most also have an Audio-sample of the word.

<div align="center">
  <img src="app/src/main/res/drawable/logo_transparent.png" alt="La Et Le Logo" width="300" />
</div>

## Screenshots

| Dark Mode                                               | Light Mode                                              | Minimalistic                                                               |
| ------------------------------------------------------- | ------------------------------------------------------- | -------------------------------------------------------------------------- |
| ![Black Screen](./docs/images/Example_Black_screen.png) | ![White Screen](./docs/images/Example_White_screen.png) | ![Minimalistic Black](./docs/images/Example_Black_minimalistic_screen.png) |

| Session                                      | Statistics                                    | Reminder Settings                                       |
| -------------------------------------------- | --------------------------------------------- | ------------------------------------------------------- |
| ![Session](./docs/images/Session_screen.png) | ![Stats](./docs/images/Statistics_screen.png) | ![Reminder](./docs/images/Reminder_Settings_screen.png) |

| App Settings                                                                                                      |
| ----------------------------------------------------------------------------------------------------------------- |
| <div align="center"><img src="./docs/images/Settings_screen.png" alt="Settings" width="220" height="450" /></div> |

## Core Features

* **Gender Training:** Guess the gender of French nouns presented in a clean, minimalist interface.
* **Points System:** Earn points for answering correctly via a system of points and answer streaks.
* **Spaced Repetition System (SRS):** Once a word is "mastered" in a learning session, it enters a review deck. The app schedules the next review time based on your performance, showing you the word again when you are most likely to forget it. Intervals get longer as you consistently answer correctly.
* **Daily Practice Reminders:** Schedule customizable daily notifications to remind you to practice. You can set the exact time and choose which days of the week you want to be reminded.
* **Two Session Modes:**
  * **Learn New Words:** Encounter and learn the gender of new nouns from a frequency-ranked list.
  * **Review Due Cards:** Practice words you've previously learned that are due for review.
* **Audio Pronunciation:** Hear the correct pronunciation of each noun to reinforce learning. Tap on the word to hear its pronunciation.
* **Detailed Statistics:** Track your progress with statistics on streaks, learned words,  mastered words, and overall completion.
* **Customizable Experience:** Adjust learning thresholds, toggle audio, and choose your app theme (Light/Dark/System).
* **Tutorial System:** Either watch a provided link to a tutorial overviewing the app functionality or press on (i) icons within the app to view tutorials walking you through the app's mechanisms.
* **Wiktionary Linking:** Long-press on the word to either copy the word or link to the french wiktionary entry for that word.

## How It Works

***Spaced Repetition System:**

* **Learning:** A new word is considered "learned" when you answer its gender correctly a set number of times in a row (the **"Learn Threshold"** in settings). It then enters the review deck, scheduled for review the next day.

* **Reviewing:**
  
  * **Correct Streak (Reward):** If you correctly answer a review card (based on the **"Review Threshold"** in settings), its next review interval is doubled (e.g., 1 day -> 2 -> 4 -> 8...).
  
  * **Incorrect Answer (Reset):** If you answer a review card incorrectly even once during a session, its streak is broken. When you successfully complete the card later in the session, its interval is reset to 1 day, ensuring you see it again tomorrow.

* **Goal:** A word is considered "mastered" for long-term memory when its review interval grows to be over 16 days away. This is tracked in the "Review Mastery" statistic. The ultimate goal is to master all nouns in the deck.

## Technical Details

The application is built using modern Android development practices.

* **Language:** [Kotlin](https://kotlinlang.org/)
* **UI Toolkit:** Android Views with Material Components (Material 3). The layouts are defined in XML.
* **Architecture:** The app follows a basic Activity-based architecture. State is managed locally within activities and persisted using `SharedPreferences`.
* **Key Libraries:**
  * **AndroidX AppCompat & Core KTX:** For core app functionality and Kotlin extensions.
  * **Material Components:** For UI elements like buttons, cards, and switches, adhering to Material Design.
  * **Gson:** For serializing and deserializing the `ReviewItem` objects to and from JSON for storage in `SharedPreferences`.

## 📜 Licenses

### App License

This application is licensed under the **GNU General Public License v3.0 or later (GPLv3+)**.  
You are free to use, study, modify, and redistribute this software under the terms of the GPL.  
See the [COPYING](./COPYING) file for the full license text.

**Author:** Seweryn Polec  
**Contact:** sewerynpol@protonmail.com  
**Source Code:** [GitLab Repository](https://gitlab.com/SeverusPol/la-et-le/)

---

### Dataset License

This project uses data derived from the following openly licensed resource:

#### Frequency Words — French 50k list

- Source: [HermitDave / FrequencyWords](https://github.com/hermitdave/FrequencyWords)  
- File: [fr_50k.txt (2018)](https://github.com/hermitdave/FrequencyWords/blob/master/content/2018/fr/fr_50k.txt)  
- Based on: [OPUS OpenSubtitles v2018](https://opus.nlpl.eu/legacy/OpenSubtitles-v2018.php)  
- License: [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/)  
- Author: Hermit Dave  

Only the following columns are derived from this source:

- `Word` 

All example French sentences, English translations of individual words and the french sentences were generated by an LLM and are **not** part of any external dataset.  
Filtered and combined data remain licensed under **CC BY-SA 4.0**.

---

### Audio Recordings

All audio samples were obtained from [LinguaLibre.org](https://lingualibre.org),  
licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).  

The recordings have been **converted to mono and optimized for file size**  
to improve app performance, but are otherwise unchanged.  
Proper attribution is maintained for all contributors.

**Audio Contributors:**  
0x010C, Antoine, Aah Rix, Aemines5, Arthur Crbz, Ash Crow, Assassas77, Avatea, Axdae, Baidax, Benoit Rochon, Benoît Prieur, BiblioCanet66 (Benjamin B.), BiblioCanet66 (Fabricio Cardenas), CKali, ChoumX, ClasseNoes (Ahmed), ClasseNoes (Anonyme569), ClasseNoes (Mathys), Culex (Fabricio Cardenas), Culex (Olivier H.), DSwissK, DSwissK (LuneMarine), DenisdeShawi, DenisdeShawi (Tokçon), Eihel, Eric.LEWIN, Estrie, Exilexi, Fralambert, GrandCelinien, Guilhelma, Harmonia Amanda, Joe Pig, Jules78120, Julien Baley, Kitel WP, Kvardek du (Anonymât), Le Commissaire, Lepticed7 (Jean), LightD31, LoquaxFR, Ltrlg (Seshiru), Lunagrouh, Lyokoï (Flavie), Madehub, Manestra, Mathieu Kappler, Mathsou, Mecanautes, Nclm, Neerwan, Nicryc, O2, Opsylac, Pamputt, Pierre MLL, Poslovitch, PtiBzh, Raphoraph, Reda Kerbouche, Rodrigo5260, Roptat, Sarah2149, Sebleouf, Selakant, Simon Villeneuve, Spotless Mind1988, Tamahashi, Taousert, Tim Tim (VD fr), Totodu74, Tsaag Valren, Vaulque, VictorDtmtc, Webfil, WikiLucas00, X-Javier, Xenophôn, Yug, copiage.

---

**Note:**  
This README license section provides a summary of all relevant licenses and attributions.  
For complete details, see the in-app *Licenses* screen or the [COPYING](./COPYING) file.

---

## ⚖️ Legal Notice

This software is provided **“as is”**, without any express or implied warranty.  
In no event shall the author be held liable for any damages arising from the use of this software.  

The program and its source code are licensed under the **GNU General Public License v3.0 or later (GPLv3+)**.  
By using, modifying, or distributing this software, you agree to the terms of the GPLv3 license.  

© 2025 Seweryn Polec. All rights reserved where applicable.
