This chapter contains some common animals, plants, fungi, and rocks that may be useful in a survival situation. Always use caution when identifying plants, animals, or mushrooms. Some species may be dangerous or protected. If you are unsure about an identification, consult a professional.



\pagebreak

## Bamboo

![](file:///android_asset/field_guide/bamboo.webp)

A tall, fast-growing grass with hollow stems. Young shoots are edible when properly cooked to remove bitterness. Bamboo can also be used as a building material.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Grassland, Mountain, Wetland

\pagebreak

## Brambles

![](file:///android_asset/field_guide/brambles.webp)

A thorny shrub, typically found in forests and fields, often bearing aggregate berries such as blackberries. The fruits of most brambles are edible once mature. Be cautious of thorns when harvesting.

Common species include: blackberry, dewberry, and raspberry.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Grassland, Forest, Urban

\pagebreak

## Cattail

![](file:///android_asset/field_guide/cattail.webp)

A wetland plant with tall, cylindrical flower spikes, commonly found near ponds, lakes, and marshes. Most parts are edible.

Also known as bulrush, reed, raupo, cumbungi, and punks.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Wetland, Freshwater

\pagebreak

## Clover

![](file:///android_asset/field_guide/clover.webp)

A small plant with 3 leaves, commonly found in fields and grassy areas. Its leaves and flowers are edible.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Grassland, Forest, Urban

\pagebreak

## Common Plantain

![](file:///android_asset/field_guide/common_plantain.webp)

A low-growing plant with broad, oval leaves, often found in lawns and disturbed areas. Its leaves are edible, and have medicinal properties as a poultice for bites or wounds.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Grassland, Urban

\pagebreak

## Dandelion

![](file:///android_asset/field_guide/dandelion.webp)

A common plant with yellow flowers and deeply toothed leaves, found in lawns, fields, and roadsides. All parts are edible, but the leaves are bitter when mature. Dandelions have potential to help with constipation or inflammation. They are also a diuretic, which could lead to an increased risk of dehydration.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Urban, Grassland, Mountain

\pagebreak

## Dock

![](file:///android_asset/field_guide/dock.webp)

A plant with broad, green leaves, often found in fields, along roadsides, and near water. Its leaves are edible when cooked.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Grassland, Forest, Wetland, Urban

\pagebreak

## Kelp

![](file:///android_asset/field_guide/kelp.webp)

A large, brown seaweed found in coastal saltwater environments, often forming dense underwater forests. It is edible and can be harvested after washing up to the shore. Kelp is not technically a plant, but it has similar characteristics.

### Location
Worldwide

### Habitat
Marine

\pagebreak

## Poison Ivy

![](file:///android_asset/survival_guide/poison_ivy.webp)

A toxic plant with three glossy, pointed leaflets, commonly found in forests, fields, and along trails. Contact with its oil, urushiol, causes itchy rashes and skin irritation. If touched, wash the affected area with soap and water immediately.

Closely related to poison oak and poison sumac, which are also skin irritants.

### Location
Asia, North America

### Habitat
Forest, Grassland, Urban, Wetland

\pagebreak

## Stinging Nettle

![](file:///android_asset/survival_guide/stinging_nettle.webp)

A plant with serrated leaves and tiny, stinging hairs, commonly found in moist, shaded areas. Contact causes a painful, itchy rash, but cooking or drying neutralizes the sting. It is edible after boiled, but harvesting should be done with gloves to avoid skin irritation.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Grassland, Urban, Wetland

\pagebreak

## Bolete

![](file:///android_asset/field_guide/bolete.webp)

A mushroom with a spongy, porous underside instead of gills, commonly found near trees. Many boletes are edible, but some are toxic, so avoid ones with red or orange pores or turn blue when cut.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest

\pagebreak

## Chaga

![](file:///android_asset/survival_guide/chaga.webp)

A black fungus with an orange interior which mainly grows on birch trees. Chaga has a hard exterior and the inside can be used as tinder or to hold an ember for hours.

### Location
North America, Europe, Asia

### Habitat
Forest

\pagebreak

## Chicken of the Woods

![](file:///android_asset/field_guide/chicken_of_the_woods.webp)

A bright orange-yellow shelf mushroom that grows on trees, often found on hardwoods in forests. The underside will have pores instead of gills and be white or yellow. It is edible when young and tender, but can cause gastrointestinal upset in some individuals.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest

\pagebreak

## Morel

![](file:///android_asset/field_guide/morel.webp)

A hollow mushroom with a honeycomb-like, conical cap that is connected to the stem at the base. They are edible and can be found during the Spring. Be cautious of inedible lookalikes with a brain-like appearance or caps attached only at the top.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest

\pagebreak

## Oyster Mushroom

![](file:///android_asset/field_guide/oyster_mushroom.webp)

A gilled mushroom that grows on decaying hardwood, often in clusters. It can be identified by its fan or oyster shape and white gills that extend down the short stem. Oyster mushrooms are edible.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest

\pagebreak

## Tinder Fungus

![](file:///android_asset/survival_guide/tinder_fungus.webp)

A hoof-shaped fungus that grows on hardwoods such as birch, beech, and oak. Tinder fungus has a hard exterior and the inside can be used as tinder or to hold an ember for hours.

### Location
Africa, North America, Europe, Asia

### Habitat
Forest

\pagebreak

## Ant

![](file:///android_asset/field_guide/ant.webp)

A small insect that lives in large colonies, commonly found in soil, trees, or under rocks. They are omnivorous and are active during the day. Most ants are edible.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Desert, Grassland, Mountain, Urban, Wetland

### Activity Pattern
Diurnal

\pagebreak

## Cricket

![](file:///android_asset/field_guide/cricket.webp)

Small nocturnal insects with the ability to jump and produce chirps. They feed on plants, decaying organic matter, and small insects. Crickets are edible.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Desert, Grassland, Mountain, Urban, Cave

### Activity Pattern
Nocturnal

\pagebreak

## Grasshopper

![](file:///android_asset/field_guide/grasshopper.webp)

A small to medium-sized insect known for its powerful hind legs and ability to jump great distances. They are herbivores, feeding on grasses and leaves, and are commonly found in open fields during the day. Grasshoppers and locusts are edible.

Also known as: locust

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Desert, Grassland, Mountain, Urban

### Activity Pattern
Diurnal

\pagebreak

## Grub (Beetle Larva)

![](file:///android_asset/survival_guide/grub.webp)

The larva of various beetles, typically found in decaying wood or soil. They feed on organic material and may emerge at night. Many grubs are edible and are commonly used as fishing bait.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Grassland, Urban, Wetland, Mountain

### Activity Pattern
Nocturnal

\pagebreak

## Termite

![](file:///android_asset/field_guide/termite.webp)

Small insects that live in colonies within wood, soil, or mounds. They are most active in warm, humid conditions and can often be located by observing mud tubes or hollowed-out wood. Most termites are edible.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Grassland, Wetland, Urban

### Activity Pattern
Nocturnal

\pagebreak

## Earthworm

![](file:///android_asset/field_guide/earthworm.webp)

A segmented, soil-dwelling worm that feeds on decaying organic matter. They are commonly found in moist environments and are active at night or after a rainfall. Many earthworms are edible and commonly used as fishing bait.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Grassland, Urban, Wetland

### Activity Pattern
Nocturnal

\pagebreak

## Clam

![](file:///android_asset/field_guide/clam.webp)

A bivalve mollusk with many varieties, many of which are edible. They are found in both saltwater and freshwater environments, typically halfway buried in sand. During low tide, clams can be located along the shoreline by digging where small holes or bubbles appear.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Marine, Freshwater

\pagebreak

## Mussel

![](file:///android_asset/field_guide/mussel.webp)

A bivalve mollusk with an elongated shell, usually attached to rocks or other hard surfaces along the shoreline. Mussels are found in both saltwater and freshwater. Many species are edible, but mussels can retain toxins from the water, especially during summer months, so only those harvested from clean sources should be consumed.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Marine, Freshwater

\pagebreak

## Periwinkle

![](file:///android_asset/field_guide/periwinkle.webp)

A small marine snail with a spiral shell, typically found clinging to rocks, tidal pools, and other hard surfaces along the shoreline. While many are edible, periwinkles should only be collected from clean water sources, as they can accumulate toxins from polluted environments.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Marine

\pagebreak

## Crab

![](file:///android_asset/field_guide/crab.webp)

A crustacean with a short, broad body commonly found along the shorelines of most saltwater bodies. Many crabs scavenge at night, dusk and dawn, or between low and high tide. They also often hide in gaps between rocks along the shoreline.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Marine, Freshwater

### Activity Pattern
Crepuscular, Nocturnal

\pagebreak

## Crayfish

![](file:///android_asset/field_guide/crayfish.webp)

A freshwater crustacean that resembles a small lobster. They are commonly found at the bottom of streams, rivers, and lakes. Crayfish are omnivorous, feeding on plants, insects, and small fish, and are most active at night.

Also known as: crawfish, crawdads, freshwater lobsters, mudbugs, or yabbies.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Wetland, Freshwater

### Activity Pattern
Nocturnal

\pagebreak

## Mouse

![](file:///android_asset/field_guide/mouse.webp)

A small rodent with a long, thin tail. Mice are nocturnal and opportunistic feeders, consuming grains, seeds, fruits, and small insects. They often nest in sheltered areas such as burrows, dense vegetation, or hidden spaces indoors.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Desert, Grassland, Mountain, Wetland, Tundra, Urban, Cave

### Activity Pattern
Nocturnal

\pagebreak

## Rabbit

![](file:///android_asset/field_guide/rabbit.webp)

A small to medium-sized mammal with long ears, a short tail, and powerful hind legs. Rabbits are most active at dawn and dusk, and can be found feeding on vegetation. They live in burrows or dense vegetation, often in groups.

Also known as: hare, bunny

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Desert, Grassland, Wetland, Mountain, Tundra

### Activity Pattern
Crepuscular

\pagebreak

## Squirrel

![](file:///android_asset/field_guide/squirrel.webp)

A small to medium-sized rodent that primarily lives in trees or burrows. They tend to be most active during the day. Squirrels eat nuts, seeds, fruits, and insects.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Forest, Desert, Grassland, Mountain, Urban, Tundra

### Activity Pattern
Diurnal

\pagebreak

## Grouse

![](file:///android_asset/field_guide/grouse.webp)

A medium-sized game bird with mottled feathers that provide excellent camouflage. Grouse are primarily ground-dwelling and feed on a variety of foods, including vegetation, seeds, berries, and insects. They are most active during the day and can often be found foraging near forest edges or open clearings.

### Location
Asia, Europe, North America

### Habitat
Forest, Grassland, Tundra

### Activity Pattern
Diurnal

\pagebreak

## Black Bass

![](file:///android_asset/field_guide/black_bass.webp)

A freshwater fish with an elongated body and sharp dorsal spines. They are commonly found in shallow waters around lily pads and logs. Bass are opportunistic feeders, consuming nearly anything that moves, and are most active in the evening.

Common species include: largemouth bass, smallmouth bass, and spotted bass.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Freshwater

### Activity Pattern
Diurnal

\pagebreak

## Carp

![](file:///android_asset/field_guide/carp.webp)

A freshwater fish with thick, large scales. They are commonly found in slow-moving or still waters and often travel in groups. Carp consume a variety of foods and are most active at night.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Freshwater

### Activity Pattern
Nocturnal, Crepuscular

\pagebreak

## Sunfish

![](file:///android_asset/field_guide/sunfish.webp)

A small freshwater fish with a tall and flat body shape and sharp dorsal spines. They are typically found near the shore in weedy areas and are most active during the day. Sunfish feed on small insects and worms but can also be caught using vibrantly colored lures.

Common species include: bluegill, pumpkinseed, and redear.

### Location
Africa, Asia, Australia, Europe, North America, South America

### Habitat
Freshwater

### Activity Pattern
Diurnal

\pagebreak

## Chert

![](file:///android_asset/field_guide/chert.webp)

A sedimentary rock that forms sharp edges when fractured, often used for tools or fire-starting. It has a dull shine and comes in white, red, brown, black, or gray. Chert is commonly found in sedimentary rock outcroppings, along roads, rivers, and shorelines.

Also known as flint or jasper.

### Location
Africa, Asia, Australia, Europe, North America, South America

\pagebreak

## Altocumulus

![](file:///android_asset/survival_guide/altocumulus.webp)

Mid level puffy clouds that look like cotton balls. They are typically white with darker patches below and can be spaced out or sheet-like. May indicate precipitation or a thunderstorm in the next 12 hours.



\pagebreak

## Altostratus

![](file:///android_asset/survival_guide/altostratus.webp)

A mid level cloud that covers the sky. The sun can barely be seen as a bright patch. May indicate precipitation in the next 8 hours.



\pagebreak

## Cirrocumulus

![](file:///android_asset/survival_guide/cirrocumulus.webp)

High level clouds that form a wavy sheet. The sheet is composed of small dots which almost look two dimensional. May indicate precipitation in the next 8 to 12 hours.



\pagebreak

## Cirrostratus

![](file:///android_asset/survival_guide/cirrostratus.webp)

A high cloud that covers the sky. It is transparent and typically causes a halo to form around the sun. May indicate precipitation in the next 10 to 15 hours.



\pagebreak

## Cirrus

![](file:///android_asset/survival_guide/cirrus.webp)

High wispy clouds that look like tufts of white hair. May indicate precipitation in the next 12 to 24 hours.



\pagebreak

## Cumulonimbus

![](file:///android_asset/survival_guide/cumulonimbus.webp)

Low puffy clouds that are very tall. They typically have an anvil shape and are dark. May indicate a thunderstorm in a few minutes.



\pagebreak

## Cumulus

![](file:///android_asset/survival_guide/cumulus.webp)

Low puffy clouds that look like cotton balls. They are spaced out and are typically white with darker patches below. Usually indicates fair weather, but if it is growing taller, then precipitation or a thunderstorm could be possible in the next few hours.



\pagebreak

## Nimbostratus

![](file:///android_asset/survival_guide/nimbostratus.webp)

A mid level cloud that is dark gray and covers the sky. If it is not raining, it may be a stratus cloud. May have precipitation for the next 4 hours.



\pagebreak

## Stratocumulus

![](file:///android_asset/survival_guide/stratocumulus.webp)

Low clouds that look like a sheet of cotton balls with small gaps. The color ranges from white to dark gray. May indicate fair weather for the next 3 hours.



\pagebreak

## Stratus

![](file:///android_asset/survival_guide/stratus.webp)

A low cloud that covers the sky. Objects don't cast shadows and it may be foggy. May indicate fair weather for the next 3 hours if it is foggy, otherwise it may indicate precipitation soon.