---
title: "Tides"
---

The Tides tool helps you keep track of tides at a specific location.

## Create a tide table
Before venturing into coastal areas, consult an official tide table for accurate times and water heights. Once you have this information, follow these steps to import it into Trail Sense's Tide tool:

1. Click the tides button in the top-right corner of the screen.
2. Tap the '+' button in the bottom-right corner.
3. Optionally, provide a name and location for the tide.
4. Adjust the tide frequency, indicating how many high tides typically occur in a day (most places have 2, known as Semidiurnal).
5. Scroll down to the tide table section.
6. Click either 'H' for high tide or 'L' for low tide to toggle between them.
7. Select 'Time not set' and enter the date and time of the tide.
8. Optionally, click the '-' in the 'Height' column to input the tide's height.
9. To add another tide, tap the '+' button in the top-left corner of the table.
10. You can delete a tide by clicking the 'X' icon to the right of the tide.
11. The tide estimation method can be changed by clicking the 'Estimation method' dropdown. Lunitidal interval uses the moon's position to estimate tides, and may be more accurate in some locations.
12. Save the tide table by clicking the checkmark in the top-right corner.

For the best accuracy, input all tides for each relevant day. Trail Sense will distinguish between entered and estimated tides on the tide chart.

### Estimation methods

- **Tide clock**: Assumes a fixed tidal cycle and requires at least one known tide to operate.
- **Lunitidal interval**: Uses the moon's position to estimate tides.
    - **Auto**: Requires at least one known tide, it will automatically calculate the lunitidal interval.
    - **Local**: Enter the lunitidal interval in hours and minutes for your location. This requires the location to be set, but does not require a tide table.
    - **UTC/Greenwich**: Enter the lunitidal interval in hours and minutes for UTC/Greenwich. This does not require a location or tide table.
- **Tide model (auto)**: Estimates the tide near the entered location or if no location is entered, near you. For most locations, tides should be accurate to within an hour.

## Viewing a tide table
By default, the Tides tool displays the closest tide to your location when you open it. To change this, go to Settings > Tides > 'Show closest tide' to toggle between displaying the closest tide and the last tide you viewed.

To select a different tide, click the tides button in the top-right corner of the screen. This opens a list of all the tide tables you've created. Simply click on a tide to view it.

### Nearby tide
This shows the tide near your location using an offline tide modal. For most locations, tides should be accurate to within an hour, but always use official tide tables if possible. If you are not close to a tide you entered, this will be shown by default.

This may be inaccurate in some areas, especially in areas with complicated geography.

The nearby tide table can't be modified or deleted.

## Tide chart
The tide chart displays the tides for the current day. The X-axis represents time, while the Y-axis represents the tide height. A dot marks the current time on the chart. By default, today is selected, but you can change it by tapping the calendar icon at the top of the screen. Additionally, you can use the arrows to move to the next/previous date or long press the calendar to quickly jump to today's date.

At the top of the screen, you'll find the current tide level and, if available, the tide's height. A down arrow means a falling tide, while an up arrow means a rising tide.

The bottom of the screen displays a tide table for the current day. If the tide height is entered, it will be shown here; otherwise, it will be estimated. Estimated tides may not be entirely accurate and are based on the inputted tides.

## Editing a tide table
You can edit a tide table with the following steps:

1. Click the tides button in the top-right corner of the screen.
2. Click the menu button to the right of the tide you wish to edit.
3. Select 'Edit.'
4. You'll be taken to the same screen used to create the tide table. Edit the table as needed.
5. Save your changes by clicking the checkmark in the top-right corner.

## Deleting a tide table
You can delete a tide table using the following steps:

1. Click the tides button in the top-right corner of the screen.
2. Click the menu button to the right of the tide you want to delete.
3. Choose 'Delete.'

## Viewing tides on the map
By default, tides with a location entered will appear on the Navigation tool's radar compass and Photo Maps. To hide/show a tide, follow these steps:

1. Click the tides button in the top-right corner of the screen.
2. Click the menu button to the right of the tide you wish to hide or show.
3. Select 'Hide' or 'Show.'

## Estimating tides without a tide table
If you don't have access to a tide table, you can estimate tides using the Tides tool. Keep in mind that this is just an estimate, so it's always best to consult an officially published tide table when possible. If you know whether the tide is currently high or low, you can create a tide table with a single entry (using the current time and tide level), and the Tides tool will estimate the tidal cycle. This should only be used for short-term predictions, as accuracy decreases further away from the reference tide.

## Finding official tide tables
To locate an official tide table, search the Internet for tides at your location. Here are some community-recommended sites offering tide tables:

### Worldwide

- [tides4fishing](https://tides4fishing.com/)
- [tide-forecast.com](https://www.tide-forecast.com/)
- [SHOM](https://maree.shom.fr/)

### Germany

- [BSH](https://www.bsh.de/DE/DATEN/Vorhersagen/Gezeiten/gezeiten_node.html)

### Netherlands

- [Rijkswaterstaat](https://www.rijkswaterstaat.nl/water/waterdata-en-waterberichtgeving/waterdata/getij)

### UK

- [UK Hydrographic Office: EasyTide](https://easytide.admiralty.co.uk/)

### UK + Ireland

- [NTSLF Tides](https://ntslf.org/tides/predictions)

### USA

- [NOAA Tides & Currents](https://tidesandcurrents.noaa.gov/tide_predictions.html)
- [Tides.net](https://tides.net/)

## Widgets
The following widgets can be placed on your device's homescreen or viewed in-app:

- **Tides**: Displays the status of the nearest tide.
- **Tide chart**: The chart of water level of the nearest tide.

## Disclaimer
Tide predictions are estimates and should not be relied upon exclusively. Whenever possible, use an official tide table and input the data into Trail Sense for accuracy.
