---
title: "Paths"
---

The Paths tool can be used to record waypoints while hiking or to follow a trail.

## Backtrack
The Backtrack feature can be used to automatically record a path while you hike. To start Backtrack, click the start button in the bottom-right corner of the screen. A notification will appear showing how far you have traveled. You can stop Backtrack by clicking the stop button in the notification or by clicking the stop button in the bottom-right corner of the screen.

To change the recording frequency, click the time under the Backtrack label at the bottom-left and enter a new interval.

Backtrack can record the cell signal strength at each point. This can be enabled in Settings > Paths > 'Record cell signal'. If you also have Settings > Navigation > 'Last signal beacon' enabled, a beacon will be created for the last known location where you had a cell signal.

By default, Backtrack paths are temporary and will be deleted after the number of days specified by Settings > Paths > 'Backtrack history'. You can choose to keep a Backtrack path forever by clicking the menu button on the Backtrack path row and selecting 'Keep forever'.

## Creating a path
You can choose to manually create a path by doing the following:

1. Tap the '+' button in the bottom-right corner of the screen.
2. Click 'Path'.
3. Give the path a name and click 'OK'.
4. Click the '+ Point' button to add a point to the path at your current location. You can add as many points as you want.

## Importing paths
If you have tracks or routes saved in a GPX file, you can import them into Trail Sense as paths.

1. Tap the '+' button in the bottom-right corner of the screen.
2. Click 'GPX File'.
3. Select the GPX file you want to load paths from.
4. Confirm that you want to import the paths by clicking 'OK'. You can uncheck any paths you don't want to import.
5. The paths will be created in the current group.

## Viewing a path
To view a path, click the path in the list. This will open the path details page. The following information will be shown:

- **Name**: The name of the path.
- **Group**: The group the path is in. You can click the group name to move the path to a different group.
- **Map**: A map showing the path and your current location. You can drag to move the map and pinch to zoom. You can also click a point on the map to select it. A scale is shown at the bottom-right of the map. You can make the map larger by clicking the expand button in the bottom-left corner of the map.
- **Selected point**: The currently selected point on the map. It will show the time, cell signal strength, elevation, and slope of the point. You can click the menu button on the point to navigate to it, create a beacon for it, or delete it. Tap the selected point on the map to deselect it.
- **Duration**: The time it took to record the path.
- **Distance**: The distance of the path.
- **Points**: The number of points in the path.
- **Difficulty**: An estimate of the difficulty of the path. Calculated based on the distance, elevation change, and slope.
- **Ascent**: The total elevation gain of the path.
- **Descent**: The total elevation loss of the path.
- **Lowest point**: The lowest elevation of the path. Click to select on the map.
- **Highest point**: The highest elevation of the path. Click to select on the map.
- **Elevation chart**: A chart showing the path's elevation over distance. Click a point on the chart to select it.
- **Points**: To see the list of points in the path, click the menu button in the top-right and select 'Points'. Click a point to select it. Click the menu button on a point to navigate to it, create a beacon for it, or delete it.

## Path styles
Adjust the path's appearance by opening it and selecting the line style or line color from the dropdowns at the top of the screen. Change the appearance of the path's points by selecting the point style from the dropdown on the top-right. Choose between the following point styles:

- **None**: No points shown.
- **Cell signal**: Show cell signal strength at each point.
- **Elevation**: Show elevation at each point.
- **Time**: Show the time each point was recorded.
- **Slope**: Show the slope at each point.

A key below the path map explains the colors.

Set the default path styles in Settings > Paths > 'Default path style' for the line style and Settings > Navigation > 'Default path color' for the line color.

## Simplify a path
Paths can be simplified to reduce the number of points in the path. This can be useful to improve the performance of the path rendering and may improve the accuracy of the path by removing GPS errors.

To simplify a path, open the path and click the menu button in the top-right corner of the screen. Select 'Simplify path' and choose the desired simplification quality. High quality means fewer points will be removed, while low quality means more points will be removed.

Once the path has been simplified, it is not possible to undo the simplification.

You can choose to automatically simplify paths imported from a GPX file by enabling Settings > Paths > 'Simplify paths on import'.

## Navigate to a path
You can navigate to the nearest point on a path by opening the path and clicking the 'Navigate' button at the bottom. This will open the navigation tool with the path as the destination. Alternatively, you can click the menu button on the path row you want to navigate to and then select 'Navigate'.

By default, this will only navigate to recorded waypoints on the path. However, you can choose to navigate to any position on the path by disabling Settings > Paths > 'Only navigate to recorded points'. This will assume that the path is a straight line between points.

Paths are also visible on the radar compass (see the 'Navigation' guide) and photo maps (see the 'Photo Maps' guide).

## Path visibility
You can choose which paths are visible on the Navigation and Photo Maps tools by clicking the eye icon on the right side of the path row.

## Delete a path
To delete a path, click the menu button on the path row you want to remove, then select 'Delete'.

## Exporting paths
To export paths, open the group you want to export and click the menu button in the top-right corner of the screen. Select 'Export', unselect any paths you don't want to export, then click 'OK'. The paths will be exported to a GPX file. 

Alternatively, you can export a single path by clicking the menu button on the path row you want to export, then selecting 'Export'.

## Organizing paths
You can organize paths into groups. To create a group, click the '+' button in the bottom-right of the path list and select 'Group'. Give the group a name and click 'OK'. Click the group in the list to view the paths in that group.

If you create a path or group while the group is open, the new path or group will be added to the currently open group.

To change the group of an existing path, click the menu button on the path row you want to move, select 'Move to', and choose the target group.

To rename a group, click the menu button on the group row you want to rename, then select 'Rename' and provide a new name.

You can delete a group (along with all paths within it) by clicking the menu button on the group row you wish to remove, then selecting 'Delete'.

## Searching for paths
To search through your created paths, use the search bar at the top of the path list. This search encompasses the current group and all subgroups. Additionally, you can sort paths by distance away, time, length or name by clicking the menu button in the top-right and selecting 'Sort'.

## Improving performance
If you are experiencing performance issues with the Paths tool, you can enable Settings > Paths > 'Fast path rendering' which will render paths faster, at the cost of appearance.

## Quick action
You can enable the Backtrack quick action in the settings for the desired tab.

To use the quick action, tap the Backtrack quick action button to toggle it on or off. You can long press the button to open the Paths tool.

## Widgets
The following widgets can be placed on your device's homescreen or viewed in-app:

- **Backtrack**: Display the distance travelled if Backtrack is enabled.

## Video guide
If you prefer a video guide on using Backtrack, here's a video by one of Trail Sense's users: [YouTube: Trail Sense: Learning How To Use BackTrack To Track Cell Service On Hikes by DeathfireD](https://www.youtube.com/watch?v=7IC69LgBcRk)
