---
title: "Map"
---

The Map tool can be used to display your beacons, paths, and photo maps in a single place. It's essential to always carry a physical map as a backup and validate Trail Sense's accuracy. This is not a replacement for a dedicated maps app and it will only show maps that you have loaded into the Photo Maps tool.

## Using the map
You can drag to pan, pinch to zoom, or tap the zoom buttons in the bottom-right.

Click the GPS button in the bottom-right to center the map on your location. Clicking it again will lock both your location and orientation, while a final click unlocks it.

## Navigating and creating beacons
When navigating to a beacon, the distance, direction, and estimated time of arrival (ETA) are displayed at the bottom. To cancel navigation, click the 'X' button. You can open the beacon by tapping the beacon name in the navigation sheet.

You can initiate navigation from the map by tapping a beacon or long-pressing a map point and selecting 'Navigate'.

To create a beacon from the map, long-press a map point and choose 'Beacon.' This opens the 'Create Beacon' screen with the location filled in.

For further details on beacons, refer to the 'Beacons' guide.

## Measuring distance and creating paths
You can measure distances by clicking the menu button in the top-right, and selecting 'Measure' or 'Create path'. Tap the map to place markers, and the total distance will be displayed at the bottom. To undo the last marker, click the undo button in the bottom left. Cancel by clicking the 'X' button in the bottom-right. You can also convert the drawn path into a saved path by clicking the 'Create path' button at the bottom.

For a quick measurement from your location to a point, long-press that point on the map and click 'Distance'.

## Layers
Layers are used to display information on the map. You can find layer settings in Settings > Map or through the menu at the top right of the screen. You can choose to hide and show layers using the switch next to each layer's name. The opacity setting for each layer determines how transparent the layer is. 0 is fully transparent and 100 is fully opaque.

### Base map
This layer shows a map of the world with colors based on satellite imagery. It is very low resolution and not suitable for navigation.

### Elevation
This layer shows the elevation from the digital elevation model (DEM) as color. You can change the DEM in Settings > Altimeter.

Settings:

- **Color**: The color scale of the pixels. The color will change based on elevation.

### Hillshade
This layer draws shadows to help see elevation in the terrain from the digital elevation model (DEM). You can change the DEM in Settings > Altimeter.

### Photo Maps
This layer shows visible Photo Maps, with the most zoomed-in map appearing on top. You can add new maps in the Photo Maps tool.

Settings:

- **Load PDF tiles**: If enabled, PDF tiles will be loaded for maps that have a PDF version available. This is slower but provides higher resolution maps.

### Contours
This layer shows contour lines generated from the digital elevation model (DEM) and can be used to see the steepness and elevation of map features. You can change the DEM in Settings > Altimeter.

Settings:

- **Show labels**: Determines if contour labels are shown on the map.
- **Color**: The color of the contour lines, some options are color scales which change based on elevation.

### Cell towers
This layer shows nearby cell towers with the accuracy of the tower's location shown as a circle under the tower. These are approximate tower locations from OpenCelliD, Mozilla Location Service, and FCC Antenna Registrations. You can click on a cell tower to navigate to it.

### Paths
This layer shows visible paths. You can add new paths in the Paths tool.

Settings:

- **Background color**: The background color to render behind paths for increased visibility.

### Beacons
This layer shows visible beacons. You can add new beacons in the Beacons tool. You can click on a beacon to navigate to it.

### Navigation
This layer draws a line between your location and the destination point you are navigating to.

### Tides
This layer shows visible tides. You can add new tides in the Tides tool.

### My location
This layer shows your location, which direction you are facing (if you have a compass), and the accuracy of your GPS.

Settings:

- **Show GPS accuracy**: Determines if the GPS accuracy circle is visible.

### Scale
This layer shows a scale bar in the bottom-left corner of the map, which can be used to estimate distances on the map.

This layer is not currently configurable.

### Elevation
This layer shows your elevation in the bottom-right corner of the map.

This layer is not currently configurable.

### Compass
This layer shows a compass in the top-right corner of the map. It shows where true north is on the map.

This layer is not currently configurable.
