---
title: "8 - Weather"
---

<!-- K: weather, condition, sky -->
<!-- S: Know the weather forecast. -->

Weather can quickly change from a nice day to a life-threatening situation. You should always be prepared for the weather in your area and keep tabs on the forecast.

**This chapter is for informational purposes only and does not replace professional advice; use at your own risk and ensure compliance with local laws.**

## Be prepared
<!-- K: prepare, gear, knowledge, skill, forecast, clothes, shelter, poncho, sunglasses, barometer, thermometer -->
<!-- S: Bring appropriate clothing and shelter for the weather. Learn how to identify signs of worsening weather. -->

### Gear

**Necessities**:

- 7-day weather forecast
- Appropriate clothing and shelter for the weather (see the Shelter chapter)
- Poncho
- Sunglasses

**Optional**:

- Barometer
  - Many smartphones have barometers but require an app to use them
- Thermometer

### Knowledge and skills
Start by learning how to do the following:

- Read a weather forecast.
- Deal with different types of weather.
- Identify signs of worsening weather.

Once you have mastered these skills, you should learn how to do the following:

- Identify signs of improving weather.
- Forecast weather based on observations.
- Understand your region's climate.
- Predict tides.

## Weather
<!-- K: weather, storm -->
<!-- S: Take shelter during severe storms. Be prepared for various conditions, such as precipitation, temperature, humidity, and strong wind. -->

Weather conditions can change rapidly and significantly impact your outdoor activities. In mountainous regions, take extra precautions when above the tree line, as weather can be more severe and you are more exposed to the elements.

### Precipitation
<!-- K: rain, snow, hail, sleet, precipitation -->

You can generally continue outdoor activities in light precipitation. However, if it starts precipitating heavily, seek shelter. During heavy rain, rivers and streams can rise rapidly, and flash floods are possible. Precipitation can also lead to hypothermia, so be aware of the risks and take steps to stay warm and dry.

Blizzards can lead to whiteout conditions, severely reducing visibility. If caught in a blizzard, seek shelter immediately and stay warm and dry.

### Temperature and humidity
<!-- K: temperature, humidity, heat, cold, hot, warm, cool -->

In cold weather, dress in layers and wear a hat and gloves to prevent heat loss. Stay dry, as wet clothing can cause you to lose body heat more quickly.

In hot weather, stay hydrated and take breaks in the shade. Wear sunscreen and sun-protective clothing to protect yourself from sun exposure. High humidity can make it feel hotter and make cooling off more difficult.

Temperature decreases by about 3.5°F (2°C) for every 1,000 feet (305 meters) of elevation gain. If you are hiking in a mountainous region, it may be warm at the bottom, but be prepared for cold, windy temperatures at the top.

### Wind
<!-- K: wind, gust, storm, hurricane, tornado, sandstorm, prevailing, blow, direction -->

Wind can make cold conditions feel even colder, increasing the risk of hypothermia and frostbite. Dress in layers and wear a hat and gloves to protect yourself from the wind. During windstorms, unstable trees and branches can become hazardous. You should be extra cautious when the wind speed is above 20 mph (32 km/h). Wind can cause sandstorms in desert environments, reducing visibility and making breathing difficult. Seek shelter during a sandstorm and protect your eyes and mouth with a bandana or cloth. In coastal environments, winds can lead to dangerous surf conditions such as high waves or rip currents.

Prevailing winds are winds that blow consistently in one direction over time. While local geography and bodies of water can affect wind patterns, general patterns for the following latitudes are as follows:

- 60° N to 90° N: Winds generally blow from the east.
- 30° N to 60° N: Winds generally blow from the west.
- 0° to 30° N: Winds generally blow from the northeast.
- 0° to 30° S: Winds generally blow from the southeast.
- 30° S to 60° S: Winds generally blow from the west.
- 60° S to 90° S: Winds generally blow from the east.

These directions also indicate where the weather will most likely come from. For example, if you are at a latitude of 40° N and see a thunderstorm to the west, it will likely arrive at your location soon.

### Fog
<!-- K: fog, visibility -->

Fog reduces visibility, making navigation difficult. If hiking in fog, stay on marked trails and use a map, compass, or GPS to navigate. Watch your footing carefully, as the fog can lead to slippery conditions.

### Lightning
<!-- K: lightning, thunder, thunderstorm, strike, hair -->

If caught outdoors during a thunderstorm, seek shelter immediately. Avoid staying in or near open fields, peaks, ridges, tall trees, water, cave entrances, and fences or poles. If you are in a forest, stay near lower trees. Tents do not protect you from lightning. If you're in an open area and can't take shelter, stand, crouch, or sit on your pack or sleeping pad with your feet together.

If you feel your hair stand on end or hear a crackling noise, you are in imminent danger of being struck by lightning.

You can estimate how far away a thunderstorm is by counting the seconds between a flash of lightning and the sound of thunder. Divide the number of seconds by 5 to get the distance in miles. One mile is about 1.6 kilometers. Any storm within 6 miles (10 kilometers) is a threat.

### Sun
<!-- K: sun, uv, uv-index, sunburn, heatstroke, shade -->

Wear sunscreen, sun-protective clothing, and sunglasses on days with a high UV index. In hot climates, stay hydrated and take breaks in the shade. If there is snow on the ground or you are on the water, wear sunglasses to prevent snow blindness.

### Smoke
<!-- K: smoke, wildfire, air quality, pollution -->

Wildfires can cause smoke to travel long distances, appearing as a haze. If possible, avoid outdoor activities on days with poor air quality.

## Climate
<!-- K: climate, average -->
<!-- S: Your region's climate can indicate what weather is common for the time of year. -->

The climate of a region refers to its average weather conditions over time. You should look up the average daily high and low temperatures, how often it rains or snows, what the humidity normally is, and where the prevailing wind blows from. You should prepare for conditions to return to the climate normals in a longer-term scenario, so if it is unusually warm during your hike but the average low is below freezing, bring cold-weather gear with you. During a dry season, you should be extra cautious about starting a fire and plan for scarce natural water sources.

## Forecasting
<!-- K: forecast, predict, signs -->
<!-- S: Signs of worsening weather include increasing cloud cover, darkening skies, strong wind, and sudden drops in temperature. -->

You can learn to forecast weather by observing the signs around you. The more signs you notice, the more accurate your forecast will be.

### Signs of worsening weather
<!-- K: storm, worsen, bad, rain, dark -->

- Cloud cover increases
- Clouds start growing vertically (into an anvil shape)
  - This indicates a thunderstorm
- Clouds darken
- Clouds move quickly
- Clouds lower
- Wind speed increases
- Temperature suddenly drops
- Barometric pressure drops
  - Faster drops may indicate more severe weather
- Wind direction changes to be opposite the prevailing wind
- Animals become quiet
- Humidity increases
- You see lightning or hear thunder
- You smell rain

### Signs of improving weather
<!-- K: improve, good, clear -->

- Cloud cover decreases
- Wind speed decreases
- Temperature rises
- Barometric pressure rises
- Wind direction changes to match the prevailing wind
- Animals become active
- Humidity decreases

### Clouds
<!-- K: cloud, type, cumulus, cirrus, cumulonimbus, altocumulus, stratus, altostratus, clear, cirrostratus, nimbostratus, cirrocumulus -->

Identifying the cloud type can improve your ability to forecast weather.

![](/assets/images/survival_guide/clouds.webp)

1. **Cirrocumulus**: High-level clouds that form a wavy sheet. The sheet is composed of small dots that almost look two-dimensional. They may indicate precipitation in the next 8 to 12 hours.
2. **Altocumulus**: Mid-level puffy clouds that look like cotton balls. They are typically white with darker patches below and can be spaced out or sheet-like. They may indicate precipitation or a thunderstorm in the next 12 hours.
3. **Cumulus**: Low puffy clouds that look like cotton balls. They are spaced out and are typically white with darker patches below. Usually they indicate fair weather, but if they are growing taller, then precipitation or a thunderstorm could be possible in the next few hours.
4. **Cumulonimbus**: Low puffy clouds that are very tall. They typically have an anvil shape and are dark. They may indicate a thunderstorm in a few minutes.
5. **Cirrostratus**: A high cloud that covers the sky. It is transparent and typically causes a halo to form around the sun. It may indicate precipitation in the next 10 to 15 hours.
6. **Altostratus**: A mid-level cloud that covers the sky. The sun can barely be seen as a bright patch. It may indicate precipitation in the next 8 hours.
7. **Stratus**: A low cloud that covers the sky. Objects don't cast shadows, and it may be foggy. It may indicate fair weather for the next few hours if it is foggy; otherwise, it may indicate precipitation soon.
8. **Nimbostratus**: A mid-level cloud that is dark gray and covers the sky. If it is not raining, it may be a stratus cloud. It may produce precipitation for the next few hours.
9. **Stratocumulus**: Low clouds that look like a sheet of cotton balls with small gaps. The color ranges from white to dark gray. They may indicate fair weather for the next few hours.
10. **Cirrus**: High wispy clouds that look like tufts of white hair. They may indicate precipitation in the next 12 to 24 hours.

## Tides
<!-- K: tide, water, coast, rise, fall, moon, ocean, sea, semidiurnal, diurnal, mixed -->
<!-- S: Most places have two high tides and two low tides daily. Check tide tables before heading to the coast. -->

Tides can affect outdoor activities near the coast. Check the tide tables before heading to the coast. Tide tables can be found online or in local newspapers.

This map shows the tide types around the world. Green is semidiurnal, blue is mixed, and orange is diurnal.

![](/assets/images/survival_guide/tides.webp)

### Semidiurnal tides
Semidiurnal tides have two high tides and two low tides each day. If you know the time of high tide, the next low tide will be about 6 hours later, and the following high tide will be about 6 hours after that.

### Mixed tides
Mixed tides are a type of semidiurnal tide, but the heights of the high and/or low tides vary throughout the day.

### Diurnal tides
Diurnal tides have one high tide and one low tide each day. If you know the time of high tide, the next low tide will be about 12 hours later, and the next high tide will be about 12 hours after that.

## Night
<!-- K: night, dark, light, moon, stars, flashlight -->
<!-- S: Be aware of when the sun will set to avoid being caught in the dark. Use a flashlight to navigate at night. -->

You can estimate the time until sunset by holding your hand horizontally with your fingers together and counting the number of finger widths between the sun and the horizon. Each finger width represents roughly 15 minutes.

![](/assets/images/survival_guide/sunset_hand.webp)

Navigating in the dark is not recommended; if necessary, use a flashlight or headlamp to light your way. On nights with a nearly full moon, you can use the moonlight to help navigate.

If you are in a mountainous region, it may get dark sooner if you are on the eastern side of the range.
