---
title: "3 - Shelter"
---

<!-- K: warm, heat -->
<!-- S: Layer clothing and build a shelter. -->

This chapter covers how to dress appropriately for the environment and build shelters to protect yourself from the elements.

**This chapter is for informational purposes only and does not replace professional advice; use at your own risk and ensure compliance with local laws.**

## Be prepared
<!-- K: prepare, gear, knowledge, skill, emergency-space-blanket, space-blanket, blanket, poncho, socks, boots, shoes, sunglasses, cordage, sewing, needle, thread, jacket, pants, hat, gloves, hand-warmer, bag, pad, tent, tarp, hat, bandana, pillow, gloves, net, gaiters, hammock, tape -->
<!-- S: Bring an emergency space blanket, cordage, and proper clothing. Be sure to plan for nighttime temperatures and bad weather. Learn how to dress in layers and increase insulation. -->

### Gear

**Necessities**:

- Emergency space blanket
- Poncho
- Extra socks
- Boots or sturdy shoes
- Sunglasses
- Cordage (paracord)
- Sewing kit (needle and thread)
- In colder climates:
  - Insulating layers (jacket, pants, hat, gloves)
  - Waterproof outer layer
  - Waterproof/insulated boots
  - Thermal underlayers
  - Hand warmers
- For overnight stays:
  - Change of clothing
  - Sleeping bag
  - Sleeping pad
  - Tent
  - Tarp

**Optional**:

- Additional changes of clothing
- Hat or bandana
- Pillow
- Gloves
- Bug net
- Gaiters
- Hammock
- Duct tape

### Knowledge and skills

Start by learning how to do the following:

- Choose clothing appropriate for your environment.
- Use an emergency space blanket.
- Get warm quickly.
- Layer clothing for warmth.
- Set up a tent and sleeping bag.
- Identify environmental hazards when selecting a shelter location.
- Tie several types of knots.

Once you have mastered these skills, you should learn how to do the following:

- Construct a natural shelter.
- Repair clothing.

## Clothing
<!-- K: clothing, wear, garment, socks, pants, shirt, jacket, fleece, vest, underwear, undergarments, windbreaker, rain, hat, sunglasses, glasses, scarf, bandana -->
<!-- S: Dress in layers and choose clothing made from wool, polyester, or nylon. Only wear shoes that you have worn in. -->

Your first line of defense in any environment is your clothing. Proper attire should keep you dry, regulate your body temperature, protect you from the sun, and prevent insect bites.

### Materials
<!-- K: material, wool, polyester, nylon, down, cotton -->

When choosing clothing, consider the following materials:

- Wool: Retains warmth even when wet.
- Polyester/nylon: Quick-drying and moisture-wicking.
- Down: Lightweight and insulating but loses warmth when wet.
- Cotton: Retains moisture and loses warmth when wet. Do not wear cotton in cold or wet environments.

### Layers
<!-- K: layer, dress -->

You should plan to wear multiple layers of clothing to protect against the elements. Layering allows you to adjust your clothing to changing conditions and maintain body temperature.

In cold environments, remove or add layers to prevent sweating while staying warm. Remove mid layers before physical exertion and add them back in after you stop.

In warm environments, you may only need to wear a base layer as long as you have sunscreen and bug repellent on. But you should still always pack rain gear, such as an emergency poncho, in case of sudden weather changes.

If you need extra insulation in a pinch, stuff your clothing with dry leaves, grass, or other insulating materials.

- **Base layer**: Wicks moisture away from the skin. This layer should be tight-fitting.
  - Undergarments
  - Socks
  - Pants
  - Shirt
- **Middle layer**: Insulates and retains heat. This layer should be loose-fitting.
  - Sweater
  - Fleece jacket
  - Insulated pants
  - Vest
- **Outer layer**: Protects against wind, rain, and snow. This layer should be loose-fitting.
  - Rain gear
  - Windbreaker
- **Accessories**: Protect against sun, wind, cold, and insects.
  - Hat
  - Sunglasses
  - Gloves
  - Scarf or bandana

### Footwear
<!-- K: footwear, shoes, boots, socks, gaiters -->

Be sure to choose footwear that is appropriate for your environment. In cold climates, wear insulated, waterproof boots. In hot climates, wear breathable, lightweight shoes. Always break in new footwear before a trip to avoid blisters.

If you plan to be hiking in wet conditions, consider wearing waterproof boots or all-terrain footwear that can handle water and dries fast.

Bring extra socks, preferably made from wool, and ensure they are taller than your boots to avoid blisters.

## Preparing a shelter site
<!-- K: prepare, shelter, sleep -->
<!-- S: Choose a location for your shelter that is protected from the elements and has access to resources. -->

When selecting a site for your shelter, look for areas near building materials and resources such as water and food. Make sure the area is protected from the elements but is also free of threats such as dead trees/branches, slopes that could lead to avalanches/rock slides, flooding, insects, poisonous plants, and dangerous animals. It should not be so secluded that you can't signal for help. If you can avoid it, do not build a shelter above the tree line in mountainous regions, as you will be exposed to the elements.

While gathering materials for your shelter, prefer wood and debris that are already on the ground and require minimal effort to use. Avoid logs that are too thick to break by hand.

## Building a shelter
<!-- K: sleep, shelter, type -->
<!-- S: Construct a shelter using natural materials or a tarp. Insulate the shelter with leaves, straw, or clothing. -->

You can construct various shelters using tarps, ponchos, or natural elements. To retain heat, build the smallest shelter that meets your needs and position it against prevailing winds to avoid excess heat loss. Before sleeping in your shelter, make sure there is adequate airflow to manage condensation and smoke from your fire.

### Lean-to
<!-- K: lean-to, build, ridgeline, tarp -->

A lean-to is a simple shelter made by leaning a large sheet of material against a support like a tree or a ridgepole. It protects from wind and rain.

1. Lash a ridgepole to two trees or supports. If you are using a tarp or poncho, your 'ridgepole' can be a cord.
2. Lay a tarp or poncho over the ridgepole, allowing one side to touch the ground. If using natural materials, lay branches and leaves over the ridgepole.
3. Secure the sides with stakes or rocks.

![](/assets/images/survival_guide/shelter_tarp.webp)

If you're constructing a ridgeline with cordage, form a bowline at one end, wrap the cordage around a tree, and pass the free end through the bowline's loop. Secure the other end to a second tree using either a taut-line hitch or a trucker's hitch, then tighten it. To attach a tarp, pull a small section of the ridgeline through the grommets and insert a stick through the resulting loop to hold it in place.

### A-frame
<!-- K: a-frame, debris, hut, build, ridgeline, tarp -->

A-frames are a more enclosed shelter that provides better protection from the elements.

1. Lash two sticks together into an A-shape. You can also use a fork in a tree or stick, a stump, or a large rock as a support.
2. Place one end of the ridgepole on top of the A-frame (or fork/stump/rock) and the other end on the ground.
3. Lay a tarp or poncho over the ridgepole, securing the sides with stakes or rocks. If using natural materials, lay branches over the ridgepole angled slightly upward, then add leaves or other debris from the bottom up.

![](/assets/images/survival_guide/shelter_debris_hut.webp)

### Cave
<!-- K: cave -->

Caves offer protection from the elements and require minimal effort to use. Be careful when entering caves, though, as they can be home to animals or have poor ventilation. Avoid lighting a fire if possible, since smoke can accumulate; if you do light a fire, do it away from the entrance so the smoke isn't blown back into the cave.

### Emergency space blanket
<!-- K: emergency-space-blanket, space-blanket, blanket -->

Wrap yourself in an emergency space blanket to reflect body heat and protect against the elements. You can also use it to create a shelter by tying it between two trees or supports. Be gentle when handling the blanket, as it can tear easily.

### Tent
<!-- K: tent, rainfly, setup, assemble -->

If you have a tent, set it up according to the manufacturer's instructions. Ensure the tent is staked securely and the rainfly is in place. Most tents can be set up by inserting poles into sleeves or clips and securing the tent to the ground with stakes. If there is even a slight chance of rain and your tent comes with a rainfly, be sure to set it up.

### Hammock
<!-- K: hammock, setup, rainfly, assemble -->

If you have a hammock, set it up between two trees or supports. Ensure the hammock is secure and the rainfly is in place. Be sure the trees or supports are strong enough to hold your weight.

### Insulation
<!-- K: insulate, insulation, cold, pad, sleeping-bag -->

You can place insulating materials like leaves, grass, or clothing between you and the shelter walls or ground to retain body heat. This barrier prevents heat loss and keeps you warm. If you have a sleeping pad, place it under your sleeping bag for additional insulation.

## Repair
<!-- K: repair, duct-tape, tape, pin, safety-pin, glue, cordage -->
<!-- S: Use a sewing kit, duct tape, safety pins, glue, or cordage to repair tears or holes in clothing or gear. -->

### Sewing
<!-- K: sewing, stitch, back-stitch, running-stitch, whip-stitch, needle, thread -->

**Back stitch**

Used for seams that require strength, such as on backpacks or tents.

![](/assets/images/survival_guide/back_stitch.webp)

<!-- \pagebreak -->

**Running stitch**

Used for quick repairs on clothing or gear in places where strength is not critical.

![](/assets/images/survival_guide/running_stitch.webp)

<!-- \pagebreak -->

**Whip stitch**

Used to repair tears or holes in fabric. It can also be used to connect two pieces of fabric.

![](/assets/images/survival_guide/whip_stitch.webp)

<!-- \pagebreak -->

### Tarps
<!-- K: tarp, grommet -->

If your tarp's grommet breaks, you can still attach it to a rope by creating a button. A button is formed by wrapping a small rock in the tarp and securing your cordage around that using a clove hitch or jam knot.

If your tarp has a hole, you can repair it using duct tape or by sewing it shut.

### Other methods
If you do not have a sewing kit, you can use duct tape, safety pins, super glue, or cordage as temporary fixes.

<!-- \pagebreak -->

## Knots
<!-- K: knot, tie, cordage, cord, rope, paracord -->
<!-- S: Learn several knots to make the most of your cordage. -->

### Overhand knot
<!-- K: overhand -->

Used to prevent the end of a rope from untwisting. This is hard to undo but very easy to tie.

![](/assets/images/survival_guide/knot_overhand.webp)

<!-- \pagebreak -->

### Overhand loop
<!-- K: overhand-loop -->

Used to create a loop at the end of a line. In most cases, a bowline would be a better choice, but this knot is easy to tie.

![](/assets/images/survival_guide/knot_overhand_loop.webp)

<!-- \pagebreak -->

### Overhand bend
<!-- K: overhand-bend -->

Used to join two lines together. This knot is easy to tie but hard to undo. In most cases, a double sheet bend would be a better choice.

![](/assets/images/survival_guide/knot_overhand_bend.webp)

<!-- \pagebreak -->

### Double sheet bend
<!-- K: double-sheet-bend, join, two, 2 -->

Used for tying two lines together.

![](/assets/images/survival_guide/knot_double_sheet_bend.webp)

<!-- \pagebreak -->

### Bowline
<!-- K: bowline, loop, grommet, tarp -->

Used to create a loop at the end of a line. You can pass a line around a tree and through the bowline loop to secure the end of a line to the tree.

You can use a bowline to attach a line to a grommet on a tarp.

![](/assets/images/survival_guide/knot_bowline.webp)

<!-- \pagebreak -->

### Jam knot
<!-- K: jam-knot, loop, fasten, pole -->

Used to fasten a rope to a timber or pole. This can be used in place of lashings. It can be loosened by pulling on the knot at the end. It is hard to untie this knot.

![](/assets/images/survival_guide/jam_knot.webp)

<!-- \pagebreak -->

### Clove hitch
<!-- K: clove-hitch, pole, hitch -->

Used to fasten a rope to a timber or pole. It can be tied at any point in a rope.

![](/assets/images/survival_guide/knot_clove_hitch.webp)

<!-- \pagebreak -->

### Taut-line hitch
<!-- K: taut-line-hitch, tighten, hitch, pole, ridge-line -->

Used to tighten a line.

![](/assets/images/survival_guide/knot_tautline_hitch.webp)

<!-- \pagebreak -->

### Trucker's hitch
<!-- K: truckers-hitch, tighten, cinch, hitch, pole, ridge-line -->

Used to secure a load or tighten a line. Can be cinched down tighter than a taut-line hitch.

![](/assets/images/survival_guide/knot_truckers_hitch.webp)

<!-- \pagebreak -->

### Square lashing
<!-- K: square-lashing, lash -->

Used to secure one pole at a right angle to another pole. This lashing starts and ends with a clove hitch, though you can use an overhand or jam knot as well.

![](/assets/images/survival_guide/knot_square_lashing.webp)

<!-- \pagebreak -->

### Shear lashing
<!-- K: shear-lashing, lash, tripod -->

Used for lashing two or more poles next to each other. It can be used to construct a tripod. This lashing starts and ends with a clove hitch, though you can use an overhand or jam knot as well.

![](/assets/images/survival_guide/knot_shear_lashing.webp)

<!-- \pagebreak -->

## Craft: Cordage
<!-- K: cordage, rope, twine, fiber, twist, cord, strand, paracord, craft -->
<!-- S: You can make cordage from grasses and sedges. -->

Cordage can be made by twisting fibers together. It is weaker than rope but can be used for sewing, fishing line, or light-duty cordage.

**Resources**

Any fibrous material can be used to make cordage. Some examples include:

- Grasses and sedges (sedges are stronger)
- Bark or palm fiber

**Instructions**

1. Gather the fibers into a loose bundle.
2. Hold the bundle near the center and twist one side clockwise until a kink forms.
3. Fold the bundle in half at the kink.
4. Twist the top half clockwise.
5. Twist the two halves together counterclockwise.
6. Repeat the process until you have a full strand. If material is running out, add more material and twist it in.

![](/assets/images/survival_guide/craft_cordage.webp)

## Craft: Tent stakes
<!-- K: tent, stake, peg, craft -->
<!-- S: You can make tent stakes from sticks. -->

**Resources**

- A short stick
- A knife
- Something to use as a hammer, such as a rock or thick stick

**Instructions**

1. Sharpen one end of a stake to a point.
2. Hammer the stake into the ground at a slight angle, leaning away from your shelter.
3. Secure a line to your tent or tarp with a bowline.
4. Secure the other end of the line to the stake with a jam knot or hitch.
