---
title: "1 - Overview"
---

<!-- K: overview, survival, situation, rescue, lost -->
<!-- S: Be prepared, stop if lost, and think before acting. -->

This guide covers essential survival skills needed to increase your chances of returning safely from an emergency survival situation. It is not a substitute for professional training or experience and should only be used as a reference.

This guide is intended to be practical and to the point, with the sole purpose of getting you out of a survival situation. Therefore, most bushcraft and other techniques that the average hiker would find impractical have been left out.

If you are in a survival situation, try to stay calm and start with this chapter's "What to Do in a Survival Situation" section.

**This chapter is for informational purposes only and does not replace professional advice; use at your own risk and ensure compliance with local laws.**

## Be prepared
<!-- K: prepare, gear, knowledge, skill -->
<!-- S: Bring a survival kit with you on all trips, and let others know your plans. Learn how to act in a survival situation and signal for help. -->

Before entering the wilderness, you should be as prepared as possible. This means you should plan your route as well as alternative routes, pack the proper gear, learn the necessary skills, and tell at least one responsible adult your plans.

### Gear

The gear you bring will depend on your skill level, trip duration, trail popularity/remoteness, terrain, time of day, and weather.

On short nature hikes (under 2 hours), a phone with offline maps, a knife or multi-tool, a lighter, sunglasses, and a bottle of water may be sufficient. You can apply insect repellent or sunscreen before going out.

Many people carry a smartphone with them at all times, and while you shouldn't rely solely on it, it can be very helpful. To make the most of it, download an offline navigation app or maps and place money, bandages, and a Fresnel lens under the back of the case for emergencies.

**Necessities**:

- Cell phone (with offline maps if possible)
- Whistle
- Pepper or bear spray (check local laws)
- Spare batteries (for flashlight) and a battery pack for your phone
- Assorted bandages
- Gauze
- Surgical tape
- Safety pin or needle
- Tweezers
- Antibiotic ointment
- Sunscreen
- Insect repellent
- Prescription medications (including several days' worth of extra doses), contact lenses, and glasses
- Pain relievers (aspirin, ibuprofen, acetaminophen)
- Hand sanitizer
- Epinephrine auto-injector (if you have severe allergies)
- Asthma inhaler (if you have asthma)
- Emergency space blanket
- Poncho
- Extra socks
- Boots or sturdy shoes
- Sunglasses
- Cordage (paracord)
- Sewing kit (needle and thread)
- In colder climates:
  - Insulating layers (jacket, pants, hat, gloves)
  - Waterproof outer layer
  - Waterproof or insulated boots
  - Thermal underlayers
  - Hand warmers
- For overnight stays:
  - Change of clothing
  - Sleeping bag
  - Sleeping pad
  - Tent
  - Tarp
  - Bear bag or canister
- Water (enough for the duration of your trip, plus a bit extra)
  - Bring a water purification method for longer trips and plan your route to include water sources.
- Water containers (preferably a container that you can boil water in, such as a single-walled stainless steel bottle)
- Firestarter (lighter, waterproof matches, or fire steel)
- Food (enough for the duration of your trip, plus a bit extra). Don't bring food you have never eaten before. Some good options can include:
  - Nuts
  - Seeds
  - Dried fruit
  - Jerky
  - Energy bars
  - Dehydrated meals (with extra water)
  - Canned food (with a can opener if needed)
- Knife or multi-tool with a knife blade
- Map
- Compass
- Flashlight or headlamp
- 7-day weather forecast

**Optional**:

- Signal mirror

See each chapter for additional gear recommendations.

### Knowledge and skills
Start by learning how to do the following:

- Follow local laws and regulations
- Act in a survival situation
- Signal for help
- Plan a trip

See each chapter for additional knowledge and skills recommendations.

### Additional reading
This guide only covers a small portion of the vast knowledge of survival and bushcraft. If you want to learn about more skills, then I recommend the following books (not affiliated):

- *Bushcraft 101* by Dave Canterbury
- *SAS Survival Handbook* by John 'Lofty' Wiseman
- *Tom Brown's Field Guide to Wilderness Survival* by Tom Brown Jr., with Brandt Morgan
- *Wilderness & Travel Medicine* by Eric A. Weiss, MD

## What to do in a survival situation
<!-- K: think, observe, act -->
<!-- S: Stop, think, observe, plan, and act. The plan may often be to stay where you are and wait for help. -->

If you are in a survival situation, try not to panic and use the following steps as a guide.

### Stop
<!-- K: stop, first, important -->

The first and most important thing to do when lost is to stop moving. If you are in immediate danger in your current position, you can move, but otherwise, stay where you are. Use this time to calm down with deep breaths (in through your nose, out through your mouth or nose); you will get home.

### Think
Take a moment to think about your situation. Answer (but do not act on) the following questions:

- What are your immediate needs?
- What resources do you have available?
- Did you tell someone your plans before you left? If so, when are they expecting you back?
- Which way did you come from?

### Observe
Next, observe your surroundings and assess your situation. The first thing to do is check your smartphone or GPS receiver for your location. If you have a maps app, open it and check if a map is available. You can also check for a signal to call for help. If you have no luck there, then look around and listen for signs of people, vehicles, or trails. You can increase the range of your hearing by cupping your hands behind your ears. Lastly, observe where you are and look for potential hazards (weather/terrain/dangerous animals) or resources (water/shelter materials/firewood).

### Plan
<!-- K: plan, next, steps, help -->

Make a plan for your next steps. What you do next is going to depend on your current situation. Here's some general advice for actions you can take, ordered by importance:

- If you are badly injured, treat your injuries.
- If you are wet and have dry clothing, remove the wet clothing and put on the dry clothes. If you only have a dry blanket or sleeping bag, remove the wet clothes and wrap yourself in that.
- If the weather is bad, take shelter.
- Try to put in a call or text for help.
- If it is cold, get warm through insulation, shelter, and then fire (if easily started).
- If it is hot, find shade and slowly drink water.
- If it is close to dark, set up a shelter and maybe a fire.
- Start conserving food and water, but don't let yourself get thirsty.
- If you have a minor injury, treat it.
- Record your current location in your phone or GPS; if you have a bright piece of clothing, tie it to a tree where you can see it. This will help you to avoid getting even more lost.
- If you are out of water or just about to run out, find a water source and purify it.
- Signal for help using the techniques later in this chapter. Do this often for the best odds of being found.
- Try to determine your location using a map.
- Check for signs of the trail nearby, but always keep your initial location in sight.
- Identify nearby points of interest that you might be able to find on a map or hike to later if needed.
- If you are out of food, start thinking about how you will forage or catch something to eat. You can survive for weeks without food but will weaken over time.
- If you have been out for several days to a week, you may need to consider hiking out. Leave a sign that you were here and in which direction you went, such as something tied to a tree and an arrow nearby made of natural materials.

In summary, the priority is to treat severe injuries, seek shelter, signal for help, find water, build a fire (to stay warm and boil water), determine your location, check for ways out, find food, and last and only if you've been out there for a long time, hike out.

Your plan should adapt to your situation as it changes. Reevaluate often and stay hopeful that you will be found.

### Act
Once you have a plan, act on it. If at any point you feel unsafe, nervous, unsure, or your situation changes, then stop and reassess.

## Planning a trip
<!-- K: plan, trip -->
<!-- S: Research the terrain, weather, and wildlife before leaving. Plan a route on a map and bring the necessary supplies. Share this plan with someone you trust. -->

Before going into the wilderness, have a plan that you can stick to. Research the terrain, weather conditions, wildlife, and plants you might encounter. Check local regulations and any permits you may need. Use an up-to-date map to plan your route and some alternative routes if the trails are impassable. Also, look up trail conditions and the weather forecast for your trip. The wrong combination of weather and terrain can prove fatal, so be prepared.

Once you have a trip planned out, pack the necessary gear and supplies and check all of it to ensure it is functional. You should share your plan with at least one responsible adult, including the routes, who you are going with, when you will be back, and when you will contact them. If you don't have someone to whom you can tell these plans, leave a note with this information in a very visible place in your home. While you are hiking, stick to your route and avoid unnecessary risks.

## Signaling for help
<!-- K: signal, help, contact, find -->
<!-- S: Try your cell phone; it may be able to make emergency calls. Otherwise, use a whistle, signal mirror, smoke, flares, flashlight, or ground-to-air signals to attract attention. -->

Signaling for help will increase your odds of being found. You should do this often, even if you don't think anyone is nearby or can hear you.

### Cell phone
<!-- K: cell, phone, call, text, smartphone -->

Many phones can call emergency services even without a signal from your carrier. If you can't make a call, try sending a text message. Check your phone periodically to see if you have a signal, but otherwise, keep it off or in airplane mode to conserve battery. You may get a better signal by moving to higher ground or an open area.

### Satellite messengers and PLBs
<!-- K: satellite, messenger, PLB, beacon, personal-locator-beacon -->

A satellite messenger or personal locator beacon (PLB) can be used to send an SOS signal in an emergency situation. They are typically used in areas where your cell phone does not have a signal. PLBs can only send an SOS signal and are required to be registered, but they don't have a subscription fee. Satellite messengers require a subscription but usually allow you to send more types of messages.

On some smartphones, there may be a satellite feature available that can be used for this purpose. Visit your phone manufacturer's website or consult the user manual to see if this is available on your device.

### Whistle
<!-- K: whistle, sound, acorn -->

Three short blasts are the universal signal for help. You may want to cover your ears when using the whistle at full volume.

In a pinch, an acorn or bottle cap can be used as a whistle. Hold it with your thumbs as pictured below, then place your lips over your thumbs' knuckles and blow. It won't be as loud as a regular whistle, but it is usable.

![](/assets/images/survival_guide/acorn_whistle.webp)

### Signal mirror
<!-- K: mirror, sunlight, reflect -->

Hold the mirror with one hand and extend your other arm in front of you with your fingers in a V-shape and the target between your fingers. Reflect sunlight onto your fingers and slowly move the mirror up and down to flash sunlight at the potential rescuers. You can use a phone screen as a signal mirror, but it will be nowhere near as effective as an actual mirror and should be combined with another signal, such as smoke or a ground-to-air signal.

![](/assets/images/survival_guide/signal_mirror.webp)

### Smoke
<!-- K: smoke, fire, burn, signal -->

Smoke can attract attention during the day. Adding green vegetation to an established fire can create a lot of smoke, but be sure to do this safely. A fire at night can also be used to attract attention.

### Flares
<!-- K: flare -->

Flares are best seen at night or in low-visibility conditions. Follow the instructions on the flare packaging and be aware of any legal restrictions on their use.

### Flashlight
<!-- K: flashlight, light, SOS -->

At night, a flashlight or headlamp can be used to signal for help. Use the international distress signal, SOS, which is three short flashes, three long flashes, and three short flashes. If your flashlight changes modes when turned off and on, you can cover the light with your hand instead of turning it off. Aim it in the direction of aircraft or other potential rescuers.

### Ground-to-air signals
<!-- K: ground-to-air -->

Ground-to-air signals are large markers you create on the ground to communicate with aircraft. Use rocks, logs, or other materials to create a large "V" (means you require assistance) or an "X" (means you require medical assistance). Use contrasting or artificial colors to make the signal more visible.

![](/assets/images/survival_guide/ground_to_air.webp)

### Avalanche beacons
<!-- K: avalanche, beacon, transceiver -->

An avalanche beacon is a device that broadcasts a signal which can be picked up by other nearby transceivers. It can help rescuers locate you if you are buried in the snow of an avalanche.

## Disclaimer
This guide is provided for informational purposes only, and neither the author, publisher, nor any contributors guarantee its accuracy or suitability for any purpose. By using this guide, you acknowledge that outdoor activities involve risks, you do such activities at your own risk, and you agree to hold harmless and indemnify the author, publisher, and any contributors from any claims or damages arising from your use of this guide. Always consult professionals for advice specific to your situation, as this guide does not substitute for professional guidance. Furthermore, be aware that local laws and regulations may affect the legal use of the techniques described herein, and lawful compliance with the statutes of your jurisdiction is your responsibility.
