The Astronomy tool can be used to see when the sun or moon is up. It can also be used to know when astronomical events are happening, such as a meteor shower or lunar eclipse.

With the exception of the time until sunrise or sunset (always today), all information shown on the page is for the selected date. By default, today is selected, but you can change it by tapping the calendar icon at the top of the screen. On the calendar, you will see the moon phase, meteor showers, and eclipses for each day. Additionally, you can use the arrows to move to the next/previous date or long press the calendar to quickly jump to today's date.

You can also click the search icon to find the next occurrence of an astronomical event at your location, such as the next full moon or meteor shower.

## Time until sunrise/sunset

The time until sunrise or sunset is shown at the top of the screen. This respects the 'Sunrise/sunset times' in Settings > Astronomy. For a description of each time, see the Sun section below.

## Chart
The chart shows the position of the sun and moon throughout the day. The X-axis is time, and the Y-axis is the altitude or height in the sky. You can tap on the sun or moon icon in the chart to see its current position. When you do this, a slider will appear so you can see its position at a different time of the day.

You can also choose to keep the current time centered in the chart by enabling 'Keep sun/moon centered' in Settings > Astronomy. This will keep the current time centered in the chart when you have today selected and will show 12 hours before and after the current time. If you have a different date selected, it will show the entire day instead.

## Sun
All times related to the sun respect the 'Sunrise/sunset times' in Settings > Astronomy. For a description of each time, see below.

The time until sunrise or sunset is shown at the top of the screen.

The time of sunrise, sunset, and noon is shown below the chart, as well as the length of the day. If you tap this section, you will see more details about the sun for the current day:

- **Actual**: This is the actual time of sunrise, sunset, and noon. It is the time when the sun is at the horizon.
- **Civil**: This is the time of sunrise, sunset, and noon when the sun is between 0 and 6 degrees below the horizon. There is enough light to see objects clearly.
- **Nautical**: This is the time of sunrise, sunset, and noon when the sun is between 6 and 12 degrees below the horizon. The horizon is still visible, but it is too dark to see objects clearly.
- **Astronomical**: This is the time of sunrise, sunset, and noon when the sun is between 12 and 18 degrees below the horizon. It is completely dark, but it is perfect for stargazing.
- **Peak altitude**: This is the highest point the sun reaches in the sky. It is shown in degrees above the horizon.
- **Daylight**: This is the amount of time when the sun is up.
- **Night**: This is the amount of time when the sun is down.
- **Season**: This is the astronomical season based on the Earth's position around the sun. It will be one of the following: spring, summer, fall, or winter.
- **Altitude**: This is the current angle of the sun above the horizon. It is shown in degrees.
- **Direction**: This is the current direction the sun is in. It is shown in degrees.

## Moon
The time of moonrise, moonset, and lunar noon are shown below the chart, as well as the current moon phase and illumination percentage. If you tap this section, you will see more details about the moon for the current day:

- **Times**: This is the time of moonrise, moonset, and lunar noon.
- **Moon phase**: This is the current phase of the moon as it appears in the sky.
- **Illumination**: This is the percentage of the moon that is illuminated. A full moon is 100% illuminated, and a new moon is 0% illuminated.
- **Peak altitude**: This is the highest point the moon reaches in the sky. It is shown in degrees above the horizon.
- **Supermoon**: This is when the moon is closer to the Earth than normal, making it appear larger and brighter in the sky.

## Meteor showers
If a meteor shower peak is happening on the selected date at your location, it will show in the list. It displays the start, peak, and end times of the shower, as well as the average number of meteors per hour. You can tap on the shower to see more details:

- **Times**: This is the start, peak, and end times of the shower.
- **Name**: This is the name of the shower.
- **Rate**: This is the average number of meteors per hour.
- **Peak altitude**: This is the highest point the radiant (area where the meteors appear to come from) reaches in the sky. It is shown in degrees above the horizon.
- **Peak direction**: This is the direction the radiant is in.

## Lunar eclipses
If a lunar eclipse is happening on the selected date at your location, it will show in the list. It displays the start, peak, and end times of the eclipse, as well as how much of the moon is eclipsed. You can tap on the eclipse to see more details:

- **Times**: This is the start, peak, and end times of the eclipse.
- **Duration**: This is the duration of the eclipse.
- **Obscuration**: This is the percentage of the moon that is eclipsed.
- **Magnitude**: This is the magnitude of the eclipse. It is the fraction of the moon's diameter that is eclipsed.
- **Peak altitude**: This is the altitude of the moon at the peak of the eclipse. It is shown in degrees above the horizon.
- **Peak direction**: This is the direction the moon is in at the peak of the eclipse.

## Solar eclipses
If a solar eclipse is happening on the selected date at your location, it will show in the list. It displays the start, peak, and end times of the eclipse, as well as how much of the sun is eclipsed. You can tap on the eclipse to see more details:

- **Times**: This is the start, peak, and end times of the eclipse.
- **Duration**: This is the duration of the eclipse.
- **Obscuration**: This is the percentage of the sun that is eclipsed.
- **Magnitude**: This is the magnitude of the eclipse. It is the fraction of the sun's diameter that is eclipsed.
- **Peak altitude**: This is the altitude of the sun at the peak of the eclipse, shown in degrees above the horizon.
- **Peak direction**: This is the direction the sun is in at the peak of the eclipse.

## Sunset alerts
Alerts can be set for sunset to avoid being caught outside in the dark. To set an alert, open Settings > Astronomy and enable 'Sunset alerts'. You can adjust the 'Sunset alert time' setting to determine how far in advance you want to be notified. There is also a quick action available for the sunset alert. See below for more information.

You can choose to use the alarm audio channel for this alert by enabling Settings > Astronomy > Use alarm for sunset alert. This will play a sound as an alarm even if media and notifications are muted. 

## Sunrise alerts
Alerts can be configured for sunrise to ensure you don't miss the beginning of the day. To set up an alert, go to Settings > Astronomy and turn on 'Sunrise alerts'. You can adjust the 'Sunrise alert time' setting to decide how much advance notice you want. Additionally, there is a quick action option available for the sunrise alert. Refer to the information below for further details.

You can choose to use the alarm audio channel for this alert by enabling Settings > Astronomy > Use alarm for sunrise alert. This will play a sound as an alarm even if media and notifications are muted. 

## Astronomy alerts
Alerts can be set for astronomical events to ensure you don't miss them. To set an alert, open Settings > Astronomy and enable the alerts you want to be notified about for your location. You can receive notifications for meteor showers, lunar eclipses, and solar eclipses. The alert will be shown up to 24 hours in advance of the event start time.

## View in 3D
If your phone has a compass, you will see a "View in 3D" button. Clicking this will open the Augmented Reality tool with the selected date and allow you to see where the sun and moon will be throughout the day using your camera.

You can choose to disable the camera when clicked by disabling the "Settings > Astronomy > Use camera for 3D viewing" setting.

## Quick action
You can enable the Sunset Alert and Sunrise Alert quick action in the settings for the tab where you want it to appear.

To use the quick action, tap the sunset alert or sunrise alert quick action button to toggle it on or off.

## Widgets
The following widgets can be placed on your device's homescreen or viewed in-app:

- **Sun**: Shows the time of the next sunrise or sunset.
- **Moon**: Shows the phase of the moon.
- **Sun & moon chart**: The chart of the height of the sun and moon in the sky.