La herramienta Navegación puede usarse para navegar a una baliza, seguir una ruta o seguir un rumbo.

## Brújula

La brújula puede usarse tanto para orientación como para navegación. Tu rumbo se muestra en la parte superior de la pantalla.

Esta función no está disponible si tu dispositivo no tiene brújula.

### Cercanas

Puedes elegir mostrar las balizas cercanas en la brújula. Los siguientes ajustes controlan las balizas cercanas:

- **Ajustes > Navegación > Mostrar balizas cercanas**: Determina si se muestran balizas cercanas en la brújula.
- **Ajustes > Navegación > Radio de balizas cercanas**: Determina la distancia máxima a la que una baliza puede estar de tu ubicación para mostrarse en la brújula.
- **Ajustes > Navegación > Balizas cercanas**: Limita el número de balizas cercanas mostradas en la brújula.

Las balizas cercanas se mostrarán como flechas alrededor de la brújula. Las flechas apuntarán a la baliza y, cuando estés mirando hacia la baliza, se mostrará más información sobre ella en la parte inferior de la pantalla.

Si tienes activada la brújula radar, las balizas cercanas se mostrarán en la propia brújula.

### Brújula radar

La brújula radar muestra balizas, rutas y mareas cercanos como una visualización tipo radar similar a un mapa. La brújula radar está disponible con las balizas cercanas activadas. Una vez activadas las balizas cercanas, puedes activar la brújula radar en 'Ajustes > Navegación > Mostrar brújula radar de balizas cercanas'.

Puedes pellizcar para hacer zoom en la brújula radar, lo que cambiará el radio de balizas cercanas.

Si tu dispositivo no tiene brújula, aún puedes elegir mostrar las marcas del dial de la brújula activando 'Ajustes > Navegación> Mostrar marcas en dial de la brújula radar'. Ten en cuenta que sin un sensor de brújula, mover tu dispositivo no cambiará la dirección de la brújula radar.

Las capas se usan para mostrar información en la brújula radar. Puedes encontrar los ajustes de capas en 'Ajustes > Navegación' o manteniendo pulsada la brújula radar. Puedes ocultar o mostrar capas usando el interruptor junto al nombre de cada capa. El ajuste de opacidad para cada capa determina cuán transparente es la capa. 0 es totalmente transparente y 100 es totalmente opaco.

#### Elevación
Esta capa muestra la elevación del modelo digital de elevación (DEM) como color. Puedes cambiar el DEM en 'Ajustes > Altímetro'.

Ajustes:

- **Color**: La escala de color de los píxeles. El color cambiará según la elevación.

#### Sombreado de relieve
Esta capa dibuja sombras para ayudar a ver la elevación del terreno a partir del modelo digital de elevación (DEM). Puedes cambiar el DEM en 'Ajustes > Altímetro'.

#### Mapas Calibrados
Esta capa muestra los mapas calibrados visibles con el mapa más acercado apareciendo arriba. Puedes añadir nuevos mapas en la herramienta Mapas Calibrados.

Ajustes:

- **Cargar mosaicos PDF**: Si está activado, se cargarán mosaicos PDF para mapas que tengan una versión PDF disponible. Esto es más lento pero proporciona mapas de mayor resolución.

#### Curvas de nivel
Esta capa muestra líneas de contorno generadas a partir del modelo digital de elevación (DEM) y puede usarse para ver la pendiente y la elevación de las características del mapa. Puedes cambiar el DEM en Ajustes > Altímetro.

Ajustes:

- **Mostrar etiquetas**: Determina si se muestran etiquetas de curvas de nivel en el mapa.
- **Color**: El color de las líneas de contorno; algunas opciones son escalas de color que cambian según la elevación.

### Torres de telefonía
Esta capa muestra torres de telefonía cercanas con la precisión de la ubicación de la torre indicada como un círculo bajo la torre. Estas son ubicaciones aproximadas de torres de OpenCelliD, Mozilla Location Service y FCC Antenna Registrations.

#### Rutas
Esta capa muestra las rutas visibles. Puedes añadir nuevos rutas en la herramienta Rutas.

Ajustes:

- **Color de fondo**: El color de fondo detrás de las rutas para mayor visibilidad.

#### Balizas
Esta capa muestra las balizas visibles. Puedes añadir nuevas balizas en la herramienta Balizas.

#### Mareas
Esta capa muestra mareas visibles. Puedes añadir nuevas mareas en la herramienta Mareas.

#### Mi ubicación
Esta capa muestra tu ubicación, la dirección a la que miras (si tienes brújula) y la precisión del GPS.

Ajustes:

- **Mostrar precisión del GPS**: Determina si el círculo de precisión del GPS es visible.

### Brújula lineal

La brújula lineal se muestra cuando sostienes el teléfono en vertical. También puedes usar la función de brújula de puntería con la brújula lineal pulsando el icono de la cámara en el lado derecho de la pantalla. Esto mostrará la brújula superpuesta en el visor de la cámara. Con la brújula de puntería activa, puedes pellizcar para hacer zoom en el visor de la cámara.

Puedes activar o desactivar la brújula lineal en 'Ajustes > Navegación > Mostrar brújula lineal'.

### Referencia Norte

Por defecto, apuntará al Norte verdadero, pero puede configurarse para apuntar al norte magnético en los ajustes de la brújula. La referencia norte se muestra en la parte inferior de la pantalla.

### Sol y luna

La brújula muestra la dirección del sol y la luna, lo que te permite navegar usando ellos y verificar la precisión de la brújula. Puedes configurar la visualización del sol y la luna en 'Ajustes > Navegación > Mostrar sol/luna en la brújula'. Las opciones son:

- **Siempre**: Mostrar siempre el sol y la luna en la brújula.
- **Cuando estén arriba**: Mostrar el sol y la luna solo cuando estén por encima del horizonte.
- **Nunca**: Nunca mostrar el sol y la luna en la brújula.

### Calibración

Las brújulas de los teléfonos no siempre son precisas, por lo que debes calibrar tu brújula con frecuencia. Puedes calibrarla moviendo el teléfono en un patrón de figura de 8. Para instrucciones más detalladas y una visual, pulsa los iconos de estado en la esquina inferior izquierda de la herramienta Navegación. Esto te guiará en la calibración de la brújula y también mostrará detalles sobre la precisión de la ubicación.

## Navegación a balizas

Puedes navegar a una baliza pulsando el botón Navegar en la esquina inferior derecha. Esto abrirá la herramienta Beacons, donde puedes seleccionar una baliza a la que navegar. Consulta la guía Beacons para más información.

Mientras navegas a una baliza, la dirección se mostrará en la brújula y todas las demás balizas cercanas se volverán transparentes. Un panel de navegación se mostrará en la parte inferior de tu pantalla con la siguiente información:
- **Nombre**: El nombre de la baliza a la que navegas.
- **Coordenadas**: Las coordenadas de la baliza.
- **Distancia**: La distancia hasta la baliza.
- **Rumbo**: El rumbo hacia la baliza.
- **ETA**: El tiempo estimado de llegada a la baliza.
- **Elevación**: La elevación de la baliza.
- **Cambio de elevación**: La diferencia de elevación respecto a tu elevación actual.
- **Notas**: Cualquier nota que tengas para la baliza. Esto se mostrará como un icono si hay notas, y puedes pulsarlo para ver las notas.

Puedes dejar de navegar a una baliza pulsando el botón 'X'.

Puedes abrir la baliza pulsando el nombre de la baliza.

Puedes crear rápidamente una baliza desde tu ubicación actual manteniendo pulsado el icono de navegación en la esquina inferior derecha. Esto abrirá la herramienta Beacons con la ubicación y la elevación rellenadas.

Para más información sobre balizas, consulta la guía Beacons.

## Navegación por rumbo

Puedes navegar usando un rumbo pulsando la brújula para fijar un rumbo. El rumbo fijado se mostrará en la brújula y en el panel de navegación. Puedes pulsar la brújula de nuevo o pulsar el botón 'X' para borrar el rumbo.

Por defecto, los rumbos no cambian cuando te desplazas a otra ubicación. Si quieres mantener el rumbo fijado a tu ubicación inicial, puedes activar 
'Ajustes > Navegación > Bloquear rumbo a la ubicación'. Esto es similar a crear una baliza a distancia y navegar hacia ella.

## Navegación por rutas.

Si tienes activada la brújula radar, puedes ver rutas cercanas en la brújula. Actualmente no puedes navegar a lo largo de una ruta, pero puedes usar la brújula para ver dónde está la ruta en relación contigo. Si tienes Backtrack en ejecución, puedes ver tu posición actual en el sendero. Para más información, consulta la guía Rutas.

## Ubicación

Tu ubicación actual se muestra en la parte superior de la pantalla. Puedes pulsarla para ver más detalles sobre tu ubicación. El panel de detalles muestra la siguiente información:

- **Compartir**: Elige copiar tu ubicación al portapapeles, compartirla como código QR, abrirla en una app de mapas o compartirla como mensaje de texto.
- **Formato**: El formato de coordenadas para ver tu ubicación. Por defecto usa el formato que tienes en 'Ajustes > Unidades > Formato de coordenadas'. Los cambios hechos aquí son temporales y no cambiarán tu formato de coordenadas por defecto.
- **Precisión**: La precisión de tu ubicación.
- **Satélites**: El número de satélites usados para calcular tu ubicación.
- **Tiempo desde la última fijación**: El tiempo desde la última actualización de tu ubicación.
- **Datum**: El datum de la ubicación. Esto siempre será WGS 84.

Puedes mantener pulsada la ubicación para abrir rápidamente el menú de compartir.

## Elevación

Tu elevación se muestra en la esquina superior izquierda de la pantalla. Puedes pulsarla para ver un historial de tu elevación. El historial solo está disponible si tienes Backtrack o el seguimiento meteorológico en ejecución; consulta las guías Rutas o Meteorología para detalles sobre cómo activar esto. Puedes ajustar la duración del historial pulsando el desplegable 'Últimas 24h' en la parte superior del panel de historial.

## Velocidad

Tu velocidad se muestra en la esquina superior derecha de la pantalla. Puedes cambiar la fuente de la velocidad en 'Ajustes > Navegación > Velocímetro'. Las opciones son:

- **Velocidad actual (GPS)**: La velocidad reportada por tu GPS.
- **Velocidad media (Backtrack)**: La velocidad media calculada por Backtrack. Esto requiere que Backtrack esté en ejecución. Consulta la guía Rutas para más información.
- **Velocidad actual (Podómetro)**: La velocidad calculada por el podómetro de tu teléfono. Esto requiere que el podómetro esté en ejecución. Consulta la guía Podómetro para más información.
- **Velocidad media (Podómetro)**: La velocidad media calculada por el podómetro de tu teléfono desde que empezaste a registrar. Esto requiere que el podómetro esté en ejecución. Consulta la guía Pedometer para más información.

## Widgets
Los siguientes widgets pueden colocarse en la pantalla de inicio de tu dispositivo o verse dentro de la app:

- **Elevación**: Muestra tu elevación actual.
- **Ubicación**: Muestra tu ubicación actual.
