---
title: "2 - Medical"
---

<!-- K: medicine, medical, heal, health, injury, sick, ill, first-aid, symptom, treat, prevent, help -->
<!-- S: Calm down and apply first aid. -->

This chapter covers basic medical knowledge and techniques for common injuries and illnesses in the wilderness. 

**This chapter is for informational purposes only and does not replace professional advice, diagnosis, or treatment; use at your own risk, ensure compliance with local laws, and consult qualified healthcare providers whenever possible.**

## Be prepared
<!-- K: prepare, gear, knowledge, skill, painkiller, bandage, gauze, tape, pin, needle, tweezer, antibiotic, ointment, cream, sunscreen, repellent, spray, medicine, medication, prescription, pill, lenses, glasses, reliever, sanitizer, epinephrine, epi-pen, epipen, inhaler, moleskin, molefoam, tourniquet, splint, alo, vera, gel, swab, mirror, tampon, pad, menstrual, cup, floss, toothbrush, toothpaste, toilet-paper, bidet, bag, trowel, soap, towel, lip-balm, electrolyte -->
<!-- S: Bring a first aid kit. Learn basic first aid and CPR. -->

### Gear

**Necessities**:

- Assorted bandages
- Gauze
- Surgical tape
- Safety pin or needle
- Tweezers
- Antibiotic ointment
- Sunscreen
- Insect repellent
- Prescription medications (including several days' worth of extra doses), contact lenses, and glasses
- Pain relievers (aspirin, ibuprofen, acetaminophen)
- Hand sanitizer
- Epinephrine auto-injector (if you have severe allergies)
- Asthma inhaler (if you have asthma)

**Optional**:

- Wound closure strips/butterfly bandages
- Moleskin
- Molefoam
- Tourniquet
- C-Splint
- Aloe vera gel
- Antiseptic wipes
- Hydrocortisone cream
- Antihistamine pills (diphenhydramine; dye-free varieties are available)
- Super glue
- Cotton swabs
- Antidiarrheal medication (loperamide)
- Gas relievers (simethicone)
- Antacid tablets
- Mirror
- Tampons/pads/menstrual cup
- Dental floss
- Toothbrush
- Toothpaste (store this in your bear bag/container at night)
- Toilet paper and/or portable bidet
- Trash bags/container (check local regulations regarding toilet paper and human waste)
- Trowel
- Soap
- Washcloth/microfiber towel
- Lip balm
- Electrolyte mix

### Knowledge and skills

Start by learning how to do the following:

- Perform basic first aid and CPR.
- Calm yourself and others.

Once you have mastered these skills, you should learn how to do the following:

- Make charcoal (see the Fire chapter).
- Make tea from plants.
- Identify medicinal plants in your area.
- Perform advanced first aid/wilderness-medicine techniques, such as setting a broken bone or suturing a wound.

## Common medications
<!-- K: medication, medicine, pill, drug, aspirin, ibuprofen, acetaminophen, diphenhydramine, loperamide, simethicone, antacid, hydrocortisone, antibiotic, ointment, cream -->
<!-- S: Bring common medications with you. Only use as directed by your doctor and follow the manufacturer's instructions. -->

This is a list of common medications hikers might carry. It's not a complete list. Only use these in accordance with your doctor's recommendations and follow the package directions. Know the side effects, how much to take, and when to take them before your trip.

- **Aspirin**: A pain reliever used for headaches, sore muscles, joint pain, inflammation, and fevers. Many doctors recommend taking aspirin at the first signs of a heart attack, as it can help prevent further blood clots. High doses can lead to gastrointestinal bleeding.
- **Ibuprofen**: A pain reliever used for headaches, sore muscles, joint pain, inflammation, and fevers. It can cause stomachaches for some people.
- **Acetaminophen**: A pain reliever used for headaches, sore muscles, joint pain, or fevers.
- **Diphenhydramine**: An antihistamine used for allergies, itching, and sleeplessness. It may cause drowsiness.
- **Loperamide**: Used to treat diarrhea.
- **Simethicone**: A gas reliever used for gas pains.
- **Antacid tablets**: Used to treat heartburn and indigestion.
- **Hydrocortisone cream**: Soothes itchy or red skin from bites, rashes, or irritation.
- **Antibiotic ointment**: Helps prevent infection in minor cuts, scrapes, or burns.

## Allergic reactions
<!-- K: allergy, allergic, reaction, rash, itch, swell, hives, sneeze, cough, throat, breath, epinephrine, epi-pen, epipen, inject, asthma, anaphylaxis -->
<!-- S: Symptoms include rash, itching, swelling, hives, and difficulty breathing. Treat by removing the allergen, using antihistamines, or using an epinephrine auto-injector. Prevent by avoiding known allergens. -->

Allergic reactions can range from contact dermatitis (like poison ivy) or bug bites to anaphylaxis, a severe reaction that can be life-threatening.

### Symptoms

- Rash
- Itching
- Swelling
- Hives
- Runny nose
- Sneezing
- Coughing
- Scratchy throat

**Severe:**

- Difficulty breathing
- Swelling of the face, lips, or tongue

### Treatment

1. Remove the allergen if possible.
2. If there is a rash, apply calamine lotion or hydrocortisone cream.
3. Take antihistamine pills.

**Severe:**

Severe allergic reactions that affect breathing or cause swelling of the face, lips, or tongue require immediate medical attention. If you have an epinephrine auto-injector, use it:

1. Remove the safety cap.
2. Hold the injector with the tip against the thigh, midway between the hip and knee.
3. Press the injector into the thigh until it clicks.
4. Hold it in place for 10 seconds.
5. Repeat with a new injector in 5 to 15 minutes if symptoms persist.
6. Seek medical attention as soon as possible.

If you have asthma and are having an attack, use your inhaler.

### Prevention

- Avoid known allergens.
- Carry at least one epinephrine auto-injector if you have severe allergies.
- Take precautions for bug bites and poisonous plants (see the relevant sections).
- Tell others about your allergies and where your epinephrine auto-injector is kept.

## Altitude sickness
<!-- K: altitude, mountain, headache, nausea, fatigue, dizziness, breath, sleep, appetite, heartbeat, cough, acclimate, descend -->
<!-- S: Symptoms include headache, nausea, fatigue, dizziness, and shortness of breath. Treat by descending to a lower altitude or with pain relievers. Prevent by ascending slowly. -->

Altitude sickness is caused by low oxygen levels at high altitudes.

### Symptoms

- Headache
- Nausea
- Fatigue
- Dizziness
- Shortness of breath
- Poor sleep
- Loss of appetite
- Rapid heartbeat
- Coughing

### Treatment

- Take pain relievers (ibuprofen) for headache.
- Do not ascend until symptoms are gone.
- Descend to a lower altitude if symptoms are severe or do not improve within a day.

### Prevention

- Ascend slowly.
- Acclimate before ascending further.
- Watch for symptoms above 6,500 feet (2,000 meters).

## Bites, stings, and attacks

### Animals
<!-- K: bite, attack, animal, mammal, bell, fight, pepper-spray, bear -->
<!-- S: Treat by washing the wound with soap and water, applying antibiotics, bandaging, and seeking medical attention. Prevent this by avoiding wild animals and making noise to alert them of your presence. -->

Many animals bite when threatened, and some can transmit diseases.

#### Treatment

1. Wash the wound with soap and water.
2. Apply antibiotic ointment.
3. Cover the wound with a bandage. Pack deep wounds with gauze but do not suture or tape them closed.
4. Seek medical attention if the wound is deep, bleeding, or shows signs of infection.

If a mammal bit you, seek medical attention as soon as possible; you may need rabies shots.

#### Prevention

- Do not approach, corner, or feed wild animals.
- Use a bear bell or make noise to alert animals of your presence.
- Avoid animals with young nearby.
- If approached by an animal:
  - Don't run, as this may trigger a chase.
  - Make yourself look big.
  - Make noise (not high-pitched screaming).
  - Pick up children and pets.
  - Back away slowly or move sideways.
  - Use bear or pepper spray if available.
  - Fight back if attacked, except for grizzly bears.
    - Aim for eyes, nose, or throat with rocks, sticks, or hands.
    - If a **grizzly bear** attacks, play dead unless it stalks you, attacks in your tent, or continues attacking-then fight back.
  - Keep your backpack on; it can offer protection.
  - Protect your vital areas (neck, head, and chest).

### Leeches
<!-- K: leech, bite, suck, blood, remove -->
<!-- S: Treat by removing the leech with a fingernail or flat object and cleaning the area. Prevent this by using insect repellent and wearing long sleeves and pants. -->

Leeches attach to your skin and suck your blood. They can be found in freshwater lakes, ponds, marshes, and on jungle vegetation.

#### Symptoms

- Leech attached to the skin
- Bleeding
- Swelling
- Pain

#### Treatment

1. Hold the rear of the leech (the fatter end) and pull it taut (but not too tight). If the rear is suctioned to your skin, a fingernail can be used to detach it.
2. Slide a fingernail or other flat object between the leech's head (the smaller end) and your skin to detach it.
3. Flick the leech away before it can reattach.
4. Clean the wound and apply antibiotic ointment.
5. Apply a bandage to control bleeding. It is normal for the wound to bleed for a while.

Do not salt, burn, or pull the leech off, as this can cause it to regurgitate into the wound.

![](/assets/images/survival_guide/leech_removal.webp)

#### Prevention

- Use insect repellent.
- Wear long sleeves and pants.
- Check for leeches frequently.

### Snakes
<!-- K: snake, bite, venom, poison, antivenom, snakebite -->
<!-- S: Treat by cleaning the wound, applying a bandage, immobilizing the limb, and seeking medical attention. Prevent this by watching where you step and wearing high boots. -->

Always check your path for snakes, especially in areas with tall grass, loose rocks, or logs. In hot and arid regions, snakes may hide in shaded areas, under brush or debris, or in holes. In temperate areas, snakes may be in areas exposed to the sun. Most snakes are nonvenomous, but if you don't know the type of snake, treat the bite as venomous.

#### Treatment

1. Rinse the bite area with water.
2. Clean the wound and cover with a bandage.
3. Remove any rings or jewelry from the affected limb.
4. Wrap the limb with a bandage, starting at the bite and moving up the limb. The bandage should be tight but not cut off circulation. You should be able to slip a finger under the bandage. If you are bitten by a pit viper (like a rattlesnake), do not bandage or apply compression as this can lead to increased tissue damage.
5. Keep the limb immobilized, as you would a fracture, and below the level of the heart.
6. Seek medical attention as soon as possible. Call the hospital ahead of time so they can prepare antivenom if needed.

Do not do the following:

- Cut the wound.
- Suck out the venom.
- Apply a tourniquet.
- Apply ice.

#### Prevention

- Watch where you step.
- Wear high boots.
- Do not put your hands or feet somewhere you cannot first see.
- Do not try to catch or kill snakes unless you know they are not venomous.

### Insects, spiders, and scorpions
<!-- K: bug, bite, repel, spray, sting, insect, spider, scorpion, mosquito, ant, bee, wasp, hornet, fly, itch, swell, red, remove -->
<!-- S: Treat by removing the stinger/tick/leech, cleaning the area, and, if needed, seeking medical attention. Prevent this by using insect repellent and wearing long sleeves and pants. -->

Many insects can bite or sting you, causing pain, swelling, and itching. Some insects can also transmit diseases.

#### Symptoms

- Itching
- Swelling
- Redness
- Pain

#### Treatment

**Bites**

To reduce itching, avoid scratching and apply calamine lotion or hydrocortisone cream. To reduce swelling, use a cloth soaked in cold water or filled with snow/ice.

If you were bitten by a spider you believe to be venomous, treat it as you would a snakebite and seek medical attention.

**Stings**

Remove any stingers, taking care not to squeeze the venom sac. Treat it as if it were a bug bite.

If you were stung by a scorpion or insect you believe to be venomous, treat it as a snakebite and seek medical attention.

**Bugs in eyes**

See the section on objects in the eye.

#### Prevention

- Use insect repellent.
- Wear long sleeves and pants.
- Wrap your face with a bandana.
- Wear glasses/sunglasses (to keep bugs out of your eyes).
- Use a bug net.
- Ensure your immunizations are current for bug-borne diseases in the area.

You can make an improvised bug repellent by applying mud to your skin or using fire smoke.

### Ticks
<!-- K: bite, repel, spray, tick, itch, swell, red, remove -->
<!-- S: Treat by removing the tick, cleaning the area, and, if needed, seeking medical attention. Prevent this by using insect repellent and wearing long sleeves and pants. -->

Ticks attach to your skin and will feed on your blood. They can transmit diseases such as Lyme disease and Rocky Mountain spotted fever.

#### Symptoms

- Itching
- Swelling
- Redness
- Attached tick

#### Treatment

1. Using tweezers or a tick spoon if available, grasp the tick where it is attached to the skin. You may be able to use your fingernails if they are long enough.
2. Pull straight out with steady, even pressure. Do not twist or jerk the tick. Do not squeeze the tick's body.
3. Treat the area as you would for a bug bite.

![](/assets/images/survival_guide/tick_removal.webp)

#### Prevention

- Use insect repellent.
- Wear long sleeves and pants.
- Check for ticks frequently, especially if using dry leaves and grass as insulation.

### Jellyfish
<!-- K: jellyfish, sting, tentacle -->
<!-- S: Treat by removing tentacles, rinsing with seawater, and applying heat. Prevent this by avoiding jellyfish. -->

Many jellyfish have small, venomous stinging cells, typically on tentacles. Even dead jellyfish can sting.

#### Symptoms

- Pain
- Itching
- Redness
- Rash
- Swelling

#### Treatment

1. Use the edge of a credit card, tweezers, or stick to remove the stingers.
2. Rinse the area with seawater (or vinegar if you somehow have it on you). Do not rinse with fresh water, as this can cause the stingers to release more venom.
3. Soak the area in hot water for 30 minutes.
4. Take pain relievers if needed.

## Bleeding
<!-- K: bleed, blood, wound, cut, scrape, deep, clot, pressure, tourniquet, bandage, red, swell, warm, pus -->
<!-- S: Treat by applying pressure, cleaning the wound, bandaging, and, if needed, seek medical attention. Prevent infection by cleaning wounds and changing bandages frequently. -->

### Treatment
Seek medical attention if the wound is deep, bleeding profusely, or shows signs of infection. Infected wounds can be identified by redness, swelling, warmth, and pus.

**Scrapes and minor cuts**

1. Clean the wound with water.
2. Optionally, apply antibiotic ointment.
3. Apply a bandage. You can use medical-grade super glue if needed.

**Deeper cuts**

1. Apply pressure to the wound with a clean cloth or bandage. You may need to apply pressure for about 10 to 20 minutes to get the bleeding to stop, longer if on blood thinners.
2. Clean the wound and irrigate it with water.
3. Bandage the wound with a sterile dressing.
4. Place new bandages over the old ones if they become soaked with blood.
5. Raise the wound above the level of the heart.
6. Seek medical attention if bleeding does not stop or if the wound is deep.

You can apply a tourniquet to stop blood flow to a limb if direct pressure does not work. This should only be done as a last resort, as it can cause permanent damage. Only a medical professional should remove a tourniquet.

### Prevention

- Use caution when handling sharp objects.
- Do not cut toward yourself.
- Watch your footing.
- Be aware of your surroundings.
- To prevent infection:
  - Clean wounds.
  - Use antibiotic ointment.
  - Change bandages frequently.

## Blisters
<!-- K: blister, rub, shoe, sock, moleskin, red, sore -->
<!-- S: Treat small blisters by applying moleskin and large blisters by draining with a sterilized needle, cleaning, and bandaging. Preventing this by keeping feet dry and wearing properly fitting shoes. -->

### Symptoms

- Red, sore area
- Blister

### Treatment
If the blister is small:

1. Cut a doughnut-shaped piece of moleskin.
2. Place the moleskin around the blister, with the blister in the hole.

If the blister is large or painful:

1. Sterilize a needle with hand sanitizer or fire.
2. Pierce the blister near the edge and drain the fluid.
3. Clean and wash the area.
4. Apply a bandage and, optionally, antibiotic ointment.

### Prevention

- Keep feet dry.
- Wear properly fitting shoes.
- Wear two pairs of socks.
- Check feet frequently for red areas and blisters.
- Stop hiking at the first sign of your skin rubbing against your boots.
- Apply adhesive tape or moleskin to prevent blisters.

## Burns
<!-- K: burn, scald, blister, red, pain, aloe, vera, fire, skin -->
<!-- S: Treat minor burns by soaking with cool water and loosely bandage. Seek medical attention for severe burns. Prevent by using caution around fires and hot objects. -->

### Treatment

**First-degree burns**

This is about the level of a mild sunburn.

1. Soak with cool water for 5 minutes.
2. Optionally, take pain relievers.
3. Apply aloe vera gel, calamine lotion, or hydrocortisone cream.

**Second-degree burns**
This is a burn that blisters and can be very painful. 

1. Soak with cool water for at least 15 minutes.
2. Take pain relievers.
3. Pat the area dry.
4. Apply a loose bandage.

Do not pop blisters.

**Third-degree burns**
This is a burn that goes through all layers of skin and may be life-threatening. Pain may be minimal due to nerve damage. Second-degree burns are likely also present.

1. Call emergency services.
2. Soak with cool water.
3. Remove clothing and jewelry from the area.
4. Drink water with electrolytes.
5. Bandage loosely.

### Prevention

- Use caution around fires, especially when wearing synthetic clothing.
- Do not touch hot objects.
- If your clothes catch fire, stop, drop to the ground, and roll to extinguish the flames.

## Choking
<!-- K: choke, throat, breath, heimlich, maneuver -->
<!-- S: Perform the Heimlich maneuver. -->

If you are choking and someone is nearby, place your hands on your throat to signal that you are choking.

### Treatment
Perform the Heimlich maneuver on yourself:

1. If possible, bend over a hard surface.
2. Make a fist with one hand.
3. Place the thumb side of your fist against your abdomen, below your ribcage and above your navel.
4. Grasp your fist with your other hand and press into your abdomen with a quick upward thrust.

Perform the Heimlich maneuver on someone else (only perform this if you know they are choking, upright, and have signaled for help):

1. Stand behind the person.
2. Reach around the person's waist.
3. Make a fist with one hand.
4. Place the thumb side of your fist against the person's abdomen, below the ribcage and above the navel.
5. Grasp your fist with your other hand and press into the person's abdomen with a quick upward thrust.

![](/assets/images/survival_guide/choking.webp)

## Cramps
<!-- K: cramp, muscle, pain, spasm, weak, electrolyte -->
<!-- S: Treat by stretching, massaging, applying heat or cold, and hydrating. Prevent by staying hydrated and replenishing electrolytes. -->

Cramps can be caused by dehydration, overexertion, or lack of electrolytes.

### Symptoms

- Muscle pain
- Muscle spasms
- Muscle weakness

### Treatment

- Gently stretch the muscle.
- Massage the muscle.
- Apply heat or cold to the muscle.
- Drink water or an electrolyte solution containing sodium and potassium.
- Eat salty foods.
- Eat potassium-rich foods (such as bananas or potatoes).
- Slow down or stop physical activity.

### Prevention

- Stay hydrated.
- Replenish electrolytes.
- Warm up your muscles before physical activity.
- Stretch before and after physical activity.
- Maintain a slow and steady pace.

## Dehydration
<!-- K: dehydrate, water, thirst, dry, fatigue, dizziness, dark, urine, headache, confusion, electrolyte, drink -->
<!-- S: Rehydrate by drinking water with electrolytes. Prevent by drinking water frequently and increasing intake during physical activity. -->

### Symptoms

- Thirst
- Dry mouth and throat
- Fatigue
- Dizziness
- Dark urine
- Reduced urine output
- Dry skin
- Headache
- Confusion
- Nausea

### Treatment
Rehydrate by slowly drinking water, an electrolyte solution, or another non-alcoholic beverage. Avoid diuretics.

### Prevention

- Drink water frequently, increasing intake during physical activity.

## Embedded fishhooks
<!-- K: fishhook, hook, remove -->
<!-- S: Hooks can be removed by running a line through the bend and pulling quickly while pushing down on the hook. Prevent by handling hooks with care. -->

Fishhooks are designed to penetrate flesh and are difficult to remove without causing further injury. Unless you need to remove the hook to prevent further injury, it's best to leave the hook in place and seek medical attention.

### Treatment
Do not attempt to remove a fishhook if it is embedded in the eye.

**Method 1**

1. Advance the hook through the skin until the barb is exposed.
2. Cut the barb off with wire cutters like those on a multitool or pliers.
3. Pull the hook opposite from how it entered; it should come out easily.
4. Clean the wound and apply antibiotic ointment.

**Method 2**

1. Run a fishing line or cordage through the bend of the hook.
2. Grab the ends of the line.
3. Apply downward pressure on the eye of the hook.
4. Quickly pull the line, causing the hook to come out the way it went in.
5. Clean the wound and apply antibiotic ointment.

In some cases, you may be able to use a pair of pliers instead of the fishing line to perform the same motion.

![](/assets/images/survival_guide/fish_hook_removal.webp)

### Prevention

- Be careful when handling fishhooks, especially lures with multiple treble hooks.
- Be extra careful when removing a hook from a thrashing or slippery fish.
- Barbless hooks are easier to remove if you get hooked, but it can be more difficult to successfully land the fish.

## Fractures
<!-- K: fracture, break, broken, bone, pain, swelling, bruise, deform, weight, splint, sling, set, arm, leg -->
<!-- S: Treat by splinting and seeking medical attention. Prevent this by being cautious and wearing proper footwear. -->

A fracture is a broken bone. A fracture can be closed (bone is broken, but skin is intact) or open (bone is broken and protruding from the skin).

### Symptoms

- Pain
- Swelling
- Bruising
- Deformity
- Loss of function
- Inability to bear weight
- Bone protruding from the skin

### Treatment
If the bone is out of place and medical attention is unavailable for several hours, you may need to set it. Otherwise, splint it in place and seek medical attention.

**Setting a bone**

1. Irrigate and clean the wound if the bone is protruding.
2. Grab the limb below the fracture.
3. Pull the limb to straighten the bone. It may pop into place, and pain may decrease.
4. Splint the bone while holding it in place.
5. Cover the open wound with a sterile dressing and bandage.

**Splinting a bone**

1. Remove all jewelry and tight clothing from the area.
2. Apply padding around the fracture.
3. Construct a splint using a rigid object (stick, trekking pole, tent pole). It should extend past the bone break on both sides.
4. Secure the splint with bandages, tape, or cordage. It should be tight but not cut off circulation. If splinting a finger, tape it to the one next to it.
5. Apply a sling if the fracture is in the arm to help immobilize the limb. You can create a makeshift sling by placing your arm in a jacket or cloth and tying the loose ends behind your neck.


Splint:

![](/assets/images/survival_guide/splint.webp)

<!-- \pagebreak -->

Sling:

![](/assets/images/survival_guide/sling.webp)

### Prevention

- Be cautious when walking on uneven terrain.
- Wear proper footwear.
- Do not overexert yourself.
- Be careful when handling heavy objects.

## Frostbite
<!-- K: frostbite, frost, cold, freeze, frozen, numb, white, gray, yellow, waxy, pain, thaw, warm, heat, red, frostnip -->
<!-- S: Treat by rewarming the area and seeking medical attention. Prevent by staying warm and dry. -->

Frostbite is caused by exposure to cold temperatures, which freezes the skin and underlying tissues. If not treated, it can lead to permanent damage.

### Symptoms

**Frostnip**:

- Redness
- Numbness
- Pale or white skin
- The area is still soft and pliable

**Frostbite**:

- White or grayish-yellow skin
- Hard or waxy skin
- Numbness

### Treatment

**Frostnip**: 

Rewarm the area using body heat (such as placing a hand under the armpit), warm water, or a hand warmer.

**Frostbite**:

Only thaw the area if you can keep it thawed. Refreezing can cause more damage. Do not use a fire to thaw the area. Do not rub the area. Seek medical attention as soon as possible.

1. Take pain medicine before thawing.
2. Prepare hot water (104-108°F/40-42°C).
3. Thaw the area for 30 to 45 minutes or until it is pink/red and soft. If the water cools, change it-remove the area from the water before changing it.
4. Wrap the area in a sterile dressing and keep warm.

### Prevention

- Bring and wear proper clothing.
- Keep dry and change out of wet clothing.
- Keep moving.
- Keep warm.
- Stay hydrated and well-fed.
- Treat at the first sign of frostnip.

## Gastrointestinal issues
<!-- K: gastrointestinal, stomach, gut, diarrhea, vomit, nausea, cramp, gas, food, water, poison, charcoal, tea, parasite, constipated -->
<!-- S: Treat by rehydrating or using medicine. Prevent this by boiling water, washing hands, cooking, and storing food properly. -->

Gastrointestinal issues can be caused by contaminated food or water.

### Symptoms

- Diarrhea
- Vomiting
- Nausea
- Stomach cramps
- Gas

### Treatment

- Rehydrate with purified water.
- Drink a cup of tea every few hours. You can make tea by boiling the following plants:
  - For diarrhea:
    - Blackberry/brambles roots
    - Cranberry or hazel leaves
    - White oak bark
  - For constipation:
    - Dandelion leaves
    - Rose hips
    - Walnut bark
  - For gas and cramps:
    - Mint leaves
- Eating campfire ash or ground charcoal (mixed into water) can also help with diarrhea.
- If you ate something poisonous, seek medical help immediately.

### Prevention

- Boil water before drinking.
- Wash hands before eating.
- Cook food thoroughly.
- Only eat foods you know are safe.
- Store food properly.

## Headache
<!-- K: headache, pain, electrolyte -->
<!-- S: Treat by taking pain relievers, drinking water, and resting. Prevent by staying hydrated and replenishing electrolytes. -->

Headaches can be caused by various factors, such as dehydration, stress, lack of sleep, eye strain, tight muscles, or illness.

### Treatment

- Take pain relievers.
- Drink water or an electrolyte solution.
- Rest.
- Eat salty foods.
- Massage tight muscles in your upper body.

### Prevention

- Stay hydrated.
- Replenish electrolytes.
- Wear sunglasses if needed.
- Do not overexert yourself.

## Heart problems
<!-- K: heart, chest, pain, arm, back, neck, jaw, stomach, attack, stroke, exhaustion, sweat, nausea, lightheaded, breath, heartbeat, cpr -->
<!-- S: Seek medical attention for chest pain. Symptoms include chest pain, shortness of breath, pain in limbs, nausea, lightheadedness, and cold sweats. -->

To be safe, seek medical attention as soon as possible if you experience symptoms of heart problems.

### Symptoms

- Chest pain
- Shortness of breath
- Pain in the arms, back, neck, jaw, or stomach
- Nausea
- Lightheadedness
- Cold sweat

### Treatment

1. Stop and sit comfortably.
2. If you have as-needed heart medication, take it. Otherwise, take aspirin. Chew the aspirin for faster absorption.
3. Call emergency services and have help come to you.

If someone else becomes unresponsive and you suspect heart problems:

**CPR**:

1. Check for responsiveness, breathing, and pulse.
2. Call emergency services and start CPR. You can put your phone on speaker to do the two at the same time.
3. Make sure the person is on their back on a hard, stable surface.
4. Place the heel of one hand on the center of the chest.
5. Place the heel of the other hand on top of the first hand.
6. Interlock fingers.
7. Keep your arms straight and your shoulders directly over your hands.
8. Push hard and fast at least 2 inches (5 cm) at 100 to 120 compressions per minute.
9. Let the chest rise completely between compressions.
10. Continue until the patient is responsive, emergency services arrive, or you are too exhausted to continue.

If you are fully trained in CPR, perform rescue breathing after 30 compressions. Otherwise, just do compressions.

![](/assets/images/survival_guide/cpr.webp)

**Rescue breathing**:

1. With the airway clear, tilt the head back and lift the chin.
2. Pinch the nose shut.
3. Give two breaths, each lasting about 1 second and causing the chest to rise.
4. Repeat the cycle of 30 compressions and two breaths.

### Prevention

- Stay hydrated.
- Do not overexert yourself.
- Talk to your doctor about your heart health and risk factors.
- Seek medical attention if you have symptoms of heart problems.

## Heat exhaustion and heatstroke
<!-- K: heat, exhaustion, stroke, heatstroke, pale, hot, sweat, fatigue, heartbeat, dizziness, nausea, vomit, cramp, muscle, headache, chill, confusion, seizure, unconscious, electrolyte, shade, break, overexert -->
<!-- S: Symptoms include pale skin, sweating, fatigue, rapid heartbeat, dizziness, nausea, muscle cramps, headache, and chills. Treat by moving to a cool place and drinking water. Prevent by staying hydrated, wearing proper clothing, and taking breaks in the shade. -->

Heat exhaustion and heatstroke are caused by exposure to high temperatures and dehydration.

### Symptoms

**Heat exhaustion**: 

- Pale skin
- Sweating
- Fatigue
- Rapid heartbeat
- Dizziness
- Nausea or vomiting
- Muscle cramps
- Headache
- Chills

**Heatstroke**:

- Same symptoms as heat exhaustion, but more severe
- Confusion
- Seizures
- Unconsciousness

### Treatment

**Heat exhaustion**:

1. Move to a cool place.
2. Slowly drink a lot of water or an electrolyte solution.
3. Douse yourself with water or slowly immerse yourself in water.

**Heatstroke**:

1. Call emergency services.
2. Move to a cool place.
3. Remove excess clothing.
4. Immerse yourself in water.
5. Be cautious when rehydrating, as seizures and vomiting can lead to choking.

### Prevention

- Stay hydrated.
- Wear proper clothing.
- Stay in the shade.
- Take breaks in the shade.
- Avoid physical activity during the hottest part of the day.
- Do not overexert yourself.

## Hygiene
<!-- K: hygiene, clean, dry -->
<!-- S: Wash hands frequently, especially before eating and after using the bathroom. -->

### Washing
<!-- K: wash, soap, shampoo, sanitize, hands -->

If you do not have soap, you can substitute white ashes, sand, or loamy soil.

Wash hands:

- Before and after preparing food.
- Before eating.
- After urinating or defecating.
- Before dressing a wound.
- After touching something likely to carry germs or be poisonous.

### Teeth
<!-- K: teeth, tooth, toothbrush, toothpaste, floss, brush -->

If you do not have a toothbrush, you can clean your teeth with a small stick (fray it by chewing on one end) or a piece of cloth. An inner strand of paracord can be used as dental floss. You can grind up charcoal and combine it with water to make a mildly abrasive toothpaste.

### Feet
<!-- K: foot, feet, sock, shoe -->

Do the following to prevent foot problems:

- Change and wash socks daily.
- Wash, dry, and massage your feet.
- Check frequently for blisters and red areas. Use adhesive tape/moleskin to prevent blisters.

### Clothing
<!-- K: clothes -->

Keep clothing clean and dry. Wash clothes with water and soap or boil them. To dry clothes, lay them in the sun on rocks, or hang them in the sun or near a fire (not too close).

### Bowel movements and urination
<!-- K: defecate, urinate, bathroom, waste, trowel, dig, hole -->

- Dig a hole 6 to 8 inches (15 to 20 centimeters) deep for bowel movements and cover it with dirt.
  - If you do not have a trowel, use a stick to dig the hole.
- If you do not have toilet paper or a bidet, use non-poisonous leaves, moss, or smooth rocks to clean yourself.
- Always wash your hands after using the bathroom.
- Do not defecate or urinate near water sources (at least 200 feet/60 meters away).

## Hypothermia
<!-- K: hypothermia, cold, freeze, frozen, shiver, coordination, memory, speech, slur, speak, drowsiness, breath, heartbeat, heat, warm, fire -->
<!-- S: Symptoms include shivering, coldness, impaired coordination, memory loss, slurred speech, and drowsiness. Treat by getting dry and warming up. Prevent by wearing proper clothing, keeping dry, moving, and keeping warm. -->

Hypothermia is caused by exposure to cold temperatures, causing the body to lose heat faster than it can produce.

### Symptoms

- Shivering. If shivering stops and you have not warmed up, it is a sign of severe hypothermia.
- Coldness
- Impaired coordination
- Memory loss
- Slurred speech
- Drowsiness
- Slow breathing and heart rate

### Treatment

- Change into dry clothes.
- Increase layers of dry clothing.
- Add insulation into clothing (such as dry leaves).
- Consume warm liquids.
- Warm near a fire.
- Use a sleeping bag or blanket.
- Use the body heat of another person.

### Prevention

- Wear proper clothing.
- Keep dry.
- Keep moving.
- Keep warm.

## Objects in the eye
<!-- K: eye, object, something, bug -->
<!-- S: Treat by irrigating the eye with clean water and removing the object with a damp cloth or cotton swab. Prevent by wearing glasses or sunglasses. -->

It is common to get objects in your eye while in the wilderness, such as dirt, sand, bugs, or an eyelash.

### Symptoms

- Pain and discomfort of the eye
- Redness of the eye
- Excess tearing
- Difficulty keeping the eye open

### Treatment

1. Avoid rubbing the eye.
2. Using clean water, irrigate the eye by pouring water into the eye.
3. If the object is still in the eye, use a mirror to locate it and attempt to remove it using a damp cloth or cotton swab. Be very gentle.
4. If the object is under the upper eyelid and you have a partner, have them place the tip of a cotton swab in the middle of your upper eyelid and gently fold the eyelid over the cotton swab. They can then remove the object using a damp cloth or cotton swab.
5. After the object is removed, if the eye feels scratchy, place a cold, damp cloth over it, keep the eye closed and rest, use eye drops, or construct an eye patch using a bandage or cloth.
6. Seek medical attention if the object is not removed or symptoms persist.

### Prevention

- Wear glasses or sunglasses.
- Don't lift objects with dirt or loose debris on them above your head without eye protection.
- Carefully apply bug repellent on your face to deter bugs from going near your eyes.

## Panic attacks and calming techniques
<!-- K: panic, attack, fear, heartbeat, sweat, tremble, breath, chest, pain, nausea, dizziness, numb, tingle, calm, meditate, technique -->
<!-- S: Symptoms include rapid heartbeat, sweating, trembling, shortness of breath, chest pain, nausea, dizziness, fear, numbness, and tingling. Treat using a calming technique, such as meditation. -->

### Symptoms

- Rapid heartbeat
- Sweating
- Trembling
- Shortness of breath
- Hyperventilation
- Chest pain
- Nausea
- Dizziness
- Fear
- Numbness or tingling

### Treatment

1. Sit down.
2. Close your eyes.
3. Do one or more of the following:
   - Take slow, deep breaths in through your nose, out through your nose or mouth.
   - Count to 10.
   - Recite a calming phrase.
   - Visualize a calming place.
   - Meditate.
   - Tense up and relax each muscle starting at your head and working down to your feet.
   - Listen to music or white noise.
   - Assure yourself that you will be okay.

## Poison ivy and contact dermatitis
<!-- K: poison, ivy, oak, sumac, trumpet, rengas, stinging, nettle, rash, itch, blister, red, swell, dermatitis, contact -->
<!-- S: Symptoms include a rash, itching, and blisters. Treat by washing the area with soap and water, applying calamine lotion, and taking antihistamines. Prevent by learning to identify and avoid poisonous plants. -->

Contact dermatitis is caused by contact with poisonous plants, such as poison ivy/poison oak, poison sumac, stinging nettle, and many other plants around the world (always check what is dangerous in your area).

![](/assets/images/survival_guide/dangerous_plants.webp)

1. **Poison ivy**: A toxic plant with three glossy, pointed leaflets, commonly found in forests, fields, and along trails. Contact with its oil causes itchy rashes and skin irritation.
2. **Stinging nettle**: A plant with serrated leaves and tiny stinging hairs, commonly found in moist, shaded areas. Contact causes a painful, itchy rash.

### Symptoms

- Burning, reddening, and swelling rash
- Itching
- Blisters

### Treatment

1. Try to remove oil from the plant using soap and water with vigorous scrubbing (imagine trying to remove oil from your skin). Sand or dirt can be used as a substitute, unless there are blisters.
2. Dry the area.
3. Apply calamine lotion or hydrocortisone cream to reduce the itch. If unavailable, apply a tannic acid solution (boil acorns or oak bark in water) or crushed jewelweed.
4. Optionally, take antihistamine pills to reduce itching.

If you touched stinging nettle, apply mud to the area and remove it when it dries. You can also use tape to pull the small needles out.

Some plants, such as wild parsnip or giant hogweed, have compounds that react to sunlight and can cause a sunburn-like rash. Wash as you would with poison ivy and wear protective clothing to hide the area from sunlight.

Avoid scratching the rash, as it can cause infection. Leave blisters alone.

Seek medical attention if needed, especially if you got sap in your eyes or if blisters appear.

### Prevention
Learn to identify and avoid contact with the following plants:

- Cowhage
- Poison ivy
- Poison oak
- Poison sumac
- Rengas tree
- Trumpet vine
- Stinging nettle
- Gympie-gympie/stinging tree
- Wild parsnip
- Giant hogweed

Research and learn to identify other dangerous plants in your region.

If you come into contact with these plants, wash the area with soap and water as soon as possible. Do not wait for a rash to appear. Do not burn these plants, as the smoke can cause irritation.

## Sleeping
<!-- K: sleep, asleep, rest, nap -->
<!-- S: To fall asleep you should calm your mind, ensure you aren't too hot or cold, and use comfortable bedding. -->

Falling asleep can be difficult in the wilderness, but getting adequate rest is important for maintaining energy. To help yourself fall asleep, wind down at night by avoiding strenuous activity and calming your mind, perhaps using meditation. Ensure you aren't too hot or cold and that your sleeping area is comfortable. You might find it easier to sleep if you make a pillow by stuffing spare clothing or a stuff sack with dry leaves or other soft materials.

Some people may also find it necessary to block out noise using earplugs or by listening to music or white noise if available.

## Snow blindness
<!-- K: snow, blind, eye, headache, light, sensitivity, red, scratchy, itch, uv -->
<!-- S: Symptoms include red, scratchy, and watery eyes, sensitivity to light, and headache. Treat by covering your eyes with a dark cloth. Prevent by wearing UV-protective sunglasses or snow goggles. -->

Snow blindness is caused when too much sunlight reflects off snow, ice, or water into your eyes.

### Symptoms

- Eyes are red, scratchy, and watery
- Sensitivity to light
- Headache

### Treatment
Cover your eyes with a dark cloth until symptoms disappear.

### Prevention
Wear UV-protective sunglasses or snow goggles. If you do not have these, you can make snow goggles from a piece of cloth or a piece of bark with slits cut in it. You can also put soot under your eyes to reduce glare.

## Splinters, thorns, spines, and needles
<!-- K: splinter, thorn, wood, needle, spike, spine, remove, tweezers, hand, porcupine, urchin, cactus -->
<!-- S: Treat by removing the splinter with tweezers and cleaning the area. Prevent by using caution when handling dry wood or thorn bushes. -->

Splinters and thorns can be painful and may lead to infection if not removed.

### Treatment
If the splinter is deep or very large, seek medical attention and do not try to remove it yourself.

1. Inspect the splinter to see if any part is exposed and determine which direction it entered.
2. If no part is exposed, sterilize a needle with hand sanitizer or fire and gently dig at the skin to expose one end of the splinter.
3. Use tweezers to grab the exposed end of the splinter, preferably pulling in the opposite direction from how it entered.
4. Slowly pull the splinter out.
5. Repeat if any pieces remain.
6. If the splinter drew blood when removed, treat it as a cut. Applying antibiotic ointment and a bandage won't hurt.

Thorns, spines, and needles can be removed the same way as splinters. Some thorns may be easy to remove without tweezers.

For urchin spines, soak the area in hot (not scalding) water for 10 to 90 minutes before removal.

You should make sure your tetanus immunization is up to date for any puncture wounds.

### Prevention

- Use caution when handling dry wood or thorn bushes.
- Avoid walking through thorn bushes.
- Wear long sleeves and pants if going off-trail.
- Don't touch cacti or porcupines.
- Watch out for urchins if walking in the ocean.

## Sprains and strains
<!-- K: sprain, strain, tendon, ligament, muscle, pain, swell, bruise, move, spasm, cramp, weakness, pop, tear -->
<!-- S: Symptoms include pain, swelling, bruising, loss of motion, muscle spasms, cramping, and weakness. Treat by resting, icing, compressing, and elevating the area. Prevent this by doing warm-ups, wearing proper footwear, and watching your steps. -->

Sprains are injuries to a tendon or ligament, while strains are injuries to a muscle or tendon.

### Symptoms

- Pain
- Swelling
- Bruising
- Loss of functional movement
- Muscle spasms and cramping
- Muscle weakness
- A pop or tear may be heard or felt during injury

### Treatment

1. Rest the injured area.
2. Ice the area for 24 to 48 hours. You can improvise using a cloth soaked in cold water or filled with snow/ice.
3. Compress the area with a bandage or splint.
4. Elevate the area.

### Prevention

- Warm up before physical activity.
- Wear proper footwear.
- Do not overexert yourself.
- Watch your step.

## Submerged in water
<!-- K: water, drown, float, submerge, swim, current, rip, tide, snow, hypothermia, fall -->
<!-- S: If caught in a rip current, swim parallel to the shore until you are out. If you fall through the ice, kick with your legs to crawl back onto the ice, then treat for hypothermia. -->

### Falling through ice
<!-- K: ice, snow, hypothermia, fall -->

If you fall through the ice and are still at the surface of the water, do the following:

1. Turn back the way you came.
2. Kick your legs to push yourself onto the ice.
3. Roll away from the hole.
4. Crawl or slide on your stomach to safety.
5. Move to a safe, warm location as quickly as possible.
6. Get out of wet clothes and into dry clothes.
7. Use leaves or dry grass as insulation and warm up near a fire.

### Rip currents
<!-- K: rip, current, tide -->

If caught in a rip current, swim parallel to the shore until you are out of the current. Then, swim back to shore.

![](/assets/images/survival_guide/rip_current.webp)

## Sunburn
<!-- K: sunburn, burn, sunscreen, uv, sun, red, pain, swell, blister, spf, skin -->
<!-- S: Symptoms include redness, pain, swelling, and blisters. Treat by getting out of the sun, applying a burn cream, and taking pain relievers. Prevent this by wearing sunscreen, proper clothing, and staying in the shade. -->

Sunburn is caused by prolonged exposure to the sun's ultraviolet (UV) radiation.

### Symptoms

- Redness
- Pain
- Swelling
- Blisters

### Treatment

1. Get out of the sun.
2. Run cool water over the burn or apply a cold compress to relieve pain.
3. To reduce pain and swelling, apply aloe vera gel, calamine lotion, or hydrocortisone cream.
4. Optionally, take pain relievers.
5. Drink extra water.

Do not pop blisters.

### Prevention

- Wear sunscreen with an SPF of at least 30.
- Wear a hat.
- Wear long sleeves and pants.
- Stay in the shade.
- Take extra precautions on days with a high UV index.

## Craft: Sunglasses
<!-- K: sunglasses, uv, sun, protect, eyes, birch, cloth, slit, bark, craft -->
<!-- S: Craft sunglasses using a piece of cloth or birch bark with slits cut in it. -->

You can make sunglasses using a piece of cloth or birch bark with slits cut in it. This helps protect your eyes from UV rays and glare.

![](/assets/images/survival_guide/improvised_sunglasses.webp)

**Resources**

- Cloth or birch bark
- Cordage

**Instructions**

1. Trim a piece of cloth or birch bark large enough to cover your eyes.
2. Cut small rectangular slits over where your eyes will be. Don't cut the slits while wearing the mask.
3. Attach cordage to both ends of the mask and ensure it fits snugly on your face.

