The Packing Lists tool can be used to plan for a trip and remember to pack all the needed items.

## Creating a packing list
To create a new packing list:

1. Click the '+' button in the bottom-right corner.
2. Select 'New packing list'.
3. Enter a name for the packing list. 

## Copying a packing list
To copy an existing packing list:

1. Click the menu button on the right of an existing packing list.
2. Click "Copy".
3. Enter a name for the new packing list.
4. (Optional) Click the menu button on the top-right and click "Clear amounts" to reset the packed amounts.

## Adding items

With a packing list open, click the '+' button in the bottom-right corner. On the create item screen, fill out the fields as described below:

- **Name**: The name of the item
- **Packed amount**: The number of items currently packed, can be blank or a number (with decimal places)
- **Desired amount**: The number of items you would like to pack, can be blank or a number (with decimal places)
- **Category**: The category to group this item by, defaults to "Other"
- **Weight**: The weight of 1 item in your desired units. Trail Sense will scale this by the amount of packed items to determine the total weight.

When finished, click the check button in the bottom-right corner to save the item.

## Editing items

With a packing list open, click the item you want to edit. This will bring you to the same form described in the 'Adding Items' section. 

When finished, click the check button in the bottom-right corner to save the item.

## Marking items as packed
If you've packed an item, you can either edit it or click the checkbox next to it to mark it as packed. This will set the packed amount to the desired amount and update the weight (if applicable).

## Pack weight
If the items have weight associated with them, the total weight of the pack will be displayed at the top of the screen. The units of the total weight can be changed in Settings > Units > Weight.

## Sorting a packing list

Clicking the menu on the top-right of the packing list will allow you to sort your items.

- **Category**: This groups items by category and sorts them by name within the category.
- **Percent packed (low to high)**: Items which are unpacked show at the top, while packed items move to the bottom. Use this to more easily see what is left to pack.
- **Percent packed (high to low)**: Items which are packed show at the top, while unpacked items move to the bottom. Use this to more easily see what is already packed.
- **Weight (low to high)**: Items which take up less weight in your pack sort to the top.
- **Weight (high to low)**: Items which take up more weight in your pack sort to the top. Use this to see which items are weighing down your pack.

## Deleting a packing list

You can delete a packing list by clicking the menu button on the right of the packing list and clicking "Delete". This will permanently delete the packing list and all the items in it.

You can also delete from the packing list itself by clicking the menu button on the top-right and clicking "Delete".

## Renaming a packing list

You can rename a packing list by clicking the menu button on the right of the packing list and clicking "Rename". This will allow you to enter a new name for the packing list.

You can also rename from the packing list itself by clicking the menu button on the top-right and clicking "Rename".

## Clearing packed amounts

You can clear the packed amounts of all the items in a packing list by clicking the menu button on the right of the packing list and clicking "Clear amounts". This will set all the packed amounts to 0, but will not delete the items.

## Exporting a packing list
You can export a packing list by clicking the menu button on the right of the packing list and clicking "Export". This will prompt you to save a .csv file to your device. This file can be imported by Trail Sense or used in the 'LighterPack' website.

## Importing a packing list
You can import a packing list by clicking the '+' button in the bottom-right corner and clicking "Import packing list". This will prompt you to select a .csv file from your device. The csv file must be in the format exported by Trail Sense or LighterPack.

You will be prompted to enter a name for the newly imported packing list. If the list had previously packed amounts, they will be imported, but you can clear them by following the steps in the 'Clearing packed amounts' section.