The Clinometer tool measures angles and can be used to determine the slope of a hill, the height of an object, or the distance to an object. It can also be used to determine avalanche risk.

The following guide uses a tree as an example, but the same steps can be used for any object.

## Measure a slope
To measure a slope (or any angle), align the line in the center of the viewfinder with the top of the hill. Tapping anywhere on the screen will lock the clinometer, and tapping again will unlock it.

Alternatively, you can use the side of your phone to measure a slope. To do this, tap the screen icon in the top-left. Then hold your phone vertically and use the side (where the volume and power buttons are normally located) of your phone to sight. Look down the side of your phone and point it at the top of the hill. You will see the angle change at the top of the screen.

The slope percentage or grade is also shown under the angle.

If you would prefer to lock the angle using the volume buttons instead of tapping the screen, you can enable this in Settings > Clinometer > Lock with volume buttons.

The angle measurements will also be displayed on the camera viewfinder.

## Measuring avalanche risk
Most avalanches occur on slopes between 30° (57%) and 45° (100%). When you measure the angle of a slope, the avalanche risk will be displayed at the bottom of your screen. You can also use the color bands on the clinometer dial; red indicates high risk, yellow indicates moderate risk, and green indicates low risk.

## Estimate the height of a tree
The height of a tree can be measured if the distance to the tree is known.

1. Tap the ruler icon in the top-right.
2. Tap 'Height'.
3. Enter the distance to the tree.
4. Align the clinometer to the base of the tree.
5. Tap the screen and hold.
6. Realign the clinometer to the top of the tree.
7. Release to lock and see the height of the tree.

If you normally measure the height of trees at the same distance, you can set a default distance in Settings > Clinometer > Baseline distance.

## Estimate the distance to a tree (known height)
If you know the height of a tree, you can estimate the distance to it by using the clinometer.

1. Tap the ruler icon in the top-right.
2. Tap 'Distance'.
3. Enter the height of the tree.
4. Align the clinometer to the base of the tree.
5. Tap the screen and hold.
6. Realign the clinometer to the top of the tree.
7. Release to lock and see the distance to the tree.

## Estimate the distance to a tree (unknown height)
If you do not know the height of the tree, you can still estimate the distance to it by using your height as a reference.

1. Tap the ruler icon in the top-right.
2. Tap 'Distance'.
3. Enter your height.
4. Stand next to the tree and take note of where the top of your head is on the tree.
5. Walk away from the tree to the place where you want to measure the distance.
6. Align the clinometer to the base of the tree.
7. Tap the screen and hold.
8. Realign the clinometer to where the top of your head was on the tree.
9. Release to lock and see the distance to the tree.

## Disclaimer
Trail Sense uses a general rule of thumb to determine if a slope has avalanche potential, which is limited by your phone's sensors. If you think a slope is unsafe, then try to find an alternate route to avoid it or take precautions.