The Beacons tool can be used to save locations and navigate to them later.

## Creating a beacon
1. Tap the '+' button in the bottom-right corner of the screen.
2. Click 'Beacon'.
3. Enter a name for the beacon.
4. Enter a location for the beacon. You can tap the GPS icon next to the location field to use your current location.
5. Fill out any of the optional fields you want to record.
6. Click the checkmark button in the top-right corner of the screen.

### Optional fields
- **Elevation**: The elevation of the beacon. You can click the elevation icon next to the elevation field to use your current elevation.
- **Create at distance**: If you want to place a beacon at a known distance and direction from a location, you can toggle this on. You will then need to enter the distance away and set the direction to the new location before you can save the beacon. The new beacon will be placed at the distance and direction away from the location entered above.
- **Group**: The group to add the beacon to. Tap a group and click 'OK' to add the beacon to that group. To create a new group, see the 'Organizing beacons' section below.
- **Color**: The color to use for the beacon.
- **Icon**: The icon to use for the beacon.
- **Notes**: Any notes you want to record about the beacon.

### Creating from a QR code
Beacons can be shared as a QR code by clicking the menu button on the beacon row you want to share, then selecting 'Share...'. You can then share the QR code with Trail Sense to create a beacon from it.

1. Tap the '+' button in the bottom-right corner of the screen.
2. Click 'QR code'.
3. Scan the QR code you want to create a beacon from.
4. Follow the steps above to fill out the beacon information. Any information from the QR code will be prefilled.

### Creating from a GPX file
If you have locations saved in a GPX file, you can import them into Trail Sense as beacons.

1. Tap the '+' button in the bottom-right corner of the screen.
2. Click 'GPX file'.
3. Select the GPX file you want to load beacons from.
4. Confirm that you want to import the beacons by clicking 'OK'. You can uncheck any beacons you don't want to import.
5. The beacons will be created in the current group.

### Creating from OSM data
There are several online tools that can be used to query OpenStreetMap data and export it as a GPX file.

To use Overpass Turbo:

1. Open [Overpass Turbo](https://overpass-turbo.eu/).
2. Adjust the map to the area you want to query.
3. Enter the query. This will be filled in if you use one of the links below.
4. Click 'Run'.
5. Click 'Export' and select 'GPX'.
6. Save the GPX file to your device.
7. Follow the steps above to import the beacons.

- [**Peaks**](https://overpass-turbo.eu/s/1SVW): Query for mountain peaks. Change the 1000 in the query to the desired elevation in meters for minimum peak height.

## Viewing a beacon
Beacons will be shown in the beacon list and will display the distance to the beacon from your current location.

To open a beacon, click the beacon in the list. This will open the beacon details page. The following information will be shown:
- **Name**: The name of the beacon.
- **Location**: The location of the beacon.
- **Elevation**: The elevation of the beacon.
- **Distance**: The distance to the beacon from your current location.
- **Historic high/low temperature**: The historical average high and low temperature for the beacon's location. See the 'Climate' guide for more information.
- **Sunrise/sunset**: The sunrise and sunset times for the beacon's location.
- **Tide**: The estimated tide near the beacon's location.
- **Notes**: Any notes you recorded about the beacon.

## Navigate to a beacon
To navigate to a beacon, open the beacon you want to navigate to and click the 'Navigate' button at the bottom. This will open the navigation tool with the beacon as the destination. Alternatively, you can click the menu button on the beacon row you want to navigate to, then select 'Navigate'.

See the 'Navigation' guide for more information on how to use the navigation tool.

## Beacon visibility
You can choose which beacons are visible on the Navigation and Photo Maps tools by clicking the eye icon on the right side of the beacon row. This will toggle the visibility of the beacon.

## Share a beacon
You can share a beacon by clicking the menu button on the beacon row you want to share, then selecting 'Share...'. Alternatively, open the beacon and click the menu button in the top-right, then choose 'Share...'. You can choose from the following options:

- **Copy**: Copies the beacon details to your clipboard.
- **QR code**: Shares a QR code for the beacon.
- **Maps**: Shares the beacon to a maps application.
- **Send**: Shares the beacon details to another app as text.

## Edit a beacon
To edit a beacon, open the beacon and click the edit button at the bottom. Alternatively, click the menu button on the beacon row you want to edit, then select 'Edit'.

See the 'Creating a beacon' section above for information on the fields you can edit.

## Delete a beacon
To delete a beacon, click the menu button on the beacon row you want to remove, then select 'Delete'. Alternatively, open the beacon, click the menu button in the top-right, and choose 'Delete'.

## Exporting beacons
To export beacons, open the group you want to export and click the menu button in the top-right corner of the screen. Select 'Export', unselect any beacons you don't want to export, then click 'OK'. The beacons will be exported to a GPX file.

## Organizing beacons
You can organize beacons into groups. To create a group, click the '+' button in the bottom-right of the beacon list and select 'Group'. Give the group a name and click 'OK'. Click the group in the list to view the beacons in that group.

If you create a beacon or group while the group is open, the new beacon or group will be added to the currently open group.

To change the group of an existing beacon, click the menu button on the beacon row you want to move, select 'Move to', and choose the target group.

To rename a group, click the menu button on the group row you want to rename, then select 'Rename' and provide a new name.

You can delete a group (along with all beacons within it) by clicking the menu button on the group row you wish to remove, then selecting 'Delete'.

## Searching for beacons
To search through your created beacons, use the search bar at the top of the beacon list. This search encompasses the current group and all subgroups. Additionally, you can sort beacons by distance, time, or name by clicking the menu button in the top-right and selecting 'Sort'.

## Last cell signal beacon
If you have Backtrack enabled (see the 'Paths' guide) and it is configured to record cell signal, you will see a beacon created for the last known location where you had a cell signal.

You can disable this beacon in Settings > Paths > 'Last signal beacon'.

You can also choose to navigate to the nearest cell signal by clicking the menu button at the top-right of the beacon list and selecting 'Navigate to nearest cell signal'. This will start navigation to the nearest recorded location that has a cell signal.

## Quick action
You can enable the Create Beacon quick action in the settings for the desired tab.

To use the quick action, tap the Beacon quick action button to create a beacon at your current location. The title of the beacon will be set to the current date and time. Once created you will see a notification at the bottom of the screen with a button to view the beacon.

## Widgets
The following widgets can be placed on your device's homescreen or viewed in-app:

- **Nearby beacons**: Displays the beacons within 1 km (0.62 miles) of your location.