The Augmented Reality tool lets you see beacons and the paths of the sun and moon overlaid onto the real world.

## Camera
If you have camera permission granted, you will see a live camera feed in the background. If you do not have camera permission granted, you will see a black background instead.

You can toggle the camera on and off by tapping the camera icon in the top-right corner of the screen.

Additionally, while the camera is active, you can adjust the zoom level using two fingers to pinch or the slider at the bottom of the screen.

By default, the camera's exposure compensation will increase at night. You can disable this via "Settings > Augmented Reality > Increase exposure at night". 

## Reticle
A circular reticle is displayed in the center of your screen. You can use this to see more details about the marker you are looking at by centering it in the reticle.

## Beacons
Nearby beacons are displayed as markers on the screen. You can tap on a beacon to start navigation (See the Navigation section below). The view distance can be adjusted in Settings > Augmented Reality > Beacons > "View distance".

## Paths
Nearby paths are displayed below your feet. Due to GPS inaccuracy, the paths may not be perfectly aligned with the real world. The view distance can be adjusted in Settings > Augmented Reality > Paths > "View distance"

You can choose to adjust paths using their recorded elevation by enabling Settings > Augmented Reality > "Use path elevation". This should make the paths line up better with hills and valleys, but is dependent on the accuracy of the elevation data.

## Sun / moon
The paths that the sun and moon will take today are displayed as markers on the screen. The sun's path is displayed in yellow and the moon's path is displayed in white. A larger marker is displayed at the current time, and will also show the moon phase. Times in the past are lighter.

If you bring the sun or moon into the reticle, you will see more details about the marker such as the time.

If you tapped the "View in 3D" button on the Astronomy tool, you can use the guide to see where the sun or moon currently is and change the previewed date in the bottom panel.

## Stars
Bright stars, planets, and constellations are shown at night. If you bring a star into the reticle, you will see its name and the constellation(s) it belongs to. The star names are either the IAU proper names or the bayer designation. The constellations are from IAU.

You can turn off the stars and planets by disabling Settings > Augmented Reality > "Show stars and planets".

You can turn off the constellations by disabling Settings > Augmented Reality > "Show constellations".

## Grid / compass
A grid is displayed on the screen to help orient you. The grid is aligned with the cardinal directions and is spaced at 30 degrees. The grid line for north is highlighted in orange. The cardinal directions are displayed over the grid.

## Orientation
The orientation of your device is displayed at the top of the screen. This includes the compass bearing and the tilt angle. The Augmented Reality tool respects the true north setting found on Settings > Sensors > Compass > True north.

## Navigation
Tap on a beacon to navigate to it.

While navigating, you will see an arrow around the reticle pointing in the direction of the beacon. Move your phone toward the arrow to bring the beacon into view. When the beacon is in the reticle, the arrow will disappear.

## Calibration
If the Augmented Reality tool is not aligned with the real world, you can calibrate it by tapping the compass icon in the top-left corner of the screen. This will prompt you to center either the sun or moon in the reticle and click "Calibrate".

Always check the accuracy against the sun, moon, or known landmarks before using this tool. Depending on the quality of your phone's sensors, you may need to repeat calibration frequently.

You will not be able to calibration on a moonless night.

If your device has a gyroscope, calibrating will switch the tool to use the gyroscope for orientation. You can disable this in Settings > Augmented Reality > "Use gyroscope after calibration".

To reset the calibration, long press the compass icon or close and reopen the tool.

### Accuracy
The accuracy of the compass and GPS are shown in the bottom-left of the screen. You can tap the status icons to see more details about the accuracy and for further instructions on calibrating your compass.

## Sensors
The Augmented Reality tool respects the compass source in Settings > Sensors > Compass > Source. If your device does not have a gyroscope, the tool will still work but will not be as accurate and may jitter.

## Layers
You can toggle the visibility of the beacons, paths, astronomy, and grid layers by clicking the layer icon in the top-left corner of the screen or by changing the "Visible" setting in Settings > Augmented Reality.

The preview date for the astronomy layer can be adjusted in the layers menu on the Augmented Reality tool.