<!-- K: food, eat, meal, hunger, hungry -->
<!-- S: Ration food and forage when there's none left. -->

Food gives you energy but is a low priority in most survival situations since you can go weeks without it. If you haven't eaten in a while, focus on foraging for bugs, shellfish, and aggregate berries.

**This chapter is for informational purposes only and does not replace professional advice; use at your own risk and ensure compliance with local laws.**

## Be prepared
<!-- K: prepare, gear, knowledge, skill, nuts, seeds, dried, fruit, jerky, energy, bar, mre, can, knife, multitool, bag, canister, utensil, stove, fuel -->
<!-- S: Bring extra food. Learn how to find food and cook in the wilderness. -->

### Gear

**Necessities**:
- Food (enough for the duration of your trip, plus a bit extra). Don't bring food you have never eaten before. Some good options can include:
  - Nuts
  - Seeds
  - Dried fruit
  - Jerky
  - Energy bars
  - Dehydrated meals (with extra water)
  - Canned food (with a can opener if needed)
- Knife or multitool with a knife blade
- Bear bag or canister (for overnight stays)

**Optional**:
- Cooking pot or container
- Utensils (a spork is a good option)
- Cooking stove and fuel

### Knowledge and skills
Start by learning how to do the following:
- Plan your meals for a trip.
- Cook food by boiling or roasting over a fire.
- Use a bear bag or canister to protect your food.

Once you have mastered these skills, you should learn how to do the following:
- Identify edible plants and mushrooms.
- Find and catch insects, shellfish, crustaceans, fish, and other animals.
- Preserve food.
- Make traps.

## Food essentials
<!-- K: essential -->
<!-- S: You need around 2,000 calories daily, but you can ration your food to make it last longer. You should properly store your food to avoid spoilage. -->

### Caloric and nutritional needs
<!-- K: nutrition, caloric, calorie, carbohydrate, protein, fat, vitamin, mineral -->

The average person needs around 2,000 calories per day. Balance carbohydrates, proteins, fats, vitamins, and minerals in your diet.

- **Carbohydrates**: Provide an immediate source of energy and are found in grains, fruits, and vegetables. Aim for 45-65% of your daily caloric intake.
- **Fats**: Provide long-term energy and are used in essential bodily functions. They are found in meats, oils, nuts, and seeds. Aim for 20-35% of your daily caloric intake.
- **Proteins**: Build and repair tissues and are found in meats, legumes, nuts, and seeds.
- **Vitamins and minerals**: Essential for overall health and are found in most foods, but a varied diet is necessary to ensure you get all the essential nutrients.

### Storage
<!-- K: storage, spoil, contamination, airtight, zipper, bag -->

Food should be stored in airtight containers to prevent spoilage and contamination. Do not pack foods that spoil quickly or require refrigeration. If you bring zipper storage bags, you can also use them for water procurement.

### Rationing
<!-- K: ration -->

If you are in a survival situation, ration your food to make it last longer. Eat two-thirds of your food in the first half of your survival situation (about 2-3 days after your expected return date) and the remaining third in the following days. Eating food will give you the energy to construct a shelter and plan.

### Starvation
<!-- K: starvation -->

Starvation occurs when the body does not receive enough nutrients to function correctly. Symptoms include loss of body fat, difficulty breathing, feeling colder, fatigue, and increased healing times. You are not likely to experience this unless you are going more than a week or two without food.

## Plants and mushrooms
<!-- K: plant, mushroom, seaweed, weeds, green, fungus, berries -->
<!-- S: Only eat plants you can confidently identify as safe, and don't eat mushrooms. Aggregate berries, like raspberries and blackberries, are generally safe. -->

Plants typically contain fewer calories than animals but can be easier to obtain if you can identify them. If you can't identify which plants are safe, just focus on bugs and shellfish. You should also avoid mushrooms unless you are experienced in foraging, since many can make you sick. Familiarize yourself with local plants and mushrooms before your trip.

### Foraging
<!-- K: forage, identify, edible, inedible, poison, toxic, sap, safe -->

The safest plants to forage are aggregate berries, such as raspberries and blackberries, since they have a distinctive look and are generally edible. Nuts and seeds are higher in calories than leafy greens, but some nuts, such as acorns, require multiple rounds of boiling to remove bitterness. Also, just because you see an animal eating a plant doesn't mean it is safe for human consumption. Never eat a plant you aren't certain is edible; even if you are certain, only eat a small amount and be on the lookout for side effects.

Here's an example of what an aggregate berry looks like (brambles):

![](file:///android_asset/field_guide/brambles.webp)

**The following should be avoided as the risk isn't worth the calories:**
- Mushrooms
- Plants that have:
  - Umbrella-shaped flowers
  - Milky sap
  - Shiny leaves
  - White, yellow, or red berries (except aggregate berries)
  - Beans, bulbs, or seeds inside pods
  - Pungent odor
  - An almond/cyanide scent in the leaves or wood
  - Bitter or soapy taste
  - Thorns, hairs, or spines
  - A three-leaved growth pattern
  - Mildew or fungus
- Plants that look like dill, carrot, parsnip, or parsley
- Spoiled plants/mushrooms/seaweed
- Anything growing alongside a road or in dirty water

### Preparation
<!-- K: leach, wash, cook, boil, prepare -->

All plants you gather should be washed and cooked. Many can be eaten raw, but if you have the means to cook them, it will be safer to avoid the risk of contamination.

## Insects
<!-- K: insect, bug, grub, worm, ant, termite, locust, grasshopper, cricket, dragonfly, bait -->
<!-- S: Most insects can be eaten when cooked or used as fishing bait. -->

Insects are a good source of protein but need to be gathered in large numbers to provide a substantial meal. If you don't want to eat insects, you can use them as bait for fishing or trapping.

### Collection
<!-- K: gather, find -->

Good places to find insects include rotting logs, under rocks, and in grassy fields. If you are looking for earthworms, you can use a stick to dig small holes in the ground, check the surface after rain or at night, or clear the leaf litter out of an area. At night, many flying insects can be attracted to a light source. Common edible bugs include ants, termites, locusts, grasshoppers, crickets, dragonflies, grubs, and worms.

Do not eat the following:
- Biting or stinging insects
- Hairy or brightly colored insects
- Insects with a pungent odor
- Hairy caterpillars
- Spiders
- Anything that feeds on blood, such as ticks, flies, and mosquitoes

### Preparation
<!-- K: prepare, cook, boil, roast, bake -->

To prepare bugs for cooking, remove any stingers and, optionally, the legs, wings, and head before eating. You should cook all bugs before eating them to be on the safe side, but in a pinch many can be eaten raw. Worms can be placed in water for 15 minutes to purge their digestive tracts before cooking. If you can't bring yourself to eat a worm, try completely drying it in the sun or roasting it and then grinding it into a powder.

## Shellfish and crustaceans
<!-- K: shellfish, crustacean, clam, mussel, snail, limpet, crayfish, lobster, crab, shrimp, shell, bait, seafood -->
<!-- S: Many shellfish and crustaceans are found along the shoreline; most can be eaten when cooked. -->

Shellfish and crustaceans are good sources of protein and can be found in both freshwater and saltwater. They are relatively easy to catch, making them good survival food sources.

### Collection
<!-- K: gather, find, trap, red, tide -->

Search shallow waters, tide pools, and rocky areas for shellfish and crustaceans. Snails and limpets are often attached to rocks, which may be easier to access during low tide. Crayfish, lobsters, and crabs can be found under and around stones, in soft mud or sand, and may be more active at night. Crustaceans can be caught by attaching bait onto a line (no hook required; they'll grab it), baiting the shoreline and waiting for them to leave the water, or using a fish trap with bait.

Some shellfish may be poisonous. Be especially cautious of mussels in tropical waters during the summer, any shellfish within three days of a red tide, or shellfish not covered by water during high tide.

### Preparation
<!-- K: prepare, cook, boil, roast, bake -->

You should cook all shellfish and crustaceans before eating. You can cook them in their shells. For crustaceans, remove the digestive tract (gray/green), gills (gray, feathery), and hard shells before eating.

## Fish
<!-- K: fish, seafood -->
<!-- S: Most fish are edible once cooked but will require some fishing gear. -->

If you are in a longer-term survival situation or have access to fishing gear, fish can be a good source of protein and nutrients. Most fish are edible, but research which fish may be dangerous in your area.

### Fishing
<!-- K: fish, hook, line, pole, bait, basket, bottle, trap, funnel, gather -->

Fish are most active before a storm, near rocks or logs, and under overhanging brush. In hot weather, fish tend to be in shaded or deep water, while in cold weather, they prefer shallow and sunny areas. In rivers, look for areas where the water is slow or still. The best time of day varies by species, so you may have better luck fishing at multiple points during the day. Many fish are more active around dusk and dawn.

**Hook and line**

Fishing with a hook and line is likely your most familiar technique. You will need to secure a hook onto a line and optionally tie it to a pole. You can use the following knot to tie the hook to the line. Use a wet finger to help tighten it to the hook.

![](file:///android_asset/survival_guide/knot_fishermans.webp)

Hooks with barbs are usually more effective than barbless hooks at keeping fish on the line. For best results, bait the hooks using insects, worms, or pieces of food. Make sure that any bait on the hook is securely attached; if using a worm, thread the hook through the worm's body.

If you need to craft a hook, go with a gorge hook since it is easy to make and doesn't need to be set manually. Fish caught with a gorge hook are more likely to die if released, so it should only be considered in a true survival situation (many places ban gorge hooks). To carve a gorge hook, sharpen both sides of a small section of wood or bone and taper it at the center. Place the hook into the bait.

![](file:///android_asset/survival_guide/gorge_hook.webp)

If you do not have fishing line, you can make it from plant fibers, inner strands of paracord (using a bend knot to join them together), or other strong cordage.

If you do not have a fishing pole, you can tie the line to both the base and tip of a sturdy stick-try to mimic what an actual fishing pole looks like. You can also wrap the line around a short stick and use it as a hand line. An easier technique may be to tie the line to a tree branch so you can do other things and check it frequently.

**Traps**

Traps are a passive way to catch small fish or crustaceans with little effort required. Be sure to check your traps every few hours.

You can construct a bottle fish trap by cutting off the cap and top quarter of a spare water bottle. Bait the trap with food and use a small rock to weigh it down. Place the top inverted into the rest of the bottle and place it in shallow water. If needed, you can tie a string to the bottle to allow for easy access.

![](file:///android_asset/survival_guide/fish_trap_bottle.webp)

Alternatively, you can construct an M-shaped funnel trap by hammering sticks into the bottom of the stream or other shallow water to form a small entrance and walls. This can be built using the shore as a back wall to reduce effort. Small fish will swim into the trap and be unable to find their way out.

![](file:///android_asset/survival_guide/fish_trap_funnel.webp)

### Preparation
<!-- K: prepare, kill, clean, gut, fillet, cook, boil, roast, bake -->

1. Once you catch a fish, bring it away from the shoreline. Do not hold or place it near the water before killing it, as it may flop back in.
2. Stun the fish by hitting it hard on the head (top of the head, right behind the eyes) with a club or rock. Then use a knife to cut the gills or pierce the brain to ensure it is dead.
3. (Optional) Remove scales by scraping them off with a knife (tail to head).
4. Cut open the belly and remove the entrails. You can also cut off the head and tail to make this easier.
5. (Optional) Cut the fish into usable pieces or fillet it.
6. Cook the fish.

<!-- \pagebreak -->

Cutting pattern to remove entrails (red line):

![](file:///android_asset/survival_guide/prepare_fish.webp)

## Other animals
<!-- K: animal, hunt, kill -->
<!-- S: Hunting or trapping can be energy-consuming and difficult without proper tools. -->

In a survival situation, it's best to focus on easier-to-catch animals like insects, shellfish, crustaceans, and fish. But if you have the means to catch other animals, they can provide a good source of protein and nutrients. Unless you are a hunter with proper gear, do not try to hunt large animals.

### Hunting
<!-- K: spear, club, throwing-stick, rock -->

**Clubs**

A club can be as simple as a stick with a heavy end. This can kill or stun fish or other small animals with a quick, forceful blow to the head.

**Spears**

A spear can be made by sharpening a stick. Unless you have experience, it's best to stab with the spear rather than throw it. To make it easier to hit your target, you can construct multiple spear points using a forked branch.

**Throwing sticks and rocks**

In a pinch, you can throw a heavy stick or rock to kill or stun small animals. Aim for the head to ensure a quick kill.

### Trapping
<!-- K: trap, deadfall, bait -->

Traps allow for the passive capture of small animals. They can be set up and left alone while you perform other tasks. Check them every few hours. Look for signs of animal activity like tracks, droppings, or chewed vegetation. Set up traps in areas where animals are likely to pass through. You can construct funnels or walls to guide animals into them. Baiting the traps can increase their effectiveness. Smoking the traps can help mask your scent.

**Deadfalls**

Deadfall traps work by dropping a heavy object on the animal when it triggers the trap. The trigger is released when the animal takes the bait, causing the heavy object to fall. Place one or more of these traps near your shelter to catch mice.

To avoid getting injured while setting the trap, support the rock/log using your knee or free hand until the trap is set. Be ready to quickly pull your hand away if it begins to fall.

![](file:///android_asset/survival_guide/figure_4_trap.webp)

1. Support stick (front/side)
2. Release stick (front/side)
3. Bait stick (front/side)
4. Bait
5. Rock

### Birds
<!-- K: bird, pluck, skin, prepare, cook, clean, boil, bake, roast -->

Birds are most easily caught at night when roosting, or you can eat eggs from nests. Use a club, throwing stick, or rock to kill or stun the bird.

To prepare a bird for cooking:

1. Pluck feathers. To make this easier, place the bird in boiling water. Optionally, you can skin the bird, but that removes some fat.
2. Cut open the body cavity and remove the entrails.
3. For larger birds, cut off the feet and separate the bird into usable pieces along the joints.
4. Cook the bird.

If you catch a seabird, skin it instead of plucking the feathers to remove the oil glands. If you catch a scavenger bird like a vulture, boil it for at least 20 minutes to kill parasites.

### Reptiles and amphibians
<!-- K: reptile, amphibian, frog, snake, turtle, lizard, skin, prepare, cook, clean, boil, bake, roast -->

Reptiles and amphibians are easier to catch than mammals and birds. Many can be found basking in open ground, on logs, or at the water's edge. Use a multi-pointed spear or pin them down with a stick behind the head.

Always wash your hands after handling reptiles and amphibians, as they can carry salmonella. Cook the meat thoroughly.

**Do not eat the following**:
- Box turtles
- Hawksbill turtles
- Brightly colored frogs
- Frogs with an X on their back
- Tree frogs
- Toads
- Salamanders
- Snakes: they are edible but may be dangerous to catch
  - If you kill a snake, cut off and bury its head before cleaning. Never touch the head with your hands; use sticks instead.

### Small mammals
<!-- K: mammal, rodent, rabbit, hare, squirrel, raccoon, mouse, small, skin, prepare, cook, clean, boil, bake, roast -->

Small mammals can be caught using traps, clubs, throwing sticks, or rocks.

To prepare a small mammal for cooking:

1. Make a cut on the back and pull the fur and skin off. You may need to sever the head and feet.
2. Flip it over and cut open the abdominal cavity and remove the entrails. Be careful not to puncture the intestines.

![](file:///android_asset/survival_guide/skin_mammal.webp)

This guide does not cover the preparation of large mammals, as they are challenging to catch and require a lot of energy to process.

## Cooking
<!-- K: cook -->
<!-- S: To avoid getting sick, boil, roast, or bake most foods. This will require you to start a fire or have a portable stove. -->

Do not try to preserve the food you catch; just cook and eat it. If possible, prepare, cook, and consume your food some distance downwind of your shelter to avoid attracting animals to your camp.

### Boiling
<!-- K: boil, container -->

Boiling preserves the most nutrients in food and is the safest cooking method. A metal container filled with water can be suspended over a fire or placed onto hot coals. Drinking the broth once it is cool enough will give you more nutrients. See the Water chapter for more information on boiling.

### Roasting
<!-- K: roast -->

Roasting is a quick and easy cooking method, but the food is less nutritious than other methods. You can roast food on a stick over a fire or place it over hot coals or on dry rocks heated by the fire.

### Baking
<!-- K: bake -->

You can wrap food in green, edible leaves or clay and place it in the coals of a fire to bake it. This method is slower than roasting but preserves more nutrients. Do not skin fish or birds packed with clay; the skin will stick to the clay and can be removed after cooking.

### Utensils
<!-- K: utensil -->

If you are packing utensils, a spork is a good option. Otherwise, you can handle food with a stick or your hands. Be sure to wash your hands before and after eating.

## Protection
<!-- K: protect, animal -->
<!-- S: Use bear bags or canisters to prevent animals from stealing your food. -->

You may need to protect your food from animals. Here are some methods to keep your food safe:

### Bear bags
<!-- K: bag, bear -->

A bear bag is a bag of food hoisted into a tree to keep it out of reach of bears and other animals. Find a tree with a branch about 20 feet (6 meters) off the ground and thick enough to support the weight of your food at about 10 feet (3 meters) from the trunk. This tree should be 20-70 yards/meters downwind from your shelter.

1. Place food in a bag.
2. Tie a rope to the bag.
3. Throw the other end of the rope over a branch. To give the line weight, attach a short stick to the end of it. Secure the stick with a clove hitch or jam knot.
4. Hoist the bag about 15 feet (4.5 meters) above the ground.
5. Tie the rope to a tree to keep the bag elevated. Use either a hitch or bowline knot.

![](file:///android_asset/survival_guide/bear_bag.webp)

See the Shelter chapter for details on how to tie knots.

### Bear canisters
<!-- K: canister, box, bear -->

A bear canister is a rigid plastic container used to store food. It is bear-proof and can be left on the ground. Some campsites may provide a large metal bear box for storing food.

Ideally, the location where you leave this container should be 20–70 yards/meters downwind from your shelter. You may find tooth or claw marks on the canister in the morning, and it may be some distance from where you left it. Using brightly colored stickers on the outside may help you find it.
