package com.kylecorry.trail_sense.tools.weather.ui.fields

import android.content.Context
import com.kylecorry.andromeda.core.system.Resources
import com.kylecorry.andromeda.views.list.ListItem
import com.kylecorry.andromeda.views.list.ResourceListIcon
import com.kylecorry.sol.units.Temperature
import com.kylecorry.trail_sense.R
import com.kylecorry.trail_sense.shared.FormatService
import com.kylecorry.trail_sense.shared.UserPreferences
import com.kylecorry.trail_sense.shared.colors.AppColor
import com.kylecorry.trail_sense.shared.sensors.thermometer.ThermometerSource
import com.kylecorry.trail_sense.tools.weather.infrastructure.subsystem.WeatherSubsystem

// TODO: Build chart into this
class TemperatureWeatherField(
    private val temperature: Temperature?,
    private val onClick: () -> Unit
) : WeatherField {
    override fun getListItem(context: Context): ListItem? {
        temperature ?: return null
        val formatter = FormatService.getInstance(context)
        val prefs = UserPreferences(context)
        val units = prefs.temperatureUnits
        val source = prefs.thermometer.source
        val value = formatter.formatTemperature(
            temperature.convertTo(units)
        )

        val color = when {
            temperature.value <= WeatherSubsystem.COLD -> {
                AppColor.Blue.color
            }
            temperature.value >= WeatherSubsystem.HOT -> {
                AppColor.Red.color
            }
            else -> {
                Resources.androidTextColorSecondary(context)
            }
        }

        return ListItem(
            5,
            context.getString(R.string.temperature),
            subtitle = when (source) {
                ThermometerSource.Historic -> context.getString(R.string.historic_temperature_years, 30)
                ThermometerSource.Sensor -> context.getString(R.string.sensor)
            },
            icon = ResourceListIcon(R.drawable.thermometer, color),
            trailingText = value
        ) {
            onClick()
        }
    }
}