package com.kylecorry.trail_sense.tools.navigation.ui.layers.compass

import com.kylecorry.andromeda.canvas.ICanvasDrawer
import com.kylecorry.trail_sense.tools.navigation.ui.IMappableReferencePoint

open class MarkerCompassLayer : ICompassLayer {

    private val markers = mutableListOf<Pair<IMappableReferencePoint, Int?>>()
    private val lock = Any()

    fun setMarkers(markers: List<IMappableReferencePoint>) {
        synchronized(lock) {
            this.markers.clear()
            this.markers.addAll(markers.map { it to null })
        }
    }

    fun addMarker(marker: IMappableReferencePoint, size: Int? = null) {
        synchronized(lock) {
            markers.add(marker to size)
        }
    }

    fun clearMarkers() {
        synchronized(lock) {
            markers.clear()
        }
    }

    override fun draw(drawer: ICanvasDrawer, compass: ICompassView) {
        val markers = synchronized(lock) {
            markers.toList()
        }
        markers.forEach {
            compass.draw(it.first, it.second)
        }
    }

    override fun invalidate() {

    }
}