import java.time.LocalDate

plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
    id("com.google.devtools.ksp")
    id("kotlin-parcelize")
}

android {
    namespace = "com.kylecorry.trail_sense"
    compileSdk = 36

    defaultConfig {
        vectorDrawables.useSupportLibrary = true
        applicationId = "com.kylecorry.trail_sense"
        minSdk = 23
        targetSdk = 36
        versionCode = 136
        versionName = "7.3.0"
        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }
    androidResources {
        // Support for auto-generated locales for per-app language settings
        generateLocaleConfig = true
    }
    buildFeatures {
        // Support for view binding
        viewBinding = true
        buildConfig = true
    }
    buildTypes {
        // ------- RELEASES -------
        // F-Droid
        getByName("release") {
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
        // Play Store
        create("playStore"){
            initWith(getByName("release"))
        }
        // GitHub
        create("github") {
            initWith(getByName("release"))
        }

        // ------- DEVELOPMENT -------
        // Local debug
        getByName("debug"){
            testProguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
        // Staging
        create("staging") {
            initWith(getByName("release"))
            applicationIdSuffix = ".staging"
            versionNameSuffix = "-staging"
        }

        // ------- NIGHTLY -------

        // Debug
        create("nightly") {
            initWith(getByName("debug"))
            applicationIdSuffix = ".nightly"
            versionNameSuffix = "-nightly-${LocalDate.now()}"
        }
        // Release
        create("nightlyRelease") {
            initWith(getByName("release"))
            applicationIdSuffix = ".nightly_release"
            versionNameSuffix = "-nightly-release-${LocalDate.now()}"
        }

        // ------- DEPRECATED -------

        // Legacy debug build for GitHub
        create("dev") {
            initWith(getByName("debug"))
            applicationIdSuffix = ".dev"
            versionNameSuffix = "-dev"
        }
        // Legacy release build for GitHub
        create("legacyGithub") {
            initWith(getByName("release"))
            applicationIdSuffix = ".github"
            versionNameSuffix = "-github"
        }
    }
    testOptions {
        unitTests.all {
            it.useJUnitPlatform()
        }
    }
    compileOptions {
        isCoreLibraryDesugaringEnabled = true
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }
    packaging {
        resources.merges += "META-INF/LICENSE.md"
        resources.merges += "META-INF/LICENSE-notice.md"
        jniLibs {
            useLegacyPackaging = true
        }
    }
    kotlinOptions {
        jvmTarget = JavaVersion.VERSION_11.toString()
    }

    lint {
        abortOnError = false
    }
}

dependencies {
    // Kotlin
    implementation(libs.kotlinx.coroutines.android)
    coreLibraryDesugaring(libs.desugar.jdk.libs)

    // AndroidX
    implementation(libs.constraintlayout)
    implementation(libs.appcompat)
    implementation(libs.core.ktx)
    implementation(libs.gridlayout)
    implementation(libs.preference.ktx)
    implementation(libs.work.runtime.ktx)
    implementation(libs.navigation.fragment.ktx)
    implementation(libs.navigation.ui.ktx)
    implementation(libs.legacy.support.v4)
    ksp(libs.room.compiler)
    implementation(libs.room.runtime)
    implementation(libs.room.ktx)
    implementation(libs.lifecycle.service)
    implementation(libs.lifecycle.viewmodel.ktx)
    implementation(libs.camera.camera2)
    implementation(libs.camera.lifecycle)
    implementation(libs.camera.view)
    implementation(libs.androidx.core.remoteviews)
    implementation(libs.androidx.exifinterface)

    // Material
    implementation(libs.material)
    implementation(libs.flexbox)

    // Andromeda
    implementation(libs.andromeda.core)
    implementation(libs.andromeda.fragments)
    implementation(libs.andromeda.forms)
    implementation(libs.andromeda.csv)
    implementation(libs.andromeda.background)
    implementation(libs.andromeda.camera)
    implementation(libs.andromeda.gpx)
    implementation(libs.andromeda.sound)
    implementation(libs.andromeda.sense)
    implementation(libs.andromeda.signal)
    implementation(libs.andromeda.preferences)
    implementation(libs.andromeda.permissions)
    implementation(libs.andromeda.canvas)
    implementation(libs.andromeda.files)
    implementation(libs.andromeda.notify)
    implementation(libs.andromeda.alerts)
    implementation(libs.andromeda.pickers)
    implementation(libs.andromeda.list)
    implementation(libs.andromeda.qr)
    implementation(libs.andromeda.markdown)
    implementation(libs.andromeda.camera)
    implementation(libs.andromeda.clipboard)
    implementation(libs.andromeda.haptics)
    implementation(libs.andromeda.bitmaps)
    implementation(libs.andromeda.torch)
    implementation(libs.andromeda.battery)
    implementation(libs.andromeda.compression)
    implementation(libs.andromeda.pdf)
    implementation(libs.andromeda.exceptions)
    implementation(libs.andromeda.print)
    implementation(libs.andromeda.list)
    implementation(libs.andromeda.views)
    implementation(libs.andromeda.xml)
    implementation(libs.andromeda.json)
    implementation(libs.andromeda.widgets)
    implementation(libs.andromeda.ipc)

    // Misc
    implementation(libs.sol)
    implementation(libs.luna)

    // Testing
    testImplementation(libs.junit)
    androidTestImplementation(libs.ext.junit)
    androidTestImplementation(libs.androidx.test.core)
    androidTestImplementation(libs.androidx.test.runner)
    androidTestImplementation(libs.androidx.test.rules)
    androidTestImplementation(libs.androidx.test.uiautomator)
    androidTestImplementation(libs.androidx.fragment.testing)
    androidTestImplementation(libs.androidx.test.arch.core)
    androidTestImplementation(libs.work.testing)
    debugImplementation(libs.androidx.fragment.testing.manifest)
    testImplementation(libs.junit.platform.runner)
    testImplementation(libs.junit.jupiter.api)
    testImplementation(libs.junit.jupiter.params)
    testRuntimeOnly(libs.junit.jupiter.engine)
    testImplementation(libs.mockito.kotlin)
}
