import 'package:app_theme/app_theme.dart';
import 'package:flutter/material.dart';

class UiTooltip extends StatelessWidget {
  const UiTooltip({
    required this.message,
    required this.child,
    super.key,
  });

  final String message;
  final Widget child;

  @override
  Widget build(BuildContext context) {
    return Tooltip(
      message: message,
      preferBelow: false,
      decoration: BoxDecoration(
        color: theme.currentGlobal.colorScheme.surface,
        boxShadow: const [
          BoxShadow(
            color: Colors.black12,
            blurRadius: 5,
            spreadRadius: 1,
            offset: Offset(0, 2),
          ),
        ],
      ),
      textStyle: TextStyle(
        color: Theme.of(context).colorScheme.onSurface,
        fontSize: Theme.of(context).textTheme.bodySmall?.fontSize,
      ),
      child: child,
    );
  }
}
