/// WebDex UI Kit
library komodo_ui_kit;

// UI components

// Buttons
// This category includes various button widgets used throughout the UI,
// providing different styles and functionalities.
export 'src/buttons/hyperlink.dart';
export 'src/buttons/language_switcher/language_switcher.dart';
export 'src/buttons/multiselect_dropdown/filter_container.dart';
export 'src/buttons/multiselect_dropdown/multiselect_dropdown.dart';
export 'src/buttons/text_dropdown_button.dart';
export 'src/buttons/theme_switcher/theme_switcher.dart';
export 'src/buttons/ui_action_text_button.dart';
export 'src/buttons/ui_border_button.dart';
export 'src/buttons/ui_checkbox.dart';
export 'src/buttons/ui_dropdown.dart';
export 'src/buttons/ui_gradient_button.dart';
export 'src/buttons/ui_primary_button.dart';
export 'src/buttons/ui_secondary_button.dart';
export 'src/buttons/ui_simple_button.dart';
export 'src/buttons/ui_sort_list_button.dart';
export 'src/buttons/ui_switcher.dart';
export 'src/buttons/ui_underline_text_button.dart';
export 'src/buttons/upload_button.dart';
// Containers
// Container widgets for organizing and displaying other widgets.
export 'src/containers/chart_tooltip_container.dart';
export 'src/containers/gradient_container.dart';
// Controls
// Widgets that handle user interaction and control other parts of the UI.
export 'src/controls/market_chart_header_controls.dart';
export 'src/controls/selected_coin_graph_control.dart'; // New control widget
// Fonts
export 'src/custom_icons/custom_icons.dart';
// Display
// Widgets primarily focused on displaying data and information.
export 'src/display/auto_scroll_text.dart';
export 'src/display/statistic_card.dart';
// Dividers
// Widgets for dividing content or adding scrollbars.
export 'src/dividers/ui_divider.dart';
export 'src/dividers/ui_scrollbar.dart';
// Inputs
// Widgets related to data input and selection, including text fields and selectors.
export 'src/inputs/input_validation_mode.dart';
export 'src/inputs/percentage_input.dart';
export 'src/inputs/percentage_range_slider.dart';
export 'src/inputs/range_slider_labelled.dart';
export 'src/inputs/time_period_selector.dart';
export 'src/inputs/ui_date_selector.dart';
export 'src/inputs/ui_text_form_field.dart';
// Painters
// Custom painters used to decorate or add effects to other widgets.
export 'src/painter/focus_decorator.dart';
// Skeleton loaders
// Widgets for displaying skeleton loaders, used to indicate loading states.
export 'src/skeleton_loaders/skeleton_loader_list_tile.dart';
// Tables
export 'src/tables/ui_table.dart';
// Themes
// Themed widgets such as spinners and loaders to indicate progress or loading states.
export 'src/tips/ui_spinner.dart';
export 'src/tips/ui_spinner_list.dart';
// Tooltips
// Widgets for displaying tooltips, providing additional context or information.
export 'src/tips/ui_tooltip.dart';
// Utils
// Utility widgets providing small but useful functions like spacing.
export 'src/utils/gap.dart'; // New utility widget
